// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/model_garden_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelGardenService_GetPublisherModel_FullMethodName = "/google.cloud.aiplatform.v1.ModelGardenService/GetPublisherModel"
	ModelGardenService_Deploy_FullMethodName            = "/google.cloud.aiplatform.v1.ModelGardenService/Deploy"
)

// ModelGardenServiceClient is the client API for ModelGardenService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelGardenServiceClient interface {
	// Gets a Model Garden publisher model.
	GetPublisherModel(ctx context.Context, in *GetPublisherModelRequest, opts ...grpc.CallOption) (*PublisherModel, error)
	// Deploys a model to a new endpoint.
	Deploy(ctx context.Context, in *DeployRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type modelGardenServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelGardenServiceClient(cc grpc.ClientConnInterface) ModelGardenServiceClient {
	return &modelGardenServiceClient{cc}
}

func (c *modelGardenServiceClient) GetPublisherModel(ctx context.Context, in *GetPublisherModelRequest, opts ...grpc.CallOption) (*PublisherModel, error) {
	out := new(PublisherModel)
	err := c.cc.Invoke(ctx, ModelGardenService_GetPublisherModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelGardenServiceClient) Deploy(ctx context.Context, in *DeployRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelGardenService_Deploy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelGardenServiceServer is the server API for ModelGardenService service.
// All implementations should embed UnimplementedModelGardenServiceServer
// for forward compatibility
type ModelGardenServiceServer interface {
	// Gets a Model Garden publisher model.
	GetPublisherModel(context.Context, *GetPublisherModelRequest) (*PublisherModel, error)
	// Deploys a model to a new endpoint.
	Deploy(context.Context, *DeployRequest) (*longrunningpb.Operation, error)
}

// UnimplementedModelGardenServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelGardenServiceServer struct {
}

func (UnimplementedModelGardenServiceServer) GetPublisherModel(context.Context, *GetPublisherModelRequest) (*PublisherModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublisherModel not implemented")
}
func (UnimplementedModelGardenServiceServer) Deploy(context.Context, *DeployRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deploy not implemented")
}

// UnsafeModelGardenServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelGardenServiceServer will
// result in compilation errors.
type UnsafeModelGardenServiceServer interface {
	mustEmbedUnimplementedModelGardenServiceServer()
}

func RegisterModelGardenServiceServer(s grpc.ServiceRegistrar, srv ModelGardenServiceServer) {
	s.RegisterService(&ModelGardenService_ServiceDesc, srv)
}

func _ModelGardenService_GetPublisherModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublisherModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).GetPublisherModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_GetPublisherModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).GetPublisherModel(ctx, req.(*GetPublisherModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelGardenService_Deploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelGardenServiceServer).Deploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelGardenService_Deploy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelGardenServiceServer).Deploy(ctx, req.(*DeployRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelGardenService_ServiceDesc is the grpc.ServiceDesc for ModelGardenService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelGardenService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.ModelGardenService",
	HandlerType: (*ModelGardenServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPublisherModel",
			Handler:    _ModelGardenService_GetPublisherModel_Handler,
		},
		{
			MethodName: "Deploy",
			Handler:    _ModelGardenService_Deploy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/model_garden_service.proto",
}
