// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported adapter sizes for tuning.
type SupervisedHyperParameters_AdapterSize int32

const (
	// Adapter size is unspecified.
	SupervisedHyperParameters_ADAPTER_SIZE_UNSPECIFIED SupervisedHyperParameters_AdapterSize = 0
	// Adapter size 1.
	SupervisedHyperParameters_ADAPTER_SIZE_ONE SupervisedHyperParameters_AdapterSize = 1
	// Adapter size 2.
	SupervisedHyperParameters_ADAPTER_SIZE_TWO SupervisedHyperParameters_AdapterSize = 6
	// Adapter size 4.
	SupervisedHyperParameters_ADAPTER_SIZE_FOUR SupervisedHyperParameters_AdapterSize = 2
	// Adapter size 8.
	SupervisedHyperParameters_ADAPTER_SIZE_EIGHT SupervisedHyperParameters_AdapterSize = 3
	// Adapter size 16.
	SupervisedHyperParameters_ADAPTER_SIZE_SIXTEEN SupervisedHyperParameters_AdapterSize = 4
	// Adapter size 32.
	SupervisedHyperParameters_ADAPTER_SIZE_THIRTY_TWO SupervisedHyperParameters_AdapterSize = 5
)

// Enum value maps for SupervisedHyperParameters_AdapterSize.
var (
	SupervisedHyperParameters_AdapterSize_name = map[int32]string{
		0: "ADAPTER_SIZE_UNSPECIFIED",
		1: "ADAPTER_SIZE_ONE",
		6: "ADAPTER_SIZE_TWO",
		2: "ADAPTER_SIZE_FOUR",
		3: "ADAPTER_SIZE_EIGHT",
		4: "ADAPTER_SIZE_SIXTEEN",
		5: "ADAPTER_SIZE_THIRTY_TWO",
	}
	SupervisedHyperParameters_AdapterSize_value = map[string]int32{
		"ADAPTER_SIZE_UNSPECIFIED": 0,
		"ADAPTER_SIZE_ONE":         1,
		"ADAPTER_SIZE_TWO":         6,
		"ADAPTER_SIZE_FOUR":        2,
		"ADAPTER_SIZE_EIGHT":       3,
		"ADAPTER_SIZE_SIXTEEN":     4,
		"ADAPTER_SIZE_THIRTY_TWO":  5,
	}
)

func (x SupervisedHyperParameters_AdapterSize) Enum() *SupervisedHyperParameters_AdapterSize {
	p := new(SupervisedHyperParameters_AdapterSize)
	*p = x
	return p
}

func (x SupervisedHyperParameters_AdapterSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupervisedHyperParameters_AdapterSize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[0].Descriptor()
}

func (SupervisedHyperParameters_AdapterSize) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[0]
}

func (x SupervisedHyperParameters_AdapterSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupervisedHyperParameters_AdapterSize.Descriptor instead.
func (SupervisedHyperParameters_AdapterSize) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{8, 0}
}

// Supported tuning modes.
type SupervisedTuningSpec_TuningMode int32

const (
	// Tuning mode is unspecified.
	SupervisedTuningSpec_TUNING_MODE_UNSPECIFIED SupervisedTuningSpec_TuningMode = 0
	// Full fine-tuning mode.
	SupervisedTuningSpec_TUNING_MODE_FULL SupervisedTuningSpec_TuningMode = 1
	// PEFT adapter tuning mode.
	SupervisedTuningSpec_TUNING_MODE_PEFT_ADAPTER SupervisedTuningSpec_TuningMode = 2
)

// Enum value maps for SupervisedTuningSpec_TuningMode.
var (
	SupervisedTuningSpec_TuningMode_name = map[int32]string{
		0: "TUNING_MODE_UNSPECIFIED",
		1: "TUNING_MODE_FULL",
		2: "TUNING_MODE_PEFT_ADAPTER",
	}
	SupervisedTuningSpec_TuningMode_value = map[string]int32{
		"TUNING_MODE_UNSPECIFIED":  0,
		"TUNING_MODE_FULL":         1,
		"TUNING_MODE_PEFT_ADAPTER": 2,
	}
)

func (x SupervisedTuningSpec_TuningMode) Enum() *SupervisedTuningSpec_TuningMode {
	p := new(SupervisedTuningSpec_TuningMode)
	*p = x
	return p
}

func (x SupervisedTuningSpec_TuningMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupervisedTuningSpec_TuningMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[1].Descriptor()
}

func (SupervisedTuningSpec_TuningMode) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[1]
}

func (x SupervisedTuningSpec_TuningMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupervisedTuningSpec_TuningMode.Descriptor instead.
func (SupervisedTuningSpec_TuningMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{9, 0}
}

// Represents a TuningJob that runs with Google owned models.
type TuningJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceModel:
	//
	//	*TuningJob_BaseModel
	SourceModel isTuningJob_SourceModel `protobuf_oneof:"source_model"`
	// Types that are assignable to TuningSpec:
	//
	//	*TuningJob_SupervisedTuningSpec
	//	*TuningJob_DistillationSpec
	//	*TuningJob_PartnerModelTuningSpec
	TuningSpec isTuningJob_TuningSpec `protobuf_oneof:"tuning_spec"`
	// Output only. Identifier. Resource name of a TuningJob. Format:
	// `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the
	// [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
	// characters long and can consist of any UTF-8 characters.
	TunedModelDisplayName string `protobuf:"bytes,2,opt,name=tuned_model_display_name,json=tunedModelDisplayName,proto3" json:"tuned_model_display_name,omitempty"`
	// Optional. The description of the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The user-provided path to custom model weights. Set this field
	// to tune a custom model. The path must be a Cloud Storage directory that
	// contains the model weights in .safetensors format along with associated
	// model metadata files. If this field is set, the base_model field must still
	// be set to indicate which base model the custom model is derived from. This
	// feature is only available for open source models.
	CustomBaseModel string `protobuf:"bytes,26,opt,name=custom_base_model,json=customBaseModel,proto3" json:"custom_base_model,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"state,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the TuningJob entered any of the following
	// [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Only populated when job's state is `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// Optional. The labels with user-defined metadata to organize
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
	// such as [Model][google.cloud.aiplatform.v1.Model] and
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint].
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The Experiment associated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	Experiment string `protobuf:"bytes,13,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// Output only. The tuned model resources associated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	TunedModel *TunedModel `protobuf:"bytes,14,opt,name=tuned_model,json=tunedModel,proto3" json:"tuned_model,omitempty"`
	// Output only. The tuning data statistics associated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	TuningDataStats *TuningDataStats `protobuf:"bytes,15,opt,name=tuning_data_stats,json=tuningDataStats,proto3" json:"tuning_data_stats,omitempty"`
	// Output only. The resource name of the PipelineJob associated with the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob]. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`.
	PipelineJob string `protobuf:"bytes,18,opt,name=pipeline_job,json=pipelineJob,proto3" json:"pipeline_job,omitempty"`
	// Customer-managed encryption key options for a TuningJob. If this is set,
	// then all resources created by the TuningJob will be encrypted with the
	// provided encryption key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,16,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// The service account that the tuningJob workload runs as.
	// If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
	// project will be used. See
	// https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
	//
	// Users starting the pipeline must have the `iam.serviceAccounts.actAs`
	// permission on this service account.
	ServiceAccount string `protobuf:"bytes,22,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Cloud Storage path to the directory where tuning job outputs are
	// written to. This field is only available and required for open source
	// models.
	OutputUri string `protobuf:"bytes,25,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *TuningJob) Reset() {
	*x = TuningJob{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuningJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningJob) ProtoMessage() {}

func (x *TuningJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningJob.ProtoReflect.Descriptor instead.
func (*TuningJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{0}
}

func (m *TuningJob) GetSourceModel() isTuningJob_SourceModel {
	if m != nil {
		return m.SourceModel
	}
	return nil
}

func (x *TuningJob) GetBaseModel() string {
	if x, ok := x.GetSourceModel().(*TuningJob_BaseModel); ok {
		return x.BaseModel
	}
	return ""
}

func (m *TuningJob) GetTuningSpec() isTuningJob_TuningSpec {
	if m != nil {
		return m.TuningSpec
	}
	return nil
}

func (x *TuningJob) GetSupervisedTuningSpec() *SupervisedTuningSpec {
	if x, ok := x.GetTuningSpec().(*TuningJob_SupervisedTuningSpec); ok {
		return x.SupervisedTuningSpec
	}
	return nil
}

func (x *TuningJob) GetDistillationSpec() *DistillationSpec {
	if x, ok := x.GetTuningSpec().(*TuningJob_DistillationSpec); ok {
		return x.DistillationSpec
	}
	return nil
}

func (x *TuningJob) GetPartnerModelTuningSpec() *PartnerModelTuningSpec {
	if x, ok := x.GetTuningSpec().(*TuningJob_PartnerModelTuningSpec); ok {
		return x.PartnerModelTuningSpec
	}
	return nil
}

func (x *TuningJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TuningJob) GetTunedModelDisplayName() string {
	if x != nil {
		return x.TunedModelDisplayName
	}
	return ""
}

func (x *TuningJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TuningJob) GetCustomBaseModel() string {
	if x != nil {
		return x.CustomBaseModel
	}
	return ""
}

func (x *TuningJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *TuningJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TuningJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TuningJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TuningJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TuningJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *TuningJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TuningJob) GetExperiment() string {
	if x != nil {
		return x.Experiment
	}
	return ""
}

func (x *TuningJob) GetTunedModel() *TunedModel {
	if x != nil {
		return x.TunedModel
	}
	return nil
}

func (x *TuningJob) GetTuningDataStats() *TuningDataStats {
	if x != nil {
		return x.TuningDataStats
	}
	return nil
}

func (x *TuningJob) GetPipelineJob() string {
	if x != nil {
		return x.PipelineJob
	}
	return ""
}

func (x *TuningJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *TuningJob) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *TuningJob) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

type isTuningJob_SourceModel interface {
	isTuningJob_SourceModel()
}

type TuningJob_BaseModel struct {
	// The base model that is being tuned. See [Supported
	// models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
	BaseModel string `protobuf:"bytes,4,opt,name=base_model,json=baseModel,proto3,oneof"`
}

func (*TuningJob_BaseModel) isTuningJob_SourceModel() {}

type isTuningJob_TuningSpec interface {
	isTuningJob_TuningSpec()
}

type TuningJob_SupervisedTuningSpec struct {
	// Tuning Spec for Supervised Fine Tuning.
	SupervisedTuningSpec *SupervisedTuningSpec `protobuf:"bytes,5,opt,name=supervised_tuning_spec,json=supervisedTuningSpec,proto3,oneof"`
}

type TuningJob_DistillationSpec struct {
	// Tuning Spec for Distillation.
	DistillationSpec *DistillationSpec `protobuf:"bytes,17,opt,name=distillation_spec,json=distillationSpec,proto3,oneof"`
}

type TuningJob_PartnerModelTuningSpec struct {
	// Tuning Spec for open sourced and third party Partner models.
	PartnerModelTuningSpec *PartnerModelTuningSpec `protobuf:"bytes,21,opt,name=partner_model_tuning_spec,json=partnerModelTuningSpec,proto3,oneof"`
}

func (*TuningJob_SupervisedTuningSpec) isTuningJob_TuningSpec() {}

func (*TuningJob_DistillationSpec) isTuningJob_TuningSpec() {}

func (*TuningJob_PartnerModelTuningSpec) isTuningJob_TuningSpec() {}

// The Model Registry Model and Online Prediction Endpoint associated with
// this [TuningJob][google.cloud.aiplatform.v1.TuningJob].
type TunedModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the TunedModel. Format:
	//
	// `projects/{project}/locations/{location}/models/{model}@{version_id}`
	//
	// When tuning from a base model, the version_id will be 1.
	//
	// For continuous tuning, the version id will be incremented by 1 from the
	// last version id in the parent model. E.g.,
	// `projects/{project}/locations/{location}/models/{model}@{last_version_id +
	// 1}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. A resource name of an Endpoint. Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`.
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The checkpoints associated with this TunedModel.
	// This field is only populated for tuning jobs that enable intermediate
	// checkpoints.
	Checkpoints []*TunedModelCheckpoint `protobuf:"bytes,3,rep,name=checkpoints,proto3" json:"checkpoints,omitempty"`
}

func (x *TunedModel) Reset() {
	*x = TunedModel{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunedModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModel) ProtoMessage() {}

func (x *TunedModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModel.ProtoReflect.Descriptor instead.
func (*TunedModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{1}
}

func (x *TunedModel) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TunedModel) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *TunedModel) GetCheckpoints() []*TunedModelCheckpoint {
	if x != nil {
		return x.Checkpoints
	}
	return nil
}

// Dataset distribution for Supervised Tuning.
type SupervisedTuningDatasetDistribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sum of a given population of values.
	Sum int64 `protobuf:"varint,1,opt,name=sum,proto3" json:"sum,omitempty"`
	// Output only. Sum of a given population of values that are billable.
	BillableSum int64 `protobuf:"varint,9,opt,name=billable_sum,json=billableSum,proto3" json:"billable_sum,omitempty"`
	// Output only. The minimum of the population values.
	Min float64 `protobuf:"fixed64,2,opt,name=min,proto3" json:"min,omitempty"`
	// Output only. The maximum of the population values.
	Max float64 `protobuf:"fixed64,3,opt,name=max,proto3" json:"max,omitempty"`
	// Output only. The arithmetic mean of the values in the population.
	Mean float64 `protobuf:"fixed64,4,opt,name=mean,proto3" json:"mean,omitempty"`
	// Output only. The median of the values in the population.
	Median float64 `protobuf:"fixed64,5,opt,name=median,proto3" json:"median,omitempty"`
	// Output only. The 5th percentile of the values in the population.
	P5 float64 `protobuf:"fixed64,6,opt,name=p5,proto3" json:"p5,omitempty"`
	// Output only. The 95th percentile of the values in the population.
	P95 float64 `protobuf:"fixed64,7,opt,name=p95,proto3" json:"p95,omitempty"`
	// Output only. Defines the histogram bucket.
	Buckets []*SupervisedTuningDatasetDistribution_DatasetBucket `protobuf:"bytes,8,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *SupervisedTuningDatasetDistribution) Reset() {
	*x = SupervisedTuningDatasetDistribution{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupervisedTuningDatasetDistribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDatasetDistribution) ProtoMessage() {}

func (x *SupervisedTuningDatasetDistribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDatasetDistribution.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDatasetDistribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{2}
}

func (x *SupervisedTuningDatasetDistribution) GetSum() int64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetBillableSum() int64 {
	if x != nil {
		return x.BillableSum
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMean() float64 {
	if x != nil {
		return x.Mean
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMedian() float64 {
	if x != nil {
		return x.Median
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetP5() float64 {
	if x != nil {
		return x.P5
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetP95() float64 {
	if x != nil {
		return x.P95
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetBuckets() []*SupervisedTuningDatasetDistribution_DatasetBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Tuning data statistics for Supervised Tuning.
type SupervisedTuningDataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of examples in the tuning dataset.
	TuningDatasetExampleCount int64 `protobuf:"varint,1,opt,name=tuning_dataset_example_count,json=tuningDatasetExampleCount,proto3" json:"tuning_dataset_example_count,omitempty"`
	// Output only. Number of tuning characters in the tuning dataset.
	TotalTuningCharacterCount int64 `protobuf:"varint,2,opt,name=total_tuning_character_count,json=totalTuningCharacterCount,proto3" json:"total_tuning_character_count,omitempty"`
	// Output only. Number of billable characters in the tuning dataset.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tuning_job.proto.
	TotalBillableCharacterCount int64 `protobuf:"varint,3,opt,name=total_billable_character_count,json=totalBillableCharacterCount,proto3" json:"total_billable_character_count,omitempty"`
	// Output only. Number of billable tokens in the tuning dataset.
	TotalBillableTokenCount int64 `protobuf:"varint,9,opt,name=total_billable_token_count,json=totalBillableTokenCount,proto3" json:"total_billable_token_count,omitempty"`
	// Output only. Number of tuning steps for this Tuning Job.
	TuningStepCount int64 `protobuf:"varint,4,opt,name=tuning_step_count,json=tuningStepCount,proto3" json:"tuning_step_count,omitempty"`
	// Output only. Dataset distributions for the user input tokens.
	UserInputTokenDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,5,opt,name=user_input_token_distribution,json=userInputTokenDistribution,proto3" json:"user_input_token_distribution,omitempty"`
	// Output only. Dataset distributions for the user output tokens.
	UserOutputTokenDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,6,opt,name=user_output_token_distribution,json=userOutputTokenDistribution,proto3" json:"user_output_token_distribution,omitempty"`
	// Output only. Dataset distributions for the messages per example.
	UserMessagePerExampleDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,7,opt,name=user_message_per_example_distribution,json=userMessagePerExampleDistribution,proto3" json:"user_message_per_example_distribution,omitempty"`
	// Output only. Sample user messages in the training dataset uri.
	UserDatasetExamples []*Content `protobuf:"bytes,8,rep,name=user_dataset_examples,json=userDatasetExamples,proto3" json:"user_dataset_examples,omitempty"`
	// Output only. The number of examples in the dataset that have been dropped.
	// An example can be dropped for reasons including: too many tokens, contains
	// an invalid image, contains too many images, etc.
	TotalTruncatedExampleCount int64 `protobuf:"varint,10,opt,name=total_truncated_example_count,json=totalTruncatedExampleCount,proto3" json:"total_truncated_example_count,omitempty"`
	// Output only. A partial sample of the indices (starting from 1) of the
	// dropped examples.
	TruncatedExampleIndices []int64 `protobuf:"varint,11,rep,packed,name=truncated_example_indices,json=truncatedExampleIndices,proto3" json:"truncated_example_indices,omitempty"`
	// Output only. For each index in `truncated_example_indices`, the user-facing
	// reason why the example was dropped.
	DroppedExampleReasons []string `protobuf:"bytes,12,rep,name=dropped_example_reasons,json=droppedExampleReasons,proto3" json:"dropped_example_reasons,omitempty"`
}

func (x *SupervisedTuningDataStats) Reset() {
	*x = SupervisedTuningDataStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupervisedTuningDataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDataStats) ProtoMessage() {}

func (x *SupervisedTuningDataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDataStats.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{3}
}

func (x *SupervisedTuningDataStats) GetTuningDatasetExampleCount() int64 {
	if x != nil {
		return x.TuningDatasetExampleCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTotalTuningCharacterCount() int64 {
	if x != nil {
		return x.TotalTuningCharacterCount
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/tuning_job.proto.
func (x *SupervisedTuningDataStats) GetTotalBillableCharacterCount() int64 {
	if x != nil {
		return x.TotalBillableCharacterCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTotalBillableTokenCount() int64 {
	if x != nil {
		return x.TotalBillableTokenCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTuningStepCount() int64 {
	if x != nil {
		return x.TuningStepCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetUserInputTokenDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserInputTokenDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserOutputTokenDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserOutputTokenDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserMessagePerExampleDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserMessagePerExampleDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserDatasetExamples() []*Content {
	if x != nil {
		return x.UserDatasetExamples
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetTotalTruncatedExampleCount() int64 {
	if x != nil {
		return x.TotalTruncatedExampleCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTruncatedExampleIndices() []int64 {
	if x != nil {
		return x.TruncatedExampleIndices
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetDroppedExampleReasons() []string {
	if x != nil {
		return x.DroppedExampleReasons
	}
	return nil
}

// Distribution computed over a tuning dataset.
type DatasetDistribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sum of a given population of values.
	Sum float64 `protobuf:"fixed64,1,opt,name=sum,proto3" json:"sum,omitempty"`
	// Output only. The minimum of the population values.
	Min float64 `protobuf:"fixed64,2,opt,name=min,proto3" json:"min,omitempty"`
	// Output only. The maximum of the population values.
	Max float64 `protobuf:"fixed64,3,opt,name=max,proto3" json:"max,omitempty"`
	// Output only. The arithmetic mean of the values in the population.
	Mean float64 `protobuf:"fixed64,4,opt,name=mean,proto3" json:"mean,omitempty"`
	// Output only. The median of the values in the population.
	Median float64 `protobuf:"fixed64,5,opt,name=median,proto3" json:"median,omitempty"`
	// Output only. The 5th percentile of the values in the population.
	P5 float64 `protobuf:"fixed64,6,opt,name=p5,proto3" json:"p5,omitempty"`
	// Output only. The 95th percentile of the values in the population.
	P95 float64 `protobuf:"fixed64,7,opt,name=p95,proto3" json:"p95,omitempty"`
	// Output only. Defines the histogram bucket.
	Buckets []*DatasetDistribution_DistributionBucket `protobuf:"bytes,8,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *DatasetDistribution) Reset() {
	*x = DatasetDistribution{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatasetDistribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetDistribution) ProtoMessage() {}

func (x *DatasetDistribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetDistribution.ProtoReflect.Descriptor instead.
func (*DatasetDistribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{4}
}

func (x *DatasetDistribution) GetSum() float64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *DatasetDistribution) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *DatasetDistribution) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

func (x *DatasetDistribution) GetMean() float64 {
	if x != nil {
		return x.Mean
	}
	return 0
}

func (x *DatasetDistribution) GetMedian() float64 {
	if x != nil {
		return x.Median
	}
	return 0
}

func (x *DatasetDistribution) GetP5() float64 {
	if x != nil {
		return x.P5
	}
	return 0
}

func (x *DatasetDistribution) GetP95() float64 {
	if x != nil {
		return x.P95
	}
	return 0
}

func (x *DatasetDistribution) GetBuckets() []*DatasetDistribution_DistributionBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Statistics computed over a tuning dataset.
type DatasetStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of examples in the tuning dataset.
	TuningDatasetExampleCount int64 `protobuf:"varint,1,opt,name=tuning_dataset_example_count,json=tuningDatasetExampleCount,proto3" json:"tuning_dataset_example_count,omitempty"`
	// Output only. Number of tuning characters in the tuning dataset.
	TotalTuningCharacterCount int64 `protobuf:"varint,2,opt,name=total_tuning_character_count,json=totalTuningCharacterCount,proto3" json:"total_tuning_character_count,omitempty"`
	// Output only. Number of billable characters in the tuning dataset.
	TotalBillableCharacterCount int64 `protobuf:"varint,3,opt,name=total_billable_character_count,json=totalBillableCharacterCount,proto3" json:"total_billable_character_count,omitempty"`
	// Output only. Number of tuning steps for this Tuning Job.
	TuningStepCount int64 `protobuf:"varint,4,opt,name=tuning_step_count,json=tuningStepCount,proto3" json:"tuning_step_count,omitempty"`
	// Output only. Dataset distributions for the user input tokens.
	UserInputTokenDistribution *DatasetDistribution `protobuf:"bytes,5,opt,name=user_input_token_distribution,json=userInputTokenDistribution,proto3" json:"user_input_token_distribution,omitempty"`
	// Output only. Dataset distributions for the user output tokens.
	UserOutputTokenDistribution *DatasetDistribution `protobuf:"bytes,6,opt,name=user_output_token_distribution,json=userOutputTokenDistribution,proto3,oneof" json:"user_output_token_distribution,omitempty"`
	// Output only. Dataset distributions for the messages per example.
	UserMessagePerExampleDistribution *DatasetDistribution `protobuf:"bytes,7,opt,name=user_message_per_example_distribution,json=userMessagePerExampleDistribution,proto3" json:"user_message_per_example_distribution,omitempty"`
	// Output only. Sample user messages in the training dataset uri.
	UserDatasetExamples []*Content `protobuf:"bytes,8,rep,name=user_dataset_examples,json=userDatasetExamples,proto3" json:"user_dataset_examples,omitempty"`
}

func (x *DatasetStats) Reset() {
	*x = DatasetStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatasetStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetStats) ProtoMessage() {}

func (x *DatasetStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetStats.ProtoReflect.Descriptor instead.
func (*DatasetStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{5}
}

func (x *DatasetStats) GetTuningDatasetExampleCount() int64 {
	if x != nil {
		return x.TuningDatasetExampleCount
	}
	return 0
}

func (x *DatasetStats) GetTotalTuningCharacterCount() int64 {
	if x != nil {
		return x.TotalTuningCharacterCount
	}
	return 0
}

func (x *DatasetStats) GetTotalBillableCharacterCount() int64 {
	if x != nil {
		return x.TotalBillableCharacterCount
	}
	return 0
}

func (x *DatasetStats) GetTuningStepCount() int64 {
	if x != nil {
		return x.TuningStepCount
	}
	return 0
}

func (x *DatasetStats) GetUserInputTokenDistribution() *DatasetDistribution {
	if x != nil {
		return x.UserInputTokenDistribution
	}
	return nil
}

func (x *DatasetStats) GetUserOutputTokenDistribution() *DatasetDistribution {
	if x != nil {
		return x.UserOutputTokenDistribution
	}
	return nil
}

func (x *DatasetStats) GetUserMessagePerExampleDistribution() *DatasetDistribution {
	if x != nil {
		return x.UserMessagePerExampleDistribution
	}
	return nil
}

func (x *DatasetStats) GetUserDatasetExamples() []*Content {
	if x != nil {
		return x.UserDatasetExamples
	}
	return nil
}

// Statistics computed for datasets used for distillation.
type DistillationDataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Statistics computed for the training dataset.
	TrainingDatasetStats *DatasetStats `protobuf:"bytes,1,opt,name=training_dataset_stats,json=trainingDatasetStats,proto3" json:"training_dataset_stats,omitempty"`
}

func (x *DistillationDataStats) Reset() {
	*x = DistillationDataStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DistillationDataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistillationDataStats) ProtoMessage() {}

func (x *DistillationDataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistillationDataStats.ProtoReflect.Descriptor instead.
func (*DistillationDataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{6}
}

func (x *DistillationDataStats) GetTrainingDatasetStats() *DatasetStats {
	if x != nil {
		return x.TrainingDatasetStats
	}
	return nil
}

// The tuning data statistic values for
// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
type TuningDataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TuningDataStats:
	//
	//	*TuningDataStats_SupervisedTuningDataStats
	//	*TuningDataStats_DistillationDataStats
	TuningDataStats isTuningDataStats_TuningDataStats `protobuf_oneof:"tuning_data_stats"`
}

func (x *TuningDataStats) Reset() {
	*x = TuningDataStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuningDataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningDataStats) ProtoMessage() {}

func (x *TuningDataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningDataStats.ProtoReflect.Descriptor instead.
func (*TuningDataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{7}
}

func (m *TuningDataStats) GetTuningDataStats() isTuningDataStats_TuningDataStats {
	if m != nil {
		return m.TuningDataStats
	}
	return nil
}

func (x *TuningDataStats) GetSupervisedTuningDataStats() *SupervisedTuningDataStats {
	if x, ok := x.GetTuningDataStats().(*TuningDataStats_SupervisedTuningDataStats); ok {
		return x.SupervisedTuningDataStats
	}
	return nil
}

func (x *TuningDataStats) GetDistillationDataStats() *DistillationDataStats {
	if x, ok := x.GetTuningDataStats().(*TuningDataStats_DistillationDataStats); ok {
		return x.DistillationDataStats
	}
	return nil
}

type isTuningDataStats_TuningDataStats interface {
	isTuningDataStats_TuningDataStats()
}

type TuningDataStats_SupervisedTuningDataStats struct {
	// The SFT Tuning data stats.
	SupervisedTuningDataStats *SupervisedTuningDataStats `protobuf:"bytes,1,opt,name=supervised_tuning_data_stats,json=supervisedTuningDataStats,proto3,oneof"`
}

type TuningDataStats_DistillationDataStats struct {
	// Output only. Statistics for distillation.
	DistillationDataStats *DistillationDataStats `protobuf:"bytes,3,opt,name=distillation_data_stats,json=distillationDataStats,proto3,oneof"`
}

func (*TuningDataStats_SupervisedTuningDataStats) isTuningDataStats_TuningDataStats() {}

func (*TuningDataStats_DistillationDataStats) isTuningDataStats_TuningDataStats() {}

// Hyperparameters for SFT.
type SupervisedHyperParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of complete passes the model makes over the entire
	// training dataset during training.
	EpochCount int64 `protobuf:"varint,1,opt,name=epoch_count,json=epochCount,proto3" json:"epoch_count,omitempty"`
	// Optional. Multiplier for adjusting the default learning rate.
	// Mutually exclusive with `learning_rate`.
	LearningRateMultiplier float64 `protobuf:"fixed64,2,opt,name=learning_rate_multiplier,json=learningRateMultiplier,proto3" json:"learning_rate_multiplier,omitempty"`
	// Optional. Learning rate for tuning.
	// Mutually exclusive with `learning_rate_multiplier`.
	// This feature is only available for open source models.
	LearningRate float64 `protobuf:"fixed64,6,opt,name=learning_rate,json=learningRate,proto3" json:"learning_rate,omitempty"`
	// Optional. Adapter size for tuning.
	AdapterSize SupervisedHyperParameters_AdapterSize `protobuf:"varint,3,opt,name=adapter_size,json=adapterSize,proto3,enum=google.cloud.aiplatform.v1beta1.SupervisedHyperParameters_AdapterSize" json:"adapter_size,omitempty"`
	// Optional. Batch size for tuning.
	// This feature is only available for open source models.
	BatchSize int64 `protobuf:"varint,5,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
}

func (x *SupervisedHyperParameters) Reset() {
	*x = SupervisedHyperParameters{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupervisedHyperParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedHyperParameters) ProtoMessage() {}

func (x *SupervisedHyperParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedHyperParameters.ProtoReflect.Descriptor instead.
func (*SupervisedHyperParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{8}
}

func (x *SupervisedHyperParameters) GetEpochCount() int64 {
	if x != nil {
		return x.EpochCount
	}
	return 0
}

func (x *SupervisedHyperParameters) GetLearningRateMultiplier() float64 {
	if x != nil {
		return x.LearningRateMultiplier
	}
	return 0
}

func (x *SupervisedHyperParameters) GetLearningRate() float64 {
	if x != nil {
		return x.LearningRate
	}
	return 0
}

func (x *SupervisedHyperParameters) GetAdapterSize() SupervisedHyperParameters_AdapterSize {
	if x != nil {
		return x.AdapterSize
	}
	return SupervisedHyperParameters_ADAPTER_SIZE_UNSPECIFIED
}

func (x *SupervisedHyperParameters) GetBatchSize() int64 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

// Tuning Spec for Supervised Tuning for first party models.
type SupervisedTuningSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Training dataset used for tuning. The dataset can be specified as
	// either a Cloud Storage path to a JSONL file or as the resource name of a
	// Vertex Multimodal Dataset.
	TrainingDatasetUri string `protobuf:"bytes,1,opt,name=training_dataset_uri,json=trainingDatasetUri,proto3" json:"training_dataset_uri,omitempty"`
	// Optional. Validation dataset used for tuning. The dataset can be specified
	// as either a Cloud Storage path to a JSONL file or as the resource name of a
	// Vertex Multimodal Dataset.
	ValidationDatasetUri string `protobuf:"bytes,2,opt,name=validation_dataset_uri,json=validationDatasetUri,proto3" json:"validation_dataset_uri,omitempty"`
	// Optional. Hyperparameters for SFT.
	HyperParameters *SupervisedHyperParameters `protobuf:"bytes,3,opt,name=hyper_parameters,json=hyperParameters,proto3" json:"hyper_parameters,omitempty"`
	// Optional. If set to true, disable intermediate checkpoints for SFT and only
	// the last checkpoint will be exported. Otherwise, enable intermediate
	// checkpoints for SFT. Default is false.
	ExportLastCheckpointOnly bool `protobuf:"varint,6,opt,name=export_last_checkpoint_only,json=exportLastCheckpointOnly,proto3" json:"export_last_checkpoint_only,omitempty"`
	// Tuning mode.
	TuningMode SupervisedTuningSpec_TuningMode `protobuf:"varint,7,opt,name=tuning_mode,json=tuningMode,proto3,enum=google.cloud.aiplatform.v1beta1.SupervisedTuningSpec_TuningMode" json:"tuning_mode,omitempty"`
}

func (x *SupervisedTuningSpec) Reset() {
	*x = SupervisedTuningSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupervisedTuningSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningSpec) ProtoMessage() {}

func (x *SupervisedTuningSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningSpec.ProtoReflect.Descriptor instead.
func (*SupervisedTuningSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{9}
}

func (x *SupervisedTuningSpec) GetTrainingDatasetUri() string {
	if x != nil {
		return x.TrainingDatasetUri
	}
	return ""
}

func (x *SupervisedTuningSpec) GetValidationDatasetUri() string {
	if x != nil {
		return x.ValidationDatasetUri
	}
	return ""
}

func (x *SupervisedTuningSpec) GetHyperParameters() *SupervisedHyperParameters {
	if x != nil {
		return x.HyperParameters
	}
	return nil
}

func (x *SupervisedTuningSpec) GetExportLastCheckpointOnly() bool {
	if x != nil {
		return x.ExportLastCheckpointOnly
	}
	return false
}

func (x *SupervisedTuningSpec) GetTuningMode() SupervisedTuningSpec_TuningMode {
	if x != nil {
		return x.TuningMode
	}
	return SupervisedTuningSpec_TUNING_MODE_UNSPECIFIED
}

// Tuning Spec for Distillation.
type DistillationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The teacher model that is being distilled from. See [Supported
	// models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
	//
	// Types that are assignable to TeacherModel:
	//
	//	*DistillationSpec_BaseTeacherModel
	//	*DistillationSpec_TunedTeacherModelSource
	TeacherModel isDistillationSpec_TeacherModel `protobuf_oneof:"teacher_model"`
	// Required. Cloud Storage path to file containing training dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	TrainingDatasetUri string `protobuf:"bytes,1,opt,name=training_dataset_uri,json=trainingDatasetUri,proto3" json:"training_dataset_uri,omitempty"`
	// Optional. Cloud Storage path to file containing validation dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	ValidationDatasetUri *string `protobuf:"bytes,2,opt,name=validation_dataset_uri,json=validationDatasetUri,proto3,oneof" json:"validation_dataset_uri,omitempty"`
	// Optional. Hyperparameters for Distillation.
	HyperParameters *DistillationHyperParameters `protobuf:"bytes,3,opt,name=hyper_parameters,json=hyperParameters,proto3" json:"hyper_parameters,omitempty"`
	// The student model that is being tuned, e.g., "google/gemma-2b-1.1-it".
	StudentModel string `protobuf:"bytes,4,opt,name=student_model,json=studentModel,proto3" json:"student_model,omitempty"`
	// Required. A path in a Cloud Storage bucket, which will be treated as the
	// root output directory of the distillation pipeline. It is used by the
	// system to generate the paths of output artifacts.
	PipelineRootDirectory string `protobuf:"bytes,7,opt,name=pipeline_root_directory,json=pipelineRootDirectory,proto3" json:"pipeline_root_directory,omitempty"`
}

func (x *DistillationSpec) Reset() {
	*x = DistillationSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DistillationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistillationSpec) ProtoMessage() {}

func (x *DistillationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistillationSpec.ProtoReflect.Descriptor instead.
func (*DistillationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{10}
}

func (m *DistillationSpec) GetTeacherModel() isDistillationSpec_TeacherModel {
	if m != nil {
		return m.TeacherModel
	}
	return nil
}

func (x *DistillationSpec) GetBaseTeacherModel() string {
	if x, ok := x.GetTeacherModel().(*DistillationSpec_BaseTeacherModel); ok {
		return x.BaseTeacherModel
	}
	return ""
}

func (x *DistillationSpec) GetTunedTeacherModelSource() string {
	if x, ok := x.GetTeacherModel().(*DistillationSpec_TunedTeacherModelSource); ok {
		return x.TunedTeacherModelSource
	}
	return ""
}

func (x *DistillationSpec) GetTrainingDatasetUri() string {
	if x != nil {
		return x.TrainingDatasetUri
	}
	return ""
}

func (x *DistillationSpec) GetValidationDatasetUri() string {
	if x != nil && x.ValidationDatasetUri != nil {
		return *x.ValidationDatasetUri
	}
	return ""
}

func (x *DistillationSpec) GetHyperParameters() *DistillationHyperParameters {
	if x != nil {
		return x.HyperParameters
	}
	return nil
}

func (x *DistillationSpec) GetStudentModel() string {
	if x != nil {
		return x.StudentModel
	}
	return ""
}

func (x *DistillationSpec) GetPipelineRootDirectory() string {
	if x != nil {
		return x.PipelineRootDirectory
	}
	return ""
}

type isDistillationSpec_TeacherModel interface {
	isDistillationSpec_TeacherModel()
}

type DistillationSpec_BaseTeacherModel struct {
	// The base teacher model that is being distilled. See [Supported
	// models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
	BaseTeacherModel string `protobuf:"bytes,5,opt,name=base_teacher_model,json=baseTeacherModel,proto3,oneof"`
}

type DistillationSpec_TunedTeacherModelSource struct {
	// The resource name of the Tuned teacher model. Format:
	// `projects/{project}/locations/{location}/models/{model}`.
	TunedTeacherModelSource string `protobuf:"bytes,6,opt,name=tuned_teacher_model_source,json=tunedTeacherModelSource,proto3,oneof"`
}

func (*DistillationSpec_BaseTeacherModel) isDistillationSpec_TeacherModel() {}

func (*DistillationSpec_TunedTeacherModelSource) isDistillationSpec_TeacherModel() {}

// Hyperparameters for Distillation.
type DistillationHyperParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of complete passes the model makes over the entire
	// training dataset during training.
	EpochCount *int64 `protobuf:"varint,1,opt,name=epoch_count,json=epochCount,proto3,oneof" json:"epoch_count,omitempty"`
	// Optional. Multiplier for adjusting the default learning rate.
	LearningRateMultiplier *float64 `protobuf:"fixed64,2,opt,name=learning_rate_multiplier,json=learningRateMultiplier,proto3,oneof" json:"learning_rate_multiplier,omitempty"`
	// Optional. Adapter size for distillation.
	AdapterSize SupervisedHyperParameters_AdapterSize `protobuf:"varint,3,opt,name=adapter_size,json=adapterSize,proto3,enum=google.cloud.aiplatform.v1beta1.SupervisedHyperParameters_AdapterSize" json:"adapter_size,omitempty"`
}

func (x *DistillationHyperParameters) Reset() {
	*x = DistillationHyperParameters{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DistillationHyperParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistillationHyperParameters) ProtoMessage() {}

func (x *DistillationHyperParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistillationHyperParameters.ProtoReflect.Descriptor instead.
func (*DistillationHyperParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{11}
}

func (x *DistillationHyperParameters) GetEpochCount() int64 {
	if x != nil && x.EpochCount != nil {
		return *x.EpochCount
	}
	return 0
}

func (x *DistillationHyperParameters) GetLearningRateMultiplier() float64 {
	if x != nil && x.LearningRateMultiplier != nil {
		return *x.LearningRateMultiplier
	}
	return 0
}

func (x *DistillationHyperParameters) GetAdapterSize() SupervisedHyperParameters_AdapterSize {
	if x != nil {
		return x.AdapterSize
	}
	return SupervisedHyperParameters_ADAPTER_SIZE_UNSPECIFIED
}

// Tuning spec for Partner models.
type PartnerModelTuningSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage path to file containing training dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	TrainingDatasetUri string `protobuf:"bytes,1,opt,name=training_dataset_uri,json=trainingDatasetUri,proto3" json:"training_dataset_uri,omitempty"`
	// Optional. Cloud Storage path to file containing validation dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	ValidationDatasetUri string `protobuf:"bytes,2,opt,name=validation_dataset_uri,json=validationDatasetUri,proto3" json:"validation_dataset_uri,omitempty"`
	// Hyperparameters for tuning. The accepted hyper_parameters and their valid
	// range of values will differ depending on the base model.
	HyperParameters map[string]*structpb.Value `protobuf:"bytes,3,rep,name=hyper_parameters,json=hyperParameters,proto3" json:"hyper_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PartnerModelTuningSpec) Reset() {
	*x = PartnerModelTuningSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PartnerModelTuningSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartnerModelTuningSpec) ProtoMessage() {}

func (x *PartnerModelTuningSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartnerModelTuningSpec.ProtoReflect.Descriptor instead.
func (*PartnerModelTuningSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{12}
}

func (x *PartnerModelTuningSpec) GetTrainingDatasetUri() string {
	if x != nil {
		return x.TrainingDatasetUri
	}
	return ""
}

func (x *PartnerModelTuningSpec) GetValidationDatasetUri() string {
	if x != nil {
		return x.ValidationDatasetUri
	}
	return ""
}

func (x *PartnerModelTuningSpec) GetHyperParameters() map[string]*structpb.Value {
	if x != nil {
		return x.HyperParameters
	}
	return nil
}

// TunedModel Reference for legacy model migration.
type TunedModelRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Tuned Model Reference for the model.
	//
	// Types that are assignable to TunedModelRef:
	//
	//	*TunedModelRef_TunedModel
	//	*TunedModelRef_TuningJob
	//	*TunedModelRef_PipelineJob
	TunedModelRef isTunedModelRef_TunedModelRef `protobuf_oneof:"tuned_model_ref"`
}

func (x *TunedModelRef) Reset() {
	*x = TunedModelRef{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunedModelRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModelRef) ProtoMessage() {}

func (x *TunedModelRef) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModelRef.ProtoReflect.Descriptor instead.
func (*TunedModelRef) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{13}
}

func (m *TunedModelRef) GetTunedModelRef() isTunedModelRef_TunedModelRef {
	if m != nil {
		return m.TunedModelRef
	}
	return nil
}

func (x *TunedModelRef) GetTunedModel() string {
	if x, ok := x.GetTunedModelRef().(*TunedModelRef_TunedModel); ok {
		return x.TunedModel
	}
	return ""
}

func (x *TunedModelRef) GetTuningJob() string {
	if x, ok := x.GetTunedModelRef().(*TunedModelRef_TuningJob); ok {
		return x.TuningJob
	}
	return ""
}

func (x *TunedModelRef) GetPipelineJob() string {
	if x, ok := x.GetTunedModelRef().(*TunedModelRef_PipelineJob); ok {
		return x.PipelineJob
	}
	return ""
}

type isTunedModelRef_TunedModelRef interface {
	isTunedModelRef_TunedModelRef()
}

type TunedModelRef_TunedModel struct {
	// Support migration from model registry.
	TunedModel string `protobuf:"bytes,1,opt,name=tuned_model,json=tunedModel,proto3,oneof"`
}

type TunedModelRef_TuningJob struct {
	// Support migration from tuning job list page, from gemini-1.0-pro-002
	// to 1.5 and above.
	TuningJob string `protobuf:"bytes,2,opt,name=tuning_job,json=tuningJob,proto3,oneof"`
}

type TunedModelRef_PipelineJob struct {
	// Support migration from tuning job list page, from bison model to gemini
	// model.
	PipelineJob string `protobuf:"bytes,3,opt,name=pipeline_job,json=pipelineJob,proto3,oneof"`
}

func (*TunedModelRef_TunedModel) isTunedModelRef_TunedModelRef() {}

func (*TunedModelRef_TuningJob) isTunedModelRef_TunedModelRef() {}

func (*TunedModelRef_PipelineJob) isTunedModelRef_TunedModelRef() {}

// TunedModelCheckpoint for the Tuned Model of a Tuning Job.
type TunedModelCheckpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the checkpoint.
	CheckpointId string `protobuf:"bytes,1,opt,name=checkpoint_id,json=checkpointId,proto3" json:"checkpoint_id,omitempty"`
	// The epoch of the checkpoint.
	Epoch int64 `protobuf:"varint,2,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// The step of the checkpoint.
	Step int64 `protobuf:"varint,3,opt,name=step,proto3" json:"step,omitempty"`
	// The Endpoint resource name that the checkpoint is deployed to. Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`.
	Endpoint string `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *TunedModelCheckpoint) Reset() {
	*x = TunedModelCheckpoint{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TunedModelCheckpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModelCheckpoint) ProtoMessage() {}

func (x *TunedModelCheckpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModelCheckpoint.ProtoReflect.Descriptor instead.
func (*TunedModelCheckpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{14}
}

func (x *TunedModelCheckpoint) GetCheckpointId() string {
	if x != nil {
		return x.CheckpointId
	}
	return ""
}

func (x *TunedModelCheckpoint) GetEpoch() int64 {
	if x != nil {
		return x.Epoch
	}
	return 0
}

func (x *TunedModelCheckpoint) GetStep() int64 {
	if x != nil {
		return x.Step
	}
	return 0
}

func (x *TunedModelCheckpoint) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

// Dataset bucket used to create a histogram for the distribution given a
// population of values.
type SupervisedTuningDatasetDistribution_DatasetBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of values in the bucket.
	Count float64 `protobuf:"fixed64,1,opt,name=count,proto3" json:"count,omitempty"`
	// Output only. Left bound of the bucket.
	Left float64 `protobuf:"fixed64,2,opt,name=left,proto3" json:"left,omitempty"`
	// Output only. Right bound of the bucket.
	Right float64 `protobuf:"fixed64,3,opt,name=right,proto3" json:"right,omitempty"`
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) Reset() {
	*x = SupervisedTuningDatasetDistribution_DatasetBucket{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDatasetDistribution_DatasetBucket) ProtoMessage() {}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDatasetDistribution_DatasetBucket.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDatasetDistribution_DatasetBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetCount() float64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetLeft() float64 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetRight() float64 {
	if x != nil {
		return x.Right
	}
	return 0
}

// Dataset bucket used to create a histogram for the distribution given a
// population of values.
type DatasetDistribution_DistributionBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of values in the bucket.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Output only. Left bound of the bucket.
	Left float64 `protobuf:"fixed64,2,opt,name=left,proto3" json:"left,omitempty"`
	// Output only. Right bound of the bucket.
	Right float64 `protobuf:"fixed64,3,opt,name=right,proto3" json:"right,omitempty"`
}

func (x *DatasetDistribution_DistributionBucket) Reset() {
	*x = DatasetDistribution_DistributionBucket{}
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatasetDistribution_DistributionBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetDistribution_DistributionBucket) ProtoMessage() {}

func (x *DatasetDistribution_DistributionBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetDistribution_DistributionBucket.ProtoReflect.Descriptor instead.
func (*DatasetDistribution_DistributionBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{4, 0}
}

func (x *DatasetDistribution_DistributionBucket) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DatasetDistribution_DistributionBucket) GetLeft() float64 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *DatasetDistribution_DistributionBucket) GetRight() float64 {
	if x != nil {
		return x.Right
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_tuning_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6,
	0x0d, 0x0a, 0x09, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x1f, 0x0a, 0x0a,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x6d, 0x0a,
	0x16, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x53, 0x70, 0x65, 0x63, 0x48, 0x01, 0x52, 0x14, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73,
	0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x11,
	0x64, 0x69, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x48, 0x01, 0x52, 0x10, 0x64, 0x69,
	0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x74,
	0x0a, 0x19, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x48, 0x01, 0x52, 0x16, 0x70, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3c, 0x0a, 0x18, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x42, 0x61, 0x73,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x53, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x49, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x74,
	0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x61,
	0x0a, 0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x50, 0x0a, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x27, 0x0a,
	0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x23, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62,
	0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62,
	0x7d, 0x2a, 0x0a, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x32, 0x09, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xf1, 0x01, 0x0a, 0x0a, 0x54, 0x75, 0x6e, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x5c, 0x0a,
	0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0xc7, 0x03, 0x0a, 0x23,
	0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x26, 0x0a, 0x0c, 0x62, 0x69,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x75, 0x6d, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x61, 0x78,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x61, 0x78,
	0x12, 0x17, 0x0a, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x12, 0x13, 0x0a, 0x02, 0x70, 0x35, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x70, 0x35, 0x12, 0x15, 0x0a, 0x03, 0x70,
	0x39, 0x35, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x70,
	0x39, 0x35, 0x12, 0x71, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64,
	0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x5e, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0xcd, 0x08, 0x0a, 0x19, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x1c, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x1c, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x4a, 0x0a, 0x1e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x1b,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a,
	0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x8c,
	0x01, 0x0a, 0x1d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1a, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01,
	0x0a, 0x1e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1b, 0x75, 0x73, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9b,
	0x01, 0x0a, 0x25, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21, 0x75, 0x73, 0x65, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x15,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x75, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12,
	0x46, 0x0a, 0x1d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x19, 0x74, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x17, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x73, 0x22, 0x89, 0x03, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x73, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x73, 0x75, 0x6d, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6d,
	0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d,
	0x61, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x12, 0x13, 0x0a, 0x02, 0x70, 0x35, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x70, 0x35, 0x12, 0x15, 0x0a,
	0x03, 0x70, 0x39, 0x35, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x70, 0x39, 0x35, 0x12, 0x66, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x63, 0x0a, 0x12,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x22, 0xad, 0x06, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x44, 0x0a, 0x1c, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x1c, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x19, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48,
	0x0a, 0x1e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x7c, 0x0a, 0x1d, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x1e, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1b, 0x75,
	0x73, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x8b, 0x01,
	0x0a, 0x25, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x44,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x15, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x75, 0x73, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x42, 0x21,
	0x0a, 0x1f, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x81, 0x01, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x68, 0x0a, 0x16, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0x9c, 0x02, 0x0a, 0x0f, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x7d, 0x0a, 0x1c, 0x73, 0x75, 0x70,
	0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x19, 0x73,
	0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x75, 0x0a, 0x17, 0x64, 0x69, 0x73, 0x74,
	0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74,
	0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42,
	0x13, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x22, 0xfe, 0x03, 0x0a, 0x19, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x70,
	0x6f, 0x63, 0x68, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x6c, 0x65, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x6c, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x16, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x65, 0x61, 0x72, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74,
	0x65, 0x12, 0x6e, 0x0a, 0x0c, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x0b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65,
	0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52,
	0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53,
	0x49, 0x5a, 0x45, 0x5f, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x41,
	0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x54, 0x57, 0x4f, 0x10, 0x06, 0x12,
	0x15, 0x0a, 0x11, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f,
	0x46, 0x4f, 0x55, 0x52, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45,
	0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x45, 0x49, 0x47, 0x48, 0x54, 0x10, 0x03, 0x12, 0x18,
	0x0a, 0x14, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x53,
	0x49, 0x58, 0x54, 0x45, 0x45, 0x4e, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x44, 0x41, 0x50,
	0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x54, 0x48, 0x49, 0x52, 0x54, 0x59, 0x5f,
	0x54, 0x57, 0x4f, 0x10, 0x05, 0x22, 0xfa, 0x03, 0x0a, 0x14, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x35,
	0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x39, 0x0a, 0x16, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x72, 0x69,
	0x12, 0x6a, 0x0a, 0x10, 0x68, 0x79, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70,
	0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68, 0x79, 0x70,
	0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x1b,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x61,
	0x73, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x61, 0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73,
	0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x22, 0x5d, 0x0a, 0x0a, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x55, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x55, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x55, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x50, 0x45, 0x46, 0x54, 0x5f, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52,
	0x10, 0x02, 0x22, 0x9a, 0x04, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x12, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x62, 0x61, 0x73, 0x65, 0x54, 0x65, 0x61, 0x63, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x63, 0x0a, 0x1a, 0x74, 0x75, 0x6e, 0x65, 0x64,
	0x5f, 0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x48, 0x00, 0x52, 0x17, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x54, 0x65, 0x61, 0x63, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x14,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x3e, 0x0a, 0x16, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x14, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x72, 0x69,
	0x88, 0x01, 0x01, 0x12, 0x6c, 0x0a, 0x10, 0x68, 0x79, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x79, 0x70, 0x65,
	0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x17, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x22,
	0xa9, 0x02, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x29, 0x0a, 0x0b, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x70, 0x6f,
	0x63, 0x68, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x18, 0x6c, 0x65,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x16, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74,
	0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x6e,
	0x0a, 0x0c, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65,
	0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1b,
	0x0a, 0x19, 0x5f, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x22, 0xdf, 0x02, 0x0a, 0x16,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x39, 0x0a,
	0x16, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x14, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x77, 0x0a, 0x10, 0x68, 0x79, 0x70, 0x65,
	0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x48, 0x79, 0x70, 0x65,
	0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x1a, 0x5a, 0x0a, 0x14, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x87, 0x02,
	0x0a, 0x0d, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x12,
	0x47, 0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x75,
	0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x48, 0x00, 0x52, 0x09, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x12, 0x4f, 0x0a, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x42, 0x11, 0x0a, 0x0f, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x22, 0x81, 0x01, 0x0a, 0x14, 0x54, 0x75, 0x6e, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x73,
	0x74, 0x65, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x74, 0x65, 0x70, 0x12,
	0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0xe5, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x0e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes = []any{
	(SupervisedHyperParameters_AdapterSize)(0),                // 0: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.AdapterSize
	(SupervisedTuningSpec_TuningMode)(0),                      // 1: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode
	(*TuningJob)(nil),                                         // 2: google.cloud.aiplatform.v1beta1.TuningJob
	(*TunedModel)(nil),                                        // 3: google.cloud.aiplatform.v1beta1.TunedModel
	(*SupervisedTuningDatasetDistribution)(nil),               // 4: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	(*SupervisedTuningDataStats)(nil),                         // 5: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats
	(*DatasetDistribution)(nil),                               // 6: google.cloud.aiplatform.v1beta1.DatasetDistribution
	(*DatasetStats)(nil),                                      // 7: google.cloud.aiplatform.v1beta1.DatasetStats
	(*DistillationDataStats)(nil),                             // 8: google.cloud.aiplatform.v1beta1.DistillationDataStats
	(*TuningDataStats)(nil),                                   // 9: google.cloud.aiplatform.v1beta1.TuningDataStats
	(*SupervisedHyperParameters)(nil),                         // 10: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters
	(*SupervisedTuningSpec)(nil),                              // 11: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec
	(*DistillationSpec)(nil),                                  // 12: google.cloud.aiplatform.v1beta1.DistillationSpec
	(*DistillationHyperParameters)(nil),                       // 13: google.cloud.aiplatform.v1beta1.DistillationHyperParameters
	(*PartnerModelTuningSpec)(nil),                            // 14: google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec
	(*TunedModelRef)(nil),                                     // 15: google.cloud.aiplatform.v1beta1.TunedModelRef
	(*TunedModelCheckpoint)(nil),                              // 16: google.cloud.aiplatform.v1beta1.TunedModelCheckpoint
	nil,                                                       // 17: google.cloud.aiplatform.v1beta1.TuningJob.LabelsEntry
	(*SupervisedTuningDatasetDistribution_DatasetBucket)(nil), // 18: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.DatasetBucket
	(*DatasetDistribution_DistributionBucket)(nil),            // 19: google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
	nil,                           // 20: google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.HyperParametersEntry
	(JobState)(0),                 // 21: google.cloud.aiplatform.v1beta1.JobState
	(*timestamppb.Timestamp)(nil), // 22: google.protobuf.Timestamp
	(*status.Status)(nil),         // 23: google.rpc.Status
	(*EncryptionSpec)(nil),        // 24: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*Content)(nil),               // 25: google.cloud.aiplatform.v1beta1.Content
	(*structpb.Value)(nil),        // 26: google.protobuf.Value
}
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs = []int32{
	11, // 0: google.cloud.aiplatform.v1beta1.TuningJob.supervised_tuning_spec:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningSpec
	12, // 1: google.cloud.aiplatform.v1beta1.TuningJob.distillation_spec:type_name -> google.cloud.aiplatform.v1beta1.DistillationSpec
	14, // 2: google.cloud.aiplatform.v1beta1.TuningJob.partner_model_tuning_spec:type_name -> google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec
	21, // 3: google.cloud.aiplatform.v1beta1.TuningJob.state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	22, // 4: google.cloud.aiplatform.v1beta1.TuningJob.create_time:type_name -> google.protobuf.Timestamp
	22, // 5: google.cloud.aiplatform.v1beta1.TuningJob.start_time:type_name -> google.protobuf.Timestamp
	22, // 6: google.cloud.aiplatform.v1beta1.TuningJob.end_time:type_name -> google.protobuf.Timestamp
	22, // 7: google.cloud.aiplatform.v1beta1.TuningJob.update_time:type_name -> google.protobuf.Timestamp
	23, // 8: google.cloud.aiplatform.v1beta1.TuningJob.error:type_name -> google.rpc.Status
	17, // 9: google.cloud.aiplatform.v1beta1.TuningJob.labels:type_name -> google.cloud.aiplatform.v1beta1.TuningJob.LabelsEntry
	3,  // 10: google.cloud.aiplatform.v1beta1.TuningJob.tuned_model:type_name -> google.cloud.aiplatform.v1beta1.TunedModel
	9,  // 11: google.cloud.aiplatform.v1beta1.TuningJob.tuning_data_stats:type_name -> google.cloud.aiplatform.v1beta1.TuningDataStats
	24, // 12: google.cloud.aiplatform.v1beta1.TuningJob.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	16, // 13: google.cloud.aiplatform.v1beta1.TunedModel.checkpoints:type_name -> google.cloud.aiplatform.v1beta1.TunedModelCheckpoint
	18, // 14: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.buckets:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.DatasetBucket
	4,  // 15: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_input_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	4,  // 16: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_output_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	4,  // 17: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_message_per_example_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	25, // 18: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_dataset_examples:type_name -> google.cloud.aiplatform.v1beta1.Content
	19, // 19: google.cloud.aiplatform.v1beta1.DatasetDistribution.buckets:type_name -> google.cloud.aiplatform.v1beta1.DatasetDistribution.DistributionBucket
	6,  // 20: google.cloud.aiplatform.v1beta1.DatasetStats.user_input_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.DatasetDistribution
	6,  // 21: google.cloud.aiplatform.v1beta1.DatasetStats.user_output_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.DatasetDistribution
	6,  // 22: google.cloud.aiplatform.v1beta1.DatasetStats.user_message_per_example_distribution:type_name -> google.cloud.aiplatform.v1beta1.DatasetDistribution
	25, // 23: google.cloud.aiplatform.v1beta1.DatasetStats.user_dataset_examples:type_name -> google.cloud.aiplatform.v1beta1.Content
	7,  // 24: google.cloud.aiplatform.v1beta1.DistillationDataStats.training_dataset_stats:type_name -> google.cloud.aiplatform.v1beta1.DatasetStats
	5,  // 25: google.cloud.aiplatform.v1beta1.TuningDataStats.supervised_tuning_data_stats:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats
	8,  // 26: google.cloud.aiplatform.v1beta1.TuningDataStats.distillation_data_stats:type_name -> google.cloud.aiplatform.v1beta1.DistillationDataStats
	0,  // 27: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.adapter_size:type_name -> google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.AdapterSize
	10, // 28: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.hyper_parameters:type_name -> google.cloud.aiplatform.v1beta1.SupervisedHyperParameters
	1,  // 29: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.tuning_mode:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode
	13, // 30: google.cloud.aiplatform.v1beta1.DistillationSpec.hyper_parameters:type_name -> google.cloud.aiplatform.v1beta1.DistillationHyperParameters
	0,  // 31: google.cloud.aiplatform.v1beta1.DistillationHyperParameters.adapter_size:type_name -> google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.AdapterSize
	20, // 32: google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.hyper_parameters:type_name -> google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.HyperParametersEntry
	26, // 33: google.cloud.aiplatform.v1beta1.PartnerModelTuningSpec.HyperParametersEntry.value:type_name -> google.protobuf.Value
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_tuning_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_tuning_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_tuning_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0].OneofWrappers = []any{
		(*TuningJob_BaseModel)(nil),
		(*TuningJob_SupervisedTuningSpec)(nil),
		(*TuningJob_DistillationSpec)(nil),
		(*TuningJob_PartnerModelTuningSpec)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[7].OneofWrappers = []any{
		(*TuningDataStats_SupervisedTuningDataStats)(nil),
		(*TuningDataStats_DistillationDataStats)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[10].OneofWrappers = []any{
		(*DistillationSpec_BaseTeacherModel)(nil),
		(*DistillationSpec_TunedTeacherModelSource)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[11].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[13].OneofWrappers = []any{
		(*TunedModelRef_TunedModel)(nil),
		(*TunedModelRef_TuningJob)(nil),
		(*TunedModelRef_PipelineJob)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_tuning_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs = nil
}
