// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/reasoning_engine_service.proto

package aiplatformpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ReasoningEngineService_CreateReasoningEngine_FullMethodName = "/google.cloud.aiplatform.v1.ReasoningEngineService/CreateReasoningEngine"
	ReasoningEngineService_GetReasoningEngine_FullMethodName    = "/google.cloud.aiplatform.v1.ReasoningEngineService/GetReasoningEngine"
	ReasoningEngineService_ListReasoningEngines_FullMethodName  = "/google.cloud.aiplatform.v1.ReasoningEngineService/ListReasoningEngines"
	ReasoningEngineService_UpdateReasoningEngine_FullMethodName = "/google.cloud.aiplatform.v1.ReasoningEngineService/UpdateReasoningEngine"
	ReasoningEngineService_DeleteReasoningEngine_FullMethodName = "/google.cloud.aiplatform.v1.ReasoningEngineService/DeleteReasoningEngine"
)

// ReasoningEngineServiceClient is the client API for ReasoningEngineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReasoningEngineServiceClient interface {
	// Creates a reasoning engine.
	CreateReasoningEngine(ctx context.Context, in *CreateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a reasoning engine.
	GetReasoningEngine(ctx context.Context, in *GetReasoningEngineRequest, opts ...grpc.CallOption) (*ReasoningEngine, error)
	// Lists reasoning engines in a location.
	ListReasoningEngines(ctx context.Context, in *ListReasoningEnginesRequest, opts ...grpc.CallOption) (*ListReasoningEnginesResponse, error)
	// Updates a reasoning engine.
	UpdateReasoningEngine(ctx context.Context, in *UpdateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a reasoning engine.
	DeleteReasoningEngine(ctx context.Context, in *DeleteReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type reasoningEngineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReasoningEngineServiceClient(cc grpc.ClientConnInterface) ReasoningEngineServiceClient {
	return &reasoningEngineServiceClient{cc}
}

func (c *reasoningEngineServiceClient) CreateReasoningEngine(ctx context.Context, in *CreateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReasoningEngineService_CreateReasoningEngine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) GetReasoningEngine(ctx context.Context, in *GetReasoningEngineRequest, opts ...grpc.CallOption) (*ReasoningEngine, error) {
	out := new(ReasoningEngine)
	err := c.cc.Invoke(ctx, ReasoningEngineService_GetReasoningEngine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) ListReasoningEngines(ctx context.Context, in *ListReasoningEnginesRequest, opts ...grpc.CallOption) (*ListReasoningEnginesResponse, error) {
	out := new(ListReasoningEnginesResponse)
	err := c.cc.Invoke(ctx, ReasoningEngineService_ListReasoningEngines_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) UpdateReasoningEngine(ctx context.Context, in *UpdateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReasoningEngineService_UpdateReasoningEngine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) DeleteReasoningEngine(ctx context.Context, in *DeleteReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ReasoningEngineService_DeleteReasoningEngine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReasoningEngineServiceServer is the server API for ReasoningEngineService service.
// All implementations should embed UnimplementedReasoningEngineServiceServer
// for forward compatibility
type ReasoningEngineServiceServer interface {
	// Creates a reasoning engine.
	CreateReasoningEngine(context.Context, *CreateReasoningEngineRequest) (*longrunningpb.Operation, error)
	// Gets a reasoning engine.
	GetReasoningEngine(context.Context, *GetReasoningEngineRequest) (*ReasoningEngine, error)
	// Lists reasoning engines in a location.
	ListReasoningEngines(context.Context, *ListReasoningEnginesRequest) (*ListReasoningEnginesResponse, error)
	// Updates a reasoning engine.
	UpdateReasoningEngine(context.Context, *UpdateReasoningEngineRequest) (*longrunningpb.Operation, error)
	// Deletes a reasoning engine.
	DeleteReasoningEngine(context.Context, *DeleteReasoningEngineRequest) (*longrunningpb.Operation, error)
}

// UnimplementedReasoningEngineServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReasoningEngineServiceServer struct {
}

func (UnimplementedReasoningEngineServiceServer) CreateReasoningEngine(context.Context, *CreateReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReasoningEngine not implemented")
}
func (UnimplementedReasoningEngineServiceServer) GetReasoningEngine(context.Context, *GetReasoningEngineRequest) (*ReasoningEngine, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReasoningEngine not implemented")
}
func (UnimplementedReasoningEngineServiceServer) ListReasoningEngines(context.Context, *ListReasoningEnginesRequest) (*ListReasoningEnginesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReasoningEngines not implemented")
}
func (UnimplementedReasoningEngineServiceServer) UpdateReasoningEngine(context.Context, *UpdateReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReasoningEngine not implemented")
}
func (UnimplementedReasoningEngineServiceServer) DeleteReasoningEngine(context.Context, *DeleteReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReasoningEngine not implemented")
}

// UnsafeReasoningEngineServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReasoningEngineServiceServer will
// result in compilation errors.
type UnsafeReasoningEngineServiceServer interface {
	mustEmbedUnimplementedReasoningEngineServiceServer()
}

func RegisterReasoningEngineServiceServer(s grpc.ServiceRegistrar, srv ReasoningEngineServiceServer) {
	s.RegisterService(&ReasoningEngineService_ServiceDesc, srv)
}

func _ReasoningEngineService_CreateReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).CreateReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineService_CreateReasoningEngine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).CreateReasoningEngine(ctx, req.(*CreateReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_GetReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).GetReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineService_GetReasoningEngine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).GetReasoningEngine(ctx, req.(*GetReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_ListReasoningEngines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReasoningEnginesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).ListReasoningEngines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineService_ListReasoningEngines_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).ListReasoningEngines(ctx, req.(*ListReasoningEnginesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_UpdateReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).UpdateReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineService_UpdateReasoningEngine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).UpdateReasoningEngine(ctx, req.(*UpdateReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_DeleteReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).DeleteReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineService_DeleteReasoningEngine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).DeleteReasoningEngine(ctx, req.(*DeleteReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReasoningEngineService_ServiceDesc is the grpc.ServiceDesc for ReasoningEngineService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReasoningEngineService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.ReasoningEngineService",
	HandlerType: (*ReasoningEngineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReasoningEngine",
			Handler:    _ReasoningEngineService_CreateReasoningEngine_Handler,
		},
		{
			MethodName: "GetReasoningEngine",
			Handler:    _ReasoningEngineService_GetReasoningEngine_Handler,
		},
		{
			MethodName: "ListReasoningEngines",
			Handler:    _ReasoningEngineService_ListReasoningEngines_Handler,
		},
		{
			MethodName: "UpdateReasoningEngine",
			Handler:    _ReasoningEngineService_UpdateReasoningEngine_Handler,
		},
		{
			MethodName: "DeleteReasoningEngine",
			Handler:    _ReasoningEngineService_DeleteReasoningEngine_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/reasoning_engine_service.proto",
}
