// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/accessapproval/v1/accessapproval.proto

package accessapprovalpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AccessApproval_ListApprovalRequests_FullMethodName            = "/google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests"
	AccessApproval_GetApprovalRequest_FullMethodName              = "/google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest"
	AccessApproval_ApproveApprovalRequest_FullMethodName          = "/google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest"
	AccessApproval_DismissApprovalRequest_FullMethodName          = "/google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest"
	AccessApproval_InvalidateApprovalRequest_FullMethodName       = "/google.cloud.accessapproval.v1.AccessApproval/InvalidateApprovalRequest"
	AccessApproval_GetAccessApprovalSettings_FullMethodName       = "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings"
	AccessApproval_UpdateAccessApprovalSettings_FullMethodName    = "/google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings"
	AccessApproval_DeleteAccessApprovalSettings_FullMethodName    = "/google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings"
	AccessApproval_GetAccessApprovalServiceAccount_FullMethodName = "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalServiceAccount"
)

// AccessApprovalClient is the client API for AccessApproval service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AccessApprovalClient interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Invalidates an existing ApprovalRequest. Returns the updated
	// ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It only invalidates a single approval.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in an approved
	// state.
	InvalidateApprovalRequest(ctx context.Context, in *InvalidateApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Retrieves the service account that is used by Access Approval to access KMS
	// keys for signing approved approval requests.
	GetAccessApprovalServiceAccount(ctx context.Context, in *GetAccessApprovalServiceAccountMessage, opts ...grpc.CallOption) (*AccessApprovalServiceAccount, error)
}

type accessApprovalClient struct {
	cc grpc.ClientConnInterface
}

func NewAccessApprovalClient(cc grpc.ClientConnInterface) AccessApprovalClient {
	return &accessApprovalClient{cc}
}

func (c *accessApprovalClient) ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error) {
	out := new(ListApprovalRequestsResponse)
	err := c.cc.Invoke(ctx, AccessApproval_ListApprovalRequests_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, AccessApproval_GetApprovalRequest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, AccessApproval_ApproveApprovalRequest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, AccessApproval_DismissApprovalRequest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) InvalidateApprovalRequest(ctx context.Context, in *InvalidateApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, AccessApproval_InvalidateApprovalRequest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, AccessApproval_GetAccessApprovalSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, AccessApproval_UpdateAccessApprovalSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AccessApproval_DeleteAccessApprovalSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetAccessApprovalServiceAccount(ctx context.Context, in *GetAccessApprovalServiceAccountMessage, opts ...grpc.CallOption) (*AccessApprovalServiceAccount, error) {
	out := new(AccessApprovalServiceAccount)
	err := c.cc.Invoke(ctx, AccessApproval_GetAccessApprovalServiceAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccessApprovalServer is the server API for AccessApproval service.
// All implementations should embed UnimplementedAccessApprovalServer
// for forward compatibility
type AccessApprovalServer interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(context.Context, *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(context.Context, *GetApprovalRequestMessage) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(context.Context, *ApproveApprovalRequestMessage) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(context.Context, *DismissApprovalRequestMessage) (*ApprovalRequest, error)
	// Invalidates an existing ApprovalRequest. Returns the updated
	// ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It only invalidates a single approval.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in an approved
	// state.
	InvalidateApprovalRequest(context.Context, *InvalidateApprovalRequestMessage) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(context.Context, *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(context.Context, *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(context.Context, *DeleteAccessApprovalSettingsMessage) (*emptypb.Empty, error)
	// Retrieves the service account that is used by Access Approval to access KMS
	// keys for signing approved approval requests.
	GetAccessApprovalServiceAccount(context.Context, *GetAccessApprovalServiceAccountMessage) (*AccessApprovalServiceAccount, error)
}

// UnimplementedAccessApprovalServer should be embedded to have forward compatible implementations.
type UnimplementedAccessApprovalServer struct {
}

func (UnimplementedAccessApprovalServer) ListApprovalRequests(context.Context, *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApprovalRequests not implemented")
}
func (UnimplementedAccessApprovalServer) GetApprovalRequest(context.Context, *GetApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApprovalRequest not implemented")
}
func (UnimplementedAccessApprovalServer) ApproveApprovalRequest(context.Context, *ApproveApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveApprovalRequest not implemented")
}
func (UnimplementedAccessApprovalServer) DismissApprovalRequest(context.Context, *DismissApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DismissApprovalRequest not implemented")
}
func (UnimplementedAccessApprovalServer) InvalidateApprovalRequest(context.Context, *InvalidateApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InvalidateApprovalRequest not implemented")
}
func (UnimplementedAccessApprovalServer) GetAccessApprovalSettings(context.Context, *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessApprovalSettings not implemented")
}
func (UnimplementedAccessApprovalServer) UpdateAccessApprovalSettings(context.Context, *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessApprovalSettings not implemented")
}
func (UnimplementedAccessApprovalServer) DeleteAccessApprovalSettings(context.Context, *DeleteAccessApprovalSettingsMessage) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessApprovalSettings not implemented")
}
func (UnimplementedAccessApprovalServer) GetAccessApprovalServiceAccount(context.Context, *GetAccessApprovalServiceAccountMessage) (*AccessApprovalServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessApprovalServiceAccount not implemented")
}

// UnsafeAccessApprovalServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AccessApprovalServer will
// result in compilation errors.
type UnsafeAccessApprovalServer interface {
	mustEmbedUnimplementedAccessApprovalServer()
}

func RegisterAccessApprovalServer(s grpc.ServiceRegistrar, srv AccessApprovalServer) {
	s.RegisterService(&AccessApproval_ServiceDesc, srv)
}

func _AccessApproval_ListApprovalRequests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApprovalRequestsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_ListApprovalRequests_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, req.(*ListApprovalRequestsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_GetApprovalRequest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, req.(*GetApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_ApproveApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_ApproveApprovalRequest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, req.(*ApproveApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DismissApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_DismissApprovalRequest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, req.(*DismissApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_InvalidateApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InvalidateApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).InvalidateApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_InvalidateApprovalRequest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).InvalidateApprovalRequest(ctx, req.(*InvalidateApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_GetAccessApprovalSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, req.(*GetAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_UpdateAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_UpdateAccessApprovalSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, req.(*UpdateAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DeleteAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_DeleteAccessApprovalSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, req.(*DeleteAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetAccessApprovalServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessApprovalServiceAccountMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetAccessApprovalServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessApproval_GetAccessApprovalServiceAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetAccessApprovalServiceAccount(ctx, req.(*GetAccessApprovalServiceAccountMessage))
	}
	return interceptor(ctx, in, info, handler)
}

// AccessApproval_ServiceDesc is the grpc.ServiceDesc for AccessApproval service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AccessApproval_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.accessapproval.v1.AccessApproval",
	HandlerType: (*AccessApprovalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListApprovalRequests",
			Handler:    _AccessApproval_ListApprovalRequests_Handler,
		},
		{
			MethodName: "GetApprovalRequest",
			Handler:    _AccessApproval_GetApprovalRequest_Handler,
		},
		{
			MethodName: "ApproveApprovalRequest",
			Handler:    _AccessApproval_ApproveApprovalRequest_Handler,
		},
		{
			MethodName: "DismissApprovalRequest",
			Handler:    _AccessApproval_DismissApprovalRequest_Handler,
		},
		{
			MethodName: "InvalidateApprovalRequest",
			Handler:    _AccessApproval_InvalidateApprovalRequest_Handler,
		},
		{
			MethodName: "GetAccessApprovalSettings",
			Handler:    _AccessApproval_GetAccessApprovalSettings_Handler,
		},
		{
			MethodName: "UpdateAccessApprovalSettings",
			Handler:    _AccessApproval_UpdateAccessApprovalSettings_Handler,
		},
		{
			MethodName: "DeleteAccessApprovalSettings",
			Handler:    _AccessApproval_DeleteAccessApprovalSettings_Handler,
		},
		{
			MethodName: "GetAccessApprovalServiceAccount",
			Handler:    _AccessApproval_GetAccessApprovalServiceAccount_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/accessapproval/v1/accessapproval.proto",
}
