// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networksecurity/v1beta1/dns_threat_detector.proto

package networksecuritypb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DnsThreatDetectorService_ListDnsThreatDetectors_FullMethodName  = "/google.cloud.networksecurity.v1beta1.DnsThreatDetectorService/ListDnsThreatDetectors"
	DnsThreatDetectorService_GetDnsThreatDetector_FullMethodName    = "/google.cloud.networksecurity.v1beta1.DnsThreatDetectorService/GetDnsThreatDetector"
	DnsThreatDetectorService_CreateDnsThreatDetector_FullMethodName = "/google.cloud.networksecurity.v1beta1.DnsThreatDetectorService/CreateDnsThreatDetector"
	DnsThreatDetectorService_UpdateDnsThreatDetector_FullMethodName = "/google.cloud.networksecurity.v1beta1.DnsThreatDetectorService/UpdateDnsThreatDetector"
	DnsThreatDetectorService_DeleteDnsThreatDetector_FullMethodName = "/google.cloud.networksecurity.v1beta1.DnsThreatDetectorService/DeleteDnsThreatDetector"
)

// DnsThreatDetectorServiceClient is the client API for DnsThreatDetectorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DnsThreatDetectorServiceClient interface {
	// Lists DnsThreatDetectors in a given project and location.
	ListDnsThreatDetectors(ctx context.Context, in *ListDnsThreatDetectorsRequest, opts ...grpc.CallOption) (*ListDnsThreatDetectorsResponse, error)
	// Gets the details of a single DnsThreatDetector.
	GetDnsThreatDetector(ctx context.Context, in *GetDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error)
	// Creates a new DnsThreatDetector in a given project and location.
	CreateDnsThreatDetector(ctx context.Context, in *CreateDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error)
	// Updates a single DnsThreatDetector.
	UpdateDnsThreatDetector(ctx context.Context, in *UpdateDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error)
	// Deletes a single DnsThreatDetector.
	DeleteDnsThreatDetector(ctx context.Context, in *DeleteDnsThreatDetectorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type dnsThreatDetectorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDnsThreatDetectorServiceClient(cc grpc.ClientConnInterface) DnsThreatDetectorServiceClient {
	return &dnsThreatDetectorServiceClient{cc}
}

func (c *dnsThreatDetectorServiceClient) ListDnsThreatDetectors(ctx context.Context, in *ListDnsThreatDetectorsRequest, opts ...grpc.CallOption) (*ListDnsThreatDetectorsResponse, error) {
	out := new(ListDnsThreatDetectorsResponse)
	err := c.cc.Invoke(ctx, DnsThreatDetectorService_ListDnsThreatDetectors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dnsThreatDetectorServiceClient) GetDnsThreatDetector(ctx context.Context, in *GetDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error) {
	out := new(DnsThreatDetector)
	err := c.cc.Invoke(ctx, DnsThreatDetectorService_GetDnsThreatDetector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dnsThreatDetectorServiceClient) CreateDnsThreatDetector(ctx context.Context, in *CreateDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error) {
	out := new(DnsThreatDetector)
	err := c.cc.Invoke(ctx, DnsThreatDetectorService_CreateDnsThreatDetector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dnsThreatDetectorServiceClient) UpdateDnsThreatDetector(ctx context.Context, in *UpdateDnsThreatDetectorRequest, opts ...grpc.CallOption) (*DnsThreatDetector, error) {
	out := new(DnsThreatDetector)
	err := c.cc.Invoke(ctx, DnsThreatDetectorService_UpdateDnsThreatDetector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dnsThreatDetectorServiceClient) DeleteDnsThreatDetector(ctx context.Context, in *DeleteDnsThreatDetectorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DnsThreatDetectorService_DeleteDnsThreatDetector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DnsThreatDetectorServiceServer is the server API for DnsThreatDetectorService service.
// All implementations should embed UnimplementedDnsThreatDetectorServiceServer
// for forward compatibility
type DnsThreatDetectorServiceServer interface {
	// Lists DnsThreatDetectors in a given project and location.
	ListDnsThreatDetectors(context.Context, *ListDnsThreatDetectorsRequest) (*ListDnsThreatDetectorsResponse, error)
	// Gets the details of a single DnsThreatDetector.
	GetDnsThreatDetector(context.Context, *GetDnsThreatDetectorRequest) (*DnsThreatDetector, error)
	// Creates a new DnsThreatDetector in a given project and location.
	CreateDnsThreatDetector(context.Context, *CreateDnsThreatDetectorRequest) (*DnsThreatDetector, error)
	// Updates a single DnsThreatDetector.
	UpdateDnsThreatDetector(context.Context, *UpdateDnsThreatDetectorRequest) (*DnsThreatDetector, error)
	// Deletes a single DnsThreatDetector.
	DeleteDnsThreatDetector(context.Context, *DeleteDnsThreatDetectorRequest) (*emptypb.Empty, error)
}

// UnimplementedDnsThreatDetectorServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDnsThreatDetectorServiceServer struct {
}

func (UnimplementedDnsThreatDetectorServiceServer) ListDnsThreatDetectors(context.Context, *ListDnsThreatDetectorsRequest) (*ListDnsThreatDetectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDnsThreatDetectors not implemented")
}
func (UnimplementedDnsThreatDetectorServiceServer) GetDnsThreatDetector(context.Context, *GetDnsThreatDetectorRequest) (*DnsThreatDetector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDnsThreatDetector not implemented")
}
func (UnimplementedDnsThreatDetectorServiceServer) CreateDnsThreatDetector(context.Context, *CreateDnsThreatDetectorRequest) (*DnsThreatDetector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDnsThreatDetector not implemented")
}
func (UnimplementedDnsThreatDetectorServiceServer) UpdateDnsThreatDetector(context.Context, *UpdateDnsThreatDetectorRequest) (*DnsThreatDetector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDnsThreatDetector not implemented")
}
func (UnimplementedDnsThreatDetectorServiceServer) DeleteDnsThreatDetector(context.Context, *DeleteDnsThreatDetectorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDnsThreatDetector not implemented")
}

// UnsafeDnsThreatDetectorServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DnsThreatDetectorServiceServer will
// result in compilation errors.
type UnsafeDnsThreatDetectorServiceServer interface {
	mustEmbedUnimplementedDnsThreatDetectorServiceServer()
}

func RegisterDnsThreatDetectorServiceServer(s grpc.ServiceRegistrar, srv DnsThreatDetectorServiceServer) {
	s.RegisterService(&DnsThreatDetectorService_ServiceDesc, srv)
}

func _DnsThreatDetectorService_ListDnsThreatDetectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDnsThreatDetectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DnsThreatDetectorServiceServer).ListDnsThreatDetectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DnsThreatDetectorService_ListDnsThreatDetectors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DnsThreatDetectorServiceServer).ListDnsThreatDetectors(ctx, req.(*ListDnsThreatDetectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DnsThreatDetectorService_GetDnsThreatDetector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDnsThreatDetectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DnsThreatDetectorServiceServer).GetDnsThreatDetector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DnsThreatDetectorService_GetDnsThreatDetector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DnsThreatDetectorServiceServer).GetDnsThreatDetector(ctx, req.(*GetDnsThreatDetectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DnsThreatDetectorService_CreateDnsThreatDetector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDnsThreatDetectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DnsThreatDetectorServiceServer).CreateDnsThreatDetector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DnsThreatDetectorService_CreateDnsThreatDetector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DnsThreatDetectorServiceServer).CreateDnsThreatDetector(ctx, req.(*CreateDnsThreatDetectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DnsThreatDetectorService_UpdateDnsThreatDetector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDnsThreatDetectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DnsThreatDetectorServiceServer).UpdateDnsThreatDetector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DnsThreatDetectorService_UpdateDnsThreatDetector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DnsThreatDetectorServiceServer).UpdateDnsThreatDetector(ctx, req.(*UpdateDnsThreatDetectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DnsThreatDetectorService_DeleteDnsThreatDetector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDnsThreatDetectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DnsThreatDetectorServiceServer).DeleteDnsThreatDetector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DnsThreatDetectorService_DeleteDnsThreatDetector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DnsThreatDetectorServiceServer).DeleteDnsThreatDetector(ctx, req.(*DeleteDnsThreatDetectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DnsThreatDetectorService_ServiceDesc is the grpc.ServiceDesc for DnsThreatDetectorService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DnsThreatDetectorService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networksecurity.v1beta1.DnsThreatDetectorService",
	HandlerType: (*DnsThreatDetectorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDnsThreatDetectors",
			Handler:    _DnsThreatDetectorService_ListDnsThreatDetectors_Handler,
		},
		{
			MethodName: "GetDnsThreatDetector",
			Handler:    _DnsThreatDetectorService_GetDnsThreatDetector_Handler,
		},
		{
			MethodName: "CreateDnsThreatDetector",
			Handler:    _DnsThreatDetectorService_CreateDnsThreatDetector_Handler,
		},
		{
			MethodName: "UpdateDnsThreatDetector",
			Handler:    _DnsThreatDetectorService_UpdateDnsThreatDetector_Handler,
		},
		{
			MethodName: "DeleteDnsThreatDetector",
			Handler:    _DnsThreatDetectorService_DeleteDnsThreatDetector_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networksecurity/v1beta1/dns_threat_detector.proto",
}
