// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatenetworks

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcknowledgeOrderReceipt = "AcknowledgeOrderReceipt"

// AcknowledgeOrderReceiptRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeOrderReceipt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeOrderReceipt for more information on using the AcknowledgeOrderReceipt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcknowledgeOrderReceiptRequest method.
//	req, resp := client.AcknowledgeOrderReceiptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt
func (c *PrivateNetworks) AcknowledgeOrderReceiptRequest(input *AcknowledgeOrderReceiptInput) (req *request.Request, output *AcknowledgeOrderReceiptOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeOrderReceipt,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/orders/acknowledge",
	}

	if input == nil {
		input = &AcknowledgeOrderReceiptInput{}
	}

	output = &AcknowledgeOrderReceiptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcknowledgeOrderReceipt API operation for AWS Private 5G.
//
// Acknowledges that the specified network order was received.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation AcknowledgeOrderReceipt for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt
func (c *PrivateNetworks) AcknowledgeOrderReceipt(input *AcknowledgeOrderReceiptInput) (*AcknowledgeOrderReceiptOutput, error) {
	req, out := c.AcknowledgeOrderReceiptRequest(input)
	return out, req.Send()
}

// AcknowledgeOrderReceiptWithContext is the same as AcknowledgeOrderReceipt with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeOrderReceipt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) AcknowledgeOrderReceiptWithContext(ctx aws.Context, input *AcknowledgeOrderReceiptInput, opts ...request.Option) (*AcknowledgeOrderReceiptOutput, error) {
	req, out := c.AcknowledgeOrderReceiptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateDeviceIdentifier = "ActivateDeviceIdentifier"

// ActivateDeviceIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the ActivateDeviceIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateDeviceIdentifier for more information on using the ActivateDeviceIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateDeviceIdentifierRequest method.
//	req, resp := client.ActivateDeviceIdentifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier
func (c *PrivateNetworks) ActivateDeviceIdentifierRequest(input *ActivateDeviceIdentifierInput) (req *request.Request, output *ActivateDeviceIdentifierOutput) {
	op := &request.Operation{
		Name:       opActivateDeviceIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/device-identifiers/activate",
	}

	if input == nil {
		input = &ActivateDeviceIdentifierInput{}
	}

	output = &ActivateDeviceIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateDeviceIdentifier API operation for AWS Private 5G.
//
// Activates the specified device identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ActivateDeviceIdentifier for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier
func (c *PrivateNetworks) ActivateDeviceIdentifier(input *ActivateDeviceIdentifierInput) (*ActivateDeviceIdentifierOutput, error) {
	req, out := c.ActivateDeviceIdentifierRequest(input)
	return out, req.Send()
}

// ActivateDeviceIdentifierWithContext is the same as ActivateDeviceIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateDeviceIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ActivateDeviceIdentifierWithContext(ctx aws.Context, input *ActivateDeviceIdentifierInput, opts ...request.Option) (*ActivateDeviceIdentifierOutput, error) {
	req, out := c.ActivateDeviceIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateNetworkSite = "ActivateNetworkSite"

// ActivateNetworkSiteRequest generates a "aws/request.Request" representing the
// client's request for the ActivateNetworkSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateNetworkSite for more information on using the ActivateNetworkSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateNetworkSiteRequest method.
//	req, resp := client.ActivateNetworkSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite
func (c *PrivateNetworks) ActivateNetworkSiteRequest(input *ActivateNetworkSiteInput) (req *request.Request, output *ActivateNetworkSiteOutput) {
	op := &request.Operation{
		Name:       opActivateNetworkSite,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-sites/activate",
	}

	if input == nil {
		input = &ActivateNetworkSiteInput{}
	}

	output = &ActivateNetworkSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateNetworkSite API operation for AWS Private 5G.
//
// Activates the specified network site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ActivateNetworkSite for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite
func (c *PrivateNetworks) ActivateNetworkSite(input *ActivateNetworkSiteInput) (*ActivateNetworkSiteOutput, error) {
	req, out := c.ActivateNetworkSiteRequest(input)
	return out, req.Send()
}

// ActivateNetworkSiteWithContext is the same as ActivateNetworkSite with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateNetworkSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ActivateNetworkSiteWithContext(ctx aws.Context, input *ActivateNetworkSiteInput, opts ...request.Option) (*ActivateNetworkSiteOutput, error) {
	req, out := c.ActivateNetworkSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfigureAccessPoint = "ConfigureAccessPoint"

// ConfigureAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the ConfigureAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfigureAccessPoint for more information on using the ConfigureAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConfigureAccessPointRequest method.
//	req, resp := client.ConfigureAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint
func (c *PrivateNetworks) ConfigureAccessPointRequest(input *ConfigureAccessPointInput) (req *request.Request, output *ConfigureAccessPointOutput) {
	op := &request.Operation{
		Name:       opConfigureAccessPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-resources/configure",
	}

	if input == nil {
		input = &ConfigureAccessPointInput{}
	}

	output = &ConfigureAccessPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfigureAccessPoint API operation for AWS Private 5G.
//
// Configures the specified network resource.
//
// Use this action to specify the geographic position of the hardware. You must
// provide Certified Professional Installer (CPI) credentials in the request
// so that we can obtain spectrum grants. For more information, see Radio units
// (https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html)
// in the Amazon Web Services Private 5G User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ConfigureAccessPoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint
func (c *PrivateNetworks) ConfigureAccessPoint(input *ConfigureAccessPointInput) (*ConfigureAccessPointOutput, error) {
	req, out := c.ConfigureAccessPointRequest(input)
	return out, req.Send()
}

// ConfigureAccessPointWithContext is the same as ConfigureAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See ConfigureAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ConfigureAccessPointWithContext(ctx aws.Context, input *ConfigureAccessPointInput, opts ...request.Option) (*ConfigureAccessPointOutput, error) {
	req, out := c.ConfigureAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetwork = "CreateNetwork"

// CreateNetworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetwork for more information on using the CreateNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkRequest method.
//	req, resp := client.CreateNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork
func (c *PrivateNetworks) CreateNetworkRequest(input *CreateNetworkInput) (req *request.Request, output *CreateNetworkOutput) {
	op := &request.Operation{
		Name:       opCreateNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/networks",
	}

	if input == nil {
		input = &CreateNetworkInput{}
	}

	output = &CreateNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetwork API operation for AWS Private 5G.
//
// Creates a network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation CreateNetwork for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The limit was exceeded.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork
func (c *PrivateNetworks) CreateNetwork(input *CreateNetworkInput) (*CreateNetworkOutput, error) {
	req, out := c.CreateNetworkRequest(input)
	return out, req.Send()
}

// CreateNetworkWithContext is the same as CreateNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) CreateNetworkWithContext(ctx aws.Context, input *CreateNetworkInput, opts ...request.Option) (*CreateNetworkOutput, error) {
	req, out := c.CreateNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkSite = "CreateNetworkSite"

// CreateNetworkSiteRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkSite for more information on using the CreateNetworkSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkSiteRequest method.
//	req, resp := client.CreateNetworkSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite
func (c *PrivateNetworks) CreateNetworkSiteRequest(input *CreateNetworkSiteInput) (req *request.Request, output *CreateNetworkSiteOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkSite,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-sites",
	}

	if input == nil {
		input = &CreateNetworkSiteInput{}
	}

	output = &CreateNetworkSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkSite API operation for AWS Private 5G.
//
// Creates a network site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation CreateNetworkSite for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite
func (c *PrivateNetworks) CreateNetworkSite(input *CreateNetworkSiteInput) (*CreateNetworkSiteOutput, error) {
	req, out := c.CreateNetworkSiteRequest(input)
	return out, req.Send()
}

// CreateNetworkSiteWithContext is the same as CreateNetworkSite with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) CreateNetworkSiteWithContext(ctx aws.Context, input *CreateNetworkSiteInput, opts ...request.Option) (*CreateNetworkSiteOutput, error) {
	req, out := c.CreateNetworkSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateDeviceIdentifier = "DeactivateDeviceIdentifier"

// DeactivateDeviceIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateDeviceIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateDeviceIdentifier for more information on using the DeactivateDeviceIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateDeviceIdentifierRequest method.
//	req, resp := client.DeactivateDeviceIdentifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier
func (c *PrivateNetworks) DeactivateDeviceIdentifierRequest(input *DeactivateDeviceIdentifierInput) (req *request.Request, output *DeactivateDeviceIdentifierOutput) {
	op := &request.Operation{
		Name:       opDeactivateDeviceIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/device-identifiers/deactivate",
	}

	if input == nil {
		input = &DeactivateDeviceIdentifierInput{}
	}

	output = &DeactivateDeviceIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeactivateDeviceIdentifier API operation for AWS Private 5G.
//
// Deactivates the specified device identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation DeactivateDeviceIdentifier for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier
func (c *PrivateNetworks) DeactivateDeviceIdentifier(input *DeactivateDeviceIdentifierInput) (*DeactivateDeviceIdentifierOutput, error) {
	req, out := c.DeactivateDeviceIdentifierRequest(input)
	return out, req.Send()
}

// DeactivateDeviceIdentifierWithContext is the same as DeactivateDeviceIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateDeviceIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) DeactivateDeviceIdentifierWithContext(ctx aws.Context, input *DeactivateDeviceIdentifierInput, opts ...request.Option) (*DeactivateDeviceIdentifierOutput, error) {
	req, out := c.DeactivateDeviceIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetwork = "DeleteNetwork"

// DeleteNetworkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetwork for more information on using the DeleteNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkRequest method.
//	req, resp := client.DeleteNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork
func (c *PrivateNetworks) DeleteNetworkRequest(input *DeleteNetworkInput) (req *request.Request, output *DeleteNetworkOutput) {
	op := &request.Operation{
		Name:       opDeleteNetwork,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/networks/{networkArn}",
	}

	if input == nil {
		input = &DeleteNetworkInput{}
	}

	output = &DeleteNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetwork API operation for AWS Private 5G.
//
// Deletes the specified network. You must delete network sites before you delete
// the network. For more information, see DeleteNetworkSite (https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html)
// in the API Reference for Amazon Web Services Private 5G.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation DeleteNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     You do not have permission to perform this operation.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork
func (c *PrivateNetworks) DeleteNetwork(input *DeleteNetworkInput) (*DeleteNetworkOutput, error) {
	req, out := c.DeleteNetworkRequest(input)
	return out, req.Send()
}

// DeleteNetworkWithContext is the same as DeleteNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) DeleteNetworkWithContext(ctx aws.Context, input *DeleteNetworkInput, opts ...request.Option) (*DeleteNetworkOutput, error) {
	req, out := c.DeleteNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkSite = "DeleteNetworkSite"

// DeleteNetworkSiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkSite for more information on using the DeleteNetworkSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkSiteRequest method.
//	req, resp := client.DeleteNetworkSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite
func (c *PrivateNetworks) DeleteNetworkSiteRequest(input *DeleteNetworkSiteInput) (req *request.Request, output *DeleteNetworkSiteOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkSite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/network-sites/{networkSiteArn}",
	}

	if input == nil {
		input = &DeleteNetworkSiteInput{}
	}

	output = &DeleteNetworkSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkSite API operation for AWS Private 5G.
//
// Deletes the specified network site. Return the hardware after you delete
// the network site. You are responsible for minimum charges. For more information,
// see Hardware returns (https://docs.aws.amazon.com/private-networks/latest/userguide/hardware-maintenance.html)
// in the Amazon Web Services Private 5G User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation DeleteNetworkSite for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     You do not have permission to perform this operation.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite
func (c *PrivateNetworks) DeleteNetworkSite(input *DeleteNetworkSiteInput) (*DeleteNetworkSiteOutput, error) {
	req, out := c.DeleteNetworkSiteRequest(input)
	return out, req.Send()
}

// DeleteNetworkSiteWithContext is the same as DeleteNetworkSite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) DeleteNetworkSiteWithContext(ctx aws.Context, input *DeleteNetworkSiteInput, opts ...request.Option) (*DeleteNetworkSiteOutput, error) {
	req, out := c.DeleteNetworkSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceIdentifier = "GetDeviceIdentifier"

// GetDeviceIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceIdentifier for more information on using the GetDeviceIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeviceIdentifierRequest method.
//	req, resp := client.GetDeviceIdentifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier
func (c *PrivateNetworks) GetDeviceIdentifierRequest(input *GetDeviceIdentifierInput) (req *request.Request, output *GetDeviceIdentifierOutput) {
	op := &request.Operation{
		Name:       opGetDeviceIdentifier,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/device-identifiers/{deviceIdentifierArn}",
	}

	if input == nil {
		input = &GetDeviceIdentifierInput{}
	}

	output = &GetDeviceIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceIdentifier API operation for AWS Private 5G.
//
// Gets the specified device identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation GetDeviceIdentifier for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier
func (c *PrivateNetworks) GetDeviceIdentifier(input *GetDeviceIdentifierInput) (*GetDeviceIdentifierOutput, error) {
	req, out := c.GetDeviceIdentifierRequest(input)
	return out, req.Send()
}

// GetDeviceIdentifierWithContext is the same as GetDeviceIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) GetDeviceIdentifierWithContext(ctx aws.Context, input *GetDeviceIdentifierInput, opts ...request.Option) (*GetDeviceIdentifierOutput, error) {
	req, out := c.GetDeviceIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetwork = "GetNetwork"

// GetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the GetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetwork for more information on using the GetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNetworkRequest method.
//	req, resp := client.GetNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork
func (c *PrivateNetworks) GetNetworkRequest(input *GetNetworkInput) (req *request.Request, output *GetNetworkOutput) {
	op := &request.Operation{
		Name:       opGetNetwork,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/networks/{networkArn}",
	}

	if input == nil {
		input = &GetNetworkInput{}
	}

	output = &GetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetwork API operation for AWS Private 5G.
//
// Gets the specified network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation GetNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork
func (c *PrivateNetworks) GetNetwork(input *GetNetworkInput) (*GetNetworkOutput, error) {
	req, out := c.GetNetworkRequest(input)
	return out, req.Send()
}

// GetNetworkWithContext is the same as GetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) GetNetworkWithContext(ctx aws.Context, input *GetNetworkInput, opts ...request.Option) (*GetNetworkOutput, error) {
	req, out := c.GetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetworkResource = "GetNetworkResource"

// GetNetworkResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetNetworkResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetworkResource for more information on using the GetNetworkResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNetworkResourceRequest method.
//	req, resp := client.GetNetworkResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource
func (c *PrivateNetworks) GetNetworkResourceRequest(input *GetNetworkResourceInput) (req *request.Request, output *GetNetworkResourceOutput) {
	op := &request.Operation{
		Name:       opGetNetworkResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/network-resources/{networkResourceArn}",
	}

	if input == nil {
		input = &GetNetworkResourceInput{}
	}

	output = &GetNetworkResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetworkResource API operation for AWS Private 5G.
//
// Gets the specified network resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation GetNetworkResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource
func (c *PrivateNetworks) GetNetworkResource(input *GetNetworkResourceInput) (*GetNetworkResourceOutput, error) {
	req, out := c.GetNetworkResourceRequest(input)
	return out, req.Send()
}

// GetNetworkResourceWithContext is the same as GetNetworkResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetworkResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) GetNetworkResourceWithContext(ctx aws.Context, input *GetNetworkResourceInput, opts ...request.Option) (*GetNetworkResourceOutput, error) {
	req, out := c.GetNetworkResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetworkSite = "GetNetworkSite"

// GetNetworkSiteRequest generates a "aws/request.Request" representing the
// client's request for the GetNetworkSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetworkSite for more information on using the GetNetworkSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNetworkSiteRequest method.
//	req, resp := client.GetNetworkSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite
func (c *PrivateNetworks) GetNetworkSiteRequest(input *GetNetworkSiteInput) (req *request.Request, output *GetNetworkSiteOutput) {
	op := &request.Operation{
		Name:       opGetNetworkSite,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/network-sites/{networkSiteArn}",
	}

	if input == nil {
		input = &GetNetworkSiteInput{}
	}

	output = &GetNetworkSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetworkSite API operation for AWS Private 5G.
//
// Gets the specified network site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation GetNetworkSite for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite
func (c *PrivateNetworks) GetNetworkSite(input *GetNetworkSiteInput) (*GetNetworkSiteOutput, error) {
	req, out := c.GetNetworkSiteRequest(input)
	return out, req.Send()
}

// GetNetworkSiteWithContext is the same as GetNetworkSite with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetworkSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) GetNetworkSiteWithContext(ctx aws.Context, input *GetNetworkSiteInput, opts ...request.Option) (*GetNetworkSiteOutput, error) {
	req, out := c.GetNetworkSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOrder = "GetOrder"

// GetOrderRequest generates a "aws/request.Request" representing the
// client's request for the GetOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrder for more information on using the GetOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOrderRequest method.
//	req, resp := client.GetOrderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder
func (c *PrivateNetworks) GetOrderRequest(input *GetOrderInput) (req *request.Request, output *GetOrderOutput) {
	op := &request.Operation{
		Name:       opGetOrder,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/orders/{orderArn}",
	}

	if input == nil {
		input = &GetOrderInput{}
	}

	output = &GetOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrder API operation for AWS Private 5G.
//
// Gets the specified order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation GetOrder for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder
func (c *PrivateNetworks) GetOrder(input *GetOrderInput) (*GetOrderOutput, error) {
	req, out := c.GetOrderRequest(input)
	return out, req.Send()
}

// GetOrderWithContext is the same as GetOrder with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) GetOrderWithContext(ctx aws.Context, input *GetOrderInput, opts ...request.Option) (*GetOrderOutput, error) {
	req, out := c.GetOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceIdentifiers = "ListDeviceIdentifiers"

// ListDeviceIdentifiersRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceIdentifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceIdentifiers for more information on using the ListDeviceIdentifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeviceIdentifiersRequest method.
//	req, resp := client.ListDeviceIdentifiersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers
func (c *PrivateNetworks) ListDeviceIdentifiersRequest(input *ListDeviceIdentifiersInput) (req *request.Request, output *ListDeviceIdentifiersOutput) {
	op := &request.Operation{
		Name:       opListDeviceIdentifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/device-identifiers/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeviceIdentifiersInput{}
	}

	output = &ListDeviceIdentifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceIdentifiers API operation for AWS Private 5G.
//
// Lists device identifiers. Add filters to your request to return a more specific
// list of results. Use filters to match the Amazon Resource Name (ARN) of an
// order, the status of device identifiers, or the ARN of the traffic group.
//
// If you specify multiple filters, filters are joined with an OR, and the request
// returns results that match all of the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListDeviceIdentifiers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers
func (c *PrivateNetworks) ListDeviceIdentifiers(input *ListDeviceIdentifiersInput) (*ListDeviceIdentifiersOutput, error) {
	req, out := c.ListDeviceIdentifiersRequest(input)
	return out, req.Send()
}

// ListDeviceIdentifiersWithContext is the same as ListDeviceIdentifiers with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceIdentifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListDeviceIdentifiersWithContext(ctx aws.Context, input *ListDeviceIdentifiersInput, opts ...request.Option) (*ListDeviceIdentifiersOutput, error) {
	req, out := c.ListDeviceIdentifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeviceIdentifiersPages iterates over the pages of a ListDeviceIdentifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeviceIdentifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeviceIdentifiers operation.
//	pageNum := 0
//	err := client.ListDeviceIdentifiersPages(params,
//	    func(page *privatenetworks.ListDeviceIdentifiersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrivateNetworks) ListDeviceIdentifiersPages(input *ListDeviceIdentifiersInput, fn func(*ListDeviceIdentifiersOutput, bool) bool) error {
	return c.ListDeviceIdentifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeviceIdentifiersPagesWithContext same as ListDeviceIdentifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListDeviceIdentifiersPagesWithContext(ctx aws.Context, input *ListDeviceIdentifiersInput, fn func(*ListDeviceIdentifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeviceIdentifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeviceIdentifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeviceIdentifiersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworkResources = "ListNetworkResources"

// ListNetworkResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworkResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworkResources for more information on using the ListNetworkResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNetworkResourcesRequest method.
//	req, resp := client.ListNetworkResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources
func (c *PrivateNetworks) ListNetworkResourcesRequest(input *ListNetworkResourcesInput) (req *request.Request, output *ListNetworkResourcesOutput) {
	op := &request.Operation{
		Name:       opListNetworkResources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNetworkResourcesInput{}
	}

	output = &ListNetworkResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworkResources API operation for AWS Private 5G.
//
// Lists network resources. Add filters to your request to return a more specific
// list of results. Use filters to match the Amazon Resource Name (ARN) of an
// order or the status of network resources.
//
// If you specify multiple filters, filters are joined with an OR, and the request
// returns results that match all of the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListNetworkResources for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources
func (c *PrivateNetworks) ListNetworkResources(input *ListNetworkResourcesInput) (*ListNetworkResourcesOutput, error) {
	req, out := c.ListNetworkResourcesRequest(input)
	return out, req.Send()
}

// ListNetworkResourcesWithContext is the same as ListNetworkResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworkResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworkResourcesWithContext(ctx aws.Context, input *ListNetworkResourcesInput, opts ...request.Option) (*ListNetworkResourcesOutput, error) {
	req, out := c.ListNetworkResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNetworkResourcesPages iterates over the pages of a ListNetworkResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNetworkResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNetworkResources operation.
//	pageNum := 0
//	err := client.ListNetworkResourcesPages(params,
//	    func(page *privatenetworks.ListNetworkResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrivateNetworks) ListNetworkResourcesPages(input *ListNetworkResourcesInput, fn func(*ListNetworkResourcesOutput, bool) bool) error {
	return c.ListNetworkResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNetworkResourcesPagesWithContext same as ListNetworkResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworkResourcesPagesWithContext(ctx aws.Context, input *ListNetworkResourcesInput, fn func(*ListNetworkResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNetworkResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNetworkResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNetworkResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworkSites = "ListNetworkSites"

// ListNetworkSitesRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworkSites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworkSites for more information on using the ListNetworkSites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNetworkSitesRequest method.
//	req, resp := client.ListNetworkSitesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites
func (c *PrivateNetworks) ListNetworkSitesRequest(input *ListNetworkSitesInput) (req *request.Request, output *ListNetworkSitesOutput) {
	op := &request.Operation{
		Name:       opListNetworkSites,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-sites/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNetworkSitesInput{}
	}

	output = &ListNetworkSitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworkSites API operation for AWS Private 5G.
//
// Lists network sites. Add filters to your request to return a more specific
// list of results. Use filters to match the status of the network site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListNetworkSites for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites
func (c *PrivateNetworks) ListNetworkSites(input *ListNetworkSitesInput) (*ListNetworkSitesOutput, error) {
	req, out := c.ListNetworkSitesRequest(input)
	return out, req.Send()
}

// ListNetworkSitesWithContext is the same as ListNetworkSites with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworkSites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworkSitesWithContext(ctx aws.Context, input *ListNetworkSitesInput, opts ...request.Option) (*ListNetworkSitesOutput, error) {
	req, out := c.ListNetworkSitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNetworkSitesPages iterates over the pages of a ListNetworkSites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNetworkSites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNetworkSites operation.
//	pageNum := 0
//	err := client.ListNetworkSitesPages(params,
//	    func(page *privatenetworks.ListNetworkSitesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrivateNetworks) ListNetworkSitesPages(input *ListNetworkSitesInput, fn func(*ListNetworkSitesOutput, bool) bool) error {
	return c.ListNetworkSitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNetworkSitesPagesWithContext same as ListNetworkSitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworkSitesPagesWithContext(ctx aws.Context, input *ListNetworkSitesInput, fn func(*ListNetworkSitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNetworkSitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNetworkSitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNetworkSitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworks = "ListNetworks"

// ListNetworksRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworks for more information on using the ListNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNetworksRequest method.
//	req, resp := client.ListNetworksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks
func (c *PrivateNetworks) ListNetworksRequest(input *ListNetworksInput) (req *request.Request, output *ListNetworksOutput) {
	op := &request.Operation{
		Name:       opListNetworks,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/networks/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNetworksInput{}
	}

	output = &ListNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworks API operation for AWS Private 5G.
//
// Lists networks. Add filters to your request to return a more specific list
// of results. Use filters to match the status of the network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListNetworks for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks
func (c *PrivateNetworks) ListNetworks(input *ListNetworksInput) (*ListNetworksOutput, error) {
	req, out := c.ListNetworksRequest(input)
	return out, req.Send()
}

// ListNetworksWithContext is the same as ListNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworksWithContext(ctx aws.Context, input *ListNetworksInput, opts ...request.Option) (*ListNetworksOutput, error) {
	req, out := c.ListNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNetworksPages iterates over the pages of a ListNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNetworks operation.
//	pageNum := 0
//	err := client.ListNetworksPages(params,
//	    func(page *privatenetworks.ListNetworksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrivateNetworks) ListNetworksPages(input *ListNetworksInput, fn func(*ListNetworksOutput, bool) bool) error {
	return c.ListNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNetworksPagesWithContext same as ListNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListNetworksPagesWithContext(ctx aws.Context, input *ListNetworksInput, fn func(*ListNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrders = "ListOrders"

// ListOrdersRequest generates a "aws/request.Request" representing the
// client's request for the ListOrders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrders for more information on using the ListOrders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrdersRequest method.
//	req, resp := client.ListOrdersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders
func (c *PrivateNetworks) ListOrdersRequest(input *ListOrdersInput) (req *request.Request, output *ListOrdersOutput) {
	op := &request.Operation{
		Name:       opListOrders,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/orders/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"startToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrdersInput{}
	}

	output = &ListOrdersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrders API operation for AWS Private 5G.
//
// Lists orders. Add filters to your request to return a more specific list
// of results. Use filters to match the Amazon Resource Name (ARN) of the network
// site or the status of the order.
//
// If you specify multiple filters, filters are joined with an OR, and the request
// returns results that match all of the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListOrders for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders
func (c *PrivateNetworks) ListOrders(input *ListOrdersInput) (*ListOrdersOutput, error) {
	req, out := c.ListOrdersRequest(input)
	return out, req.Send()
}

// ListOrdersWithContext is the same as ListOrders with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListOrdersWithContext(ctx aws.Context, input *ListOrdersInput, opts ...request.Option) (*ListOrdersOutput, error) {
	req, out := c.ListOrdersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrdersPages iterates over the pages of a ListOrders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrders operation.
//	pageNum := 0
//	err := client.ListOrdersPages(params,
//	    func(page *privatenetworks.ListOrdersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrivateNetworks) ListOrdersPages(input *ListOrdersInput, fn func(*ListOrdersOutput, bool) bool) error {
	return c.ListOrdersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrdersPagesWithContext same as ListOrdersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListOrdersPagesWithContext(ctx aws.Context, input *ListOrdersInput, fn func(*ListOrdersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrdersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrdersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrdersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource
func (c *PrivateNetworks) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Private 5G.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     You do not have permission to perform this operation.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource
func (c *PrivateNetworks) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPing = "Ping"

// PingRequest generates a "aws/request.Request" representing the
// client's request for the Ping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Ping for more information on using the Ping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PingRequest method.
//	req, resp := client.PingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping
func (c *PrivateNetworks) PingRequest(input *PingInput) (req *request.Request, output *PingOutput) {
	op := &request.Operation{
		Name:       opPing,
		HTTPMethod: "GET",
		HTTPPath:   "/ping",
	}

	if input == nil {
		input = &PingInput{}
	}

	output = &PingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Ping API operation for AWS Private 5G.
//
// Checks the health of the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation Ping for usage and error information.
//
// Returned Error Types:
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping
func (c *PrivateNetworks) Ping(input *PingInput) (*PingOutput, error) {
	req, out := c.PingRequest(input)
	return out, req.Send()
}

// PingWithContext is the same as Ping with the addition of
// the ability to pass a context and additional request options.
//
// See Ping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) PingWithContext(ctx aws.Context, input *PingInput, opts ...request.Option) (*PingOutput, error) {
	req, out := c.PingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartNetworkResourceUpdate = "StartNetworkResourceUpdate"

// StartNetworkResourceUpdateRequest generates a "aws/request.Request" representing the
// client's request for the StartNetworkResourceUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartNetworkResourceUpdate for more information on using the StartNetworkResourceUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartNetworkResourceUpdateRequest method.
//	req, resp := client.StartNetworkResourceUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/StartNetworkResourceUpdate
func (c *PrivateNetworks) StartNetworkResourceUpdateRequest(input *StartNetworkResourceUpdateInput) (req *request.Request, output *StartNetworkResourceUpdateOutput) {
	op := &request.Operation{
		Name:       opStartNetworkResourceUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/network-resources/update",
	}

	if input == nil {
		input = &StartNetworkResourceUpdateInput{}
	}

	output = &StartNetworkResourceUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartNetworkResourceUpdate API operation for AWS Private 5G.
//
// Starts an update of the specified network resource.
//
// After you submit a request to replace or return a network resource, the status
// of the network resource is CREATING_SHIPPING_LABEL. The shipping label is
// available when the status of the network resource is PENDING_RETURN. After
// the network resource is successfully returned, its status is DELETED. For
// more information, see Return a radio unit (https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation StartNetworkResourceUpdate for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/StartNetworkResourceUpdate
func (c *PrivateNetworks) StartNetworkResourceUpdate(input *StartNetworkResourceUpdateInput) (*StartNetworkResourceUpdateOutput, error) {
	req, out := c.StartNetworkResourceUpdateRequest(input)
	return out, req.Send()
}

// StartNetworkResourceUpdateWithContext is the same as StartNetworkResourceUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See StartNetworkResourceUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) StartNetworkResourceUpdateWithContext(ctx aws.Context, input *StartNetworkResourceUpdateInput, opts ...request.Option) (*StartNetworkResourceUpdateOutput, error) {
	req, out := c.StartNetworkResourceUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource
func (c *PrivateNetworks) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Private 5G.
//
// Adds tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     You do not have permission to perform this operation.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource
func (c *PrivateNetworks) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource
func (c *PrivateNetworks) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Private 5G.
//
// Removes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     You do not have permission to perform this operation.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource
func (c *PrivateNetworks) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNetworkSite = "UpdateNetworkSite"

// UpdateNetworkSiteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNetworkSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNetworkSite for more information on using the UpdateNetworkSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNetworkSiteRequest method.
//	req, resp := client.UpdateNetworkSiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite
func (c *PrivateNetworks) UpdateNetworkSiteRequest(input *UpdateNetworkSiteInput) (req *request.Request, output *UpdateNetworkSiteOutput) {
	op := &request.Operation{
		Name:       opUpdateNetworkSite,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/network-sites/site",
	}

	if input == nil {
		input = &UpdateNetworkSiteInput{}
	}

	output = &UpdateNetworkSiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNetworkSite API operation for AWS Private 5G.
//
// Updates the specified network site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation UpdateNetworkSite for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite
func (c *PrivateNetworks) UpdateNetworkSite(input *UpdateNetworkSiteInput) (*UpdateNetworkSiteOutput, error) {
	req, out := c.UpdateNetworkSiteRequest(input)
	return out, req.Send()
}

// UpdateNetworkSiteWithContext is the same as UpdateNetworkSite with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNetworkSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) UpdateNetworkSiteWithContext(ctx aws.Context, input *UpdateNetworkSiteInput, opts ...request.Option) (*UpdateNetworkSiteOutput, error) {
	req, out := c.UpdateNetworkSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNetworkSitePlan = "UpdateNetworkSitePlan"

// UpdateNetworkSitePlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNetworkSitePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNetworkSitePlan for more information on using the UpdateNetworkSitePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNetworkSitePlanRequest method.
//	req, resp := client.UpdateNetworkSitePlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan
func (c *PrivateNetworks) UpdateNetworkSitePlanRequest(input *UpdateNetworkSitePlanInput) (req *request.Request, output *UpdateNetworkSitePlanOutput) {
	op := &request.Operation{
		Name:       opUpdateNetworkSitePlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/network-sites/plan",
	}

	if input == nil {
		input = &UpdateNetworkSitePlanInput{}
	}

	output = &UpdateNetworkSitePlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNetworkSitePlan API operation for AWS Private 5G.
//
// Updates the specified network site plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Private 5G's
// API operation UpdateNetworkSitePlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - ValidationException
//     The request failed validation.
//
//   - InternalServerException
//     Information about an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan
func (c *PrivateNetworks) UpdateNetworkSitePlan(input *UpdateNetworkSitePlanInput) (*UpdateNetworkSitePlanOutput, error) {
	req, out := c.UpdateNetworkSitePlanRequest(input)
	return out, req.Send()
}

// UpdateNetworkSitePlanWithContext is the same as UpdateNetworkSitePlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNetworkSitePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrivateNetworks) UpdateNetworkSitePlanWithContext(ctx aws.Context, input *UpdateNetworkSitePlanInput, opts ...request.Option) (*UpdateNetworkSitePlanOutput, error) {
	req, out := c.UpdateNetworkSitePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have permission to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AcknowledgeOrderReceiptInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the order.
	//
	// OrderArn is a required field
	OrderArn *string `locationName:"orderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeOrderReceiptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeOrderReceiptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeOrderReceiptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeOrderReceiptInput"}
	if s.OrderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrderArn sets the OrderArn field's value.
func (s *AcknowledgeOrderReceiptInput) SetOrderArn(v string) *AcknowledgeOrderReceiptInput {
	s.OrderArn = &v
	return s
}

type AcknowledgeOrderReceiptOutput struct {
	_ struct{} `type:"structure"`

	// Information about the order.
	//
	// Order is a required field
	Order *Order `locationName:"order" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeOrderReceiptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcknowledgeOrderReceiptOutput) GoString() string {
	return s.String()
}

// SetOrder sets the Order field's value.
func (s *AcknowledgeOrderReceiptOutput) SetOrder(v *Order) *AcknowledgeOrderReceiptOutput {
	s.Order = v
	return s
}

type ActivateDeviceIdentifierInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the device identifier.
	//
	// DeviceIdentifierArn is a required field
	DeviceIdentifierArn *string `locationName:"deviceIdentifierArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateDeviceIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateDeviceIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateDeviceIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateDeviceIdentifierInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DeviceIdentifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIdentifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ActivateDeviceIdentifierInput) SetClientToken(v string) *ActivateDeviceIdentifierInput {
	s.ClientToken = &v
	return s
}

// SetDeviceIdentifierArn sets the DeviceIdentifierArn field's value.
func (s *ActivateDeviceIdentifierInput) SetDeviceIdentifierArn(v string) *ActivateDeviceIdentifierInput {
	s.DeviceIdentifierArn = &v
	return s
}

type ActivateDeviceIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device identifier.
	//
	// DeviceIdentifier is a required field
	DeviceIdentifier *DeviceIdentifier `locationName:"deviceIdentifier" type:"structure" required:"true"`

	// The tags on the device identifier.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ActivateDeviceIdentifierOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateDeviceIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateDeviceIdentifierOutput) GoString() string {
	return s.String()
}

// SetDeviceIdentifier sets the DeviceIdentifier field's value.
func (s *ActivateDeviceIdentifierOutput) SetDeviceIdentifier(v *DeviceIdentifier) *ActivateDeviceIdentifierOutput {
	s.DeviceIdentifier = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ActivateDeviceIdentifierOutput) SetTags(v map[string]*string) *ActivateDeviceIdentifierOutput {
	s.Tags = v
	return s
}

type ActivateNetworkSiteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string" required:"true"`

	// The shipping address of the network site.
	//
	// ShippingAddress is a required field
	ShippingAddress *Address `locationName:"shippingAddress" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateNetworkSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateNetworkSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateNetworkSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateNetworkSiteInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkSiteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteArn"))
	}
	if s.ShippingAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("ShippingAddress"))
	}
	if s.ShippingAddress != nil {
		if err := s.ShippingAddress.Validate(); err != nil {
			invalidParams.AddNested("ShippingAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ActivateNetworkSiteInput) SetClientToken(v string) *ActivateNetworkSiteInput {
	s.ClientToken = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *ActivateNetworkSiteInput) SetNetworkSiteArn(v string) *ActivateNetworkSiteInput {
	s.NetworkSiteArn = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *ActivateNetworkSiteInput) SetShippingAddress(v *Address) *ActivateNetworkSiteInput {
	s.ShippingAddress = v
	return s
}

type ActivateNetworkSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateNetworkSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateNetworkSiteOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *ActivateNetworkSiteOutput) SetNetworkSite(v *NetworkSite) *ActivateNetworkSiteOutput {
	s.NetworkSite = v
	return s
}

// Information about an address.
type Address struct {
	_ struct{} `type:"structure"`

	// The city for this address.
	//
	// City is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// City is a required field
	City *string `locationName:"city" min:"1" type:"string" required:"true" sensitive:"true"`

	// The company name for this address.
	//
	// Company is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Company *string `locationName:"company" min:"1" type:"string" sensitive:"true"`

	// The country for this address.
	//
	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// Country is a required field
	Country *string `locationName:"country" min:"1" type:"string" required:"true" sensitive:"true"`

	// The recipient's name for this address.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The phone number for this address.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PhoneNumber *string `locationName:"phoneNumber" min:"1" type:"string" sensitive:"true"`

	// The postal code for this address.
	//
	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// PostalCode is a required field
	PostalCode *string `locationName:"postalCode" min:"1" type:"string" required:"true" sensitive:"true"`

	// The state or province for this address.
	//
	// StateOrProvince is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// StateOrProvince is a required field
	StateOrProvince *string `locationName:"stateOrProvince" min:"1" type:"string" required:"true" sensitive:"true"`

	// The first line of the street address.
	//
	// Street1 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	//
	// Street1 is a required field
	Street1 *string `locationName:"street1" min:"1" type:"string" required:"true" sensitive:"true"`

	// The second line of the street address.
	//
	// Street2 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Street2 *string `locationName:"street2" min:"1" type:"string" sensitive:"true"`

	// The third line of the street address.
	//
	// Street3 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Street3 *string `locationName:"street3" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.City == nil {
		invalidParams.Add(request.NewErrParamRequired("City"))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Company != nil && len(*s.Company) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Company", 1))
	}
	if s.Country == nil {
		invalidParams.Add(request.NewErrParamRequired("Country"))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.PostalCode == nil {
		invalidParams.Add(request.NewErrParamRequired("PostalCode"))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.StateOrProvince == nil {
		invalidParams.Add(request.NewErrParamRequired("StateOrProvince"))
	}
	if s.StateOrProvince != nil && len(*s.StateOrProvince) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateOrProvince", 1))
	}
	if s.Street1 == nil {
		invalidParams.Add(request.NewErrParamRequired("Street1"))
	}
	if s.Street1 != nil && len(*s.Street1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street1", 1))
	}
	if s.Street2 != nil && len(*s.Street2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street2", 1))
	}
	if s.Street3 != nil && len(*s.Street3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street3", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCompany sets the Company field's value.
func (s *Address) SetCompany(v string) *Address {
	s.Company = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetName sets the Name field's value.
func (s *Address) SetName(v string) *Address {
	s.Name = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Address) SetPhoneNumber(v string) *Address {
	s.PhoneNumber = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetStateOrProvince sets the StateOrProvince field's value.
func (s *Address) SetStateOrProvince(v string) *Address {
	s.StateOrProvince = &v
	return s
}

// SetStreet1 sets the Street1 field's value.
func (s *Address) SetStreet1(v string) *Address {
	s.Street1 = &v
	return s
}

// SetStreet2 sets the Street2 field's value.
func (s *Address) SetStreet2(v string) *Address {
	s.Street2 = &v
	return s
}

// SetStreet3 sets the Street3 field's value.
func (s *Address) SetStreet3(v string) *Address {
	s.Street3 = &v
	return s
}

type ConfigureAccessPointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network resource.
	//
	// AccessPointArn is a required field
	AccessPointArn *string `locationName:"accessPointArn" type:"string" required:"true"`

	// A Base64 encoded string of the CPI certificate associated with the CPI user
	// who is certifying the coordinates of the network resource.
	//
	// CpiSecretKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfigureAccessPointInput's
	// String and GoString methods.
	CpiSecretKey *string `locationName:"cpiSecretKey" min:"1" type:"string" sensitive:"true"`

	// The CPI user ID of the CPI user who is certifying the coordinates of the
	// network resource.
	//
	// CpiUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfigureAccessPointInput's
	// String and GoString methods.
	CpiUserId *string `locationName:"cpiUserId" min:"1" type:"string" sensitive:"true"`

	// The CPI password associated with the CPI certificate in cpiSecretKey.
	//
	// CpiUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfigureAccessPointInput's
	// String and GoString methods.
	CpiUserPassword *string `locationName:"cpiUserPassword" min:"1" type:"string" sensitive:"true"`

	// The CPI user name of the CPI user who is certifying the coordinates of the
	// radio unit.
	//
	// CpiUsername is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfigureAccessPointInput's
	// String and GoString methods.
	CpiUsername *string `locationName:"cpiUsername" min:"1" type:"string" sensitive:"true"`

	// The position of the network resource.
	Position *Position `locationName:"position" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureAccessPointInput"}
	if s.AccessPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPointArn"))
	}
	if s.CpiSecretKey != nil && len(*s.CpiSecretKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CpiSecretKey", 1))
	}
	if s.CpiUserId != nil && len(*s.CpiUserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CpiUserId", 1))
	}
	if s.CpiUserPassword != nil && len(*s.CpiUserPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CpiUserPassword", 1))
	}
	if s.CpiUsername != nil && len(*s.CpiUsername) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CpiUsername", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *ConfigureAccessPointInput) SetAccessPointArn(v string) *ConfigureAccessPointInput {
	s.AccessPointArn = &v
	return s
}

// SetCpiSecretKey sets the CpiSecretKey field's value.
func (s *ConfigureAccessPointInput) SetCpiSecretKey(v string) *ConfigureAccessPointInput {
	s.CpiSecretKey = &v
	return s
}

// SetCpiUserId sets the CpiUserId field's value.
func (s *ConfigureAccessPointInput) SetCpiUserId(v string) *ConfigureAccessPointInput {
	s.CpiUserId = &v
	return s
}

// SetCpiUserPassword sets the CpiUserPassword field's value.
func (s *ConfigureAccessPointInput) SetCpiUserPassword(v string) *ConfigureAccessPointInput {
	s.CpiUserPassword = &v
	return s
}

// SetCpiUsername sets the CpiUsername field's value.
func (s *ConfigureAccessPointInput) SetCpiUsername(v string) *ConfigureAccessPointInput {
	s.CpiUsername = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *ConfigureAccessPointInput) SetPosition(v *Position) *ConfigureAccessPointInput {
	s.Position = v
	return s
}

type ConfigureAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network resource.
	//
	// AccessPoint is a required field
	AccessPoint *NetworkResource `locationName:"accessPoint" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigureAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPoint sets the AccessPoint field's value.
func (s *ConfigureAccessPointOutput) SetAccessPoint(v *NetworkResource) *ConfigureAccessPointOutput {
	s.AccessPoint = v
	return s
}

type CreateNetworkInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The description of the network.
	Description *string `locationName:"description" type:"string"`

	// The name of the network. You can't change the name after you create the network.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The tags to apply to the network.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.NetworkName != nil && len(*s.NetworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNetworkInput) SetClientToken(v string) *CreateNetworkInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkInput) SetDescription(v string) *CreateNetworkInput {
	s.Description = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *CreateNetworkInput) SetNetworkName(v string) *CreateNetworkInput {
	s.NetworkName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkInput) SetTags(v map[string]*string) *CreateNetworkInput {
	s.Tags = v
	return s
}

type CreateNetworkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network.
	//
	// Network is a required field
	Network *Network `locationName:"network" type:"structure" required:"true"`

	// The network tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkOutput) GoString() string {
	return s.String()
}

// SetNetwork sets the Network field's value.
func (s *CreateNetworkOutput) SetNetwork(v *Network) *CreateNetworkOutput {
	s.Network = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkOutput) SetTags(v map[string]*string) *CreateNetworkOutput {
	s.Tags = v
	return s
}

type CreateNetworkSiteInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that is the parent of this site. You can't change the
	// Availability Zone after you create the site.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The ID of the Availability Zone that is the parent of this site. You can't
	// change the Availability Zone after you create the site.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The description of the site.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The name of the site. You can't change the name after you create the site.
	//
	// NetworkSiteName is a required field
	NetworkSiteName *string `locationName:"networkSiteName" min:"1" type:"string" required:"true"`

	// Information about the pending plan for this site.
	PendingPlan *SitePlan `locationName:"pendingPlan" type:"structure"`

	// The tags to apply to the network site.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkSiteInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkSiteInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}
	if s.NetworkSiteName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteName"))
	}
	if s.NetworkSiteName != nil && len(*s.NetworkSiteName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSiteName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.PendingPlan != nil {
		if err := s.PendingPlan.Validate(); err != nil {
			invalidParams.AddNested("PendingPlan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateNetworkSiteInput) SetAvailabilityZone(v string) *CreateNetworkSiteInput {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateNetworkSiteInput) SetAvailabilityZoneId(v string) *CreateNetworkSiteInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNetworkSiteInput) SetClientToken(v string) *CreateNetworkSiteInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkSiteInput) SetDescription(v string) *CreateNetworkSiteInput {
	s.Description = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *CreateNetworkSiteInput) SetNetworkArn(v string) *CreateNetworkSiteInput {
	s.NetworkArn = &v
	return s
}

// SetNetworkSiteName sets the NetworkSiteName field's value.
func (s *CreateNetworkSiteInput) SetNetworkSiteName(v string) *CreateNetworkSiteInput {
	s.NetworkSiteName = &v
	return s
}

// SetPendingPlan sets the PendingPlan field's value.
func (s *CreateNetworkSiteInput) SetPendingPlan(v *SitePlan) *CreateNetworkSiteInput {
	s.PendingPlan = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkSiteInput) SetTags(v map[string]*string) *CreateNetworkSiteInput {
	s.Tags = v
	return s
}

type CreateNetworkSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`

	// The network site tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkSiteOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkSiteOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *CreateNetworkSiteOutput) SetNetworkSite(v *NetworkSite) *CreateNetworkSiteOutput {
	s.NetworkSite = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkSiteOutput) SetTags(v map[string]*string) *CreateNetworkSiteOutput {
	s.Tags = v
	return s
}

type DeactivateDeviceIdentifierInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the device identifier.
	//
	// DeviceIdentifierArn is a required field
	DeviceIdentifierArn *string `locationName:"deviceIdentifierArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateDeviceIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateDeviceIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateDeviceIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateDeviceIdentifierInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DeviceIdentifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIdentifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeactivateDeviceIdentifierInput) SetClientToken(v string) *DeactivateDeviceIdentifierInput {
	s.ClientToken = &v
	return s
}

// SetDeviceIdentifierArn sets the DeviceIdentifierArn field's value.
func (s *DeactivateDeviceIdentifierInput) SetDeviceIdentifierArn(v string) *DeactivateDeviceIdentifierInput {
	s.DeviceIdentifierArn = &v
	return s
}

type DeactivateDeviceIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device identifier.
	//
	// DeviceIdentifier is a required field
	DeviceIdentifier *DeviceIdentifier `locationName:"deviceIdentifier" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateDeviceIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateDeviceIdentifierOutput) GoString() string {
	return s.String()
}

// SetDeviceIdentifier sets the DeviceIdentifier field's value.
func (s *DeactivateDeviceIdentifierOutput) SetDeviceIdentifier(v *DeviceIdentifier) *DeactivateDeviceIdentifierOutput {
	s.DeviceIdentifier = v
	return s
}

type DeleteNetworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `location:"uri" locationName:"networkArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}
	if s.NetworkArn != nil && len(*s.NetworkArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteNetworkInput) SetClientToken(v string) *DeleteNetworkInput {
	s.ClientToken = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *DeleteNetworkInput) SetNetworkArn(v string) *DeleteNetworkInput {
	s.NetworkArn = &v
	return s
}

type DeleteNetworkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network.
	//
	// Network is a required field
	Network *Network `locationName:"network" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkOutput) GoString() string {
	return s.String()
}

// SetNetwork sets the Network field's value.
func (s *DeleteNetworkOutput) SetNetwork(v *Network) *DeleteNetworkOutput {
	s.Network = v
	return s
}

type DeleteNetworkSiteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `location:"uri" locationName:"networkSiteArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkSiteInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkSiteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteArn"))
	}
	if s.NetworkSiteArn != nil && len(*s.NetworkSiteArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSiteArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteNetworkSiteInput) SetClientToken(v string) *DeleteNetworkSiteInput {
	s.ClientToken = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *DeleteNetworkSiteInput) SetNetworkSiteArn(v string) *DeleteNetworkSiteInput {
	s.NetworkSiteArn = &v
	return s
}

type DeleteNetworkSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkSiteOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *DeleteNetworkSiteOutput) SetNetworkSite(v *NetworkSite) *DeleteNetworkSiteOutput {
	s.NetworkSite = v
	return s
}

// Information about a subscriber of a device that can use a network.
type DeviceIdentifier struct {
	_ struct{} `type:"structure"`

	// The creation time of this device identifier.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the device identifier.
	DeviceIdentifierArn *string `locationName:"deviceIdentifierArn" type:"string"`

	// The Integrated Circuit Card Identifier of the device identifier.
	Iccid *string `locationName:"iccid" type:"string"`

	// The International Mobile Subscriber Identity of the device identifier.
	//
	// Imsi is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeviceIdentifier's
	// String and GoString methods.
	Imsi *string `locationName:"imsi" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the network on which the device identifier
	// appears.
	NetworkArn *string `locationName:"networkArn" type:"string"`

	// The Amazon Resource Name (ARN) of the order used to purchase the device identifier.
	OrderArn *string `locationName:"orderArn" type:"string"`

	// The status of the device identifier.
	Status *string `locationName:"status" type:"string" enum:"DeviceIdentifierStatus"`

	// The Amazon Resource Name (ARN) of the traffic group to which the device identifier
	// belongs.
	TrafficGroupArn *string `locationName:"trafficGroupArn" type:"string"`

	// The vendor of the device identifier.
	Vendor *string `locationName:"vendor" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceIdentifier) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeviceIdentifier) SetCreatedAt(v time.Time) *DeviceIdentifier {
	s.CreatedAt = &v
	return s
}

// SetDeviceIdentifierArn sets the DeviceIdentifierArn field's value.
func (s *DeviceIdentifier) SetDeviceIdentifierArn(v string) *DeviceIdentifier {
	s.DeviceIdentifierArn = &v
	return s
}

// SetIccid sets the Iccid field's value.
func (s *DeviceIdentifier) SetIccid(v string) *DeviceIdentifier {
	s.Iccid = &v
	return s
}

// SetImsi sets the Imsi field's value.
func (s *DeviceIdentifier) SetImsi(v string) *DeviceIdentifier {
	s.Imsi = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *DeviceIdentifier) SetNetworkArn(v string) *DeviceIdentifier {
	s.NetworkArn = &v
	return s
}

// SetOrderArn sets the OrderArn field's value.
func (s *DeviceIdentifier) SetOrderArn(v string) *DeviceIdentifier {
	s.OrderArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeviceIdentifier) SetStatus(v string) *DeviceIdentifier {
	s.Status = &v
	return s
}

// SetTrafficGroupArn sets the TrafficGroupArn field's value.
func (s *DeviceIdentifier) SetTrafficGroupArn(v string) *DeviceIdentifier {
	s.TrafficGroupArn = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *DeviceIdentifier) SetVendor(v string) *DeviceIdentifier {
	s.Vendor = &v
	return s
}

type GetDeviceIdentifierInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the device identifier.
	//
	// DeviceIdentifierArn is a required field
	DeviceIdentifierArn *string `location:"uri" locationName:"deviceIdentifierArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceIdentifierInput"}
	if s.DeviceIdentifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIdentifierArn"))
	}
	if s.DeviceIdentifierArn != nil && len(*s.DeviceIdentifierArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceIdentifierArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIdentifierArn sets the DeviceIdentifierArn field's value.
func (s *GetDeviceIdentifierInput) SetDeviceIdentifierArn(v string) *GetDeviceIdentifierInput {
	s.DeviceIdentifierArn = &v
	return s
}

type GetDeviceIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device identifier.
	DeviceIdentifier *DeviceIdentifier `locationName:"deviceIdentifier" type:"structure"`

	// The device identifier tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDeviceIdentifierOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceIdentifierOutput) GoString() string {
	return s.String()
}

// SetDeviceIdentifier sets the DeviceIdentifier field's value.
func (s *GetDeviceIdentifierOutput) SetDeviceIdentifier(v *DeviceIdentifier) *GetDeviceIdentifierOutput {
	s.DeviceIdentifier = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDeviceIdentifierOutput) SetTags(v map[string]*string) *GetDeviceIdentifierOutput {
	s.Tags = v
	return s
}

type GetNetworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `location:"uri" locationName:"networkArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkInput"}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}
	if s.NetworkArn != nil && len(*s.NetworkArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *GetNetworkInput) SetNetworkArn(v string) *GetNetworkInput {
	s.NetworkArn = &v
	return s
}

type GetNetworkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network.
	//
	// Network is a required field
	Network *Network `locationName:"network" type:"structure" required:"true"`

	// The network tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetNetworkOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkOutput) GoString() string {
	return s.String()
}

// SetNetwork sets the Network field's value.
func (s *GetNetworkOutput) SetNetwork(v *Network) *GetNetworkOutput {
	s.Network = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetNetworkOutput) SetTags(v map[string]*string) *GetNetworkOutput {
	s.Tags = v
	return s
}

type GetNetworkResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the network resource.
	//
	// NetworkResourceArn is a required field
	NetworkResourceArn *string `location:"uri" locationName:"networkResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkResourceInput"}
	if s.NetworkResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkResourceArn"))
	}
	if s.NetworkResourceArn != nil && len(*s.NetworkResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkResourceArn sets the NetworkResourceArn field's value.
func (s *GetNetworkResourceInput) SetNetworkResourceArn(v string) *GetNetworkResourceInput {
	s.NetworkResourceArn = &v
	return s
}

type GetNetworkResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network resource.
	//
	// NetworkResource is a required field
	NetworkResource *NetworkResource `locationName:"networkResource" type:"structure" required:"true"`

	// The network resource tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetNetworkResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkResourceOutput) GoString() string {
	return s.String()
}

// SetNetworkResource sets the NetworkResource field's value.
func (s *GetNetworkResourceOutput) SetNetworkResource(v *NetworkResource) *GetNetworkResourceOutput {
	s.NetworkResource = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetNetworkResourceOutput) SetTags(v map[string]*string) *GetNetworkResourceOutput {
	s.Tags = v
	return s
}

type GetNetworkSiteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `location:"uri" locationName:"networkSiteArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkSiteInput"}
	if s.NetworkSiteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteArn"))
	}
	if s.NetworkSiteArn != nil && len(*s.NetworkSiteArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkSiteArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *GetNetworkSiteInput) SetNetworkSiteArn(v string) *GetNetworkSiteInput {
	s.NetworkSiteArn = &v
	return s
}

type GetNetworkSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`

	// The network site tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetNetworkSiteOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkSiteOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *GetNetworkSiteOutput) SetNetworkSite(v *NetworkSite) *GetNetworkSiteOutput {
	s.NetworkSite = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetNetworkSiteOutput) SetTags(v map[string]*string) *GetNetworkSiteOutput {
	s.Tags = v
	return s
}

type GetOrderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the order.
	//
	// OrderArn is a required field
	OrderArn *string `location:"uri" locationName:"orderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrderInput"}
	if s.OrderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderArn"))
	}
	if s.OrderArn != nil && len(*s.OrderArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrderArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrderArn sets the OrderArn field's value.
func (s *GetOrderInput) SetOrderArn(v string) *GetOrderInput {
	s.OrderArn = &v
	return s
}

type GetOrderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the order.
	//
	// Order is a required field
	Order *Order `locationName:"order" type:"structure" required:"true"`

	// The order tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetOrderOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrderOutput) GoString() string {
	return s.String()
}

// SetOrder sets the Order field's value.
func (s *GetOrderOutput) SetOrder(v *Order) *GetOrderOutput {
	s.Order = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetOrderOutput) SetTags(v map[string]*string) *GetOrderOutput {
	s.Tags = v
	return s
}

// Information about an internal error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The limit was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDeviceIdentifiersInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	//
	//    * ORDER - The Amazon Resource Name (ARN) of the order.
	//
	//    * STATUS - The status (ACTIVE | INACTIVE).
	//
	//    * TRAFFIC_GROUP - The Amazon Resource Name (ARN) of the traffic group.
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	Filters map[string][]*string `locationName:"filters" type:"map"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The token for the next page of results.
	StartToken *string `locationName:"startToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceIdentifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceIdentifiersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceIdentifiersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceIdentifiersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListDeviceIdentifiersInput) SetFilters(v map[string][]*string) *ListDeviceIdentifiersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceIdentifiersInput) SetMaxResults(v int64) *ListDeviceIdentifiersInput {
	s.MaxResults = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *ListDeviceIdentifiersInput) SetNetworkArn(v string) *ListDeviceIdentifiersInput {
	s.NetworkArn = &v
	return s
}

// SetStartToken sets the StartToken field's value.
func (s *ListDeviceIdentifiersInput) SetStartToken(v string) *ListDeviceIdentifiersInput {
	s.StartToken = &v
	return s
}

type ListDeviceIdentifiersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device identifiers.
	DeviceIdentifiers []*DeviceIdentifier `locationName:"deviceIdentifiers" type:"list"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceIdentifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceIdentifiersOutput) GoString() string {
	return s.String()
}

// SetDeviceIdentifiers sets the DeviceIdentifiers field's value.
func (s *ListDeviceIdentifiersOutput) SetDeviceIdentifiers(v []*DeviceIdentifier) *ListDeviceIdentifiersOutput {
	s.DeviceIdentifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceIdentifiersOutput) SetNextToken(v string) *ListDeviceIdentifiersOutput {
	s.NextToken = &v
	return s
}

type ListNetworkResourcesInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	//
	//    * ORDER - The Amazon Resource Name (ARN) of the order.
	//
	//    * STATUS - The status (AVAILABLE | DELETED | DELETING | PENDING | PENDING_RETURN
	//    | PROVISIONING | SHIPPED).
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	Filters map[string][]*string `locationName:"filters" type:"map"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The token for the next page of results.
	StartToken *string `locationName:"startToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworkResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworkResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNetworkResourcesInput) SetFilters(v map[string][]*string) *ListNetworkResourcesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNetworkResourcesInput) SetMaxResults(v int64) *ListNetworkResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *ListNetworkResourcesInput) SetNetworkArn(v string) *ListNetworkResourcesInput {
	s.NetworkArn = &v
	return s
}

// SetStartToken sets the StartToken field's value.
func (s *ListNetworkResourcesInput) SetStartToken(v string) *ListNetworkResourcesInput {
	s.StartToken = &v
	return s
}

type ListNetworkResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Information about network resources.
	NetworkResources []*NetworkResource `locationName:"networkResources" type:"list"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkResourcesOutput) GoString() string {
	return s.String()
}

// SetNetworkResources sets the NetworkResources field's value.
func (s *ListNetworkResourcesOutput) SetNetworkResources(v []*NetworkResource) *ListNetworkResourcesOutput {
	s.NetworkResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkResourcesOutput) SetNextToken(v string) *ListNetworkResourcesOutput {
	s.NextToken = &v
	return s
}

type ListNetworkSitesInput struct {
	_ struct{} `type:"structure"`

	// The filters. Add filters to your request to return a more specific list of
	// results. Use filters to match the status of the network sites.
	//
	//    * STATUS - The status (AVAILABLE | CREATED | DELETED | DEPROVISIONING
	//    | PROVISIONING).
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	Filters map[string][]*string `locationName:"filters" type:"map"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The token for the next page of results.
	StartToken *string `locationName:"startToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworkSitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworkSitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNetworkSitesInput) SetFilters(v map[string][]*string) *ListNetworkSitesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNetworkSitesInput) SetMaxResults(v int64) *ListNetworkSitesInput {
	s.MaxResults = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *ListNetworkSitesInput) SetNetworkArn(v string) *ListNetworkSitesInput {
	s.NetworkArn = &v
	return s
}

// SetStartToken sets the StartToken field's value.
func (s *ListNetworkSitesInput) SetStartToken(v string) *ListNetworkSitesInput {
	s.StartToken = &v
	return s
}

type ListNetworkSitesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network sites.
	NetworkSites []*NetworkSite `locationName:"networkSites" type:"list"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkSitesOutput) GoString() string {
	return s.String()
}

// SetNetworkSites sets the NetworkSites field's value.
func (s *ListNetworkSitesOutput) SetNetworkSites(v []*NetworkSite) *ListNetworkSitesOutput {
	s.NetworkSites = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkSitesOutput) SetNextToken(v string) *ListNetworkSitesOutput {
	s.NextToken = &v
	return s
}

type ListNetworksInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	//
	//    * STATUS - The status (AVAILABLE | CREATED | DELETED | DEPROVISIONING
	//    | PROVISIONING).
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	Filters map[string][]*string `locationName:"filters" type:"map"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	StartToken *string `locationName:"startToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNetworksInput) SetFilters(v map[string][]*string) *ListNetworksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNetworksInput) SetMaxResults(v int64) *ListNetworksInput {
	s.MaxResults = &v
	return s
}

// SetStartToken sets the StartToken field's value.
func (s *ListNetworksInput) SetStartToken(v string) *ListNetworksInput {
	s.StartToken = &v
	return s
}

type ListNetworksOutput struct {
	_ struct{} `type:"structure"`

	// The networks.
	Networks []*Network `locationName:"networks" type:"list"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworksOutput) GoString() string {
	return s.String()
}

// SetNetworks sets the Networks field's value.
func (s *ListNetworksOutput) SetNetworks(v []*Network) *ListNetworksOutput {
	s.Networks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworksOutput) SetNextToken(v string) *ListNetworksOutput {
	s.NextToken = &v
	return s
}

type ListOrdersInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	//
	//    * NETWORK_SITE - The Amazon Resource Name (ARN) of the network site.
	//
	//    * STATUS - The status (ACKNOWLEDGING | ACKNOWLEDGED | UNACKNOWLEDGED).
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	Filters map[string][]*string `locationName:"filters" type:"map"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The token for the next page of results.
	StartToken *string `locationName:"startToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrdersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrdersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrdersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrdersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListOrdersInput) SetFilters(v map[string][]*string) *ListOrdersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrdersInput) SetMaxResults(v int64) *ListOrdersInput {
	s.MaxResults = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *ListOrdersInput) SetNetworkArn(v string) *ListOrdersInput {
	s.NetworkArn = &v
	return s
}

// SetStartToken sets the StartToken field's value.
func (s *ListOrdersInput) SetStartToken(v string) *ListOrdersInput {
	s.StartToken = &v
	return s
}

type ListOrdersOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the orders.
	Orders []*Order `locationName:"orders" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrdersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrdersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrdersOutput) SetNextToken(v string) *ListOrdersOutput {
	s.NextToken = &v
	return s
}

// SetOrders sets the Orders field's value.
func (s *ListOrdersOutput) SetOrders(v []*Order) *ListOrdersOutput {
	s.Orders = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resource tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about a name/value pair.
type NameValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the pair.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The value of the pair.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NameValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NameValuePair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NameValuePair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NameValuePair"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *NameValuePair) SetName(v string) *NameValuePair {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *NameValuePair) SetValue(v string) *NameValuePair {
	s.Value = &v
	return s
}

// Information about a network.
type Network struct {
	_ struct{} `type:"structure"`

	// The creation time of the network.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the network.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the network.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The name of the network.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The status of the network.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"NetworkStatus"`

	// The status reason of the network.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Network) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Network) SetCreatedAt(v time.Time) *Network {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Network) SetDescription(v string) *Network {
	s.Description = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *Network) SetNetworkArn(v string) *Network {
	s.NetworkArn = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *Network) SetNetworkName(v string) *Network {
	s.NetworkName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Network) SetStatus(v string) *Network {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Network) SetStatusReason(v string) *Network {
	s.StatusReason = &v
	return s
}

// Information about a network resource.
type NetworkResource struct {
	_ struct{} `type:"structure"`

	// The attributes of the network resource.
	Attributes []*NameValuePair `locationName:"attributes" type:"list"`

	// The creation time of the network resource.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the network resource.
	Description *string `locationName:"description" type:"string"`

	// The health of the network resource.
	Health *string `locationName:"health" type:"string" enum:"HealthStatus"`

	// The model of the network resource.
	Model *string `locationName:"model" type:"string"`

	// The Amazon Resource Name (ARN) of the network on which this network resource
	// appears.
	NetworkArn *string `locationName:"networkArn" type:"string"`

	// The Amazon Resource Name (ARN) of the network resource.
	NetworkResourceArn *string `locationName:"networkResourceArn" type:"string"`

	// The Amazon Resource Name (ARN) of the network site on which this network
	// resource appears.
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string"`

	// The Amazon Resource Name (ARN) of the order used to purchase this network
	// resource.
	OrderArn *string `locationName:"orderArn" type:"string"`

	// The position of the network resource.
	Position *Position `locationName:"position" type:"structure"`

	// Information about a request to return the network resource.
	ReturnInformation *ReturnInformation `locationName:"returnInformation" type:"structure"`

	// The serial number of the network resource.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The status of the network resource.
	Status *string `locationName:"status" type:"string" enum:"NetworkResourceStatus"`

	// The status reason of the network resource.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The type of the network resource.
	Type *string `locationName:"type" type:"string" enum:"NetworkResourceType"`

	// The vendor of the network resource.
	Vendor *string `locationName:"vendor" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResource) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *NetworkResource) SetAttributes(v []*NameValuePair) *NetworkResource {
	s.Attributes = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *NetworkResource) SetCreatedAt(v time.Time) *NetworkResource {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkResource) SetDescription(v string) *NetworkResource {
	s.Description = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *NetworkResource) SetHealth(v string) *NetworkResource {
	s.Health = &v
	return s
}

// SetModel sets the Model field's value.
func (s *NetworkResource) SetModel(v string) *NetworkResource {
	s.Model = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *NetworkResource) SetNetworkArn(v string) *NetworkResource {
	s.NetworkArn = &v
	return s
}

// SetNetworkResourceArn sets the NetworkResourceArn field's value.
func (s *NetworkResource) SetNetworkResourceArn(v string) *NetworkResource {
	s.NetworkResourceArn = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *NetworkResource) SetNetworkSiteArn(v string) *NetworkResource {
	s.NetworkSiteArn = &v
	return s
}

// SetOrderArn sets the OrderArn field's value.
func (s *NetworkResource) SetOrderArn(v string) *NetworkResource {
	s.OrderArn = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *NetworkResource) SetPosition(v *Position) *NetworkResource {
	s.Position = v
	return s
}

// SetReturnInformation sets the ReturnInformation field's value.
func (s *NetworkResource) SetReturnInformation(v *ReturnInformation) *NetworkResource {
	s.ReturnInformation = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *NetworkResource) SetSerialNumber(v string) *NetworkResource {
	s.SerialNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NetworkResource) SetStatus(v string) *NetworkResource {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *NetworkResource) SetStatusReason(v string) *NetworkResource {
	s.StatusReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkResource) SetType(v string) *NetworkResource {
	s.Type = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *NetworkResource) SetVendor(v string) *NetworkResource {
	s.Vendor = &v
	return s
}

// Information about a network resource definition.
type NetworkResourceDefinition struct {
	_ struct{} `type:"structure"`

	// The count in the network resource definition.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// The options in the network resource definition.
	Options []*NameValuePair `locationName:"options" type:"list"`

	// The type in the network resource definition.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"NetworkResourceDefinitionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResourceDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkResourceDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkResourceDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkResourceDefinition"}
	if s.Count == nil {
		invalidParams.Add(request.NewErrParamRequired("Count"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Options != nil {
		for i, v := range s.Options {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Options", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *NetworkResourceDefinition) SetCount(v int64) *NetworkResourceDefinition {
	s.Count = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *NetworkResourceDefinition) SetOptions(v []*NameValuePair) *NetworkResourceDefinition {
	s.Options = v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkResourceDefinition) SetType(v string) *NetworkResourceDefinition {
	s.Type = &v
	return s
}

// Information about a network site.
type NetworkSite struct {
	_ struct{} `type:"structure"`

	// The parent Availability Zone for the network site.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The parent Availability Zone ID for the network site.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The creation time of the network site.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The current plan of the network site.
	CurrentPlan *SitePlan `locationName:"currentPlan" type:"structure"`

	// The description of the network site.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the network to which the network site belongs.
	//
	// NetworkArn is a required field
	NetworkArn *string `locationName:"networkArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string" required:"true"`

	// The name of the network site.
	//
	// NetworkSiteName is a required field
	NetworkSiteName *string `locationName:"networkSiteName" min:"1" type:"string" required:"true"`

	// The pending plan of the network site.
	PendingPlan *SitePlan `locationName:"pendingPlan" type:"structure"`

	// The status of the network site.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"NetworkSiteStatus"`

	// The status reason of the network site.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkSite) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NetworkSite) SetAvailabilityZone(v string) *NetworkSite {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *NetworkSite) SetAvailabilityZoneId(v string) *NetworkSite {
	s.AvailabilityZoneId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *NetworkSite) SetCreatedAt(v time.Time) *NetworkSite {
	s.CreatedAt = &v
	return s
}

// SetCurrentPlan sets the CurrentPlan field's value.
func (s *NetworkSite) SetCurrentPlan(v *SitePlan) *NetworkSite {
	s.CurrentPlan = v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkSite) SetDescription(v string) *NetworkSite {
	s.Description = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *NetworkSite) SetNetworkArn(v string) *NetworkSite {
	s.NetworkArn = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *NetworkSite) SetNetworkSiteArn(v string) *NetworkSite {
	s.NetworkSiteArn = &v
	return s
}

// SetNetworkSiteName sets the NetworkSiteName field's value.
func (s *NetworkSite) SetNetworkSiteName(v string) *NetworkSite {
	s.NetworkSiteName = &v
	return s
}

// SetPendingPlan sets the PendingPlan field's value.
func (s *NetworkSite) SetPendingPlan(v *SitePlan) *NetworkSite {
	s.PendingPlan = v
	return s
}

// SetStatus sets the Status field's value.
func (s *NetworkSite) SetStatus(v string) *NetworkSite {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *NetworkSite) SetStatusReason(v string) *NetworkSite {
	s.StatusReason = &v
	return s
}

// Information about an order.
type Order struct {
	_ struct{} `type:"structure"`

	// The acknowledgement status of the order.
	AcknowledgmentStatus *string `locationName:"acknowledgmentStatus" type:"string" enum:"AcknowledgmentStatus"`

	// The creation time of the order.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the network associated with this order.
	NetworkArn *string `locationName:"networkArn" type:"string"`

	// The Amazon Resource Name (ARN) of the network site associated with this order.
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string"`

	// The Amazon Resource Name (ARN) of the order.
	OrderArn *string `locationName:"orderArn" type:"string"`

	// The shipping address of the order.
	ShippingAddress *Address `locationName:"shippingAddress" type:"structure"`

	// The tracking information of the order.
	TrackingInformation []*TrackingInformation `locationName:"trackingInformation" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Order) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Order) GoString() string {
	return s.String()
}

// SetAcknowledgmentStatus sets the AcknowledgmentStatus field's value.
func (s *Order) SetAcknowledgmentStatus(v string) *Order {
	s.AcknowledgmentStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Order) SetCreatedAt(v time.Time) *Order {
	s.CreatedAt = &v
	return s
}

// SetNetworkArn sets the NetworkArn field's value.
func (s *Order) SetNetworkArn(v string) *Order {
	s.NetworkArn = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *Order) SetNetworkSiteArn(v string) *Order {
	s.NetworkSiteArn = &v
	return s
}

// SetOrderArn sets the OrderArn field's value.
func (s *Order) SetOrderArn(v string) *Order {
	s.OrderArn = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *Order) SetShippingAddress(v *Address) *Order {
	s.ShippingAddress = v
	return s
}

// SetTrackingInformation sets the TrackingInformation field's value.
func (s *Order) SetTrackingInformation(v []*TrackingInformation) *Order {
	s.TrackingInformation = v
	return s
}

type PingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PingInput) GoString() string {
	return s.String()
}

type PingOutput struct {
	_ struct{} `type:"structure"`

	// Information about the health of the service.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PingOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *PingOutput) SetStatus(v string) *PingOutput {
	s.Status = &v
	return s
}

// Information about a position.
type Position struct {
	_ struct{} `type:"structure"`

	// The elevation of the equipment at this position.
	Elevation *float64 `locationName:"elevation" type:"double"`

	// The reference point from which elevation is reported.
	ElevationReference *string `locationName:"elevationReference" type:"string" enum:"ElevationReference"`

	// The units used to measure the elevation of the position.
	ElevationUnit *string `locationName:"elevationUnit" type:"string" enum:"ElevationUnit"`

	// The latitude of the position.
	Latitude *float64 `locationName:"latitude" type:"double"`

	// The longitude of the position.
	Longitude *float64 `locationName:"longitude" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Position) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Position) GoString() string {
	return s.String()
}

// SetElevation sets the Elevation field's value.
func (s *Position) SetElevation(v float64) *Position {
	s.Elevation = &v
	return s
}

// SetElevationReference sets the ElevationReference field's value.
func (s *Position) SetElevationReference(v string) *Position {
	s.ElevationReference = &v
	return s
}

// SetElevationUnit sets the ElevationUnit field's value.
func (s *Position) SetElevationUnit(v string) *Position {
	s.ElevationUnit = &v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *Position) SetLatitude(v float64) *Position {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *Position) SetLongitude(v float64) *Position {
	s.Longitude = &v
	return s
}

// The resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the affected resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the affected resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a request to return a network resource.
type ReturnInformation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replacement order.
	ReplacementOrderArn *string `locationName:"replacementOrderArn" type:"string"`

	// The reason for the return. If the return request did not include a reason
	// for the return, this value is null.
	ReturnReason *string `locationName:"returnReason" type:"string"`

	// The shipping address.
	ShippingAddress *Address `locationName:"shippingAddress" type:"structure"`

	// The URL of the shipping label. The shipping label is available for download
	// only if the status of the network resource is PENDING_RETURN. For more information,
	// see Return a radio unit (https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit).
	ShippingLabel *string `locationName:"shippingLabel" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnInformation) GoString() string {
	return s.String()
}

// SetReplacementOrderArn sets the ReplacementOrderArn field's value.
func (s *ReturnInformation) SetReplacementOrderArn(v string) *ReturnInformation {
	s.ReplacementOrderArn = &v
	return s
}

// SetReturnReason sets the ReturnReason field's value.
func (s *ReturnInformation) SetReturnReason(v string) *ReturnInformation {
	s.ReturnReason = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *ReturnInformation) SetShippingAddress(v *Address) *ReturnInformation {
	s.ShippingAddress = v
	return s
}

// SetShippingLabel sets the ShippingLabel field's value.
func (s *ReturnInformation) SetShippingLabel(v string) *ReturnInformation {
	s.ShippingLabel = &v
	return s
}

// Information about a site plan.
type SitePlan struct {
	_ struct{} `type:"structure"`

	// The options of the plan.
	Options []*NameValuePair `locationName:"options" type:"list"`

	// The resource definitions of the plan.
	ResourceDefinitions []*NetworkResourceDefinition `locationName:"resourceDefinitions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SitePlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SitePlan) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SitePlan) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SitePlan"}
	if s.Options != nil {
		for i, v := range s.Options {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Options", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceDefinitions != nil {
		for i, v := range s.ResourceDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptions sets the Options field's value.
func (s *SitePlan) SetOptions(v []*NameValuePair) *SitePlan {
	s.Options = v
	return s
}

// SetResourceDefinitions sets the ResourceDefinitions field's value.
func (s *SitePlan) SetResourceDefinitions(v []*NetworkResourceDefinition) *SitePlan {
	s.ResourceDefinitions = v
	return s
}

type StartNetworkResourceUpdateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network resource.
	//
	// NetworkResourceArn is a required field
	NetworkResourceArn *string `locationName:"networkResourceArn" type:"string" required:"true"`

	// The reason for the return. Providing a reason for a return is optional.
	ReturnReason *string `locationName:"returnReason" type:"string"`

	// The shipping address. If you don't provide a shipping address when replacing
	// or returning a network resource, we use the address from the original order
	// for the network resource.
	ShippingAddress *Address `locationName:"shippingAddress" type:"structure"`

	// The update type.
	//
	//    * REPLACE - Submits a request to replace a defective radio unit. We provide
	//    a shipping label that you can use for the return process and we ship a
	//    replacement radio unit to you.
	//
	//    * RETURN - Submits a request to replace a radio unit that you no longer
	//    need. We provide a shipping label that you can use for the return process.
	//
	// UpdateType is a required field
	UpdateType *string `locationName:"updateType" type:"string" required:"true" enum:"UpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartNetworkResourceUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartNetworkResourceUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartNetworkResourceUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartNetworkResourceUpdateInput"}
	if s.NetworkResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkResourceArn"))
	}
	if s.UpdateType == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateType"))
	}
	if s.ShippingAddress != nil {
		if err := s.ShippingAddress.Validate(); err != nil {
			invalidParams.AddNested("ShippingAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkResourceArn sets the NetworkResourceArn field's value.
func (s *StartNetworkResourceUpdateInput) SetNetworkResourceArn(v string) *StartNetworkResourceUpdateInput {
	s.NetworkResourceArn = &v
	return s
}

// SetReturnReason sets the ReturnReason field's value.
func (s *StartNetworkResourceUpdateInput) SetReturnReason(v string) *StartNetworkResourceUpdateInput {
	s.ReturnReason = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *StartNetworkResourceUpdateInput) SetShippingAddress(v *Address) *StartNetworkResourceUpdateInput {
	s.ShippingAddress = v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *StartNetworkResourceUpdateInput) SetUpdateType(v string) *StartNetworkResourceUpdateInput {
	s.UpdateType = &v
	return s
}

type StartNetworkResourceUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The network resource.
	NetworkResource *NetworkResource `locationName:"networkResource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartNetworkResourceUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartNetworkResourceUpdateOutput) GoString() string {
	return s.String()
}

// SetNetworkResource sets the NetworkResource field's value.
func (s *StartNetworkResourceUpdateOutput) SetNetworkResource(v *NetworkResource) *StartNetworkResourceUpdateOutput {
	s.NetworkResource = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about tracking a shipment.
type TrackingInformation struct {
	_ struct{} `type:"structure"`

	// The tracking number of the shipment.
	TrackingNumber *string `locationName:"trackingNumber" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingInformation) GoString() string {
	return s.String()
}

// SetTrackingNumber sets the TrackingNumber field's value.
func (s *TrackingInformation) SetTrackingNumber(v string) *TrackingInformation {
	s.TrackingNumber = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateNetworkSiteInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkSiteInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkSiteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateNetworkSiteInput) SetClientToken(v string) *UpdateNetworkSiteInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateNetworkSiteInput) SetDescription(v string) *UpdateNetworkSiteInput {
	s.Description = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *UpdateNetworkSiteInput) SetNetworkSiteArn(v string) *UpdateNetworkSiteInput {
	s.NetworkSiteArn = &v
	return s
}

type UpdateNetworkSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`

	// The network site tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNetworkSiteOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSiteOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *UpdateNetworkSiteOutput) SetNetworkSite(v *NetworkSite) *UpdateNetworkSiteOutput {
	s.NetworkSite = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateNetworkSiteOutput) SetTags(v map[string]*string) *UpdateNetworkSiteOutput {
	s.Tags = v
	return s
}

type UpdateNetworkSitePlanInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to ensure idempotency (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the network site.
	//
	// NetworkSiteArn is a required field
	NetworkSiteArn *string `locationName:"networkSiteArn" type:"string" required:"true"`

	// The pending plan.
	//
	// PendingPlan is a required field
	PendingPlan *SitePlan `locationName:"pendingPlan" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSitePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSitePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkSitePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkSitePlanInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.NetworkSiteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkSiteArn"))
	}
	if s.PendingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("PendingPlan"))
	}
	if s.PendingPlan != nil {
		if err := s.PendingPlan.Validate(); err != nil {
			invalidParams.AddNested("PendingPlan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateNetworkSitePlanInput) SetClientToken(v string) *UpdateNetworkSitePlanInput {
	s.ClientToken = &v
	return s
}

// SetNetworkSiteArn sets the NetworkSiteArn field's value.
func (s *UpdateNetworkSitePlanInput) SetNetworkSiteArn(v string) *UpdateNetworkSitePlanInput {
	s.NetworkSiteArn = &v
	return s
}

// SetPendingPlan sets the PendingPlan field's value.
func (s *UpdateNetworkSitePlanInput) SetPendingPlan(v *SitePlan) *UpdateNetworkSitePlanInput {
	s.PendingPlan = v
	return s
}

type UpdateNetworkSitePlanOutput struct {
	_ struct{} `type:"structure"`

	// Information about the network site.
	NetworkSite *NetworkSite `locationName:"networkSite" type:"structure"`

	// The network site tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNetworkSitePlanOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSitePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkSitePlanOutput) GoString() string {
	return s.String()
}

// SetNetworkSite sets the NetworkSite field's value.
func (s *UpdateNetworkSitePlanOutput) SetNetworkSite(v *NetworkSite) *UpdateNetworkSitePlanOutput {
	s.NetworkSite = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateNetworkSitePlanOutput) SetTags(v map[string]*string) *UpdateNetworkSitePlanOutput {
	s.Tags = v
	return s
}

// The request failed validation.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that caused the error, if applicable.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a field that failed validation.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message about the validation failure.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name that failed validation.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AcknowledgmentStatusAcknowledging is a AcknowledgmentStatus enum value
	AcknowledgmentStatusAcknowledging = "ACKNOWLEDGING"

	// AcknowledgmentStatusAcknowledged is a AcknowledgmentStatus enum value
	AcknowledgmentStatusAcknowledged = "ACKNOWLEDGED"

	// AcknowledgmentStatusUnacknowledged is a AcknowledgmentStatus enum value
	AcknowledgmentStatusUnacknowledged = "UNACKNOWLEDGED"
)

// AcknowledgmentStatus_Values returns all elements of the AcknowledgmentStatus enum
func AcknowledgmentStatus_Values() []string {
	return []string{
		AcknowledgmentStatusAcknowledging,
		AcknowledgmentStatusAcknowledged,
		AcknowledgmentStatusUnacknowledged,
	}
}

const (
	// DeviceIdentifierFilterKeysStatus is a DeviceIdentifierFilterKeys enum value
	DeviceIdentifierFilterKeysStatus = "STATUS"

	// DeviceIdentifierFilterKeysOrder is a DeviceIdentifierFilterKeys enum value
	DeviceIdentifierFilterKeysOrder = "ORDER"

	// DeviceIdentifierFilterKeysTrafficGroup is a DeviceIdentifierFilterKeys enum value
	DeviceIdentifierFilterKeysTrafficGroup = "TRAFFIC_GROUP"
)

// DeviceIdentifierFilterKeys_Values returns all elements of the DeviceIdentifierFilterKeys enum
func DeviceIdentifierFilterKeys_Values() []string {
	return []string{
		DeviceIdentifierFilterKeysStatus,
		DeviceIdentifierFilterKeysOrder,
		DeviceIdentifierFilterKeysTrafficGroup,
	}
}

const (
	// DeviceIdentifierStatusActive is a DeviceIdentifierStatus enum value
	DeviceIdentifierStatusActive = "ACTIVE"

	// DeviceIdentifierStatusInactive is a DeviceIdentifierStatus enum value
	DeviceIdentifierStatusInactive = "INACTIVE"
)

// DeviceIdentifierStatus_Values returns all elements of the DeviceIdentifierStatus enum
func DeviceIdentifierStatus_Values() []string {
	return []string{
		DeviceIdentifierStatusActive,
		DeviceIdentifierStatusInactive,
	}
}

const (
	// ElevationReferenceAgl is a ElevationReference enum value
	ElevationReferenceAgl = "AGL"

	// ElevationReferenceAmsl is a ElevationReference enum value
	ElevationReferenceAmsl = "AMSL"
)

// ElevationReference_Values returns all elements of the ElevationReference enum
func ElevationReference_Values() []string {
	return []string{
		ElevationReferenceAgl,
		ElevationReferenceAmsl,
	}
}

const (
	// ElevationUnitFeet is a ElevationUnit enum value
	ElevationUnitFeet = "FEET"
)

// ElevationUnit_Values returns all elements of the ElevationUnit enum
func ElevationUnit_Values() []string {
	return []string{
		ElevationUnitFeet,
	}
}

const (
	// HealthStatusInitial is a HealthStatus enum value
	HealthStatusInitial = "INITIAL"

	// HealthStatusHealthy is a HealthStatus enum value
	HealthStatusHealthy = "HEALTHY"

	// HealthStatusUnhealthy is a HealthStatus enum value
	HealthStatusUnhealthy = "UNHEALTHY"
)

// HealthStatus_Values returns all elements of the HealthStatus enum
func HealthStatus_Values() []string {
	return []string{
		HealthStatusInitial,
		HealthStatusHealthy,
		HealthStatusUnhealthy,
	}
}

const (
	// NetworkFilterKeysStatus is a NetworkFilterKeys enum value
	NetworkFilterKeysStatus = "STATUS"
)

// NetworkFilterKeys_Values returns all elements of the NetworkFilterKeys enum
func NetworkFilterKeys_Values() []string {
	return []string{
		NetworkFilterKeysStatus,
	}
}

const (
	// NetworkResourceDefinitionTypeRadioUnit is a NetworkResourceDefinitionType enum value
	NetworkResourceDefinitionTypeRadioUnit = "RADIO_UNIT"

	// NetworkResourceDefinitionTypeDeviceIdentifier is a NetworkResourceDefinitionType enum value
	NetworkResourceDefinitionTypeDeviceIdentifier = "DEVICE_IDENTIFIER"
)

// NetworkResourceDefinitionType_Values returns all elements of the NetworkResourceDefinitionType enum
func NetworkResourceDefinitionType_Values() []string {
	return []string{
		NetworkResourceDefinitionTypeRadioUnit,
		NetworkResourceDefinitionTypeDeviceIdentifier,
	}
}

const (
	// NetworkResourceFilterKeysOrder is a NetworkResourceFilterKeys enum value
	NetworkResourceFilterKeysOrder = "ORDER"

	// NetworkResourceFilterKeysStatus is a NetworkResourceFilterKeys enum value
	NetworkResourceFilterKeysStatus = "STATUS"
)

// NetworkResourceFilterKeys_Values returns all elements of the NetworkResourceFilterKeys enum
func NetworkResourceFilterKeys_Values() []string {
	return []string{
		NetworkResourceFilterKeysOrder,
		NetworkResourceFilterKeysStatus,
	}
}

const (
	// NetworkResourceStatusPending is a NetworkResourceStatus enum value
	NetworkResourceStatusPending = "PENDING"

	// NetworkResourceStatusShipped is a NetworkResourceStatus enum value
	NetworkResourceStatusShipped = "SHIPPED"

	// NetworkResourceStatusProvisioning is a NetworkResourceStatus enum value
	NetworkResourceStatusProvisioning = "PROVISIONING"

	// NetworkResourceStatusProvisioned is a NetworkResourceStatus enum value
	NetworkResourceStatusProvisioned = "PROVISIONED"

	// NetworkResourceStatusAvailable is a NetworkResourceStatus enum value
	NetworkResourceStatusAvailable = "AVAILABLE"

	// NetworkResourceStatusDeleting is a NetworkResourceStatus enum value
	NetworkResourceStatusDeleting = "DELETING"

	// NetworkResourceStatusPendingReturn is a NetworkResourceStatus enum value
	NetworkResourceStatusPendingReturn = "PENDING_RETURN"

	// NetworkResourceStatusDeleted is a NetworkResourceStatus enum value
	NetworkResourceStatusDeleted = "DELETED"

	// NetworkResourceStatusCreatingShippingLabel is a NetworkResourceStatus enum value
	NetworkResourceStatusCreatingShippingLabel = "CREATING_SHIPPING_LABEL"
)

// NetworkResourceStatus_Values returns all elements of the NetworkResourceStatus enum
func NetworkResourceStatus_Values() []string {
	return []string{
		NetworkResourceStatusPending,
		NetworkResourceStatusShipped,
		NetworkResourceStatusProvisioning,
		NetworkResourceStatusProvisioned,
		NetworkResourceStatusAvailable,
		NetworkResourceStatusDeleting,
		NetworkResourceStatusPendingReturn,
		NetworkResourceStatusDeleted,
		NetworkResourceStatusCreatingShippingLabel,
	}
}

const (
	// NetworkResourceTypeRadioUnit is a NetworkResourceType enum value
	NetworkResourceTypeRadioUnit = "RADIO_UNIT"
)

// NetworkResourceType_Values returns all elements of the NetworkResourceType enum
func NetworkResourceType_Values() []string {
	return []string{
		NetworkResourceTypeRadioUnit,
	}
}

const (
	// NetworkSiteFilterKeysStatus is a NetworkSiteFilterKeys enum value
	NetworkSiteFilterKeysStatus = "STATUS"
)

// NetworkSiteFilterKeys_Values returns all elements of the NetworkSiteFilterKeys enum
func NetworkSiteFilterKeys_Values() []string {
	return []string{
		NetworkSiteFilterKeysStatus,
	}
}

const (
	// NetworkSiteStatusCreated is a NetworkSiteStatus enum value
	NetworkSiteStatusCreated = "CREATED"

	// NetworkSiteStatusProvisioning is a NetworkSiteStatus enum value
	NetworkSiteStatusProvisioning = "PROVISIONING"

	// NetworkSiteStatusAvailable is a NetworkSiteStatus enum value
	NetworkSiteStatusAvailable = "AVAILABLE"

	// NetworkSiteStatusDeprovisioning is a NetworkSiteStatus enum value
	NetworkSiteStatusDeprovisioning = "DEPROVISIONING"

	// NetworkSiteStatusDeleted is a NetworkSiteStatus enum value
	NetworkSiteStatusDeleted = "DELETED"
)

// NetworkSiteStatus_Values returns all elements of the NetworkSiteStatus enum
func NetworkSiteStatus_Values() []string {
	return []string{
		NetworkSiteStatusCreated,
		NetworkSiteStatusProvisioning,
		NetworkSiteStatusAvailable,
		NetworkSiteStatusDeprovisioning,
		NetworkSiteStatusDeleted,
	}
}

const (
	// NetworkStatusCreated is a NetworkStatus enum value
	NetworkStatusCreated = "CREATED"

	// NetworkStatusProvisioning is a NetworkStatus enum value
	NetworkStatusProvisioning = "PROVISIONING"

	// NetworkStatusAvailable is a NetworkStatus enum value
	NetworkStatusAvailable = "AVAILABLE"

	// NetworkStatusDeprovisioning is a NetworkStatus enum value
	NetworkStatusDeprovisioning = "DEPROVISIONING"

	// NetworkStatusDeleted is a NetworkStatus enum value
	NetworkStatusDeleted = "DELETED"
)

// NetworkStatus_Values returns all elements of the NetworkStatus enum
func NetworkStatus_Values() []string {
	return []string{
		NetworkStatusCreated,
		NetworkStatusProvisioning,
		NetworkStatusAvailable,
		NetworkStatusDeprovisioning,
		NetworkStatusDeleted,
	}
}

const (
	// OrderFilterKeysStatus is a OrderFilterKeys enum value
	OrderFilterKeysStatus = "STATUS"

	// OrderFilterKeysNetworkSite is a OrderFilterKeys enum value
	OrderFilterKeysNetworkSite = "NETWORK_SITE"
)

// OrderFilterKeys_Values returns all elements of the OrderFilterKeys enum
func OrderFilterKeys_Values() []string {
	return []string{
		OrderFilterKeysStatus,
		OrderFilterKeysNetworkSite,
	}
}

const (
	// UpdateTypeReplace is a UpdateType enum value
	UpdateTypeReplace = "REPLACE"

	// UpdateTypeReturn is a UpdateType enum value
	UpdateTypeReturn = "RETURN"
)

// UpdateType_Values returns all elements of the UpdateType enum
func UpdateType_Values() []string {
	return []string{
		UpdateTypeReplace,
		UpdateTypeReturn,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonCannotAssumeRole is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotAssumeRole = "CANNOT_ASSUME_ROLE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonCannotAssumeRole,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
