// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmessaging

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateChannelFlow = "AssociateChannelFlow"

// AssociateChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the AssociateChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateChannelFlow for more information on using the AssociateChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateChannelFlowRequest method.
//	req, resp := client.AssociateChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/AssociateChannelFlow
func (c *ChimeSDKMessaging) AssociateChannelFlowRequest(input *AssociateChannelFlowInput) (req *request.Request, output *AssociateChannelFlowOutput) {
	op := &request.Operation{
		Name:       opAssociateChannelFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/channel-flow",
	}

	if input == nil {
		input = &AssociateChannelFlowInput{}
	}

	output = &AssociateChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Associates a channel flow with a channel. Once associated, all messages to
// that channel go through channel flow processors. To stop processing, use
// the DisassociateChannelFlow API.
//
// Only administrators or channel moderators can associate a channel flow. The
// x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation AssociateChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/AssociateChannelFlow
func (c *ChimeSDKMessaging) AssociateChannelFlow(input *AssociateChannelFlowInput) (*AssociateChannelFlowOutput, error) {
	req, out := c.AssociateChannelFlowRequest(input)
	return out, req.Send()
}

// AssociateChannelFlowWithContext is the same as AssociateChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) AssociateChannelFlowWithContext(ctx aws.Context, input *AssociateChannelFlowInput, opts ...request.Option) (*AssociateChannelFlowOutput, error) {
	req, out := c.AssociateChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateChannelMembership = "BatchCreateChannelMembership"

// BatchCreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateChannelMembership for more information on using the BatchCreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateChannelMembershipRequest method.
//	req, resp := client.BatchCreateChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/BatchCreateChannelMembership
func (c *ChimeSDKMessaging) BatchCreateChannelMembershipRequest(input *BatchCreateChannelMembershipInput) (req *request.Request, output *BatchCreateChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opBatchCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateChannelMembershipInput{}
	}

	output = &BatchCreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Adds a specified number of users and bots to a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation BatchCreateChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/BatchCreateChannelMembership
func (c *ChimeSDKMessaging) BatchCreateChannelMembership(input *BatchCreateChannelMembershipInput) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	return out, req.Send()
}

// BatchCreateChannelMembershipWithContext is the same as BatchCreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) BatchCreateChannelMembershipWithContext(ctx aws.Context, input *BatchCreateChannelMembershipInput, opts ...request.Option) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChannelFlowCallback = "ChannelFlowCallback"

// ChannelFlowCallbackRequest generates a "aws/request.Request" representing the
// client's request for the ChannelFlowCallback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChannelFlowCallback for more information on using the ChannelFlowCallback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ChannelFlowCallbackRequest method.
//	req, resp := client.ChannelFlowCallbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ChannelFlowCallback
func (c *ChimeSDKMessaging) ChannelFlowCallbackRequest(input *ChannelFlowCallbackInput) (req *request.Request, output *ChannelFlowCallbackOutput) {
	op := &request.Operation{
		Name:       opChannelFlowCallback,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}?operation=channel-flow-callback",
	}

	if input == nil {
		input = &ChannelFlowCallbackInput{}
	}

	output = &ChannelFlowCallbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ChannelFlowCallback API operation for Amazon Chime SDK Messaging.
//
// Calls back Chime SDK Messaging with a processing response message. This should
// be invoked from the processor Lambda. This is a developer API.
//
// You can return one of the following processing responses:
//
//   - Update message content or metadata
//
//   - Deny a message
//
//   - Make no changes to the message
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ChannelFlowCallback for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ChannelFlowCallback
func (c *ChimeSDKMessaging) ChannelFlowCallback(input *ChannelFlowCallbackInput) (*ChannelFlowCallbackOutput, error) {
	req, out := c.ChannelFlowCallbackRequest(input)
	return out, req.Send()
}

// ChannelFlowCallbackWithContext is the same as ChannelFlowCallback with the addition of
// the ability to pass a context and additional request options.
//
// See ChannelFlowCallback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ChannelFlowCallbackWithContext(ctx aws.Context, input *ChannelFlowCallbackInput, opts ...request.Option) (*ChannelFlowCallbackOutput, error) {
	req, out := c.ChannelFlowCallbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannel
func (c *ChimeSDKMessaging) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for Amazon Chime SDK Messaging.
//
// Creates a channel to which you can add users and send messages.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannel
func (c *ChimeSDKMessaging) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelBan = "CreateChannelBan"

// CreateChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelBan for more information on using the CreateChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelBanRequest method.
//	req, resp := client.CreateChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelBan
func (c *ChimeSDKMessaging) CreateChannelBanRequest(input *CreateChannelBanInput) (req *request.Request, output *CreateChannelBanOutput) {
	op := &request.Operation{
		Name:       opCreateChannelBan,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/bans",
	}

	if input == nil {
		input = &CreateChannelBanInput{}
	}

	output = &CreateChannelBanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelBan API operation for Amazon Chime SDK Messaging.
//
// Permanently bans a member from a channel. Moderators can't add banned members
// to a channel. To undo a ban, you first have to DeleteChannelBan, and then
// CreateChannelMembership. Bans are cleaned up when you delete users or channels.
//
// If you ban a user who is already part of a channel, that user is automatically
// kicked from the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelBan
func (c *ChimeSDKMessaging) CreateChannelBan(input *CreateChannelBanInput) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	return out, req.Send()
}

// CreateChannelBanWithContext is the same as CreateChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelBanWithContext(ctx aws.Context, input *CreateChannelBanInput, opts ...request.Option) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelFlow = "CreateChannelFlow"

// CreateChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelFlow for more information on using the CreateChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelFlowRequest method.
//	req, resp := client.CreateChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelFlow
func (c *ChimeSDKMessaging) CreateChannelFlowRequest(input *CreateChannelFlowInput) (req *request.Request, output *CreateChannelFlowOutput) {
	op := &request.Operation{
		Name:       opCreateChannelFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/channel-flows",
	}

	if input == nil {
		input = &CreateChannelFlowInput{}
	}

	output = &CreateChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Creates a channel flow, a container for processors. Processors are AWS Lambda
// functions that perform actions on chat messages, such as stripping out profanity.
// You can associate channel flows with channels, and the processors in the
// channel flow then take action on all messages sent to that channel. This
// is a developer API.
//
// Channel flows process the following items:
//
// # New and updated messages
//
// # Persistent and non-persistent messages
//
// # The Standard message type
//
// Channel flows don't process Control or System messages. For more information
// about the message types provided by Chime SDK Messaging, refer to Message
// types (https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types)
// in the Amazon Chime developer guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelFlow
func (c *ChimeSDKMessaging) CreateChannelFlow(input *CreateChannelFlowInput) (*CreateChannelFlowOutput, error) {
	req, out := c.CreateChannelFlowRequest(input)
	return out, req.Send()
}

// CreateChannelFlowWithContext is the same as CreateChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelFlowWithContext(ctx aws.Context, input *CreateChannelFlowInput, opts ...request.Option) (*CreateChannelFlowOutput, error) {
	req, out := c.CreateChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelMembership = "CreateChannelMembership"

// CreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelMembership for more information on using the CreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelMembershipRequest method.
//	req, resp := client.CreateChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelMembership
func (c *ChimeSDKMessaging) CreateChannelMembershipRequest(input *CreateChannelMembershipInput) (req *request.Request, output *CreateChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships",
	}

	if input == nil {
		input = &CreateChannelMembershipInput{}
	}

	output = &CreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Adds a member to a channel. The InvitedBy field in ChannelMembership is derived
// from the request header. A channel member can:
//
//   - List messages
//
//   - Send messages
//
//   - Receive messages
//
//   - Edit their own messages
//
//   - Leave the channel
//
// Privacy settings impact this action as follows:
//
//   - Public Channels: You do not need to be a member to list messages, but
//     you must be a member to send messages.
//
//   - Private Channels: You must be a member to list or send messages.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUserArn
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelMembership
func (c *ChimeSDKMessaging) CreateChannelMembership(input *CreateChannelMembershipInput) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	return out, req.Send()
}

// CreateChannelMembershipWithContext is the same as CreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelMembershipWithContext(ctx aws.Context, input *CreateChannelMembershipInput, opts ...request.Option) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelModerator = "CreateChannelModerator"

// CreateChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelModerator for more information on using the CreateChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelModeratorRequest method.
//	req, resp := client.CreateChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelModerator
func (c *ChimeSDKMessaging) CreateChannelModeratorRequest(input *CreateChannelModeratorInput) (req *request.Request, output *CreateChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opCreateChannelModerator,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/moderators",
	}

	if input == nil {
		input = &CreateChannelModeratorInput{}
	}

	output = &CreateChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Creates a new ChannelModerator. A channel moderator can:
//
//   - Add and remove other members of the channel.
//
//   - Add and remove other moderators of the channel.
//
//   - Add and remove user bans for the channel.
//
//   - Redact messages in the channel.
//
//   - List messages in the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBotof the user that makes the API call as the value in the
// header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation CreateChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/CreateChannelModerator
func (c *ChimeSDKMessaging) CreateChannelModerator(input *CreateChannelModeratorInput) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	return out, req.Send()
}

// CreateChannelModeratorWithContext is the same as CreateChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) CreateChannelModeratorWithContext(ctx aws.Context, input *CreateChannelModeratorInput, opts ...request.Option) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannel
func (c *ChimeSDKMessaging) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for Amazon Chime SDK Messaging.
//
// Immediately makes a channel and its memberships inaccessible and marks them
// for deletion. This is an irreversible process.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUserArn
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannel
func (c *ChimeSDKMessaging) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelBan = "DeleteChannelBan"

// DeleteChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelBan for more information on using the DeleteChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelBanRequest method.
//	req, resp := client.DeleteChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelBan
func (c *ChimeSDKMessaging) DeleteChannelBanRequest(input *DeleteChannelBanInput) (req *request.Request, output *DeleteChannelBanOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelBan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelBanInput{}
	}

	output = &DeleteChannelBanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelBan API operation for Amazon Chime SDK Messaging.
//
// Removes a member from a channel's ban list.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelBan
func (c *ChimeSDKMessaging) DeleteChannelBan(input *DeleteChannelBanInput) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	return out, req.Send()
}

// DeleteChannelBanWithContext is the same as DeleteChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelBanWithContext(ctx aws.Context, input *DeleteChannelBanInput, opts ...request.Option) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelFlow = "DeleteChannelFlow"

// DeleteChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelFlow for more information on using the DeleteChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelFlowRequest method.
//	req, resp := client.DeleteChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelFlow
func (c *ChimeSDKMessaging) DeleteChannelFlowRequest(input *DeleteChannelFlowInput) (req *request.Request, output *DeleteChannelFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channel-flows/{channelFlowArn}",
	}

	if input == nil {
		input = &DeleteChannelFlowInput{}
	}

	output = &DeleteChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Deletes a channel flow, an irreversible process. This is a developer API.
//
// This API works only when the channel flow is not associated with any channel.
// To get a list of all channels that a channel flow is associated with, use
// the ListChannelsAssociatedWithChannelFlow API. Use the DisassociateChannelFlow
// API to disassociate a channel flow from all channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelFlow
func (c *ChimeSDKMessaging) DeleteChannelFlow(input *DeleteChannelFlowInput) (*DeleteChannelFlowOutput, error) {
	req, out := c.DeleteChannelFlowRequest(input)
	return out, req.Send()
}

// DeleteChannelFlowWithContext is the same as DeleteChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelFlowWithContext(ctx aws.Context, input *DeleteChannelFlowInput, opts ...request.Option) (*DeleteChannelFlowOutput, error) {
	req, out := c.DeleteChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMembership = "DeleteChannelMembership"

// DeleteChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMembership for more information on using the DeleteChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelMembershipRequest method.
//	req, resp := client.DeleteChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMembership
func (c *ChimeSDKMessaging) DeleteChannelMembershipRequest(input *DeleteChannelMembershipInput) (req *request.Request, output *DeleteChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelMembershipInput{}
	}

	output = &DeleteChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Removes a member from a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMembership
func (c *ChimeSDKMessaging) DeleteChannelMembership(input *DeleteChannelMembershipInput) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	return out, req.Send()
}

// DeleteChannelMembershipWithContext is the same as DeleteChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelMembershipWithContext(ctx aws.Context, input *DeleteChannelMembershipInput, opts ...request.Option) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMessage = "DeleteChannelMessage"

// DeleteChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMessage for more information on using the DeleteChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelMessageRequest method.
//	req, resp := client.DeleteChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMessage
func (c *ChimeSDKMessaging) DeleteChannelMessageRequest(input *DeleteChannelMessageInput) (req *request.Request, output *DeleteChannelMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelMessage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &DeleteChannelMessageInput{}
	}

	output = &DeleteChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Deletes a channel message. Only admins can perform this action. Deletion
// makes messages inaccessible immediately. A background process deletes any
// revisions created by UpdateChannelMessage.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMessage
func (c *ChimeSDKMessaging) DeleteChannelMessage(input *DeleteChannelMessageInput) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	return out, req.Send()
}

// DeleteChannelMessageWithContext is the same as DeleteChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelMessageWithContext(ctx aws.Context, input *DeleteChannelMessageInput, opts ...request.Option) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelModerator = "DeleteChannelModerator"

// DeleteChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelModerator for more information on using the DeleteChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelModeratorRequest method.
//	req, resp := client.DeleteChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelModerator
func (c *ChimeSDKMessaging) DeleteChannelModeratorRequest(input *DeleteChannelModeratorInput) (req *request.Request, output *DeleteChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelModerator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DeleteChannelModeratorInput{}
	}

	output = &DeleteChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Deletes a channel moderator.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelModerator
func (c *ChimeSDKMessaging) DeleteChannelModerator(input *DeleteChannelModeratorInput) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	return out, req.Send()
}

// DeleteChannelModeratorWithContext is the same as DeleteChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteChannelModeratorWithContext(ctx aws.Context, input *DeleteChannelModeratorInput, opts ...request.Option) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMessagingStreamingConfigurations = "DeleteMessagingStreamingConfigurations"

// DeleteMessagingStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMessagingStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMessagingStreamingConfigurations for more information on using the DeleteMessagingStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMessagingStreamingConfigurationsRequest method.
//	req, resp := client.DeleteMessagingStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) DeleteMessagingStreamingConfigurationsRequest(input *DeleteMessagingStreamingConfigurationsInput) (req *request.Request, output *DeleteMessagingStreamingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDeleteMessagingStreamingConfigurations,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &DeleteMessagingStreamingConfigurationsInput{}
	}

	output = &DeleteMessagingStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMessagingStreamingConfigurations API operation for Amazon Chime SDK Messaging.
//
// Deletes the streaming configurations for an AppInstance. For more information,
// see Streaming messaging data (https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DeleteMessagingStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) DeleteMessagingStreamingConfigurations(input *DeleteMessagingStreamingConfigurationsInput) (*DeleteMessagingStreamingConfigurationsOutput, error) {
	req, out := c.DeleteMessagingStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// DeleteMessagingStreamingConfigurationsWithContext is the same as DeleteMessagingStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMessagingStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DeleteMessagingStreamingConfigurationsWithContext(ctx aws.Context, input *DeleteMessagingStreamingConfigurationsInput, opts ...request.Option) (*DeleteMessagingStreamingConfigurationsOutput, error) {
	req, out := c.DeleteMessagingStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelRequest method.
//	req, resp := client.DescribeChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannel
func (c *ChimeSDKMessaging) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel in an Amazon Chime AppInstance.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannel
func (c *ChimeSDKMessaging) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelBan = "DescribeChannelBan"

// DescribeChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelBan for more information on using the DescribeChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelBanRequest method.
//	req, resp := client.DescribeChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelBan
func (c *ChimeSDKMessaging) DescribeChannelBanRequest(input *DescribeChannelBanInput) (req *request.Request, output *DescribeChannelBanOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelBan,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelBanInput{}
	}

	output = &DescribeChannelBanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelBan API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel ban.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelBan
func (c *ChimeSDKMessaging) DescribeChannelBan(input *DescribeChannelBanInput) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	return out, req.Send()
}

// DescribeChannelBanWithContext is the same as DescribeChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelBanWithContext(ctx aws.Context, input *DescribeChannelBanInput, opts ...request.Option) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelFlow = "DescribeChannelFlow"

// DescribeChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelFlow for more information on using the DescribeChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelFlowRequest method.
//	req, resp := client.DescribeChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelFlow
func (c *ChimeSDKMessaging) DescribeChannelFlowRequest(input *DescribeChannelFlowInput) (req *request.Request, output *DescribeChannelFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/channel-flows/{channelFlowArn}",
	}

	if input == nil {
		input = &DescribeChannelFlowInput{}
	}

	output = &DescribeChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel flow in an Amazon Chime AppInstance.
// This is a developer API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelFlow
func (c *ChimeSDKMessaging) DescribeChannelFlow(input *DescribeChannelFlowInput) (*DescribeChannelFlowOutput, error) {
	req, out := c.DescribeChannelFlowRequest(input)
	return out, req.Send()
}

// DescribeChannelFlowWithContext is the same as DescribeChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelFlowWithContext(ctx aws.Context, input *DescribeChannelFlowInput, opts ...request.Option) (*DescribeChannelFlowOutput, error) {
	req, out := c.DescribeChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembership = "DescribeChannelMembership"

// DescribeChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembership for more information on using the DescribeChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelMembershipRequest method.
//	req, resp := client.DescribeChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembership
func (c *ChimeSDKMessaging) DescribeChannelMembershipRequest(input *DescribeChannelMembershipInput) (req *request.Request, output *DescribeChannelMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelMembershipInput{}
	}

	output = &DescribeChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelMembership API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a user's channel membership.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembership
func (c *ChimeSDKMessaging) DescribeChannelMembership(input *DescribeChannelMembershipInput) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipWithContext is the same as DescribeChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelMembershipWithContext(ctx aws.Context, input *DescribeChannelMembershipInput, opts ...request.Option) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembershipForAppInstanceUser = "DescribeChannelMembershipForAppInstanceUser"

// DescribeChannelMembershipForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembershipForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembershipForAppInstanceUser for more information on using the DescribeChannelMembershipForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelMembershipForAppInstanceUserRequest method.
//	req, resp := client.DescribeChannelMembershipForAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembershipForAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUserRequest(input *DescribeChannelMembershipForAppInstanceUserInput) (req *request.Request, output *DescribeChannelMembershipForAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelMembershipForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-membership",
	}

	if input == nil {
		input = &DescribeChannelMembershipForAppInstanceUserInput{}
	}

	output = &DescribeChannelMembershipForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelMembershipForAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Returns the details of a channel based on the membership of the specified
// AppInstanceUser or AppInstanceBot.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelMembershipForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelMembershipForAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUser(input *DescribeChannelMembershipForAppInstanceUserInput) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipForAppInstanceUserWithContext is the same as DescribeChannelMembershipForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembershipForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelMembershipForAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelMembershipForAppInstanceUserInput, opts ...request.Option) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModeratedByAppInstanceUser = "DescribeChannelModeratedByAppInstanceUser"

// DescribeChannelModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModeratedByAppInstanceUser for more information on using the DescribeChannelModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelModeratedByAppInstanceUserRequest method.
//	req, resp := client.DescribeChannelModeratedByAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUserRequest(input *DescribeChannelModeratedByAppInstanceUserInput) (req *request.Request, output *DescribeChannelModeratedByAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-moderated-channel",
	}

	if input == nil {
		input = &DescribeChannelModeratedByAppInstanceUserInput{}
	}

	output = &DescribeChannelModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelModeratedByAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a channel moderated by the specified AppInstanceUser
// or AppInstanceBot.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUser(input *DescribeChannelModeratedByAppInstanceUserInput) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratedByAppInstanceUserWithContext is the same as DescribeChannelModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelModeratedByAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelModeratedByAppInstanceUserInput, opts ...request.Option) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModerator = "DescribeChannelModerator"

// DescribeChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModerator for more information on using the DescribeChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelModeratorRequest method.
//	req, resp := client.DescribeChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModerator
func (c *ChimeSDKMessaging) DescribeChannelModeratorRequest(input *DescribeChannelModeratorInput) (req *request.Request, output *DescribeChannelModeratorOutput) {
	op := &request.Operation{
		Name:       opDescribeChannelModerator,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DescribeChannelModeratorInput{}
	}

	output = &DescribeChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannelModerator API operation for Amazon Chime SDK Messaging.
//
// Returns the full details of a single ChannelModerator.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DescribeChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DescribeChannelModerator
func (c *ChimeSDKMessaging) DescribeChannelModerator(input *DescribeChannelModeratorInput) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratorWithContext is the same as DescribeChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DescribeChannelModeratorWithContext(ctx aws.Context, input *DescribeChannelModeratorInput, opts ...request.Option) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateChannelFlow = "DisassociateChannelFlow"

// DisassociateChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateChannelFlow for more information on using the DisassociateChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateChannelFlowRequest method.
//	req, resp := client.DisassociateChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DisassociateChannelFlow
func (c *ChimeSDKMessaging) DisassociateChannelFlowRequest(input *DisassociateChannelFlowInput) (req *request.Request, output *DisassociateChannelFlowOutput) {
	op := &request.Operation{
		Name:       opDisassociateChannelFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/channel-flow/{channelFlowArn}",
	}

	if input == nil {
		input = &DisassociateChannelFlowInput{}
	}

	output = &DisassociateChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Disassociates a channel flow from all its channels. Once disassociated, all
// messages to that channel stop going through the channel flow processor.
//
// Only administrators or channel moderators can disassociate a channel flow.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation DisassociateChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DisassociateChannelFlow
func (c *ChimeSDKMessaging) DisassociateChannelFlow(input *DisassociateChannelFlowInput) (*DisassociateChannelFlowOutput, error) {
	req, out := c.DisassociateChannelFlowRequest(input)
	return out, req.Send()
}

// DisassociateChannelFlowWithContext is the same as DisassociateChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) DisassociateChannelFlowWithContext(ctx aws.Context, input *DisassociateChannelFlowInput, opts ...request.Option) (*DisassociateChannelFlowOutput, error) {
	req, out := c.DisassociateChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelMembershipPreferences = "GetChannelMembershipPreferences"

// GetChannelMembershipPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelMembershipPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelMembershipPreferences for more information on using the GetChannelMembershipPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelMembershipPreferencesRequest method.
//	req, resp := client.GetChannelMembershipPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMembershipPreferences
func (c *ChimeSDKMessaging) GetChannelMembershipPreferencesRequest(input *GetChannelMembershipPreferencesInput) (req *request.Request, output *GetChannelMembershipPreferencesOutput) {
	op := &request.Operation{
		Name:       opGetChannelMembershipPreferences,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}/preferences",
	}

	if input == nil {
		input = &GetChannelMembershipPreferencesInput{}
	}

	output = &GetChannelMembershipPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelMembershipPreferences API operation for Amazon Chime SDK Messaging.
//
// Gets the membership preferences of an AppInstanceUser or AppInstanceBot for
// the specified channel. A user or a bot must be a member of the channel and
// own the membership to be able to retrieve membership preferences. Users or
// bots in the AppInstanceAdmin and channel moderator roles can't retrieve preferences
// for other users or bots. Banned users or bots can't retrieve membership preferences
// for the channel from which they are banned.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetChannelMembershipPreferences for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMembershipPreferences
func (c *ChimeSDKMessaging) GetChannelMembershipPreferences(input *GetChannelMembershipPreferencesInput) (*GetChannelMembershipPreferencesOutput, error) {
	req, out := c.GetChannelMembershipPreferencesRequest(input)
	return out, req.Send()
}

// GetChannelMembershipPreferencesWithContext is the same as GetChannelMembershipPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelMembershipPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetChannelMembershipPreferencesWithContext(ctx aws.Context, input *GetChannelMembershipPreferencesInput, opts ...request.Option) (*GetChannelMembershipPreferencesOutput, error) {
	req, out := c.GetChannelMembershipPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelMessage = "GetChannelMessage"

// GetChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelMessage for more information on using the GetChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelMessageRequest method.
//	req, resp := client.GetChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessage
func (c *ChimeSDKMessaging) GetChannelMessageRequest(input *GetChannelMessageInput) (req *request.Request, output *GetChannelMessageOutput) {
	op := &request.Operation{
		Name:       opGetChannelMessage,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &GetChannelMessageInput{}
	}

	output = &GetChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Gets the full details of a channel message.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessage
func (c *ChimeSDKMessaging) GetChannelMessage(input *GetChannelMessageInput) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	return out, req.Send()
}

// GetChannelMessageWithContext is the same as GetChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetChannelMessageWithContext(ctx aws.Context, input *GetChannelMessageInput, opts ...request.Option) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelMessageStatus = "GetChannelMessageStatus"

// GetChannelMessageStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelMessageStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelMessageStatus for more information on using the GetChannelMessageStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelMessageStatusRequest method.
//	req, resp := client.GetChannelMessageStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessageStatus
func (c *ChimeSDKMessaging) GetChannelMessageStatusRequest(input *GetChannelMessageStatusInput) (req *request.Request, output *GetChannelMessageStatusOutput) {
	op := &request.Operation{
		Name:       opGetChannelMessageStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}?scope=message-status",
	}

	if input == nil {
		input = &GetChannelMessageStatusInput{}
	}

	output = &GetChannelMessageStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelMessageStatus API operation for Amazon Chime SDK Messaging.
//
// Gets message status for a specified messageId. Use this API to determine
// the intermediate status of messages going through channel flow processing.
// The API provides an alternative to retrieving message status if the event
// was not received because a client wasn't connected to a websocket.
//
// Messages can have any one of these statuses.
//
// # SENT
//
// # Message processed successfully
//
// # PENDING
//
// # Ongoing processing
//
// # FAILED
//
// # Processing failed
//
// # DENIED
//
// Messasge denied by the processor
//
//   - This API does not return statuses for denied messages, because we don't
//     store them once the processor denies them.
//
//   - Only the message sender can invoke this API.
//
//   - The x-amz-chime-bearer request header is mandatory. Use the ARN of the
//     AppInstanceUser or AppInstanceBot that makes the API call as the value
//     in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetChannelMessageStatus for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetChannelMessageStatus
func (c *ChimeSDKMessaging) GetChannelMessageStatus(input *GetChannelMessageStatusInput) (*GetChannelMessageStatusOutput, error) {
	req, out := c.GetChannelMessageStatusRequest(input)
	return out, req.Send()
}

// GetChannelMessageStatusWithContext is the same as GetChannelMessageStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelMessageStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetChannelMessageStatusWithContext(ctx aws.Context, input *GetChannelMessageStatusInput, opts ...request.Option) (*GetChannelMessageStatusOutput, error) {
	req, out := c.GetChannelMessageStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMessagingSessionEndpoint = "GetMessagingSessionEndpoint"

// GetMessagingSessionEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetMessagingSessionEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMessagingSessionEndpoint for more information on using the GetMessagingSessionEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMessagingSessionEndpointRequest method.
//	req, resp := client.GetMessagingSessionEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingSessionEndpoint
func (c *ChimeSDKMessaging) GetMessagingSessionEndpointRequest(input *GetMessagingSessionEndpointInput) (req *request.Request, output *GetMessagingSessionEndpointOutput) {
	op := &request.Operation{
		Name:       opGetMessagingSessionEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoints/messaging-session",
	}

	if input == nil {
		input = &GetMessagingSessionEndpointInput{}
	}

	output = &GetMessagingSessionEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMessagingSessionEndpoint API operation for Amazon Chime SDK Messaging.
//
// The details of the endpoint for the messaging session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetMessagingSessionEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingSessionEndpoint
func (c *ChimeSDKMessaging) GetMessagingSessionEndpoint(input *GetMessagingSessionEndpointInput) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	return out, req.Send()
}

// GetMessagingSessionEndpointWithContext is the same as GetMessagingSessionEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetMessagingSessionEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetMessagingSessionEndpointWithContext(ctx aws.Context, input *GetMessagingSessionEndpointInput, opts ...request.Option) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMessagingStreamingConfigurations = "GetMessagingStreamingConfigurations"

// GetMessagingStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the GetMessagingStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMessagingStreamingConfigurations for more information on using the GetMessagingStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMessagingStreamingConfigurationsRequest method.
//	req, resp := client.GetMessagingStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) GetMessagingStreamingConfigurationsRequest(input *GetMessagingStreamingConfigurationsInput) (req *request.Request, output *GetMessagingStreamingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opGetMessagingStreamingConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &GetMessagingStreamingConfigurationsInput{}
	}

	output = &GetMessagingStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMessagingStreamingConfigurations API operation for Amazon Chime SDK Messaging.
//
// Retrieves the data streaming configuration for an AppInstance. For more information,
// see Streaming messaging data (https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation GetMessagingStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/GetMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) GetMessagingStreamingConfigurations(input *GetMessagingStreamingConfigurationsInput) (*GetMessagingStreamingConfigurationsOutput, error) {
	req, out := c.GetMessagingStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// GetMessagingStreamingConfigurationsWithContext is the same as GetMessagingStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See GetMessagingStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) GetMessagingStreamingConfigurationsWithContext(ctx aws.Context, input *GetMessagingStreamingConfigurationsInput, opts ...request.Option) (*GetMessagingStreamingConfigurationsOutput, error) {
	req, out := c.GetMessagingStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannelBans = "ListChannelBans"

// ListChannelBansRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelBans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelBans for more information on using the ListChannelBans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelBansRequest method.
//	req, resp := client.ListChannelBansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelBans
func (c *ChimeSDKMessaging) ListChannelBansRequest(input *ListChannelBansInput) (req *request.Request, output *ListChannelBansOutput) {
	op := &request.Operation{
		Name:       opListChannelBans,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelBansInput{}
	}

	output = &ListChannelBansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelBans API operation for Amazon Chime SDK Messaging.
//
// Lists all the users and bots banned from a particular channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelBans for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelBans
func (c *ChimeSDKMessaging) ListChannelBans(input *ListChannelBansInput) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	return out, req.Send()
}

// ListChannelBansWithContext is the same as ListChannelBans with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelBans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelBansWithContext(ctx aws.Context, input *ListChannelBansInput, opts ...request.Option) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelBansPages iterates over the pages of a ListChannelBans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelBans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelBans operation.
//	pageNum := 0
//	err := client.ListChannelBansPages(params,
//	    func(page *chimesdkmessaging.ListChannelBansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelBansPages(input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool) error {
	return c.ListChannelBansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelBansPagesWithContext same as ListChannelBansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelBansPagesWithContext(ctx aws.Context, input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelBansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelBansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelBansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelFlows = "ListChannelFlows"

// ListChannelFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelFlows for more information on using the ListChannelFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelFlowsRequest method.
//	req, resp := client.ListChannelFlowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelFlows
func (c *ChimeSDKMessaging) ListChannelFlowsRequest(input *ListChannelFlowsInput) (req *request.Request, output *ListChannelFlowsOutput) {
	op := &request.Operation{
		Name:       opListChannelFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/channel-flows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelFlowsInput{}
	}

	output = &ListChannelFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelFlows API operation for Amazon Chime SDK Messaging.
//
// Returns a paginated lists of all the channel flows created under a single
// Chime. This is a developer API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelFlows for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelFlows
func (c *ChimeSDKMessaging) ListChannelFlows(input *ListChannelFlowsInput) (*ListChannelFlowsOutput, error) {
	req, out := c.ListChannelFlowsRequest(input)
	return out, req.Send()
}

// ListChannelFlowsWithContext is the same as ListChannelFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelFlowsWithContext(ctx aws.Context, input *ListChannelFlowsInput, opts ...request.Option) (*ListChannelFlowsOutput, error) {
	req, out := c.ListChannelFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelFlowsPages iterates over the pages of a ListChannelFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelFlows operation.
//	pageNum := 0
//	err := client.ListChannelFlowsPages(params,
//	    func(page *chimesdkmessaging.ListChannelFlowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelFlowsPages(input *ListChannelFlowsInput, fn func(*ListChannelFlowsOutput, bool) bool) error {
	return c.ListChannelFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelFlowsPagesWithContext same as ListChannelFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelFlowsPagesWithContext(ctx aws.Context, input *ListChannelFlowsInput, fn func(*ListChannelFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMemberships = "ListChannelMemberships"

// ListChannelMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMemberships for more information on using the ListChannelMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMembershipsRequest method.
//	req, resp := client.ListChannelMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMemberships
func (c *ChimeSDKMessaging) ListChannelMembershipsRequest(input *ListChannelMembershipsInput) (req *request.Request, output *ListChannelMembershipsOutput) {
	op := &request.Operation{
		Name:       opListChannelMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsInput{}
	}

	output = &ListChannelMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMemberships API operation for Amazon Chime SDK Messaging.
//
// Lists all channel memberships in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// If you want to list the channels to which a specific app instance user belongs,
// see the ListChannelMembershipsForAppInstanceUser (https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMemberships for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMemberships
func (c *ChimeSDKMessaging) ListChannelMemberships(input *ListChannelMembershipsInput) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsWithContext is the same as ListChannelMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsWithContext(ctx aws.Context, input *ListChannelMembershipsInput, opts ...request.Option) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsPages iterates over the pages of a ListChannelMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMemberships operation.
//	pageNum := 0
//	err := client.ListChannelMembershipsPages(params,
//	    func(page *chimesdkmessaging.ListChannelMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelMembershipsPages(input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool) error {
	return c.ListChannelMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsPagesWithContext same as ListChannelMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsPagesWithContext(ctx aws.Context, input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMembershipsForAppInstanceUser = "ListChannelMembershipsForAppInstanceUser"

// ListChannelMembershipsForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMembershipsForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMembershipsForAppInstanceUser for more information on using the ListChannelMembershipsForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMembershipsForAppInstanceUserRequest method.
//	req, resp := client.ListChannelMembershipsForAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMembershipsForAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserRequest(input *ListChannelMembershipsForAppInstanceUserInput) (req *request.Request, output *ListChannelMembershipsForAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opListChannelMembershipsForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsForAppInstanceUserInput{}
	}

	output = &ListChannelMembershipsForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMembershipsForAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// Lists all channels that anr AppInstanceUser or AppInstanceBot is a part of.
// Only an AppInstanceAdmin can call the API with a user ARN that is not their
// own.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMembershipsForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMembershipsForAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUser(input *ListChannelMembershipsForAppInstanceUserInput) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserWithContext is the same as ListChannelMembershipsForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMembershipsForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, opts ...request.Option) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserPages iterates over the pages of a ListChannelMembershipsForAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMembershipsForAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMembershipsForAppInstanceUser operation.
//	pageNum := 0
//	err := client.ListChannelMembershipsForAppInstanceUserPages(params,
//	    func(page *chimesdkmessaging.ListChannelMembershipsForAppInstanceUserOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserPages(input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelMembershipsForAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsForAppInstanceUserPagesWithContext same as ListChannelMembershipsForAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMembershipsForAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsForAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsForAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsForAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMessages = "ListChannelMessages"

// ListChannelMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMessages for more information on using the ListChannelMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMessagesRequest method.
//	req, resp := client.ListChannelMessagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMessages
func (c *ChimeSDKMessaging) ListChannelMessagesRequest(input *ListChannelMessagesInput) (req *request.Request, output *ListChannelMessagesOutput) {
	op := &request.Operation{
		Name:       opListChannelMessages,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMessagesInput{}
	}

	output = &ListChannelMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelMessages API operation for Amazon Chime SDK Messaging.
//
// List all the messages in a channel. Returns a paginated list of ChannelMessages.
// By default, sorted by creation timestamp in descending order.
//
// Redacted messages appear in the results as empty, since they are only redacted,
// not deleted. Deleted messages do not appear in the results. This action always
// returns the latest version of an edited message.
//
// Also, the x-amz-chime-bearer request header is mandatory. Use the ARN of
// the AppInstanceUser or AppInstanceBot that makes the API call as the value
// in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelMessages for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelMessages
func (c *ChimeSDKMessaging) ListChannelMessages(input *ListChannelMessagesInput) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	return out, req.Send()
}

// ListChannelMessagesWithContext is the same as ListChannelMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMessagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, opts ...request.Option) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMessagesPages iterates over the pages of a ListChannelMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMessages operation.
//	pageNum := 0
//	err := client.ListChannelMessagesPages(params,
//	    func(page *chimesdkmessaging.ListChannelMessagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelMessagesPages(input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool) error {
	return c.ListChannelMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMessagesPagesWithContext same as ListChannelMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelMessagesPagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMessagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelModerators = "ListChannelModerators"

// ListChannelModeratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelModerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelModerators for more information on using the ListChannelModerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelModeratorsRequest method.
//	req, resp := client.ListChannelModeratorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelModerators
func (c *ChimeSDKMessaging) ListChannelModeratorsRequest(input *ListChannelModeratorsInput) (req *request.Request, output *ListChannelModeratorsOutput) {
	op := &request.Operation{
		Name:       opListChannelModerators,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelModeratorsInput{}
	}

	output = &ListChannelModeratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelModerators API operation for Amazon Chime SDK Messaging.
//
// Lists all the moderators for a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelModerators for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelModerators
func (c *ChimeSDKMessaging) ListChannelModerators(input *ListChannelModeratorsInput) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	return out, req.Send()
}

// ListChannelModeratorsWithContext is the same as ListChannelModerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelModerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelModeratorsWithContext(ctx aws.Context, input *ListChannelModeratorsInput, opts ...request.Option) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelModeratorsPages iterates over the pages of a ListChannelModerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelModerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelModerators operation.
//	pageNum := 0
//	err := client.ListChannelModeratorsPages(params,
//	    func(page *chimesdkmessaging.ListChannelModeratorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelModeratorsPages(input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool) error {
	return c.ListChannelModeratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelModeratorsPagesWithContext same as ListChannelModeratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelModeratorsPagesWithContext(ctx aws.Context, input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelModeratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelModeratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelModeratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannels
func (c *ChimeSDKMessaging) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for Amazon Chime SDK Messaging.
//
// Lists all Channels created under a single Chime App as a paginated list.
// You can specify filters to narrow results.
//
// Functionality & restrictions
//
//   - Use privacy = PUBLIC to retrieve all public channels in the account.
//
//   - Only an AppInstanceAdmin can set privacy = PRIVATE to list the private
//     channels in an account.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannels
func (c *ChimeSDKMessaging) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *chimesdkmessaging.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelsAssociatedWithChannelFlow = "ListChannelsAssociatedWithChannelFlow"

// ListChannelsAssociatedWithChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelsAssociatedWithChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelsAssociatedWithChannelFlow for more information on using the ListChannelsAssociatedWithChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsAssociatedWithChannelFlowRequest method.
//	req, resp := client.ListChannelsAssociatedWithChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsAssociatedWithChannelFlow
func (c *ChimeSDKMessaging) ListChannelsAssociatedWithChannelFlowRequest(input *ListChannelsAssociatedWithChannelFlowInput) (req *request.Request, output *ListChannelsAssociatedWithChannelFlowOutput) {
	op := &request.Operation{
		Name:       opListChannelsAssociatedWithChannelFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=channel-flow-associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsAssociatedWithChannelFlowInput{}
	}

	output = &ListChannelsAssociatedWithChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelsAssociatedWithChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Lists all channels associated with a specified channel flow. You can associate
// a channel flow with multiple channels, but you can only associate a channel
// with one channel flow. This is a developer API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelsAssociatedWithChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsAssociatedWithChannelFlow
func (c *ChimeSDKMessaging) ListChannelsAssociatedWithChannelFlow(input *ListChannelsAssociatedWithChannelFlowInput) (*ListChannelsAssociatedWithChannelFlowOutput, error) {
	req, out := c.ListChannelsAssociatedWithChannelFlowRequest(input)
	return out, req.Send()
}

// ListChannelsAssociatedWithChannelFlowWithContext is the same as ListChannelsAssociatedWithChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelsAssociatedWithChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsAssociatedWithChannelFlowWithContext(ctx aws.Context, input *ListChannelsAssociatedWithChannelFlowInput, opts ...request.Option) (*ListChannelsAssociatedWithChannelFlowOutput, error) {
	req, out := c.ListChannelsAssociatedWithChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsAssociatedWithChannelFlowPages iterates over the pages of a ListChannelsAssociatedWithChannelFlow operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelsAssociatedWithChannelFlow method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelsAssociatedWithChannelFlow operation.
//	pageNum := 0
//	err := client.ListChannelsAssociatedWithChannelFlowPages(params,
//	    func(page *chimesdkmessaging.ListChannelsAssociatedWithChannelFlowOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelsAssociatedWithChannelFlowPages(input *ListChannelsAssociatedWithChannelFlowInput, fn func(*ListChannelsAssociatedWithChannelFlowOutput, bool) bool) error {
	return c.ListChannelsAssociatedWithChannelFlowPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsAssociatedWithChannelFlowPagesWithContext same as ListChannelsAssociatedWithChannelFlowPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsAssociatedWithChannelFlowPagesWithContext(ctx aws.Context, input *ListChannelsAssociatedWithChannelFlowInput, fn func(*ListChannelsAssociatedWithChannelFlowOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsAssociatedWithChannelFlowInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsAssociatedWithChannelFlowRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsAssociatedWithChannelFlowOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelsModeratedByAppInstanceUser = "ListChannelsModeratedByAppInstanceUser"

// ListChannelsModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelsModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelsModeratedByAppInstanceUser for more information on using the ListChannelsModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsModeratedByAppInstanceUserRequest method.
//	req, resp := client.ListChannelsModeratedByAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserRequest(input *ListChannelsModeratedByAppInstanceUserInput) (req *request.Request, output *ListChannelsModeratedByAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opListChannelsModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-moderated-channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsModeratedByAppInstanceUserInput{}
	}

	output = &ListChannelsModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelsModeratedByAppInstanceUser API operation for Amazon Chime SDK Messaging.
//
// A list of the channels moderated by an AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListChannelsModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListChannelsModeratedByAppInstanceUser
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUser(input *ListChannelsModeratedByAppInstanceUserInput) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserWithContext is the same as ListChannelsModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelsModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, opts ...request.Option) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserPages iterates over the pages of a ListChannelsModeratedByAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelsModeratedByAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelsModeratedByAppInstanceUser operation.
//	pageNum := 0
//	err := client.ListChannelsModeratedByAppInstanceUserPages(params,
//	    func(page *chimesdkmessaging.ListChannelsModeratedByAppInstanceUserOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserPages(input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelsModeratedByAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsModeratedByAppInstanceUserPagesWithContext same as ListChannelsModeratedByAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListChannelsModeratedByAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsModeratedByAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsModeratedByAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsModeratedByAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubChannels = "ListSubChannels"

// ListSubChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubChannels for more information on using the ListSubChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubChannelsRequest method.
//	req, resp := client.ListSubChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListSubChannels
func (c *ChimeSDKMessaging) ListSubChannelsRequest(input *ListSubChannelsInput) (req *request.Request, output *ListSubChannelsOutput) {
	op := &request.Operation{
		Name:       opListSubChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/subchannels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubChannelsInput{}
	}

	output = &ListSubChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubChannels API operation for Amazon Chime SDK Messaging.
//
// Lists all the SubChannels in an elastic channel when given a channel ID.
// Available only to the app instance admins and channel moderators of elastic
// channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListSubChannels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListSubChannels
func (c *ChimeSDKMessaging) ListSubChannels(input *ListSubChannelsInput) (*ListSubChannelsOutput, error) {
	req, out := c.ListSubChannelsRequest(input)
	return out, req.Send()
}

// ListSubChannelsWithContext is the same as ListSubChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListSubChannelsWithContext(ctx aws.Context, input *ListSubChannelsInput, opts ...request.Option) (*ListSubChannelsOutput, error) {
	req, out := c.ListSubChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubChannelsPages iterates over the pages of a ListSubChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubChannels operation.
//	pageNum := 0
//	err := client.ListSubChannelsPages(params,
//	    func(page *chimesdkmessaging.ListSubChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) ListSubChannelsPages(input *ListSubChannelsInput, fn func(*ListSubChannelsOutput, bool) bool) error {
	return c.ListSubChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubChannelsPagesWithContext same as ListSubChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListSubChannelsPagesWithContext(ctx aws.Context, input *ListSubChannelsInput, fn func(*ListSubChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListTagsForResource
func (c *ChimeSDKMessaging) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime SDK Messaging.
//
// Lists the tags applied to an Amazon Chime SDK messaging resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListTagsForResource
func (c *ChimeSDKMessaging) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutChannelExpirationSettings = "PutChannelExpirationSettings"

// PutChannelExpirationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutChannelExpirationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutChannelExpirationSettings for more information on using the PutChannelExpirationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutChannelExpirationSettingsRequest method.
//	req, resp := client.PutChannelExpirationSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutChannelExpirationSettings
func (c *ChimeSDKMessaging) PutChannelExpirationSettingsRequest(input *PutChannelExpirationSettingsInput) (req *request.Request, output *PutChannelExpirationSettingsOutput) {
	op := &request.Operation{
		Name:       opPutChannelExpirationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/expiration-settings",
	}

	if input == nil {
		input = &PutChannelExpirationSettingsInput{}
	}

	output = &PutChannelExpirationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutChannelExpirationSettings API operation for Amazon Chime SDK Messaging.
//
// Sets the number of days before the channel is automatically deleted.
//
//   - A background process deletes expired channels within 6 hours of expiration.
//     Actual deletion times may vary.
//
//   - Expired channels that have not yet been deleted appear as active, and
//     you can update their expiration settings. The system honors the new settings.
//
//   - The x-amz-chime-bearer request header is mandatory. Use the ARN of the
//     AppInstanceUser or AppInstanceBot that makes the API call as the value
//     in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation PutChannelExpirationSettings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutChannelExpirationSettings
func (c *ChimeSDKMessaging) PutChannelExpirationSettings(input *PutChannelExpirationSettingsInput) (*PutChannelExpirationSettingsOutput, error) {
	req, out := c.PutChannelExpirationSettingsRequest(input)
	return out, req.Send()
}

// PutChannelExpirationSettingsWithContext is the same as PutChannelExpirationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutChannelExpirationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) PutChannelExpirationSettingsWithContext(ctx aws.Context, input *PutChannelExpirationSettingsInput, opts ...request.Option) (*PutChannelExpirationSettingsOutput, error) {
	req, out := c.PutChannelExpirationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutChannelMembershipPreferences = "PutChannelMembershipPreferences"

// PutChannelMembershipPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the PutChannelMembershipPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutChannelMembershipPreferences for more information on using the PutChannelMembershipPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutChannelMembershipPreferencesRequest method.
//	req, resp := client.PutChannelMembershipPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutChannelMembershipPreferences
func (c *ChimeSDKMessaging) PutChannelMembershipPreferencesRequest(input *PutChannelMembershipPreferencesInput) (req *request.Request, output *PutChannelMembershipPreferencesOutput) {
	op := &request.Operation{
		Name:       opPutChannelMembershipPreferences,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}/preferences",
	}

	if input == nil {
		input = &PutChannelMembershipPreferencesInput{}
	}

	output = &PutChannelMembershipPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutChannelMembershipPreferences API operation for Amazon Chime SDK Messaging.
//
// Sets the membership preferences of an AppInstanceUser or AppIntanceBot for
// the specified channel. The user or bot must be a member of the channel. Only
// the user or bot who owns the membership can set preferences. Users or bots
// in the AppInstanceAdmin and channel moderator roles can't set preferences
// for other users or users. Banned users or bots can't set membership preferences
// for the channel from which they are banned.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of an AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation PutChannelMembershipPreferences for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutChannelMembershipPreferences
func (c *ChimeSDKMessaging) PutChannelMembershipPreferences(input *PutChannelMembershipPreferencesInput) (*PutChannelMembershipPreferencesOutput, error) {
	req, out := c.PutChannelMembershipPreferencesRequest(input)
	return out, req.Send()
}

// PutChannelMembershipPreferencesWithContext is the same as PutChannelMembershipPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See PutChannelMembershipPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) PutChannelMembershipPreferencesWithContext(ctx aws.Context, input *PutChannelMembershipPreferencesInput, opts ...request.Option) (*PutChannelMembershipPreferencesOutput, error) {
	req, out := c.PutChannelMembershipPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMessagingStreamingConfigurations = "PutMessagingStreamingConfigurations"

// PutMessagingStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the PutMessagingStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMessagingStreamingConfigurations for more information on using the PutMessagingStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMessagingStreamingConfigurationsRequest method.
//	req, resp := client.PutMessagingStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) PutMessagingStreamingConfigurationsRequest(input *PutMessagingStreamingConfigurationsInput) (req *request.Request, output *PutMessagingStreamingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opPutMessagingStreamingConfigurations,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &PutMessagingStreamingConfigurationsInput{}
	}

	output = &PutMessagingStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutMessagingStreamingConfigurations API operation for Amazon Chime SDK Messaging.
//
// Sets the data streaming configuration for an AppInstance. For more information,
// see Streaming messaging data (https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation PutMessagingStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/PutMessagingStreamingConfigurations
func (c *ChimeSDKMessaging) PutMessagingStreamingConfigurations(input *PutMessagingStreamingConfigurationsInput) (*PutMessagingStreamingConfigurationsOutput, error) {
	req, out := c.PutMessagingStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// PutMessagingStreamingConfigurationsWithContext is the same as PutMessagingStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See PutMessagingStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) PutMessagingStreamingConfigurationsWithContext(ctx aws.Context, input *PutMessagingStreamingConfigurationsInput, opts ...request.Option) (*PutMessagingStreamingConfigurationsOutput, error) {
	req, out := c.PutMessagingStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRedactChannelMessage = "RedactChannelMessage"

// RedactChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the RedactChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RedactChannelMessage for more information on using the RedactChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RedactChannelMessageRequest method.
//	req, resp := client.RedactChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/RedactChannelMessage
func (c *ChimeSDKMessaging) RedactChannelMessageRequest(input *RedactChannelMessageInput) (req *request.Request, output *RedactChannelMessageOutput) {
	op := &request.Operation{
		Name:       opRedactChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactChannelMessageInput{}
	}

	output = &RedactChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RedactChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Redacts message content, but not metadata. The message exists in the back
// end, but the action returns null content, and the state shows as redacted.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation RedactChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/RedactChannelMessage
func (c *ChimeSDKMessaging) RedactChannelMessage(input *RedactChannelMessageInput) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	return out, req.Send()
}

// RedactChannelMessageWithContext is the same as RedactChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See RedactChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) RedactChannelMessageWithContext(ctx aws.Context, input *RedactChannelMessageInput, opts ...request.Option) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchChannels = "SearchChannels"

// SearchChannelsRequest generates a "aws/request.Request" representing the
// client's request for the SearchChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchChannels for more information on using the SearchChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchChannelsRequest method.
//	req, resp := client.SearchChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SearchChannels
func (c *ChimeSDKMessaging) SearchChannelsRequest(input *SearchChannelsInput) (req *request.Request, output *SearchChannelsOutput) {
	op := &request.Operation{
		Name:       opSearchChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/channels?operation=search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchChannelsInput{}
	}

	output = &SearchChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchChannels API operation for Amazon Chime SDK Messaging.
//
// Allows the ChimeBearer to search channels by channel members. Users or bots
// can search across the channels that they belong to. Users in the AppInstanceAdmin
// role can search across all channels.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation SearchChannels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SearchChannels
func (c *ChimeSDKMessaging) SearchChannels(input *SearchChannelsInput) (*SearchChannelsOutput, error) {
	req, out := c.SearchChannelsRequest(input)
	return out, req.Send()
}

// SearchChannelsWithContext is the same as SearchChannels with the addition of
// the ability to pass a context and additional request options.
//
// See SearchChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) SearchChannelsWithContext(ctx aws.Context, input *SearchChannelsInput, opts ...request.Option) (*SearchChannelsOutput, error) {
	req, out := c.SearchChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchChannelsPages iterates over the pages of a SearchChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchChannels operation.
//	pageNum := 0
//	err := client.SearchChannelsPages(params,
//	    func(page *chimesdkmessaging.SearchChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMessaging) SearchChannelsPages(input *SearchChannelsInput, fn func(*SearchChannelsOutput, bool) bool) error {
	return c.SearchChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchChannelsPagesWithContext same as SearchChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) SearchChannelsPagesWithContext(ctx aws.Context, input *SearchChannelsInput, fn func(*SearchChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendChannelMessage = "SendChannelMessage"

// SendChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendChannelMessage for more information on using the SendChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendChannelMessageRequest method.
//	req, resp := client.SendChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SendChannelMessage
func (c *ChimeSDKMessaging) SendChannelMessageRequest(input *SendChannelMessageInput) (req *request.Request, output *SendChannelMessageOutput) {
	op := &request.Operation{
		Name:       opSendChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages",
	}

	if input == nil {
		input = &SendChannelMessageInput{}
	}

	output = &SendChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Sends a message to a particular channel that the member is a part of.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Also, STANDARD messages can contain 4KB of data and the 1KB of metadata.
// CONTROL messages can contain 30 bytes of data and no metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation SendChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/SendChannelMessage
func (c *ChimeSDKMessaging) SendChannelMessage(input *SendChannelMessageInput) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	return out, req.Send()
}

// SendChannelMessageWithContext is the same as SendChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) SendChannelMessageWithContext(ctx aws.Context, input *SendChannelMessageInput, opts ...request.Option) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/TagResource
func (c *ChimeSDKMessaging) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime SDK Messaging.
//
// Applies the specified tags to the specified Amazon Chime SDK messaging resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/TagResource
func (c *ChimeSDKMessaging) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UntagResource
func (c *ChimeSDKMessaging) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime SDK Messaging.
//
// Removes the specified tags from the specified Amazon Chime SDK messaging
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UntagResource
func (c *ChimeSDKMessaging) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannel
func (c *ChimeSDKMessaging) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for Amazon Chime SDK Messaging.
//
// Update a channel's attributes.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannel
func (c *ChimeSDKMessaging) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelFlow = "UpdateChannelFlow"

// UpdateChannelFlowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelFlow for more information on using the UpdateChannelFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelFlowRequest method.
//	req, resp := client.UpdateChannelFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelFlow
func (c *ChimeSDKMessaging) UpdateChannelFlowRequest(input *UpdateChannelFlowInput) (req *request.Request, output *UpdateChannelFlowOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/channel-flows/{channelFlowArn}",
	}

	if input == nil {
		input = &UpdateChannelFlowInput{}
	}

	output = &UpdateChannelFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelFlow API operation for Amazon Chime SDK Messaging.
//
// Updates channel flow attributes. This is a developer API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannelFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelFlow
func (c *ChimeSDKMessaging) UpdateChannelFlow(input *UpdateChannelFlowInput) (*UpdateChannelFlowOutput, error) {
	req, out := c.UpdateChannelFlowRequest(input)
	return out, req.Send()
}

// UpdateChannelFlowWithContext is the same as UpdateChannelFlow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelFlowWithContext(ctx aws.Context, input *UpdateChannelFlowInput, opts ...request.Option) (*UpdateChannelFlowOutput, error) {
	req, out := c.UpdateChannelFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelMessage = "UpdateChannelMessage"

// UpdateChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelMessage for more information on using the UpdateChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelMessageRequest method.
//	req, resp := client.UpdateChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelMessage
func (c *ChimeSDKMessaging) UpdateChannelMessageRequest(input *UpdateChannelMessageInput) (req *request.Request, output *UpdateChannelMessageOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelMessage,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &UpdateChannelMessageInput{}
	}

	output = &UpdateChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelMessage API operation for Amazon Chime SDK Messaging.
//
// Updates the content of a message.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelMessage
func (c *ChimeSDKMessaging) UpdateChannelMessage(input *UpdateChannelMessageInput) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	return out, req.Send()
}

// UpdateChannelMessageWithContext is the same as UpdateChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelMessageWithContext(ctx aws.Context, input *UpdateChannelMessageInput, opts ...request.Option) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelReadMarker = "UpdateChannelReadMarker"

// UpdateChannelReadMarkerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelReadMarker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelReadMarker for more information on using the UpdateChannelReadMarker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelReadMarkerRequest method.
//	req, resp := client.UpdateChannelReadMarkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelReadMarker
func (c *ChimeSDKMessaging) UpdateChannelReadMarkerRequest(input *UpdateChannelReadMarkerInput) (req *request.Request, output *UpdateChannelReadMarkerOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelReadMarker,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/readMarker",
	}

	if input == nil {
		input = &UpdateChannelReadMarkerInput{}
	}

	output = &UpdateChannelReadMarkerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelReadMarker API operation for Amazon Chime SDK Messaging.
//
// The details of the time when a user last read messages in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the ARN of the AppInstanceUser
// or AppInstanceBot that makes the API call as the value in the header.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Messaging's
// API operation UpdateChannelReadMarker for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/UpdateChannelReadMarker
func (c *ChimeSDKMessaging) UpdateChannelReadMarker(input *UpdateChannelReadMarkerInput) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	return out, req.Send()
}

// UpdateChannelReadMarkerWithContext is the same as UpdateChannelReadMarker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelReadMarker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMessaging) UpdateChannelReadMarkerWithContext(ctx aws.Context, input *UpdateChannelReadMarkerInput, opts ...request.Option) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Summary of the membership details of an AppInstanceUser.
type AppInstanceUserMembershipSummary struct {
	_ struct{} `type:"structure"`

	// The time at which an AppInstanceUser last marked a channel as read.
	ReadMarkerTimestamp *time.Time `type:"timestamp"`

	// The ID of the SubChannel that the AppInstanceUser is a member of.
	SubChannelId *string `min:"1" type:"string"`

	// The type of ChannelMembership.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserMembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserMembershipSummary) GoString() string {
	return s.String()
}

// SetReadMarkerTimestamp sets the ReadMarkerTimestamp field's value.
func (s *AppInstanceUserMembershipSummary) SetReadMarkerTimestamp(v time.Time) *AppInstanceUserMembershipSummary {
	s.ReadMarkerTimestamp = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *AppInstanceUserMembershipSummary) SetSubChannelId(v string) *AppInstanceUserMembershipSummary {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppInstanceUserMembershipSummary) SetType(v string) *AppInstanceUserMembershipSummary {
	s.Type = &v
	return s
}

type AssociateChannelFlowInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user making the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateChannelFlowInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *AssociateChannelFlowInput) SetChannelArn(v string) *AssociateChannelFlowInput {
	s.ChannelArn = &v
	return s
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *AssociateChannelFlowInput) SetChannelFlowArn(v string) *AssociateChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *AssociateChannelFlowInput) SetChimeBearer(v string) *AssociateChannelFlowInput {
	s.ChimeBearer = &v
	return s
}

type AssociateChannelFlowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateChannelFlowOutput) GoString() string {
	return s.String()
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The membership information, including member ARNs, the channel ARN, and membership
// types.
type BatchChannelMemberships struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding members.
	ChannelArn *string `min:"5" type:"string"`

	// The identifier of the member who invited another member.
	InvitedBy *Identity `type:"structure"`

	// The users successfully added to the request.
	Members []*Identity `type:"list"`

	// The ID of the SubChannel.
	SubChannelId *string `min:"1" type:"string"`

	// The membership types set for the channel members.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchChannelMemberships) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchChannelMemberships) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchChannelMemberships) SetChannelArn(v string) *BatchChannelMemberships {
	s.ChannelArn = &v
	return s
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *BatchChannelMemberships) SetInvitedBy(v *Identity) *BatchChannelMemberships {
	s.InvitedBy = v
	return s
}

// SetMembers sets the Members field's value.
func (s *BatchChannelMemberships) SetMembers(v []*Identity) *BatchChannelMemberships {
	s.Members = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *BatchChannelMemberships) SetSubChannelId(v string) *BatchChannelMemberships {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *BatchChannelMemberships) SetType(v string) *BatchChannelMemberships {
	s.Type = &v
	return s
}

// A list of failed member ARNs, error codes, and error messages.
type BatchCreateChannelMembershipError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The AppInstanceUserArn of the member that the service couldn't add.
	MemberArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchCreateChannelMembershipError) SetErrorCode(v string) *BatchCreateChannelMembershipError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchCreateChannelMembershipError) SetErrorMessage(v string) *BatchCreateChannelMembershipError {
	s.ErrorMessage = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *BatchCreateChannelMembershipError) SetMemberArn(v string) *BatchCreateChannelMembershipError {
	s.MemberArn = &v
	return s
}

type BatchCreateChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users or bots.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARNs of the members you want to add to the channel. Only AppInstanceUsers
	// and AppInstanceBots can be added as a channel member.
	//
	// MemberArns is a required field
	MemberArns []*string `min:"1" type:"list" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when creating membership in a SubChannel for a moderator in
	// an elastic channel.
	SubChannelId *string `min:"1" type:"string"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are always
	// returned as part of ListChannelMemberships. Hidden members are only returned
	// if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden
	// members are not returned. This is only supported by moderators.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArns == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArns"))
	}
	if s.MemberArns != nil && len(s.MemberArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArns", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchCreateChannelMembershipInput) SetChannelArn(v string) *BatchCreateChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *BatchCreateChannelMembershipInput) SetChimeBearer(v string) *BatchCreateChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArns sets the MemberArns field's value.
func (s *BatchCreateChannelMembershipInput) SetMemberArns(v []*string) *BatchCreateChannelMembershipInput {
	s.MemberArns = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *BatchCreateChannelMembershipInput) SetSubChannelId(v string) *BatchCreateChannelMembershipInput {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *BatchCreateChannelMembershipInput) SetType(v string) *BatchCreateChannelMembershipInput {
	s.Type = &v
	return s
}

type BatchCreateChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The list of channel memberships in the response.
	BatchChannelMemberships *BatchChannelMemberships `type:"structure"`

	// If the action fails for one or more of the memberships in the request, a
	// list of the memberships is returned, along with error codes and error messages.
	Errors []*BatchCreateChannelMembershipError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetBatchChannelMemberships sets the BatchChannelMemberships field's value.
func (s *BatchCreateChannelMembershipOutput) SetBatchChannelMemberships(v *BatchChannelMemberships) *BatchCreateChannelMembershipOutput {
	s.BatchChannelMemberships = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateChannelMembershipOutput) SetErrors(v []*BatchCreateChannelMembershipError) *BatchCreateChannelMembershipOutput {
	s.Errors = v
	return s
}

// The details of a channel.
type Channel struct {
	_ struct{} `type:"structure"`

	// The ARN of a channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ARN of the channel flow.
	ChannelFlowArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the channel.
	CreatedBy *Identity `type:"structure"`

	// The time at which the AppInstanceUser created the channel.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The attributes required to configure and create an elastic channel. An elastic
	// channel can support a maximum of 1-million members.
	ElasticChannelConfiguration *ElasticChannelConfiguration `type:"structure"`

	// Settings that control when a channel expires.
	ExpirationSettings *ExpirationSettings `type:"structure"`

	// The time at which a member sent the last message in the channel.
	LastMessageTimestamp *time.Time `type:"timestamp"`

	// The time at which a channel was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The channel's metadata.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Channel's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the channel.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of a channel.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Channel's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The channel's privacy setting.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *Channel) SetChannelArn(v string) *Channel {
	s.ChannelArn = &v
	return s
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *Channel) SetChannelFlowArn(v string) *Channel {
	s.ChannelFlowArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Channel) SetCreatedBy(v *Identity) *Channel {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Channel) SetCreatedTimestamp(v time.Time) *Channel {
	s.CreatedTimestamp = &v
	return s
}

// SetElasticChannelConfiguration sets the ElasticChannelConfiguration field's value.
func (s *Channel) SetElasticChannelConfiguration(v *ElasticChannelConfiguration) *Channel {
	s.ElasticChannelConfiguration = v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *Channel) SetExpirationSettings(v *ExpirationSettings) *Channel {
	s.ExpirationSettings = v
	return s
}

// SetLastMessageTimestamp sets the LastMessageTimestamp field's value.
func (s *Channel) SetLastMessageTimestamp(v time.Time) *Channel {
	s.LastMessageTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *Channel) SetLastUpdatedTimestamp(v time.Time) *Channel {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Channel) SetMetadata(v string) *Channel {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *Channel) SetMode(v string) *Channel {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *Channel) SetPrivacy(v string) *Channel {
	s.Privacy = &v
	return s
}

// Summary of details of a channel associated with channel flow.
type ChannelAssociatedWithFlowSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The channel's metadata.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelAssociatedWithFlowSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the channel.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelAssociatedWithFlowSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The channel's privacy setting.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelAssociatedWithFlowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelAssociatedWithFlowSummary) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelAssociatedWithFlowSummary) SetChannelArn(v string) *ChannelAssociatedWithFlowSummary {
	s.ChannelArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelAssociatedWithFlowSummary) SetMetadata(v string) *ChannelAssociatedWithFlowSummary {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *ChannelAssociatedWithFlowSummary) SetMode(v string) *ChannelAssociatedWithFlowSummary {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelAssociatedWithFlowSummary) SetName(v string) *ChannelAssociatedWithFlowSummary {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *ChannelAssociatedWithFlowSummary) SetPrivacy(v string) *ChannelAssociatedWithFlowSummary {
	s.Privacy = &v
	return s
}

// The details of a channel ban.
type ChannelBan struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel from which a member is being banned.
	ChannelArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the ban.
	CreatedBy *Identity `type:"structure"`

	// The time at which the ban was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The member being banned from the channel.
	Member *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelBan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelBan) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelBan) SetChannelArn(v string) *ChannelBan {
	s.ChannelArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ChannelBan) SetCreatedBy(v *Identity) *ChannelBan {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelBan) SetCreatedTimestamp(v time.Time) *ChannelBan {
	s.CreatedTimestamp = &v
	return s
}

// SetMember sets the Member field's value.
func (s *ChannelBan) SetMember(v *Identity) *ChannelBan {
	s.Member = v
	return s
}

// Summary of the details of a ChannelBan.
type ChannelBanSummary struct {
	_ struct{} `type:"structure"`

	// The member being banned from a channel.
	Member *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelBanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelBanSummary) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *ChannelBanSummary) SetMember(v *Identity) *ChannelBanSummary {
	s.Member = v
	return s
}

// The details of a channel flow.
type ChannelFlow struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow.
	ChannelFlowArn *string `min:"5" type:"string"`

	// The time at which the channel flow was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a channel flow was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelFlow's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// Information about the processor Lambda functions.
	Processors []*Processor `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlow) GoString() string {
	return s.String()
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *ChannelFlow) SetChannelFlowArn(v string) *ChannelFlow {
	s.ChannelFlowArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelFlow) SetCreatedTimestamp(v time.Time) *ChannelFlow {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelFlow) SetLastUpdatedTimestamp(v time.Time) *ChannelFlow {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelFlow) SetName(v string) *ChannelFlow {
	s.Name = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *ChannelFlow) SetProcessors(v []*Processor) *ChannelFlow {
	s.Processors = v
	return s
}

type ChannelFlowCallbackInput struct {
	_ struct{} `type:"structure"`

	// The identifier passed to the processor by the service when invoked. Use the
	// identifier to call back the service.
	CallbackId *string `min:"32" type:"string" idempotencyToken:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// Stores information about the processed message.
	//
	// ChannelMessage is a required field
	ChannelMessage *ChannelMessageCallback `type:"structure" required:"true"`

	// When a processor determines that a message needs to be DENIED, pass this
	// parameter with a value of true.
	DeleteResource *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowCallbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowCallbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelFlowCallbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelFlowCallbackInput"}
	if s.CallbackId != nil && len(*s.CallbackId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("CallbackId", 32))
	}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelMessage == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelMessage"))
	}
	if s.ChannelMessage != nil {
		if err := s.ChannelMessage.Validate(); err != nil {
			invalidParams.AddNested("ChannelMessage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallbackId sets the CallbackId field's value.
func (s *ChannelFlowCallbackInput) SetCallbackId(v string) *ChannelFlowCallbackInput {
	s.CallbackId = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelFlowCallbackInput) SetChannelArn(v string) *ChannelFlowCallbackInput {
	s.ChannelArn = &v
	return s
}

// SetChannelMessage sets the ChannelMessage field's value.
func (s *ChannelFlowCallbackInput) SetChannelMessage(v *ChannelMessageCallback) *ChannelFlowCallbackInput {
	s.ChannelMessage = v
	return s
}

// SetDeleteResource sets the DeleteResource field's value.
func (s *ChannelFlowCallbackInput) SetDeleteResource(v bool) *ChannelFlowCallbackInput {
	s.DeleteResource = &v
	return s
}

type ChannelFlowCallbackOutput struct {
	_ struct{} `type:"structure"`

	// The call back ID passed in the request.
	CallbackId *string `min:"32" type:"string"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowCallbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowCallbackOutput) GoString() string {
	return s.String()
}

// SetCallbackId sets the CallbackId field's value.
func (s *ChannelFlowCallbackOutput) SetCallbackId(v string) *ChannelFlowCallbackOutput {
	s.CallbackId = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelFlowCallbackOutput) SetChannelArn(v string) *ChannelFlowCallbackOutput {
	s.ChannelArn = &v
	return s
}

// Summary of details of a channel flow.
type ChannelFlowSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow.
	ChannelFlowArn *string `min:"5" type:"string"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelFlowSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// Information about the processor Lambda functions.
	Processors []*Processor `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelFlowSummary) GoString() string {
	return s.String()
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *ChannelFlowSummary) SetChannelFlowArn(v string) *ChannelFlowSummary {
	s.ChannelFlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelFlowSummary) SetName(v string) *ChannelFlowSummary {
	s.Name = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *ChannelFlowSummary) SetProcessors(v []*Processor) *ChannelFlowSummary {
	s.Processors = v
	return s
}

// The details of a channel member.
type ChannelMembership struct {
	_ struct{} `type:"structure"`

	// The ARN of the member's channel.
	ChannelArn *string `min:"5" type:"string"`

	// The time at which the channel membership was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The identifier of the member who invited another member.
	InvitedBy *Identity `type:"structure"`

	// The time at which a channel membership was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The data of the channel member.
	Member *Identity `type:"structure"`

	// The ID of the SubChannel that a user belongs to.
	SubChannelId *string `min:"1" type:"string"`

	// The membership type set for the channel member.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembership) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelMembership) SetChannelArn(v string) *ChannelMembership {
	s.ChannelArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMembership) SetCreatedTimestamp(v time.Time) *ChannelMembership {
	s.CreatedTimestamp = &v
	return s
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *ChannelMembership) SetInvitedBy(v *Identity) *ChannelMembership {
	s.InvitedBy = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMembership) SetLastUpdatedTimestamp(v time.Time) *ChannelMembership {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMember sets the Member field's value.
func (s *ChannelMembership) SetMember(v *Identity) *ChannelMembership {
	s.Member = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ChannelMembership) SetSubChannelId(v string) *ChannelMembership {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMembership) SetType(v string) *ChannelMembership {
	s.Type = &v
	return s
}

// Summary of the channel membership details of an AppInstanceUser.
type ChannelMembershipForAppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// Returns the channel membership data for an AppInstance.
	AppInstanceUserMembershipSummary *AppInstanceUserMembershipSummary `type:"structure"`

	// Returns the channel data for an AppInstance.
	ChannelSummary *ChannelSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipForAppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipForAppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetAppInstanceUserMembershipSummary sets the AppInstanceUserMembershipSummary field's value.
func (s *ChannelMembershipForAppInstanceUserSummary) SetAppInstanceUserMembershipSummary(v *AppInstanceUserMembershipSummary) *ChannelMembershipForAppInstanceUserSummary {
	s.AppInstanceUserMembershipSummary = v
	return s
}

// SetChannelSummary sets the ChannelSummary field's value.
func (s *ChannelMembershipForAppInstanceUserSummary) SetChannelSummary(v *ChannelSummary) *ChannelMembershipForAppInstanceUserSummary {
	s.ChannelSummary = v
	return s
}

// The channel membership preferences for an AppInstanceUser.
type ChannelMembershipPreferences struct {
	_ struct{} `type:"structure"`

	// The push notification configuration of a message.
	PushNotifications *PushNotificationPreferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelMembershipPreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelMembershipPreferences"}
	if s.PushNotifications != nil {
		if err := s.PushNotifications.Validate(); err != nil {
			invalidParams.AddNested("PushNotifications", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPushNotifications sets the PushNotifications field's value.
func (s *ChannelMembershipPreferences) SetPushNotifications(v *PushNotificationPreferences) *ChannelMembershipPreferences {
	s.PushNotifications = v
	return s
}

// Summary of the details of a ChannelMembership.
type ChannelMembershipSummary struct {
	_ struct{} `type:"structure"`

	// A member's summary data.
	Member *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMembershipSummary) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *ChannelMembershipSummary) SetMember(v *Identity) *ChannelMembershipSummary {
	s.Member = v
	return s
}

// The details of a message in a channel.
type ChannelMessage struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The message content.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessage's
	// String and GoString methods.
	Content *string `type:"string" sensitive:"true"`

	// The content type of the channel message.
	//
	// ContentType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessage's
	// String and GoString methods.
	ContentType *string `type:"string" sensitive:"true"`

	// The time at which the message was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was edited.
	LastEditedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The attributes for the message, used for message filtering along with a FilterRule
	// defined in the PushNotificationPreferences.
	MessageAttributes map[string]*MessageAttributeValue `type:"map"`

	// The ID of a message.
	MessageId *string `min:"1" type:"string"`

	// The message metadata.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessage's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The persistence setting for a channel message.
	Persistence *string `type:"string" enum:"ChannelMessagePersistenceType"`

	// Hides the content of a message.
	Redacted *bool `type:"boolean"`

	// The message sender.
	Sender *Identity `type:"structure"`

	// The status of the channel message.
	Status *ChannelMessageStatusStructure `type:"structure"`

	// The ID of the SubChannel.
	SubChannelId *string `min:"1" type:"string"`

	// The message type.
	Type *string `type:"string" enum:"ChannelMessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessage) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelMessage) SetChannelArn(v string) *ChannelMessage {
	s.ChannelArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *ChannelMessage) SetContent(v string) *ChannelMessage {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ChannelMessage) SetContentType(v string) *ChannelMessage {
	s.ContentType = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMessage) SetCreatedTimestamp(v time.Time) *ChannelMessage {
	s.CreatedTimestamp = &v
	return s
}

// SetLastEditedTimestamp sets the LastEditedTimestamp field's value.
func (s *ChannelMessage) SetLastEditedTimestamp(v time.Time) *ChannelMessage {
	s.LastEditedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMessage) SetLastUpdatedTimestamp(v time.Time) *ChannelMessage {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMessageAttributes sets the MessageAttributes field's value.
func (s *ChannelMessage) SetMessageAttributes(v map[string]*MessageAttributeValue) *ChannelMessage {
	s.MessageAttributes = v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *ChannelMessage) SetMessageId(v string) *ChannelMessage {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelMessage) SetMetadata(v string) *ChannelMessage {
	s.Metadata = &v
	return s
}

// SetPersistence sets the Persistence field's value.
func (s *ChannelMessage) SetPersistence(v string) *ChannelMessage {
	s.Persistence = &v
	return s
}

// SetRedacted sets the Redacted field's value.
func (s *ChannelMessage) SetRedacted(v bool) *ChannelMessage {
	s.Redacted = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *ChannelMessage) SetSender(v *Identity) *ChannelMessage {
	s.Sender = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChannelMessage) SetStatus(v *ChannelMessageStatusStructure) *ChannelMessage {
	s.Status = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ChannelMessage) SetSubChannelId(v string) *ChannelMessage {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMessage) SetType(v string) *ChannelMessage {
	s.Type = &v
	return s
}

// Stores information about a callback.
type ChannelMessageCallback struct {
	_ struct{} `type:"structure"`

	// The message content.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageCallback's
	// String and GoString methods.
	Content *string `min:"1" type:"string" sensitive:"true"`

	// The content type of the call-back message.
	//
	// ContentType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageCallback's
	// String and GoString methods.
	ContentType *string `type:"string" sensitive:"true"`

	// The attributes for the message, used for message filtering along with a FilterRule
	// defined in the PushNotificationPreferences.
	MessageAttributes map[string]*MessageAttributeValue `type:"map"`

	// The message ID.
	//
	// MessageId is a required field
	MessageId *string `min:"1" type:"string" required:"true"`

	// The message metadata.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageCallback's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The push notification configuration of the message.
	PushNotification *PushNotificationConfiguration `type:"structure"`

	// The ID of the SubChannel.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageCallback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageCallback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelMessageCallback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelMessageCallback"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}
	if s.PushNotification != nil {
		if err := s.PushNotification.Validate(); err != nil {
			invalidParams.AddNested("PushNotification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *ChannelMessageCallback) SetContent(v string) *ChannelMessageCallback {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ChannelMessageCallback) SetContentType(v string) *ChannelMessageCallback {
	s.ContentType = &v
	return s
}

// SetMessageAttributes sets the MessageAttributes field's value.
func (s *ChannelMessageCallback) SetMessageAttributes(v map[string]*MessageAttributeValue) *ChannelMessageCallback {
	s.MessageAttributes = v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *ChannelMessageCallback) SetMessageId(v string) *ChannelMessageCallback {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelMessageCallback) SetMetadata(v string) *ChannelMessageCallback {
	s.Metadata = &v
	return s
}

// SetPushNotification sets the PushNotification field's value.
func (s *ChannelMessageCallback) SetPushNotification(v *PushNotificationConfiguration) *ChannelMessageCallback {
	s.PushNotification = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ChannelMessageCallback) SetSubChannelId(v string) *ChannelMessageCallback {
	s.SubChannelId = &v
	return s
}

// Stores information about a message status.
type ChannelMessageStatusStructure struct {
	_ struct{} `type:"structure"`

	// Contains more details about the messasge status.
	Detail *string `type:"string"`

	// The message status value.
	Value *string `type:"string" enum:"ChannelMessageStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageStatusStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageStatusStructure) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *ChannelMessageStatusStructure) SetDetail(v string) *ChannelMessageStatusStructure {
	s.Detail = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ChannelMessageStatusStructure) SetValue(v string) *ChannelMessageStatusStructure {
	s.Value = &v
	return s
}

// Summary of the messages in a Channel.
type ChannelMessageSummary struct {
	_ struct{} `type:"structure"`

	// The content of the message.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageSummary's
	// String and GoString methods.
	Content *string `type:"string" sensitive:"true"`

	// The content type of the channel messsage listed in the summary.
	//
	// ContentType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageSummary's
	// String and GoString methods.
	ContentType *string `type:"string" sensitive:"true"`

	// The time at which the message summary was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was last edited.
	LastEditedTimestamp *time.Time `type:"timestamp"`

	// The time at which a message was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The message attribues listed in a the summary of a channel message.
	MessageAttributes map[string]*MessageAttributeValue `type:"map"`

	// The ID of the message.
	MessageId *string `min:"1" type:"string"`

	// The metadata of the message.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelMessageSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// Indicates whether a message was redacted.
	Redacted *bool `type:"boolean"`

	// The message sender.
	Sender *Identity `type:"structure"`

	// The message status. The status value is SENT for messages sent to a channel
	// without a channel flow. For channels associated with channel flow, the value
	// determines the processing stage.
	Status *ChannelMessageStatusStructure `type:"structure"`

	// The type of message.
	Type *string `type:"string" enum:"ChannelMessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelMessageSummary) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ChannelMessageSummary) SetContent(v string) *ChannelMessageSummary {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ChannelMessageSummary) SetContentType(v string) *ChannelMessageSummary {
	s.ContentType = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelMessageSummary) SetCreatedTimestamp(v time.Time) *ChannelMessageSummary {
	s.CreatedTimestamp = &v
	return s
}

// SetLastEditedTimestamp sets the LastEditedTimestamp field's value.
func (s *ChannelMessageSummary) SetLastEditedTimestamp(v time.Time) *ChannelMessageSummary {
	s.LastEditedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *ChannelMessageSummary) SetLastUpdatedTimestamp(v time.Time) *ChannelMessageSummary {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMessageAttributes sets the MessageAttributes field's value.
func (s *ChannelMessageSummary) SetMessageAttributes(v map[string]*MessageAttributeValue) *ChannelMessageSummary {
	s.MessageAttributes = v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *ChannelMessageSummary) SetMessageId(v string) *ChannelMessageSummary {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelMessageSummary) SetMetadata(v string) *ChannelMessageSummary {
	s.Metadata = &v
	return s
}

// SetRedacted sets the Redacted field's value.
func (s *ChannelMessageSummary) SetRedacted(v bool) *ChannelMessageSummary {
	s.Redacted = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *ChannelMessageSummary) SetSender(v *Identity) *ChannelMessageSummary {
	s.Sender = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChannelMessageSummary) SetStatus(v *ChannelMessageStatusStructure) *ChannelMessageSummary {
	s.Status = v
	return s
}

// SetType sets the Type field's value.
func (s *ChannelMessageSummary) SetType(v string) *ChannelMessageSummary {
	s.Type = &v
	return s
}

// Summary of the details of a moderated channel.
type ChannelModeratedByAppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// Summary of the details of a Channel.
	ChannelSummary *ChannelSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModeratedByAppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModeratedByAppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetChannelSummary sets the ChannelSummary field's value.
func (s *ChannelModeratedByAppInstanceUserSummary) SetChannelSummary(v *ChannelSummary) *ChannelModeratedByAppInstanceUserSummary {
	s.ChannelSummary = v
	return s
}

// The details of a channel moderator.
type ChannelModerator struct {
	_ struct{} `type:"structure"`

	// The ARN of the moderator's channel.
	ChannelArn *string `min:"5" type:"string"`

	// The AppInstanceUser who created the moderator.
	CreatedBy *Identity `type:"structure"`

	// The time at which the moderator was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The moderator's data.
	Moderator *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModerator) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelModerator) SetChannelArn(v string) *ChannelModerator {
	s.ChannelArn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ChannelModerator) SetCreatedBy(v *Identity) *ChannelModerator {
	s.CreatedBy = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ChannelModerator) SetCreatedTimestamp(v time.Time) *ChannelModerator {
	s.CreatedTimestamp = &v
	return s
}

// SetModerator sets the Moderator field's value.
func (s *ChannelModerator) SetModerator(v *Identity) *ChannelModerator {
	s.Moderator = v
	return s
}

// Summary of the details of a ChannelModerator.
type ChannelModeratorSummary struct {
	_ struct{} `type:"structure"`

	// The data for a moderator.
	Moderator *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModeratorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelModeratorSummary) GoString() string {
	return s.String()
}

// SetModerator sets the Moderator field's value.
func (s *ChannelModeratorSummary) SetModerator(v *Identity) *ChannelModeratorSummary {
	s.Moderator = v
	return s
}

// Summary of the details of a Channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The time at which the last persistent message in a channel was sent.
	LastMessageTimestamp *time.Time `type:"timestamp"`

	// The metadata of the channel.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the channel.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of the channel.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChannelSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The privacy setting of the channel.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelSummary) SetChannelArn(v string) *ChannelSummary {
	s.ChannelArn = &v
	return s
}

// SetLastMessageTimestamp sets the LastMessageTimestamp field's value.
func (s *ChannelSummary) SetLastMessageTimestamp(v time.Time) *ChannelSummary {
	s.LastMessageTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ChannelSummary) SetMetadata(v string) *ChannelSummary {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *ChannelSummary) SetMode(v string) *ChannelSummary {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *ChannelSummary) SetPrivacy(v string) *ChannelSummary {
	s.Privacy = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelBanInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the ban request.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member being banned.
	//
	// MemberArn is a required field
	MemberArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelBanInput) SetChannelArn(v string) *CreateChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelBanInput) SetChimeBearer(v string) *CreateChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *CreateChannelBanInput) SetMemberArn(v string) *CreateChannelBanInput {
	s.MemberArn = &v
	return s
}

type CreateChannelBanOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the response to the ban request.
	ChannelArn *string `min:"5" type:"string"`

	// The ChannelArn and BannedIdentity of the member in the ban response.
	Member *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelBanOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelBanOutput) SetChannelArn(v string) *CreateChannelBanOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *CreateChannelBanOutput) SetMember(v *Identity) *CreateChannelBanOutput {
	s.Member = v
	return s
}

type CreateChannelFlowInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The client token for the request. An Idempotency token.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelFlowInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelFlowInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Information about the processor Lambda functions.
	//
	// Processors is a required field
	Processors []*Processor `min:"1" type:"list" required:"true"`

	// The tags for the creation request.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelFlowInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Processors == nil {
		invalidParams.Add(request.NewErrParamRequired("Processors"))
	}
	if s.Processors != nil && len(s.Processors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Processors", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Processors != nil {
		for i, v := range s.Processors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Processors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateChannelFlowInput) SetAppInstanceArn(v string) *CreateChannelFlowInput {
	s.AppInstanceArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateChannelFlowInput) SetClientRequestToken(v string) *CreateChannelFlowInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelFlowInput) SetName(v string) *CreateChannelFlowInput {
	s.Name = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *CreateChannelFlowInput) SetProcessors(v []*Processor) *CreateChannelFlowInput {
	s.Processors = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelFlowInput) SetTags(v []*Tag) *CreateChannelFlowInput {
	s.Tags = v
	return s
}

type CreateChannelFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow.
	ChannelFlowArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelFlowOutput) GoString() string {
	return s.String()
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *CreateChannelFlowOutput) SetChannelFlowArn(v string) *CreateChannelFlowOutput {
	s.ChannelFlowArn = &v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The ID of the channel in the request.
	//
	// ChannelId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelInput's
	// String and GoString methods.
	ChannelId *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The client token for the request. An Idempotency token.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The attributes required to configure and create an elastic channel. An elastic
	// channel can support a maximum of 1-million users, excluding moderators.
	ElasticChannelConfiguration *ElasticChannelConfiguration `type:"structure"`

	// Settings that control the interval after which the channel is automatically
	// deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`

	// The ARNs of the channel members in the request.
	MemberArns []*string `min:"1" type:"list"`

	// The metadata of the creation request. Limited to 1KB and UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The channel mode: UNRESTRICTED or RESTRICTED. Administrators, moderators,
	// and channel members can add themselves and other members to unrestricted
	// channels. Only administrators and moderators can add members to restricted
	// channels.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The ARNs of the channel moderators in the request.
	ModeratorArns []*string `min:"1" type:"list"`

	// The name of the channel.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateChannelInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The channel's privacy level: PUBLIC or PRIVATE. Private channels aren't discoverable
	// by users outside the channel. Public channels are discoverable by anyone
	// in the AppInstance.
	Privacy *string `type:"string" enum:"ChannelPrivacy"`

	// The tags for the creation request.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.MemberArns != nil && len(s.MemberArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArns", 1))
	}
	if s.ModeratorArns != nil && len(s.ModeratorArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModeratorArns", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ElasticChannelConfiguration != nil {
		if err := s.ElasticChannelConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ElasticChannelConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ExpirationSettings != nil {
		if err := s.ExpirationSettings.Validate(); err != nil {
			invalidParams.AddNested("ExpirationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateChannelInput) SetAppInstanceArn(v string) *CreateChannelInput {
	s.AppInstanceArn = &v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateChannelInput) SetChannelId(v string) *CreateChannelInput {
	s.ChannelId = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelInput) SetChimeBearer(v string) *CreateChannelInput {
	s.ChimeBearer = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateChannelInput) SetClientRequestToken(v string) *CreateChannelInput {
	s.ClientRequestToken = &v
	return s
}

// SetElasticChannelConfiguration sets the ElasticChannelConfiguration field's value.
func (s *CreateChannelInput) SetElasticChannelConfiguration(v *ElasticChannelConfiguration) *CreateChannelInput {
	s.ElasticChannelConfiguration = v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *CreateChannelInput) SetExpirationSettings(v *ExpirationSettings) *CreateChannelInput {
	s.ExpirationSettings = v
	return s
}

// SetMemberArns sets the MemberArns field's value.
func (s *CreateChannelInput) SetMemberArns(v []*string) *CreateChannelInput {
	s.MemberArns = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateChannelInput) SetMetadata(v string) *CreateChannelInput {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CreateChannelInput) SetMode(v string) *CreateChannelInput {
	s.Mode = &v
	return s
}

// SetModeratorArns sets the ModeratorArns field's value.
func (s *CreateChannelInput) SetModeratorArns(v []*string) *CreateChannelInput {
	s.ModeratorArns = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *CreateChannelInput) SetPrivacy(v string) *CreateChannelInput {
	s.Privacy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v []*Tag) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member you want to add to the channel.
	//
	// MemberArn is a required field
	MemberArn *string `min:"5" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when creating membership in a SubChannel for a moderator in
	// an elastic channel.
	SubChannelId *string `min:"1" type:"string"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are always
	// returned as part of ListChannelMemberships. Hidden members are only returned
	// if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden
	// members are not returned. This is only supported by moderators.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelMembershipInput) SetChannelArn(v string) *CreateChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelMembershipInput) SetChimeBearer(v string) *CreateChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *CreateChannelMembershipInput) SetMemberArn(v string) *CreateChannelMembershipInput {
	s.MemberArn = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *CreateChannelMembershipInput) SetSubChannelId(v string) *CreateChannelMembershipInput {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateChannelMembershipInput) SetType(v string) *CreateChannelMembershipInput {
	s.Type = &v
	return s
}

type CreateChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ARN and metadata of the member being added.
	Member *Identity `type:"structure"`

	// The ID of the SubChannel in the response.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelMembershipOutput) SetChannelArn(v string) *CreateChannelMembershipOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *CreateChannelMembershipOutput) SetMember(v *Identity) *CreateChannelMembershipOutput {
	s.Member = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *CreateChannelMembershipOutput) SetSubChannelId(v string) *CreateChannelMembershipOutput {
	s.SubChannelId = &v
	return s
}

type CreateChannelModeratorInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the moderator.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelModeratorInput) SetChannelArn(v string) *CreateChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *CreateChannelModeratorInput) SetChannelModeratorArn(v string) *CreateChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *CreateChannelModeratorInput) SetChimeBearer(v string) *CreateChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type CreateChannelModeratorOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ARNs of the channel and the moderator.
	ChannelModerator *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelModeratorOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelModeratorOutput) SetChannelArn(v string) *CreateChannelModeratorOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelModerator sets the ChannelModerator field's value.
func (s *CreateChannelModeratorOutput) SetChannelModerator(v *Identity) *CreateChannelModeratorOutput {
	s.ChannelModerator = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *CreateChannelOutput) SetChannelArn(v string) *CreateChannelOutput {
	s.ChannelArn = &v
	return s
}

type DeleteChannelBanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel from which the AppInstanceUser was banned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser that you want to reinstate.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelBanInput) SetChannelArn(v string) *DeleteChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelBanInput) SetChimeBearer(v string) *DeleteChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DeleteChannelBanInput) SetMemberArn(v string) *DeleteChannelBanInput {
	s.MemberArn = &v
	return s
}

type DeleteChannelBanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelBanOutput) GoString() string {
	return s.String()
}

type DeleteChannelFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `location:"uri" locationName:"channelFlowArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelFlowInput"}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *DeleteChannelFlowInput) SetChannelFlowArn(v string) *DeleteChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

type DeleteChannelFlowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelFlowOutput) GoString() string {
	return s.String()
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel being deleted.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelInput) SetChannelArn(v string) *DeleteChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelInput) SetChimeBearer(v string) *DeleteChannelInput {
	s.ChimeBearer = &v
	return s
}

type DeleteChannelMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel from which you want to remove the user.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member that you're removing from the channel.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only for use by moderators.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelMembershipInput) SetChannelArn(v string) *DeleteChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelMembershipInput) SetChimeBearer(v string) *DeleteChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DeleteChannelMembershipInput) SetMemberArn(v string) *DeleteChannelMembershipInput {
	s.MemberArn = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *DeleteChannelMembershipInput) SetSubChannelId(v string) *DeleteChannelMembershipInput {
	s.SubChannelId = &v
	return s
}

type DeleteChannelMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMembershipOutput) GoString() string {
	return s.String()
}

type DeleteChannelMessageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message being deleted.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when deleting messages in a SubChannel that the user belongs
	// to.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelMessageInput) SetChannelArn(v string) *DeleteChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelMessageInput) SetChimeBearer(v string) *DeleteChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *DeleteChannelMessageInput) SetMessageId(v string) *DeleteChannelMessageInput {
	s.MessageId = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *DeleteChannelMessageInput) SetSubChannelId(v string) *DeleteChannelMessageInput {
	s.SubChannelId = &v
	return s
}

type DeleteChannelMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelMessageOutput) GoString() string {
	return s.String()
}

type DeleteChannelModeratorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the moderator being deleted.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `location:"uri" locationName:"channelModeratorArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DeleteChannelModeratorInput) SetChannelArn(v string) *DeleteChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *DeleteChannelModeratorInput) SetChannelModeratorArn(v string) *DeleteChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DeleteChannelModeratorInput) SetChimeBearer(v string) *DeleteChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type DeleteChannelModeratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelModeratorOutput) GoString() string {
	return s.String()
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeleteMessagingStreamingConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the streaming configurations being deleted.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessagingStreamingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessagingStreamingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMessagingStreamingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMessagingStreamingConfigurationsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DeleteMessagingStreamingConfigurationsInput) SetAppInstanceArn(v string) *DeleteMessagingStreamingConfigurationsInput {
	s.AppInstanceArn = &v
	return s
}

type DeleteMessagingStreamingConfigurationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessagingStreamingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMessagingStreamingConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeChannelBanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel from which the user is banned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member being banned.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelBanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelBanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelBanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelBanInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelBanInput) SetChannelArn(v string) *DescribeChannelBanInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelBanInput) SetChimeBearer(v string) *DescribeChannelBanInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DescribeChannelBanInput) SetMemberArn(v string) *DescribeChannelBanInput {
	s.MemberArn = &v
	return s
}

type DescribeChannelBanOutput struct {
	_ struct{} `type:"structure"`

	// The details of the ban.
	ChannelBan *ChannelBan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelBanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelBanOutput) GoString() string {
	return s.String()
}

// SetChannelBan sets the ChannelBan field's value.
func (s *DescribeChannelBanOutput) SetChannelBan(v *ChannelBan) *DescribeChannelBanOutput {
	s.ChannelBan = v
	return s
}

type DescribeChannelFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `location:"uri" locationName:"channelFlowArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelFlowInput"}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *DescribeChannelFlowInput) SetChannelFlowArn(v string) *DescribeChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

type DescribeChannelFlowOutput struct {
	_ struct{} `type:"structure"`

	// The channel flow details.
	ChannelFlow *ChannelFlow `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelFlowOutput) GoString() string {
	return s.String()
}

// SetChannelFlow sets the ChannelFlow field's value.
func (s *DescribeChannelFlowOutput) SetChannelFlow(v *ChannelFlow) *DescribeChannelFlowOutput {
	s.ChannelFlow = v
	return s
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelInput) SetChannelArn(v string) *DescribeChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelInput) SetChimeBearer(v string) *DescribeChannelInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelMembershipForAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user or bot in a channel.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string" required:"true"`

	// The ARN of the channel to which the user belongs.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipForAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipForAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelMembershipForAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelMembershipForAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetChannelArn(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelMembershipForAppInstanceUserInput) SetChimeBearer(v string) *DescribeChannelMembershipForAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelMembershipForAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The channel to which a user belongs.
	ChannelMembership *ChannelMembershipForAppInstanceUserSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipForAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipForAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannelMembership sets the ChannelMembership field's value.
func (s *DescribeChannelMembershipForAppInstanceUserOutput) SetChannelMembership(v *ChannelMembershipForAppInstanceUserSummary) *DescribeChannelMembershipForAppInstanceUserOutput {
	s.ChannelMembership = v
	return s
}

type DescribeChannelMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`

	// The ID of the SubChannel in the request. The response contains an ElasticChannelConfiguration
	// object.
	//
	// Only required to get a user’s SubChannel membership details.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelMembershipInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelMembershipInput) SetChannelArn(v string) *DescribeChannelMembershipInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelMembershipInput) SetChimeBearer(v string) *DescribeChannelMembershipInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *DescribeChannelMembershipInput) SetMemberArn(v string) *DescribeChannelMembershipInput {
	s.MemberArn = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *DescribeChannelMembershipInput) SetSubChannelId(v string) *DescribeChannelMembershipInput {
	s.SubChannelId = &v
	return s
}

type DescribeChannelMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The details of the membership.
	ChannelMembership *ChannelMembership `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelMembershipOutput) GoString() string {
	return s.String()
}

// SetChannelMembership sets the ChannelMembership field's value.
func (s *DescribeChannelMembershipOutput) SetChannelMembership(v *ChannelMembership) *DescribeChannelMembershipOutput {
	s.ChannelMembership = v
	return s
}

type DescribeChannelModeratedByAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user or bot in the moderated channel.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string" required:"true"`

	// The ARN of the moderated channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratedByAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratedByAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelModeratedByAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelModeratedByAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetChannelArn(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelModeratedByAppInstanceUserInput) SetChimeBearer(v string) *DescribeChannelModeratedByAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelModeratedByAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The moderated channel.
	Channel *ChannelModeratedByAppInstanceUserSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratedByAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratedByAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DescribeChannelModeratedByAppInstanceUserOutput) SetChannel(v *ChannelModeratedByAppInstanceUserSummary) *DescribeChannelModeratedByAppInstanceUserOutput {
	s.Channel = v
	return s
}

type DescribeChannelModeratorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the channel moderator.
	//
	// ChannelModeratorArn is a required field
	ChannelModeratorArn *string `location:"uri" locationName:"channelModeratorArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelModeratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelModeratorInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelModeratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelModeratorArn"))
	}
	if s.ChannelModeratorArn != nil && len(*s.ChannelModeratorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelModeratorArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DescribeChannelModeratorInput) SetChannelArn(v string) *DescribeChannelModeratorInput {
	s.ChannelArn = &v
	return s
}

// SetChannelModeratorArn sets the ChannelModeratorArn field's value.
func (s *DescribeChannelModeratorInput) SetChannelModeratorArn(v string) *DescribeChannelModeratorInput {
	s.ChannelModeratorArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DescribeChannelModeratorInput) SetChimeBearer(v string) *DescribeChannelModeratorInput {
	s.ChimeBearer = &v
	return s
}

type DescribeChannelModeratorOutput struct {
	_ struct{} `type:"structure"`

	// The details of the channel moderator.
	ChannelModerator *ChannelModerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelModeratorOutput) GoString() string {
	return s.String()
}

// SetChannelModerator sets the ChannelModerator field's value.
func (s *DescribeChannelModeratorOutput) SetChannelModerator(v *ChannelModerator) *DescribeChannelModeratorOutput {
	s.ChannelModerator = v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	// The channel details.
	Channel *Channel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DescribeChannelOutput) SetChannel(v *Channel) *DescribeChannelOutput {
	s.Channel = v
	return s
}

type DisassociateChannelFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `location:"uri" locationName:"channelFlowArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user making the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateChannelFlowInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *DisassociateChannelFlowInput) SetChannelArn(v string) *DisassociateChannelFlowInput {
	s.ChannelArn = &v
	return s
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *DisassociateChannelFlowInput) SetChannelFlowArn(v string) *DisassociateChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *DisassociateChannelFlowInput) SetChimeBearer(v string) *DisassociateChannelFlowInput {
	s.ChimeBearer = &v
	return s
}

type DisassociateChannelFlowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateChannelFlowOutput) GoString() string {
	return s.String()
}

// The attributes required to configure and create an elastic channel. An elastic
// channel can support a maximum of 1-million members.
type ElasticChannelConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of SubChannels that you want to allow in the elastic channel.
	//
	// MaximumSubChannels is a required field
	MaximumSubChannels *int64 `min:"2" type:"integer" required:"true"`

	// The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil
	// of the calculated value is used in balancing members among SubChannels of
	// the elastic channel.
	//
	// MinimumMembershipPercentage is a required field
	MinimumMembershipPercentage *int64 `min:"1" type:"integer" required:"true"`

	// The maximum number of members allowed in a SubChannel.
	//
	// TargetMembershipsPerSubChannel is a required field
	TargetMembershipsPerSubChannel *int64 `min:"2" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticChannelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticChannelConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticChannelConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticChannelConfiguration"}
	if s.MaximumSubChannels == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumSubChannels"))
	}
	if s.MaximumSubChannels != nil && *s.MaximumSubChannels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumSubChannels", 2))
	}
	if s.MinimumMembershipPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumMembershipPercentage"))
	}
	if s.MinimumMembershipPercentage != nil && *s.MinimumMembershipPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumMembershipPercentage", 1))
	}
	if s.TargetMembershipsPerSubChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetMembershipsPerSubChannel"))
	}
	if s.TargetMembershipsPerSubChannel != nil && *s.TargetMembershipsPerSubChannel < 2 {
		invalidParams.Add(request.NewErrParamMinValue("TargetMembershipsPerSubChannel", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumSubChannels sets the MaximumSubChannels field's value.
func (s *ElasticChannelConfiguration) SetMaximumSubChannels(v int64) *ElasticChannelConfiguration {
	s.MaximumSubChannels = &v
	return s
}

// SetMinimumMembershipPercentage sets the MinimumMembershipPercentage field's value.
func (s *ElasticChannelConfiguration) SetMinimumMembershipPercentage(v int64) *ElasticChannelConfiguration {
	s.MinimumMembershipPercentage = &v
	return s
}

// SetTargetMembershipsPerSubChannel sets the TargetMembershipsPerSubChannel field's value.
func (s *ElasticChannelConfiguration) SetTargetMembershipsPerSubChannel(v int64) *ElasticChannelConfiguration {
	s.TargetMembershipsPerSubChannel = &v
	return s
}

// Settings that control the interval after which a channel is deleted.
type ExpirationSettings struct {
	_ struct{} `type:"structure"`

	// The conditions that must be met for a channel to expire.
	//
	// ExpirationCriterion is a required field
	ExpirationCriterion *string `type:"string" required:"true" enum:"ExpirationCriterion"`

	// The period in days after which the system automatically deletes a channel.
	//
	// ExpirationDays is a required field
	ExpirationDays *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpirationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpirationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpirationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpirationSettings"}
	if s.ExpirationCriterion == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpirationCriterion"))
	}
	if s.ExpirationDays == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpirationDays"))
	}
	if s.ExpirationDays != nil && *s.ExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpirationCriterion sets the ExpirationCriterion field's value.
func (s *ExpirationSettings) SetExpirationCriterion(v string) *ExpirationSettings {
	s.ExpirationCriterion = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *ExpirationSettings) SetExpirationDays(v int64) *ExpirationSettings {
	s.ExpirationDays = &v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetChannelMembershipPreferencesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the member retrieving the preferences.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMembershipPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMembershipPreferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelMembershipPreferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelMembershipPreferencesInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetChannelMembershipPreferencesInput) SetChannelArn(v string) *GetChannelMembershipPreferencesInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *GetChannelMembershipPreferencesInput) SetChimeBearer(v string) *GetChannelMembershipPreferencesInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *GetChannelMembershipPreferencesInput) SetMemberArn(v string) *GetChannelMembershipPreferencesInput {
	s.MemberArn = &v
	return s
}

type GetChannelMembershipPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The details of a user.
	Member *Identity `type:"structure"`

	// The channel membership preferences for an AppInstanceUser .
	Preferences *ChannelMembershipPreferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMembershipPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMembershipPreferencesOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetChannelMembershipPreferencesOutput) SetChannelArn(v string) *GetChannelMembershipPreferencesOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *GetChannelMembershipPreferencesOutput) SetMember(v *Identity) *GetChannelMembershipPreferencesOutput {
	s.Member = v
	return s
}

// SetPreferences sets the Preferences field's value.
func (s *GetChannelMembershipPreferencesOutput) SetPreferences(v *ChannelMembershipPreferences) *GetChannelMembershipPreferencesOutput {
	s.Preferences = v
	return s
}

type GetChannelMessageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when getting messages in a SubChannel that the user belongs
	// to.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetChannelMessageInput) SetChannelArn(v string) *GetChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *GetChannelMessageInput) SetChimeBearer(v string) *GetChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *GetChannelMessageInput) SetMessageId(v string) *GetChannelMessageInput {
	s.MessageId = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *GetChannelMessageInput) SetSubChannelId(v string) *GetChannelMessageInput {
	s.SubChannelId = &v
	return s
}

type GetChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The details of and content in the message.
	ChannelMessage *ChannelMessage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelMessage sets the ChannelMessage field's value.
func (s *GetChannelMessageOutput) SetChannelMessage(v *ChannelMessage) *GetChannelMessageOutput {
	s.ChannelMessage = v
	return s
}

type GetChannelMessageStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user making the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when getting message status in a SubChannel that the user belongs
	// to.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelMessageStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelMessageStatusInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *GetChannelMessageStatusInput) SetChannelArn(v string) *GetChannelMessageStatusInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *GetChannelMessageStatusInput) SetChimeBearer(v string) *GetChannelMessageStatusInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *GetChannelMessageStatusInput) SetMessageId(v string) *GetChannelMessageStatusInput {
	s.MessageId = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *GetChannelMessageStatusInput) SetSubChannelId(v string) *GetChannelMessageStatusInput {
	s.SubChannelId = &v
	return s
}

type GetChannelMessageStatusOutput struct {
	_ struct{} `type:"structure"`

	// The message status and details.
	Status *ChannelMessageStatusStructure `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelMessageStatusOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetChannelMessageStatusOutput) SetStatus(v *ChannelMessageStatusStructure) *GetChannelMessageStatusOutput {
	s.Status = v
	return s
}

type GetMessagingSessionEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingSessionEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingSessionEndpointInput) GoString() string {
	return s.String()
}

type GetMessagingSessionEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint returned in the response.
	Endpoint *MessagingSessionEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingSessionEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingSessionEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetMessagingSessionEndpointOutput) SetEndpoint(v *MessagingSessionEndpoint) *GetMessagingSessionEndpointOutput {
	s.Endpoint = v
	return s
}

type GetMessagingStreamingConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the streaming configurations.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingStreamingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingStreamingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMessagingStreamingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMessagingStreamingConfigurationsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *GetMessagingStreamingConfigurationsInput) SetAppInstanceArn(v string) *GetMessagingStreamingConfigurationsInput {
	s.AppInstanceArn = &v
	return s
}

type GetMessagingStreamingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The streaming settings.
	StreamingConfigurations []*StreamingConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingStreamingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMessagingStreamingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetStreamingConfigurations sets the StreamingConfigurations field's value.
func (s *GetMessagingStreamingConfigurationsOutput) SetStreamingConfigurations(v []*StreamingConfiguration) *GetMessagingStreamingConfigurationsOutput {
	s.StreamingConfigurations = v
	return s
}

// The details of a user or bot.
type Identity struct {
	_ struct{} `type:"structure"`

	// The ARN in an Identity.
	Arn *string `min:"5" type:"string"`

	// The name in an Identity.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Identity's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Identity) SetArn(v string) *Identity {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Identity) SetName(v string) *Identity {
	s.Name = &v
	return s
}

// Stores metadata about a Lambda processor.
type LambdaConfiguration struct {
	_ struct{} `type:"structure"`

	// Controls how the Lambda function is invoked.
	//
	// InvocationType is a required field
	InvocationType *string `type:"string" required:"true" enum:"InvocationType"`

	// The ARN of the Lambda message processing function.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"15" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaConfiguration"}
	if s.InvocationType == nil {
		invalidParams.Add(request.NewErrParamRequired("InvocationType"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvocationType sets the InvocationType field's value.
func (s *LambdaConfiguration) SetInvocationType(v string) *LambdaConfiguration {
	s.InvocationType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LambdaConfiguration) SetResourceArn(v string) *LambdaConfiguration {
	s.ResourceArn = &v
	return s
}

type ListChannelBansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of bans that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested bans are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelBansInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelBansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelBansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelBansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelBansInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelBansInput) SetChannelArn(v string) *ListChannelBansInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelBansInput) SetChimeBearer(v string) *ListChannelBansInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelBansInput) SetMaxResults(v int64) *ListChannelBansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelBansInput) SetNextToken(v string) *ListChannelBansInput {
	s.NextToken = &v
	return s
}

type ListChannelBansOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information for each requested ban.
	ChannelBans []*ChannelBanSummary `type:"list"`

	// The token passed by previous API calls until all requested bans are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelBansOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelBansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelBansOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelBansOutput) SetChannelArn(v string) *ListChannelBansOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelBans sets the ChannelBans field's value.
func (s *ListChannelBansOutput) SetChannelBans(v []*ChannelBanSummary) *ListChannelBansOutput {
	s.ChannelBans = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelBansOutput) SetNextToken(v string) *ListChannelBansOutput {
	s.NextToken = &v
	return s
}

type ListChannelFlowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the app instance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The maximum number of channel flows that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channel flows
	// are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelFlowsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelFlowsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListChannelFlowsInput) SetAppInstanceArn(v string) *ListChannelFlowsInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelFlowsInput) SetMaxResults(v int64) *ListChannelFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelFlowsInput) SetNextToken(v string) *ListChannelFlowsInput {
	s.NextToken = &v
	return s
}

type ListChannelFlowsOutput struct {
	_ struct{} `type:"structure"`

	// The information about each channel flow.
	ChannelFlows []*ChannelFlowSummary `type:"list"`

	// The token passed by previous API calls until all requested channels are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelFlowsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelFlowsOutput) GoString() string {
	return s.String()
}

// SetChannelFlows sets the ChannelFlows field's value.
func (s *ListChannelFlowsOutput) SetChannelFlows(v []*ChannelFlowSummary) *ListChannelFlowsOutput {
	s.ChannelFlows = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelFlowsOutput) SetNextToken(v string) *ListChannelFlowsOutput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsForAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user or bot.
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of users that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of channel
	// memberships is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMembershipsForAppInstanceUserInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsForAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsForAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMembershipsForAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMembershipsForAppInstanceUserInput"}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetAppInstanceUserArn(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetChimeBearer(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetMaxResults(v int64) *ListChannelMembershipsForAppInstanceUserInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsForAppInstanceUserInput) SetNextToken(v string) *ListChannelMembershipsForAppInstanceUserInput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsForAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The information for the requested channel memberships.
	ChannelMemberships []*ChannelMembershipForAppInstanceUserSummary `type:"list"`

	// The token passed by previous API calls until all requested users are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMembershipsForAppInstanceUserOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsForAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsForAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannelMemberships sets the ChannelMemberships field's value.
func (s *ListChannelMembershipsForAppInstanceUserOutput) SetChannelMemberships(v []*ChannelMembershipForAppInstanceUserSummary) *ListChannelMembershipsForAppInstanceUserOutput {
	s.ChannelMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsForAppInstanceUserOutput) SetNextToken(v string) *ListChannelMembershipsForAppInstanceUserOutput {
	s.NextToken = &v
	return s
}

type ListChannelMembershipsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of channel memberships that you want returned.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channel memberships that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMembershipsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when listing a user's memberships in a particular sub-channel
	// of an elastic channel.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`

	// The membership type of a user, DEFAULT or HIDDEN. Default members are returned
	// as part of ListChannelMemberships if no type is specified. Hidden members
	// are only returned if the type filter in ListChannelMemberships equals HIDDEN.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMembershipsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMembershipsInput) SetChannelArn(v string) *ListChannelMembershipsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMembershipsInput) SetChimeBearer(v string) *ListChannelMembershipsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMembershipsInput) SetMaxResults(v int64) *ListChannelMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsInput) SetNextToken(v string) *ListChannelMembershipsInput {
	s.NextToken = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ListChannelMembershipsInput) SetSubChannelId(v string) *ListChannelMembershipsInput {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListChannelMembershipsInput) SetType(v string) *ListChannelMembershipsInput {
	s.Type = &v
	return s
}

type ListChannelMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information for the requested channel memberships.
	ChannelMemberships []*ChannelMembershipSummary `type:"list"`

	// The token passed by previous API calls until all requested channel memberships
	// are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMembershipsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMembershipsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMembershipsOutput) SetChannelArn(v string) *ListChannelMembershipsOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelMemberships sets the ChannelMemberships field's value.
func (s *ListChannelMembershipsOutput) SetChannelMemberships(v []*ChannelMembershipSummary) *ListChannelMembershipsOutput {
	s.ChannelMemberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMembershipsOutput) SetNextToken(v string) *ListChannelMembershipsOutput {
	s.NextToken = &v
	return s
}

type ListChannelMessagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of messages that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested messages are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMessagesInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The final or ending time stamp for your requested messages.
	NotAfter *time.Time `location:"querystring" locationName:"not-after" type:"timestamp"`

	// The initial or starting time stamp for your requested messages.
	NotBefore *time.Time `location:"querystring" locationName:"not-before" type:"timestamp"`

	// The order in which you want messages sorted. Default is Descending, based
	// on time created.
	SortOrder *string `location:"querystring" locationName:"sort-order" type:"string" enum:"SortOrder"`

	// The ID of the SubChannel in the request.
	//
	// Only required when listing the messages in a SubChannel that the user belongs
	// to.
	SubChannelId *string `location:"querystring" locationName:"sub-channel-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelMessagesInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMessagesInput) SetChannelArn(v string) *ListChannelMessagesInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelMessagesInput) SetChimeBearer(v string) *ListChannelMessagesInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelMessagesInput) SetMaxResults(v int64) *ListChannelMessagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMessagesInput) SetNextToken(v string) *ListChannelMessagesInput {
	s.NextToken = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *ListChannelMessagesInput) SetNotAfter(v time.Time) *ListChannelMessagesInput {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *ListChannelMessagesInput) SetNotBefore(v time.Time) *ListChannelMessagesInput {
	s.NotBefore = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListChannelMessagesInput) SetSortOrder(v string) *ListChannelMessagesInput {
	s.SortOrder = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ListChannelMessagesInput) SetSubChannelId(v string) *ListChannelMessagesInput {
	s.SubChannelId = &v
	return s
}

type ListChannelMessagesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the requested messages.
	ChannelArn *string `min:"5" type:"string"`

	// The information about, and content of, each requested message.
	ChannelMessages []*ChannelMessageSummary `type:"list"`

	// The token passed by previous API calls until all requested messages are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelMessagesOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// The ID of the SubChannel in the response.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelMessagesOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelMessagesOutput) SetChannelArn(v string) *ListChannelMessagesOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelMessages sets the ChannelMessages field's value.
func (s *ListChannelMessagesOutput) SetChannelMessages(v []*ChannelMessageSummary) *ListChannelMessagesOutput {
	s.ChannelMessages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelMessagesOutput) SetNextToken(v string) *ListChannelMessagesOutput {
	s.NextToken = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *ListChannelMessagesOutput) SetSubChannelId(v string) *ListChannelMessagesOutput {
	s.SubChannelId = &v
	return s
}

type ListChannelModeratorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of moderators that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested moderators are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelModeratorsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelModeratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelModeratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelModeratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelModeratorsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelModeratorsInput) SetChannelArn(v string) *ListChannelModeratorsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelModeratorsInput) SetChimeBearer(v string) *ListChannelModeratorsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelModeratorsInput) SetMaxResults(v int64) *ListChannelModeratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelModeratorsInput) SetNextToken(v string) *ListChannelModeratorsInput {
	s.NextToken = &v
	return s
}

type ListChannelModeratorsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The information about and names of each moderator.
	ChannelModerators []*ChannelModeratorSummary `type:"list"`

	// The token passed by previous API calls until all requested moderators are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelModeratorsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelModeratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelModeratorsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListChannelModeratorsOutput) SetChannelArn(v string) *ListChannelModeratorsOutput {
	s.ChannelArn = &v
	return s
}

// SetChannelModerators sets the ChannelModerators field's value.
func (s *ListChannelModeratorsOutput) SetChannelModerators(v []*ChannelModeratorSummary) *ListChannelModeratorsOutput {
	s.ChannelModerators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelModeratorsOutput) SetNextToken(v string) *ListChannelModeratorsOutput {
	s.NextToken = &v
	return s
}

type ListChannelsAssociatedWithChannelFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `location:"querystring" locationName:"channel-flow-arn" min:"5" type:"string" required:"true"`

	// The maximum number of channels that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channels are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsAssociatedWithChannelFlowInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsAssociatedWithChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsAssociatedWithChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsAssociatedWithChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsAssociatedWithChannelFlowInput"}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *ListChannelsAssociatedWithChannelFlowInput) SetChannelFlowArn(v string) *ListChannelsAssociatedWithChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsAssociatedWithChannelFlowInput) SetMaxResults(v int64) *ListChannelsAssociatedWithChannelFlowInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsAssociatedWithChannelFlowInput) SetNextToken(v string) *ListChannelsAssociatedWithChannelFlowInput {
	s.NextToken = &v
	return s
}

type ListChannelsAssociatedWithChannelFlowOutput struct {
	_ struct{} `type:"structure"`

	// The information about each channel.
	Channels []*ChannelAssociatedWithFlowSummary `type:"list"`

	// The token passed by previous API calls until all requested channels are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsAssociatedWithChannelFlowOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsAssociatedWithChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsAssociatedWithChannelFlowOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsAssociatedWithChannelFlowOutput) SetChannels(v []*ChannelAssociatedWithFlowSummary) *ListChannelsAssociatedWithChannelFlowOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsAssociatedWithChannelFlowOutput) SetNextToken(v string) *ListChannelsAssociatedWithChannelFlowOutput {
	s.NextToken = &v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channels that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested channels are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`

	// The privacy setting. PUBLIC retrieves all the public channels. PRIVATE retrieves
	// private channels. Only an AppInstanceAdmin can retrieve private channels.
	Privacy *string `location:"querystring" locationName:"privacy" type:"string" enum:"ChannelPrivacy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListChannelsInput) SetAppInstanceArn(v string) *ListChannelsInput {
	s.AppInstanceArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelsInput) SetChimeBearer(v string) *ListChannelsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

// SetPrivacy sets the Privacy field's value.
func (s *ListChannelsInput) SetPrivacy(v string) *ListChannelsInput {
	s.Privacy = &v
	return s
}

type ListChannelsModeratedByAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user or bot in the moderated channel.
	AppInstanceUserArn *string `location:"querystring" locationName:"app-instance-user-arn" min:"5" type:"string"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of channels in the request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsModeratedByAppInstanceUserInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsModeratedByAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsModeratedByAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsModeratedByAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsModeratedByAppInstanceUserInput"}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetAppInstanceUserArn(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetChimeBearer(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetMaxResults(v int64) *ListChannelsModeratedByAppInstanceUserInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsModeratedByAppInstanceUserInput) SetNextToken(v string) *ListChannelsModeratedByAppInstanceUserInput {
	s.NextToken = &v
	return s
}

type ListChannelsModeratedByAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The moderated channels in the request.
	Channels []*ChannelModeratedByAppInstanceUserSummary `type:"list"`

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsModeratedByAppInstanceUserOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsModeratedByAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsModeratedByAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsModeratedByAppInstanceUserOutput) SetChannels(v []*ChannelModeratedByAppInstanceUserSummary) *ListChannelsModeratedByAppInstanceUserOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsModeratedByAppInstanceUserOutput) SetNextToken(v string) *ListChannelsModeratedByAppInstanceUserOutput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// The information about each channel.
	Channels []*ChannelSummary `type:"list"`

	// The token returned from previous API requests until the number of channels
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListChannelsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListSubChannelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of elastic channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The AppInstanceUserArn of the user making the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The maximum number of sub-channels that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested sub-channels are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListSubChannelsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubChannelsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListSubChannelsInput) SetChannelArn(v string) *ListSubChannelsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *ListSubChannelsInput) SetChimeBearer(v string) *ListSubChannelsInput {
	s.ChimeBearer = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubChannelsInput) SetMaxResults(v int64) *ListSubChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubChannelsInput) SetNextToken(v string) *ListSubChannelsInput {
	s.NextToken = &v
	return s
}

type ListSubChannelsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of elastic channel.
	ChannelArn *string `min:"5" type:"string"`

	// The token passed by previous API calls until all requested sub-channels are
	// returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListSubChannelsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// The information about each sub-channel.
	SubChannels []*SubChannelSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubChannelsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ListSubChannelsOutput) SetChannelArn(v string) *ListSubChannelsOutput {
	s.ChannelArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubChannelsOutput) SetNextToken(v string) *ListSubChannelsOutput {
	s.NextToken = &v
	return s
}

// SetSubChannels sets the SubChannels field's value.
func (s *ListSubChannelsOutput) SetSubChannels(v []*SubChannelSummary) *ListSubChannelsOutput {
	s.SubChannels = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"arn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag key-value pairs.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A list of message attribute values.
type MessageAttributeValue struct {
	_ struct{} `type:"structure"`

	// The strings in a message attribute value.
	StringValues []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageAttributeValue) GoString() string {
	return s.String()
}

// SetStringValues sets the StringValues field's value.
func (s *MessageAttributeValue) SetStringValues(v []*string) *MessageAttributeValue {
	s.StringValues = v
	return s
}

// The websocket endpoint used to connect to Amazon Chime SDK messaging.
type MessagingSessionEndpoint struct {
	_ struct{} `type:"structure"`

	// The endpoint to which you establish a websocket connection.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessagingSessionEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessagingSessionEndpoint) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *MessagingSessionEndpoint) SetUrl(v string) *MessagingSessionEndpoint {
	s.Url = &v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The information about a processor in a channel flow.
type Processor struct {
	_ struct{} `type:"structure"`

	// The information about the type of processor and its identifier.
	//
	// Configuration is a required field
	Configuration *ProcessorConfiguration `type:"structure" required:"true"`

	// The sequence in which processors run. If you have multiple processors in
	// a channel flow, message processing goes through each processor in the sequence.
	// The value determines the sequence. At this point, we support only 1 processor
	// within a flow.
	//
	// ExecutionOrder is a required field
	ExecutionOrder *int64 `min:"1" type:"integer" required:"true"`

	// Determines whether to continue with message processing or stop it in cases
	// where communication with a processor fails. If a processor has a fallback
	// action of ABORT and communication with it fails, the processor sets the message
	// status to FAILED and does not send the message to any recipients. Note that
	// if the last processor in the channel flow sequence has a fallback action
	// of CONTINUE and communication with the processor fails, then the message
	// is considered processed and sent to recipients of the channel.
	//
	// FallbackAction is a required field
	FallbackAction *string `type:"string" required:"true" enum:"FallbackAction"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Processor's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Processor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Processor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Processor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Processor"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.ExecutionOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionOrder"))
	}
	if s.ExecutionOrder != nil && *s.ExecutionOrder < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExecutionOrder", 1))
	}
	if s.FallbackAction == nil {
		invalidParams.Add(request.NewErrParamRequired("FallbackAction"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *Processor) SetConfiguration(v *ProcessorConfiguration) *Processor {
	s.Configuration = v
	return s
}

// SetExecutionOrder sets the ExecutionOrder field's value.
func (s *Processor) SetExecutionOrder(v int64) *Processor {
	s.ExecutionOrder = &v
	return s
}

// SetFallbackAction sets the FallbackAction field's value.
func (s *Processor) SetFallbackAction(v string) *Processor {
	s.FallbackAction = &v
	return s
}

// SetName sets the Name field's value.
func (s *Processor) SetName(v string) *Processor {
	s.Name = &v
	return s
}

// A processor's metadata.
type ProcessorConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates that the processor is of type Lambda.
	//
	// Lambda is a required field
	Lambda *LambdaConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessorConfiguration"}
	if s.Lambda == nil {
		invalidParams.Add(request.NewErrParamRequired("Lambda"))
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambda sets the Lambda field's value.
func (s *ProcessorConfiguration) SetLambda(v *LambdaConfiguration) *ProcessorConfiguration {
	s.Lambda = v
	return s
}

// The push notification configuration of the message.
type PushNotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The body of the push notification.
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PushNotificationConfiguration's
	// String and GoString methods.
	Body *string `min:"1" type:"string" sensitive:"true"`

	// The title of the push notification.
	//
	// Title is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PushNotificationConfiguration's
	// String and GoString methods.
	Title *string `min:"1" type:"string" sensitive:"true"`

	// Enum value that indicates the type of the push notification for a message.
	// DEFAULT: Normal mobile push notification. VOIP: VOIP mobile push notification.
	Type *string `type:"string" enum:"PushNotificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushNotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushNotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PushNotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PushNotificationConfiguration"}
	if s.Body != nil && len(*s.Body) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Body", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *PushNotificationConfiguration) SetBody(v string) *PushNotificationConfiguration {
	s.Body = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *PushNotificationConfiguration) SetTitle(v string) *PushNotificationConfiguration {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *PushNotificationConfiguration) SetType(v string) *PushNotificationConfiguration {
	s.Type = &v
	return s
}

// The channel membership preferences for push notification.
type PushNotificationPreferences struct {
	_ struct{} `type:"structure"`

	// Enum value that indicates which push notifications to send to the requested
	// member of a channel. ALL sends all push notifications, NONE sends no push
	// notifications, FILTERED sends only filtered push notifications.
	//
	// AllowNotifications is a required field
	AllowNotifications *string `type:"string" required:"true" enum:"AllowNotifications"`

	// The simple JSON object used to send a subset of a push notification to the
	// requested member.
	//
	// FilterRule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PushNotificationPreferences's
	// String and GoString methods.
	FilterRule *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushNotificationPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushNotificationPreferences) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PushNotificationPreferences) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PushNotificationPreferences"}
	if s.AllowNotifications == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowNotifications"))
	}
	if s.FilterRule != nil && len(*s.FilterRule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterRule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowNotifications sets the AllowNotifications field's value.
func (s *PushNotificationPreferences) SetAllowNotifications(v string) *PushNotificationPreferences {
	s.AllowNotifications = &v
	return s
}

// SetFilterRule sets the FilterRule field's value.
func (s *PushNotificationPreferences) SetFilterRule(v string) *PushNotificationPreferences {
	s.FilterRule = &v
	return s
}

type PutChannelExpirationSettingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string"`

	// Settings that control the interval after which a channel is deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelExpirationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelExpirationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutChannelExpirationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutChannelExpirationSettingsInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.ExpirationSettings != nil {
		if err := s.ExpirationSettings.Validate(); err != nil {
			invalidParams.AddNested("ExpirationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutChannelExpirationSettingsInput) SetChannelArn(v string) *PutChannelExpirationSettingsInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *PutChannelExpirationSettingsInput) SetChimeBearer(v string) *PutChannelExpirationSettingsInput {
	s.ChimeBearer = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *PutChannelExpirationSettingsInput) SetExpirationSettings(v *ExpirationSettings) *PutChannelExpirationSettingsInput {
	s.ExpirationSettings = v
	return s
}

type PutChannelExpirationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The channel ARN.
	ChannelArn *string `min:"5" type:"string"`

	// Settings that control the interval after which a channel is deleted.
	ExpirationSettings *ExpirationSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelExpirationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelExpirationSettingsOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutChannelExpirationSettingsOutput) SetChannelArn(v string) *PutChannelExpirationSettingsOutput {
	s.ChannelArn = &v
	return s
}

// SetExpirationSettings sets the ExpirationSettings field's value.
func (s *PutChannelExpirationSettingsOutput) SetExpirationSettings(v *ExpirationSettings) *PutChannelExpirationSettingsOutput {
	s.ExpirationSettings = v
	return s
}

type PutChannelMembershipPreferencesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ARN of the member setting the preferences.
	//
	// MemberArn is a required field
	MemberArn *string `location:"uri" locationName:"memberArn" min:"5" type:"string" required:"true"`

	// The channel membership preferences of an AppInstanceUser .
	//
	// Preferences is a required field
	Preferences *ChannelMembershipPreferences `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelMembershipPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelMembershipPreferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutChannelMembershipPreferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutChannelMembershipPreferencesInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MemberArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberArn"))
	}
	if s.MemberArn != nil && len(*s.MemberArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("MemberArn", 5))
	}
	if s.Preferences == nil {
		invalidParams.Add(request.NewErrParamRequired("Preferences"))
	}
	if s.Preferences != nil {
		if err := s.Preferences.Validate(); err != nil {
			invalidParams.AddNested("Preferences", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutChannelMembershipPreferencesInput) SetChannelArn(v string) *PutChannelMembershipPreferencesInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *PutChannelMembershipPreferencesInput) SetChimeBearer(v string) *PutChannelMembershipPreferencesInput {
	s.ChimeBearer = &v
	return s
}

// SetMemberArn sets the MemberArn field's value.
func (s *PutChannelMembershipPreferencesInput) SetMemberArn(v string) *PutChannelMembershipPreferencesInput {
	s.MemberArn = &v
	return s
}

// SetPreferences sets the Preferences field's value.
func (s *PutChannelMembershipPreferencesInput) SetPreferences(v *ChannelMembershipPreferences) *PutChannelMembershipPreferencesInput {
	s.Preferences = v
	return s
}

type PutChannelMembershipPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The details of a user.
	Member *Identity `type:"structure"`

	// The ARN and metadata of the member being added.
	Preferences *ChannelMembershipPreferences `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelMembershipPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelMembershipPreferencesOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *PutChannelMembershipPreferencesOutput) SetChannelArn(v string) *PutChannelMembershipPreferencesOutput {
	s.ChannelArn = &v
	return s
}

// SetMember sets the Member field's value.
func (s *PutChannelMembershipPreferencesOutput) SetMember(v *Identity) *PutChannelMembershipPreferencesOutput {
	s.Member = v
	return s
}

// SetPreferences sets the Preferences field's value.
func (s *PutChannelMembershipPreferencesOutput) SetPreferences(v *ChannelMembershipPreferences) *PutChannelMembershipPreferencesOutput {
	s.Preferences = v
	return s
}

type PutMessagingStreamingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the streaming configuration.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The streaming configurations.
	//
	// StreamingConfigurations is a required field
	StreamingConfigurations []*StreamingConfiguration `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMessagingStreamingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMessagingStreamingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMessagingStreamingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMessagingStreamingConfigurationsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.StreamingConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingConfigurations"))
	}
	if s.StreamingConfigurations != nil && len(s.StreamingConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingConfigurations", 1))
	}
	if s.StreamingConfigurations != nil {
		for i, v := range s.StreamingConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StreamingConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *PutMessagingStreamingConfigurationsInput) SetAppInstanceArn(v string) *PutMessagingStreamingConfigurationsInput {
	s.AppInstanceArn = &v
	return s
}

// SetStreamingConfigurations sets the StreamingConfigurations field's value.
func (s *PutMessagingStreamingConfigurationsInput) SetStreamingConfigurations(v []*StreamingConfiguration) *PutMessagingStreamingConfigurationsInput {
	s.StreamingConfigurations = v
	return s
}

type PutMessagingStreamingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The requested streaming configurations.
	StreamingConfigurations []*StreamingConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMessagingStreamingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMessagingStreamingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetStreamingConfigurations sets the StreamingConfigurations field's value.
func (s *PutMessagingStreamingConfigurationsOutput) SetStreamingConfigurations(v []*StreamingConfiguration) *PutMessagingStreamingConfigurationsOutput {
	s.StreamingConfigurations = v
	return s
}

type RedactChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the messages that you want to redact.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The ID of the message being redacted.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The ID of the SubChannel in the request.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedactChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *RedactChannelMessageInput) SetChannelArn(v string) *RedactChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *RedactChannelMessageInput) SetChimeBearer(v string) *RedactChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *RedactChannelMessageInput) SetMessageId(v string) *RedactChannelMessageInput {
	s.MessageId = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *RedactChannelMessageInput) SetSubChannelId(v string) *RedactChannelMessageInput {
	s.SubChannelId = &v
	return s
}

type RedactChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel containing the messages that you want to redact.
	ChannelArn *string `min:"5" type:"string"`

	// The ID of the message being redacted.
	MessageId *string `min:"1" type:"string"`

	// The ID of the SubChannel in the response.
	//
	// Only required when redacting messages in a SubChannel that the user belongs
	// to.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *RedactChannelMessageOutput) SetChannelArn(v string) *RedactChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *RedactChannelMessageOutput) SetMessageId(v string) *RedactChannelMessageOutput {
	s.MessageId = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *RedactChannelMessageOutput) SetSubChannelId(v string) *RedactChannelMessageOutput {
	s.SubChannelId = &v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SearchChannelsInput struct {
	_ struct{} `type:"structure"`

	// The AppInstanceUserArn of the user making the API call.
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string"`

	// A list of the Field objects in the channel being searched.
	//
	// Fields is a required field
	Fields []*SearchField `min:"1" type:"list" required:"true"`

	// The maximum number of channels that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of channels
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchChannelsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchChannelsInput"}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.Fields != nil && len(s.Fields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fields", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *SearchChannelsInput) SetChimeBearer(v string) *SearchChannelsInput {
	s.ChimeBearer = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *SearchChannelsInput) SetFields(v []*SearchField) *SearchChannelsInput {
	s.Fields = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchChannelsInput) SetMaxResults(v int64) *SearchChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchChannelsInput) SetNextToken(v string) *SearchChannelsInput {
	s.NextToken = &v
	return s
}

type SearchChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the channels in the request.
	Channels []*ChannelSummary `type:"list"`

	// The token returned from previous API responses until the number of channels
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchChannelsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *SearchChannelsOutput) SetChannels(v []*ChannelSummary) *SearchChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchChannelsOutput) SetNextToken(v string) *SearchChannelsOutput {
	s.NextToken = &v
	return s
}

// A Field of the channel that you want to search.
type SearchField struct {
	_ struct{} `type:"structure"`

	// An enum value that indicates the key to search the channel on. MEMBERS allows
	// you to search channels based on memberships. You can use it with the EQUALS
	// operator to get channels whose memberships are equal to the specified values,
	// and with the INCLUDES operator to get channels whose memberships include
	// the specified values.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"SearchFieldKey"`

	// The operator used to compare field values, currently EQUALS or INCLUDES.
	// Use the EQUALS operator to find channels whose memberships equal the specified
	// values. Use the INCLUDES operator to find channels whose memberships include
	// the specified values.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"SearchFieldOperator"`

	// The values that you want to search for, a list of strings. The values must
	// be AppInstanceUserArns specified as a list of strings.
	//
	// This operation isn't supported for AppInstanceUsers with large number of
	// memberships.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchField"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *SearchField) SetKey(v string) *SearchField {
	s.Key = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *SearchField) SetOperator(v string) *SearchField {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchField) SetValues(v []*string) *SearchField {
	s.Values = v
	return s
}

type SendChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The Idempotency token for each client request.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendChannelMessageInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The content of the message.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendChannelMessageInput's
	// String and GoString methods.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The content type of the channel message.
	//
	// ContentType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendChannelMessageInput's
	// String and GoString methods.
	ContentType *string `type:"string" sensitive:"true"`

	// The attributes for the message, used for message filtering along with a FilterRule
	// defined in the PushNotificationPreferences.
	MessageAttributes map[string]*MessageAttributeValue `type:"map"`

	// The optional metadata for each message.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendChannelMessageInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// Boolean that controls whether the message is persisted on the back end. Required.
	//
	// Persistence is a required field
	Persistence *string `type:"string" required:"true" enum:"ChannelMessagePersistenceType"`

	// The push notification configuration of the message.
	PushNotification *PushNotificationConfiguration `type:"structure"`

	// The ID of the SubChannel in the request.
	SubChannelId *string `min:"1" type:"string"`

	// The type of message, STANDARD or CONTROL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelMessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Persistence == nil {
		invalidParams.Add(request.NewErrParamRequired("Persistence"))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.PushNotification != nil {
		if err := s.PushNotification.Validate(); err != nil {
			invalidParams.AddNested("PushNotification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *SendChannelMessageInput) SetChannelArn(v string) *SendChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *SendChannelMessageInput) SetChimeBearer(v string) *SendChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SendChannelMessageInput) SetClientRequestToken(v string) *SendChannelMessageInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendChannelMessageInput) SetContent(v string) *SendChannelMessageInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SendChannelMessageInput) SetContentType(v string) *SendChannelMessageInput {
	s.ContentType = &v
	return s
}

// SetMessageAttributes sets the MessageAttributes field's value.
func (s *SendChannelMessageInput) SetMessageAttributes(v map[string]*MessageAttributeValue) *SendChannelMessageInput {
	s.MessageAttributes = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *SendChannelMessageInput) SetMetadata(v string) *SendChannelMessageInput {
	s.Metadata = &v
	return s
}

// SetPersistence sets the Persistence field's value.
func (s *SendChannelMessageInput) SetPersistence(v string) *SendChannelMessageInput {
	s.Persistence = &v
	return s
}

// SetPushNotification sets the PushNotification field's value.
func (s *SendChannelMessageInput) SetPushNotification(v *PushNotificationConfiguration) *SendChannelMessageInput {
	s.PushNotification = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *SendChannelMessageInput) SetSubChannelId(v string) *SendChannelMessageInput {
	s.SubChannelId = &v
	return s
}

// SetType sets the Type field's value.
func (s *SendChannelMessageInput) SetType(v string) *SendChannelMessageInput {
	s.Type = &v
	return s
}

type SendChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ID string assigned to each message.
	MessageId *string `min:"1" type:"string"`

	// The status of the channel message.
	Status *ChannelMessageStatusStructure `type:"structure"`

	// The ID of the SubChannel in the response.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *SendChannelMessageOutput) SetChannelArn(v string) *SendChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *SendChannelMessageOutput) SetMessageId(v string) *SendChannelMessageOutput {
	s.MessageId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SendChannelMessageOutput) SetStatus(v *ChannelMessageStatusStructure) *SendChannelMessageOutput {
	s.Status = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *SendChannelMessageOutput) SetSubChannelId(v string) *SendChannelMessageOutput {
	s.SubChannelId = &v
	return s
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for connecting a messaging stream to Amazon Kinesis.
type StreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// The data type of the configuration.
	//
	// DataType is a required field
	DataType *string `type:"string" required:"true" enum:"MessagingDataType"`

	// The ARN of the resource in the configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingConfiguration"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *StreamingConfiguration) SetDataType(v string) *StreamingConfiguration {
	s.DataType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StreamingConfiguration) SetResourceArn(v string) *StreamingConfiguration {
	s.ResourceArn = &v
	return s
}

// Summary of the sub-channels associated with the elastic channel.
type SubChannelSummary struct {
	_ struct{} `type:"structure"`

	// The number of members in a SubChannel.
	MembershipCount *int64 `type:"integer"`

	// The unique ID of a SubChannel.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubChannelSummary) GoString() string {
	return s.String()
}

// SetMembershipCount sets the MembershipCount field's value.
func (s *SubChannelSummary) SetMembershipCount(v int64) *SubChannelSummary {
	s.MembershipCount = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *SubChannelSummary) SetSubChannelId(v string) *SubChannelSummary {
	s.SubChannelId = &v
	return s
}

// A tag object containing a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key in a tag.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value in a tag.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"5" type:"string" required:"true"`

	// The tag key-value pairs.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"5" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 5))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelFlowInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow.
	//
	// ChannelFlowArn is a required field
	ChannelFlowArn *string `location:"uri" locationName:"channelFlowArn" min:"5" type:"string" required:"true"`

	// The name of the channel flow.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelFlowInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Information about the processor Lambda functions
	//
	// Processors is a required field
	Processors []*Processor `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelFlowInput"}
	if s.ChannelFlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelFlowArn"))
	}
	if s.ChannelFlowArn != nil && len(*s.ChannelFlowArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelFlowArn", 5))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Processors == nil {
		invalidParams.Add(request.NewErrParamRequired("Processors"))
	}
	if s.Processors != nil && len(s.Processors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Processors", 1))
	}
	if s.Processors != nil {
		for i, v := range s.Processors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Processors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *UpdateChannelFlowInput) SetChannelFlowArn(v string) *UpdateChannelFlowInput {
	s.ChannelFlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelFlowInput) SetName(v string) *UpdateChannelFlowInput {
	s.Name = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *UpdateChannelFlowInput) SetProcessors(v []*Processor) *UpdateChannelFlowInput {
	s.Processors = v
	return s
}

type UpdateChannelFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel flow.
	ChannelFlowArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelFlowOutput) GoString() string {
	return s.String()
}

// SetChannelFlowArn sets the ChannelFlowArn field's value.
func (s *UpdateChannelFlowOutput) SetChannelFlowArn(v string) *UpdateChannelFlowOutput {
	s.ChannelFlowArn = &v
	return s
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The metadata for the update request.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The mode of the update request.
	Mode *string `type:"string" enum:"ChannelMode"`

	// The name of the channel.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelInput) SetChannelArn(v string) *UpdateChannelInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelInput) SetChimeBearer(v string) *UpdateChannelInput {
	s.ChimeBearer = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateChannelInput) SetMetadata(v string) *UpdateChannelInput {
	s.Metadata = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *UpdateChannelInput) SetMode(v string) *UpdateChannelInput {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

type UpdateChannelMessageInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`

	// The content of the message being updated.
	//
	// Content is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelMessageInput's
	// String and GoString methods.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The content type of the channel message.
	//
	// ContentType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelMessageInput's
	// String and GoString methods.
	ContentType *string `type:"string" sensitive:"true"`

	// The ID string of the message being updated.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"1" type:"string" required:"true"`

	// The metadata of the message being updated.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateChannelMessageInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The ID of the SubChannel in the request.
	//
	// Only required when updating messages in a SubChannel that the user belongs
	// to.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelMessageInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.SubChannelId != nil && len(*s.SubChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelMessageInput) SetChannelArn(v string) *UpdateChannelMessageInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelMessageInput) SetChimeBearer(v string) *UpdateChannelMessageInput {
	s.ChimeBearer = &v
	return s
}

// SetContent sets the Content field's value.
func (s *UpdateChannelMessageInput) SetContent(v string) *UpdateChannelMessageInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *UpdateChannelMessageInput) SetContentType(v string) *UpdateChannelMessageInput {
	s.ContentType = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateChannelMessageInput) SetMessageId(v string) *UpdateChannelMessageInput {
	s.MessageId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateChannelMessageInput) SetMetadata(v string) *UpdateChannelMessageInput {
	s.Metadata = &v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *UpdateChannelMessageInput) SetSubChannelId(v string) *UpdateChannelMessageInput {
	s.SubChannelId = &v
	return s
}

type UpdateChannelMessageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`

	// The ID string of the message being updated.
	MessageId *string `min:"1" type:"string"`

	// The status of the message update.
	Status *ChannelMessageStatusStructure `type:"structure"`

	// The ID of the SubChannel in the response.
	SubChannelId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelMessageOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelMessageOutput) SetChannelArn(v string) *UpdateChannelMessageOutput {
	s.ChannelArn = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateChannelMessageOutput) SetMessageId(v string) *UpdateChannelMessageOutput {
	s.MessageId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateChannelMessageOutput) SetStatus(v *ChannelMessageStatusStructure) *UpdateChannelMessageOutput {
	s.Status = v
	return s
}

// SetSubChannelId sets the SubChannelId field's value.
func (s *UpdateChannelMessageOutput) SetSubChannelId(v string) *UpdateChannelMessageOutput {
	s.SubChannelId = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelOutput) SetChannelArn(v string) *UpdateChannelOutput {
	s.ChannelArn = &v
	return s
}

type UpdateChannelReadMarkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the channel.
	//
	// ChannelArn is a required field
	ChannelArn *string `location:"uri" locationName:"channelArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstanceUser or AppInstanceBot that makes the API call.
	//
	// ChimeBearer is a required field
	ChimeBearer *string `location:"header" locationName:"x-amz-chime-bearer" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelReadMarkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelReadMarkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelReadMarkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelReadMarkerInput"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 5))
	}
	if s.ChimeBearer == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeBearer"))
	}
	if s.ChimeBearer != nil && len(*s.ChimeBearer) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChimeBearer", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelReadMarkerInput) SetChannelArn(v string) *UpdateChannelReadMarkerInput {
	s.ChannelArn = &v
	return s
}

// SetChimeBearer sets the ChimeBearer field's value.
func (s *UpdateChannelReadMarkerInput) SetChimeBearer(v string) *UpdateChannelReadMarkerInput {
	s.ChimeBearer = &v
	return s
}

type UpdateChannelReadMarkerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	ChannelArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelReadMarkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelReadMarkerOutput) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *UpdateChannelReadMarkerOutput) SetChannelArn(v string) *UpdateChannelReadMarkerOutput {
	s.ChannelArn = &v
	return s
}

const (
	// AllowNotificationsAll is a AllowNotifications enum value
	AllowNotificationsAll = "ALL"

	// AllowNotificationsNone is a AllowNotifications enum value
	AllowNotificationsNone = "NONE"

	// AllowNotificationsFiltered is a AllowNotifications enum value
	AllowNotificationsFiltered = "FILTERED"
)

// AllowNotifications_Values returns all elements of the AllowNotifications enum
func AllowNotifications_Values() []string {
	return []string{
		AllowNotificationsAll,
		AllowNotificationsNone,
		AllowNotificationsFiltered,
	}
}

const (
	// ChannelMembershipTypeDefault is a ChannelMembershipType enum value
	ChannelMembershipTypeDefault = "DEFAULT"

	// ChannelMembershipTypeHidden is a ChannelMembershipType enum value
	ChannelMembershipTypeHidden = "HIDDEN"
)

// ChannelMembershipType_Values returns all elements of the ChannelMembershipType enum
func ChannelMembershipType_Values() []string {
	return []string{
		ChannelMembershipTypeDefault,
		ChannelMembershipTypeHidden,
	}
}

const (
	// ChannelMessagePersistenceTypePersistent is a ChannelMessagePersistenceType enum value
	ChannelMessagePersistenceTypePersistent = "PERSISTENT"

	// ChannelMessagePersistenceTypeNonPersistent is a ChannelMessagePersistenceType enum value
	ChannelMessagePersistenceTypeNonPersistent = "NON_PERSISTENT"
)

// ChannelMessagePersistenceType_Values returns all elements of the ChannelMessagePersistenceType enum
func ChannelMessagePersistenceType_Values() []string {
	return []string{
		ChannelMessagePersistenceTypePersistent,
		ChannelMessagePersistenceTypeNonPersistent,
	}
}

const (
	// ChannelMessageStatusSent is a ChannelMessageStatus enum value
	ChannelMessageStatusSent = "SENT"

	// ChannelMessageStatusPending is a ChannelMessageStatus enum value
	ChannelMessageStatusPending = "PENDING"

	// ChannelMessageStatusFailed is a ChannelMessageStatus enum value
	ChannelMessageStatusFailed = "FAILED"

	// ChannelMessageStatusDenied is a ChannelMessageStatus enum value
	ChannelMessageStatusDenied = "DENIED"
)

// ChannelMessageStatus_Values returns all elements of the ChannelMessageStatus enum
func ChannelMessageStatus_Values() []string {
	return []string{
		ChannelMessageStatusSent,
		ChannelMessageStatusPending,
		ChannelMessageStatusFailed,
		ChannelMessageStatusDenied,
	}
}

const (
	// ChannelMessageTypeStandard is a ChannelMessageType enum value
	ChannelMessageTypeStandard = "STANDARD"

	// ChannelMessageTypeControl is a ChannelMessageType enum value
	ChannelMessageTypeControl = "CONTROL"
)

// ChannelMessageType_Values returns all elements of the ChannelMessageType enum
func ChannelMessageType_Values() []string {
	return []string{
		ChannelMessageTypeStandard,
		ChannelMessageTypeControl,
	}
}

const (
	// ChannelModeUnrestricted is a ChannelMode enum value
	ChannelModeUnrestricted = "UNRESTRICTED"

	// ChannelModeRestricted is a ChannelMode enum value
	ChannelModeRestricted = "RESTRICTED"
)

// ChannelMode_Values returns all elements of the ChannelMode enum
func ChannelMode_Values() []string {
	return []string{
		ChannelModeUnrestricted,
		ChannelModeRestricted,
	}
}

const (
	// ChannelPrivacyPublic is a ChannelPrivacy enum value
	ChannelPrivacyPublic = "PUBLIC"

	// ChannelPrivacyPrivate is a ChannelPrivacy enum value
	ChannelPrivacyPrivate = "PRIVATE"
)

// ChannelPrivacy_Values returns all elements of the ChannelPrivacy enum
func ChannelPrivacy_Values() []string {
	return []string{
		ChannelPrivacyPublic,
		ChannelPrivacyPrivate,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeConflict,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodePreconditionFailed,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeAccessDenied,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottled,
		ErrorCodeThrottling,
		ErrorCodeUnauthorized,
		ErrorCodeUnprocessable,
		ErrorCodeVoiceConnectorGroupAssociationsExist,
		ErrorCodePhoneNumberAssociationsExist,
	}
}

const (
	// ExpirationCriterionCreatedTimestamp is a ExpirationCriterion enum value
	ExpirationCriterionCreatedTimestamp = "CREATED_TIMESTAMP"

	// ExpirationCriterionLastMessageTimestamp is a ExpirationCriterion enum value
	ExpirationCriterionLastMessageTimestamp = "LAST_MESSAGE_TIMESTAMP"
)

// ExpirationCriterion_Values returns all elements of the ExpirationCriterion enum
func ExpirationCriterion_Values() []string {
	return []string{
		ExpirationCriterionCreatedTimestamp,
		ExpirationCriterionLastMessageTimestamp,
	}
}

const (
	// FallbackActionContinue is a FallbackAction enum value
	FallbackActionContinue = "CONTINUE"

	// FallbackActionAbort is a FallbackAction enum value
	FallbackActionAbort = "ABORT"
)

// FallbackAction_Values returns all elements of the FallbackAction enum
func FallbackAction_Values() []string {
	return []string{
		FallbackActionContinue,
		FallbackActionAbort,
	}
}

const (
	// InvocationTypeAsync is a InvocationType enum value
	InvocationTypeAsync = "ASYNC"
)

// InvocationType_Values returns all elements of the InvocationType enum
func InvocationType_Values() []string {
	return []string{
		InvocationTypeAsync,
	}
}

const (
	// MessagingDataTypeChannel is a MessagingDataType enum value
	MessagingDataTypeChannel = "Channel"

	// MessagingDataTypeChannelMessage is a MessagingDataType enum value
	MessagingDataTypeChannelMessage = "ChannelMessage"
)

// MessagingDataType_Values returns all elements of the MessagingDataType enum
func MessagingDataType_Values() []string {
	return []string{
		MessagingDataTypeChannel,
		MessagingDataTypeChannelMessage,
	}
}

const (
	// PushNotificationTypeDefault is a PushNotificationType enum value
	PushNotificationTypeDefault = "DEFAULT"

	// PushNotificationTypeVoip is a PushNotificationType enum value
	PushNotificationTypeVoip = "VOIP"
)

// PushNotificationType_Values returns all elements of the PushNotificationType enum
func PushNotificationType_Values() []string {
	return []string{
		PushNotificationTypeDefault,
		PushNotificationTypeVoip,
	}
}

const (
	// SearchFieldKeyMembers is a SearchFieldKey enum value
	SearchFieldKeyMembers = "MEMBERS"
)

// SearchFieldKey_Values returns all elements of the SearchFieldKey enum
func SearchFieldKey_Values() []string {
	return []string{
		SearchFieldKeyMembers,
	}
}

const (
	// SearchFieldOperatorEquals is a SearchFieldOperator enum value
	SearchFieldOperatorEquals = "EQUALS"

	// SearchFieldOperatorIncludes is a SearchFieldOperator enum value
	SearchFieldOperatorIncludes = "INCLUDES"
)

// SearchFieldOperator_Values returns all elements of the SearchFieldOperator enum
func SearchFieldOperator_Values() []string {
	return []string{
		SearchFieldOperatorEquals,
		SearchFieldOperatorIncludes,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
