// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes a request to assign the billing of the unused capacity of a Capacity
// Reservation. For more information, see [Billing assignment for shared Amazon EC2 Capacity Reservations].
//
// [Billing assignment for shared Amazon EC2 Capacity Reservations]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/transfer-billing.html
func (c *Client) DescribeCapacityReservationBillingRequests(ctx context.Context, params *DescribeCapacityReservationBillingRequestsInput, optFns ...func(*Options)) (*DescribeCapacityReservationBillingRequestsOutput, error) {
	if params == nil {
		params = &DescribeCapacityReservationBillingRequestsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCapacityReservationBillingRequests", params, optFns, c.addOperationDescribeCapacityReservationBillingRequestsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCapacityReservationBillingRequestsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCapacityReservationBillingRequestsInput struct {

	// Specify one of the following:
	//
	//   - odcr-owner - If you are the Capacity Reservation owner, specify this value
	//   to view requests that you have initiated. Not supported with the requested-by
	//   filter.
	//
	//   - unused-reservation-billing-owner - If you are the consumer account, specify
	//   this value to view requests that have been sent to you. Not supported with the
	//   unused-reservation-billing-owner filter.
	//
	// This member is required.
	Role types.CallerRole

	// The ID of the Capacity Reservation.
	CapacityReservationIds []string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters.
	//
	//   - status - The state of the request ( pending | accepted | rejected |
	//   cancelled | revoked | expired ).
	//
	//   - requested-by - The account ID of the Capacity Reservation owner that
	//   initiated the request. Not supported if you specify requested-by for Role.
	//
	//   - unused-reservation-billing-owner - The ID of the consumer account to which
	//   the request was sent. Not supported if you specify
	//   unused-reservation-billing-owner for Role.
	Filters []types.Filter

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCapacityReservationBillingRequestsOutput struct {

	// Information about the request.
	CapacityReservationBillingRequests []types.CapacityReservationBillingRequest

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCapacityReservationBillingRequestsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeCapacityReservationBillingRequests{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeCapacityReservationBillingRequests{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCapacityReservationBillingRequests"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeCapacityReservationBillingRequestsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCapacityReservationBillingRequests(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCapacityReservationBillingRequestsPaginatorOptions is the paginator
// options for DescribeCapacityReservationBillingRequests
type DescribeCapacityReservationBillingRequestsPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCapacityReservationBillingRequestsPaginator is a paginator for
// DescribeCapacityReservationBillingRequests
type DescribeCapacityReservationBillingRequestsPaginator struct {
	options   DescribeCapacityReservationBillingRequestsPaginatorOptions
	client    DescribeCapacityReservationBillingRequestsAPIClient
	params    *DescribeCapacityReservationBillingRequestsInput
	nextToken *string
	firstPage bool
}

// NewDescribeCapacityReservationBillingRequestsPaginator returns a new
// DescribeCapacityReservationBillingRequestsPaginator
func NewDescribeCapacityReservationBillingRequestsPaginator(client DescribeCapacityReservationBillingRequestsAPIClient, params *DescribeCapacityReservationBillingRequestsInput, optFns ...func(*DescribeCapacityReservationBillingRequestsPaginatorOptions)) *DescribeCapacityReservationBillingRequestsPaginator {
	if params == nil {
		params = &DescribeCapacityReservationBillingRequestsInput{}
	}

	options := DescribeCapacityReservationBillingRequestsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCapacityReservationBillingRequestsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCapacityReservationBillingRequestsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeCapacityReservationBillingRequests page.
func (p *DescribeCapacityReservationBillingRequestsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCapacityReservationBillingRequestsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeCapacityReservationBillingRequests(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeCapacityReservationBillingRequestsAPIClient is a client that implements
// the DescribeCapacityReservationBillingRequests operation.
type DescribeCapacityReservationBillingRequestsAPIClient interface {
	DescribeCapacityReservationBillingRequests(context.Context, *DescribeCapacityReservationBillingRequestsInput, ...func(*Options)) (*DescribeCapacityReservationBillingRequestsOutput, error)
}

var _ DescribeCapacityReservationBillingRequestsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeCapacityReservationBillingRequests(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCapacityReservationBillingRequests",
	}
}
