// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gkeconnect/gateway/v1/control.proto

package gatewaypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GatewayControl_GenerateCredentials_FullMethodName = "/google.cloud.gkeconnect.gateway.v1.GatewayControl/GenerateCredentials"
)

// GatewayControlClient is the client API for GatewayControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GatewayControlClient interface {
	// GenerateCredentials provides connection information that allows a user to
	// access the specified membership using Connect Gateway.
	GenerateCredentials(ctx context.Context, in *GenerateCredentialsRequest, opts ...grpc.CallOption) (*GenerateCredentialsResponse, error)
}

type gatewayControlClient struct {
	cc grpc.ClientConnInterface
}

func NewGatewayControlClient(cc grpc.ClientConnInterface) GatewayControlClient {
	return &gatewayControlClient{cc}
}

func (c *gatewayControlClient) GenerateCredentials(ctx context.Context, in *GenerateCredentialsRequest, opts ...grpc.CallOption) (*GenerateCredentialsResponse, error) {
	out := new(GenerateCredentialsResponse)
	err := c.cc.Invoke(ctx, GatewayControl_GenerateCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GatewayControlServer is the server API for GatewayControl service.
// All implementations should embed UnimplementedGatewayControlServer
// for forward compatibility
type GatewayControlServer interface {
	// GenerateCredentials provides connection information that allows a user to
	// access the specified membership using Connect Gateway.
	GenerateCredentials(context.Context, *GenerateCredentialsRequest) (*GenerateCredentialsResponse, error)
}

// UnimplementedGatewayControlServer should be embedded to have forward compatible implementations.
type UnimplementedGatewayControlServer struct {
}

func (UnimplementedGatewayControlServer) GenerateCredentials(context.Context, *GenerateCredentialsRequest) (*GenerateCredentialsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateCredentials not implemented")
}

// UnsafeGatewayControlServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GatewayControlServer will
// result in compilation errors.
type UnsafeGatewayControlServer interface {
	mustEmbedUnimplementedGatewayControlServer()
}

func RegisterGatewayControlServer(s grpc.ServiceRegistrar, srv GatewayControlServer) {
	s.RegisterService(&GatewayControl_ServiceDesc, srv)
}

func _GatewayControl_GenerateCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayControlServer).GenerateCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GatewayControl_GenerateCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayControlServer).GenerateCredentials(ctx, req.(*GenerateCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GatewayControl_ServiceDesc is the grpc.ServiceDesc for GatewayControl service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GatewayControl_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkeconnect.gateway.v1.GatewayControl",
	HandlerType: (*GatewayControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateCredentials",
			Handler:    _GatewayControl_GenerateCredentials_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkeconnect/gateway/v1/control.proto",
}
