// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package contactcenterinsightspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the options for viewing a conversation.
type ConversationView int32

const (
	// The conversation view is not specified.
	//
	// * Defaults to `FULL` in `GetConversationRequest`.
	// * Defaults to `BASIC` in `ListConversationsRequest`.
	ConversationView_CONVERSATION_VIEW_UNSPECIFIED ConversationView = 0
	// Populates all fields in the conversation.
	ConversationView_FULL ConversationView = 2
	// Populates all fields in the conversation except the transcript.
	ConversationView_BASIC ConversationView = 1
)

// Enum value maps for ConversationView.
var (
	ConversationView_name = map[int32]string{
		0: "CONVERSATION_VIEW_UNSPECIFIED",
		2: "FULL",
		1: "BASIC",
	}
	ConversationView_value = map[string]int32{
		"CONVERSATION_VIEW_UNSPECIFIED": 0,
		"FULL":                          2,
		"BASIC":                         1,
	}
)

func (x ConversationView) Enum() *ConversationView {
	p := new(ConversationView)
	*p = x
	return p
}

func (x ConversationView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0].Descriptor()
}

func (ConversationView) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[0]
}

func (x ConversationView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationView.Descriptor instead.
func (ConversationView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

type IngestConversationsRequest_GcsSource_BucketObjectType int32

const (
	// The object type is unspecified and will default to `TRANSCRIPT`.
	IngestConversationsRequest_GcsSource_BUCKET_OBJECT_TYPE_UNSPECIFIED IngestConversationsRequest_GcsSource_BucketObjectType = 0
	// The object is a transcript.
	IngestConversationsRequest_GcsSource_TRANSCRIPT IngestConversationsRequest_GcsSource_BucketObjectType = 1
	// The object is an audio file.
	IngestConversationsRequest_GcsSource_AUDIO IngestConversationsRequest_GcsSource_BucketObjectType = 2
)

// Enum value maps for IngestConversationsRequest_GcsSource_BucketObjectType.
var (
	IngestConversationsRequest_GcsSource_BucketObjectType_name = map[int32]string{
		0: "BUCKET_OBJECT_TYPE_UNSPECIFIED",
		1: "TRANSCRIPT",
		2: "AUDIO",
	}
	IngestConversationsRequest_GcsSource_BucketObjectType_value = map[string]int32{
		"BUCKET_OBJECT_TYPE_UNSPECIFIED": 0,
		"TRANSCRIPT":                     1,
		"AUDIO":                          2,
	}
)

func (x IngestConversationsRequest_GcsSource_BucketObjectType) Enum() *IngestConversationsRequest_GcsSource_BucketObjectType {
	p := new(IngestConversationsRequest_GcsSource_BucketObjectType)
	*p = x
	return p
}

func (x IngestConversationsRequest_GcsSource_BucketObjectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestConversationsRequest_GcsSource_BucketObjectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[1].Descriptor()
}

func (IngestConversationsRequest_GcsSource_BucketObjectType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[1]
}

func (x IngestConversationsRequest_GcsSource_BucketObjectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestConversationsRequest_GcsSource_BucketObjectType.Descriptor instead.
func (IngestConversationsRequest_GcsSource_BucketObjectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 0, 0}
}

// Specifies the action that occurs if the destination table already exists.
type ExportInsightsDataRequest_WriteDisposition int32

const (
	// Write disposition is not specified. Defaults to WRITE_TRUNCATE.
	ExportInsightsDataRequest_WRITE_DISPOSITION_UNSPECIFIED ExportInsightsDataRequest_WriteDisposition = 0
	// If the table already exists, BigQuery will overwrite the table data and
	// use the schema from the load.
	ExportInsightsDataRequest_WRITE_TRUNCATE ExportInsightsDataRequest_WriteDisposition = 1
	// If the table already exists, BigQuery will append data to the table.
	ExportInsightsDataRequest_WRITE_APPEND ExportInsightsDataRequest_WriteDisposition = 2
)

// Enum value maps for ExportInsightsDataRequest_WriteDisposition.
var (
	ExportInsightsDataRequest_WriteDisposition_name = map[int32]string{
		0: "WRITE_DISPOSITION_UNSPECIFIED",
		1: "WRITE_TRUNCATE",
		2: "WRITE_APPEND",
	}
	ExportInsightsDataRequest_WriteDisposition_value = map[string]int32{
		"WRITE_DISPOSITION_UNSPECIFIED": 0,
		"WRITE_TRUNCATE":                1,
		"WRITE_APPEND":                  2,
	}
)

func (x ExportInsightsDataRequest_WriteDisposition) Enum() *ExportInsightsDataRequest_WriteDisposition {
	p := new(ExportInsightsDataRequest_WriteDisposition)
	*p = x
	return p
}

func (x ExportInsightsDataRequest_WriteDisposition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportInsightsDataRequest_WriteDisposition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[2].Descriptor()
}

func (ExportInsightsDataRequest_WriteDisposition) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[2]
}

func (x ExportInsightsDataRequest_WriteDisposition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportInsightsDataRequest_WriteDisposition.Descriptor instead.
func (ExportInsightsDataRequest_WriteDisposition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25, 0}
}

// The key of the dimension.
type Dimension_DimensionKey int32

const (
	// The key of the dimension is unspecified.
	Dimension_DIMENSION_KEY_UNSPECIFIED Dimension_DimensionKey = 0
	// The dimension is keyed by issues.
	Dimension_ISSUE Dimension_DimensionKey = 1
	// The dimension is keyed by agents.
	Dimension_AGENT Dimension_DimensionKey = 2
	// The dimension is keyed by agent teams.
	Dimension_AGENT_TEAM Dimension_DimensionKey = 3
	// The dimension is keyed by QaQuestionIds.
	// Note that: We only group by the QuestionId and not the revision-id of the
	// scorecard this question is a part of. This allows for showing stats for
	// the same question across different scorecard revisions.
	Dimension_QA_QUESTION_ID Dimension_DimensionKey = 4
	// The dimension is keyed by QaQuestionIds-Answer value pairs.
	// Note that: We only group by the QuestionId and not the revision-id of the
	// scorecard this question is a part of. This allows for showing
	// distribution of answers per question across different scorecard
	// revisions.
	Dimension_QA_QUESTION_ANSWER_VALUE Dimension_DimensionKey = 5
	// The dimension is keyed by the conversation profile ID.
	Dimension_CONVERSATION_PROFILE_ID Dimension_DimensionKey = 6
)

// Enum value maps for Dimension_DimensionKey.
var (
	Dimension_DimensionKey_name = map[int32]string{
		0: "DIMENSION_KEY_UNSPECIFIED",
		1: "ISSUE",
		2: "AGENT",
		3: "AGENT_TEAM",
		4: "QA_QUESTION_ID",
		5: "QA_QUESTION_ANSWER_VALUE",
		6: "CONVERSATION_PROFILE_ID",
	}
	Dimension_DimensionKey_value = map[string]int32{
		"DIMENSION_KEY_UNSPECIFIED": 0,
		"ISSUE":                     1,
		"AGENT":                     2,
		"AGENT_TEAM":                3,
		"QA_QUESTION_ID":            4,
		"QA_QUESTION_ANSWER_VALUE":  5,
		"CONVERSATION_PROFILE_ID":   6,
	}
)

func (x Dimension_DimensionKey) Enum() *Dimension_DimensionKey {
	p := new(Dimension_DimensionKey)
	*p = x
	return p
}

func (x Dimension_DimensionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Dimension_DimensionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[3].Descriptor()
}

func (Dimension_DimensionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[3]
}

func (x Dimension_DimensionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Dimension_DimensionKey.Descriptor instead.
func (Dimension_DimensionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79, 0}
}

// A time granularity divides the time line into discrete time periods.
// This is useful for defining buckets over which filtering and aggregation
// should be performed.
type QueryMetricsRequest_TimeGranularity int32

const (
	// The time granularity is unspecified and will default to NONE.
	QueryMetricsRequest_TIME_GRANULARITY_UNSPECIFIED QueryMetricsRequest_TimeGranularity = 0
	// No time granularity. The response won't contain a time series.
	// This is the default value if no time granularity is specified.
	QueryMetricsRequest_NONE QueryMetricsRequest_TimeGranularity = 1
	// Data points in the time series will aggregate at a daily granularity.
	// 1 day means [midnight to midnight).
	QueryMetricsRequest_DAILY QueryMetricsRequest_TimeGranularity = 2
	// Data points in the time series will aggregate at a daily granularity.
	// 1 HOUR means [01:00 to 02:00).
	QueryMetricsRequest_HOURLY QueryMetricsRequest_TimeGranularity = 3
	// Data points in the time series will aggregate at a daily granularity.
	// PER_MINUTE means [01:00 to 01:01).
	QueryMetricsRequest_PER_MINUTE QueryMetricsRequest_TimeGranularity = 4
	// Data points in the time series will aggregate at a 1 minute  granularity.
	// PER_5_MINUTES means [01:00 to 01:05).
	QueryMetricsRequest_PER_5_MINUTES QueryMetricsRequest_TimeGranularity = 5
	// Data points in the time series will aggregate at a monthly granularity.
	// 1 MONTH means [01st of the month to 1st of the next month).
	QueryMetricsRequest_MONTHLY QueryMetricsRequest_TimeGranularity = 6
)

// Enum value maps for QueryMetricsRequest_TimeGranularity.
var (
	QueryMetricsRequest_TimeGranularity_name = map[int32]string{
		0: "TIME_GRANULARITY_UNSPECIFIED",
		1: "NONE",
		2: "DAILY",
		3: "HOURLY",
		4: "PER_MINUTE",
		5: "PER_5_MINUTES",
		6: "MONTHLY",
	}
	QueryMetricsRequest_TimeGranularity_value = map[string]int32{
		"TIME_GRANULARITY_UNSPECIFIED": 0,
		"NONE":                         1,
		"DAILY":                        2,
		"HOURLY":                       3,
		"PER_MINUTE":                   4,
		"PER_5_MINUTES":                5,
		"MONTHLY":                      6,
	}
)

func (x QueryMetricsRequest_TimeGranularity) Enum() *QueryMetricsRequest_TimeGranularity {
	p := new(QueryMetricsRequest_TimeGranularity)
	*p = x
	return p
}

func (x QueryMetricsRequest_TimeGranularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QueryMetricsRequest_TimeGranularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[4].Descriptor()
}

func (QueryMetricsRequest_TimeGranularity) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[4]
}

func (x QueryMetricsRequest_TimeGranularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QueryMetricsRequest_TimeGranularity.Descriptor instead.
func (QueryMetricsRequest_TimeGranularity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{80, 0}
}

// All permissible file formats.
type BulkUploadFeedbackLabelsRequest_GcsSource_Format int32

const (
	// Unspecified format.
	BulkUploadFeedbackLabelsRequest_GcsSource_FORMAT_UNSPECIFIED BulkUploadFeedbackLabelsRequest_GcsSource_Format = 0
	// CSV format.
	BulkUploadFeedbackLabelsRequest_GcsSource_CSV BulkUploadFeedbackLabelsRequest_GcsSource_Format = 1
	// JSON format.
	BulkUploadFeedbackLabelsRequest_GcsSource_JSON BulkUploadFeedbackLabelsRequest_GcsSource_Format = 2
)

// Enum value maps for BulkUploadFeedbackLabelsRequest_GcsSource_Format.
var (
	BulkUploadFeedbackLabelsRequest_GcsSource_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "CSV",
		2: "JSON",
	}
	BulkUploadFeedbackLabelsRequest_GcsSource_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"CSV":                1,
		"JSON":               2,
	}
)

func (x BulkUploadFeedbackLabelsRequest_GcsSource_Format) Enum() *BulkUploadFeedbackLabelsRequest_GcsSource_Format {
	p := new(BulkUploadFeedbackLabelsRequest_GcsSource_Format)
	*p = x
	return p
}

func (x BulkUploadFeedbackLabelsRequest_GcsSource_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BulkUploadFeedbackLabelsRequest_GcsSource_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[5].Descriptor()
}

func (BulkUploadFeedbackLabelsRequest_GcsSource_Format) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[5]
}

func (x BulkUploadFeedbackLabelsRequest_GcsSource_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsRequest_GcsSource_Format.Descriptor instead.
func (BulkUploadFeedbackLabelsRequest_GcsSource_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{113, 0, 0}
}

// Possible feedback label types that will be downloaded.
type BulkDownloadFeedbackLabelsRequest_FeedbackLabelType int32

const (
	// Unspecified format
	BulkDownloadFeedbackLabelsRequest_FEEDBACK_LABEL_TYPE_UNSPECIFIED BulkDownloadFeedbackLabelsRequest_FeedbackLabelType = 0
	// Downloaded file will contain all Quality AI labels from the latest
	// scorecard revision.
	BulkDownloadFeedbackLabelsRequest_QUALITY_AI BulkDownloadFeedbackLabelsRequest_FeedbackLabelType = 1
	// Downloaded file will contain only Topic Modeling labels.
	BulkDownloadFeedbackLabelsRequest_TOPIC_MODELING BulkDownloadFeedbackLabelsRequest_FeedbackLabelType = 2
)

// Enum value maps for BulkDownloadFeedbackLabelsRequest_FeedbackLabelType.
var (
	BulkDownloadFeedbackLabelsRequest_FeedbackLabelType_name = map[int32]string{
		0: "FEEDBACK_LABEL_TYPE_UNSPECIFIED",
		1: "QUALITY_AI",
		2: "TOPIC_MODELING",
	}
	BulkDownloadFeedbackLabelsRequest_FeedbackLabelType_value = map[string]int32{
		"FEEDBACK_LABEL_TYPE_UNSPECIFIED": 0,
		"QUALITY_AI":                      1,
		"TOPIC_MODELING":                  2,
	}
)

func (x BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) Enum() *BulkDownloadFeedbackLabelsRequest_FeedbackLabelType {
	p := new(BulkDownloadFeedbackLabelsRequest_FeedbackLabelType)
	*p = x
	return p
}

func (x BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[6].Descriptor()
}

func (BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[6]
}

func (x BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsRequest_FeedbackLabelType.Descriptor instead.
func (BulkDownloadFeedbackLabelsRequest_FeedbackLabelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{116, 0}
}

// All permissible file formats.
// See `records_per_file_count` to override the default number of records
// per file.
type BulkDownloadFeedbackLabelsRequest_GcsDestination_Format int32

const (
	// Unspecified format.
	BulkDownloadFeedbackLabelsRequest_GcsDestination_FORMAT_UNSPECIFIED BulkDownloadFeedbackLabelsRequest_GcsDestination_Format = 0
	// CSV format.
	// 1,000 labels are stored per CSV file by default.
	BulkDownloadFeedbackLabelsRequest_GcsDestination_CSV BulkDownloadFeedbackLabelsRequest_GcsDestination_Format = 1
	// JSON format.
	// 1 label stored per JSON file by default.
	BulkDownloadFeedbackLabelsRequest_GcsDestination_JSON BulkDownloadFeedbackLabelsRequest_GcsDestination_Format = 2
)

// Enum value maps for BulkDownloadFeedbackLabelsRequest_GcsDestination_Format.
var (
	BulkDownloadFeedbackLabelsRequest_GcsDestination_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "CSV",
		2: "JSON",
	}
	BulkDownloadFeedbackLabelsRequest_GcsDestination_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"CSV":                1,
		"JSON":               2,
	}
)

func (x BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) Enum() *BulkDownloadFeedbackLabelsRequest_GcsDestination_Format {
	p := new(BulkDownloadFeedbackLabelsRequest_GcsDestination_Format)
	*p = x
	return p
}

func (x BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[7].Descriptor()
}

func (BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes[7]
}

func (x BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsRequest_GcsDestination_Format.Descriptor instead.
func (BulkDownloadFeedbackLabelsRequest_GcsDestination_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{116, 0, 0}
}

// The request for calculating conversation statistics.
type CalculateStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the conversations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// A filter to reduce results to a specific subset. This field is useful for
	// getting statistics about conversations with specific properties.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *CalculateStatsRequest) Reset() {
	*x = CalculateStatsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsRequest) ProtoMessage() {}

func (x *CalculateStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{0}
}

func (x *CalculateStatsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CalculateStatsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for calculating conversation statistics.
type CalculateStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The average duration of all conversations. The average is calculated using
	// only conversations that have a time duration.
	AverageDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=average_duration,json=averageDuration,proto3" json:"average_duration,omitempty"`
	// The average number of turns per conversation.
	AverageTurnCount int32 `protobuf:"varint,2,opt,name=average_turn_count,json=averageTurnCount,proto3" json:"average_turn_count,omitempty"`
	// The total number of conversations.
	ConversationCount int32 `protobuf:"varint,3,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
	// A map associating each smart highlighter display name with its respective
	// number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int32 `protobuf:"bytes,4,rep,name=smart_highlighter_matches,json=smartHighlighterMatches,proto3" json:"smart_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each custom highlighter resource name with its respective
	// number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int32 `protobuf:"bytes,5,rep,name=custom_highlighter_matches,json=customHighlighterMatches,proto3" json:"custom_highlighter_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each issue resource name with its respective number of
	// matches in the set of conversations. Key has the format:
	// `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
	// Deprecated, use `issue_matches_stats` field instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/contactcenterinsights/v1/contact_center_insights.proto.
	IssueMatches map[string]int32 `protobuf:"bytes,6,rep,name=issue_matches,json=issueMatches,proto3" json:"issue_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map associating each issue resource name with its respective number of
	// matches in the set of conversations. Key has the format:
	// `projects/<Project-ID>/locations/<Location-ID>/issueModels/<Issue-Model-ID>/issues/<Issue-ID>`
	IssueMatchesStats map[string]*IssueModelLabelStats_IssueStats `protobuf:"bytes,8,rep,name=issue_matches_stats,json=issueMatchesStats,proto3" json:"issue_matches_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A time series representing the count of conversations created over time
	// that match that requested filter criteria.
	ConversationCountTimeSeries *CalculateStatsResponse_TimeSeries `protobuf:"bytes,7,opt,name=conversation_count_time_series,json=conversationCountTimeSeries,proto3" json:"conversation_count_time_series,omitempty"`
}

func (x *CalculateStatsResponse) Reset() {
	*x = CalculateStatsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse) ProtoMessage() {}

func (x *CalculateStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1}
}

func (x *CalculateStatsResponse) GetAverageDuration() *durationpb.Duration {
	if x != nil {
		return x.AverageDuration
	}
	return nil
}

func (x *CalculateStatsResponse) GetAverageTurnCount() int32 {
	if x != nil {
		return x.AverageTurnCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

func (x *CalculateStatsResponse) GetSmartHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.SmartHighlighterMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetCustomHighlighterMatches() map[string]int32 {
	if x != nil {
		return x.CustomHighlighterMatches
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/contactcenterinsights/v1/contact_center_insights.proto.
func (x *CalculateStatsResponse) GetIssueMatches() map[string]int32 {
	if x != nil {
		return x.IssueMatches
	}
	return nil
}

func (x *CalculateStatsResponse) GetIssueMatchesStats() map[string]*IssueModelLabelStats_IssueStats {
	if x != nil {
		return x.IssueMatchesStats
	}
	return nil
}

func (x *CalculateStatsResponse) GetConversationCountTimeSeries() *CalculateStatsResponse_TimeSeries {
	if x != nil {
		return x.ConversationCountTimeSeries
	}
	return nil
}

// Metadata for a create analysis operation.
type CreateAnalysisOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The Conversation that this Analysis Operation belongs to.
	Conversation string `protobuf:"bytes,3,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Output only. The annotator selector used for the analysis (if any).
	AnnotatorSelector *AnnotatorSelector `protobuf:"bytes,4,opt,name=annotator_selector,json=annotatorSelector,proto3" json:"annotator_selector,omitempty"`
}

func (x *CreateAnalysisOperationMetadata) Reset() {
	*x = CreateAnalysisOperationMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAnalysisOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisOperationMetadata) ProtoMessage() {}

func (x *CreateAnalysisOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateAnalysisOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{2}
}

func (x *CreateAnalysisOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateAnalysisOperationMetadata) GetConversation() string {
	if x != nil {
		return x.Conversation
	}
	return ""
}

func (x *CreateAnalysisOperationMetadata) GetAnnotatorSelector() *AnnotatorSelector {
	if x != nil {
		return x.AnnotatorSelector
	}
	return nil
}

// Request to create a conversation.
type CreateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation resource to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// A unique ID for the new conversation. This ID will become the final
	// component of the conversation's resource name. If no ID is specified, a
	// server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
}

func (x *CreateConversationRequest) Reset() {
	*x = CreateConversationRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationRequest) ProtoMessage() {}

func (x *CreateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{3}
}

func (x *CreateConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *CreateConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

// Request to upload a conversation.
type UploadConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation resource to create.
	Conversation *Conversation `protobuf:"bytes,2,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// Optional. A unique ID for the new conversation. This ID will become the
	// final component of the conversation's resource name. If no ID is specified,
	// a server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
	ConversationId string `protobuf:"bytes,3,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
	// Optional. DLP settings for transcript redaction. Will default to the config
	// specified in Settings.
	RedactionConfig *RedactionConfig `protobuf:"bytes,4,opt,name=redaction_config,json=redactionConfig,proto3" json:"redaction_config,omitempty"`
	// Optional. Speech-to-Text configuration. Will default to the config
	// specified in Settings.
	SpeechConfig *SpeechConfig `protobuf:"bytes,11,opt,name=speech_config,json=speechConfig,proto3" json:"speech_config,omitempty"`
}

func (x *UploadConversationRequest) Reset() {
	*x = UploadConversationRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadConversationRequest) ProtoMessage() {}

func (x *UploadConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadConversationRequest.ProtoReflect.Descriptor instead.
func (*UploadConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{4}
}

func (x *UploadConversationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UploadConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *UploadConversationRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

func (x *UploadConversationRequest) GetRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.RedactionConfig
	}
	return nil
}

func (x *UploadConversationRequest) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

// The metadata for an `UploadConversation` operation.
type UploadConversationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request.
	Request *UploadConversationRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. The operation name for a successfully created analysis
	// operation, if any.
	AnalysisOperation string `protobuf:"bytes,4,opt,name=analysis_operation,json=analysisOperation,proto3" json:"analysis_operation,omitempty"`
	// Output only. The redaction config applied to the uploaded conversation.
	AppliedRedactionConfig *RedactionConfig `protobuf:"bytes,5,opt,name=applied_redaction_config,json=appliedRedactionConfig,proto3" json:"applied_redaction_config,omitempty"`
}

func (x *UploadConversationMetadata) Reset() {
	*x = UploadConversationMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadConversationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadConversationMetadata) ProtoMessage() {}

func (x *UploadConversationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadConversationMetadata.ProtoReflect.Descriptor instead.
func (*UploadConversationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{5}
}

func (x *UploadConversationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UploadConversationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UploadConversationMetadata) GetRequest() *UploadConversationRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *UploadConversationMetadata) GetAnalysisOperation() string {
	if x != nil {
		return x.AnalysisOperation
	}
	return ""
}

func (x *UploadConversationMetadata) GetAppliedRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.AppliedRedactionConfig
	}
	return nil
}

// Request to list conversations.
type ListConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the conversation.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of conversations to return in the response. A valid page
	// size ranges from 0 to 100,000 inclusive. If the page size is zero or
	// unspecified, a default page size of 100 will be chosen. Note that a call
	// might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListConversationsResponse`. This value
	// indicates that this is a continuation of a prior `ListConversations` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The attribute by which to order conversations in the response.
	// If empty, conversations will be ordered by descending creation time.
	// Supported values are one of the following:
	//
	// * create_time
	// * customer_satisfaction_rating
	// * duration
	// * latest_analysis
	// * start_time
	// * turn_count
	//
	// The default sort order is ascending. To specify order, append `asc` or
	// `desc` (`create_time desc`).
	// For more details, see [Google AIPs
	// Ordering](https://google.aip.dev/132#ordering).
	OrderBy string `protobuf:"bytes,7,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The level of details of the conversation. Default is `BASIC`.
	View ConversationView `protobuf:"varint,5,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *ListConversationsRequest) Reset() {
	*x = ListConversationsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsRequest) ProtoMessage() {}

func (x *ListConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{6}
}

func (x *ListConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConversationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListConversationsRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The response of listing conversations.
type ListConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversations that match the request.
	Conversations []*Conversation `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page. If
	// this field is set, it means there is another page available. If it is not
	// set, it means no other pages are available.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationsResponse) Reset() {
	*x = ListConversationsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsResponse) ProtoMessage() {}

func (x *ListConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{7}
}

func (x *ListConversationsResponse) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

func (x *ListConversationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a conversation.
type GetConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The level of details of the conversation. Default is `FULL`.
	View ConversationView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationView" json:"view,omitempty"`
}

func (x *GetConversationRequest) Reset() {
	*x = GetConversationRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationRequest) ProtoMessage() {}

func (x *GetConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{8}
}

func (x *GetConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetConversationRequest) GetView() ConversationView {
	if x != nil {
		return x.View
	}
	return ConversationView_CONVERSATION_VIEW_UNSPECIFIED
}

// The request to update a conversation.
type UpdateConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the conversation.
	Conversation *Conversation `protobuf:"bytes,1,opt,name=conversation,proto3" json:"conversation,omitempty"`
	// The list of fields to be updated. All possible fields can be updated by
	// passing `*`, or a subset of the following updateable fields can be
	// provided:
	//
	// * `agent_id`
	// * `language_code`
	// * `labels`
	// * `metadata`
	// * `quality_metadata`
	// * `call_metadata`
	// * `start_time`
	// * `expire_time` or `ttl`
	// * `data_source.gcs_source.audio_uri` or
	// `data_source.dialogflow_source.audio_uri`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversationRequest) Reset() {
	*x = UpdateConversationRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversationRequest) ProtoMessage() {}

func (x *UpdateConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversationRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateConversationRequest) GetConversation() *Conversation {
	if x != nil {
		return x.Conversation
	}
	return nil
}

func (x *UpdateConversationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a conversation.
type DeleteConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, all of this conversation's analyses will also be deleted.
	// Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConversationRequest) Reset() {
	*x = DeleteConversationRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationRequest) ProtoMessage() {}

func (x *DeleteConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConversationRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request to ingest conversations.
type IngestConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for an external data store containing objects that will
	// be converted to conversations.
	//
	// Types that are assignable to Source:
	//
	//	*IngestConversationsRequest_GcsSource_
	Source isIngestConversationsRequest_Source `protobuf_oneof:"source"`
	// Configuration for converting individual `source` objects to conversations.
	//
	// Types that are assignable to ObjectConfig:
	//
	//	*IngestConversationsRequest_TranscriptObjectConfig_
	ObjectConfig isIngestConversationsRequest_ObjectConfig `protobuf_oneof:"object_config"`
	// Required. The parent resource for new conversations.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration that applies to all conversations.
	ConversationConfig *IngestConversationsRequest_ConversationConfig `protobuf:"bytes,4,opt,name=conversation_config,json=conversationConfig,proto3" json:"conversation_config,omitempty"`
	// Optional. DLP settings for transcript redaction. Optional, will default to
	// the config specified in Settings.
	RedactionConfig *RedactionConfig `protobuf:"bytes,5,opt,name=redaction_config,json=redactionConfig,proto3" json:"redaction_config,omitempty"`
	// Optional. Default Speech-to-Text configuration. Optional, will default to
	// the config specified in Settings.
	SpeechConfig *SpeechConfig `protobuf:"bytes,6,opt,name=speech_config,json=speechConfig,proto3" json:"speech_config,omitempty"`
	// Optional. If set, this fields indicates the number of objects to ingest
	// from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize *int32 `protobuf:"varint,7,opt,name=sample_size,json=sampleSize,proto3,oneof" json:"sample_size,omitempty"`
}

func (x *IngestConversationsRequest) Reset() {
	*x = IngestConversationsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest) ProtoMessage() {}

func (x *IngestConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11}
}

func (m *IngestConversationsRequest) GetSource() isIngestConversationsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *IngestConversationsRequest) GetGcsSource() *IngestConversationsRequest_GcsSource {
	if x, ok := x.GetSource().(*IngestConversationsRequest_GcsSource_); ok {
		return x.GcsSource
	}
	return nil
}

func (m *IngestConversationsRequest) GetObjectConfig() isIngestConversationsRequest_ObjectConfig {
	if m != nil {
		return m.ObjectConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetTranscriptObjectConfig() *IngestConversationsRequest_TranscriptObjectConfig {
	if x, ok := x.GetObjectConfig().(*IngestConversationsRequest_TranscriptObjectConfig_); ok {
		return x.TranscriptObjectConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *IngestConversationsRequest) GetConversationConfig() *IngestConversationsRequest_ConversationConfig {
	if x != nil {
		return x.ConversationConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetRedactionConfig() *RedactionConfig {
	if x != nil {
		return x.RedactionConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

func (x *IngestConversationsRequest) GetSampleSize() int32 {
	if x != nil && x.SampleSize != nil {
		return *x.SampleSize
	}
	return 0
}

type isIngestConversationsRequest_Source interface {
	isIngestConversationsRequest_Source()
}

type IngestConversationsRequest_GcsSource_ struct {
	// A cloud storage bucket source. Note that any previously ingested objects
	// from the source will be skipped to avoid duplication.
	GcsSource *IngestConversationsRequest_GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*IngestConversationsRequest_GcsSource_) isIngestConversationsRequest_Source() {}

type isIngestConversationsRequest_ObjectConfig interface {
	isIngestConversationsRequest_ObjectConfig()
}

type IngestConversationsRequest_TranscriptObjectConfig_ struct {
	// Configuration for when `source` contains conversation transcripts.
	TranscriptObjectConfig *IngestConversationsRequest_TranscriptObjectConfig `protobuf:"bytes,3,opt,name=transcript_object_config,json=transcriptObjectConfig,proto3,oneof"`
}

func (*IngestConversationsRequest_TranscriptObjectConfig_) isIngestConversationsRequest_ObjectConfig() {
}

// The metadata for an IngestConversations operation.
type IngestConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request for ingest.
	Request *IngestConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
	// Output only. Statistics for IngestConversations operation.
	IngestConversationsStats *IngestConversationsMetadata_IngestConversationsStats `protobuf:"bytes,5,opt,name=ingest_conversations_stats,json=ingestConversationsStats,proto3" json:"ingest_conversations_stats,omitempty"`
}

func (x *IngestConversationsMetadata) Reset() {
	*x = IngestConversationsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsMetadata) ProtoMessage() {}

func (x *IngestConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsMetadata.ProtoReflect.Descriptor instead.
func (*IngestConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{12}
}

func (x *IngestConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IngestConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *IngestConversationsMetadata) GetRequest() *IngestConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *IngestConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

func (x *IngestConversationsMetadata) GetIngestConversationsStats() *IngestConversationsMetadata_IngestConversationsStats {
	if x != nil {
		return x.IngestConversationsStats
	}
	return nil
}

// The response to an IngestConversations operation.
type IngestConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IngestConversationsResponse) Reset() {
	*x = IngestConversationsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsResponse) ProtoMessage() {}

func (x *IngestConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsResponse.ProtoReflect.Descriptor instead.
func (*IngestConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{13}
}

// The request to create an analysis.
type CreateAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analysis.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The analysis to create.
	Analysis *Analysis `protobuf:"bytes,2,opt,name=analysis,proto3" json:"analysis,omitempty"`
}

func (x *CreateAnalysisRequest) Reset() {
	*x = CreateAnalysisRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisRequest) ProtoMessage() {}

func (x *CreateAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisRequest.ProtoReflect.Descriptor instead.
func (*CreateAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{14}
}

func (x *CreateAnalysisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnalysisRequest) GetAnalysis() *Analysis {
	if x != nil {
		return x.Analysis
	}
	return nil
}

// The request to list analyses.
type ListAnalysesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analyses.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of analyses to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListAnalysesResponse`; indicates
	// that this is a continuation of a prior `ListAnalyses` call and
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// conversations with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAnalysesRequest) Reset() {
	*x = ListAnalysesRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnalysesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesRequest) ProtoMessage() {}

func (x *ListAnalysesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesRequest.ProtoReflect.Descriptor instead.
func (*ListAnalysesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{15}
}

func (x *ListAnalysesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnalysesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnalysesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnalysesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response to list analyses.
type ListAnalysesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analyses that match the request.
	Analyses []*Analysis `protobuf:"bytes,1,rep,name=analyses,proto3" json:"analyses,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnalysesResponse) Reset() {
	*x = ListAnalysesResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnalysesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesResponse) ProtoMessage() {}

func (x *ListAnalysesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesResponse.ProtoReflect.Descriptor instead.
func (*ListAnalysesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{16}
}

func (x *ListAnalysesResponse) GetAnalyses() []*Analysis {
	if x != nil {
		return x.Analyses
	}
	return nil
}

func (x *ListAnalysesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get an analysis.
type GetAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnalysisRequest) Reset() {
	*x = GetAnalysisRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnalysisRequest) ProtoMessage() {}

func (x *GetAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnalysisRequest.ProtoReflect.Descriptor instead.
func (*GetAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{17}
}

func (x *GetAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an analysis.
type DeleteAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnalysisRequest) Reset() {
	*x = DeleteAnalysisRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnalysisRequest) ProtoMessage() {}

func (x *DeleteAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnalysisRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to analyze conversations in bulk.
type BulkAnalyzeConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to create analyses in.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Filter used to select the subset of conversations to analyze.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Percentage of selected conversation to analyze, between
	// [0, 100].
	AnalysisPercentage float32 `protobuf:"fixed32,3,opt,name=analysis_percentage,json=analysisPercentage,proto3" json:"analysis_percentage,omitempty"`
	// To select the annotators to run and the phrase matchers to use
	// (if any). If not specified, all annotators will be run.
	AnnotatorSelector *AnnotatorSelector `protobuf:"bytes,8,opt,name=annotator_selector,json=annotatorSelector,proto3" json:"annotator_selector,omitempty"`
}

func (x *BulkAnalyzeConversationsRequest) Reset() {
	*x = BulkAnalyzeConversationsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkAnalyzeConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsRequest) ProtoMessage() {}

func (x *BulkAnalyzeConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsRequest.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{19}
}

func (x *BulkAnalyzeConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkAnalyzeConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *BulkAnalyzeConversationsRequest) GetAnalysisPercentage() float32 {
	if x != nil {
		return x.AnalysisPercentage
	}
	return 0
}

func (x *BulkAnalyzeConversationsRequest) GetAnnotatorSelector() *AnnotatorSelector {
	if x != nil {
		return x.AnnotatorSelector
	}
	return nil
}

// The metadata for a bulk analyze conversations operation.
type BulkAnalyzeConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for bulk analyze.
	Request *BulkAnalyzeConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// The number of requested analyses that have completed successfully so far.
	CompletedAnalysesCount int32 `protobuf:"varint,4,opt,name=completed_analyses_count,json=completedAnalysesCount,proto3" json:"completed_analyses_count,omitempty"`
	// The number of requested analyses that have failed so far.
	FailedAnalysesCount int32 `protobuf:"varint,5,opt,name=failed_analyses_count,json=failedAnalysesCount,proto3" json:"failed_analyses_count,omitempty"`
	// Total number of analyses requested. Computed by the number of conversations
	// returned by `filter` multiplied by `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int32 `protobuf:"varint,6,opt,name=total_requested_analyses_count,json=totalRequestedAnalysesCount,proto3" json:"total_requested_analyses_count,omitempty"`
	// Output only. Partial errors during bulk analyze operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,7,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *BulkAnalyzeConversationsMetadata) Reset() {
	*x = BulkAnalyzeConversationsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkAnalyzeConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsMetadata) ProtoMessage() {}

func (x *BulkAnalyzeConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsMetadata.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{20}
}

func (x *BulkAnalyzeConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetRequest() *BulkAnalyzeConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkAnalyzeConversationsMetadata) GetCompletedAnalysesCount() int32 {
	if x != nil {
		return x.CompletedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetFailedAnalysesCount() int32 {
	if x != nil {
		return x.FailedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetTotalRequestedAnalysesCount() int32 {
	if x != nil {
		return x.TotalRequestedAnalysesCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// The response for a bulk analyze conversations operation.
type BulkAnalyzeConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of successful analyses.
	SuccessfulAnalysisCount int32 `protobuf:"varint,1,opt,name=successful_analysis_count,json=successfulAnalysisCount,proto3" json:"successful_analysis_count,omitempty"`
	// Count of failed analyses.
	FailedAnalysisCount int32 `protobuf:"varint,2,opt,name=failed_analysis_count,json=failedAnalysisCount,proto3" json:"failed_analysis_count,omitempty"`
}

func (x *BulkAnalyzeConversationsResponse) Reset() {
	*x = BulkAnalyzeConversationsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkAnalyzeConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkAnalyzeConversationsResponse) ProtoMessage() {}

func (x *BulkAnalyzeConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkAnalyzeConversationsResponse.ProtoReflect.Descriptor instead.
func (*BulkAnalyzeConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{21}
}

func (x *BulkAnalyzeConversationsResponse) GetSuccessfulAnalysisCount() int32 {
	if x != nil {
		return x.SuccessfulAnalysisCount
	}
	return 0
}

func (x *BulkAnalyzeConversationsResponse) GetFailedAnalysisCount() int32 {
	if x != nil {
		return x.FailedAnalysisCount
	}
	return 0
}

// The request to delete conversations in bulk.
type BulkDeleteConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to delete conversations from.
	// Format:
	// projects/{project}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filter used to select the subset of conversations to delete.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Maximum number of conversations to delete.
	MaxDeleteCount int32 `protobuf:"varint,3,opt,name=max_delete_count,json=maxDeleteCount,proto3" json:"max_delete_count,omitempty"`
	// If set to true, all of this conversation's analyses will also be deleted.
	// Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *BulkDeleteConversationsRequest) Reset() {
	*x = BulkDeleteConversationsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDeleteConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsRequest) ProtoMessage() {}

func (x *BulkDeleteConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsRequest.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{22}
}

func (x *BulkDeleteConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkDeleteConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *BulkDeleteConversationsRequest) GetMaxDeleteCount() int32 {
	if x != nil {
		return x.MaxDeleteCount
	}
	return 0
}

func (x *BulkDeleteConversationsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The metadata for a bulk delete conversations operation.
type BulkDeleteConversationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for bulk delete.
	Request *BulkDeleteConversationsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during bulk delete conversations operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *BulkDeleteConversationsMetadata) Reset() {
	*x = BulkDeleteConversationsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDeleteConversationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsMetadata) ProtoMessage() {}

func (x *BulkDeleteConversationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsMetadata.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{23}
}

func (x *BulkDeleteConversationsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetRequest() *BulkDeleteConversationsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkDeleteConversationsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// The response for a bulk delete conversations operation.
type BulkDeleteConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkDeleteConversationsResponse) Reset() {
	*x = BulkDeleteConversationsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDeleteConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteConversationsResponse) ProtoMessage() {}

func (x *BulkDeleteConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteConversationsResponse.ProtoReflect.Descriptor instead.
func (*BulkDeleteConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{24}
}

// The request to export insights.
type ExportInsightsDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exporter destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportInsightsDataRequest_BigQueryDestination_
	Destination isExportInsightsDataRequest_Destination `protobuf_oneof:"destination"`
	// Required. The parent resource to export data from.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter to reduce results to a specific subset. Useful for exporting
	// conversations with specific properties.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// A fully qualified KMS key name for BigQuery tables protected by CMEK.
	// Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
	KmsKey string `protobuf:"bytes,4,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Options for what to do if the destination table already exists.
	WriteDisposition ExportInsightsDataRequest_WriteDisposition `protobuf:"varint,5,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest_WriteDisposition" json:"write_disposition,omitempty"`
}

func (x *ExportInsightsDataRequest) Reset() {
	*x = ExportInsightsDataRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportInsightsDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest) ProtoMessage() {}

func (x *ExportInsightsDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25}
}

func (m *ExportInsightsDataRequest) GetDestination() isExportInsightsDataRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetBigQueryDestination() *ExportInsightsDataRequest_BigQueryDestination {
	if x, ok := x.GetDestination().(*ExportInsightsDataRequest_BigQueryDestination_); ok {
		return x.BigQueryDestination
	}
	return nil
}

func (x *ExportInsightsDataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *ExportInsightsDataRequest) GetWriteDisposition() ExportInsightsDataRequest_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return ExportInsightsDataRequest_WRITE_DISPOSITION_UNSPECIFIED
}

type isExportInsightsDataRequest_Destination interface {
	isExportInsightsDataRequest_Destination()
}

type ExportInsightsDataRequest_BigQueryDestination_ struct {
	// Specified if sink is a BigQuery table.
	BigQueryDestination *ExportInsightsDataRequest_BigQueryDestination `protobuf:"bytes,2,opt,name=big_query_destination,json=bigQueryDestination,proto3,oneof"`
}

func (*ExportInsightsDataRequest_BigQueryDestination_) isExportInsightsDataRequest_Destination() {}

// Metadata for an export insights operation.
type ExportInsightsDataMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for export.
	Request *ExportInsightsDataRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during export operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *ExportInsightsDataMetadata) Reset() {
	*x = ExportInsightsDataMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportInsightsDataMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataMetadata) ProtoMessage() {}

func (x *ExportInsightsDataMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataMetadata.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{26}
}

func (x *ExportInsightsDataMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetRequest() *ExportInsightsDataRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *ExportInsightsDataMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// Response for an export insights operation.
type ExportInsightsDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportInsightsDataResponse) Reset() {
	*x = ExportInsightsDataResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportInsightsDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataResponse) ProtoMessage() {}

func (x *ExportInsightsDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataResponse.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{27}
}

// The request to create an issue model.
type CreateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The issue model to create.
	IssueModel *IssueModel `protobuf:"bytes,2,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CreateIssueModelRequest) Reset() {
	*x = CreateIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelRequest) ProtoMessage() {}

func (x *CreateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*CreateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{28}
}

func (x *CreateIssueModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

// Metadata for creating an issue model.
type CreateIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for creation.
	Request *CreateIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *CreateIssueModelMetadata) Reset() {
	*x = CreateIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIssueModelMetadata) ProtoMessage() {}

func (x *CreateIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*CreateIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{29}
}

func (x *CreateIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateIssueModelMetadata) GetRequest() *CreateIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to update an issue model.
type UpdateIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue model.
	IssueModel *IssueModel `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueModelRequest) Reset() {
	*x = UpdateIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueModelRequest) ProtoMessage() {}

func (x *UpdateIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateIssueModelRequest) GetIssueModel() *IssueModel {
	if x != nil {
		return x.IssueModel
	}
	return nil
}

func (x *UpdateIssueModelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list issue models.
type ListIssueModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssueModelsRequest) Reset() {
	*x = ListIssueModelsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIssueModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsRequest) ProtoMessage() {}

func (x *ListIssueModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsRequest.ProtoReflect.Descriptor instead.
func (*ListIssueModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{31}
}

func (x *ListIssueModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issue models.
type ListIssueModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issue models that match the request.
	IssueModels []*IssueModel `protobuf:"bytes,1,rep,name=issue_models,json=issueModels,proto3" json:"issue_models,omitempty"`
}

func (x *ListIssueModelsResponse) Reset() {
	*x = ListIssueModelsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIssueModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssueModelsResponse) ProtoMessage() {}

func (x *ListIssueModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssueModelsResponse.ProtoReflect.Descriptor instead.
func (*ListIssueModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{32}
}

func (x *ListIssueModelsResponse) GetIssueModels() []*IssueModel {
	if x != nil {
		return x.IssueModels
	}
	return nil
}

// The request to get an issue model.
type GetIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueModelRequest) Reset() {
	*x = GetIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueModelRequest) ProtoMessage() {}

func (x *GetIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueModelRequest.ProtoReflect.Descriptor instead.
func (*GetIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{33}
}

func (x *GetIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete an issue model.
type DeleteIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue model to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIssueModelRequest) Reset() {
	*x = DeleteIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelRequest) ProtoMessage() {}

func (x *DeleteIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata for deleting an issue model.
type DeleteIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deletion.
	Request *DeleteIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeleteIssueModelMetadata) Reset() {
	*x = DeleteIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueModelMetadata) ProtoMessage() {}

func (x *DeleteIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeleteIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeleteIssueModelMetadata) GetRequest() *DeleteIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to deploy an issue model.
type DeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to deploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployIssueModelRequest) Reset() {
	*x = DeployIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelRequest) ProtoMessage() {}

func (x *DeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*DeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{36}
}

func (x *DeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to deploy an issue model.
type DeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployIssueModelResponse) Reset() {
	*x = DeployIssueModelResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelResponse) ProtoMessage() {}

func (x *DeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*DeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{37}
}

// Metadata for deploying an issue model.
type DeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for deployment.
	Request *DeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *DeployIssueModelMetadata) Reset() {
	*x = DeployIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIssueModelMetadata) ProtoMessage() {}

func (x *DeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*DeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{38}
}

func (x *DeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DeployIssueModelMetadata) GetRequest() *DeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to undeploy an issue model.
type UndeployIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The issue model to undeploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployIssueModelRequest) Reset() {
	*x = UndeployIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeployIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelRequest) ProtoMessage() {}

func (x *UndeployIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelRequest.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{39}
}

func (x *UndeployIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response to undeploy an issue model.
type UndeployIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployIssueModelResponse) Reset() {
	*x = UndeployIssueModelResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeployIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelResponse) ProtoMessage() {}

func (x *UndeployIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelResponse.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{40}
}

// Metadata for undeploying an issue model.
type UndeployIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original request for undeployment.
	Request *UndeployIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *UndeployIssueModelMetadata) Reset() {
	*x = UndeployIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeployIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIssueModelMetadata) ProtoMessage() {}

func (x *UndeployIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*UndeployIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{41}
}

func (x *UndeployIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UndeployIssueModelMetadata) GetRequest() *UndeployIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// Request to export an issue model.
type ExportIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//
	//	*ExportIssueModelRequest_GcsDestination_
	Destination isExportIssueModelRequest_Destination `protobuf_oneof:"Destination"`
	// Required. The issue model to export.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ExportIssueModelRequest) Reset() {
	*x = ExportIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIssueModelRequest) ProtoMessage() {}

func (x *ExportIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIssueModelRequest.ProtoReflect.Descriptor instead.
func (*ExportIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{42}
}

func (m *ExportIssueModelRequest) GetDestination() isExportIssueModelRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportIssueModelRequest) GetGcsDestination() *ExportIssueModelRequest_GcsDestination {
	if x, ok := x.GetDestination().(*ExportIssueModelRequest_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *ExportIssueModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isExportIssueModelRequest_Destination interface {
	isExportIssueModelRequest_Destination()
}

type ExportIssueModelRequest_GcsDestination_ struct {
	// Google Cloud Storage URI to export the issue model to.
	GcsDestination *ExportIssueModelRequest_GcsDestination `protobuf:"bytes,2,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*ExportIssueModelRequest_GcsDestination_) isExportIssueModelRequest_Destination() {}

// Response from export issue model
type ExportIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportIssueModelResponse) Reset() {
	*x = ExportIssueModelResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIssueModelResponse) ProtoMessage() {}

func (x *ExportIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIssueModelResponse.ProtoReflect.Descriptor instead.
func (*ExportIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{43}
}

// Metadata used for export issue model.
type ExportIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original export request.
	Request *ExportIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *ExportIssueModelMetadata) Reset() {
	*x = ExportIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIssueModelMetadata) ProtoMessage() {}

func (x *ExportIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*ExportIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{44}
}

func (x *ExportIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportIssueModelMetadata) GetRequest() *ExportIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// Request to import an issue model.
type ImportIssueModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*ImportIssueModelRequest_GcsSource_
	Source isImportIssueModelRequest_Source `protobuf_oneof:"Source"`
	// Required. The parent resource of the issue model.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set to true, will create an issue model from the imported file
	// with randomly generated IDs for the issue model and corresponding issues.
	// Otherwise, replaces an existing model with the same ID as the file.
	CreateNewModel bool `protobuf:"varint,3,opt,name=create_new_model,json=createNewModel,proto3" json:"create_new_model,omitempty"`
}

func (x *ImportIssueModelRequest) Reset() {
	*x = ImportIssueModelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportIssueModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIssueModelRequest) ProtoMessage() {}

func (x *ImportIssueModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIssueModelRequest.ProtoReflect.Descriptor instead.
func (*ImportIssueModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{45}
}

func (m *ImportIssueModelRequest) GetSource() isImportIssueModelRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportIssueModelRequest) GetGcsSource() *ImportIssueModelRequest_GcsSource {
	if x, ok := x.GetSource().(*ImportIssueModelRequest_GcsSource_); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportIssueModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportIssueModelRequest) GetCreateNewModel() bool {
	if x != nil {
		return x.CreateNewModel
	}
	return false
}

type isImportIssueModelRequest_Source interface {
	isImportIssueModelRequest_Source()
}

type ImportIssueModelRequest_GcsSource_ struct {
	// Google Cloud Storage source message.
	GcsSource *ImportIssueModelRequest_GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ImportIssueModelRequest_GcsSource_) isImportIssueModelRequest_Source() {}

// Response from import issue model
type ImportIssueModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportIssueModelResponse) Reset() {
	*x = ImportIssueModelResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportIssueModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIssueModelResponse) ProtoMessage() {}

func (x *ImportIssueModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIssueModelResponse.ProtoReflect.Descriptor instead.
func (*ImportIssueModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{46}
}

// Metadata used for import issue model.
type ImportIssueModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The original import request.
	Request *ImportIssueModelRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *ImportIssueModelMetadata) Reset() {
	*x = ImportIssueModelMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportIssueModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIssueModelMetadata) ProtoMessage() {}

func (x *ImportIssueModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIssueModelMetadata.ProtoReflect.Descriptor instead.
func (*ImportIssueModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{47}
}

func (x *ImportIssueModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportIssueModelMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ImportIssueModelMetadata) GetRequest() *ImportIssueModelRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// The request to get an issue.
type GetIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIssueRequest) Reset() {
	*x = GetIssueRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIssueRequest) ProtoMessage() {}

func (x *GetIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIssueRequest.ProtoReflect.Descriptor instead.
func (*GetIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{48}
}

func (x *GetIssueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list issues.
type ListIssuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the issue.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListIssuesRequest) Reset() {
	*x = ListIssuesRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIssuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesRequest) ProtoMessage() {}

func (x *ListIssuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesRequest.ProtoReflect.Descriptor instead.
func (*ListIssuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{49}
}

func (x *ListIssuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response of listing issues.
type ListIssuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issues that match the request.
	Issues []*Issue `protobuf:"bytes,1,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (x *ListIssuesResponse) Reset() {
	*x = ListIssuesResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListIssuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIssuesResponse) ProtoMessage() {}

func (x *ListIssuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIssuesResponse.ProtoReflect.Descriptor instead.
func (*ListIssuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{50}
}

func (x *ListIssuesResponse) GetIssues() []*Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

// The request to update an issue.
type UpdateIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the issue.
	Issue *Issue `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIssueRequest) Reset() {
	*x = UpdateIssueRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIssueRequest) ProtoMessage() {}

func (x *UpdateIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIssueRequest.ProtoReflect.Descriptor instead.
func (*UpdateIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{51}
}

func (x *UpdateIssueRequest) GetIssue() *Issue {
	if x != nil {
		return x.Issue
	}
	return nil
}

func (x *UpdateIssueRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete an issue.
type DeleteIssueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the issue to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIssueRequest) Reset() {
	*x = DeleteIssueRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteIssueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIssueRequest) ProtoMessage() {}

func (x *DeleteIssueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIssueRequest.ProtoReflect.Descriptor instead.
func (*DeleteIssueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{52}
}

func (x *DeleteIssueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get statistics of an issue model.
type CalculateIssueModelStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the issue model to query against.
	IssueModel string `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
}

func (x *CalculateIssueModelStatsRequest) Reset() {
	*x = CalculateIssueModelStatsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateIssueModelStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsRequest) ProtoMessage() {}

func (x *CalculateIssueModelStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsRequest.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{53}
}

func (x *CalculateIssueModelStatsRequest) GetIssueModel() string {
	if x != nil {
		return x.IssueModel
	}
	return ""
}

// Response of querying an issue model's statistics.
type CalculateIssueModelStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The latest label statistics for the queried issue model. Includes results
	// on both training data and data labeled after deployment.
	CurrentStats *IssueModelLabelStats `protobuf:"bytes,4,opt,name=current_stats,json=currentStats,proto3" json:"current_stats,omitempty"`
}

func (x *CalculateIssueModelStatsResponse) Reset() {
	*x = CalculateIssueModelStatsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateIssueModelStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateIssueModelStatsResponse) ProtoMessage() {}

func (x *CalculateIssueModelStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateIssueModelStatsResponse.ProtoReflect.Descriptor instead.
func (*CalculateIssueModelStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{54}
}

func (x *CalculateIssueModelStatsResponse) GetCurrentStats() *IssueModelLabelStats {
	if x != nil {
		return x.CurrentStats
	}
	return nil
}

// Request to create a phrase matcher.
type CreatePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher. Required. The location
	// to create a phrase matcher for. Format: `projects/<Project
	// ID>/locations/<Location ID>` or `projects/<Project
	// Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The phrase matcher resource to create.
	PhraseMatcher *PhraseMatcher `protobuf:"bytes,2,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
}

func (x *CreatePhraseMatcherRequest) Reset() {
	*x = CreatePhraseMatcherRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhraseMatcherRequest) ProtoMessage() {}

func (x *CreatePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*CreatePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{55}
}

func (x *CreatePhraseMatcherRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePhraseMatcherRequest) GetPhraseMatcher() *PhraseMatcher {
	if x != nil {
		return x.PhraseMatcher
	}
	return nil
}

// Request to list phrase matchers.
type ListPhraseMatchersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the phrase matcher.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of phrase matchers to return in the response. If this
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListPhraseMatchersResponse`. This value
	// indicates that this is a continuation of a prior `ListPhraseMatchers` call
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter to reduce results to a specific subset. Useful for querying
	// phrase matchers with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPhraseMatchersRequest) Reset() {
	*x = ListPhraseMatchersRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPhraseMatchersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersRequest) ProtoMessage() {}

func (x *ListPhraseMatchersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersRequest.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{56}
}

func (x *ListPhraseMatchersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhraseMatchersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPhraseMatchersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response of listing phrase matchers.
type ListPhraseMatchersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase matchers that match the request.
	PhraseMatchers []*PhraseMatcher `protobuf:"bytes,1,rep,name=phrase_matchers,json=phraseMatchers,proto3" json:"phrase_matchers,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhraseMatchersResponse) Reset() {
	*x = ListPhraseMatchersResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPhraseMatchersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseMatchersResponse) ProtoMessage() {}

func (x *ListPhraseMatchersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseMatchersResponse.ProtoReflect.Descriptor instead.
func (*ListPhraseMatchersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{57}
}

func (x *ListPhraseMatchersResponse) GetPhraseMatchers() []*PhraseMatcher {
	if x != nil {
		return x.PhraseMatchers
	}
	return nil
}

func (x *ListPhraseMatchersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get a a phrase matcher.
type GetPhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPhraseMatcherRequest) Reset() {
	*x = GetPhraseMatcherRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhraseMatcherRequest) ProtoMessage() {}

func (x *GetPhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*GetPhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{58}
}

func (x *GetPhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete a phrase matcher.
type DeletePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase matcher to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePhraseMatcherRequest) Reset() {
	*x = DeletePhraseMatcherRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhraseMatcherRequest) ProtoMessage() {}

func (x *DeletePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*DeletePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{59}
}

func (x *DeletePhraseMatcherRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update a phrase matcher.
type UpdatePhraseMatcherRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the phrase matcher.
	PhraseMatcher *PhraseMatcher `protobuf:"bytes,1,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePhraseMatcherRequest) Reset() {
	*x = UpdatePhraseMatcherRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePhraseMatcherRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePhraseMatcherRequest) ProtoMessage() {}

func (x *UpdatePhraseMatcherRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePhraseMatcherRequest.ProtoReflect.Descriptor instead.
func (*UpdatePhraseMatcherRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{60}
}

func (x *UpdatePhraseMatcherRequest) GetPhraseMatcher() *PhraseMatcher {
	if x != nil {
		return x.PhraseMatcher
	}
	return nil
}

func (x *UpdatePhraseMatcherRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to get project-level settings.
type GetSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSettingsRequest) Reset() {
	*x = GetSettingsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingsRequest) ProtoMessage() {}

func (x *GetSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{61}
}

func (x *GetSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update project-level settings.
type UpdateSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new settings values.
	Settings *Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSettingsRequest) Reset() {
	*x = UpdateSettingsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingsRequest) ProtoMessage() {}

func (x *UpdateSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{62}
}

func (x *UpdateSettingsRequest) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to create a analysis rule.
// analysis_rule_id will be generated by the server.
type CreateAnalysisRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analysis rule. Required. The location
	// to create a analysis rule for. Format: `projects/<Project
	// ID>/locations/<Location ID>` or `projects/<Project
	// Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The analysis rule resource to create.
	AnalysisRule *AnalysisRule `protobuf:"bytes,2,opt,name=analysis_rule,json=analysisRule,proto3" json:"analysis_rule,omitempty"`
}

func (x *CreateAnalysisRuleRequest) Reset() {
	*x = CreateAnalysisRuleRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAnalysisRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisRuleRequest) ProtoMessage() {}

func (x *CreateAnalysisRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisRuleRequest.ProtoReflect.Descriptor instead.
func (*CreateAnalysisRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{63}
}

func (x *CreateAnalysisRuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnalysisRuleRequest) GetAnalysisRule() *AnalysisRule {
	if x != nil {
		return x.AnalysisRule
	}
	return nil
}

// The request for getting a analysis rule.
type GetAnalysisRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the AnalysisRule to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnalysisRuleRequest) Reset() {
	*x = GetAnalysisRuleRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAnalysisRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnalysisRuleRequest) ProtoMessage() {}

func (x *GetAnalysisRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnalysisRuleRequest.ProtoReflect.Descriptor instead.
func (*GetAnalysisRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{64}
}

func (x *GetAnalysisRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to update a analysis rule.
type UpdateAnalysisRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new analysis rule.
	AnalysisRule *AnalysisRule `protobuf:"bytes,1,opt,name=analysis_rule,json=analysisRule,proto3" json:"analysis_rule,omitempty"`
	// Optional. The list of fields to be updated.
	// If the update_mask is not provided, the update will be applied to all
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnalysisRuleRequest) Reset() {
	*x = UpdateAnalysisRuleRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAnalysisRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnalysisRuleRequest) ProtoMessage() {}

func (x *UpdateAnalysisRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnalysisRuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnalysisRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{65}
}

func (x *UpdateAnalysisRuleRequest) GetAnalysisRule() *AnalysisRule {
	if x != nil {
		return x.AnalysisRule
	}
	return nil
}

func (x *UpdateAnalysisRuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a analysis rule.
type DeleteAnalysisRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the analysis rule to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnalysisRuleRequest) Reset() {
	*x = DeleteAnalysisRuleRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAnalysisRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnalysisRuleRequest) ProtoMessage() {}

func (x *DeleteAnalysisRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnalysisRuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnalysisRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{66}
}

func (x *DeleteAnalysisRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to list analysis rules.
type ListAnalysisRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the analysis rules.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of analysis rule to return in the response. If
	// this value is zero, the service will select a default size. A call may
	// return fewer objects than requested. A non-empty `next_page_token` in the
	// response indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListAnalysisRulesResponse`;
	// indicates that this is a continuation of a prior `ListAnalysisRules` call
	// and the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnalysisRulesRequest) Reset() {
	*x = ListAnalysisRulesRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnalysisRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysisRulesRequest) ProtoMessage() {}

func (x *ListAnalysisRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysisRulesRequest.ProtoReflect.Descriptor instead.
func (*ListAnalysisRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{67}
}

func (x *ListAnalysisRulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnalysisRulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnalysisRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response of listing views.
type ListAnalysisRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analysis_rule that match the request.
	AnalysisRules []*AnalysisRule `protobuf:"bytes,1,rep,name=analysis_rules,json=analysisRules,proto3" json:"analysis_rules,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnalysisRulesResponse) Reset() {
	*x = ListAnalysisRulesResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnalysisRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysisRulesResponse) ProtoMessage() {}

func (x *ListAnalysisRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysisRulesResponse.ProtoReflect.Descriptor instead.
func (*ListAnalysisRulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{68}
}

func (x *ListAnalysisRulesResponse) GetAnalysisRules() []*AnalysisRule {
	if x != nil {
		return x.AnalysisRules
	}
	return nil
}

func (x *ListAnalysisRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to get location-level encryption specification.
type GetEncryptionSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the encryption spec resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEncryptionSpecRequest) Reset() {
	*x = GetEncryptionSpecRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEncryptionSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEncryptionSpecRequest) ProtoMessage() {}

func (x *GetEncryptionSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEncryptionSpecRequest.ProtoReflect.Descriptor instead.
func (*GetEncryptionSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{69}
}

func (x *GetEncryptionSpecRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to initialize a location-level encryption specification.
type InitializeEncryptionSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The encryption spec used for CMEK encryption. It is required that
	// the kms key is in the same region as the endpoint. The same key will be
	// used for all provisioned resources, if encryption is available. If the
	// `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,1,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *InitializeEncryptionSpecRequest) Reset() {
	*x = InitializeEncryptionSpecRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecRequest) ProtoMessage() {}

func (x *InitializeEncryptionSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecRequest.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{70}
}

func (x *InitializeEncryptionSpecRequest) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// The response to initialize a location-level encryption specification.
type InitializeEncryptionSpecResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitializeEncryptionSpecResponse) Reset() {
	*x = InitializeEncryptionSpecResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecResponse) ProtoMessage() {}

func (x *InitializeEncryptionSpecResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecResponse.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{71}
}

// Metadata for initializing a location-level encryption specification.
type InitializeEncryptionSpecMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request for initialization.
	Request *InitializeEncryptionSpecRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during initializing operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *InitializeEncryptionSpecMetadata) Reset() {
	*x = InitializeEncryptionSpecMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializeEncryptionSpecMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeEncryptionSpecMetadata) ProtoMessage() {}

func (x *InitializeEncryptionSpecMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeEncryptionSpecMetadata.ProtoReflect.Descriptor instead.
func (*InitializeEncryptionSpecMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{72}
}

func (x *InitializeEncryptionSpecMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InitializeEncryptionSpecMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *InitializeEncryptionSpecMetadata) GetRequest() *InitializeEncryptionSpecRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *InitializeEncryptionSpecMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// The request to create a view.
type CreateViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the view. Required. The location to create
	// a view for.
	// Format: `projects/<Project ID>/locations/<Location ID>` or
	// `projects/<Project Number>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The view resource to create.
	View *View `protobuf:"bytes,2,opt,name=view,proto3" json:"view,omitempty"`
}

func (x *CreateViewRequest) Reset() {
	*x = CreateViewRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateViewRequest) ProtoMessage() {}

func (x *CreateViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateViewRequest.ProtoReflect.Descriptor instead.
func (*CreateViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{73}
}

func (x *CreateViewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateViewRequest) GetView() *View {
	if x != nil {
		return x.View
	}
	return nil
}

// The request to get a view.
type GetViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the view to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetViewRequest) Reset() {
	*x = GetViewRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetViewRequest) ProtoMessage() {}

func (x *GetViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetViewRequest.ProtoReflect.Descriptor instead.
func (*GetViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{74}
}

func (x *GetViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to list views.
type ListViewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the views.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of views to return in the response. If this
	// value is zero, the service will select a default size. A call may return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListViewsResponse`; indicates
	// that this is a continuation of a prior `ListViews` call and
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListViewsRequest) Reset() {
	*x = ListViewsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListViewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViewsRequest) ProtoMessage() {}

func (x *ListViewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViewsRequest.ProtoReflect.Descriptor instead.
func (*ListViewsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{75}
}

func (x *ListViewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListViewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListViewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response of listing views.
type ListViewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The views that match the request.
	Views []*View `protobuf:"bytes,1,rep,name=views,proto3" json:"views,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListViewsResponse) Reset() {
	*x = ListViewsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListViewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViewsResponse) ProtoMessage() {}

func (x *ListViewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViewsResponse.ProtoReflect.Descriptor instead.
func (*ListViewsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{76}
}

func (x *ListViewsResponse) GetViews() []*View {
	if x != nil {
		return x.Views
	}
	return nil
}

func (x *ListViewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to update a view.
type UpdateViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new view.
	View *View `protobuf:"bytes,1,opt,name=view,proto3" json:"view,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateViewRequest) Reset() {
	*x = UpdateViewRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateViewRequest) ProtoMessage() {}

func (x *UpdateViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateViewRequest.ProtoReflect.Descriptor instead.
func (*UpdateViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{77}
}

func (x *UpdateViewRequest) GetView() *View {
	if x != nil {
		return x.View
	}
	return nil
}

func (x *UpdateViewRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request to delete a view.
type DeleteViewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the view to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteViewRequest) Reset() {
	*x = DeleteViewRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteViewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteViewRequest) ProtoMessage() {}

func (x *DeleteViewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteViewRequest.ProtoReflect.Descriptor instead.
func (*DeleteViewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{78}
}

func (x *DeleteViewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A dimension determines the grouping key for the query. In SQL terms, these
// would be part of both the "SELECT" and "GROUP BY" clauses.
type Dimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output-only metadata about the dimension.
	//
	// Types that are assignable to DimensionMetadata:
	//
	//	*Dimension_IssueDimensionMetadata_
	//	*Dimension_AgentDimensionMetadata_
	//	*Dimension_QaQuestionDimensionMetadata_
	//	*Dimension_QaQuestionAnswerDimensionMetadata_
	DimensionMetadata isDimension_DimensionMetadata `protobuf_oneof:"dimension_metadata"`
	// The key of the dimension.
	DimensionKey Dimension_DimensionKey `protobuf:"varint,1,opt,name=dimension_key,json=dimensionKey,proto3,enum=google.cloud.contactcenterinsights.v1.Dimension_DimensionKey" json:"dimension_key,omitempty"`
}

func (x *Dimension) Reset() {
	*x = Dimension{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension) ProtoMessage() {}

func (x *Dimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension.ProtoReflect.Descriptor instead.
func (*Dimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79}
}

func (m *Dimension) GetDimensionMetadata() isDimension_DimensionMetadata {
	if m != nil {
		return m.DimensionMetadata
	}
	return nil
}

func (x *Dimension) GetIssueDimensionMetadata() *Dimension_IssueDimensionMetadata {
	if x, ok := x.GetDimensionMetadata().(*Dimension_IssueDimensionMetadata_); ok {
		return x.IssueDimensionMetadata
	}
	return nil
}

func (x *Dimension) GetAgentDimensionMetadata() *Dimension_AgentDimensionMetadata {
	if x, ok := x.GetDimensionMetadata().(*Dimension_AgentDimensionMetadata_); ok {
		return x.AgentDimensionMetadata
	}
	return nil
}

func (x *Dimension) GetQaQuestionDimensionMetadata() *Dimension_QaQuestionDimensionMetadata {
	if x, ok := x.GetDimensionMetadata().(*Dimension_QaQuestionDimensionMetadata_); ok {
		return x.QaQuestionDimensionMetadata
	}
	return nil
}

func (x *Dimension) GetQaQuestionAnswerDimensionMetadata() *Dimension_QaQuestionAnswerDimensionMetadata {
	if x, ok := x.GetDimensionMetadata().(*Dimension_QaQuestionAnswerDimensionMetadata_); ok {
		return x.QaQuestionAnswerDimensionMetadata
	}
	return nil
}

func (x *Dimension) GetDimensionKey() Dimension_DimensionKey {
	if x != nil {
		return x.DimensionKey
	}
	return Dimension_DIMENSION_KEY_UNSPECIFIED
}

type isDimension_DimensionMetadata interface {
	isDimension_DimensionMetadata()
}

type Dimension_IssueDimensionMetadata_ struct {
	// Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *Dimension_IssueDimensionMetadata `protobuf:"bytes,2,opt,name=issue_dimension_metadata,json=issueDimensionMetadata,proto3,oneof"`
}

type Dimension_AgentDimensionMetadata_ struct {
	// Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *Dimension_AgentDimensionMetadata `protobuf:"bytes,3,opt,name=agent_dimension_metadata,json=agentDimensionMetadata,proto3,oneof"`
}

type Dimension_QaQuestionDimensionMetadata_ struct {
	// Output only. Metadata about the QA question dimension.
	QaQuestionDimensionMetadata *Dimension_QaQuestionDimensionMetadata `protobuf:"bytes,4,opt,name=qa_question_dimension_metadata,json=qaQuestionDimensionMetadata,proto3,oneof"`
}

type Dimension_QaQuestionAnswerDimensionMetadata_ struct {
	// Output only. Metadata about the QA question-answer dimension.
	QaQuestionAnswerDimensionMetadata *Dimension_QaQuestionAnswerDimensionMetadata `protobuf:"bytes,5,opt,name=qa_question_answer_dimension_metadata,json=qaQuestionAnswerDimensionMetadata,proto3,oneof"`
}

func (*Dimension_IssueDimensionMetadata_) isDimension_DimensionMetadata() {}

func (*Dimension_AgentDimensionMetadata_) isDimension_DimensionMetadata() {}

func (*Dimension_QaQuestionDimensionMetadata_) isDimension_DimensionMetadata() {}

func (*Dimension_QaQuestionAnswerDimensionMetadata_) isDimension_DimensionMetadata() {}

// The request for querying metrics.
type QueryMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. Filter to select a subset of conversations to compute the
	// metrics. Must specify a window of the conversation create time to compute
	// the metrics. The returned metrics will be from the range [DATE(starting
	// create time), DATE(ending create time)).
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The time granularity of each data point in the time series.
	// Defaults to NONE if this field is unspecified.
	TimeGranularity QueryMetricsRequest_TimeGranularity `protobuf:"varint,3,opt,name=time_granularity,json=timeGranularity,proto3,enum=google.cloud.contactcenterinsights.v1.QueryMetricsRequest_TimeGranularity" json:"time_granularity,omitempty"`
	// The dimensions that determine the grouping key for the query. Defaults to
	// no dimension if this field is unspecified. If a dimension is specified,
	// its key must also be specified. Each dimension's key must be unique.
	//
	// If a time granularity is also specified, metric values in the dimension
	// will be bucketed by this granularity.
	//
	// Up to one dimension is supported for now.
	Dimensions []*Dimension `protobuf:"bytes,4,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Measures to return. Defaults to all measures if this field is unspecified.
	// A valid mask should traverse from the `measure` field from the response.
	// For example, a path from a measure mask to get the conversation count is
	// "conversation_measure.count".
	MeasureMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=measure_mask,json=measureMask,proto3" json:"measure_mask,omitempty"`
}

func (x *QueryMetricsRequest) Reset() {
	*x = QueryMetricsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsRequest) ProtoMessage() {}

func (x *QueryMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsRequest.ProtoReflect.Descriptor instead.
func (*QueryMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{80}
}

func (x *QueryMetricsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *QueryMetricsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *QueryMetricsRequest) GetTimeGranularity() QueryMetricsRequest_TimeGranularity {
	if x != nil {
		return x.TimeGranularity
	}
	return QueryMetricsRequest_TIME_GRANULARITY_UNSPECIFIED
}

func (x *QueryMetricsRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *QueryMetricsRequest) GetMeasureMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.MeasureMask
	}
	return nil
}

// The response for querying metrics.
type QueryMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The metrics last update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// A slice contains a total and (if the request specified a time granularity)
	// a time series of metric values. Each slice contains a unique combination of
	// the cardinality of dimensions from the request.
	Slices []*QueryMetricsResponse_Slice `protobuf:"bytes,2,rep,name=slices,proto3" json:"slices,omitempty"`
	// The macro average slice contains aggregated averages across the selected
	// dimension. i.e. if group_by agent is specified this field will contain the
	// average across all agents.
	// This field is only populated if the request specifies a Dimension.
	MacroAverageSlice *QueryMetricsResponse_Slice `protobuf:"bytes,4,opt,name=macro_average_slice,json=macroAverageSlice,proto3,oneof" json:"macro_average_slice,omitempty"`
}

func (x *QueryMetricsResponse) Reset() {
	*x = QueryMetricsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse) ProtoMessage() {}

func (x *QueryMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81}
}

func (x *QueryMetricsResponse) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *QueryMetricsResponse) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *QueryMetricsResponse) GetSlices() []*QueryMetricsResponse_Slice {
	if x != nil {
		return x.Slices
	}
	return nil
}

func (x *QueryMetricsResponse) GetMacroAverageSlice() *QueryMetricsResponse_Slice {
	if x != nil {
		return x.MacroAverageSlice
	}
	return nil
}

// The metadata from querying metrics.
type QueryMetricsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *QueryMetricsMetadata) Reset() {
	*x = QueryMetricsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsMetadata) ProtoMessage() {}

func (x *QueryMetricsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsMetadata.ProtoReflect.Descriptor instead.
func (*QueryMetricsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{82}
}

// The request for creating a QaQuestion.
type CreateQaQuestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the QaQuestion.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The QaQuestion to create.
	QaQuestion *QaQuestion `protobuf:"bytes,2,opt,name=qa_question,json=qaQuestion,proto3" json:"qa_question,omitempty"`
	// Optional. A unique ID for the new question. This ID will become the final
	// component of the question's resource name. If no ID is specified, a
	// server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
	QaQuestionId string `protobuf:"bytes,3,opt,name=qa_question_id,json=qaQuestionId,proto3" json:"qa_question_id,omitempty"`
}

func (x *CreateQaQuestionRequest) Reset() {
	*x = CreateQaQuestionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateQaQuestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateQaQuestionRequest) ProtoMessage() {}

func (x *CreateQaQuestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateQaQuestionRequest.ProtoReflect.Descriptor instead.
func (*CreateQaQuestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{83}
}

func (x *CreateQaQuestionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateQaQuestionRequest) GetQaQuestion() *QaQuestion {
	if x != nil {
		return x.QaQuestion
	}
	return nil
}

func (x *CreateQaQuestionRequest) GetQaQuestionId() string {
	if x != nil {
		return x.QaQuestionId
	}
	return ""
}

// The request for a QaQuestion.
type GetQaQuestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaQuestion to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQaQuestionRequest) Reset() {
	*x = GetQaQuestionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQaQuestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQaQuestionRequest) ProtoMessage() {}

func (x *GetQaQuestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQaQuestionRequest.ProtoReflect.Descriptor instead.
func (*GetQaQuestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{84}
}

func (x *GetQaQuestionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list QaQuestions.
type ListQaQuestionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the questions.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of questions to return in the response. If the
	// value is zero, the service will select a default size. A call might return
	// fewer objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListQaQuestionsResponse`. This
	// value indicates that this is a continuation of a prior `ListQaQuestions`
	// call and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListQaQuestionsRequest) Reset() {
	*x = ListQaQuestionsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaQuestionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaQuestionsRequest) ProtoMessage() {}

func (x *ListQaQuestionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaQuestionsRequest.ProtoReflect.Descriptor instead.
func (*ListQaQuestionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{85}
}

func (x *ListQaQuestionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQaQuestionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQaQuestionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from a ListQaQuestions request.
type ListQaQuestionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The QaQuestions under the parent.
	QaQuestions []*QaQuestion `protobuf:"bytes,1,rep,name=qa_questions,json=qaQuestions,proto3" json:"qa_questions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQaQuestionsResponse) Reset() {
	*x = ListQaQuestionsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaQuestionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaQuestionsResponse) ProtoMessage() {}

func (x *ListQaQuestionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaQuestionsResponse.ProtoReflect.Descriptor instead.
func (*ListQaQuestionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{86}
}

func (x *ListQaQuestionsResponse) GetQaQuestions() []*QaQuestion {
	if x != nil {
		return x.QaQuestions
	}
	return nil
}

func (x *ListQaQuestionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for updating a QaQuestion.
type UpdateQaQuestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The QaQuestion to update.
	QaQuestion *QaQuestion `protobuf:"bytes,1,opt,name=qa_question,json=qaQuestion,proto3" json:"qa_question,omitempty"`
	// Required. The list of fields to be updated. All possible fields can be
	// updated by passing `*`, or a subset of the following updateable fields can
	// be provided:
	//
	// * `abbreviation`
	// * `answer_choices`
	// * `answer_instructions`
	// * `order`
	// * `question_body`
	// * `tags`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateQaQuestionRequest) Reset() {
	*x = UpdateQaQuestionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateQaQuestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateQaQuestionRequest) ProtoMessage() {}

func (x *UpdateQaQuestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateQaQuestionRequest.ProtoReflect.Descriptor instead.
func (*UpdateQaQuestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{87}
}

func (x *UpdateQaQuestionRequest) GetQaQuestion() *QaQuestion {
	if x != nil {
		return x.QaQuestion
	}
	return nil
}

func (x *UpdateQaQuestionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for deleting a QaQuestion.
type DeleteQaQuestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaQuestion to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteQaQuestionRequest) Reset() {
	*x = DeleteQaQuestionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteQaQuestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteQaQuestionRequest) ProtoMessage() {}

func (x *DeleteQaQuestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteQaQuestionRequest.ProtoReflect.Descriptor instead.
func (*DeleteQaQuestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{88}
}

func (x *DeleteQaQuestionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for creating a QaScorecard.
type CreateQaScorecardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the QaScorecard.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The QaScorecard to create.
	QaScorecard *QaScorecard `protobuf:"bytes,2,opt,name=qa_scorecard,json=qaScorecard,proto3" json:"qa_scorecard,omitempty"`
	// Optional. A unique ID for the new QaScorecard. This ID will become the
	// final component of the QaScorecard's resource name. If no ID is specified,
	// a server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
	QaScorecardId string `protobuf:"bytes,3,opt,name=qa_scorecard_id,json=qaScorecardId,proto3" json:"qa_scorecard_id,omitempty"`
}

func (x *CreateQaScorecardRequest) Reset() {
	*x = CreateQaScorecardRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateQaScorecardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateQaScorecardRequest) ProtoMessage() {}

func (x *CreateQaScorecardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateQaScorecardRequest.ProtoReflect.Descriptor instead.
func (*CreateQaScorecardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{89}
}

func (x *CreateQaScorecardRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateQaScorecardRequest) GetQaScorecard() *QaScorecard {
	if x != nil {
		return x.QaScorecard
	}
	return nil
}

func (x *CreateQaScorecardRequest) GetQaScorecardId() string {
	if x != nil {
		return x.QaScorecardId
	}
	return ""
}

// The request for a QaScorecard. By default, returns the latest revision.
type GetQaScorecardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecard to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQaScorecardRequest) Reset() {
	*x = GetQaScorecardRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQaScorecardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQaScorecardRequest) ProtoMessage() {}

func (x *GetQaScorecardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQaScorecardRequest.ProtoReflect.Descriptor instead.
func (*GetQaScorecardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{90}
}

func (x *GetQaScorecardRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for updating a QaScorecard.
type UpdateQaScorecardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The QaScorecard to update.
	QaScorecard *QaScorecard `protobuf:"bytes,1,opt,name=qa_scorecard,json=qaScorecard,proto3" json:"qa_scorecard,omitempty"`
	// Required. The list of fields to be updated. All possible fields can be
	// updated by passing `*`, or a subset of the following updateable fields can
	// be provided:
	//
	// * `description`
	// * `display_name`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateQaScorecardRequest) Reset() {
	*x = UpdateQaScorecardRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateQaScorecardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateQaScorecardRequest) ProtoMessage() {}

func (x *UpdateQaScorecardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateQaScorecardRequest.ProtoReflect.Descriptor instead.
func (*UpdateQaScorecardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{91}
}

func (x *UpdateQaScorecardRequest) GetQaScorecard() *QaScorecard {
	if x != nil {
		return x.QaScorecard
	}
	return nil
}

func (x *UpdateQaScorecardRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for deleting a QaScorecard.
type DeleteQaScorecardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecard to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, all of this QaScorecard's child resources will
	// also be deleted. Otherwise, the request will only succeed if it has none.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteQaScorecardRequest) Reset() {
	*x = DeleteQaScorecardRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteQaScorecardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteQaScorecardRequest) ProtoMessage() {}

func (x *DeleteQaScorecardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteQaScorecardRequest.ProtoReflect.Descriptor instead.
func (*DeleteQaScorecardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{92}
}

func (x *DeleteQaScorecardRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteQaScorecardRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request for creating a QaScorecardRevision.
type CreateQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the QaScorecardRevision.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The QaScorecardRevision to create.
	QaScorecardRevision *QaScorecardRevision `protobuf:"bytes,2,opt,name=qa_scorecard_revision,json=qaScorecardRevision,proto3" json:"qa_scorecard_revision,omitempty"`
	// Optional. A unique ID for the new QaScorecardRevision. This ID will become
	// the final component of the QaScorecardRevision's resource name. If no ID is
	// specified, a server-generated ID will be used.
	//
	// This value should be 4-64 characters and must match the regular
	// expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`.
	QaScorecardRevisionId string `protobuf:"bytes,3,opt,name=qa_scorecard_revision_id,json=qaScorecardRevisionId,proto3" json:"qa_scorecard_revision_id,omitempty"`
}

func (x *CreateQaScorecardRevisionRequest) Reset() {
	*x = CreateQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateQaScorecardRevisionRequest) ProtoMessage() {}

func (x *CreateQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*CreateQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{93}
}

func (x *CreateQaScorecardRevisionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateQaScorecardRevisionRequest) GetQaScorecardRevision() *QaScorecardRevision {
	if x != nil {
		return x.QaScorecardRevision
	}
	return nil
}

func (x *CreateQaScorecardRevisionRequest) GetQaScorecardRevisionId() string {
	if x != nil {
		return x.QaScorecardRevisionId
	}
	return ""
}

// The request for a QaScorecardRevision.
type GetQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecardRevision to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQaScorecardRevisionRequest) Reset() {
	*x = GetQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQaScorecardRevisionRequest) ProtoMessage() {}

func (x *GetQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{94}
}

func (x *GetQaScorecardRevisionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for TuneQaScorecardRevision endpoint.
type TuneQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for new fine tuning job instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Filter for selecting the feedback labels that needs to be
	// used for training.
	// This filter can be used to limit the feedback labels used for tuning to a
	// feedback labels created or updated for a specific time-window etc.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Run in validate only mode, no fine tuning will actually run.
	// Data quality validations like training data distributions will run.
	// Even when set to false, the data quality validations will still run but
	// once the validations complete we will proceed with the fine tune, if
	// applicable.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *TuneQaScorecardRevisionRequest) Reset() {
	*x = TuneQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionRequest) ProtoMessage() {}

func (x *TuneQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{95}
}

func (x *TuneQaScorecardRevisionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TuneQaScorecardRevisionRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *TuneQaScorecardRevisionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Response for TuneQaScorecardRevision endpoint.
type TuneQaScorecardRevisionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TuneQaScorecardRevisionResponse) Reset() {
	*x = TuneQaScorecardRevisionResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionResponse) ProtoMessage() {}

func (x *TuneQaScorecardRevisionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionResponse.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{96}
}

// Metadata for TuneQaScorecardRevision endpoint.
type TuneQaScorecardRevisionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request.
	Request *TuneQaScorecardRevisionRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. The results of data validation per question in the request.
	QaQuestionDatasetValidationResults []*TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult `protobuf:"bytes,4,rep,name=qa_question_dataset_validation_results,json=qaQuestionDatasetValidationResults,proto3" json:"qa_question_dataset_validation_results,omitempty"`
	// Output only. The metrics for each QaQuestion in the TuneScorecardRevision
	// request.
	QaQuestionDatasetTuningMetrics []*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics `protobuf:"bytes,5,rep,name=qa_question_dataset_tuning_metrics,json=qaQuestionDatasetTuningMetrics,proto3" json:"qa_question_dataset_tuning_metrics,omitempty"`
	// Output only. The percentage of the tuning job that has completed. Always
	// between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
	// indicates the job has completed i.e. 100%.
	TuningCompletionRatio float64 `protobuf:"fixed64,6,opt,name=tuning_completion_ratio,json=tuningCompletionRatio,proto3" json:"tuning_completion_ratio,omitempty"`
}

func (x *TuneQaScorecardRevisionMetadata) Reset() {
	*x = TuneQaScorecardRevisionMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionMetadata) ProtoMessage() {}

func (x *TuneQaScorecardRevisionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionMetadata.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{97}
}

func (x *TuneQaScorecardRevisionMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata) GetRequest() *TuneQaScorecardRevisionRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata) GetQaQuestionDatasetValidationResults() []*TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult {
	if x != nil {
		return x.QaQuestionDatasetValidationResults
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata) GetQaQuestionDatasetTuningMetrics() []*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics {
	if x != nil {
		return x.QaQuestionDatasetTuningMetrics
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata) GetTuningCompletionRatio() float64 {
	if x != nil {
		return x.TuningCompletionRatio
	}
	return 0
}

// The request to deploy a QaScorecardRevision
type DeployQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecardRevision to deploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployQaScorecardRevisionRequest) Reset() {
	*x = DeployQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployQaScorecardRevisionRequest) ProtoMessage() {}

func (x *DeployQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*DeployQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{98}
}

func (x *DeployQaScorecardRevisionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to undeploy a QaScorecardRevision
type UndeployQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecardRevision to undeploy.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployQaScorecardRevisionRequest) Reset() {
	*x = UndeployQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeployQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployQaScorecardRevisionRequest) ProtoMessage() {}

func (x *UndeployQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*UndeployQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{99}
}

func (x *UndeployQaScorecardRevisionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to delete a QaScorecardRevision.
type DeleteQaScorecardRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the QaScorecardRevision to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, all of this QaScorecardRevision's child resources
	// will also be deleted. Otherwise, the request will only succeed if it has
	// none.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteQaScorecardRevisionRequest) Reset() {
	*x = DeleteQaScorecardRevisionRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteQaScorecardRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteQaScorecardRevisionRequest) ProtoMessage() {}

func (x *DeleteQaScorecardRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteQaScorecardRevisionRequest.ProtoReflect.Descriptor instead.
func (*DeleteQaScorecardRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{100}
}

func (x *DeleteQaScorecardRevisionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteQaScorecardRevisionRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request to list QaScorecards.
type ListQaScorecardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the scorecards.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of scorecards to return in the response. If
	// the value is zero, the service will select a default size. A call might
	// return fewer objects than requested. A non-empty `next_page_token` in the
	// response indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListQaScorecardsResponse`. This
	// value indicates that this is a continuation of a prior `ListQaScorecards`
	// call and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListQaScorecardsRequest) Reset() {
	*x = ListQaScorecardsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaScorecardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaScorecardsRequest) ProtoMessage() {}

func (x *ListQaScorecardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaScorecardsRequest.ProtoReflect.Descriptor instead.
func (*ListQaScorecardsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{101}
}

func (x *ListQaScorecardsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQaScorecardsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQaScorecardsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from a ListQaScorecards request.
type ListQaScorecardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The QaScorecards under the parent.
	QaScorecards []*QaScorecard `protobuf:"bytes,1,rep,name=qa_scorecards,json=qaScorecards,proto3" json:"qa_scorecards,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQaScorecardsResponse) Reset() {
	*x = ListQaScorecardsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaScorecardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaScorecardsResponse) ProtoMessage() {}

func (x *ListQaScorecardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaScorecardsResponse.ProtoReflect.Descriptor instead.
func (*ListQaScorecardsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{102}
}

func (x *ListQaScorecardsResponse) GetQaScorecards() []*QaScorecard {
	if x != nil {
		return x.QaScorecards
	}
	return nil
}

func (x *ListQaScorecardsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to list QaScorecardRevisions
type ListQaScorecardRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the scorecard revisions. To list all
	// revisions of all scorecards, substitute the QaScorecard ID with a '-'
	// character.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of scorecard revisions to return in the
	// response. If the value is zero, the service will select a default size. A
	// call might return fewer objects than requested. A non-empty
	// `next_page_token` in the response indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last
	// `ListQaScorecardRevisionsResponse`. This value indicates that this is a
	// continuation of a prior `ListQaScorecardRevisions` call and that the system
	// should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter to reduce results to a specific subset. Useful for
	// querying scorecard revisions with specific properties.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListQaScorecardRevisionsRequest) Reset() {
	*x = ListQaScorecardRevisionsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaScorecardRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaScorecardRevisionsRequest) ProtoMessage() {}

func (x *ListQaScorecardRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaScorecardRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListQaScorecardRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{103}
}

func (x *ListQaScorecardRevisionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQaScorecardRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQaScorecardRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListQaScorecardRevisionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response from a ListQaScorecardRevisions request.
type ListQaScorecardRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The QaScorecards under the parent.
	QaScorecardRevisions []*QaScorecardRevision `protobuf:"bytes,1,rep,name=qa_scorecard_revisions,json=qaScorecardRevisions,proto3" json:"qa_scorecard_revisions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQaScorecardRevisionsResponse) Reset() {
	*x = ListQaScorecardRevisionsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListQaScorecardRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQaScorecardRevisionsResponse) ProtoMessage() {}

func (x *ListQaScorecardRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQaScorecardRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListQaScorecardRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{104}
}

func (x *ListQaScorecardRevisionsResponse) GetQaScorecardRevisions() []*QaScorecardRevision {
	if x != nil {
		return x.QaScorecardRevisions
	}
	return nil
}

func (x *ListQaScorecardRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for creating a feedback label.
type CreateFeedbackLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the feedback label.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID of the feedback label to create.
	// If one is not specified it will be generated by the server.
	FeedbackLabelId string `protobuf:"bytes,2,opt,name=feedback_label_id,json=feedbackLabelId,proto3" json:"feedback_label_id,omitempty"`
	// Required. The feedback label to create.
	FeedbackLabel *FeedbackLabel `protobuf:"bytes,3,opt,name=feedback_label,json=feedbackLabel,proto3" json:"feedback_label,omitempty"`
}

func (x *CreateFeedbackLabelRequest) Reset() {
	*x = CreateFeedbackLabelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeedbackLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeedbackLabelRequest) ProtoMessage() {}

func (x *CreateFeedbackLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeedbackLabelRequest.ProtoReflect.Descriptor instead.
func (*CreateFeedbackLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{105}
}

func (x *CreateFeedbackLabelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeedbackLabelRequest) GetFeedbackLabelId() string {
	if x != nil {
		return x.FeedbackLabelId
	}
	return ""
}

func (x *CreateFeedbackLabelRequest) GetFeedbackLabel() *FeedbackLabel {
	if x != nil {
		return x.FeedbackLabel
	}
	return nil
}

// The request for listing feedback labels.
type ListFeedbackLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the feedback labels.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Automatically sorts by
	// conversation ID. To sort by all feedback labels in a project see
	// ListAllFeedbackLabels.
	//
	// Supported fields:
	//
	// * `issue_model_id`
	// * `qa_question_id`
	// * `qa_scorecard_id`
	// * `min_create_time`
	// * `max_create_time`
	// * `min_update_time`
	// * `max_update_time`
	// * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of feedback labels to return in the response.
	// A valid page size ranges from 0 to 100,000 inclusive. If the page size is
	// zero or unspecified, a default page size of 100 will be chosen. Note that a
	// call might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListFeedbackLabelsResponse`. This
	// value indicates that this is a continuation of a prior `ListFeedbackLabels`
	// call and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFeedbackLabelsRequest) Reset() {
	*x = ListFeedbackLabelsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeedbackLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedbackLabelsRequest) ProtoMessage() {}

func (x *ListFeedbackLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedbackLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListFeedbackLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{106}
}

func (x *ListFeedbackLabelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeedbackLabelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeedbackLabelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeedbackLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for listing feedback labels.
type ListFeedbackLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feedback labels that match the request.
	FeedbackLabels []*FeedbackLabel `protobuf:"bytes,1,rep,name=feedback_labels,json=feedbackLabels,proto3" json:"feedback_labels,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeedbackLabelsResponse) Reset() {
	*x = ListFeedbackLabelsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeedbackLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedbackLabelsResponse) ProtoMessage() {}

func (x *ListFeedbackLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedbackLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListFeedbackLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{107}
}

func (x *ListFeedbackLabelsResponse) GetFeedbackLabels() []*FeedbackLabel {
	if x != nil {
		return x.FeedbackLabels
	}
	return nil
}

func (x *ListFeedbackLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for getting a feedback label.
type GetFeedbackLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the feedback label to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeedbackLabelRequest) Reset() {
	*x = GetFeedbackLabelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeedbackLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeedbackLabelRequest) ProtoMessage() {}

func (x *GetFeedbackLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeedbackLabelRequest.ProtoReflect.Descriptor instead.
func (*GetFeedbackLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{108}
}

func (x *GetFeedbackLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for updating a feedback label.
type UpdateFeedbackLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The feedback label to update.
	FeedbackLabel *FeedbackLabel `protobuf:"bytes,1,opt,name=feedback_label,json=feedbackLabel,proto3" json:"feedback_label,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeedbackLabelRequest) Reset() {
	*x = UpdateFeedbackLabelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeedbackLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeedbackLabelRequest) ProtoMessage() {}

func (x *UpdateFeedbackLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeedbackLabelRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeedbackLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{109}
}

func (x *UpdateFeedbackLabelRequest) GetFeedbackLabel() *FeedbackLabel {
	if x != nil {
		return x.FeedbackLabel
	}
	return nil
}

func (x *UpdateFeedbackLabelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for deleting a feedback label.
type DeleteFeedbackLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the feedback label to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeedbackLabelRequest) Reset() {
	*x = DeleteFeedbackLabelRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeedbackLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeedbackLabelRequest) ProtoMessage() {}

func (x *DeleteFeedbackLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeedbackLabelRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeedbackLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{110}
}

func (x *DeleteFeedbackLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for listing all feedback labels.
type ListAllFeedbackLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of all feedback labels per project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of feedback labels to return in the response.
	// A valid page size ranges from 0 to 100,000 inclusive. If the page size is
	// zero or unspecified, a default page size of 100 will be chosen. Note that a
	// call might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last `ListAllFeedbackLabelsResponse`.
	// This value indicates that this is a continuation of a prior
	// `ListAllFeedbackLabels` call and that the system should return the next
	// page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter to reduce results to a specific subset in the entire
	// project. Supports disjunctions (OR) and conjunctions (AND).
	//
	// Supported fields:
	//
	// * `issue_model_id`
	// * `qa_question_id`
	// * `min_create_time`
	// * `max_create_time`
	// * `min_update_time`
	// * `max_update_time`
	// * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAllFeedbackLabelsRequest) Reset() {
	*x = ListAllFeedbackLabelsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAllFeedbackLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAllFeedbackLabelsRequest) ProtoMessage() {}

func (x *ListAllFeedbackLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAllFeedbackLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListAllFeedbackLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{111}
}

func (x *ListAllFeedbackLabelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAllFeedbackLabelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAllFeedbackLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAllFeedbackLabelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for listing all feedback labels.
type ListAllFeedbackLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feedback labels that match the request.
	FeedbackLabels []*FeedbackLabel `protobuf:"bytes,1,rep,name=feedback_labels,json=feedbackLabels,proto3" json:"feedback_labels,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAllFeedbackLabelsResponse) Reset() {
	*x = ListAllFeedbackLabelsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAllFeedbackLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAllFeedbackLabelsResponse) ProtoMessage() {}

func (x *ListAllFeedbackLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAllFeedbackLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListAllFeedbackLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{112}
}

func (x *ListAllFeedbackLabelsResponse) GetFeedbackLabels() []*FeedbackLabel {
	if x != nil {
		return x.FeedbackLabels
	}
	return nil
}

func (x *ListAllFeedbackLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for bulk uploading feedback labels.
type BulkUploadFeedbackLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for an external data store containing objects that will
	// be converted to FeedbackLabels.
	//
	// Types that are assignable to Source:
	//
	//	*BulkUploadFeedbackLabelsRequest_GcsSource_
	Source isBulkUploadFeedbackLabelsRequest_Source `protobuf_oneof:"source"`
	// Required. The parent resource for new feedback labels.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If set, upload will not happen and the labels will be validated.
	// If not set, then default behavior will be to upload the labels after
	// validation is complete.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *BulkUploadFeedbackLabelsRequest) Reset() {
	*x = BulkUploadFeedbackLabelsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkUploadFeedbackLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkUploadFeedbackLabelsRequest) ProtoMessage() {}

func (x *BulkUploadFeedbackLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsRequest.ProtoReflect.Descriptor instead.
func (*BulkUploadFeedbackLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{113}
}

func (m *BulkUploadFeedbackLabelsRequest) GetSource() isBulkUploadFeedbackLabelsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsRequest) GetGcsSource() *BulkUploadFeedbackLabelsRequest_GcsSource {
	if x, ok := x.GetSource().(*BulkUploadFeedbackLabelsRequest_GcsSource_); ok {
		return x.GcsSource
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkUploadFeedbackLabelsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

type isBulkUploadFeedbackLabelsRequest_Source interface {
	isBulkUploadFeedbackLabelsRequest_Source()
}

type BulkUploadFeedbackLabelsRequest_GcsSource_ struct {
	// A cloud storage bucket source.
	GcsSource *BulkUploadFeedbackLabelsRequest_GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*BulkUploadFeedbackLabelsRequest_GcsSource_) isBulkUploadFeedbackLabelsRequest_Source() {}

// Response for the Bulk Upload Feedback Labels API.
type BulkUploadFeedbackLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkUploadFeedbackLabelsResponse) Reset() {
	*x = BulkUploadFeedbackLabelsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkUploadFeedbackLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkUploadFeedbackLabelsResponse) ProtoMessage() {}

func (x *BulkUploadFeedbackLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsResponse.ProtoReflect.Descriptor instead.
func (*BulkUploadFeedbackLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{114}
}

// Metadata for the Bulk Upload Feedback Labels API.
type BulkUploadFeedbackLabelsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request for ingest.
	Request *BulkUploadFeedbackLabelsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during ingest operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
	// Output only. Statistics for BulkUploadFeedbackLabels operation.
	UploadStats *BulkUploadFeedbackLabelsMetadata_UploadStats `protobuf:"bytes,5,opt,name=upload_stats,json=uploadStats,proto3" json:"upload_stats,omitempty"`
}

func (x *BulkUploadFeedbackLabelsMetadata) Reset() {
	*x = BulkUploadFeedbackLabelsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkUploadFeedbackLabelsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkUploadFeedbackLabelsMetadata) ProtoMessage() {}

func (x *BulkUploadFeedbackLabelsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsMetadata.ProtoReflect.Descriptor instead.
func (*BulkUploadFeedbackLabelsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{115}
}

func (x *BulkUploadFeedbackLabelsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsMetadata) GetRequest() *BulkUploadFeedbackLabelsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

func (x *BulkUploadFeedbackLabelsMetadata) GetUploadStats() *BulkUploadFeedbackLabelsMetadata_UploadStats {
	if x != nil {
		return x.UploadStats
	}
	return nil
}

// Request for the BulkDownloadFeedbackLabel endpoint.
type BulkDownloadFeedbackLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for an external data store to which the feedback labels
	// will be written to.
	//
	// Types that are assignable to Destination:
	//
	//	*BulkDownloadFeedbackLabelsRequest_GcsDestination_
	Destination isBulkDownloadFeedbackLabelsRequest_Destination `protobuf_oneof:"destination"`
	// Required. The parent resource for new feedback labels.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND).
	//
	// Supported fields:
	//
	// * `issue_model_id`
	// * `qa_question_id`
	// * `qa_scorecard_id`
	// * `min_create_time`
	// * `max_create_time`
	// * `min_update_time`
	// * `max_update_time`
	// * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Limits the maximum number of feedback labels that will be
	// downloaded. The first `N` feedback labels will be downloaded.
	MaxDownloadCount int32 `protobuf:"varint,4,opt,name=max_download_count,json=maxDownloadCount,proto3" json:"max_download_count,omitempty"`
	// Optional. The type of feedback labels that will be downloaded.
	FeedbackLabelType BulkDownloadFeedbackLabelsRequest_FeedbackLabelType `protobuf:"varint,5,opt,name=feedback_label_type,json=feedbackLabelType,proto3,enum=google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest_FeedbackLabelType" json:"feedback_label_type,omitempty"`
	// Optional. Filter parent conversations to download feedback labels for.
	// When specified, the feedback labels will be downloaded for the
	// conversations that match the filter.
	// If `template_qa_scorecard_id` is set, all the conversations that match the
	// filter will be paired with the questions under the scorecard for labeling.
	ConversationFilter string `protobuf:"bytes,6,opt,name=conversation_filter,json=conversationFilter,proto3" json:"conversation_filter,omitempty"`
	// Optional. If set, a template for labeling conversations and scorecard
	// questions will be created from the conversation_filter and the questions
	// under the scorecard(s). The feedback label `filter` will be ignored.
	TemplateQaScorecardId []string `protobuf:"bytes,7,rep,name=template_qa_scorecard_id,json=templateQaScorecardId,proto3" json:"template_qa_scorecard_id,omitempty"`
}

func (x *BulkDownloadFeedbackLabelsRequest) Reset() {
	*x = BulkDownloadFeedbackLabelsRequest{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDownloadFeedbackLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDownloadFeedbackLabelsRequest) ProtoMessage() {}

func (x *BulkDownloadFeedbackLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsRequest.ProtoReflect.Descriptor instead.
func (*BulkDownloadFeedbackLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{116}
}

func (m *BulkDownloadFeedbackLabelsRequest) GetDestination() isBulkDownloadFeedbackLabelsRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsRequest) GetGcsDestination() *BulkDownloadFeedbackLabelsRequest_GcsDestination {
	if x, ok := x.GetDestination().(*BulkDownloadFeedbackLabelsRequest_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkDownloadFeedbackLabelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *BulkDownloadFeedbackLabelsRequest) GetMaxDownloadCount() int32 {
	if x != nil {
		return x.MaxDownloadCount
	}
	return 0
}

func (x *BulkDownloadFeedbackLabelsRequest) GetFeedbackLabelType() BulkDownloadFeedbackLabelsRequest_FeedbackLabelType {
	if x != nil {
		return x.FeedbackLabelType
	}
	return BulkDownloadFeedbackLabelsRequest_FEEDBACK_LABEL_TYPE_UNSPECIFIED
}

func (x *BulkDownloadFeedbackLabelsRequest) GetConversationFilter() string {
	if x != nil {
		return x.ConversationFilter
	}
	return ""
}

func (x *BulkDownloadFeedbackLabelsRequest) GetTemplateQaScorecardId() []string {
	if x != nil {
		return x.TemplateQaScorecardId
	}
	return nil
}

type isBulkDownloadFeedbackLabelsRequest_Destination interface {
	isBulkDownloadFeedbackLabelsRequest_Destination()
}

type BulkDownloadFeedbackLabelsRequest_GcsDestination_ struct {
	// A cloud storage bucket destination.
	GcsDestination *BulkDownloadFeedbackLabelsRequest_GcsDestination `protobuf:"bytes,3,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*BulkDownloadFeedbackLabelsRequest_GcsDestination_) isBulkDownloadFeedbackLabelsRequest_Destination() {
}

// Response for the BulkDownloadFeedbackLabel endpoint.
type BulkDownloadFeedbackLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkDownloadFeedbackLabelsResponse) Reset() {
	*x = BulkDownloadFeedbackLabelsResponse{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDownloadFeedbackLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDownloadFeedbackLabelsResponse) ProtoMessage() {}

func (x *BulkDownloadFeedbackLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsResponse.ProtoReflect.Descriptor instead.
func (*BulkDownloadFeedbackLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{117}
}

// Metadata for the BulkDownloadFeedbackLabel endpoint.
type BulkDownloadFeedbackLabelsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The original request for download.
	Request *BulkDownloadFeedbackLabelsRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Partial errors during ingest operation that might cause the operation
	// output to be incomplete.
	PartialErrors []*status.Status `protobuf:"bytes,4,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
	// Output only. Statistics for BulkDownloadFeedbackLabels operation.
	DownloadStats *BulkDownloadFeedbackLabelsMetadata_DownloadStats `protobuf:"bytes,5,opt,name=download_stats,json=downloadStats,proto3" json:"download_stats,omitempty"`
}

func (x *BulkDownloadFeedbackLabelsMetadata) Reset() {
	*x = BulkDownloadFeedbackLabelsMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDownloadFeedbackLabelsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDownloadFeedbackLabelsMetadata) ProtoMessage() {}

func (x *BulkDownloadFeedbackLabelsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsMetadata.ProtoReflect.Descriptor instead.
func (*BulkDownloadFeedbackLabelsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{118}
}

func (x *BulkDownloadFeedbackLabelsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsMetadata) GetRequest() *BulkDownloadFeedbackLabelsRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsMetadata) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

func (x *BulkDownloadFeedbackLabelsMetadata) GetDownloadStats() *BulkDownloadFeedbackLabelsMetadata_DownloadStats {
	if x != nil {
		return x.DownloadStats
	}
	return nil
}

// A time series representing conversations over time.
type CalculateStatsResponse_TimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The duration of each interval.
	IntervalDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=interval_duration,json=intervalDuration,proto3" json:"interval_duration,omitempty"`
	// An ordered list of intervals from earliest to latest, where each interval
	// represents the number of conversations that transpired during the time
	// window.
	Points []*CalculateStatsResponse_TimeSeries_Interval `protobuf:"bytes,2,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries) Reset() {
	*x = CalculateStatsResponse_TimeSeries{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateStatsResponse_TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CalculateStatsResponse_TimeSeries) GetIntervalDuration() *durationpb.Duration {
	if x != nil {
		return x.IntervalDuration
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries) GetPoints() []*CalculateStatsResponse_TimeSeries_Interval {
	if x != nil {
		return x.Points
	}
	return nil
}

// A single interval in a time series.
type CalculateStatsResponse_TimeSeries_Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of this interval.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The number of conversations created in this interval.
	ConversationCount int32 `protobuf:"varint,2,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
}

func (x *CalculateStatsResponse_TimeSeries_Interval) Reset() {
	*x = CalculateStatsResponse_TimeSeries_Interval{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CalculateStatsResponse_TimeSeries_Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateStatsResponse_TimeSeries_Interval) ProtoMessage() {}

func (x *CalculateStatsResponse_TimeSeries_Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateStatsResponse_TimeSeries_Interval.ProtoReflect.Descriptor instead.
func (*CalculateStatsResponse_TimeSeries_Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CalculateStatsResponse_TimeSeries_Interval) GetConversationCount() int32 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

// Configuration for Cloud Storage bucket sources.
type IngestConversationsRequest_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud Storage bucket containing source objects.
	BucketUri string `protobuf:"bytes,1,opt,name=bucket_uri,json=bucketUri,proto3" json:"bucket_uri,omitempty"`
	// Optional. Specifies the type of the objects in `bucket_uri`.
	BucketObjectType IngestConversationsRequest_GcsSource_BucketObjectType `protobuf:"varint,2,opt,name=bucket_object_type,json=bucketObjectType,proto3,enum=google.cloud.contactcenterinsights.v1.IngestConversationsRequest_GcsSource_BucketObjectType" json:"bucket_object_type,omitempty"`
	// Optional. The Cloud Storage path to the conversation metadata. Note that:
	// [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in
	//
	//	separate buckets.
	//
	// [3] A source file and its corresponding metadata file must share the same
	// name to
	//
	//	be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
	//	`gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri *string `protobuf:"bytes,3,opt,name=metadata_bucket_uri,json=metadataBucketUri,proto3,oneof" json:"metadata_bucket_uri,omitempty"`
	// Optional. Custom keys to extract as conversation labels from metadata
	// files in `metadata_bucket_uri`. Keys not included in this field will be
	// ignored. Note that there is a limit of 100 labels per conversation.
	CustomMetadataKeys []string `protobuf:"bytes,12,rep,name=custom_metadata_keys,json=customMetadataKeys,proto3" json:"custom_metadata_keys,omitempty"`
}

func (x *IngestConversationsRequest_GcsSource) Reset() {
	*x = IngestConversationsRequest_GcsSource{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsRequest_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_GcsSource) ProtoMessage() {}

func (x *IngestConversationsRequest_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_GcsSource.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 0}
}

func (x *IngestConversationsRequest_GcsSource) GetBucketUri() string {
	if x != nil {
		return x.BucketUri
	}
	return ""
}

func (x *IngestConversationsRequest_GcsSource) GetBucketObjectType() IngestConversationsRequest_GcsSource_BucketObjectType {
	if x != nil {
		return x.BucketObjectType
	}
	return IngestConversationsRequest_GcsSource_BUCKET_OBJECT_TYPE_UNSPECIFIED
}

func (x *IngestConversationsRequest_GcsSource) GetMetadataBucketUri() string {
	if x != nil && x.MetadataBucketUri != nil {
		return *x.MetadataBucketUri
	}
	return ""
}

func (x *IngestConversationsRequest_GcsSource) GetCustomMetadataKeys() []string {
	if x != nil {
		return x.CustomMetadataKeys
	}
	return nil
}

// Configuration for processing transcript objects.
type IngestConversationsRequest_TranscriptObjectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The medium transcript objects represent.
	Medium Conversation_Medium `protobuf:"varint,1,opt,name=medium,proto3,enum=google.cloud.contactcenterinsights.v1.Conversation_Medium" json:"medium,omitempty"`
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) Reset() {
	*x = IngestConversationsRequest_TranscriptObjectConfig{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_TranscriptObjectConfig) ProtoMessage() {}

func (x *IngestConversationsRequest_TranscriptObjectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_TranscriptObjectConfig.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_TranscriptObjectConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 1}
}

func (x *IngestConversationsRequest_TranscriptObjectConfig) GetMedium() Conversation_Medium {
	if x != nil {
		return x.Medium
	}
	return Conversation_MEDIUM_UNSPECIFIED
}

// Configuration that applies to all conversations.
type IngestConversationsRequest_ConversationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. An opaque, user-specified string representing a human agent who
	// handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `protobuf:"bytes,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// Optional. Indicates which of the channels, 1 or 2, contains the agent.
	// Note that this must be set for conversations to be properly displayed and
	// analyzed.
	AgentChannel int32 `protobuf:"varint,2,opt,name=agent_channel,json=agentChannel,proto3" json:"agent_channel,omitempty"`
	// Optional. Indicates which of the channels, 1 or 2, contains the agent.
	// Note that this must be set for conversations to be properly displayed and
	// analyzed.
	CustomerChannel int32 `protobuf:"varint,3,opt,name=customer_channel,json=customerChannel,proto3" json:"customer_channel,omitempty"`
}

func (x *IngestConversationsRequest_ConversationConfig) Reset() {
	*x = IngestConversationsRequest_ConversationConfig{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsRequest_ConversationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsRequest_ConversationConfig) ProtoMessage() {}

func (x *IngestConversationsRequest_ConversationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsRequest_ConversationConfig.ProtoReflect.Descriptor instead.
func (*IngestConversationsRequest_ConversationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{11, 2}
}

func (x *IngestConversationsRequest_ConversationConfig) GetAgentId() string {
	if x != nil {
		return x.AgentId
	}
	return ""
}

func (x *IngestConversationsRequest_ConversationConfig) GetAgentChannel() int32 {
	if x != nil {
		return x.AgentChannel
	}
	return 0
}

func (x *IngestConversationsRequest_ConversationConfig) GetCustomerChannel() int32 {
	if x != nil {
		return x.CustomerChannel
	}
	return 0
}

// Statistics for IngestConversations operation.
type IngestConversationsMetadata_IngestConversationsStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number of objects processed during the ingest operation.
	ProcessedObjectCount int32 `protobuf:"varint,1,opt,name=processed_object_count,json=processedObjectCount,proto3" json:"processed_object_count,omitempty"`
	// Output only. The number of objects skipped because another conversation
	// with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int32 `protobuf:"varint,2,opt,name=duplicates_skipped_count,json=duplicatesSkippedCount,proto3" json:"duplicates_skipped_count,omitempty"`
	// Output only. The number of new conversations added during this ingest
	// operation.
	SuccessfulIngestCount int32 `protobuf:"varint,3,opt,name=successful_ingest_count,json=successfulIngestCount,proto3" json:"successful_ingest_count,omitempty"`
	// Output only. The number of objects which were unable to be ingested due
	// to errors. The errors are populated in the partial_errors field.
	FailedIngestCount int32 `protobuf:"varint,4,opt,name=failed_ingest_count,json=failedIngestCount,proto3" json:"failed_ingest_count,omitempty"`
}

func (x *IngestConversationsMetadata_IngestConversationsStats) Reset() {
	*x = IngestConversationsMetadata_IngestConversationsStats{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngestConversationsMetadata_IngestConversationsStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestConversationsMetadata_IngestConversationsStats) ProtoMessage() {}

func (x *IngestConversationsMetadata_IngestConversationsStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestConversationsMetadata_IngestConversationsStats.ProtoReflect.Descriptor instead.
func (*IngestConversationsMetadata_IngestConversationsStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{12, 0}
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetProcessedObjectCount() int32 {
	if x != nil {
		return x.ProcessedObjectCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetDuplicatesSkippedCount() int32 {
	if x != nil {
		return x.DuplicatesSkippedCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetSuccessfulIngestCount() int32 {
	if x != nil {
		return x.SuccessfulIngestCount
	}
	return 0
}

func (x *IngestConversationsMetadata_IngestConversationsStats) GetFailedIngestCount() int32 {
	if x != nil {
		return x.FailedIngestCount
	}
	return 0
}

// A BigQuery Table Reference.
type ExportInsightsDataRequest_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise,
	// the resource project will be used.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *ExportInsightsDataRequest_BigQueryDestination) Reset() {
	*x = ExportInsightsDataRequest_BigQueryDestination{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportInsightsDataRequest_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportInsightsDataRequest_BigQueryDestination) ProtoMessage() {}

func (x *ExportInsightsDataRequest_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportInsightsDataRequest_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*ExportInsightsDataRequest_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{25, 0}
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ExportInsightsDataRequest_BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

// Google Cloud Storage Object URI to save the issue model to.
type ExportIssueModelRequest_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `gs://<bucket-name>/<object-name>`
	ObjectUri string `protobuf:"bytes,1,opt,name=object_uri,json=objectUri,proto3" json:"object_uri,omitempty"`
}

func (x *ExportIssueModelRequest_GcsDestination) Reset() {
	*x = ExportIssueModelRequest_GcsDestination{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportIssueModelRequest_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIssueModelRequest_GcsDestination) ProtoMessage() {}

func (x *ExportIssueModelRequest_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIssueModelRequest_GcsDestination.ProtoReflect.Descriptor instead.
func (*ExportIssueModelRequest_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{42, 0}
}

func (x *ExportIssueModelRequest_GcsDestination) GetObjectUri() string {
	if x != nil {
		return x.ObjectUri
	}
	return ""
}

// Google Cloud Storage Object URI to get the issue model file from.
type ImportIssueModelRequest_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `gs://<bucket-name>/<object-name>`
	ObjectUri string `protobuf:"bytes,1,opt,name=object_uri,json=objectUri,proto3" json:"object_uri,omitempty"`
}

func (x *ImportIssueModelRequest_GcsSource) Reset() {
	*x = ImportIssueModelRequest_GcsSource{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[131]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportIssueModelRequest_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIssueModelRequest_GcsSource) ProtoMessage() {}

func (x *ImportIssueModelRequest_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[131]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIssueModelRequest_GcsSource.ProtoReflect.Descriptor instead.
func (*ImportIssueModelRequest_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{45, 0}
}

func (x *ImportIssueModelRequest_GcsSource) GetObjectUri() string {
	if x != nil {
		return x.ObjectUri
	}
	return ""
}

// Metadata about the issue dimension.
type Dimension_IssueDimensionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The issue ID.
	IssueId string `protobuf:"bytes,1,opt,name=issue_id,json=issueId,proto3" json:"issue_id,omitempty"`
	// The issue display name.
	IssueDisplayName string `protobuf:"bytes,2,opt,name=issue_display_name,json=issueDisplayName,proto3" json:"issue_display_name,omitempty"`
	// The parent issue model ID.
	IssueModelId string `protobuf:"bytes,3,opt,name=issue_model_id,json=issueModelId,proto3" json:"issue_model_id,omitempty"`
}

func (x *Dimension_IssueDimensionMetadata) Reset() {
	*x = Dimension_IssueDimensionMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[132]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dimension_IssueDimensionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension_IssueDimensionMetadata) ProtoMessage() {}

func (x *Dimension_IssueDimensionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[132]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension_IssueDimensionMetadata.ProtoReflect.Descriptor instead.
func (*Dimension_IssueDimensionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79, 0}
}

func (x *Dimension_IssueDimensionMetadata) GetIssueId() string {
	if x != nil {
		return x.IssueId
	}
	return ""
}

func (x *Dimension_IssueDimensionMetadata) GetIssueDisplayName() string {
	if x != nil {
		return x.IssueDisplayName
	}
	return ""
}

func (x *Dimension_IssueDimensionMetadata) GetIssueModelId() string {
	if x != nil {
		return x.IssueModelId
	}
	return ""
}

// Metadata about the agent dimension.
type Dimension_AgentDimensionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A user-specified string representing the agent.
	AgentId string `protobuf:"bytes,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// Optional. The agent's name
	AgentDisplayName string `protobuf:"bytes,2,opt,name=agent_display_name,json=agentDisplayName,proto3" json:"agent_display_name,omitempty"`
	// Optional. A user-specified string representing the agent's team.
	AgentTeam string `protobuf:"bytes,3,opt,name=agent_team,json=agentTeam,proto3" json:"agent_team,omitempty"`
}

func (x *Dimension_AgentDimensionMetadata) Reset() {
	*x = Dimension_AgentDimensionMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[133]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dimension_AgentDimensionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension_AgentDimensionMetadata) ProtoMessage() {}

func (x *Dimension_AgentDimensionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[133]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension_AgentDimensionMetadata.ProtoReflect.Descriptor instead.
func (*Dimension_AgentDimensionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79, 1}
}

func (x *Dimension_AgentDimensionMetadata) GetAgentId() string {
	if x != nil {
		return x.AgentId
	}
	return ""
}

func (x *Dimension_AgentDimensionMetadata) GetAgentDisplayName() string {
	if x != nil {
		return x.AgentDisplayName
	}
	return ""
}

func (x *Dimension_AgentDimensionMetadata) GetAgentTeam() string {
	if x != nil {
		return x.AgentTeam
	}
	return ""
}

// Metadata about the QA question dimension.
type Dimension_QaQuestionDimensionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The QA scorecard ID.
	QaScorecardId string `protobuf:"bytes,1,opt,name=qa_scorecard_id,json=qaScorecardId,proto3" json:"qa_scorecard_id,omitempty"`
	// Optional. The QA question ID.
	QaQuestionId string `protobuf:"bytes,2,opt,name=qa_question_id,json=qaQuestionId,proto3" json:"qa_question_id,omitempty"`
	// Optional. The full body of the question.
	QuestionBody string `protobuf:"bytes,3,opt,name=question_body,json=questionBody,proto3" json:"question_body,omitempty"`
}

func (x *Dimension_QaQuestionDimensionMetadata) Reset() {
	*x = Dimension_QaQuestionDimensionMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[134]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dimension_QaQuestionDimensionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension_QaQuestionDimensionMetadata) ProtoMessage() {}

func (x *Dimension_QaQuestionDimensionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[134]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension_QaQuestionDimensionMetadata.ProtoReflect.Descriptor instead.
func (*Dimension_QaQuestionDimensionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79, 2}
}

func (x *Dimension_QaQuestionDimensionMetadata) GetQaScorecardId() string {
	if x != nil {
		return x.QaScorecardId
	}
	return ""
}

func (x *Dimension_QaQuestionDimensionMetadata) GetQaQuestionId() string {
	if x != nil {
		return x.QaQuestionId
	}
	return ""
}

func (x *Dimension_QaQuestionDimensionMetadata) GetQuestionBody() string {
	if x != nil {
		return x.QuestionBody
	}
	return ""
}

// Metadata about the QA question-answer dimension.
// This is useful for showing the answer distribution for questions for a
// given scorecard.
type Dimension_QaQuestionAnswerDimensionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The QA scorecard ID.
	QaScorecardId string `protobuf:"bytes,1,opt,name=qa_scorecard_id,json=qaScorecardId,proto3" json:"qa_scorecard_id,omitempty"`
	// Optional. The QA question ID.
	QaQuestionId string `protobuf:"bytes,2,opt,name=qa_question_id,json=qaQuestionId,proto3" json:"qa_question_id,omitempty"`
	// Optional. The full body of the question.
	QuestionBody string `protobuf:"bytes,3,opt,name=question_body,json=questionBody,proto3" json:"question_body,omitempty"`
	// Optional. The full body of the question.
	AnswerValue string `protobuf:"bytes,4,opt,name=answer_value,json=answerValue,proto3" json:"answer_value,omitempty"`
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) Reset() {
	*x = Dimension_QaQuestionAnswerDimensionMetadata{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[135]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension_QaQuestionAnswerDimensionMetadata) ProtoMessage() {}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[135]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension_QaQuestionAnswerDimensionMetadata.ProtoReflect.Descriptor instead.
func (*Dimension_QaQuestionAnswerDimensionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{79, 3}
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) GetQaScorecardId() string {
	if x != nil {
		return x.QaScorecardId
	}
	return ""
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) GetQaQuestionId() string {
	if x != nil {
		return x.QaQuestionId
	}
	return ""
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) GetQuestionBody() string {
	if x != nil {
		return x.QuestionBody
	}
	return ""
}

func (x *Dimension_QaQuestionAnswerDimensionMetadata) GetAnswerValue() string {
	if x != nil {
		return x.AnswerValue
	}
	return ""
}

// A slice contains a total and (if the request specified a time granularity)
// a time series of metric values. Each slice contains a unique combination of
// the cardinality of dimensions from the request.
//
// For example, if the request specifies a single ISSUE dimension and it has a
// cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in
// total), the response will have 2 slices:
//
// * Slice 1 -> dimensions=[Issue 1]
// * Slice 2 -> dimensions=[Issue 2]
type QueryMetricsResponse_Slice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique combination of dimensions that this slice represents.
	Dimensions []*Dimension `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The total metric value. The interval of this data point is
	// [starting create time, ending create time) from the request.
	Total *QueryMetricsResponse_Slice_DataPoint `protobuf:"bytes,2,opt,name=total,proto3" json:"total,omitempty"`
	// A time series of metric values. This is only populated if the request
	// specifies a time granularity other than NONE.
	TimeSeries *QueryMetricsResponse_Slice_TimeSeries `protobuf:"bytes,3,opt,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
}

func (x *QueryMetricsResponse_Slice) Reset() {
	*x = QueryMetricsResponse_Slice{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[136]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse_Slice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse_Slice) ProtoMessage() {}

func (x *QueryMetricsResponse_Slice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[136]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse_Slice.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse_Slice) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81, 0}
}

func (x *QueryMetricsResponse_Slice) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *QueryMetricsResponse_Slice) GetTotal() *QueryMetricsResponse_Slice_DataPoint {
	if x != nil {
		return x.Total
	}
	return nil
}

func (x *QueryMetricsResponse_Slice) GetTimeSeries() *QueryMetricsResponse_Slice_TimeSeries {
	if x != nil {
		return x.TimeSeries
	}
	return nil
}

// A data point contains the metric values mapped to an interval.
type QueryMetricsResponse_Slice_DataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The measure included in this data point.
	//
	// Types that are assignable to Measure:
	//
	//	*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_
	Measure isQueryMetricsResponse_Slice_DataPoint_Measure `protobuf_oneof:"measure"`
	// The interval that this data point represents.
	//
	// * If this is the total data point, the interval is
	// [starting create time, ending create time) from the request.
	// * If this a data point from the time series, the interval is
	// [time, time + time granularity from the request).
	Interval *interval.Interval `protobuf:"bytes,1,opt,name=interval,proto3" json:"interval,omitempty"`
}

func (x *QueryMetricsResponse_Slice_DataPoint) Reset() {
	*x = QueryMetricsResponse_Slice_DataPoint{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[137]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse_Slice_DataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse_Slice_DataPoint) ProtoMessage() {}

func (x *QueryMetricsResponse_Slice_DataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[137]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse_Slice_DataPoint.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse_Slice_DataPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81, 0, 0}
}

func (m *QueryMetricsResponse_Slice_DataPoint) GetMeasure() isQueryMetricsResponse_Slice_DataPoint_Measure {
	if m != nil {
		return m.Measure
	}
	return nil
}

func (x *QueryMetricsResponse_Slice_DataPoint) GetConversationMeasure() *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure {
	if x, ok := x.GetMeasure().(*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_); ok {
		return x.ConversationMeasure
	}
	return nil
}

func (x *QueryMetricsResponse_Slice_DataPoint) GetInterval() *interval.Interval {
	if x != nil {
		return x.Interval
	}
	return nil
}

type isQueryMetricsResponse_Slice_DataPoint_Measure interface {
	isQueryMetricsResponse_Slice_DataPoint_Measure()
}

type QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_ struct {
	// The measure related to conversations.
	ConversationMeasure *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure `protobuf:"bytes,2,opt,name=conversation_measure,json=conversationMeasure,proto3,oneof"`
}

func (*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_) isQueryMetricsResponse_Slice_DataPoint_Measure() {
}

// A time series of metric values.
type QueryMetricsResponse_Slice_TimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data points that make up the time series .
	DataPoints []*QueryMetricsResponse_Slice_DataPoint `protobuf:"bytes,4,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *QueryMetricsResponse_Slice_TimeSeries) Reset() {
	*x = QueryMetricsResponse_Slice_TimeSeries{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[138]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse_Slice_TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse_Slice_TimeSeries) ProtoMessage() {}

func (x *QueryMetricsResponse_Slice_TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[138]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse_Slice_TimeSeries.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse_Slice_TimeSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81, 0, 1}
}

func (x *QueryMetricsResponse_Slice_TimeSeries) GetDataPoints() []*QueryMetricsResponse_Slice_DataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// The measure related to conversations.
type QueryMetricsResponse_Slice_DataPoint_ConversationMeasure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversation count.
	ConversationCount *int32 `protobuf:"varint,1,opt,name=conversation_count,json=conversationCount,proto3,oneof" json:"conversation_count,omitempty"`
	// The average silence percentage.
	AverageSilencePercentage *float32 `protobuf:"fixed32,2,opt,name=average_silence_percentage,json=averageSilencePercentage,proto3,oneof" json:"average_silence_percentage,omitempty"`
	// The average duration.
	AverageDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=average_duration,json=averageDuration,proto3,oneof" json:"average_duration,omitempty"`
	// The average turn count.
	AverageTurnCount *float32 `protobuf:"fixed32,4,opt,name=average_turn_count,json=averageTurnCount,proto3,oneof" json:"average_turn_count,omitempty"`
	// The average agent's sentiment score.
	AverageAgentSentimentScore *float32 `protobuf:"fixed32,5,opt,name=average_agent_sentiment_score,json=averageAgentSentimentScore,proto3,oneof" json:"average_agent_sentiment_score,omitempty"`
	// The average client's sentiment score.
	AverageClientSentimentScore *float32 `protobuf:"fixed32,6,opt,name=average_client_sentiment_score,json=averageClientSentimentScore,proto3,oneof" json:"average_client_sentiment_score,omitempty"`
	// The average customer satisfaction rating.
	AverageCustomerSatisfactionRating *float64 `protobuf:"fixed64,8,opt,name=average_customer_satisfaction_rating,json=averageCustomerSatisfactionRating,proto3,oneof" json:"average_customer_satisfaction_rating,omitempty"`
	// Average QA normalized score.
	// Will exclude 0's in average calculation.
	AverageQaNormalizedScore *float64 `protobuf:"fixed64,7,opt,name=average_qa_normalized_score,json=averageQaNormalizedScore,proto3,oneof" json:"average_qa_normalized_score,omitempty"`
	// Average QA normalized score for all the tags.
	QaTagScores []*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore `protobuf:"bytes,9,rep,name=qa_tag_scores,json=qaTagScores,proto3" json:"qa_tag_scores,omitempty"`
	// Average QA normalized score averaged for questions averaged across
	// all revisions of the parent scorecard.
	// Will be only populated if the request specifies a dimension of
	// QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore *float64 `protobuf:"fixed64,10,opt,name=average_qa_question_normalized_score,json=averageQaQuestionNormalizedScore,proto3,oneof" json:"average_qa_question_normalized_score,omitempty"`
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) Reset() {
	*x = QueryMetricsResponse_Slice_DataPoint_ConversationMeasure{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[139]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) ProtoMessage() {}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[139]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse_Slice_DataPoint_ConversationMeasure.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81, 0, 0, 0}
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetConversationCount() int32 {
	if x != nil && x.ConversationCount != nil {
		return *x.ConversationCount
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageSilencePercentage() float32 {
	if x != nil && x.AverageSilencePercentage != nil {
		return *x.AverageSilencePercentage
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageDuration() *durationpb.Duration {
	if x != nil {
		return x.AverageDuration
	}
	return nil
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageTurnCount() float32 {
	if x != nil && x.AverageTurnCount != nil {
		return *x.AverageTurnCount
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageAgentSentimentScore() float32 {
	if x != nil && x.AverageAgentSentimentScore != nil {
		return *x.AverageAgentSentimentScore
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageClientSentimentScore() float32 {
	if x != nil && x.AverageClientSentimentScore != nil {
		return *x.AverageClientSentimentScore
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageCustomerSatisfactionRating() float64 {
	if x != nil && x.AverageCustomerSatisfactionRating != nil {
		return *x.AverageCustomerSatisfactionRating
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageQaNormalizedScore() float64 {
	if x != nil && x.AverageQaNormalizedScore != nil {
		return *x.AverageQaNormalizedScore
	}
	return 0
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetQaTagScores() []*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore {
	if x != nil {
		return x.QaTagScores
	}
	return nil
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure) GetAverageQaQuestionNormalizedScore() float64 {
	if x != nil && x.AverageQaQuestionNormalizedScore != nil {
		return *x.AverageQaQuestionNormalizedScore
	}
	return 0
}

// Average QA normalized score for the tag.
type QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tag name.
	Tag string `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `protobuf:"fixed64,2,opt,name=average_tag_normalized_score,json=averageTagNormalizedScore,proto3" json:"average_tag_normalized_score,omitempty"`
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) Reset() {
	*x = QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[140]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) ProtoMessage() {}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[140]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore.ProtoReflect.Descriptor instead.
func (*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{81, 0, 0, 0, 0}
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore) GetAverageTagNormalizedScore() float64 {
	if x != nil {
		return x.AverageTagNormalizedScore
	}
	return 0
}

// Contains validation results for a question in the tuning request.
type TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource path of the question whose dataset was
	// evaluated for tuning.
	Question string `protobuf:"bytes,1,opt,name=question,proto3" json:"question,omitempty"`
	// A list of any applicable data validation warnings about the question's
	// feedback labels.
	DatasetValidationWarnings []DatasetValidationWarning `protobuf:"varint,2,rep,packed,name=dataset_validation_warnings,json=datasetValidationWarnings,proto3,enum=google.cloud.contactcenterinsights.v1.DatasetValidationWarning" json:"dataset_validation_warnings,omitempty"`
	// The number of valid feedback labels in the question's dataset.
	ValidFeedbackLabelsCount int32 `protobuf:"varint,3,opt,name=valid_feedback_labels_count,json=validFeedbackLabelsCount,proto3" json:"valid_feedback_labels_count,omitempty"`
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) Reset() {
	*x = TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[141]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) ProtoMessage() {}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[141]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{97, 0}
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) GetDatasetValidationWarnings() []DatasetValidationWarning {
	if x != nil {
		return x.DatasetValidationWarnings
	}
	return nil
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult) GetValidFeedbackLabelsCount() int32 {
	if x != nil {
		return x.ValidFeedbackLabelsCount
	}
	return 0
}

// Contains performance metrics for each QaQuestion in the
// TuneScorecardRevision request.
type TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource path of the question whose dataset was
	// evaluated for tuning.
	Question string `protobuf:"bytes,1,opt,name=question,proto3" json:"question,omitempty"`
	// Output only. The metrics for the question's dataset.
	Metrics *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics `protobuf:"bytes,2,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) Reset() {
	*x = TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[142]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) ProtoMessage() {}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[142]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{97, 1}
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics) GetMetrics() *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Performance metrics for the question's dataset calculated over the tuned
// model.
type TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Accuracy of the question's dataset.
	Accuracy float64 `protobuf:"fixed64,1,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) Reset() {
	*x = TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[143]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) ProtoMessage() {}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[143]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics.ProtoReflect.Descriptor instead.
func (*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{97, 1, 0}
}

func (x *TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics) GetAccuracy() float64 {
	if x != nil {
		return x.Accuracy
	}
	return 0
}

// Google Cloud Storage Object details to get the feedback label file from.
type BulkUploadFeedbackLabelsRequest_GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. File format which will be ingested.
	Format BulkUploadFeedbackLabelsRequest_GcsSource_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest_GcsSource_Format" json:"format,omitempty"`
	// Required. The Google Cloud Storage URI of the file to import.
	// Format: `gs://bucket_name/object_name`
	ObjectUri string `protobuf:"bytes,2,opt,name=object_uri,json=objectUri,proto3" json:"object_uri,omitempty"`
}

func (x *BulkUploadFeedbackLabelsRequest_GcsSource) Reset() {
	*x = BulkUploadFeedbackLabelsRequest_GcsSource{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[144]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkUploadFeedbackLabelsRequest_GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkUploadFeedbackLabelsRequest_GcsSource) ProtoMessage() {}

func (x *BulkUploadFeedbackLabelsRequest_GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[144]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsRequest_GcsSource.ProtoReflect.Descriptor instead.
func (*BulkUploadFeedbackLabelsRequest_GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{113, 0}
}

func (x *BulkUploadFeedbackLabelsRequest_GcsSource) GetFormat() BulkUploadFeedbackLabelsRequest_GcsSource_Format {
	if x != nil {
		return x.Format
	}
	return BulkUploadFeedbackLabelsRequest_GcsSource_FORMAT_UNSPECIFIED
}

func (x *BulkUploadFeedbackLabelsRequest_GcsSource) GetObjectUri() string {
	if x != nil {
		return x.ObjectUri
	}
	return ""
}

// Statistics for BulkUploadFeedbackLabels operation.
type BulkUploadFeedbackLabelsMetadata_UploadStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of objects processed during the upload operation.
	ProcessedObjectCount int32 `protobuf:"varint,1,opt,name=processed_object_count,json=processedObjectCount,proto3" json:"processed_object_count,omitempty"`
	// The number of objects skipped because of failed validation
	FailedValidationCount int32 `protobuf:"varint,2,opt,name=failed_validation_count,json=failedValidationCount,proto3" json:"failed_validation_count,omitempty"`
	// The number of new feedback labels added during this ingest operation.
	SuccessfulUploadCount int32 `protobuf:"varint,3,opt,name=successful_upload_count,json=successfulUploadCount,proto3" json:"successful_upload_count,omitempty"`
}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) Reset() {
	*x = BulkUploadFeedbackLabelsMetadata_UploadStats{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[145]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkUploadFeedbackLabelsMetadata_UploadStats) ProtoMessage() {}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[145]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkUploadFeedbackLabelsMetadata_UploadStats.ProtoReflect.Descriptor instead.
func (*BulkUploadFeedbackLabelsMetadata_UploadStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{115, 0}
}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) GetProcessedObjectCount() int32 {
	if x != nil {
		return x.ProcessedObjectCount
	}
	return 0
}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) GetFailedValidationCount() int32 {
	if x != nil {
		return x.FailedValidationCount
	}
	return 0
}

func (x *BulkUploadFeedbackLabelsMetadata_UploadStats) GetSuccessfulUploadCount() int32 {
	if x != nil {
		return x.SuccessfulUploadCount
	}
	return 0
}

// Google Cloud Storage Object details to write the feedback labels to.
type BulkDownloadFeedbackLabelsRequest_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. File format in which the labels will be exported.
	Format BulkDownloadFeedbackLabelsRequest_GcsDestination_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest_GcsDestination_Format" json:"format,omitempty"`
	// Required. The Google Cloud Storage URI to write the feedback labels to.
	// The file name will be used as a prefix for the files written to the
	// bucket if the output needs to be split across multiple files, otherwise
	// it will be used as is. The file extension will be appended to the file
	// name based on the format selected.
	//
	//	E.g. `gs://bucket_name/object_uri_prefix`
	ObjectUri string `protobuf:"bytes,2,opt,name=object_uri,json=objectUri,proto3" json:"object_uri,omitempty"`
	// Optional. Add whitespace to the JSON file. Makes easier to read, but
	// increases file size. Only applicable for JSON format.
	AddWhitespace bool `protobuf:"varint,3,opt,name=add_whitespace,json=addWhitespace,proto3" json:"add_whitespace,omitempty"`
	// Optional. Always print fields with no presence.
	// This is useful for printing fields that are not set, like implicit 0
	// value or empty lists/maps. Only applicable for JSON format.
	AlwaysPrintEmptyFields bool `protobuf:"varint,4,opt,name=always_print_empty_fields,json=alwaysPrintEmptyFields,proto3" json:"always_print_empty_fields,omitempty"`
	// Optional. The number of records per file. Applicable for either format.
	RecordsPerFileCount int64 `protobuf:"varint,5,opt,name=records_per_file_count,json=recordsPerFileCount,proto3" json:"records_per_file_count,omitempty"`
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) Reset() {
	*x = BulkDownloadFeedbackLabelsRequest_GcsDestination{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[146]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDownloadFeedbackLabelsRequest_GcsDestination) ProtoMessage() {}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[146]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsRequest_GcsDestination.ProtoReflect.Descriptor instead.
func (*BulkDownloadFeedbackLabelsRequest_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{116, 0}
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) GetFormat() BulkDownloadFeedbackLabelsRequest_GcsDestination_Format {
	if x != nil {
		return x.Format
	}
	return BulkDownloadFeedbackLabelsRequest_GcsDestination_FORMAT_UNSPECIFIED
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) GetObjectUri() string {
	if x != nil {
		return x.ObjectUri
	}
	return ""
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) GetAddWhitespace() bool {
	if x != nil {
		return x.AddWhitespace
	}
	return false
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) GetAlwaysPrintEmptyFields() bool {
	if x != nil {
		return x.AlwaysPrintEmptyFields
	}
	return false
}

func (x *BulkDownloadFeedbackLabelsRequest_GcsDestination) GetRecordsPerFileCount() int64 {
	if x != nil {
		return x.RecordsPerFileCount
	}
	return 0
}

// Statistics for BulkDownloadFeedbackLabels operation.
type BulkDownloadFeedbackLabelsMetadata_DownloadStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of objects processed during the download operation.
	ProcessedObjectCount int32 `protobuf:"varint,1,opt,name=processed_object_count,json=processedObjectCount,proto3" json:"processed_object_count,omitempty"`
	// The number of new feedback labels downloaded during this operation.
	// Different from "processed" because some labels might not be downloaded
	// because an error.
	SuccessfulDownloadCount int32 `protobuf:"varint,2,opt,name=successful_download_count,json=successfulDownloadCount,proto3" json:"successful_download_count,omitempty"`
	// Total number of files written to the provided Cloud Storage bucket.
	TotalFilesWritten int32 `protobuf:"varint,3,opt,name=total_files_written,json=totalFilesWritten,proto3" json:"total_files_written,omitempty"`
	// Output only. Full name of the files written to Cloud storage.
	FileNames []string `protobuf:"bytes,4,rep,name=file_names,json=fileNames,proto3" json:"file_names,omitempty"`
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) Reset() {
	*x = BulkDownloadFeedbackLabelsMetadata_DownloadStats{}
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[147]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDownloadFeedbackLabelsMetadata_DownloadStats) ProtoMessage() {}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[147]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDownloadFeedbackLabelsMetadata_DownloadStats.ProtoReflect.Descriptor instead.
func (*BulkDownloadFeedbackLabelsMetadata_DownloadStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP(), []int{118, 0}
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) GetProcessedObjectCount() int32 {
	if x != nil {
		return x.ProcessedObjectCount
	}
	return 0
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) GetSuccessfulDownloadCount() int32 {
	if x != nil {
		return x.SuccessfulDownloadCount
	}
	return 0
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) GetTotalFilesWritten() int32 {
	if x != nil {
		return x.TotalFilesWritten
	}
	return 0
}

func (x *BulkDownloadFeedbackLabelsMetadata_DownloadStats) GetFileNames() []string {
	if x != nil {
		return x.FileNames
	}
	return nil
}

var File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto protoreflect.FileDescriptor

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x76, 0x0a, 0x15, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa2, 0x0c, 0x0a, 0x16, 0x43, 0x61, 0x6c,
	0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x54, 0x75,
	0x72, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x19, 0x73, 0x6d, 0x61, 0x72, 0x74,
	0x5f, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x48,
	0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x17, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x48, 0x69, 0x67,
	0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12,
	0x99, 0x01, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c,
	0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69,
	0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67,
	0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x78, 0x0a, 0x0d, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x13, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x8d, 0x01, 0x0a,
	0x1e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61,
	0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xb5, 0x02, 0x0a,
	0x0a, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x11, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x74,
	0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x4a, 0x0a, 0x1c, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x48, 0x69, 0x67,
	0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x4b, 0x0a, 0x1d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69,
	0x67, 0x68, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3f, 0x0a,
	0x11, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x8c,
	0x01, 0x0a, 0x16, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5c, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xec, 0x02,
	0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x5d, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c,
	0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xe5, 0x01, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0xb1, 0x03, 0x0a, 0x19, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x0d, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa6, 0x03, 0x0a, 0x1a, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x18, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x65, 0x64, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x9e, 0x02, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x59, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb4, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xb6, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x80, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xad, 0x0b, 0x0a, 0x1a, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x94, 0x01, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x01, 0x52, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x85, 0x01,
	0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a,
	0x0d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x0b,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x1a, 0x9d, 0x03, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x8f, 0x01, 0x0a, 0x12, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x13, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x11, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x55,
	0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x51, 0x0a, 0x10,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x43, 0x52, 0x49,
	0x50, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x02, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x1a, 0x71, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x57, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x1a, 0x8e, 0x01, 0x0a, 0x12, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xe7, 0x05, 0x0a, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x9e, 0x01, 0x0a, 0x1a, 0x69, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x69,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0x86, 0x02, 0x0a, 0x18, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x3d, 0x0a, 0x18, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x73, 0x6b,
	0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b,
	0x0a, 0x17, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x69, 0x6e, 0x67,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xbc, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x08,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xbc,
	0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8b, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x15,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa0, 0x02, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x13, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x22, 0xeb, 0x03, 0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38,
	0x0a, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x16, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x1e,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x3e, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x22, 0x92, 0x01, 0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x66, 0x75, 0x6c, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x66, 0x75, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xbb, 0x01, 0x0a, 0x1e, 0x42, 0x75, 0x6c, 0x6b, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e,
	0x6d, 0x61, 0x78, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x22, 0xb1, 0x02, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x21, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf3, 0x04, 0x0a, 0x19,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8a, 0x01, 0x0a, 0x15, 0x62, 0x69,
	0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x7e, 0x0a, 0x11, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44,
	0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x69, 0x0a, 0x13, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5b, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x57, 0x52, 0x49,
	0x54, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44,
	0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xb1, 0x02, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a,
	0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xf2, 0x01, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0xaf, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22,
	0x6f, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x22, 0x63, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf2, 0x01,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf2, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x68, 0x0a, 0x19, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xf6, 0x01, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x5a, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xa5, 0x02, 0x0a,
	0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x78, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a,
	0x34, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x55, 0x72, 0x69, 0x42, 0x0d, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1a, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xe8, 0x01, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xb1, 0x02, 0x0a, 0x17,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x6e, 0x65, 0x77, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x77, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x2f, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x55, 0x72, 0x69, 0x42, 0x08, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x1a, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x18,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x59, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x64, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a,
	0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x06, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x5c, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7b,
	0x0a, 0x1f, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x58, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x84, 0x01, 0x0a, 0x20,
	0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x60, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0xb2, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a, 0x1a,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x69, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x1a,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34,
	0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x1a, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5f, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbd, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x67, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xbc, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d,
	0x0a, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x6a, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x9f, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5a, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0d, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x6b, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x86, 0x01, 0x0a, 0x1f, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x22, 0x0a, 0x20, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc2, 0x02,
	0x0a, 0x20, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x65, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x22, 0x57, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7e,
	0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x05, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96,
	0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5a, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xfe, 0x0c, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x88, 0x01, 0x0a, 0x18, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x16, 0x69, 0x73, 0x73, 0x75, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x88, 0x01, 0x0a,
	0x18, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x16, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x98, 0x01, 0x0a, 0x1e, 0x71, 0x61, 0x5f, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1b, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xab, 0x01, 0x0a, 0x25, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x21, 0x71,
	0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x62, 0x0a, 0x0d, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x1a, 0xee, 0x01, 0x0a, 0x16, 0x49, 0x73, 0x73, 0x75, 0x65, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x4a, 0x0a, 0x08, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x52, 0x07, 0x69, 0x73, 0x73, 0x75, 0x65, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x73, 0x73, 0x75, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0e, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x49, 0x64, 0x1a, 0x8f, 0x01, 0x0a, 0x16, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x1e, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x31, 0x0a, 0x12, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x65, 0x61,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x1a, 0x9f, 0x01, 0x0a, 0x1b, 0x51, 0x61, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x0f, 0x71, 0x61, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0e, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x28, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f, 0x64, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x64, 0x79, 0x1a, 0xcd, 0x01, 0x0a, 0x21, 0x51, 0x61,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x2b, 0x0a, 0x0f, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x71,
	0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0e,
	0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x71, 0x61, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x64,
	0x79, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x0c, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x49,
	0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x53, 0x53,
	0x55, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x45, 0x41, 0x4d, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x51, 0x41, 0x5f, 0x51, 0x55, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
	0x44, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x51, 0x41, 0x5f, 0x51, 0x55, 0x45, 0x53, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10,
	0x05, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x06, 0x42, 0x14,
	0x0a, 0x12, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x88, 0x04, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x75, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61,
	0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x75,
	0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x47, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x50, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0b, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x84, 0x01, 0x0a, 0x0f, 0x54, 0x69, 0x6d,
	0x65, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x20, 0x0a, 0x1c,
	0x54, 0x49, 0x4d, 0x45, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c,
	0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f, 0x55, 0x52, 0x4c, 0x59, 0x10, 0x03, 0x12,
	0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x10, 0x04, 0x12,
	0x11, 0x0a, 0x0d, 0x50, 0x45, 0x52, 0x5f, 0x35, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x53,
	0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x06, 0x22,
	0xab, 0x11, 0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x06,
	0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x52,
	0x06, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x72, 0x6f,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x72, 0x6f,
	0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x88, 0x01, 0x01, 0x1a,
	0xa3, 0x0e, 0x0a, 0x05, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a, 0x05, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x6d,
	0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xf9, 0x0a,
	0x0a, 0x09, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x94, 0x01, 0x0a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x48, 0x00, 0x52, 0x13, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x12, 0x31, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x08, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x1a, 0x96, 0x09, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x32, 0x0a,
	0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x41, 0x0a, 0x1a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x6c,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x18, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52, 0x0f, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x31, 0x0a, 0x12, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x03, 0x52, 0x10, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x54, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x46, 0x0a, 0x1d, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x04, 0x52, 0x1a, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x1e, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x05, 0x52, 0x1b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x24, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x06, 0x52, 0x21, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x53, 0x61, 0x74, 0x69, 0x73, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x61, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x07, 0x52, 0x18, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x51, 0x61, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x8e,
	0x01, 0x0a, 0x0d, 0x71, 0x61, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x2e, 0x51, 0x61, 0x54, 0x61, 0x67, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x52, 0x0b, 0x71, 0x61, 0x54, 0x61, 0x67, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x12,
	0x53, 0x0a, 0x24, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x61, 0x5f, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x48, 0x08, 0x52,
	0x20, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x88, 0x01, 0x01, 0x1a, 0x5f, 0x0a, 0x0a, 0x51, 0x61, 0x54, 0x61, 0x67, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x74, 0x61, 0x67, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x61, 0x67, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x19, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x54, 0x61, 0x67, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1d, 0x0a, 0x1b,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x75, 0x72,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x27, 0x0a, 0x25,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x71, 0x61, 0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x09,
	0x0a, 0x07, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x1a, 0x7a, 0x0a, 0x0a, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x61, 0x63, 0x72, 0x6f, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x22, 0x16, 0x0a,
	0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xf7, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x71,
	0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x0e, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22,
	0x63, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x97, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0c, 0x71,
	0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x66, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe6, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x71, 0x61, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x49,
	0x64, 0x22, 0x65, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32,
	0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x83, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xa7, 0x02, 0x0a, 0x20, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x73, 0x0a, 0x15, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x13, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x18, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x71, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0x75, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x1e, 0x54,
	0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x21,
	0x0a, 0x1f, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xa8, 0x0a, 0x0a, 0x1f, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e,
	0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xc1, 0x01, 0x0a, 0x26, 0x71, 0x61,
	0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x22, 0x71, 0x61, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0xb6, 0x01,
	0x0a, 0x22, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x74, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61,
	0x74, 0x69, 0x6f, 0x1a, 0xb8, 0x02, 0x0a, 0x21, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x53, 0x0a, 0x08, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7f,
	0x0a, 0x1b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x52, 0x19, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3d, 0x0a, 0x1b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xab,
	0x02, 0x0a, 0x1e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x53, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8c, 0x01, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x25, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x22, 0x78, 0x0a, 0x20,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x22, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x3a, 0x0a, 0x38, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0d, 0x71, 0x61,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x0c, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd6, 0x01, 0x0a, 0x1f,
	0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0xbc, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70, 0x0a, 0x16, 0x71, 0x61, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x82, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x0e, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x66, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0xd1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0e, 0x66, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x69, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01,
	0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0e,
	0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x6c, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa6, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c,
	0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0f, 0x66, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0e, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe8,
	0x03, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x71, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x1a, 0xda, 0x01, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x74, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x22, 0x33, 0x0a, 0x06, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x43, 0x53, 0x56, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x22, 0x0a, 0x20, 0x42, 0x75, 0x6c,
	0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf5, 0x04,
	0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x65, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x12, 0x7b, 0x0a, 0x0c, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a,
	0xb3, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x34, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x14, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a,
	0x17, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x75, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15,
	0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xbd, 0x08, 0x0a, 0x21, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x0f,
	0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x31, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x13, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x18, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x15, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x49, 0x64, 0x1a, 0x8c, 0x03, 0x0a, 0x0e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7b, 0x0a, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a,
	0x0e, 0x61, 0x64, 0x64, 0x5f, 0x77, 0x68, 0x69, 0x74, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61, 0x64, 0x64, 0x57,
	0x68, 0x69, 0x74, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x19, 0x61, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x38, 0x0a, 0x16, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x50, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x33, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a,
	0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x5c, 0x0a, 0x11, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x1f, 0x46, 0x45, 0x45, 0x44, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x41, 0x49,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x24, 0x0a, 0x22, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa4, 0x05, 0x0a, 0x22,
	0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x67, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x0e, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0xd5, 0x01, 0x0a, 0x0d, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c,
	0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e,
	0x0a, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x77, 0x72,
	0x69, 0x74, 0x74, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x22,
	0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x2a, 0x4a, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52,
	0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x32, 0xc8,
	0x88, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0xfa, 0x01, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70,
	0xca, 0x41, 0x2a, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0xfc, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f,
	0xda, 0x41, 0x18, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x0c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32,
	0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfe, 0x01, 0x0a, 0x0e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x01, 0xca, 0x41, 0x2b, 0x0a,
	0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x3a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x3c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x47,
	0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0xb3, 0x01, 0x0a,
	0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb7, 0x02, 0x0a, 0x18, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x20, 0x42, 0x75,
	0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20,
	0x42, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x12, 0x9e, 0x02, 0x0a,
	0x17, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c,
	0x01, 0xca, 0x41, 0x42, 0x0a, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22,
	0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x83, 0x02,
	0x0a, 0x13, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x3a, 0x0a, 0x1b, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x69, 0x6e, 0x67,
	0x65, 0x73, 0x74, 0x12, 0xfe, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0xca, 0x41,
	0x38, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0xf6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x0a,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a,
	0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x2f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xf1, 0x01,
	0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x6a, 0xda, 0x41, 0x17, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41,
	0x31, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xf2, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xfd, 0x01, 0x0a, 0x12, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01,
	0xca, 0x41, 0x38, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1a, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xf2, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x34, 0x0a, 0x18,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a,
	0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xf5, 0x01, 0x0a, 0x10, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81,
	0x01, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0xb9, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc,
	0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0xd9, 0x01,
	0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x22, 0x61, 0xda, 0x41, 0x11, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x47, 0x3a, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x32, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x01, 0x0a, 0x0b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x92, 0x02, 0x0a, 0x18, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0xf2, 0x01, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x62, 0xda, 0x41, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12,
	0xcb, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0xb3,
	0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34,
	0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x22, 0x76, 0xda, 0x41, 0x1a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x0e, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x02,
	0x0a, 0x0e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb3, 0x01,
	0xda, 0x41, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xa1, 0x01, 0x5a, 0x5b, 0x12, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x53, 0x65, 0x74, 0x2f, 0x2a, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x0e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x5c, 0xda, 0x41,
	0x14, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x08, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x5f, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65,
	0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c,
	0x65, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0xff, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x72,
	0xda, 0x41, 0x19, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x50, 0x3a, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x7d, 0x12, 0xb3, 0x02, 0x0a, 0x18, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x20,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x20, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x7d, 0x3a,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x0a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77,
	0x22, 0x45, 0xda, 0x41, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x69, 0x65, 0x77,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x29, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xba, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xc4,
	0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x69, 0x65, 0x77, 0x22, 0x4f, 0xda, 0x41, 0x10, 0x76, 0x69, 0x65, 0x77, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x32, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x2a, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb7, 0x02, 0x0a, 0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcb, 0x01, 0xca,
	0x41, 0x2c, 0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x95, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5c, 0x3a, 0x01, 0x2a, 0x22, 0x57, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69,
	0x65, 0x77, 0x53, 0x65, 0x74, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x8c, 0x02, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x61,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x84, 0x01, 0xda, 0x41, 0x22, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71,
	0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x71, 0x61, 0x5f, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59,
	0x3a, 0x0b, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x61,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85,
	0x01, 0xda, 0x41, 0x17, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x65, 0x3a, 0x0b, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x56,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x71, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x59, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51,
	0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x71, 0x61, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xf6,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x22, 0x6c, 0xda, 0x41, 0x23, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x2c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x51,
	0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x22, 0x3f, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf8, 0x01,
	0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x22, 0x6e, 0xda, 0x41, 0x18, 0x71, 0x61, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0c, 0x71, 0x61, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x12, 0xb6, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x93, 0x01, 0xda, 0x41, 0x35, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x15, 0x71, 0x61, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc6, 0x02, 0x0a, 0x17, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc4, 0x01, 0xca, 0x41, 0x42, 0x0a, 0x1f, 0x54, 0x75,
	0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x54,
	0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x75, 0x6e, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xf0, 0x01,
	0x0a, 0x19, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x12, 0xf6, 0x01, 0x0a, 0x1b, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x51, 0x61, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a,
	0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xc9, 0x01, 0x0a, 0x19, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72,
	0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51,
	0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x61, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x95, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x22, 0x84, 0x01, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2c, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x0e, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0xee, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0xdb, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x86, 0x01, 0xda, 0x41, 0x1a,
	0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63,
	0x3a, 0x0e, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x32, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xee, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x9b, 0x02, 0x0a, 0x18, 0x42,
	0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97,
	0x01, 0xca, 0x41, 0x44, 0x0a, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x42, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x62, 0x75, 0x6c, 0x6b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0xa5, 0x02, 0x0a, 0x1a, 0x42, 0x75, 0x6c,
	0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x9d, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x22, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x42, 0x75, 0x6c, 0x6b,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a,
	0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x1a, 0x58, 0xca, 0x41, 0x24, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa5, 0x02, 0x0a, 0x29, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70, 0x62, 0x3b,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce sync.Once
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc
)

func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescGZIP() []byte {
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescOnce.Do(func() {
		file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData)
	})
	return file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDescData
}

var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes = make([]protoimpl.MessageInfo, 148)
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = []any{
	(ConversationView)(0), // 0: google.cloud.contactcenterinsights.v1.ConversationView
	(IngestConversationsRequest_GcsSource_BucketObjectType)(0),   // 1: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType
	(ExportInsightsDataRequest_WriteDisposition)(0),              // 2: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
	(Dimension_DimensionKey)(0),                                  // 3: google.cloud.contactcenterinsights.v1.Dimension.DimensionKey
	(QueryMetricsRequest_TimeGranularity)(0),                     // 4: google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
	(BulkUploadFeedbackLabelsRequest_GcsSource_Format)(0),        // 5: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
	(BulkDownloadFeedbackLabelsRequest_FeedbackLabelType)(0),     // 6: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType
	(BulkDownloadFeedbackLabelsRequest_GcsDestination_Format)(0), // 7: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format
	(*CalculateStatsRequest)(nil),                                // 8: google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	(*CalculateStatsResponse)(nil),                               // 9: google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	(*CreateAnalysisOperationMetadata)(nil),                      // 10: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata
	(*CreateConversationRequest)(nil),                            // 11: google.cloud.contactcenterinsights.v1.CreateConversationRequest
	(*UploadConversationRequest)(nil),                            // 12: google.cloud.contactcenterinsights.v1.UploadConversationRequest
	(*UploadConversationMetadata)(nil),                           // 13: google.cloud.contactcenterinsights.v1.UploadConversationMetadata
	(*ListConversationsRequest)(nil),                             // 14: google.cloud.contactcenterinsights.v1.ListConversationsRequest
	(*ListConversationsResponse)(nil),                            // 15: google.cloud.contactcenterinsights.v1.ListConversationsResponse
	(*GetConversationRequest)(nil),                               // 16: google.cloud.contactcenterinsights.v1.GetConversationRequest
	(*UpdateConversationRequest)(nil),                            // 17: google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	(*DeleteConversationRequest)(nil),                            // 18: google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	(*IngestConversationsRequest)(nil),                           // 19: google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	(*IngestConversationsMetadata)(nil),                          // 20: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
	(*IngestConversationsResponse)(nil),                          // 21: google.cloud.contactcenterinsights.v1.IngestConversationsResponse
	(*CreateAnalysisRequest)(nil),                                // 22: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	(*ListAnalysesRequest)(nil),                                  // 23: google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	(*ListAnalysesResponse)(nil),                                 // 24: google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	(*GetAnalysisRequest)(nil),                                   // 25: google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	(*DeleteAnalysisRequest)(nil),                                // 26: google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	(*BulkAnalyzeConversationsRequest)(nil),                      // 27: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	(*BulkAnalyzeConversationsMetadata)(nil),                     // 28: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
	(*BulkAnalyzeConversationsResponse)(nil),                     // 29: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsResponse
	(*BulkDeleteConversationsRequest)(nil),                       // 30: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	(*BulkDeleteConversationsMetadata)(nil),                      // 31: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata
	(*BulkDeleteConversationsResponse)(nil),                      // 32: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsResponse
	(*ExportInsightsDataRequest)(nil),                            // 33: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	(*ExportInsightsDataMetadata)(nil),                           // 34: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata
	(*ExportInsightsDataResponse)(nil),                           // 35: google.cloud.contactcenterinsights.v1.ExportInsightsDataResponse
	(*CreateIssueModelRequest)(nil),                              // 36: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	(*CreateIssueModelMetadata)(nil),                             // 37: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata
	(*UpdateIssueModelRequest)(nil),                              // 38: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	(*ListIssueModelsRequest)(nil),                               // 39: google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	(*ListIssueModelsResponse)(nil),                              // 40: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	(*GetIssueModelRequest)(nil),                                 // 41: google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	(*DeleteIssueModelRequest)(nil),                              // 42: google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	(*DeleteIssueModelMetadata)(nil),                             // 43: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata
	(*DeployIssueModelRequest)(nil),                              // 44: google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	(*DeployIssueModelResponse)(nil),                             // 45: google.cloud.contactcenterinsights.v1.DeployIssueModelResponse
	(*DeployIssueModelMetadata)(nil),                             // 46: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata
	(*UndeployIssueModelRequest)(nil),                            // 47: google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	(*UndeployIssueModelResponse)(nil),                           // 48: google.cloud.contactcenterinsights.v1.UndeployIssueModelResponse
	(*UndeployIssueModelMetadata)(nil),                           // 49: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata
	(*ExportIssueModelRequest)(nil),                              // 50: google.cloud.contactcenterinsights.v1.ExportIssueModelRequest
	(*ExportIssueModelResponse)(nil),                             // 51: google.cloud.contactcenterinsights.v1.ExportIssueModelResponse
	(*ExportIssueModelMetadata)(nil),                             // 52: google.cloud.contactcenterinsights.v1.ExportIssueModelMetadata
	(*ImportIssueModelRequest)(nil),                              // 53: google.cloud.contactcenterinsights.v1.ImportIssueModelRequest
	(*ImportIssueModelResponse)(nil),                             // 54: google.cloud.contactcenterinsights.v1.ImportIssueModelResponse
	(*ImportIssueModelMetadata)(nil),                             // 55: google.cloud.contactcenterinsights.v1.ImportIssueModelMetadata
	(*GetIssueRequest)(nil),                                      // 56: google.cloud.contactcenterinsights.v1.GetIssueRequest
	(*ListIssuesRequest)(nil),                                    // 57: google.cloud.contactcenterinsights.v1.ListIssuesRequest
	(*ListIssuesResponse)(nil),                                   // 58: google.cloud.contactcenterinsights.v1.ListIssuesResponse
	(*UpdateIssueRequest)(nil),                                   // 59: google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	(*DeleteIssueRequest)(nil),                                   // 60: google.cloud.contactcenterinsights.v1.DeleteIssueRequest
	(*CalculateIssueModelStatsRequest)(nil),                      // 61: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	(*CalculateIssueModelStatsResponse)(nil),                     // 62: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	(*CreatePhraseMatcherRequest)(nil),                           // 63: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	(*ListPhraseMatchersRequest)(nil),                            // 64: google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	(*ListPhraseMatchersResponse)(nil),                           // 65: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	(*GetPhraseMatcherRequest)(nil),                              // 66: google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	(*DeletePhraseMatcherRequest)(nil),                           // 67: google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	(*UpdatePhraseMatcherRequest)(nil),                           // 68: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest
	(*GetSettingsRequest)(nil),                                   // 69: google.cloud.contactcenterinsights.v1.GetSettingsRequest
	(*UpdateSettingsRequest)(nil),                                // 70: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	(*CreateAnalysisRuleRequest)(nil),                            // 71: google.cloud.contactcenterinsights.v1.CreateAnalysisRuleRequest
	(*GetAnalysisRuleRequest)(nil),                               // 72: google.cloud.contactcenterinsights.v1.GetAnalysisRuleRequest
	(*UpdateAnalysisRuleRequest)(nil),                            // 73: google.cloud.contactcenterinsights.v1.UpdateAnalysisRuleRequest
	(*DeleteAnalysisRuleRequest)(nil),                            // 74: google.cloud.contactcenterinsights.v1.DeleteAnalysisRuleRequest
	(*ListAnalysisRulesRequest)(nil),                             // 75: google.cloud.contactcenterinsights.v1.ListAnalysisRulesRequest
	(*ListAnalysisRulesResponse)(nil),                            // 76: google.cloud.contactcenterinsights.v1.ListAnalysisRulesResponse
	(*GetEncryptionSpecRequest)(nil),                             // 77: google.cloud.contactcenterinsights.v1.GetEncryptionSpecRequest
	(*InitializeEncryptionSpecRequest)(nil),                      // 78: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecRequest
	(*InitializeEncryptionSpecResponse)(nil),                     // 79: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecResponse
	(*InitializeEncryptionSpecMetadata)(nil),                     // 80: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata
	(*CreateViewRequest)(nil),                                    // 81: google.cloud.contactcenterinsights.v1.CreateViewRequest
	(*GetViewRequest)(nil),                                       // 82: google.cloud.contactcenterinsights.v1.GetViewRequest
	(*ListViewsRequest)(nil),                                     // 83: google.cloud.contactcenterinsights.v1.ListViewsRequest
	(*ListViewsResponse)(nil),                                    // 84: google.cloud.contactcenterinsights.v1.ListViewsResponse
	(*UpdateViewRequest)(nil),                                    // 85: google.cloud.contactcenterinsights.v1.UpdateViewRequest
	(*DeleteViewRequest)(nil),                                    // 86: google.cloud.contactcenterinsights.v1.DeleteViewRequest
	(*Dimension)(nil),                                            // 87: google.cloud.contactcenterinsights.v1.Dimension
	(*QueryMetricsRequest)(nil),                                  // 88: google.cloud.contactcenterinsights.v1.QueryMetricsRequest
	(*QueryMetricsResponse)(nil),                                 // 89: google.cloud.contactcenterinsights.v1.QueryMetricsResponse
	(*QueryMetricsMetadata)(nil),                                 // 90: google.cloud.contactcenterinsights.v1.QueryMetricsMetadata
	(*CreateQaQuestionRequest)(nil),                              // 91: google.cloud.contactcenterinsights.v1.CreateQaQuestionRequest
	(*GetQaQuestionRequest)(nil),                                 // 92: google.cloud.contactcenterinsights.v1.GetQaQuestionRequest
	(*ListQaQuestionsRequest)(nil),                               // 93: google.cloud.contactcenterinsights.v1.ListQaQuestionsRequest
	(*ListQaQuestionsResponse)(nil),                              // 94: google.cloud.contactcenterinsights.v1.ListQaQuestionsResponse
	(*UpdateQaQuestionRequest)(nil),                              // 95: google.cloud.contactcenterinsights.v1.UpdateQaQuestionRequest
	(*DeleteQaQuestionRequest)(nil),                              // 96: google.cloud.contactcenterinsights.v1.DeleteQaQuestionRequest
	(*CreateQaScorecardRequest)(nil),                             // 97: google.cloud.contactcenterinsights.v1.CreateQaScorecardRequest
	(*GetQaScorecardRequest)(nil),                                // 98: google.cloud.contactcenterinsights.v1.GetQaScorecardRequest
	(*UpdateQaScorecardRequest)(nil),                             // 99: google.cloud.contactcenterinsights.v1.UpdateQaScorecardRequest
	(*DeleteQaScorecardRequest)(nil),                             // 100: google.cloud.contactcenterinsights.v1.DeleteQaScorecardRequest
	(*CreateQaScorecardRevisionRequest)(nil),                     // 101: google.cloud.contactcenterinsights.v1.CreateQaScorecardRevisionRequest
	(*GetQaScorecardRevisionRequest)(nil),                        // 102: google.cloud.contactcenterinsights.v1.GetQaScorecardRevisionRequest
	(*TuneQaScorecardRevisionRequest)(nil),                       // 103: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
	(*TuneQaScorecardRevisionResponse)(nil),                      // 104: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionResponse
	(*TuneQaScorecardRevisionMetadata)(nil),                      // 105: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
	(*DeployQaScorecardRevisionRequest)(nil),                     // 106: google.cloud.contactcenterinsights.v1.DeployQaScorecardRevisionRequest
	(*UndeployQaScorecardRevisionRequest)(nil),                   // 107: google.cloud.contactcenterinsights.v1.UndeployQaScorecardRevisionRequest
	(*DeleteQaScorecardRevisionRequest)(nil),                     // 108: google.cloud.contactcenterinsights.v1.DeleteQaScorecardRevisionRequest
	(*ListQaScorecardsRequest)(nil),                              // 109: google.cloud.contactcenterinsights.v1.ListQaScorecardsRequest
	(*ListQaScorecardsResponse)(nil),                             // 110: google.cloud.contactcenterinsights.v1.ListQaScorecardsResponse
	(*ListQaScorecardRevisionsRequest)(nil),                      // 111: google.cloud.contactcenterinsights.v1.ListQaScorecardRevisionsRequest
	(*ListQaScorecardRevisionsResponse)(nil),                     // 112: google.cloud.contactcenterinsights.v1.ListQaScorecardRevisionsResponse
	(*CreateFeedbackLabelRequest)(nil),                           // 113: google.cloud.contactcenterinsights.v1.CreateFeedbackLabelRequest
	(*ListFeedbackLabelsRequest)(nil),                            // 114: google.cloud.contactcenterinsights.v1.ListFeedbackLabelsRequest
	(*ListFeedbackLabelsResponse)(nil),                           // 115: google.cloud.contactcenterinsights.v1.ListFeedbackLabelsResponse
	(*GetFeedbackLabelRequest)(nil),                              // 116: google.cloud.contactcenterinsights.v1.GetFeedbackLabelRequest
	(*UpdateFeedbackLabelRequest)(nil),                           // 117: google.cloud.contactcenterinsights.v1.UpdateFeedbackLabelRequest
	(*DeleteFeedbackLabelRequest)(nil),                           // 118: google.cloud.contactcenterinsights.v1.DeleteFeedbackLabelRequest
	(*ListAllFeedbackLabelsRequest)(nil),                         // 119: google.cloud.contactcenterinsights.v1.ListAllFeedbackLabelsRequest
	(*ListAllFeedbackLabelsResponse)(nil),                        // 120: google.cloud.contactcenterinsights.v1.ListAllFeedbackLabelsResponse
	(*BulkUploadFeedbackLabelsRequest)(nil),                      // 121: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
	(*BulkUploadFeedbackLabelsResponse)(nil),                     // 122: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsResponse
	(*BulkUploadFeedbackLabelsMetadata)(nil),                     // 123: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
	(*BulkDownloadFeedbackLabelsRequest)(nil),                    // 124: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
	(*BulkDownloadFeedbackLabelsResponse)(nil),                   // 125: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsResponse
	(*BulkDownloadFeedbackLabelsMetadata)(nil),                   // 126: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
	(*CalculateStatsResponse_TimeSeries)(nil),                    // 127: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	nil, // 128: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	nil, // 129: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	nil, // 130: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	nil, // 131: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry
	(*CalculateStatsResponse_TimeSeries_Interval)(nil),                             // 132: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	(*IngestConversationsRequest_GcsSource)(nil),                                   // 133: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
	(*IngestConversationsRequest_TranscriptObjectConfig)(nil),                      // 134: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
	(*IngestConversationsRequest_ConversationConfig)(nil),                          // 135: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
	(*IngestConversationsMetadata_IngestConversationsStats)(nil),                   // 136: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats
	(*ExportInsightsDataRequest_BigQueryDestination)(nil),                          // 137: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	(*ExportIssueModelRequest_GcsDestination)(nil),                                 // 138: google.cloud.contactcenterinsights.v1.ExportIssueModelRequest.GcsDestination
	(*ImportIssueModelRequest_GcsSource)(nil),                                      // 139: google.cloud.contactcenterinsights.v1.ImportIssueModelRequest.GcsSource
	(*Dimension_IssueDimensionMetadata)(nil),                                       // 140: google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
	(*Dimension_AgentDimensionMetadata)(nil),                                       // 141: google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
	(*Dimension_QaQuestionDimensionMetadata)(nil),                                  // 142: google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
	(*Dimension_QaQuestionAnswerDimensionMetadata)(nil),                            // 143: google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
	(*QueryMetricsResponse_Slice)(nil),                                             // 144: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
	(*QueryMetricsResponse_Slice_DataPoint)(nil),                                   // 145: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
	(*QueryMetricsResponse_Slice_TimeSeries)(nil),                                  // 146: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
	(*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure)(nil),               // 147: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure
	(*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore)(nil),    // 148: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore
	(*TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult)(nil),      // 149: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult
	(*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics)(nil),         // 150: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics
	(*TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics)(nil), // 151: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics
	(*BulkUploadFeedbackLabelsRequest_GcsSource)(nil),                              // 152: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
	(*BulkUploadFeedbackLabelsMetadata_UploadStats)(nil),                           // 153: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
	(*BulkDownloadFeedbackLabelsRequest_GcsDestination)(nil),                       // 154: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
	(*BulkDownloadFeedbackLabelsMetadata_DownloadStats)(nil),                       // 155: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
	(*durationpb.Duration)(nil),                                                    // 156: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                                                  // 157: google.protobuf.Timestamp
	(*AnnotatorSelector)(nil),                                                      // 158: google.cloud.contactcenterinsights.v1.AnnotatorSelector
	(*Conversation)(nil),                                                           // 159: google.cloud.contactcenterinsights.v1.Conversation
	(*RedactionConfig)(nil),                                                        // 160: google.cloud.contactcenterinsights.v1.RedactionConfig
	(*SpeechConfig)(nil),                                                           // 161: google.cloud.contactcenterinsights.v1.SpeechConfig
	(*fieldmaskpb.FieldMask)(nil),                                                  // 162: google.protobuf.FieldMask
	(*status.Status)(nil),                                                          // 163: google.rpc.Status
	(*Analysis)(nil),                                                               // 164: google.cloud.contactcenterinsights.v1.Analysis
	(*IssueModel)(nil),                                                             // 165: google.cloud.contactcenterinsights.v1.IssueModel
	(*Issue)(nil),                                                                  // 166: google.cloud.contactcenterinsights.v1.Issue
	(*IssueModelLabelStats)(nil),                                                   // 167: google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	(*PhraseMatcher)(nil),                                                          // 168: google.cloud.contactcenterinsights.v1.PhraseMatcher
	(*Settings)(nil),                                                               // 169: google.cloud.contactcenterinsights.v1.Settings
	(*AnalysisRule)(nil),                                                           // 170: google.cloud.contactcenterinsights.v1.AnalysisRule
	(*EncryptionSpec)(nil),                                                         // 171: google.cloud.contactcenterinsights.v1.EncryptionSpec
	(*View)(nil),                                                                   // 172: google.cloud.contactcenterinsights.v1.View
	(*QaQuestion)(nil),                                                             // 173: google.cloud.contactcenterinsights.v1.QaQuestion
	(*QaScorecard)(nil),                                                            // 174: google.cloud.contactcenterinsights.v1.QaScorecard
	(*QaScorecardRevision)(nil),                                                    // 175: google.cloud.contactcenterinsights.v1.QaScorecardRevision
	(*FeedbackLabel)(nil),                                                          // 176: google.cloud.contactcenterinsights.v1.FeedbackLabel
	(*IssueModelLabelStats_IssueStats)(nil),                                        // 177: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	(Conversation_Medium)(0),                                                       // 178: google.cloud.contactcenterinsights.v1.Conversation.Medium
	(*interval.Interval)(nil),                                                      // 179: google.type.Interval
	(DatasetValidationWarning)(0),                                                  // 180: google.cloud.contactcenterinsights.v1.DatasetValidationWarning
	(*longrunningpb.Operation)(nil),                                                // 181: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                                          // 182: google.protobuf.Empty
}
var file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = []int32{
	156, // 0: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.average_duration:type_name -> google.protobuf.Duration
	128, // 1: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.smart_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.SmartHighlighterMatchesEntry
	129, // 2: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.custom_highlighter_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.CustomHighlighterMatchesEntry
	130, // 3: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.issue_matches:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesEntry
	131, // 4: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.issue_matches_stats:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry
	127, // 5: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.conversation_count_time_series:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
	157, // 6: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 7: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	158, // 8: google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata.annotator_selector:type_name -> google.cloud.contactcenterinsights.v1.AnnotatorSelector
	159, // 9: google.cloud.contactcenterinsights.v1.CreateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	159, // 10: google.cloud.contactcenterinsights.v1.UploadConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	160, // 11: google.cloud.contactcenterinsights.v1.UploadConversationRequest.redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	161, // 12: google.cloud.contactcenterinsights.v1.UploadConversationRequest.speech_config:type_name -> google.cloud.contactcenterinsights.v1.SpeechConfig
	157, // 13: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 14: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.end_time:type_name -> google.protobuf.Timestamp
	12,  // 15: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.UploadConversationRequest
	160, // 16: google.cloud.contactcenterinsights.v1.UploadConversationMetadata.applied_redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	0,   // 17: google.cloud.contactcenterinsights.v1.ListConversationsRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	159, // 18: google.cloud.contactcenterinsights.v1.ListConversationsResponse.conversations:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	0,   // 19: google.cloud.contactcenterinsights.v1.GetConversationRequest.view:type_name -> google.cloud.contactcenterinsights.v1.ConversationView
	159, // 20: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.conversation:type_name -> google.cloud.contactcenterinsights.v1.Conversation
	162, // 21: google.cloud.contactcenterinsights.v1.UpdateConversationRequest.update_mask:type_name -> google.protobuf.FieldMask
	133, // 22: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.gcs_source:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
	134, // 23: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.transcript_object_config:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
	135, // 24: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.conversation_config:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
	160, // 25: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.redaction_config:type_name -> google.cloud.contactcenterinsights.v1.RedactionConfig
	161, // 26: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.speech_config:type_name -> google.cloud.contactcenterinsights.v1.SpeechConfig
	157, // 27: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 28: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	19,  // 29: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	163, // 30: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	136, // 31: google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.ingest_conversations_stats:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats
	164, // 32: google.cloud.contactcenterinsights.v1.CreateAnalysisRequest.analysis:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	164, // 33: google.cloud.contactcenterinsights.v1.ListAnalysesResponse.analyses:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	158, // 34: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.annotator_selector:type_name -> google.cloud.contactcenterinsights.v1.AnnotatorSelector
	157, // 35: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 36: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	27,  // 37: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	163, // 38: google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	157, // 39: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 40: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.end_time:type_name -> google.protobuf.Timestamp
	30,  // 41: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	163, // 42: google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata.partial_errors:type_name -> google.rpc.Status
	137, // 43: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.big_query_destination:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
	2,   // 44: google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.write_disposition:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
	157, // 45: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 46: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.end_time:type_name -> google.protobuf.Timestamp
	33,  // 47: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	163, // 48: google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata.partial_errors:type_name -> google.rpc.Status
	165, // 49: google.cloud.contactcenterinsights.v1.CreateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	157, // 50: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 51: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	36,  // 52: google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	165, // 53: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.issue_model:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	162, // 54: google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest.update_mask:type_name -> google.protobuf.FieldMask
	165, // 55: google.cloud.contactcenterinsights.v1.ListIssueModelsResponse.issue_models:type_name -> google.cloud.contactcenterinsights.v1.IssueModel
	157, // 56: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 57: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	42,  // 58: google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	157, // 59: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 60: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	44,  // 61: google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	157, // 62: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 63: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	47,  // 64: google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	138, // 65: google.cloud.contactcenterinsights.v1.ExportIssueModelRequest.gcs_destination:type_name -> google.cloud.contactcenterinsights.v1.ExportIssueModelRequest.GcsDestination
	157, // 66: google.cloud.contactcenterinsights.v1.ExportIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 67: google.cloud.contactcenterinsights.v1.ExportIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	50,  // 68: google.cloud.contactcenterinsights.v1.ExportIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.ExportIssueModelRequest
	139, // 69: google.cloud.contactcenterinsights.v1.ImportIssueModelRequest.gcs_source:type_name -> google.cloud.contactcenterinsights.v1.ImportIssueModelRequest.GcsSource
	157, // 70: google.cloud.contactcenterinsights.v1.ImportIssueModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 71: google.cloud.contactcenterinsights.v1.ImportIssueModelMetadata.end_time:type_name -> google.protobuf.Timestamp
	53,  // 72: google.cloud.contactcenterinsights.v1.ImportIssueModelMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.ImportIssueModelRequest
	166, // 73: google.cloud.contactcenterinsights.v1.ListIssuesResponse.issues:type_name -> google.cloud.contactcenterinsights.v1.Issue
	166, // 74: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.issue:type_name -> google.cloud.contactcenterinsights.v1.Issue
	162, // 75: google.cloud.contactcenterinsights.v1.UpdateIssueRequest.update_mask:type_name -> google.protobuf.FieldMask
	167, // 76: google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse.current_stats:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	168, // 77: google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest.phrase_matcher:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	168, // 78: google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse.phrase_matchers:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	168, // 79: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest.phrase_matcher:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	162, // 80: google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest.update_mask:type_name -> google.protobuf.FieldMask
	169, // 81: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.settings:type_name -> google.cloud.contactcenterinsights.v1.Settings
	162, // 82: google.cloud.contactcenterinsights.v1.UpdateSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	170, // 83: google.cloud.contactcenterinsights.v1.CreateAnalysisRuleRequest.analysis_rule:type_name -> google.cloud.contactcenterinsights.v1.AnalysisRule
	170, // 84: google.cloud.contactcenterinsights.v1.UpdateAnalysisRuleRequest.analysis_rule:type_name -> google.cloud.contactcenterinsights.v1.AnalysisRule
	162, // 85: google.cloud.contactcenterinsights.v1.UpdateAnalysisRuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	170, // 86: google.cloud.contactcenterinsights.v1.ListAnalysisRulesResponse.analysis_rules:type_name -> google.cloud.contactcenterinsights.v1.AnalysisRule
	171, // 87: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecRequest.encryption_spec:type_name -> google.cloud.contactcenterinsights.v1.EncryptionSpec
	157, // 88: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 89: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata.end_time:type_name -> google.protobuf.Timestamp
	78,  // 90: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecRequest
	163, // 91: google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata.partial_errors:type_name -> google.rpc.Status
	172, // 92: google.cloud.contactcenterinsights.v1.CreateViewRequest.view:type_name -> google.cloud.contactcenterinsights.v1.View
	172, // 93: google.cloud.contactcenterinsights.v1.ListViewsResponse.views:type_name -> google.cloud.contactcenterinsights.v1.View
	172, // 94: google.cloud.contactcenterinsights.v1.UpdateViewRequest.view:type_name -> google.cloud.contactcenterinsights.v1.View
	162, // 95: google.cloud.contactcenterinsights.v1.UpdateViewRequest.update_mask:type_name -> google.protobuf.FieldMask
	140, // 96: google.cloud.contactcenterinsights.v1.Dimension.issue_dimension_metadata:type_name -> google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
	141, // 97: google.cloud.contactcenterinsights.v1.Dimension.agent_dimension_metadata:type_name -> google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
	142, // 98: google.cloud.contactcenterinsights.v1.Dimension.qa_question_dimension_metadata:type_name -> google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
	143, // 99: google.cloud.contactcenterinsights.v1.Dimension.qa_question_answer_dimension_metadata:type_name -> google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
	3,   // 100: google.cloud.contactcenterinsights.v1.Dimension.dimension_key:type_name -> google.cloud.contactcenterinsights.v1.Dimension.DimensionKey
	4,   // 101: google.cloud.contactcenterinsights.v1.QueryMetricsRequest.time_granularity:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
	87,  // 102: google.cloud.contactcenterinsights.v1.QueryMetricsRequest.dimensions:type_name -> google.cloud.contactcenterinsights.v1.Dimension
	162, // 103: google.cloud.contactcenterinsights.v1.QueryMetricsRequest.measure_mask:type_name -> google.protobuf.FieldMask
	157, // 104: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.update_time:type_name -> google.protobuf.Timestamp
	144, // 105: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.slices:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
	144, // 106: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.macro_average_slice:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
	173, // 107: google.cloud.contactcenterinsights.v1.CreateQaQuestionRequest.qa_question:type_name -> google.cloud.contactcenterinsights.v1.QaQuestion
	173, // 108: google.cloud.contactcenterinsights.v1.ListQaQuestionsResponse.qa_questions:type_name -> google.cloud.contactcenterinsights.v1.QaQuestion
	173, // 109: google.cloud.contactcenterinsights.v1.UpdateQaQuestionRequest.qa_question:type_name -> google.cloud.contactcenterinsights.v1.QaQuestion
	162, // 110: google.cloud.contactcenterinsights.v1.UpdateQaQuestionRequest.update_mask:type_name -> google.protobuf.FieldMask
	174, // 111: google.cloud.contactcenterinsights.v1.CreateQaScorecardRequest.qa_scorecard:type_name -> google.cloud.contactcenterinsights.v1.QaScorecard
	174, // 112: google.cloud.contactcenterinsights.v1.UpdateQaScorecardRequest.qa_scorecard:type_name -> google.cloud.contactcenterinsights.v1.QaScorecard
	162, // 113: google.cloud.contactcenterinsights.v1.UpdateQaScorecardRequest.update_mask:type_name -> google.protobuf.FieldMask
	175, // 114: google.cloud.contactcenterinsights.v1.CreateQaScorecardRevisionRequest.qa_scorecard_revision:type_name -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	157, // 115: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 116: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.end_time:type_name -> google.protobuf.Timestamp
	103, // 117: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
	149, // 118: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.qa_question_dataset_validation_results:type_name -> google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult
	150, // 119: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.qa_question_dataset_tuning_metrics:type_name -> google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics
	174, // 120: google.cloud.contactcenterinsights.v1.ListQaScorecardsResponse.qa_scorecards:type_name -> google.cloud.contactcenterinsights.v1.QaScorecard
	175, // 121: google.cloud.contactcenterinsights.v1.ListQaScorecardRevisionsResponse.qa_scorecard_revisions:type_name -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	176, // 122: google.cloud.contactcenterinsights.v1.CreateFeedbackLabelRequest.feedback_label:type_name -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	176, // 123: google.cloud.contactcenterinsights.v1.ListFeedbackLabelsResponse.feedback_labels:type_name -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	176, // 124: google.cloud.contactcenterinsights.v1.UpdateFeedbackLabelRequest.feedback_label:type_name -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	162, // 125: google.cloud.contactcenterinsights.v1.UpdateFeedbackLabelRequest.update_mask:type_name -> google.protobuf.FieldMask
	176, // 126: google.cloud.contactcenterinsights.v1.ListAllFeedbackLabelsResponse.feedback_labels:type_name -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	152, // 127: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.gcs_source:type_name -> google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
	157, // 128: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 129: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.end_time:type_name -> google.protobuf.Timestamp
	121, // 130: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
	163, // 131: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.partial_errors:type_name -> google.rpc.Status
	153, // 132: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.upload_stats:type_name -> google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
	154, // 133: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.gcs_destination:type_name -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
	6,   // 134: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.feedback_label_type:type_name -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType
	157, // 135: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.create_time:type_name -> google.protobuf.Timestamp
	157, // 136: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.end_time:type_name -> google.protobuf.Timestamp
	124, // 137: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.request:type_name -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
	163, // 138: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.partial_errors:type_name -> google.rpc.Status
	155, // 139: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.download_stats:type_name -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
	156, // 140: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.interval_duration:type_name -> google.protobuf.Duration
	132, // 141: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.points:type_name -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
	177, // 142: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.IssueMatchesStatsEntry.value:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	157, // 143: google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval.start_time:type_name -> google.protobuf.Timestamp
	1,   // 144: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.bucket_object_type:type_name -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType
	178, // 145: google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig.medium:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Medium
	87,  // 146: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.dimensions:type_name -> google.cloud.contactcenterinsights.v1.Dimension
	145, // 147: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.total:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
	146, // 148: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.time_series:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
	147, // 149: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.conversation_measure:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure
	179, // 150: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.interval:type_name -> google.type.Interval
	145, // 151: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries.data_points:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
	156, // 152: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.average_duration:type_name -> google.protobuf.Duration
	148, // 153: google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.qa_tag_scores:type_name -> google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore
	180, // 154: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult.dataset_validation_warnings:type_name -> google.cloud.contactcenterinsights.v1.DatasetValidationWarning
	151, // 155: google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.metrics:type_name -> google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics
	5,   // 156: google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.format:type_name -> google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
	7,   // 157: google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.format:type_name -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format
	11,  // 158: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:input_type -> google.cloud.contactcenterinsights.v1.CreateConversationRequest
	12,  // 159: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UploadConversation:input_type -> google.cloud.contactcenterinsights.v1.UploadConversationRequest
	17,  // 160: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:input_type -> google.cloud.contactcenterinsights.v1.UpdateConversationRequest
	16,  // 161: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:input_type -> google.cloud.contactcenterinsights.v1.GetConversationRequest
	14,  // 162: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:input_type -> google.cloud.contactcenterinsights.v1.ListConversationsRequest
	18,  // 163: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:input_type -> google.cloud.contactcenterinsights.v1.DeleteConversationRequest
	22,  // 164: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:input_type -> google.cloud.contactcenterinsights.v1.CreateAnalysisRequest
	25,  // 165: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:input_type -> google.cloud.contactcenterinsights.v1.GetAnalysisRequest
	23,  // 166: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:input_type -> google.cloud.contactcenterinsights.v1.ListAnalysesRequest
	26,  // 167: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:input_type -> google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest
	27,  // 168: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkAnalyzeConversations:input_type -> google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
	30,  // 169: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDeleteConversations:input_type -> google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest
	19,  // 170: google.cloud.contactcenterinsights.v1.ContactCenterInsights.IngestConversations:input_type -> google.cloud.contactcenterinsights.v1.IngestConversationsRequest
	33,  // 171: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:input_type -> google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
	36,  // 172: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.CreateIssueModelRequest
	38,  // 173: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest
	41,  // 174: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:input_type -> google.cloud.contactcenterinsights.v1.GetIssueModelRequest
	39,  // 175: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:input_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsRequest
	42,  // 176: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest
	44,  // 177: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.DeployIssueModelRequest
	47,  // 178: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:input_type -> google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest
	50,  // 179: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportIssueModel:input_type -> google.cloud.contactcenterinsights.v1.ExportIssueModelRequest
	53,  // 180: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ImportIssueModel:input_type -> google.cloud.contactcenterinsights.v1.ImportIssueModelRequest
	56,  // 181: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:input_type -> google.cloud.contactcenterinsights.v1.GetIssueRequest
	57,  // 182: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:input_type -> google.cloud.contactcenterinsights.v1.ListIssuesRequest
	59,  // 183: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:input_type -> google.cloud.contactcenterinsights.v1.UpdateIssueRequest
	60,  // 184: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssue:input_type -> google.cloud.contactcenterinsights.v1.DeleteIssueRequest
	61,  // 185: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest
	63,  // 186: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest
	66,  // 187: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest
	64,  // 188: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:input_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest
	67,  // 189: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest
	68,  // 190: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdatePhraseMatcher:input_type -> google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest
	8,   // 191: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:input_type -> google.cloud.contactcenterinsights.v1.CalculateStatsRequest
	69,  // 192: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:input_type -> google.cloud.contactcenterinsights.v1.GetSettingsRequest
	70,  // 193: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:input_type -> google.cloud.contactcenterinsights.v1.UpdateSettingsRequest
	71,  // 194: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysisRule:input_type -> google.cloud.contactcenterinsights.v1.CreateAnalysisRuleRequest
	72,  // 195: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysisRule:input_type -> google.cloud.contactcenterinsights.v1.GetAnalysisRuleRequest
	75,  // 196: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalysisRules:input_type -> google.cloud.contactcenterinsights.v1.ListAnalysisRulesRequest
	73,  // 197: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateAnalysisRule:input_type -> google.cloud.contactcenterinsights.v1.UpdateAnalysisRuleRequest
	74,  // 198: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysisRule:input_type -> google.cloud.contactcenterinsights.v1.DeleteAnalysisRuleRequest
	77,  // 199: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetEncryptionSpec:input_type -> google.cloud.contactcenterinsights.v1.GetEncryptionSpecRequest
	78,  // 200: google.cloud.contactcenterinsights.v1.ContactCenterInsights.InitializeEncryptionSpec:input_type -> google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecRequest
	81,  // 201: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateView:input_type -> google.cloud.contactcenterinsights.v1.CreateViewRequest
	82,  // 202: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetView:input_type -> google.cloud.contactcenterinsights.v1.GetViewRequest
	83,  // 203: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListViews:input_type -> google.cloud.contactcenterinsights.v1.ListViewsRequest
	85,  // 204: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateView:input_type -> google.cloud.contactcenterinsights.v1.UpdateViewRequest
	86,  // 205: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteView:input_type -> google.cloud.contactcenterinsights.v1.DeleteViewRequest
	88,  // 206: google.cloud.contactcenterinsights.v1.ContactCenterInsights.QueryMetrics:input_type -> google.cloud.contactcenterinsights.v1.QueryMetricsRequest
	91,  // 207: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaQuestion:input_type -> google.cloud.contactcenterinsights.v1.CreateQaQuestionRequest
	92,  // 208: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaQuestion:input_type -> google.cloud.contactcenterinsights.v1.GetQaQuestionRequest
	95,  // 209: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateQaQuestion:input_type -> google.cloud.contactcenterinsights.v1.UpdateQaQuestionRequest
	96,  // 210: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaQuestion:input_type -> google.cloud.contactcenterinsights.v1.DeleteQaQuestionRequest
	93,  // 211: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaQuestions:input_type -> google.cloud.contactcenterinsights.v1.ListQaQuestionsRequest
	97,  // 212: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaScorecard:input_type -> google.cloud.contactcenterinsights.v1.CreateQaScorecardRequest
	98,  // 213: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaScorecard:input_type -> google.cloud.contactcenterinsights.v1.GetQaScorecardRequest
	99,  // 214: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateQaScorecard:input_type -> google.cloud.contactcenterinsights.v1.UpdateQaScorecardRequest
	100, // 215: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaScorecard:input_type -> google.cloud.contactcenterinsights.v1.DeleteQaScorecardRequest
	109, // 216: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaScorecards:input_type -> google.cloud.contactcenterinsights.v1.ListQaScorecardsRequest
	101, // 217: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.CreateQaScorecardRevisionRequest
	102, // 218: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.GetQaScorecardRevisionRequest
	103, // 219: google.cloud.contactcenterinsights.v1.ContactCenterInsights.TuneQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
	106, // 220: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.DeployQaScorecardRevisionRequest
	107, // 221: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.UndeployQaScorecardRevisionRequest
	108, // 222: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaScorecardRevision:input_type -> google.cloud.contactcenterinsights.v1.DeleteQaScorecardRevisionRequest
	111, // 223: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaScorecardRevisions:input_type -> google.cloud.contactcenterinsights.v1.ListQaScorecardRevisionsRequest
	113, // 224: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateFeedbackLabel:input_type -> google.cloud.contactcenterinsights.v1.CreateFeedbackLabelRequest
	114, // 225: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListFeedbackLabels:input_type -> google.cloud.contactcenterinsights.v1.ListFeedbackLabelsRequest
	116, // 226: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetFeedbackLabel:input_type -> google.cloud.contactcenterinsights.v1.GetFeedbackLabelRequest
	117, // 227: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateFeedbackLabel:input_type -> google.cloud.contactcenterinsights.v1.UpdateFeedbackLabelRequest
	118, // 228: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteFeedbackLabel:input_type -> google.cloud.contactcenterinsights.v1.DeleteFeedbackLabelRequest
	119, // 229: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAllFeedbackLabels:input_type -> google.cloud.contactcenterinsights.v1.ListAllFeedbackLabelsRequest
	121, // 230: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkUploadFeedbackLabels:input_type -> google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
	124, // 231: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDownloadFeedbackLabels:input_type -> google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
	159, // 232: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	181, // 233: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UploadConversation:output_type -> google.longrunning.Operation
	159, // 234: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	159, // 235: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetConversation:output_type -> google.cloud.contactcenterinsights.v1.Conversation
	15,  // 236: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListConversations:output_type -> google.cloud.contactcenterinsights.v1.ListConversationsResponse
	182, // 237: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteConversation:output_type -> google.protobuf.Empty
	181, // 238: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysis:output_type -> google.longrunning.Operation
	164, // 239: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysis:output_type -> google.cloud.contactcenterinsights.v1.Analysis
	24,  // 240: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalyses:output_type -> google.cloud.contactcenterinsights.v1.ListAnalysesResponse
	182, // 241: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysis:output_type -> google.protobuf.Empty
	181, // 242: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkAnalyzeConversations:output_type -> google.longrunning.Operation
	181, // 243: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDeleteConversations:output_type -> google.longrunning.Operation
	181, // 244: google.cloud.contactcenterinsights.v1.ContactCenterInsights.IngestConversations:output_type -> google.longrunning.Operation
	181, // 245: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportInsightsData:output_type -> google.longrunning.Operation
	181, // 246: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateIssueModel:output_type -> google.longrunning.Operation
	165, // 247: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	165, // 248: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssueModel:output_type -> google.cloud.contactcenterinsights.v1.IssueModel
	40,  // 249: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssueModels:output_type -> google.cloud.contactcenterinsights.v1.ListIssueModelsResponse
	181, // 250: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssueModel:output_type -> google.longrunning.Operation
	181, // 251: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployIssueModel:output_type -> google.longrunning.Operation
	181, // 252: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployIssueModel:output_type -> google.longrunning.Operation
	181, // 253: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ExportIssueModel:output_type -> google.longrunning.Operation
	181, // 254: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ImportIssueModel:output_type -> google.longrunning.Operation
	166, // 255: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	58,  // 256: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListIssues:output_type -> google.cloud.contactcenterinsights.v1.ListIssuesResponse
	166, // 257: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateIssue:output_type -> google.cloud.contactcenterinsights.v1.Issue
	182, // 258: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteIssue:output_type -> google.protobuf.Empty
	62,  // 259: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateIssueModelStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse
	168, // 260: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreatePhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	168, // 261: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetPhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	65,  // 262: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListPhraseMatchers:output_type -> google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse
	182, // 263: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeletePhraseMatcher:output_type -> google.protobuf.Empty
	168, // 264: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdatePhraseMatcher:output_type -> google.cloud.contactcenterinsights.v1.PhraseMatcher
	9,   // 265: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CalculateStats:output_type -> google.cloud.contactcenterinsights.v1.CalculateStatsResponse
	169, // 266: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	169, // 267: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateSettings:output_type -> google.cloud.contactcenterinsights.v1.Settings
	170, // 268: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateAnalysisRule:output_type -> google.cloud.contactcenterinsights.v1.AnalysisRule
	170, // 269: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetAnalysisRule:output_type -> google.cloud.contactcenterinsights.v1.AnalysisRule
	76,  // 270: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAnalysisRules:output_type -> google.cloud.contactcenterinsights.v1.ListAnalysisRulesResponse
	170, // 271: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateAnalysisRule:output_type -> google.cloud.contactcenterinsights.v1.AnalysisRule
	182, // 272: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteAnalysisRule:output_type -> google.protobuf.Empty
	171, // 273: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetEncryptionSpec:output_type -> google.cloud.contactcenterinsights.v1.EncryptionSpec
	181, // 274: google.cloud.contactcenterinsights.v1.ContactCenterInsights.InitializeEncryptionSpec:output_type -> google.longrunning.Operation
	172, // 275: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateView:output_type -> google.cloud.contactcenterinsights.v1.View
	172, // 276: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetView:output_type -> google.cloud.contactcenterinsights.v1.View
	84,  // 277: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListViews:output_type -> google.cloud.contactcenterinsights.v1.ListViewsResponse
	172, // 278: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateView:output_type -> google.cloud.contactcenterinsights.v1.View
	182, // 279: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteView:output_type -> google.protobuf.Empty
	181, // 280: google.cloud.contactcenterinsights.v1.ContactCenterInsights.QueryMetrics:output_type -> google.longrunning.Operation
	173, // 281: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaQuestion:output_type -> google.cloud.contactcenterinsights.v1.QaQuestion
	173, // 282: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaQuestion:output_type -> google.cloud.contactcenterinsights.v1.QaQuestion
	173, // 283: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateQaQuestion:output_type -> google.cloud.contactcenterinsights.v1.QaQuestion
	182, // 284: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaQuestion:output_type -> google.protobuf.Empty
	94,  // 285: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaQuestions:output_type -> google.cloud.contactcenterinsights.v1.ListQaQuestionsResponse
	174, // 286: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaScorecard:output_type -> google.cloud.contactcenterinsights.v1.QaScorecard
	174, // 287: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaScorecard:output_type -> google.cloud.contactcenterinsights.v1.QaScorecard
	174, // 288: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateQaScorecard:output_type -> google.cloud.contactcenterinsights.v1.QaScorecard
	182, // 289: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaScorecard:output_type -> google.protobuf.Empty
	110, // 290: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaScorecards:output_type -> google.cloud.contactcenterinsights.v1.ListQaScorecardsResponse
	175, // 291: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateQaScorecardRevision:output_type -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	175, // 292: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetQaScorecardRevision:output_type -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	181, // 293: google.cloud.contactcenterinsights.v1.ContactCenterInsights.TuneQaScorecardRevision:output_type -> google.longrunning.Operation
	175, // 294: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeployQaScorecardRevision:output_type -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	175, // 295: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UndeployQaScorecardRevision:output_type -> google.cloud.contactcenterinsights.v1.QaScorecardRevision
	182, // 296: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteQaScorecardRevision:output_type -> google.protobuf.Empty
	112, // 297: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListQaScorecardRevisions:output_type -> google.cloud.contactcenterinsights.v1.ListQaScorecardRevisionsResponse
	176, // 298: google.cloud.contactcenterinsights.v1.ContactCenterInsights.CreateFeedbackLabel:output_type -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	115, // 299: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListFeedbackLabels:output_type -> google.cloud.contactcenterinsights.v1.ListFeedbackLabelsResponse
	176, // 300: google.cloud.contactcenterinsights.v1.ContactCenterInsights.GetFeedbackLabel:output_type -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	176, // 301: google.cloud.contactcenterinsights.v1.ContactCenterInsights.UpdateFeedbackLabel:output_type -> google.cloud.contactcenterinsights.v1.FeedbackLabel
	182, // 302: google.cloud.contactcenterinsights.v1.ContactCenterInsights.DeleteFeedbackLabel:output_type -> google.protobuf.Empty
	120, // 303: google.cloud.contactcenterinsights.v1.ContactCenterInsights.ListAllFeedbackLabels:output_type -> google.cloud.contactcenterinsights.v1.ListAllFeedbackLabelsResponse
	181, // 304: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkUploadFeedbackLabels:output_type -> google.longrunning.Operation
	181, // 305: google.cloud.contactcenterinsights.v1.ContactCenterInsights.BulkDownloadFeedbackLabels:output_type -> google.longrunning.Operation
	232, // [232:306] is the sub-list for method output_type
	158, // [158:232] is the sub-list for method input_type
	158, // [158:158] is the sub-list for extension type_name
	158, // [158:158] is the sub-list for extension extendee
	0,   // [0:158] is the sub-list for field type_name
}

func init() { file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() }
func file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_init() {
	if File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto != nil {
		return
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_init()
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[11].OneofWrappers = []any{
		(*IngestConversationsRequest_GcsSource_)(nil),
		(*IngestConversationsRequest_TranscriptObjectConfig_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[25].OneofWrappers = []any{
		(*ExportInsightsDataRequest_BigQueryDestination_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[42].OneofWrappers = []any{
		(*ExportIssueModelRequest_GcsDestination_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[45].OneofWrappers = []any{
		(*ImportIssueModelRequest_GcsSource_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[79].OneofWrappers = []any{
		(*Dimension_IssueDimensionMetadata_)(nil),
		(*Dimension_AgentDimensionMetadata_)(nil),
		(*Dimension_QaQuestionDimensionMetadata_)(nil),
		(*Dimension_QaQuestionAnswerDimensionMetadata_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[81].OneofWrappers = []any{}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[113].OneofWrappers = []any{
		(*BulkUploadFeedbackLabelsRequest_GcsSource_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[116].OneofWrappers = []any{
		(*BulkDownloadFeedbackLabelsRequest_GcsDestination_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[125].OneofWrappers = []any{}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[137].OneofWrappers = []any{
		(*QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes[139].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   148,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes,
		DependencyIndexes: file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs,
		EnumInfos:         file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_enumTypes,
		MessageInfos:      file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_msgTypes,
	}.Build()
	File_google_cloud_contactcenterinsights_v1_contact_center_insights_proto = out.File
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_rawDesc = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_goTypes = nil
	file_google_cloud_contactcenterinsights_v1_contact_center_insights_proto_depIdxs = nil
}
