package main

import (
	"context"
	"fmt"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	clients, err := t.ListClients(ctx)
	if err != nil {
		log.Fatal(err)
	}

	for _, c := range clients {
		fmt.Println(c.Tty, c.Session)
	}
}
