// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

package documentaipb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DocumentProcessorService_ProcessDocument_FullMethodName            = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument"
	DocumentProcessorService_BatchProcessDocuments_FullMethodName      = "/google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments"
	DocumentProcessorService_FetchProcessorTypes_FullMethodName        = "/google.cloud.documentai.v1beta3.DocumentProcessorService/FetchProcessorTypes"
	DocumentProcessorService_ListProcessorTypes_FullMethodName         = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorTypes"
	DocumentProcessorService_GetProcessorType_FullMethodName           = "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessorType"
	DocumentProcessorService_ListProcessors_FullMethodName             = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessors"
	DocumentProcessorService_GetProcessor_FullMethodName               = "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessor"
	DocumentProcessorService_TrainProcessorVersion_FullMethodName      = "/google.cloud.documentai.v1beta3.DocumentProcessorService/TrainProcessorVersion"
	DocumentProcessorService_GetProcessorVersion_FullMethodName        = "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessorVersion"
	DocumentProcessorService_ListProcessorVersions_FullMethodName      = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorVersions"
	DocumentProcessorService_DeleteProcessorVersion_FullMethodName     = "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessorVersion"
	DocumentProcessorService_DeployProcessorVersion_FullMethodName     = "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeployProcessorVersion"
	DocumentProcessorService_UndeployProcessorVersion_FullMethodName   = "/google.cloud.documentai.v1beta3.DocumentProcessorService/UndeployProcessorVersion"
	DocumentProcessorService_CreateProcessor_FullMethodName            = "/google.cloud.documentai.v1beta3.DocumentProcessorService/CreateProcessor"
	DocumentProcessorService_DeleteProcessor_FullMethodName            = "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessor"
	DocumentProcessorService_EnableProcessor_FullMethodName            = "/google.cloud.documentai.v1beta3.DocumentProcessorService/EnableProcessor"
	DocumentProcessorService_DisableProcessor_FullMethodName           = "/google.cloud.documentai.v1beta3.DocumentProcessorService/DisableProcessor"
	DocumentProcessorService_SetDefaultProcessorVersion_FullMethodName = "/google.cloud.documentai.v1beta3.DocumentProcessorService/SetDefaultProcessorVersion"
	DocumentProcessorService_ReviewDocument_FullMethodName             = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument"
	DocumentProcessorService_EvaluateProcessorVersion_FullMethodName   = "/google.cloud.documentai.v1beta3.DocumentProcessorService/EvaluateProcessorVersion"
	DocumentProcessorService_GetEvaluation_FullMethodName              = "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetEvaluation"
	DocumentProcessorService_ListEvaluations_FullMethodName            = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListEvaluations"
	DocumentProcessorService_ImportProcessorVersion_FullMethodName     = "/google.cloud.documentai.v1beta3.DocumentProcessorService/ImportProcessorVersion"
)

// DocumentProcessorServiceClient is the client API for DocumentProcessorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DocumentProcessorServiceClient interface {
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches processor types. Note that we don't use
	// [ListProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorTypes]
	// here, because it isn't paginated.
	FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error)
	// Gets a processor type detail.
	GetProcessorType(ctx context.Context, in *GetProcessorTypeRequest, opts ...grpc.CallOption) (*ProcessorType, error)
	// Lists all processors which belong to this project.
	ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Trains a new processor version.
	// Operation metadata is returned as
	// [TrainProcessorVersionMetadata][google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata].
	TrainProcessorVersion(ctx context.Context, in *TrainProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a processor version detail.
	GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a processor from the
	// [ProcessorType][google.cloud.documentai.v1beta3.ProcessorType] provided.
	// The processor will be at `ENABLED` state by default after its creation.
	// Note that this method requires the `documentai.processors.create`
	// permission on the project, which is highly privileged. A user or service
	// account with this permission can create new processors that can interact
	// with any gcs bucket in your project.
	CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enables a processor
	EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disables a processor
	DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Set the default (active) version of a
	// [Processor][google.cloud.documentai.v1beta3.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument]
	// and
	// [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Evaluates a ProcessorVersion against annotated documents, producing an
	// Evaluation.
	EvaluateProcessorVersion(ctx context.Context, in *EvaluateProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a specific evaluation.
	GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error)
	// Retrieves a set of evaluations for a given processor version.
	ListEvaluations(ctx context.Context, in *ListEvaluationsRequest, opts ...grpc.CallOption) (*ListEvaluationsResponse, error)
	// Imports a processor version from source processor version.
	ImportProcessorVersion(ctx context.Context, in *ImportProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type documentProcessorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentProcessorServiceClient(cc grpc.ClientConnInterface) DocumentProcessorServiceClient {
	return &documentProcessorServiceClient{cc}
}

func (c *documentProcessorServiceClient) ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error) {
	out := new(ProcessResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ProcessDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_BatchProcessDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error) {
	out := new(FetchProcessorTypesResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_FetchProcessorTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error) {
	out := new(ListProcessorTypesResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ListProcessorTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessorType(ctx context.Context, in *GetProcessorTypeRequest, opts ...grpc.CallOption) (*ProcessorType, error) {
	out := new(ProcessorType)
	err := c.cc.Invoke(ctx, DocumentProcessorService_GetProcessorType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error) {
	out := new(ListProcessorsResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ListProcessors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, DocumentProcessorService_GetProcessor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) TrainProcessorVersion(ctx context.Context, in *TrainProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_TrainProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error) {
	out := new(ProcessorVersion)
	err := c.cc.Invoke(ctx, DocumentProcessorService_GetProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error) {
	out := new(ListProcessorVersionsResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ListProcessorVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_DeleteProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_DeployProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_UndeployProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, DocumentProcessorService_CreateProcessor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_DeleteProcessor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_EnableProcessor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_DisableProcessor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_SetDefaultProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ReviewDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) EvaluateProcessorVersion(ctx context.Context, in *EvaluateProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_EvaluateProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error) {
	out := new(Evaluation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_GetEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListEvaluations(ctx context.Context, in *ListEvaluationsRequest, opts ...grpc.CallOption) (*ListEvaluationsResponse, error) {
	out := new(ListEvaluationsResponse)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ListEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ImportProcessorVersion(ctx context.Context, in *ImportProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DocumentProcessorService_ImportProcessorVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentProcessorServiceServer is the server API for DocumentProcessorService service.
// All implementations should embed UnimplementedDocumentProcessorServiceServer
// for forward compatibility
type DocumentProcessorServiceServer interface {
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunningpb.Operation, error)
	// Fetches processor types. Note that we don't use
	// [ListProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorTypes]
	// here, because it isn't paginated.
	FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error)
	// Gets a processor type detail.
	GetProcessorType(context.Context, *GetProcessorTypeRequest) (*ProcessorType, error)
	// Lists all processors which belong to this project.
	ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error)
	// Trains a new processor version.
	// Operation metadata is returned as
	// [TrainProcessorVersionMetadata][google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata].
	TrainProcessorVersion(context.Context, *TrainProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Gets a processor version detail.
	GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Creates a processor from the
	// [ProcessorType][google.cloud.documentai.v1beta3.ProcessorType] provided.
	// The processor will be at `ENABLED` state by default after its creation.
	// Note that this method requires the `documentai.processors.create`
	// permission on the project, which is highly privileged. A user or service
	// account with this permission can create new processors that can interact
	// with any gcs bucket in your project.
	CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunningpb.Operation, error)
	// Enables a processor
	EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunningpb.Operation, error)
	// Disables a processor
	DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunningpb.Operation, error)
	// Set the default (active) version of a
	// [Processor][google.cloud.documentai.v1beta3.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument]
	// and
	// [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunningpb.Operation, error)
	// Evaluates a ProcessorVersion against annotated documents, producing an
	// Evaluation.
	EvaluateProcessorVersion(context.Context, *EvaluateProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Retrieves a specific evaluation.
	GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error)
	// Retrieves a set of evaluations for a given processor version.
	ListEvaluations(context.Context, *ListEvaluationsRequest) (*ListEvaluationsResponse, error)
	// Imports a processor version from source processor version.
	ImportProcessorVersion(context.Context, *ImportProcessorVersionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDocumentProcessorServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDocumentProcessorServiceServer struct {
}

func (UnimplementedDocumentProcessorServiceServer) ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchProcessorTypes not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcessorTypes not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) GetProcessorType(context.Context, *GetProcessorTypeRequest) (*ProcessorType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessorType not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcessors not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessor not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) TrainProcessorVersion(context.Context, *TrainProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcessorVersions not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProcessor not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcessor not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableProcessor not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableProcessor not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReviewDocument not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) EvaluateProcessorVersion(context.Context, *EvaluateProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvaluateProcessorVersion not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEvaluation not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ListEvaluations(context.Context, *ListEvaluationsRequest) (*ListEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvaluations not implemented")
}
func (UnimplementedDocumentProcessorServiceServer) ImportProcessorVersion(context.Context, *ImportProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportProcessorVersion not implemented")
}

// UnsafeDocumentProcessorServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DocumentProcessorServiceServer will
// result in compilation errors.
type UnsafeDocumentProcessorServiceServer interface {
	mustEmbedUnimplementedDocumentProcessorServiceServer()
}

func RegisterDocumentProcessorServiceServer(s grpc.ServiceRegistrar, srv DocumentProcessorServiceServer) {
	s.RegisterService(&DocumentProcessorService_ServiceDesc, srv)
}

func _DocumentProcessorService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ProcessDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, req.(*ProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_BatchProcessDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_FetchProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_FetchProcessorTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, req.(*FetchProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ListProcessorTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, req.(*ListProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessorType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessorType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_GetProcessorType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessorType(ctx, req.(*GetProcessorTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ListProcessors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, req.(*ListProcessorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_GetProcessor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, req.(*GetProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_TrainProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).TrainProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_TrainProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).TrainProcessorVersion(ctx, req.(*TrainProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_GetProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, req.(*GetProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ListProcessorVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, req.(*ListProcessorVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_DeleteProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, req.(*DeleteProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_DeployProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, req.(*DeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_UndeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_UndeployProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, req.(*UndeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_CreateProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_CreateProcessor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, req.(*CreateProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_DeleteProcessor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, req.(*DeleteProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_EnableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_EnableProcessor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, req.(*EnableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DisableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_DisableProcessor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, req.(*DisableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_SetDefaultProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_SetDefaultProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, req.(*SetDefaultProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ReviewDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReviewDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ReviewDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, req.(*ReviewDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_EvaluateProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).EvaluateProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_EvaluateProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).EvaluateProcessorVersion(ctx, req.(*EvaluateProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_GetEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetEvaluation(ctx, req.(*GetEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ListEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListEvaluations(ctx, req.(*ListEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ImportProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ImportProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DocumentProcessorService_ImportProcessorVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ImportProcessorVersion(ctx, req.(*ImportProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DocumentProcessorService_ServiceDesc is the grpc.ServiceDesc for DocumentProcessorService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DocumentProcessorService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta3.DocumentProcessorService",
	HandlerType: (*DocumentProcessorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentProcessorService_ProcessDocument_Handler,
		},
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentProcessorService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "FetchProcessorTypes",
			Handler:    _DocumentProcessorService_FetchProcessorTypes_Handler,
		},
		{
			MethodName: "ListProcessorTypes",
			Handler:    _DocumentProcessorService_ListProcessorTypes_Handler,
		},
		{
			MethodName: "GetProcessorType",
			Handler:    _DocumentProcessorService_GetProcessorType_Handler,
		},
		{
			MethodName: "ListProcessors",
			Handler:    _DocumentProcessorService_ListProcessors_Handler,
		},
		{
			MethodName: "GetProcessor",
			Handler:    _DocumentProcessorService_GetProcessor_Handler,
		},
		{
			MethodName: "TrainProcessorVersion",
			Handler:    _DocumentProcessorService_TrainProcessorVersion_Handler,
		},
		{
			MethodName: "GetProcessorVersion",
			Handler:    _DocumentProcessorService_GetProcessorVersion_Handler,
		},
		{
			MethodName: "ListProcessorVersions",
			Handler:    _DocumentProcessorService_ListProcessorVersions_Handler,
		},
		{
			MethodName: "DeleteProcessorVersion",
			Handler:    _DocumentProcessorService_DeleteProcessorVersion_Handler,
		},
		{
			MethodName: "DeployProcessorVersion",
			Handler:    _DocumentProcessorService_DeployProcessorVersion_Handler,
		},
		{
			MethodName: "UndeployProcessorVersion",
			Handler:    _DocumentProcessorService_UndeployProcessorVersion_Handler,
		},
		{
			MethodName: "CreateProcessor",
			Handler:    _DocumentProcessorService_CreateProcessor_Handler,
		},
		{
			MethodName: "DeleteProcessor",
			Handler:    _DocumentProcessorService_DeleteProcessor_Handler,
		},
		{
			MethodName: "EnableProcessor",
			Handler:    _DocumentProcessorService_EnableProcessor_Handler,
		},
		{
			MethodName: "DisableProcessor",
			Handler:    _DocumentProcessorService_DisableProcessor_Handler,
		},
		{
			MethodName: "SetDefaultProcessorVersion",
			Handler:    _DocumentProcessorService_SetDefaultProcessorVersion_Handler,
		},
		{
			MethodName: "ReviewDocument",
			Handler:    _DocumentProcessorService_ReviewDocument_Handler,
		},
		{
			MethodName: "EvaluateProcessorVersion",
			Handler:    _DocumentProcessorService_EvaluateProcessorVersion_Handler,
		},
		{
			MethodName: "GetEvaluation",
			Handler:    _DocumentProcessorService_GetEvaluation_Handler,
		},
		{
			MethodName: "ListEvaluations",
			Handler:    _DocumentProcessorService_ListEvaluations_Handler,
		},
		{
			MethodName: "ImportProcessorVersion",
			Handler:    _DocumentProcessorService_ImportProcessorVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta3/document_processor_service.proto",
}
