// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/labels/v2beta/field.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Localized date format options.
type Field_DateOptions_DateFormat int32

const (
	// Date format unspecified.
	Field_DateOptions_DATE_FORMAT_UNSPECIFIED Field_DateOptions_DateFormat = 0
	// Includes full month name.
	// For example, January 12, 1999
	// (MMMM d, y)
	Field_DateOptions_LONG_DATE Field_DateOptions_DateFormat = 1
	// Short, numeric, representation.
	// For example, 12/13/99
	// (M/d/yy)
	Field_DateOptions_SHORT_DATE Field_DateOptions_DateFormat = 2
)

// Enum value maps for Field_DateOptions_DateFormat.
var (
	Field_DateOptions_DateFormat_name = map[int32]string{
		0: "DATE_FORMAT_UNSPECIFIED",
		1: "LONG_DATE",
		2: "SHORT_DATE",
	}
	Field_DateOptions_DateFormat_value = map[string]int32{
		"DATE_FORMAT_UNSPECIFIED": 0,
		"LONG_DATE":               1,
		"SHORT_DATE":              2,
	}
)

func (x Field_DateOptions_DateFormat) Enum() *Field_DateOptions_DateFormat {
	p := new(Field_DateOptions_DateFormat)
	*p = x
	return p
}

func (x Field_DateOptions_DateFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Field_DateOptions_DateFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2beta_field_proto_enumTypes[0].Descriptor()
}

func (Field_DateOptions_DateFormat) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2beta_field_proto_enumTypes[0]
}

func (x Field_DateOptions_DateFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Field_DateOptions_DateFormat.Descriptor instead.
func (Field_DateOptions_DateFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 8, 0}
}

// Defines a field that has a display name, data type, and other
// configuration options. This field defines the kind of metadata that may be
// set on a Drive item.
type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data type and options of this field.
	// Once published, the data type cannot be changed.
	//
	// Types that are assignable to Type:
	//
	//	*Field_TextOptions_
	//	*Field_IntegerOptions_
	//	*Field_DateOptions_
	//	*Field_SelectionOptions_
	//	*Field_UserOptions_
	Type isField_Type `protobuf_oneof:"type"`
	// Output only. The key of a field, unique within a label or library.
	//
	// This value is autogenerated. Matches the regex: `([a-zA-Z0-9])+`
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The key to use when constructing Drive search queries to find
	// files based on values defined for this field on files.
	// For example, "`{query_key}` > 2001-01-01".
	QueryKey string `protobuf:"bytes,2,opt,name=query_key,json=queryKey,proto3" json:"query_key,omitempty"`
	// The basic properties of the field.
	Properties *Field_Properties `protobuf:"bytes,3,opt,name=properties,proto3" json:"properties,omitempty"`
	// Output only. The lifecycle of this field.
	Lifecycle *Lifecycle `protobuf:"bytes,4,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Output only. UI display hints for rendering a field.
	DisplayHints *Field_DisplayHints `protobuf:"bytes,5,opt,name=display_hints,json=displayHints,proto3" json:"display_hints,omitempty"`
	// Output only. The capabilities this user has when editing this field.
	SchemaCapabilities *Field_SchemaCapabilities `protobuf:"bytes,6,opt,name=schema_capabilities,json=schemaCapabilities,proto3" json:"schema_capabilities,omitempty"`
	// Output only. The capabilities this user has on this field and its value
	// when the label is applied on Drive items.
	AppliedCapabilities *Field_AppliedCapabilities `protobuf:"bytes,7,opt,name=applied_capabilities,json=appliedCapabilities,proto3" json:"applied_capabilities,omitempty"`
	// Output only. The user who created this field.
	Creator *UserInfo `protobuf:"bytes,8,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The time this field was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The user who modified this field.
	Updater *UserInfo `protobuf:"bytes,10,opt,name=updater,proto3" json:"updater,omitempty"`
	// Output only. The time this field was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The user who published this field. This value has no meaning
	// when the field is not published.
	Publisher *UserInfo `protobuf:"bytes,12,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Output only. The user who disabled this field. This value has no meaning
	// when the field is not disabled.
	Disabler *UserInfo `protobuf:"bytes,13,opt,name=disabler,proto3" json:"disabler,omitempty"`
	// Output only. The time this field was disabled. This value has no meaning
	// when the field is not disabled.
	DisableTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=disable_time,json=disableTime,proto3" json:"disable_time,omitempty"`
	// Output only. The LockStatus of this field.
	LockStatus *LockStatus `protobuf:"bytes,15,opt,name=lock_status,json=lockStatus,proto3" json:"lock_status,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0}
}

func (m *Field) GetType() isField_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Field) GetTextOptions() *Field_TextOptions {
	if x, ok := x.GetType().(*Field_TextOptions_); ok {
		return x.TextOptions
	}
	return nil
}

func (x *Field) GetIntegerOptions() *Field_IntegerOptions {
	if x, ok := x.GetType().(*Field_IntegerOptions_); ok {
		return x.IntegerOptions
	}
	return nil
}

func (x *Field) GetDateOptions() *Field_DateOptions {
	if x, ok := x.GetType().(*Field_DateOptions_); ok {
		return x.DateOptions
	}
	return nil
}

func (x *Field) GetSelectionOptions() *Field_SelectionOptions {
	if x, ok := x.GetType().(*Field_SelectionOptions_); ok {
		return x.SelectionOptions
	}
	return nil
}

func (x *Field) GetUserOptions() *Field_UserOptions {
	if x, ok := x.GetType().(*Field_UserOptions_); ok {
		return x.UserOptions
	}
	return nil
}

func (x *Field) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Field) GetQueryKey() string {
	if x != nil {
		return x.QueryKey
	}
	return ""
}

func (x *Field) GetProperties() *Field_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Field) GetLifecycle() *Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Field) GetDisplayHints() *Field_DisplayHints {
	if x != nil {
		return x.DisplayHints
	}
	return nil
}

func (x *Field) GetSchemaCapabilities() *Field_SchemaCapabilities {
	if x != nil {
		return x.SchemaCapabilities
	}
	return nil
}

func (x *Field) GetAppliedCapabilities() *Field_AppliedCapabilities {
	if x != nil {
		return x.AppliedCapabilities
	}
	return nil
}

func (x *Field) GetCreator() *UserInfo {
	if x != nil {
		return x.Creator
	}
	return nil
}

func (x *Field) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Field) GetUpdater() *UserInfo {
	if x != nil {
		return x.Updater
	}
	return nil
}

func (x *Field) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Field) GetPublisher() *UserInfo {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *Field) GetDisabler() *UserInfo {
	if x != nil {
		return x.Disabler
	}
	return nil
}

func (x *Field) GetDisableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisableTime
	}
	return nil
}

func (x *Field) GetLockStatus() *LockStatus {
	if x != nil {
		return x.LockStatus
	}
	return nil
}

type isField_Type interface {
	isField_Type()
}

type Field_TextOptions_ struct {
	// Text field options.
	TextOptions *Field_TextOptions `protobuf:"bytes,16,opt,name=text_options,json=textOptions,proto3,oneof"`
}

type Field_IntegerOptions_ struct {
	// Integer field options.
	IntegerOptions *Field_IntegerOptions `protobuf:"bytes,18,opt,name=integer_options,json=integerOptions,proto3,oneof"`
}

type Field_DateOptions_ struct {
	// Date field options.
	DateOptions *Field_DateOptions `protobuf:"bytes,19,opt,name=date_options,json=dateOptions,proto3,oneof"`
}

type Field_SelectionOptions_ struct {
	// Selection field options.
	SelectionOptions *Field_SelectionOptions `protobuf:"bytes,20,opt,name=selection_options,json=selectionOptions,proto3,oneof"`
}

type Field_UserOptions_ struct {
	// User field options.
	UserOptions *Field_UserOptions `protobuf:"bytes,21,opt,name=user_options,json=userOptions,proto3,oneof"`
}

func (*Field_TextOptions_) isField_Type() {}

func (*Field_IntegerOptions_) isField_Type() {}

func (*Field_DateOptions_) isField_Type() {}

func (*Field_SelectionOptions_) isField_Type() {}

func (*Field_UserOptions_) isField_Type() {}

// The basic properties of the field.
type Field_Properties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The display text to show in the UI identifying this field.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Whether the field should be marked as required.
	Required bool `protobuf:"varint,2,opt,name=required,proto3" json:"required,omitempty"`
	// Input only. Insert or move this field before the indicated field. If
	// empty, the field is placed at the end of the list.
	InsertBeforeField string `protobuf:"bytes,3,opt,name=insert_before_field,json=insertBeforeField,proto3" json:"insert_before_field,omitempty"`
}

func (x *Field_Properties) Reset() {
	*x = Field_Properties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_Properties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_Properties) ProtoMessage() {}

func (x *Field_Properties) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_Properties.ProtoReflect.Descriptor instead.
func (*Field_Properties) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Field_Properties) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Field_Properties) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Field_Properties) GetInsertBeforeField() string {
	if x != nil {
		return x.InsertBeforeField
	}
	return ""
}

// UI display hints for rendering a field.
type Field_DisplayHints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the field should be shown as required in the UI.
	Required bool `protobuf:"varint,1,opt,name=required,proto3" json:"required,omitempty"`
	// Whether the field should be shown in the UI as disabled.
	Disabled bool `protobuf:"varint,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// This field should be hidden in the search menu when searching for Drive
	// items.
	HiddenInSearch bool `protobuf:"varint,3,opt,name=hidden_in_search,json=hiddenInSearch,proto3" json:"hidden_in_search,omitempty"`
	// This field should be shown in the apply menu when applying values to a
	// Drive item.
	ShownInApply bool `protobuf:"varint,4,opt,name=shown_in_apply,json=shownInApply,proto3" json:"shown_in_apply,omitempty"`
}

func (x *Field_DisplayHints) Reset() {
	*x = Field_DisplayHints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_DisplayHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_DisplayHints) ProtoMessage() {}

func (x *Field_DisplayHints) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_DisplayHints.ProtoReflect.Descriptor instead.
func (*Field_DisplayHints) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Field_DisplayHints) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Field_DisplayHints) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Field_DisplayHints) GetHiddenInSearch() bool {
	if x != nil {
		return x.HiddenInSearch
	}
	return false
}

func (x *Field_DisplayHints) GetShownInApply() bool {
	if x != nil {
		return x.ShownInApply
	}
	return false
}

// The capabilities related to this field when editing the field.
type Field_SchemaCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can change this field.
	CanUpdate bool `protobuf:"varint,1,opt,name=can_update,json=canUpdate,proto3" json:"can_update,omitempty"`
	// Whether the user can delete this field.
	// The user must have permission and the field must be deprecated.
	CanDelete bool `protobuf:"varint,2,opt,name=can_delete,json=canDelete,proto3" json:"can_delete,omitempty"`
	// Whether the user can disable this field.
	// The user must have permission and this field must not already be
	// disabled.
	CanDisable bool `protobuf:"varint,3,opt,name=can_disable,json=canDisable,proto3" json:"can_disable,omitempty"`
	// Whether the user can enable this field.
	// The user must have permission and this field must be disabled.
	CanEnable bool `protobuf:"varint,4,opt,name=can_enable,json=canEnable,proto3" json:"can_enable,omitempty"`
}

func (x *Field_SchemaCapabilities) Reset() {
	*x = Field_SchemaCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SchemaCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SchemaCapabilities) ProtoMessage() {}

func (x *Field_SchemaCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SchemaCapabilities.ProtoReflect.Descriptor instead.
func (*Field_SchemaCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Field_SchemaCapabilities) GetCanUpdate() bool {
	if x != nil {
		return x.CanUpdate
	}
	return false
}

func (x *Field_SchemaCapabilities) GetCanDelete() bool {
	if x != nil {
		return x.CanDelete
	}
	return false
}

func (x *Field_SchemaCapabilities) GetCanDisable() bool {
	if x != nil {
		return x.CanDisable
	}
	return false
}

func (x *Field_SchemaCapabilities) GetCanEnable() bool {
	if x != nil {
		return x.CanEnable
	}
	return false
}

// The capabilities related to this field on applied metadata.
type Field_AppliedCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can read related applied metadata on items.
	CanRead bool `protobuf:"varint,1,opt,name=can_read,json=canRead,proto3" json:"can_read,omitempty"`
	// Whether the user can search for Drive items referencing this field.
	CanSearch bool `protobuf:"varint,2,opt,name=can_search,json=canSearch,proto3" json:"can_search,omitempty"`
	// Whether the user can set this field on Drive items.
	CanWrite bool `protobuf:"varint,3,opt,name=can_write,json=canWrite,proto3" json:"can_write,omitempty"`
}

func (x *Field_AppliedCapabilities) Reset() {
	*x = Field_AppliedCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_AppliedCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_AppliedCapabilities) ProtoMessage() {}

func (x *Field_AppliedCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_AppliedCapabilities.ProtoReflect.Descriptor instead.
func (*Field_AppliedCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Field_AppliedCapabilities) GetCanRead() bool {
	if x != nil {
		return x.CanRead
	}
	return false
}

func (x *Field_AppliedCapabilities) GetCanSearch() bool {
	if x != nil {
		return x.CanSearch
	}
	return false
}

func (x *Field_AppliedCapabilities) GetCanWrite() bool {
	if x != nil {
		return x.CanWrite
	}
	return false
}

// Options for a multi-valued variant of an associated field type.
type Field_ListOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum number of entries permitted.
	MaxEntries int32 `protobuf:"varint,1,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
}

func (x *Field_ListOptions) Reset() {
	*x = Field_ListOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_ListOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_ListOptions) ProtoMessage() {}

func (x *Field_ListOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_ListOptions.ProtoReflect.Descriptor instead.
func (*Field_ListOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Field_ListOptions) GetMaxEntries() int32 {
	if x != nil {
		return x.MaxEntries
	}
	return 0
}

// Options for the Text field type.
type Field_TextOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The minimum valid length of values for the text field.
	MinLength int32 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Output only. The maximum valid length of values for the text field.
	MaxLength int32 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
}

func (x *Field_TextOptions) Reset() {
	*x = Field_TextOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_TextOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_TextOptions) ProtoMessage() {}

func (x *Field_TextOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_TextOptions.ProtoReflect.Descriptor instead.
func (*Field_TextOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Field_TextOptions) GetMinLength() int32 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *Field_TextOptions) GetMaxLength() int32 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

// Options the Long Text field type.
type Field_LongTextOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The minimum valid length of values for the text field.
	MinLength int32 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Output only. The maximum valid length of values for the text field.
	MaxLength int32 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
}

func (x *Field_LongTextOptions) Reset() {
	*x = Field_LongTextOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_LongTextOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_LongTextOptions) ProtoMessage() {}

func (x *Field_LongTextOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_LongTextOptions.ProtoReflect.Descriptor instead.
func (*Field_LongTextOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Field_LongTextOptions) GetMinLength() int32 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *Field_LongTextOptions) GetMaxLength() int32 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

// Options for the Integer field type.
type Field_IntegerOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The minimum valid value for the integer field.
	MinValue int64 `protobuf:"varint,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Output only. The maximum valid value for the integer field.
	MaxValue int64 `protobuf:"varint,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
}

func (x *Field_IntegerOptions) Reset() {
	*x = Field_IntegerOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_IntegerOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_IntegerOptions) ProtoMessage() {}

func (x *Field_IntegerOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_IntegerOptions.ProtoReflect.Descriptor instead.
func (*Field_IntegerOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Field_IntegerOptions) GetMinValue() int64 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *Field_IntegerOptions) GetMaxValue() int64 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

// Options for the date field type.
type Field_DateOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Localized date formatting option. Field values are rendered in
	// this format according to their locale.
	DateFormatType Field_DateOptions_DateFormat `protobuf:"varint,1,opt,name=date_format_type,json=dateFormatType,proto3,enum=google.apps.drive.labels.v2beta.Field_DateOptions_DateFormat" json:"date_format_type,omitempty"`
	// Output only. ICU date format.
	DateFormat string `protobuf:"bytes,2,opt,name=date_format,json=dateFormat,proto3" json:"date_format,omitempty"`
	// Output only. Minimum valid value (year, month, day).
	MinValue *date.Date `protobuf:"bytes,3,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Output only. Maximum valid value (year, month, day).
	MaxValue *date.Date `protobuf:"bytes,4,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
}

func (x *Field_DateOptions) Reset() {
	*x = Field_DateOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_DateOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_DateOptions) ProtoMessage() {}

func (x *Field_DateOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_DateOptions.ProtoReflect.Descriptor instead.
func (*Field_DateOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Field_DateOptions) GetDateFormatType() Field_DateOptions_DateFormat {
	if x != nil {
		return x.DateFormatType
	}
	return Field_DateOptions_DATE_FORMAT_UNSPECIFIED
}

func (x *Field_DateOptions) GetDateFormat() string {
	if x != nil {
		return x.DateFormat
	}
	return ""
}

func (x *Field_DateOptions) GetMinValue() *date.Date {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *Field_DateOptions) GetMaxValue() *date.Date {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

// Options for the selection field type.
type Field_SelectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When specified, indicates this field supports a list of values.
	// Once the field is published, this cannot be changed.
	ListOptions *Field_ListOptions `protobuf:"bytes,1,opt,name=list_options,json=listOptions,proto3" json:"list_options,omitempty"`
	// The options available for this selection field.
	// The list order is consistent, and modified with `insert_before_choice`.
	Choices []*Field_SelectionOptions_Choice `protobuf:"bytes,2,rep,name=choices,proto3" json:"choices,omitempty"`
}

func (x *Field_SelectionOptions) Reset() {
	*x = Field_SelectionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions) ProtoMessage() {}

func (x *Field_SelectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Field_SelectionOptions) GetListOptions() *Field_ListOptions {
	if x != nil {
		return x.ListOptions
	}
	return nil
}

func (x *Field_SelectionOptions) GetChoices() []*Field_SelectionOptions_Choice {
	if x != nil {
		return x.Choices
	}
	return nil
}

// Options for the user field type.
type Field_UserOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When specified, indicates that this field supports a list of values.
	// Once the field is published, this cannot be changed.
	ListOptions *Field_ListOptions `protobuf:"bytes,1,opt,name=list_options,json=listOptions,proto3" json:"list_options,omitempty"`
}

func (x *Field_UserOptions) Reset() {
	*x = Field_UserOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_UserOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_UserOptions) ProtoMessage() {}

func (x *Field_UserOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_UserOptions.ProtoReflect.Descriptor instead.
func (*Field_UserOptions) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Field_UserOptions) GetListOptions() *Field_ListOptions {
	if x != nil {
		return x.ListOptions
	}
	return nil
}

// Selection field choice.
type Field_SelectionOptions_Choice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique value of the choice.
	// This ID is autogenerated. Matches the regex: `([a-zA-Z0-9_])+`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Basic properties of the choice.
	Properties *Field_SelectionOptions_Choice_Properties `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"`
	// Output only. Lifecycle of the choice.
	Lifecycle *Lifecycle `protobuf:"bytes,3,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Output only. UI display hints for rendering a choice.
	DisplayHints *Field_SelectionOptions_Choice_DisplayHints `protobuf:"bytes,4,opt,name=display_hints,json=displayHints,proto3" json:"display_hints,omitempty"`
	// Output only. The capabilities related to this option when editing the
	// option.
	SchemaCapabilities *Field_SelectionOptions_Choice_SchemaCapabilities `protobuf:"bytes,5,opt,name=schema_capabilities,json=schemaCapabilities,proto3" json:"schema_capabilities,omitempty"`
	// Output only. The capabilities related to this choice on applied
	// metadata.
	AppliedCapabilities *Field_SelectionOptions_Choice_AppliedCapabilities `protobuf:"bytes,6,opt,name=applied_capabilities,json=appliedCapabilities,proto3" json:"applied_capabilities,omitempty"`
	// Output only. The user who created this choice.
	Creator *UserInfo `protobuf:"bytes,7,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The time this choice was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The user who updated this choice last.
	Updater *UserInfo `protobuf:"bytes,9,opt,name=updater,proto3" json:"updater,omitempty"`
	// Output only. The time this choice was updated last.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The user who published this choice. This value has no
	// meaning when the choice is not published.
	Publisher *UserInfo `protobuf:"bytes,11,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Output only. The time this choice was published. This value has no
	// meaning when the choice is not published.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Output only. The user who disabled this choice. This value has no
	// meaning when the option is not disabled.
	Disabler *UserInfo `protobuf:"bytes,13,opt,name=disabler,proto3" json:"disabler,omitempty"`
	// Output only. The time this choice was disabled. This value has no
	// meaning when the choice is not disabled.
	DisableTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=disable_time,json=disableTime,proto3" json:"disable_time,omitempty"`
	// Output only. The LockStatus of this choice.
	LockStatus *LockStatus `protobuf:"bytes,15,opt,name=lock_status,json=lockStatus,proto3" json:"lock_status,omitempty"`
}

func (x *Field_SelectionOptions_Choice) Reset() {
	*x = Field_SelectionOptions_Choice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions_Choice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions_Choice) ProtoMessage() {}

func (x *Field_SelectionOptions_Choice) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions_Choice.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions_Choice) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9, 0}
}

func (x *Field_SelectionOptions_Choice) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Field_SelectionOptions_Choice) GetProperties() *Field_SelectionOptions_Choice_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetLifecycle() *Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetDisplayHints() *Field_SelectionOptions_Choice_DisplayHints {
	if x != nil {
		return x.DisplayHints
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetSchemaCapabilities() *Field_SelectionOptions_Choice_SchemaCapabilities {
	if x != nil {
		return x.SchemaCapabilities
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetAppliedCapabilities() *Field_SelectionOptions_Choice_AppliedCapabilities {
	if x != nil {
		return x.AppliedCapabilities
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetCreator() *UserInfo {
	if x != nil {
		return x.Creator
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetUpdater() *UserInfo {
	if x != nil {
		return x.Updater
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetPublisher() *UserInfo {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetDisabler() *UserInfo {
	if x != nil {
		return x.Disabler
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetDisableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisableTime
	}
	return nil
}

func (x *Field_SelectionOptions_Choice) GetLockStatus() *LockStatus {
	if x != nil {
		return x.LockStatus
	}
	return nil
}

// Basic properties of the choice.
type Field_SelectionOptions_Choice_Properties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The display text to show in the UI identifying this field.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of this label.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The badge configuration for this choice. When set, the
	// label that owns this choice is considered a "badged label".
	BadgeConfig *BadgeConfig `protobuf:"bytes,3,opt,name=badge_config,json=badgeConfig,proto3" json:"badge_config,omitempty"`
	// Input only. Insert or move this choice before the indicated choice.
	// If empty, the choice is placed at the end of the list.
	InsertBeforeChoice string `protobuf:"bytes,4,opt,name=insert_before_choice,json=insertBeforeChoice,proto3" json:"insert_before_choice,omitempty"`
}

func (x *Field_SelectionOptions_Choice_Properties) Reset() {
	*x = Field_SelectionOptions_Choice_Properties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions_Choice_Properties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions_Choice_Properties) ProtoMessage() {}

func (x *Field_SelectionOptions_Choice_Properties) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions_Choice_Properties.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions_Choice_Properties) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9, 0, 0}
}

func (x *Field_SelectionOptions_Choice_Properties) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Field_SelectionOptions_Choice_Properties) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Field_SelectionOptions_Choice_Properties) GetBadgeConfig() *BadgeConfig {
	if x != nil {
		return x.BadgeConfig
	}
	return nil
}

func (x *Field_SelectionOptions_Choice_Properties) GetInsertBeforeChoice() string {
	if x != nil {
		return x.InsertBeforeChoice
	}
	return ""
}

// UI display hints for rendering an option.
type Field_SelectionOptions_Choice_DisplayHints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the option should be shown in the UI as disabled.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// This option should be hidden in the search menu when searching for
	// Drive items.
	HiddenInSearch bool `protobuf:"varint,2,opt,name=hidden_in_search,json=hiddenInSearch,proto3" json:"hidden_in_search,omitempty"`
	// This option should be shown in the apply menu when applying values to
	// a Drive item.
	ShownInApply bool `protobuf:"varint,3,opt,name=shown_in_apply,json=shownInApply,proto3" json:"shown_in_apply,omitempty"`
	// The colors to use for the badge. Changed to Google Material colors
	// based on the chosen `properties.badge_config.color`.
	BadgeColors *BadgeColors `protobuf:"bytes,4,opt,name=badge_colors,json=badgeColors,proto3" json:"badge_colors,omitempty"`
	// The dark-mode color to use for the badge. Changed to Google Material
	// colors based on the chosen `properties.badge_config.color`.
	DarkBadgeColors *BadgeColors `protobuf:"bytes,5,opt,name=dark_badge_colors,json=darkBadgeColors,proto3" json:"dark_badge_colors,omitempty"`
	// The priority of this badge. Used to compare and sort between multiple
	// badges. A lower number means the badge should be shown first.
	// When a badging configuration is not present, this will be 0.
	// Otherwise, this will be set to `BadgeConfig.priority_override` or the
	// default heuristic which prefers creation date of the label, and field
	// and option priority.
	BadgePriority int64 `protobuf:"varint,6,opt,name=badge_priority,json=badgePriority,proto3" json:"badge_priority,omitempty"`
}

func (x *Field_SelectionOptions_Choice_DisplayHints) Reset() {
	*x = Field_SelectionOptions_Choice_DisplayHints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions_Choice_DisplayHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions_Choice_DisplayHints) ProtoMessage() {}

func (x *Field_SelectionOptions_Choice_DisplayHints) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions_Choice_DisplayHints.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions_Choice_DisplayHints) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9, 0, 1}
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetHiddenInSearch() bool {
	if x != nil {
		return x.HiddenInSearch
	}
	return false
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetShownInApply() bool {
	if x != nil {
		return x.ShownInApply
	}
	return false
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetBadgeColors() *BadgeColors {
	if x != nil {
		return x.BadgeColors
	}
	return nil
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetDarkBadgeColors() *BadgeColors {
	if x != nil {
		return x.DarkBadgeColors
	}
	return nil
}

func (x *Field_SelectionOptions_Choice_DisplayHints) GetBadgePriority() int64 {
	if x != nil {
		return x.BadgePriority
	}
	return 0
}

// The capabilities related to this choice when editing the choice.
type Field_SelectionOptions_Choice_SchemaCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can update this choice.
	CanUpdate bool `protobuf:"varint,1,opt,name=can_update,json=canUpdate,proto3" json:"can_update,omitempty"`
	// Whether the user can delete this choice.
	CanDelete bool `protobuf:"varint,2,opt,name=can_delete,json=canDelete,proto3" json:"can_delete,omitempty"`
	// Whether the user can disable this choice.
	CanDisable bool `protobuf:"varint,3,opt,name=can_disable,json=canDisable,proto3" json:"can_disable,omitempty"`
	// Whether the user can enable this choice.
	CanEnable bool `protobuf:"varint,4,opt,name=can_enable,json=canEnable,proto3" json:"can_enable,omitempty"`
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) Reset() {
	*x = Field_SelectionOptions_Choice_SchemaCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions_Choice_SchemaCapabilities) ProtoMessage() {}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions_Choice_SchemaCapabilities.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions_Choice_SchemaCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9, 0, 2}
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) GetCanUpdate() bool {
	if x != nil {
		return x.CanUpdate
	}
	return false
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) GetCanDelete() bool {
	if x != nil {
		return x.CanDelete
	}
	return false
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) GetCanDisable() bool {
	if x != nil {
		return x.CanDisable
	}
	return false
}

func (x *Field_SelectionOptions_Choice_SchemaCapabilities) GetCanEnable() bool {
	if x != nil {
		return x.CanEnable
	}
	return false
}

// The capabilities related to this choice on applied metadata.
type Field_SelectionOptions_Choice_AppliedCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can read related applied metadata on items.
	CanRead bool `protobuf:"varint,1,opt,name=can_read,json=canRead,proto3" json:"can_read,omitempty"`
	// Whether the user can use this choice in search queries.
	CanSearch bool `protobuf:"varint,2,opt,name=can_search,json=canSearch,proto3" json:"can_search,omitempty"`
	// Whether the user can select this choice on an item.
	CanSelect bool `protobuf:"varint,3,opt,name=can_select,json=canSelect,proto3" json:"can_select,omitempty"`
}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) Reset() {
	*x = Field_SelectionOptions_Choice_AppliedCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field_SelectionOptions_Choice_AppliedCapabilities) ProtoMessage() {}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_field_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field_SelectionOptions_Choice_AppliedCapabilities.ProtoReflect.Descriptor instead.
func (*Field_SelectionOptions_Choice_AppliedCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP(), []int{0, 9, 0, 3}
}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) GetCanRead() bool {
	if x != nil {
		return x.CanRead
	}
	return false
}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) GetCanSearch() bool {
	if x != nil {
		return x.CanSearch
	}
	return false
}

func (x *Field_SelectionOptions_Choice_AppliedCapabilities) GetCanSelect() bool {
	if x != nil {
		return x.CanSelect
	}
	return false
}

var File_google_apps_drive_labels_v2beta_field_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2beta_field_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf2, 0x28, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x57, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x54,
	0x65, 0x78, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65,
	0x78, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67,
	0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x0c, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x0c,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x09, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe2, 0x41, 0x01, 0x03, 0x52, 0x08, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x51,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x4e, 0x0a, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c,
	0x65, 0x12, 0x5e, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48, 0x69, 0x6e, 0x74,
	0x73, 0x12, 0x70, 0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x63, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52,
	0x12, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x6f, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x41, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x72, 0x12, 0x41, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72,
	0x12, 0x43, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x63,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0a, 0x6c,
	0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x0a, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe2, 0x41, 0x01, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x34, 0x0a,
	0x13, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x04,
	0x52, 0x11, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x1a, 0x96, 0x01, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x10,
	0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x49, 0x6e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x6e, 0x5f,
	0x69, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x73, 0x68, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x1a, 0x92, 0x01, 0x0a,
	0x12, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x1a, 0x6c, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x61, 0x6e, 0x5f,
	0x72, 0x65, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x61, 0x6e, 0x52,
	0x65, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x61, 0x6e, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x61, 0x6e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x1a,
	0x2e, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a,
	0x57, 0x0a, 0x0b, 0x54, 0x65, 0x78, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23,
	0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6d,
	0x61, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x5b, 0x0a, 0x0f, 0x4c, 0x6f, 0x6e, 0x67,
	0x54, 0x65, 0x78, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0a, 0x6d,
	0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x56, 0x0a, 0x0e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x61,
	0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xd3, 0x02,
	0x0a, 0x0b, 0x44, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x67, 0x0a,
	0x10, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01,
	0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x34, 0x0a,
	0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x34, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52,
	0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x48, 0x0a, 0x0a, 0x44, 0x61, 0x74,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x45, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x4e, 0x47, 0x5f, 0x44, 0x41, 0x54,
	0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x41, 0x54,
	0x45, 0x10, 0x02, 0x1a, 0xf7, 0x11, 0x0a, 0x10, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0c, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x0b, 0x6c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x58, 0x0a, 0x07, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x52, 0x07, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x1a, 0xb1, 0x10, 0x0a, 0x06, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x69, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x4e, 0x0a, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x04,
	0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12,
	0x76, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48, 0x69,
	0x6e, 0x74, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x13, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43,
	0x68, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x12,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x13, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x49, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x41, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49,
	0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x09,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03,
	0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x0c, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x12, 0x43, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xe0, 0x01, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4f, 0x0a, 0x0c, 0x62, 0x61, 0x64, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x36, 0x0a, 0x14, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x62, 0x65, 0x66, 0x6f,
	0x72, 0x65, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x04, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x1a, 0xcc, 0x02, 0x0a, 0x0c, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e,
	0x5f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0e, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x49, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x12, 0x24, 0x0a, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x61, 0x70, 0x70,
	0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x6e, 0x49,
	0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x4f, 0x0a, 0x0c, 0x62, 0x61, 0x64, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42,
	0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x52, 0x0b, 0x62, 0x61, 0x64, 0x67,
	0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x11, 0x64, 0x61, 0x72, 0x6b, 0x5f,
	0x62, 0x61, 0x64, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73,
	0x52, 0x0f, 0x64, 0x61, 0x72, 0x6b, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x64, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x62, 0x61, 0x64, 0x67, 0x65,
	0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x92, 0x01, 0x0a, 0x12, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x6e, 0x0a,
	0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x1a, 0x64, 0x0a,
	0x0b, 0x55, 0x73, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0c,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x6c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x42, 0x81, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x3b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2beta_field_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2beta_field_proto_rawDescData = file_google_apps_drive_labels_v2beta_field_proto_rawDesc
)

func file_google_apps_drive_labels_v2beta_field_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2beta_field_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2beta_field_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2beta_field_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2beta_field_proto_rawDescData
}

var file_google_apps_drive_labels_v2beta_field_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_apps_drive_labels_v2beta_field_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_apps_drive_labels_v2beta_field_proto_goTypes = []interface{}{
	(Field_DateOptions_DateFormat)(0),                         // 0: google.apps.drive.labels.v2beta.Field.DateOptions.DateFormat
	(*Field)(nil),                                             // 1: google.apps.drive.labels.v2beta.Field
	(*Field_Properties)(nil),                                  // 2: google.apps.drive.labels.v2beta.Field.Properties
	(*Field_DisplayHints)(nil),                                // 3: google.apps.drive.labels.v2beta.Field.DisplayHints
	(*Field_SchemaCapabilities)(nil),                          // 4: google.apps.drive.labels.v2beta.Field.SchemaCapabilities
	(*Field_AppliedCapabilities)(nil),                         // 5: google.apps.drive.labels.v2beta.Field.AppliedCapabilities
	(*Field_ListOptions)(nil),                                 // 6: google.apps.drive.labels.v2beta.Field.ListOptions
	(*Field_TextOptions)(nil),                                 // 7: google.apps.drive.labels.v2beta.Field.TextOptions
	(*Field_LongTextOptions)(nil),                             // 8: google.apps.drive.labels.v2beta.Field.LongTextOptions
	(*Field_IntegerOptions)(nil),                              // 9: google.apps.drive.labels.v2beta.Field.IntegerOptions
	(*Field_DateOptions)(nil),                                 // 10: google.apps.drive.labels.v2beta.Field.DateOptions
	(*Field_SelectionOptions)(nil),                            // 11: google.apps.drive.labels.v2beta.Field.SelectionOptions
	(*Field_UserOptions)(nil),                                 // 12: google.apps.drive.labels.v2beta.Field.UserOptions
	(*Field_SelectionOptions_Choice)(nil),                     // 13: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice
	(*Field_SelectionOptions_Choice_Properties)(nil),          // 14: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.Properties
	(*Field_SelectionOptions_Choice_DisplayHints)(nil),        // 15: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.DisplayHints
	(*Field_SelectionOptions_Choice_SchemaCapabilities)(nil),  // 16: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.SchemaCapabilities
	(*Field_SelectionOptions_Choice_AppliedCapabilities)(nil), // 17: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.AppliedCapabilities
	(*Lifecycle)(nil),                                         // 18: google.apps.drive.labels.v2beta.Lifecycle
	(*UserInfo)(nil),                                          // 19: google.apps.drive.labels.v2beta.UserInfo
	(*timestamppb.Timestamp)(nil),                             // 20: google.protobuf.Timestamp
	(*LockStatus)(nil),                                        // 21: google.apps.drive.labels.v2beta.LockStatus
	(*date.Date)(nil),                                         // 22: google.type.Date
	(*BadgeConfig)(nil),                                       // 23: google.apps.drive.labels.v2beta.BadgeConfig
	(*BadgeColors)(nil),                                       // 24: google.apps.drive.labels.v2beta.BadgeColors
}
var file_google_apps_drive_labels_v2beta_field_proto_depIdxs = []int32{
	7,  // 0: google.apps.drive.labels.v2beta.Field.text_options:type_name -> google.apps.drive.labels.v2beta.Field.TextOptions
	9,  // 1: google.apps.drive.labels.v2beta.Field.integer_options:type_name -> google.apps.drive.labels.v2beta.Field.IntegerOptions
	10, // 2: google.apps.drive.labels.v2beta.Field.date_options:type_name -> google.apps.drive.labels.v2beta.Field.DateOptions
	11, // 3: google.apps.drive.labels.v2beta.Field.selection_options:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions
	12, // 4: google.apps.drive.labels.v2beta.Field.user_options:type_name -> google.apps.drive.labels.v2beta.Field.UserOptions
	2,  // 5: google.apps.drive.labels.v2beta.Field.properties:type_name -> google.apps.drive.labels.v2beta.Field.Properties
	18, // 6: google.apps.drive.labels.v2beta.Field.lifecycle:type_name -> google.apps.drive.labels.v2beta.Lifecycle
	3,  // 7: google.apps.drive.labels.v2beta.Field.display_hints:type_name -> google.apps.drive.labels.v2beta.Field.DisplayHints
	4,  // 8: google.apps.drive.labels.v2beta.Field.schema_capabilities:type_name -> google.apps.drive.labels.v2beta.Field.SchemaCapabilities
	5,  // 9: google.apps.drive.labels.v2beta.Field.applied_capabilities:type_name -> google.apps.drive.labels.v2beta.Field.AppliedCapabilities
	19, // 10: google.apps.drive.labels.v2beta.Field.creator:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 11: google.apps.drive.labels.v2beta.Field.create_time:type_name -> google.protobuf.Timestamp
	19, // 12: google.apps.drive.labels.v2beta.Field.updater:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 13: google.apps.drive.labels.v2beta.Field.update_time:type_name -> google.protobuf.Timestamp
	19, // 14: google.apps.drive.labels.v2beta.Field.publisher:type_name -> google.apps.drive.labels.v2beta.UserInfo
	19, // 15: google.apps.drive.labels.v2beta.Field.disabler:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 16: google.apps.drive.labels.v2beta.Field.disable_time:type_name -> google.protobuf.Timestamp
	21, // 17: google.apps.drive.labels.v2beta.Field.lock_status:type_name -> google.apps.drive.labels.v2beta.LockStatus
	0,  // 18: google.apps.drive.labels.v2beta.Field.DateOptions.date_format_type:type_name -> google.apps.drive.labels.v2beta.Field.DateOptions.DateFormat
	22, // 19: google.apps.drive.labels.v2beta.Field.DateOptions.min_value:type_name -> google.type.Date
	22, // 20: google.apps.drive.labels.v2beta.Field.DateOptions.max_value:type_name -> google.type.Date
	6,  // 21: google.apps.drive.labels.v2beta.Field.SelectionOptions.list_options:type_name -> google.apps.drive.labels.v2beta.Field.ListOptions
	13, // 22: google.apps.drive.labels.v2beta.Field.SelectionOptions.choices:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice
	6,  // 23: google.apps.drive.labels.v2beta.Field.UserOptions.list_options:type_name -> google.apps.drive.labels.v2beta.Field.ListOptions
	14, // 24: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.properties:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.Properties
	18, // 25: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.lifecycle:type_name -> google.apps.drive.labels.v2beta.Lifecycle
	15, // 26: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.display_hints:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.DisplayHints
	16, // 27: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.schema_capabilities:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.SchemaCapabilities
	17, // 28: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.applied_capabilities:type_name -> google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.AppliedCapabilities
	19, // 29: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.creator:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 30: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.create_time:type_name -> google.protobuf.Timestamp
	19, // 31: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.updater:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 32: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.update_time:type_name -> google.protobuf.Timestamp
	19, // 33: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.publisher:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 34: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.publish_time:type_name -> google.protobuf.Timestamp
	19, // 35: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.disabler:type_name -> google.apps.drive.labels.v2beta.UserInfo
	20, // 36: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.disable_time:type_name -> google.protobuf.Timestamp
	21, // 37: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.lock_status:type_name -> google.apps.drive.labels.v2beta.LockStatus
	23, // 38: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.Properties.badge_config:type_name -> google.apps.drive.labels.v2beta.BadgeConfig
	24, // 39: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.DisplayHints.badge_colors:type_name -> google.apps.drive.labels.v2beta.BadgeColors
	24, // 40: google.apps.drive.labels.v2beta.Field.SelectionOptions.Choice.DisplayHints.dark_badge_colors:type_name -> google.apps.drive.labels.v2beta.BadgeColors
	41, // [41:41] is the sub-list for method output_type
	41, // [41:41] is the sub-list for method input_type
	41, // [41:41] is the sub-list for extension type_name
	41, // [41:41] is the sub-list for extension extendee
	0,  // [0:41] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2beta_field_proto_init() }
func file_google_apps_drive_labels_v2beta_field_proto_init() {
	if File_google_apps_drive_labels_v2beta_field_proto != nil {
		return
	}
	file_google_apps_drive_labels_v2beta_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_Properties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_DisplayHints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SchemaCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_AppliedCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_ListOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_TextOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_LongTextOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_IntegerOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_DateOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_UserOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions_Choice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions_Choice_Properties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions_Choice_DisplayHints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions_Choice_SchemaCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_field_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Field_SelectionOptions_Choice_AppliedCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_labels_v2beta_field_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Field_TextOptions_)(nil),
		(*Field_IntegerOptions_)(nil),
		(*Field_DateOptions_)(nil),
		(*Field_SelectionOptions_)(nil),
		(*Field_UserOptions_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2beta_field_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2beta_field_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2beta_field_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2beta_field_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2beta_field_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2beta_field_proto = out.File
	file_google_apps_drive_labels_v2beta_field_proto_rawDesc = nil
	file_google_apps_drive_labels_v2beta_field_proto_goTypes = nil
	file_google_apps_drive_labels_v2beta_field_proto_depIdxs = nil
}
