/*
   Copyright The containerd Authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package sbserver

import (
	runtime "k8s.io/cri-api/pkg/apis/runtime/v1"
)

func (c *criService) GetContainerEvents(r *runtime.GetEventsRequest, s runtime.RuntimeService_GetContainerEventsServer) error {
	// TODO (https://github.com/containerd/containerd/issues/7318):
	// replace with a real implementation that broadcasts containerEventsChan
	// to all subscribers.
	for event := range c.containerEventsChan {
		if err := s.Send(&event); err != nil {
			return err
		}
	}
	return nil
}
