package cacheimport

import (
	"time"

	digest "github.com/opencontainers/go-digest"
)

const CacheConfigMediaTypeV0 = "application/vnd.buildkit.cacheconfig.v0"

type CacheConfig struct {
	Layers  []CacheLayer  `json:"layers,omitempty"`
	Records []CacheRecord `json:"records,omitempty"`
}

type CacheLayer struct {
	Blob        digest.Digest     `json:"blob,omitempty"`
	ParentIndex int               `json:"parent,omitempty"`
	Annotations *LayerAnnotations `json:"annotations,omitempty"`
}

type LayerAnnotations struct {
	MediaType string        `json:"mediaType,omitempty"`
	DiffID    digest.Digest `json:"diffID,omitempty"`
	Size      int64         `json:"size,omitempty"`
	CreatedAt time.Time     `json:"createdAt"`
}

type CacheRecord struct {
	Results        []CacheResult   `json:"layers,omitempty"`
	ChainedResults []ChainedResult `json:"chains,omitempty"`
	Digest         digest.Digest   `json:"digest,omitempty"`
	Inputs         [][]CacheInput  `json:"inputs,omitempty"`
}

type CacheResult struct {
	LayerIndex int       `json:"layer"`
	CreatedAt  time.Time `json:"createdAt"`
}

type ChainedResult struct {
	LayerIndexes []int     `json:"layers"`
	CreatedAt    time.Time `json:"createdAt"`
}

type CacheInput struct {
	Selector  string `json:"selector,omitempty"`
	LinkIndex int    `json:"link"`
}
