// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkemulticloud/v1/common_resources.proto

package gkemulticloud

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The taint effect.
type NodeTaint_Effect int32

const (
	// Not set.
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// Do not allow new pods to schedule onto the node unless they tolerate the
	// taint, but allow all pods submitted to Kubelet without going through the
	// scheduler to start, and allow all already-running pods to continue
	// running. Enforced by the scheduler.
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// Like TaintEffectNoSchedule, but the scheduler tries not to schedule
	// new pods onto the node, rather than prohibiting new pods from scheduling
	// onto the node entirely. Enforced by the scheduler.
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// Evict any already-running pods that do not tolerate the taint.
	// Currently enforced by NodeController.
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

// Enum value maps for NodeTaint_Effect.
var (
	NodeTaint_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "NO_SCHEDULE",
		2: "PREFER_NO_SCHEDULE",
		3: "NO_EXECUTE",
	}
	NodeTaint_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED": 0,
		"NO_SCHEDULE":        1,
		"PREFER_NO_SCHEDULE": 2,
		"NO_EXECUTE":         3,
	}
)

func (x NodeTaint_Effect) Enum() *NodeTaint_Effect {
	p := new(NodeTaint_Effect)
	*p = x
	return p
}

func (x NodeTaint_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTaint_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[0].Descriptor()
}

func (NodeTaint_Effect) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[0]
}

func (x NodeTaint_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTaint_Effect.Descriptor instead.
func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{3, 0}
}

// The components of the logging configuration;
type LoggingComponentConfig_Component int32

const (
	// No component is specified
	LoggingComponentConfig_COMPONENT_UNSPECIFIED LoggingComponentConfig_Component = 0
	// This indicates that system logging components is enabled.
	LoggingComponentConfig_SYSTEM_COMPONENTS LoggingComponentConfig_Component = 1
	// This indicates that user workload logging component is enabled.
	LoggingComponentConfig_WORKLOADS LoggingComponentConfig_Component = 2
)

// Enum value maps for LoggingComponentConfig_Component.
var (
	LoggingComponentConfig_Component_name = map[int32]string{
		0: "COMPONENT_UNSPECIFIED",
		1: "SYSTEM_COMPONENTS",
		2: "WORKLOADS",
	}
	LoggingComponentConfig_Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"SYSTEM_COMPONENTS":     1,
		"WORKLOADS":             2,
	}
)

func (x LoggingComponentConfig_Component) Enum() *LoggingComponentConfig_Component {
	p := new(LoggingComponentConfig_Component)
	*p = x
	return p
}

func (x LoggingComponentConfig_Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingComponentConfig_Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[1].Descriptor()
}

func (LoggingComponentConfig_Component) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes[1]
}

func (x LoggingComponentConfig_Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingComponentConfig_Component.Descriptor instead.
func (LoggingComponentConfig_Component) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{6, 0}
}

// Workload Identity settings.
type WorkloadIdentityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OIDC issuer URL for this cluster.
	IssuerUri string `protobuf:"bytes,1,opt,name=issuer_uri,json=issuerUri,proto3" json:"issuer_uri,omitempty"`
	// The Workload Identity Pool associated to the cluster.
	WorkloadPool string `protobuf:"bytes,2,opt,name=workload_pool,json=workloadPool,proto3" json:"workload_pool,omitempty"`
	// The ID of the OIDC Identity Provider (IdP) associated to the Workload
	// Identity Pool.
	IdentityProvider string `protobuf:"bytes,3,opt,name=identity_provider,json=identityProvider,proto3" json:"identity_provider,omitempty"`
}

func (x *WorkloadIdentityConfig) Reset() {
	*x = WorkloadIdentityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityConfig) ProtoMessage() {}

func (x *WorkloadIdentityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityConfig.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{0}
}

func (x *WorkloadIdentityConfig) GetIssuerUri() string {
	if x != nil {
		return x.IssuerUri
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetWorkloadPool() string {
	if x != nil {
		return x.WorkloadPool
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetIdentityProvider() string {
	if x != nil {
		return x.IdentityProvider
	}
	return ""
}

// Constraints applied to pods.
type MaxPodsConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The maximum number of pods to schedule on a single node.
	MaxPodsPerNode int64 `protobuf:"varint,1,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3" json:"max_pods_per_node,omitempty"`
}

func (x *MaxPodsConstraint) Reset() {
	*x = MaxPodsConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaxPodsConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaxPodsConstraint) ProtoMessage() {}

func (x *MaxPodsConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaxPodsConstraint.ProtoReflect.Descriptor instead.
func (*MaxPodsConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{1}
}

func (x *MaxPodsConstraint) GetMaxPodsPerNode() int64 {
	if x != nil {
		return x.MaxPodsPerNode
	}
	return 0
}

// Metadata about a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which this operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this operation was completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the resource associated to this operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,4,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Output only. Human-readable status of any error that occurred during the operation.
	ErrorDetail string `protobuf:"bytes,5,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{2}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetErrorDetail() string {
	if x != nil {
		return x.ErrorDetail
	}
	return ""
}

// The taint content for the node taint.
type NodeTaint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Key for the taint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. Value for the taint.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The taint effect.
	Effect NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.cloud.gkemulticloud.v1.NodeTaint_Effect" json:"effect,omitempty"`
}

func (x *NodeTaint) Reset() {
	*x = NodeTaint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeTaint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTaint) ProtoMessage() {}

func (x *NodeTaint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTaint.ProtoReflect.Descriptor instead.
func (*NodeTaint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{3}
}

func (x *NodeTaint) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *NodeTaint) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *NodeTaint) GetEffect() NodeTaint_Effect {
	if x != nil {
		return x.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// Fleet related configuration.
//
// Fleets are a Google Cloud concept for logically organizing clusters,
// letting you use and manage multi-cluster capabilities and apply
// consistent policies across your systems.
//
// See [Anthos
// Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
// more details on Anthos multi-cluster capabilities using Fleets.
type Fleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Fleet host project where this cluster will be registered.
	//
	// Project names are formatted as
	// `projects/<project-number>`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. The name of the managed Hub Membership resource associated to this cluster.
	//
	// Membership names are formatted as
	// `projects/<project-number>/locations/global/membership/<cluster-id>`.
	Membership string `protobuf:"bytes,2,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *Fleet) Reset() {
	*x = Fleet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fleet) ProtoMessage() {}

func (x *Fleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fleet.ProtoReflect.Descriptor instead.
func (*Fleet) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Fleet) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Fleet) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

// Parameters that describe the Logging configuration in a cluster.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of the logging components;
	ComponentConfig *LoggingComponentConfig `protobuf:"bytes,1,opt,name=component_config,json=componentConfig,proto3" json:"component_config,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{5}
}

func (x *LoggingConfig) GetComponentConfig() *LoggingComponentConfig {
	if x != nil {
		return x.ComponentConfig
	}
	return nil
}

// Parameters that describe the Logging component configuration in a cluster.
type LoggingComponentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The components to be enabled.
	EnableComponents []LoggingComponentConfig_Component `protobuf:"varint,1,rep,packed,name=enable_components,json=enableComponents,proto3,enum=google.cloud.gkemulticloud.v1.LoggingComponentConfig_Component" json:"enable_components,omitempty"`
}

func (x *LoggingComponentConfig) Reset() {
	*x = LoggingComponentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingComponentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingComponentConfig) ProtoMessage() {}

func (x *LoggingComponentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingComponentConfig.ProtoReflect.Descriptor instead.
func (*LoggingComponentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP(), []int{6}
}

func (x *LoggingComponentConfig) GetEnableComponents() []LoggingComponentConfig_Component {
	if x != nil {
		return x.EnableComponents
	}
	return nil
}

var File_google_cloud_gkemulticloud_v1_common_resources_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x89, 0x01, 0x0a, 0x16, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x55, 0x72,
	0x69, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x22, 0x43, 0x0a, 0x11, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f,
	0x70, 0x6f, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x6f, 0x64,
	0x73, 0x50, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x22, 0x80, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xe6, 0x01, 0x0a, 0x09,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x22, 0x59, 0x0a, 0x06, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12,
	0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55,
	0x4c, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x45, 0x10, 0x03, 0x22, 0x4b, 0x0a, 0x05, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x12, 0x1d, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x23, 0x0a, 0x0a,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x22, 0x71, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x60, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6c, 0x0a, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x4c, 0x0a,
	0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f,
	0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f,
	0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x53, 0x10, 0x02, 0x42, 0x87, 0x01, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x42, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData = file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes = []interface{}{
	(NodeTaint_Effect)(0),                 // 0: google.cloud.gkemulticloud.v1.NodeTaint.Effect
	(LoggingComponentConfig_Component)(0), // 1: google.cloud.gkemulticloud.v1.LoggingComponentConfig.Component
	(*WorkloadIdentityConfig)(nil),        // 2: google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	(*MaxPodsConstraint)(nil),             // 3: google.cloud.gkemulticloud.v1.MaxPodsConstraint
	(*OperationMetadata)(nil),             // 4: google.cloud.gkemulticloud.v1.OperationMetadata
	(*NodeTaint)(nil),                     // 5: google.cloud.gkemulticloud.v1.NodeTaint
	(*Fleet)(nil),                         // 6: google.cloud.gkemulticloud.v1.Fleet
	(*LoggingConfig)(nil),                 // 7: google.cloud.gkemulticloud.v1.LoggingConfig
	(*LoggingComponentConfig)(nil),        // 8: google.cloud.gkemulticloud.v1.LoggingComponentConfig
	(*timestamppb.Timestamp)(nil),         // 9: google.protobuf.Timestamp
}
var file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs = []int32{
	9, // 0: google.cloud.gkemulticloud.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	9, // 1: google.cloud.gkemulticloud.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0, // 2: google.cloud.gkemulticloud.v1.NodeTaint.effect:type_name -> google.cloud.gkemulticloud.v1.NodeTaint.Effect
	8, // 3: google.cloud.gkemulticloud.v1.LoggingConfig.component_config:type_name -> google.cloud.gkemulticloud.v1.LoggingComponentConfig
	1, // 4: google.cloud.gkemulticloud.v1.LoggingComponentConfig.enable_components:type_name -> google.cloud.gkemulticloud.v1.LoggingComponentConfig.Component
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_common_resources_proto_init() }
func file_google_cloud_gkemulticloud_v1_common_resources_proto_init() {
	if File_google_cloud_gkemulticloud_v1_common_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaxPodsConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeTaint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Fleet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingComponentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkemulticloud_v1_common_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_common_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_common_resources_proto = out.File
	file_google_cloud_gkemulticloud_v1_common_resources_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_common_resources_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_common_resources_proto_depIdxs = nil
}
