// Code generated by github.com/jmattheis/goverter, DO NOT EDIT.
//go:build !goverter

package generated

import house "github.com/jmattheis/goverter/example/house"

type ConverterImpl struct{}

func (c *ConverterImpl) ConvertApartment(source house.DBApartment) house.APIApartment {
	var houseAPIApartment house.APIApartment
	houseAPIApartment.Position = source.Position
	houseAPIApartment.Owner = c.ConvertPerson(source.Owner)
	houseAPIApartment.OwnerName = source.Owner.Name
	if source.CoResident != nil {
		houseAPIApartment.CoResident = make([]house.APIPerson, len(source.CoResident))
		for i := 0; i < len(source.CoResident); i++ {
			houseAPIApartment.CoResident[i] = c.ConvertPerson(source.CoResident[i])
		}
	}
	return houseAPIApartment
}
func (c *ConverterImpl) ConvertHouse(source house.DBHouse) house.APIHouse {
	var houseAPIHouse house.APIHouse
	houseAPIHouse.Address = source.Address
	if source.Apartments != nil {
		houseAPIHouse.Apartments = make(map[house.APIRoomNR]house.APIApartment, len(source.Apartments))
		for key, value := range source.Apartments {
			houseAPIHouse.Apartments[house.APIRoomNR(key)] = c.ConvertApartment(value)
		}
	}
	return houseAPIHouse
}
func (c *ConverterImpl) ConvertPerson(source house.DBPerson) house.APIPerson {
	var houseAPIPerson house.APIPerson
	houseAPIPerson.ID = source.ID
	houseAPIPerson.MiddleName = house.SQLStringToPString(source.MiddleName)
	pString := source.Name
	houseAPIPerson.FirstName = &pString
	if source.Friends != nil {
		houseAPIPerson.Friends = make([]house.APIPerson, len(source.Friends))
		for i := 0; i < len(source.Friends); i++ {
			houseAPIPerson.Friends[i] = c.ConvertPerson(source.Friends[i])
		}
	}
	return houseAPIPerson
}
