// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkidentity

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAppInstance = "CreateAppInstance"

// CreateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstance for more information on using the CreateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppInstanceRequest method.
//    req, resp := client.CreateAppInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance
func (c *ChimeSDKIdentity) CreateAppInstanceRequest(input *CreateAppInstanceInput) (req *request.Request, output *CreateAppInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances",
	}

	if input == nil {
		input = &CreateAppInstanceInput{}
	}

	output = &CreateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstance API operation for Amazon Chime SDK Identity.
//
// Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only
// SDK messaging customers use this API. CreateAppInstance supports idempotency
// behavior as described in the AWS API Standard.
//
// identity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstance for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstance
func (c *ChimeSDKIdentity) CreateAppInstance(input *CreateAppInstanceInput) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	return out, req.Send()
}

// CreateAppInstanceWithContext is the same as CreateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceWithContext(ctx aws.Context, input *CreateAppInstanceInput, opts ...request.Option) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceAdmin = "CreateAppInstanceAdmin"

// CreateAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceAdmin for more information on using the CreateAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppInstanceAdminRequest method.
//    req, resp := client.CreateAppInstanceAdminRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin
func (c *ChimeSDKIdentity) CreateAppInstanceAdminRequest(input *CreateAppInstanceAdminInput) (req *request.Request, output *CreateAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstanceAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
	}

	if input == nil {
		input = &CreateAppInstanceAdminInput{}
	}

	output = &CreateAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can
// perform the following actions.
//
//    * ChannelModerator actions across all channels in the AppInstance.
//
//    * DeleteChannelMessage actions.
//
// Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceAdmin
func (c *ChimeSDKIdentity) CreateAppInstanceAdmin(input *CreateAppInstanceAdminInput) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	return out, req.Send()
}

// CreateAppInstanceAdminWithContext is the same as CreateAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceAdminWithContext(ctx aws.Context, input *CreateAppInstanceAdminInput, opts ...request.Option) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceUser = "CreateAppInstanceUser"

// CreateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceUser for more information on using the CreateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppInstanceUserRequest method.
//    req, resp := client.CreateAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser
func (c *ChimeSDKIdentity) CreateAppInstanceUserRequest(input *CreateAppInstanceUserInput) (req *request.Request, output *CreateAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opCreateAppInstanceUser,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instance-users",
	}

	if input == nil {
		input = &CreateAppInstanceUserInput{}
	}

	output = &CreateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Creates a user under an Amazon Chime AppInstance. The request consists of
// a unique appInstanceUserId and Name for that user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation CreateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/CreateAppInstanceUser
func (c *ChimeSDKIdentity) CreateAppInstanceUser(input *CreateAppInstanceUserInput) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	return out, req.Send()
}

// CreateAppInstanceUserWithContext is the same as CreateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) CreateAppInstanceUserWithContext(ctx aws.Context, input *CreateAppInstanceUserInput, opts ...request.Option) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstance = "DeleteAppInstance"

// DeleteAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstance for more information on using the DeleteAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppInstanceRequest method.
//    req, resp := client.DeleteAppInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance
func (c *ChimeSDKIdentity) DeleteAppInstanceRequest(input *DeleteAppInstanceInput) (req *request.Request, output *DeleteAppInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceInput{}
	}

	output = &DeleteAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstance API operation for Amazon Chime SDK Identity.
//
// Deletes an AppInstance and all associated data asynchronously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstance for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstance
func (c *ChimeSDKIdentity) DeleteAppInstance(input *DeleteAppInstanceInput) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceWithContext is the same as DeleteAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceWithContext(ctx aws.Context, input *DeleteAppInstanceInput, opts ...request.Option) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceAdmin = "DeleteAppInstanceAdmin"

// DeleteAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceAdmin for more information on using the DeleteAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppInstanceAdminRequest method.
//    req, resp := client.DeleteAppInstanceAdminRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin
func (c *ChimeSDKIdentity) DeleteAppInstanceAdminRequest(input *DeleteAppInstanceAdminInput) (req *request.Request, output *DeleteAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstanceAdmin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceAdminInput{}
	}

	output = &DeleteAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete
// the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceAdmin
func (c *ChimeSDKIdentity) DeleteAppInstanceAdmin(input *DeleteAppInstanceAdminInput) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceAdminWithContext is the same as DeleteAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceAdminWithContext(ctx aws.Context, input *DeleteAppInstanceAdminInput, opts ...request.Option) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceUser = "DeleteAppInstanceUser"

// DeleteAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceUser for more information on using the DeleteAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppInstanceUserRequest method.
//    req, resp := client.DeleteAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser
func (c *ChimeSDKIdentity) DeleteAppInstanceUserRequest(input *DeleteAppInstanceUserInput) (req *request.Request, output *DeleteAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDeleteAppInstanceUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceUserInput{}
	}

	output = &DeleteAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Deletes an AppInstanceUser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DeleteAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DeleteAppInstanceUser
func (c *ChimeSDKIdentity) DeleteAppInstanceUser(input *DeleteAppInstanceUserInput) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceUserWithContext is the same as DeleteAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DeleteAppInstanceUserWithContext(ctx aws.Context, input *DeleteAppInstanceUserInput, opts ...request.Option) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstance = "DescribeAppInstance"

// DescribeAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstance for more information on using the DescribeAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppInstanceRequest method.
//    req, resp := client.DescribeAppInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance
func (c *ChimeSDKIdentity) DescribeAppInstanceRequest(input *DescribeAppInstanceInput) (req *request.Request, output *DescribeAppInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceInput{}
	}

	output = &DescribeAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstance API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstance for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstance
func (c *ChimeSDKIdentity) DescribeAppInstance(input *DescribeAppInstanceInput) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceWithContext is the same as DescribeAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceWithContext(ctx aws.Context, input *DescribeAppInstanceInput, opts ...request.Option) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceAdmin = "DescribeAppInstanceAdmin"

// DescribeAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceAdmin for more information on using the DescribeAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppInstanceAdminRequest method.
//    req, resp := client.DescribeAppInstanceAdminRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin
func (c *ChimeSDKIdentity) DescribeAppInstanceAdminRequest(input *DescribeAppInstanceAdminInput) (req *request.Request, output *DescribeAppInstanceAdminOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceAdmin,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceAdminInput{}
	}

	output = &DescribeAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceAdmin API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstanceAdmin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceAdmin
func (c *ChimeSDKIdentity) DescribeAppInstanceAdmin(input *DescribeAppInstanceAdminInput) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceAdminWithContext is the same as DescribeAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceAdminWithContext(ctx aws.Context, input *DescribeAppInstanceAdminInput, opts ...request.Option) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceUser = "DescribeAppInstanceUser"

// DescribeAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceUser for more information on using the DescribeAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppInstanceUserRequest method.
//    req, resp := client.DescribeAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser
func (c *ChimeSDKIdentity) DescribeAppInstanceUserRequest(input *DescribeAppInstanceUserInput) (req *request.Request, output *DescribeAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opDescribeAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceUserInput{}
	}

	output = &DescribeAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Returns the full details of an AppInstanceUser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation DescribeAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/DescribeAppInstanceUser
func (c *ChimeSDKIdentity) DescribeAppInstanceUser(input *DescribeAppInstanceUserInput) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceUserWithContext is the same as DescribeAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) DescribeAppInstanceUserWithContext(ctx aws.Context, input *DescribeAppInstanceUserInput, opts ...request.Option) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppInstanceRetentionSettings = "GetAppInstanceRetentionSettings"

// GetAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppInstanceRetentionSettings for more information on using the GetAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppInstanceRetentionSettingsRequest method.
//    req, resp := client.GetAppInstanceRetentionSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettingsRequest(input *GetAppInstanceRetentionSettingsInput) (req *request.Request, output *GetAppInstanceRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAppInstanceRetentionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &GetAppInstanceRetentionSettingsInput{}
	}

	output = &GetAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppInstanceRetentionSettings API operation for Amazon Chime SDK Identity.
//
// Gets the retention settings for an AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation GetAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/GetAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettings(input *GetAppInstanceRetentionSettingsInput) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// GetAppInstanceRetentionSettingsWithContext is the same as GetAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) GetAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *GetAppInstanceRetentionSettingsInput, opts ...request.Option) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAppInstanceAdmins = "ListAppInstanceAdmins"

// ListAppInstanceAdminsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceAdmins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceAdmins for more information on using the ListAppInstanceAdmins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppInstanceAdminsRequest method.
//    req, resp := client.ListAppInstanceAdminsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins
func (c *ChimeSDKIdentity) ListAppInstanceAdminsRequest(input *ListAppInstanceAdminsInput) (req *request.Request, output *ListAppInstanceAdminsOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceAdmins,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceAdminsInput{}
	}

	output = &ListAppInstanceAdminsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceAdmins API operation for Amazon Chime SDK Identity.
//
// Returns a list of the administrators in the AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceAdmins for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceAdmins
func (c *ChimeSDKIdentity) ListAppInstanceAdmins(input *ListAppInstanceAdminsInput) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	return out, req.Send()
}

// ListAppInstanceAdminsWithContext is the same as ListAppInstanceAdmins with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceAdmins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceAdminsWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, opts ...request.Option) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceAdminsPages iterates over the pages of a ListAppInstanceAdmins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceAdmins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppInstanceAdmins operation.
//    pageNum := 0
//    err := client.ListAppInstanceAdminsPages(params,
//        func(page *chimesdkidentity.ListAppInstanceAdminsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKIdentity) ListAppInstanceAdminsPages(input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool) error {
	return c.ListAppInstanceAdminsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceAdminsPagesWithContext same as ListAppInstanceAdminsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceAdminsPagesWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceAdminsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceAdminsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceAdminsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceUsers = "ListAppInstanceUsers"

// ListAppInstanceUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceUsers for more information on using the ListAppInstanceUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppInstanceUsersRequest method.
//    req, resp := client.ListAppInstanceUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers
func (c *ChimeSDKIdentity) ListAppInstanceUsersRequest(input *ListAppInstanceUsersInput) (req *request.Request, output *ListAppInstanceUsersOutput) {
	op := &request.Operation{
		Name:       opListAppInstanceUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceUsersInput{}
	}

	output = &ListAppInstanceUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstanceUsers API operation for Amazon Chime SDK Identity.
//
// List all AppInstanceUsers created under a single AppInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstanceUsers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstanceUsers
func (c *ChimeSDKIdentity) ListAppInstanceUsers(input *ListAppInstanceUsersInput) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	return out, req.Send()
}

// ListAppInstanceUsersWithContext is the same as ListAppInstanceUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUsersWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, opts ...request.Option) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceUsersPages iterates over the pages of a ListAppInstanceUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppInstanceUsers operation.
//    pageNum := 0
//    err := client.ListAppInstanceUsersPages(params,
//        func(page *chimesdkidentity.ListAppInstanceUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKIdentity) ListAppInstanceUsersPages(input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool) error {
	return c.ListAppInstanceUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceUsersPagesWithContext same as ListAppInstanceUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstanceUsersPagesWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstances = "ListAppInstances"

// ListAppInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstances for more information on using the ListAppInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppInstancesRequest method.
//    req, resp := client.ListAppInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances
func (c *ChimeSDKIdentity) ListAppInstancesRequest(input *ListAppInstancesInput) (req *request.Request, output *ListAppInstancesOutput) {
	op := &request.Operation{
		Name:       opListAppInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstancesInput{}
	}

	output = &ListAppInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppInstances API operation for Amazon Chime SDK Identity.
//
// Lists all Amazon Chime AppInstances created under a single AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation ListAppInstances for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/ListAppInstances
func (c *ChimeSDKIdentity) ListAppInstances(input *ListAppInstancesInput) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	return out, req.Send()
}

// ListAppInstancesWithContext is the same as ListAppInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstancesWithContext(ctx aws.Context, input *ListAppInstancesInput, opts ...request.Option) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstancesPages iterates over the pages of a ListAppInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppInstances operation.
//    pageNum := 0
//    err := client.ListAppInstancesPages(params,
//        func(page *chimesdkidentity.ListAppInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKIdentity) ListAppInstancesPages(input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool) error {
	return c.ListAppInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstancesPagesWithContext same as ListAppInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) ListAppInstancesPagesWithContext(ctx aws.Context, input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAppInstanceRetentionSettings = "PutAppInstanceRetentionSettings"

// PutAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppInstanceRetentionSettings for more information on using the PutAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAppInstanceRetentionSettingsRequest method.
//    req, resp := client.PutAppInstanceRetentionSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettingsRequest(input *PutAppInstanceRetentionSettingsInput) (req *request.Request, output *PutAppInstanceRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opPutAppInstanceRetentionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &PutAppInstanceRetentionSettingsInput{}
	}

	output = &PutAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAppInstanceRetentionSettings API operation for Amazon Chime SDK Identity.
//
// Sets the amount of time in days that a given AppInstance retains data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation PutAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/PutAppInstanceRetentionSettings
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettings(input *PutAppInstanceRetentionSettingsInput) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// PutAppInstanceRetentionSettingsWithContext is the same as PutAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) PutAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *PutAppInstanceRetentionSettingsInput, opts ...request.Option) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstance = "UpdateAppInstance"

// UpdateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstance for more information on using the UpdateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppInstanceRequest method.
//    req, resp := client.UpdateAppInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance
func (c *ChimeSDKIdentity) UpdateAppInstanceRequest(input *UpdateAppInstanceInput) (req *request.Request, output *UpdateAppInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstance,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceInput{}
	}

	output = &UpdateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstance API operation for Amazon Chime SDK Identity.
//
// Updates AppInstance metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstance for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstance
func (c *ChimeSDKIdentity) UpdateAppInstance(input *UpdateAppInstanceInput) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceWithContext is the same as UpdateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceWithContext(ctx aws.Context, input *UpdateAppInstanceInput, opts ...request.Option) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstanceUser = "UpdateAppInstanceUser"

// UpdateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstanceUser for more information on using the UpdateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppInstanceUserRequest method.
//    req, resp := client.UpdateAppInstanceUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser
func (c *ChimeSDKIdentity) UpdateAppInstanceUserRequest(input *UpdateAppInstanceUserInput) (req *request.Request, output *UpdateAppInstanceUserOutput) {
	op := &request.Operation{
		Name:       opUpdateAppInstanceUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceUserInput{}
	}

	output = &UpdateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppInstanceUser API operation for Amazon Chime SDK Identity.
//
// Updates the details of an AppInstanceUser. You can update names and metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Identity's
// API operation UpdateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/UpdateAppInstanceUser
func (c *ChimeSDKIdentity) UpdateAppInstanceUser(input *UpdateAppInstanceUserInput) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceUserWithContext is the same as UpdateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKIdentity) UpdateAppInstanceUserWithContext(ctx aws.Context, input *UpdateAppInstanceUserInput, opts ...request.Option) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The details of an AppInstance, an instance of an Amazon Chime SDK messaging
// application.
type AppInstance struct {
	_ struct{} `type:"structure"`

	// The ARN of the messaging instance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an AppInstance was created. In epoch milliseconds.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time an AppInstance was last updated. In epoch milliseconds.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of an AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstance) SetAppInstanceArn(v string) *AppInstance {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstance) SetCreatedTimestamp(v time.Time) *AppInstance {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstance) SetLastUpdatedTimestamp(v time.Time) *AppInstance {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstance) SetMetadata(v string) *AppInstance {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstance) SetName(v string) *AppInstance {
	s.Name = &v
	return s
}

// The details of an AppInstanceAdmin.
type AppInstanceAdmin struct {
	_ struct{} `type:"structure"`

	// The AppInstanceAdmin data.
	Admin *Identity `type:"structure"`

	// The ARN of the AppInstance for which the user is an administrator.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an administrator was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdmin) SetAdmin(v *Identity) *AppInstanceAdmin {
	s.Admin = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceAdmin) SetAppInstanceArn(v string) *AppInstanceAdmin {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceAdmin) SetCreatedTimestamp(v time.Time) *AppInstanceAdmin {
	s.CreatedTimestamp = &v
	return s
}

// Summary of the details of an AppInstanceAdmin.
type AppInstanceAdminSummary struct {
	_ struct{} `type:"structure"`

	// The details of the AppInstanceAdmin.
	Admin *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdminSummary) SetAdmin(v *Identity) *AppInstanceAdminSummary {
	s.Admin = v
	return s
}

// The details of the data-retention settings for an AppInstance.
type AppInstanceRetentionSettings struct {
	_ struct{} `type:"structure"`

	// The length of time in days to retain the messages in a channel.
	ChannelRetentionSettings *ChannelRetentionSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppInstanceRetentionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppInstanceRetentionSettings"}
	if s.ChannelRetentionSettings != nil {
		if err := s.ChannelRetentionSettings.Validate(); err != nil {
			invalidParams.AddNested("ChannelRetentionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelRetentionSettings sets the ChannelRetentionSettings field's value.
func (s *AppInstanceRetentionSettings) SetChannelRetentionSettings(v *ChannelRetentionSettings) *AppInstanceRetentionSettings {
	s.ChannelRetentionSettings = v
	return s
}

// Summary of the data for an AppInstance.
type AppInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The AppInstance ARN.
	AppInstanceArn *string `min:"5" type:"string"`

	// The metadata of the AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceSummary) SetAppInstanceArn(v string) *AppInstanceSummary {
	s.AppInstanceArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceSummary) SetMetadata(v string) *AppInstanceSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceSummary) SetName(v string) *AppInstanceSummary {
	s.Name = &v
	return s
}

// The details of an AppInstanceUser.
type AppInstanceUser struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The time at which the AppInstanceUser was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which the AppInstanceUser was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUser) SetAppInstanceUserArn(v string) *AppInstanceUser {
	s.AppInstanceUserArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceUser) SetCreatedTimestamp(v time.Time) *AppInstanceUser {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstanceUser) SetLastUpdatedTimestamp(v time.Time) *AppInstanceUser {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUser) SetMetadata(v string) *AppInstanceUser {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUser) SetName(v string) *AppInstanceUser {
	s.Name = &v
	return s
}

// Summary of the details of an AppInstanceUser.
type AppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUserSummary) SetAppInstanceUserArn(v string) *AppInstanceUserSummary {
	s.AppInstanceUserArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUserSummary) SetMetadata(v string) *AppInstanceUserSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUserSummary) SetName(v string) *AppInstanceUserSummary {
	s.Name = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of the retention settings for a channel.
type ChannelRetentionSettings struct {
	_ struct{} `type:"structure"`

	// The time in days to retain the messages in a channel.
	RetentionDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelRetentionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelRetentionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelRetentionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelRetentionSettings"}
	if s.RetentionDays != nil && *s.RetentionDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *ChannelRetentionSettings) SetRetentionDays(v int64) *ChannelRetentionSettings {
	s.RetentionDays = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAppInstanceAdminInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the administrator of the current AppInstance.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *CreateAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *CreateAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceAdminInput) SetAppInstanceArn(v string) *CreateAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`

	// The name and ARN of the admin for the AppInstance.
	AppInstanceAdmin *Identity `type:"structure"`

	// The ARN of the of the admin for the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceAdminOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmin sets the AppInstanceAdmin field's value.
func (s *CreateAppInstanceAdminOutput) SetAppInstanceAdmin(v *Identity) *CreateAppInstanceAdminOutput {
	s.AppInstanceAdmin = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceAdminOutput) SetAppInstanceArn(v string) *CreateAppInstanceAdminOutput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ClientRequestToken of the AppInstance.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The metadata of the AppInstance. Limited to a 1KB string in UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Tags assigned to the AppInstanceUser.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAppInstanceInput) SetClientRequestToken(v string) *CreateAppInstanceInput {
	s.ClientRequestToken = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateAppInstanceInput) SetMetadata(v string) *CreateAppInstanceInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInstanceInput) SetName(v string) *CreateAppInstanceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInstanceInput) SetTags(v []*Tag) *CreateAppInstanceInput {
	s.Tags = v
	return s
}

type CreateAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceOutput) SetAppInstanceArn(v string) *CreateAppInstanceOutput {
	s.AppInstanceArn = &v
	return s
}

type CreateAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance request.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `min:"5" type:"string" required:"true"`

	// The user ID of the AppInstance.
	//
	// AppInstanceUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	//
	// AppInstanceUserId is a required field
	AppInstanceUserId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The token assigned to the user requesting an AppInstance.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The request's metadata. Limited to a 1KB string in UTF-8.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The user's name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Tags assigned to the AppInstanceUser.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInstanceUserInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.AppInstanceUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserId"))
	}
	if s.AppInstanceUserId != nil && len(*s.AppInstanceUserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *CreateAppInstanceUserInput) SetAppInstanceArn(v string) *CreateAppInstanceUserInput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceUserId sets the AppInstanceUserId field's value.
func (s *CreateAppInstanceUserInput) SetAppInstanceUserId(v string) *CreateAppInstanceUserInput {
	s.AppInstanceUserId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAppInstanceUserInput) SetClientRequestToken(v string) *CreateAppInstanceUserInput {
	s.ClientRequestToken = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateAppInstanceUserInput) SetMetadata(v string) *CreateAppInstanceUserInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInstanceUserInput) SetName(v string) *CreateAppInstanceUserInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInstanceUserInput) SetTags(v []*Tag) *CreateAppInstanceUserInput {
	s.Tags = v
	return s
}

type CreateAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The user's ARN.
	AppInstanceUserArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *CreateAppInstanceUserOutput) SetAppInstanceUserArn(v string) *CreateAppInstanceUserOutput {
	s.AppInstanceUserArn = &v
	return s
}

type DeleteAppInstanceAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance's administrator.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `location:"uri" locationName:"appInstanceAdminArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *DeleteAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *DeleteAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DeleteAppInstanceAdminInput) SetAppInstanceArn(v string) *DeleteAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type DeleteAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceAdminOutput) GoString() string {
	return s.String()
}

type DeleteAppInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DeleteAppInstanceInput) SetAppInstanceArn(v string) *DeleteAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

type DeleteAppInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceOutput) GoString() string {
	return s.String()
}

type DeleteAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the user request being deleted.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DeleteAppInstanceUserInput) SetAppInstanceUserArn(v string) *DeleteAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

type DeleteAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInstanceUserOutput) GoString() string {
	return s.String()
}

type DescribeAppInstanceAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceAdmin.
	//
	// AppInstanceAdminArn is a required field
	AppInstanceAdminArn *string `location:"uri" locationName:"appInstanceAdminArn" min:"5" type:"string" required:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceAdminInput"}
	if s.AppInstanceAdminArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceAdminArn"))
	}
	if s.AppInstanceAdminArn != nil && len(*s.AppInstanceAdminArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceAdminArn", 5))
	}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceAdminArn sets the AppInstanceAdminArn field's value.
func (s *DescribeAppInstanceAdminInput) SetAppInstanceAdminArn(v string) *DescribeAppInstanceAdminInput {
	s.AppInstanceAdminArn = &v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DescribeAppInstanceAdminInput) SetAppInstanceArn(v string) *DescribeAppInstanceAdminInput {
	s.AppInstanceArn = &v
	return s
}

type DescribeAppInstanceAdminOutput struct {
	_ struct{} `type:"structure"`

	// The ARN and name of the AppInstanceUser, the ARN of the AppInstance, and
	// the created and last-updated timestamps. All timestamps use epoch milliseconds.
	AppInstanceAdmin *AppInstanceAdmin `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceAdminOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmin sets the AppInstanceAdmin field's value.
func (s *DescribeAppInstanceAdminOutput) SetAppInstanceAdmin(v *AppInstanceAdmin) *DescribeAppInstanceAdminOutput {
	s.AppInstanceAdmin = v
	return s
}

type DescribeAppInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *DescribeAppInstanceInput) SetAppInstanceArn(v string) *DescribeAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

type DescribeAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN, metadata, created and last-updated timestamps, and the name of the
	// AppInstance. All timestamps use epoch milliseconds.
	AppInstance *AppInstance `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstance sets the AppInstance field's value.
func (s *DescribeAppInstanceOutput) SetAppInstance(v *AppInstance) *DescribeAppInstanceOutput {
	s.AppInstance = v
	return s
}

type DescribeAppInstanceUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *DescribeAppInstanceUserInput) SetAppInstanceUserArn(v string) *DescribeAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

type DescribeAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The name of the AppInstanceUser.
	AppInstanceUser *AppInstanceUser `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUser sets the AppInstanceUser field's value.
func (s *DescribeAppInstanceUserOutput) SetAppInstanceUser(v *AppInstanceUser) *DescribeAppInstanceUserOutput {
	s.AppInstanceUser = v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAppInstanceRetentionSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInstanceRetentionSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInstanceRetentionSettingsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *GetAppInstanceRetentionSettingsInput) SetAppInstanceArn(v string) *GetAppInstanceRetentionSettingsInput {
	s.AppInstanceArn = &v
	return s
}

type GetAppInstanceRetentionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The retention settings for the AppInstance.
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure"`

	// The timestamp representing the time at which the specified items are retained,
	// in Epoch Seconds.
	InitiateDeletionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAppInstanceRetentionSettingsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *GetAppInstanceRetentionSettingsOutput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *GetAppInstanceRetentionSettingsOutput {
	s.AppInstanceRetentionSettings = v
	return s
}

// SetInitiateDeletionTimestamp sets the InitiateDeletionTimestamp field's value.
func (s *GetAppInstanceRetentionSettingsOutput) SetInitiateDeletionTimestamp(v time.Time) *GetAppInstanceRetentionSettingsOutput {
	s.InitiateDeletionTimestamp = &v
	return s
}

// The details of a user.
type Identity struct {
	_ struct{} `type:"structure"`

	// The ARN in an Identity.
	Arn *string `min:"5" type:"string"`

	// The name in an Identity.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Identity's
	// String and GoString methods.
	Name *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Identity) SetArn(v string) *Identity {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Identity) SetName(v string) *Identity {
	s.Name = &v
	return s
}

type ListAppInstanceAdminsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The maximum number of administrators that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token returned from previous API requests until the number of administrators
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceAdminsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceAdminsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceAdminsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceAdminsInput) SetAppInstanceArn(v string) *ListAppInstanceAdminsInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceAdminsInput) SetMaxResults(v int64) *ListAppInstanceAdminsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceAdminsInput) SetNextToken(v string) *ListAppInstanceAdminsInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceAdminsOutput struct {
	_ struct{} `type:"structure"`

	// The information for each administrator.
	AppInstanceAdmins []*AppInstanceAdminSummary `type:"list"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The token returned from previous API requests until the number of administrators
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceAdminsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceAdminsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceAdmins sets the AppInstanceAdmins field's value.
func (s *ListAppInstanceAdminsOutput) SetAppInstanceAdmins(v []*AppInstanceAdminSummary) *ListAppInstanceAdminsOutput {
	s.AppInstanceAdmins = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceAdminsOutput) SetAppInstanceArn(v string) *ListAppInstanceAdminsOutput {
	s.AppInstanceArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceAdminsOutput) SetNextToken(v string) *ListAppInstanceAdminsOutput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUsersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"querystring" locationName:"app-instance-arn" min:"5" type:"string" required:"true"`

	// The maximum number of requests that you want returned.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API calls until all requested users are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUsersInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstanceUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstanceUsersInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceUsersInput) SetAppInstanceArn(v string) *ListAppInstanceUsersInput {
	s.AppInstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstanceUsersInput) SetMaxResults(v int64) *ListAppInstanceUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUsersInput) SetNextToken(v string) *ListAppInstanceUsersInput {
	s.NextToken = &v
	return s
}

type ListAppInstanceUsersOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The information for each requested AppInstanceUser.
	AppInstanceUsers []*AppInstanceUserSummary `type:"list"`

	// The token passed by previous API calls until all requested users are returned.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstanceUsersOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstanceUsersOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *ListAppInstanceUsersOutput) SetAppInstanceArn(v string) *ListAppInstanceUsersOutput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceUsers sets the AppInstanceUsers field's value.
func (s *ListAppInstanceUsersOutput) SetAppInstanceUsers(v []*AppInstanceUserSummary) *ListAppInstanceUsersOutput {
	s.AppInstanceUsers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstanceUsersOutput) SetNextToken(v string) *ListAppInstanceUsersOutput {
	s.NextToken = &v
	return s
}

type ListAppInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of AppInstances that you want to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token passed by previous API requests until you reach the maximum number
	// of AppInstances.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstancesInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppInstancesInput) SetMaxResults(v int64) *ListAppInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstancesInput) SetNextToken(v string) *ListAppInstancesInput {
	s.NextToken = &v
	return s
}

type ListAppInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The information for each AppInstance.
	AppInstances []*AppInstanceSummary `type:"list"`

	// The token passed by previous API requests until the maximum number of AppInstances
	// is reached.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListAppInstancesOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppInstancesOutput) GoString() string {
	return s.String()
}

// SetAppInstances sets the AppInstances field's value.
func (s *ListAppInstancesOutput) SetAppInstances(v []*AppInstanceSummary) *ListAppInstancesOutput {
	s.AppInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppInstancesOutput) SetNextToken(v string) *ListAppInstancesOutput {
	s.NextToken = &v
	return s
}

type PutAppInstanceRetentionSettingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The time in days to retain data. Data type: number.
	//
	// AppInstanceRetentionSettings is a required field
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAppInstanceRetentionSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAppInstanceRetentionSettingsInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.AppInstanceRetentionSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceRetentionSettings"))
	}
	if s.AppInstanceRetentionSettings != nil {
		if err := s.AppInstanceRetentionSettings.Validate(); err != nil {
			invalidParams.AddNested("AppInstanceRetentionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *PutAppInstanceRetentionSettingsInput) SetAppInstanceArn(v string) *PutAppInstanceRetentionSettingsInput {
	s.AppInstanceArn = &v
	return s
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *PutAppInstanceRetentionSettingsInput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *PutAppInstanceRetentionSettingsInput {
	s.AppInstanceRetentionSettings = v
	return s
}

type PutAppInstanceRetentionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The time in days to retain data. Data type: number.
	AppInstanceRetentionSettings *AppInstanceRetentionSettings `type:"structure"`

	// The time at which the API deletes data.
	InitiateDeletionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAppInstanceRetentionSettingsOutput) GoString() string {
	return s.String()
}

// SetAppInstanceRetentionSettings sets the AppInstanceRetentionSettings field's value.
func (s *PutAppInstanceRetentionSettingsOutput) SetAppInstanceRetentionSettings(v *AppInstanceRetentionSettings) *PutAppInstanceRetentionSettingsOutput {
	s.AppInstanceRetentionSettings = v
	return s
}

// SetInitiateDeletionTimestamp sets the InitiateDeletionTimestamp field's value.
func (s *PutAppInstanceRetentionSettingsOutput) SetInitiateDeletionTimestamp(v time.Time) *PutAppInstanceRetentionSettingsOutput {
	s.InitiateDeletionTimestamp = &v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a tag applied to a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value of the tag.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateAppInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	//
	// AppInstanceArn is a required field
	AppInstanceArn *string `location:"uri" locationName:"appInstanceArn" min:"5" type:"string" required:"true"`

	// The metadata that you want to change.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `type:"string" required:"true" sensitive:"true"`

	// The name that you want to change.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceInput"}
	if s.AppInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceArn"))
	}
	if s.AppInstanceArn != nil && len(*s.AppInstanceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceArn", 5))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *UpdateAppInstanceInput) SetAppInstanceArn(v string) *UpdateAppInstanceInput {
	s.AppInstanceArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateAppInstanceInput) SetMetadata(v string) *UpdateAppInstanceInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceInput) SetName(v string) *UpdateAppInstanceInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstance.
	AppInstanceArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceOutput) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *UpdateAppInstanceOutput) SetAppInstanceArn(v string) *UpdateAppInstanceOutput {
	s.AppInstanceArn = &v
	return s
}

type UpdateAppInstanceUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	//
	// AppInstanceUserArn is a required field
	AppInstanceUserArn *string `location:"uri" locationName:"appInstanceUserArn" min:"5" type:"string" required:"true"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata *string `type:"string" required:"true" sensitive:"true"`

	// The name of the AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAppInstanceUserInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInstanceUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInstanceUserInput"}
	if s.AppInstanceUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceUserArn"))
	}
	if s.AppInstanceUserArn != nil && len(*s.AppInstanceUserArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AppInstanceUserArn", 5))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserInput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserInput {
	s.AppInstanceUserArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateAppInstanceUserInput) SetMetadata(v string) *UpdateAppInstanceUserInput {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInstanceUserInput) SetName(v string) *UpdateAppInstanceUserInput {
	s.Name = &v
	return s
}

type UpdateAppInstanceUserOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAppInstanceUserOutput) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *UpdateAppInstanceUserOutput) SetAppInstanceUserArn(v string) *UpdateAppInstanceUserOutput {
	s.AppInstanceUserArn = &v
	return s
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeConflict,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodePreconditionFailed,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeAccessDenied,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottled,
		ErrorCodeThrottling,
		ErrorCodeUnauthorized,
		ErrorCodeUnprocessable,
		ErrorCodeVoiceConnectorGroupAssociationsExist,
		ErrorCodePhoneNumberAssociationsExist,
	}
}
