/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ServerApi;
import com.mongodb.ServerApiVersion;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class MongoServerApiFactoryBean
implements FactoryBean<ServerApi> {
    private String version;
    @Nullable
    private Boolean deprecationErrors;
    @Nullable
    private Boolean strict;

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDeprecationErrors(@Nullable Boolean deprecationErrors) {
        this.deprecationErrors = deprecationErrors;
    }

    public void setStrict(@Nullable Boolean strict) {
        this.strict = strict;
    }

    @Nullable
    public ServerApi getObject() throws Exception {
        ServerApi.Builder builder = ServerApi.builder().version(this.version());
        if (this.deprecationErrors != null) {
            builder = builder.deprecationErrors(this.deprecationErrors.booleanValue());
        }
        if (this.strict != null) {
            builder = builder.strict(this.strict.booleanValue());
        }
        return builder.build();
    }

    @Nullable
    public Class<?> getObjectType() {
        return ServerApi.class;
    }

    private ServerApiVersion version() {
        try {
            return (ServerApiVersion)ObjectUtils.caseInsensitiveValueOf((Enum[])ServerApiVersion.values(), (String)this.version);
        }
        catch (IllegalArgumentException e) {
            return ServerApiVersion.findByValue((String)this.version);
        }
    }
}

