/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class GnpRandomBipartiteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private final Random rng;
    private final int n1;
    private final int n2;
    private final double p;

    public GnpRandomBipartiteGraphGenerator(int n1, int n2, double p) {
        this(n1, n2, p, new Random());
    }

    public GnpRandomBipartiteGraphGenerator(int n1, int n2, double p, long seed) {
        this(n1, n2, p, new Random(seed));
    }

    public GnpRandomBipartiteGraphGenerator(int n1, int n2, double p, Random rng) {
        if (n1 < 0) {
            throw new IllegalArgumentException("number of vertices must be non-negative");
        }
        this.n1 = n1;
        if (n2 < 0) {
            throw new IllegalArgumentException("number of vertices must be non-negative");
        }
        this.n2 = n2;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("not valid probability of edge existence");
        }
        this.p = p;
        this.rng = rng;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.n1 + this.n2 == 0) {
            return;
        }
        int previousVertexSetSize = target.vertexSet().size();
        HashMap<Integer, V> partitionA = new HashMap<Integer, V>(this.n1);
        for (int i = 0; i < this.n1; ++i) {
            V v = vertexFactory.createVertex();
            target.addVertex(v);
            partitionA.put(i, v);
        }
        HashMap<Integer, V> partitionB = new HashMap<Integer, V>(this.n2);
        for (int i = 0; i < this.n2; ++i) {
            V v = vertexFactory.createVertex();
            target.addVertex(v);
            partitionB.put(i, v);
        }
        if (target.vertexSet().size() != previousVertexSetSize + this.n1 + this.n2) {
            throw new IllegalArgumentException("Vertex factory did not produce " + (this.n1 + this.n2) + " distinct vertices.");
        }
        boolean isDirected = target instanceof DirectedGraph;
        for (int i = 0; i < this.n1; ++i) {
            Object s = partitionA.get(i);
            for (int j = 0; j < this.n2; ++j) {
                Object t = partitionB.get(j);
                if (this.rng.nextDouble() < this.p) {
                    target.addEdge(s, t);
                }
                if (!isDirected || !(this.rng.nextDouble() < this.p)) continue;
                target.addEdge(t, s);
            }
        }
    }
}

