/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan.hotspot2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.F.return;
import com.ubnt.data.X;
import com.ubnt.model.api.wlan.hotspot2.ImmutableCellularNetworkDto;
import io.swagger.v3.oas.annotations.media.Schema;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Cellular Network", description="Wlan Hotspot2 Cellular Network")
@Value.Immutable
@return
public interface CellularNetworkDto {
    @JsonProperty(value="name")
    @Schema(name="Cellular Network Name")
    public String name();

    @JsonProperty(value="country_code")
    @Schema(name="Cellular Network Country Code")
    public String countryCode();

    @JsonProperty(value="mcc")
    @Schema(name="Mobile Country Code")
    public String mobileCountryCode();

    @JsonProperty(value="mnc")
    @Schema(name="Mobile Network Code")
    public String mobileNetworkCode();

    default public X toLegacy() {
        return new X().append("name", this.name()).append("country_code", this.countryCode()).append("mcc", this.mobileCountryCode()).append("mnc", this.mobileNetworkCode());
    }

    public static ImmutableCellularNetworkDto.Builder builder() {
        return ImmutableCellularNetworkDto.builder();
    }

    public static CellularNetworkDto of(X x2) {
        return CellularNetworkDto.builder().name(x2.getString("name")).countryCode(x2.getString("country_code")).mobileCountryCode(x2.getString("mcc")).mobileNetworkCode(x2.getString("mnc")).build();
    }
}

