/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.F.B;
import com.ubnt.model.api.trafficstats.ImmutableCountryTrafficDto;
import java.util.Comparator;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@B
@Value.Immutable
public abstract class CountryTrafficDto
implements Comparable<CountryTrafficDto> {
    @JsonProperty(value="country")
    public abstract String country();

    @JsonProperty(value="bytes_received")
    public abstract long bytesReceived();

    @JsonProperty(value="bytes_transmitted")
    public abstract long bytesTransmitted();

    @JsonProperty(value="total_bytes")
    @Value.Lazy
    public long totalBytes() {
        return this.bytesReceived() + this.bytesTransmitted();
    }

    @Override
    public int compareTo(CountryTrafficDto countryTrafficDto) {
        return Comparator.comparingLong(CountryTrafficDto::totalBytes).thenComparingLong(CountryTrafficDto::bytesReceived).thenComparingLong(CountryTrafficDto::bytesTransmitted).reversed().compare(this, countryTrafficDto);
    }

    public static CountryTrafficDto add(CountryTrafficDto countryTrafficDto, CountryTrafficDto countryTrafficDto2) {
        return ImmutableCountryTrafficDto.builder().country(countryTrafficDto2.country()).bytesReceived(countryTrafficDto.bytesReceived() + countryTrafficDto2.bytesReceived()).bytesTransmitted(countryTrafficDto.bytesTransmitted() + countryTrafficDto2.bytesTransmitted()).build();
    }

    public static CountryTrafficDto empty() {
        return ImmutableCountryTrafficDto.builder().country("").bytesReceived(0L).bytesTransmitted(0L).build();
    }
}

