/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.ospf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.F.return;
import com.ubnt.model.api.ospf.ImmutableOspfAreaDto;
import com.ubnt.model.api.ospf.OspfAreaType;
import com.ubnt.service.ospf.OspfAreaDocumentPart;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.immutables.value.Value;

@Schema(name="OSPF Area")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableOspfAreaDto.class)
@Value.Immutable
@return
public interface OspfAreaDto {
    @JsonProperty(value="name")
    @NotEmpty
    public String name();

    @JsonProperty(value="area_id")
    @NotEmpty
    public String areaId();

    @JsonProperty(value="area_type")
    @NotNull
    public OspfAreaType areaType();

    @JsonProperty(value="network_ids")
    @Size(min=1)
    public @Size(min=1) List<String> networkIds();

    public static ImmutableOspfAreaDto.Builder builder() {
        return ImmutableOspfAreaDto.builder();
    }

    public static OspfAreaDto ofDocument(OspfAreaDocumentPart ospfAreaDocumentPart) {
        return OspfAreaDto.builder().name(ospfAreaDocumentPart.getName()).areaId(ospfAreaDocumentPart.getAreaId()).areaType(ospfAreaDocumentPart.getAreaType()).networkIds(ospfAreaDocumentPart.getNetworkIds()).build();
    }

    default public OspfAreaDocumentPart toDocument() {
        return OspfAreaDocumentPart.builder().o00000(this.name()).\u00f400000(this.areaId()).\u00d500000(this.areaType()).\u00d600000(this.networkIds()).\u00d400000();
    }
}

