/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.views.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.charts.ChartFactory;
import org.graalvm.visualvm.charts.SimpleXYChartDescriptor;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.model.HostOverview;
import org.graalvm.visualvm.host.model.HostOverviewFactory;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class HostOverviewView
extends DataSourceView
implements DataRemovedListener<Host> {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/host/views/resources/overview.png";
    private Timer timer;
    private HostOverview hostOverview;

    HostOverviewView(Host host) {
        super((DataSource)host, NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Overview"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 0, false);
    }

    protected void willBeAdded() {
        this.hostOverview = HostOverviewFactory.getSystemOverviewFor((Host)((Host)this.getDataSource()));
    }

    protected void removed() {
        this.timer.cancel();
    }

    public void dataRemoved(Host dataSource) {
        this.timer.cancel();
    }

    protected DataViewComponent createComponent() {
        GlobalPreferences preferences = GlobalPreferences.sharedInstance();
        int chartCache = preferences.getMonitoredHostCache() * 60 / preferences.getMonitoredHostPoll();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport((Host)this.getDataSource()).getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        boolean cpuSupported = this.hostOverview.getSystemLoadAverage() >= 0.0;
        final CpuLoadViewSupport cpuLoadViewSupport = new CpuLoadViewSupport(this.hostOverview, cpuSupported, chartCache);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_CPU"), true), 1);
        dvc.addDetailsView(cpuLoadViewSupport.getDetailsView(), 1);
        if (!cpuSupported) {
            dvc.hideDetailsArea(1);
        }
        final PhysicalMemoryViewSupport physicalMemoryViewSupport = new PhysicalMemoryViewSupport(chartCache);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Memory"), true), 2);
        dvc.addDetailsView(physicalMemoryViewSupport.getDetailsView(), 2);
        final SwapMemoryViewSupport swapMemoryViewSupport = new SwapMemoryViewSupport(chartCache);
        dvc.addDetailsView(swapMemoryViewSupport.getDetailsView(), 2);
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                cpuLoadViewSupport.refresh(HostOverviewView.this.hostOverview, time);
                physicalMemoryViewSupport.refresh(HostOverviewView.this.hostOverview, time);
                swapMemoryViewSupport.refresh(HostOverviewView.this.hostOverview, time);
            }
        }, 800L, 2000L);
        this.getDataSource().notifyWhenRemoved((DataRemovedListener)this);
        return dvc;
    }

    private static class SwapMemoryViewSupport
    extends JPanel {
        private static final String USED_SWAP = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_swap");
        private static final String USED_SWAP_LEG = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_swap_leg");
        private static final String TOTAL_SWAP = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_swap");
        private SimpleXYChartSupport chartSupport;

        SwapMemoryViewSupport(int chartCache) {
            this.initModels(chartCache);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Swap_memory"), null, 20, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            long memorySwapMax = hostOverview.getTotalSwapSpaceSize();
            long memorySwapUsed = memorySwapMax - hostOverview.getFreeSwapSpaceSize();
            this.chartSupport.addValues(time, new long[]{memorySwapUsed});
            this.chartSupport.updateDetails(new String[]{this.chartSupport.formatBytes(memorySwapUsed), this.chartSupport.formatBytes(memorySwapMax)});
        }

        private void initModels(int chartCache) {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0x8000000L, (boolean)false, (int)chartCache);
            chartDescriptor.addLineFillItems(new String[]{USED_SWAP_LEG});
            chartDescriptor.setDetailsItems(new String[]{USED_SWAP, TOTAL_SWAP});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
        }
    }

    private static class PhysicalMemoryViewSupport
    extends JPanel {
        private static String USED_MEMORY = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_memory");
        private static String USED_MEMORY_LEG = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Used_memory_leg");
        private static String TOTAL_MEMORY = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_memory");
        private SimpleXYChartSupport chartSupport;

        PhysicalMemoryViewSupport(int chartCache) {
            this.initModels(chartCache);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Physical_memory"), null, 10, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            long memoryMax = hostOverview.getTotalPhysicalMemorySize();
            long memoryUsed = memoryMax - hostOverview.getFreePhysicalMemorySize();
            this.chartSupport.addValues(time, new long[]{memoryUsed});
            this.chartSupport.updateDetails(new String[]{this.chartSupport.formatBytes(memoryUsed), this.chartSupport.formatBytes(memoryMax)});
        }

        private void initModels(int chartCache) {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0x8000000L, (boolean)false, (int)chartCache);
            chartDescriptor.addLineFillItems(new String[]{USED_MEMORY_LEG});
            chartDescriptor.setDetailsItems(new String[]{USED_MEMORY, TOTAL_MEMORY});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
        }
    }

    private static class CpuLoadViewSupport
    extends JPanel {
        private boolean cpuMonitoringSupported;
        private static final String LOAD_AVERAGE = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Load_average");
        private SimpleXYChartSupport chartSupport;

        CpuLoadViewSupport(HostOverview hostOverview, boolean cpuSupported, int chartCache) {
            this.cpuMonitoringSupported = cpuSupported;
            this.initModels(chartCache);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_CPU_load"), null, 10, (JComponent)this, null);
        }

        public void refresh(HostOverview hostOverview, long time) {
            if (this.cpuMonitoringSupported) {
                long load = (long)(hostOverview.getSystemLoadAverage() * 1000.0);
                this.chartSupport.addValues(time, new long[]{load});
                this.chartSupport.updateDetails(new String[]{this.chartSupport.formatDecimal(load)});
            }
        }

        private void initModels(int chartCache) {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)1L, (double)0.001, (boolean)false, (int)chartCache);
            chartDescriptor.addLineItems(new String[]{LOAD_AVERAGE});
            chartDescriptor.setDetailsItems(new String[]{LOAD_AVERAGE});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.cpuMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.HOST), "Center");
            }
        }
    }

    private static class MasterViewSupport
    extends JPanel {
        MasterViewSupport(Host host) {
            this.initComponents(host);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(Host host) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralInfo(host) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)area, "Center");
        }

        String getGeneralInfo(Host host) {
            HostOverview so = HostOverviewFactory.getSystemOverviewFor((Host)host);
            StringBuilder data = new StringBuilder();
            String hostIp = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Host_IP");
            data.append("<b>" + hostIp + ":</b> " + so.getHostAddress() + "<br>");
            String hostname = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Hostname");
            data.append("<b>" + hostname + ":</b> " + so.getHostName() + "<br><br>");
            String name = so.getName();
            String ver = so.getVersion();
            String patch = so.getPatchLevel();
            patch = "unknown".equals(patch) ? "" : patch;
            String os = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_OS");
            String arch = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Architecture");
            String proc = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Processors");
            String memory = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Total_memory_size");
            String swap = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_Swap_size");
            String mb = NbBundle.getMessage(HostOverviewView.class, (String)"LBL_MB");
            data.append("<b>" + os + ":</b> " + name + " (" + ver + ") " + patch + "<br>");
            data.append("<b>" + arch + ":</b> " + so.getArch() + "<br>");
            data.append("<b>" + proc + ":</b> " + so.getAvailableProcessors() + "<br><br>");
            data.append("<b>" + memory + ":</b> " + this.formatBytes(so.getTotalPhysicalMemorySize()) + " " + mb + "<br>");
            data.append("<b>" + swap + ":</b> " + this.formatBytes(so.getTotalSwapSpaceSize()) + " " + mb + "<br>");
            return data.toString();
        }

        private String formatBytes(long l) {
            return NumberFormat.getInstance().format((double)(10L * l / 1024L / 1024L) / 10.0);
        }
    }
}

