// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Vault Secret Management API
//
// Use the Secret Management API to manage secrets and secret versions. For more information, see Managing Secrets (https://docs.oracle.com/iaas/Content/KeyManagement/Tasks/managingsecrets.htm).
//

package vault

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// BytesGenerationContext Generates random bytes. By default, secrets of type Bytes has no structure. The generated bytes are stored as a Base64 encoded string.
// The SecretTemplate must have the %GENERATED_BYTES% keyword which is replaced with the generated bytes, if provided
type BytesGenerationContext struct {

	// SecretTemplate captures structure in which customer wants to store secrets. This is optional and a default structure is available for each secret type.
	// The template can have any structure with static values that are not generated. Within the template, you can insert predefined placeholders to store secrets.
	// These placeholders are later replaced with the generated content and saved as a Base64 encoded content.
	SecretTemplate *string `mandatory:"false" json:"secretTemplate"`

	// Name of random bytes generation template for generating random byte type secret.
	GenerationTemplate BytesGenerationContextGenerationTemplateEnum `mandatory:"true" json:"generationTemplate"`
}

// GetSecretTemplate returns SecretTemplate
func (m BytesGenerationContext) GetSecretTemplate() *string {
	return m.SecretTemplate
}

func (m BytesGenerationContext) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m BytesGenerationContext) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingBytesGenerationContextGenerationTemplateEnum(string(m.GenerationTemplate)); !ok && m.GenerationTemplate != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for GenerationTemplate: %s. Supported values are: %s.", m.GenerationTemplate, strings.Join(GetBytesGenerationContextGenerationTemplateEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m BytesGenerationContext) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeBytesGenerationContext BytesGenerationContext
	s := struct {
		DiscriminatorParam string `json:"generationType"`
		MarshalTypeBytesGenerationContext
	}{
		"BYTES",
		(MarshalTypeBytesGenerationContext)(m),
	}

	return json.Marshal(&s)
}

// BytesGenerationContextGenerationTemplateEnum Enum with underlying type: string
type BytesGenerationContextGenerationTemplateEnum string

// Set of constants representing the allowable values for BytesGenerationContextGenerationTemplateEnum
const (
	BytesGenerationContextGenerationTemplate512  BytesGenerationContextGenerationTemplateEnum = "BYTES_512"
	BytesGenerationContextGenerationTemplate1024 BytesGenerationContextGenerationTemplateEnum = "BYTES_1024"
)

var mappingBytesGenerationContextGenerationTemplateEnum = map[string]BytesGenerationContextGenerationTemplateEnum{
	"BYTES_512":  BytesGenerationContextGenerationTemplate512,
	"BYTES_1024": BytesGenerationContextGenerationTemplate1024,
}

var mappingBytesGenerationContextGenerationTemplateEnumLowerCase = map[string]BytesGenerationContextGenerationTemplateEnum{
	"bytes_512":  BytesGenerationContextGenerationTemplate512,
	"bytes_1024": BytesGenerationContextGenerationTemplate1024,
}

// GetBytesGenerationContextGenerationTemplateEnumValues Enumerates the set of values for BytesGenerationContextGenerationTemplateEnum
func GetBytesGenerationContextGenerationTemplateEnumValues() []BytesGenerationContextGenerationTemplateEnum {
	values := make([]BytesGenerationContextGenerationTemplateEnum, 0)
	for _, v := range mappingBytesGenerationContextGenerationTemplateEnum {
		values = append(values, v)
	}
	return values
}

// GetBytesGenerationContextGenerationTemplateEnumStringValues Enumerates the set of values in String for BytesGenerationContextGenerationTemplateEnum
func GetBytesGenerationContextGenerationTemplateEnumStringValues() []string {
	return []string{
		"BYTES_512",
		"BYTES_1024",
	}
}

// GetMappingBytesGenerationContextGenerationTemplateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingBytesGenerationContextGenerationTemplateEnum(val string) (BytesGenerationContextGenerationTemplateEnum, bool) {
	enum, ok := mappingBytesGenerationContextGenerationTemplateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
