// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Management API
//
// Use the Database Management API to monitor and manage resources such as
// Oracle Databases, MySQL Databases, and External Database Systems.
// For more information, see Database Management (https://docs.oracle.com/iaas/database-management/home.htm).
//

package databasemanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DatabasePlan The resource allocation directives must all use the share attribute, or they must all use the level and allocation attributes.
// If you use the share attribute to allocate I/O resources, then the database plan can have a maximum of 1024 directives.
// If you use the level and allocation attributes to allocate I/O resources, then the database plan can have
// a maximum of 32 directives.
// Only one directive is allowed for each database name and each profile name.
type DatabasePlan struct {

	// A list of DatabasePlanDirectives.
	Items []DatabasePlanDirective `mandatory:"true" json:"items"`
}

func (m DatabasePlan) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DatabasePlan) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
