// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2alpha/serving_config_service.proto

package retailpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ServingConfigService_CreateServingConfig_FullMethodName = "/google.cloud.retail.v2alpha.ServingConfigService/CreateServingConfig"
	ServingConfigService_DeleteServingConfig_FullMethodName = "/google.cloud.retail.v2alpha.ServingConfigService/DeleteServingConfig"
	ServingConfigService_UpdateServingConfig_FullMethodName = "/google.cloud.retail.v2alpha.ServingConfigService/UpdateServingConfig"
	ServingConfigService_GetServingConfig_FullMethodName    = "/google.cloud.retail.v2alpha.ServingConfigService/GetServingConfig"
	ServingConfigService_ListServingConfigs_FullMethodName  = "/google.cloud.retail.v2alpha.ServingConfigService/ListServingConfigs"
	ServingConfigService_AddControl_FullMethodName          = "/google.cloud.retail.v2alpha.ServingConfigService/AddControl"
	ServingConfigService_RemoveControl_FullMethodName       = "/google.cloud.retail.v2alpha.ServingConfigService/RemoveControl"
)

// ServingConfigServiceClient is the client API for ServingConfigService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServingConfigServiceClient interface {
	// Creates a ServingConfig.
	//
	// A maximum of 100
	// [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]s are allowed in
	// a [Catalog][google.cloud.retail.v2alpha.Catalog], otherwise a
	// FAILED_PRECONDITION error is returned.
	CreateServingConfig(ctx context.Context, in *CreateServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error)
	// Deletes a ServingConfig.
	//
	// Returns a NotFound error if the ServingConfig does not exist.
	DeleteServingConfig(ctx context.Context, in *DeleteServingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a ServingConfig.
	UpdateServingConfig(ctx context.Context, in *UpdateServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error)
	// Gets a ServingConfig.
	//
	// Returns a NotFound error if the ServingConfig does not exist.
	GetServingConfig(ctx context.Context, in *GetServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error)
	// Lists all ServingConfigs linked to this catalog.
	ListServingConfigs(ctx context.Context, in *ListServingConfigsRequest, opts ...grpc.CallOption) (*ListServingConfigsResponse, error)
	// Enables a Control on the specified ServingConfig.
	// The control is added in the last position of the list of controls
	// it belongs to (e.g. if it's a facet spec control it will be applied
	// in the last position of servingConfig.facetSpecIds)
	// Returns a ALREADY_EXISTS error if the control has already been applied.
	// Returns a FAILED_PRECONDITION error if the addition could exceed maximum
	// number of control allowed for that type of control.
	AddControl(ctx context.Context, in *AddControlRequest, opts ...grpc.CallOption) (*ServingConfig, error)
	// Disables a Control on the specified ServingConfig.
	// The control is removed from the ServingConfig.
	// Returns a NOT_FOUND error if the Control is not enabled for the
	// ServingConfig.
	RemoveControl(ctx context.Context, in *RemoveControlRequest, opts ...grpc.CallOption) (*ServingConfig, error)
}

type servingConfigServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServingConfigServiceClient(cc grpc.ClientConnInterface) ServingConfigServiceClient {
	return &servingConfigServiceClient{cc}
}

func (c *servingConfigServiceClient) CreateServingConfig(ctx context.Context, in *CreateServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error) {
	out := new(ServingConfig)
	err := c.cc.Invoke(ctx, ServingConfigService_CreateServingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) DeleteServingConfig(ctx context.Context, in *DeleteServingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ServingConfigService_DeleteServingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) UpdateServingConfig(ctx context.Context, in *UpdateServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error) {
	out := new(ServingConfig)
	err := c.cc.Invoke(ctx, ServingConfigService_UpdateServingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) GetServingConfig(ctx context.Context, in *GetServingConfigRequest, opts ...grpc.CallOption) (*ServingConfig, error) {
	out := new(ServingConfig)
	err := c.cc.Invoke(ctx, ServingConfigService_GetServingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) ListServingConfigs(ctx context.Context, in *ListServingConfigsRequest, opts ...grpc.CallOption) (*ListServingConfigsResponse, error) {
	out := new(ListServingConfigsResponse)
	err := c.cc.Invoke(ctx, ServingConfigService_ListServingConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) AddControl(ctx context.Context, in *AddControlRequest, opts ...grpc.CallOption) (*ServingConfig, error) {
	out := new(ServingConfig)
	err := c.cc.Invoke(ctx, ServingConfigService_AddControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servingConfigServiceClient) RemoveControl(ctx context.Context, in *RemoveControlRequest, opts ...grpc.CallOption) (*ServingConfig, error) {
	out := new(ServingConfig)
	err := c.cc.Invoke(ctx, ServingConfigService_RemoveControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServingConfigServiceServer is the server API for ServingConfigService service.
// All implementations should embed UnimplementedServingConfigServiceServer
// for forward compatibility
type ServingConfigServiceServer interface {
	// Creates a ServingConfig.
	//
	// A maximum of 100
	// [ServingConfig][google.cloud.retail.v2alpha.ServingConfig]s are allowed in
	// a [Catalog][google.cloud.retail.v2alpha.Catalog], otherwise a
	// FAILED_PRECONDITION error is returned.
	CreateServingConfig(context.Context, *CreateServingConfigRequest) (*ServingConfig, error)
	// Deletes a ServingConfig.
	//
	// Returns a NotFound error if the ServingConfig does not exist.
	DeleteServingConfig(context.Context, *DeleteServingConfigRequest) (*emptypb.Empty, error)
	// Updates a ServingConfig.
	UpdateServingConfig(context.Context, *UpdateServingConfigRequest) (*ServingConfig, error)
	// Gets a ServingConfig.
	//
	// Returns a NotFound error if the ServingConfig does not exist.
	GetServingConfig(context.Context, *GetServingConfigRequest) (*ServingConfig, error)
	// Lists all ServingConfigs linked to this catalog.
	ListServingConfigs(context.Context, *ListServingConfigsRequest) (*ListServingConfigsResponse, error)
	// Enables a Control on the specified ServingConfig.
	// The control is added in the last position of the list of controls
	// it belongs to (e.g. if it's a facet spec control it will be applied
	// in the last position of servingConfig.facetSpecIds)
	// Returns a ALREADY_EXISTS error if the control has already been applied.
	// Returns a FAILED_PRECONDITION error if the addition could exceed maximum
	// number of control allowed for that type of control.
	AddControl(context.Context, *AddControlRequest) (*ServingConfig, error)
	// Disables a Control on the specified ServingConfig.
	// The control is removed from the ServingConfig.
	// Returns a NOT_FOUND error if the Control is not enabled for the
	// ServingConfig.
	RemoveControl(context.Context, *RemoveControlRequest) (*ServingConfig, error)
}

// UnimplementedServingConfigServiceServer should be embedded to have forward compatible implementations.
type UnimplementedServingConfigServiceServer struct {
}

func (UnimplementedServingConfigServiceServer) CreateServingConfig(context.Context, *CreateServingConfigRequest) (*ServingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServingConfig not implemented")
}
func (UnimplementedServingConfigServiceServer) DeleteServingConfig(context.Context, *DeleteServingConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServingConfig not implemented")
}
func (UnimplementedServingConfigServiceServer) UpdateServingConfig(context.Context, *UpdateServingConfigRequest) (*ServingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServingConfig not implemented")
}
func (UnimplementedServingConfigServiceServer) GetServingConfig(context.Context, *GetServingConfigRequest) (*ServingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServingConfig not implemented")
}
func (UnimplementedServingConfigServiceServer) ListServingConfigs(context.Context, *ListServingConfigsRequest) (*ListServingConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServingConfigs not implemented")
}
func (UnimplementedServingConfigServiceServer) AddControl(context.Context, *AddControlRequest) (*ServingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddControl not implemented")
}
func (UnimplementedServingConfigServiceServer) RemoveControl(context.Context, *RemoveControlRequest) (*ServingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveControl not implemented")
}

// UnsafeServingConfigServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServingConfigServiceServer will
// result in compilation errors.
type UnsafeServingConfigServiceServer interface {
	mustEmbedUnimplementedServingConfigServiceServer()
}

func RegisterServingConfigServiceServer(s grpc.ServiceRegistrar, srv ServingConfigServiceServer) {
	s.RegisterService(&ServingConfigService_ServiceDesc, srv)
}

func _ServingConfigService_CreateServingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).CreateServingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_CreateServingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).CreateServingConfig(ctx, req.(*CreateServingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_DeleteServingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).DeleteServingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_DeleteServingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).DeleteServingConfig(ctx, req.(*DeleteServingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_UpdateServingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).UpdateServingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_UpdateServingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).UpdateServingConfig(ctx, req.(*UpdateServingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_GetServingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).GetServingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_GetServingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).GetServingConfig(ctx, req.(*GetServingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_ListServingConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServingConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).ListServingConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_ListServingConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).ListServingConfigs(ctx, req.(*ListServingConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_AddControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).AddControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_AddControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).AddControl(ctx, req.(*AddControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServingConfigService_RemoveControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServingConfigServiceServer).RemoveControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServingConfigService_RemoveControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServingConfigServiceServer).RemoveControl(ctx, req.(*RemoveControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ServingConfigService_ServiceDesc is the grpc.ServiceDesc for ServingConfigService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServingConfigService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2alpha.ServingConfigService",
	HandlerType: (*ServingConfigServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateServingConfig",
			Handler:    _ServingConfigService_CreateServingConfig_Handler,
		},
		{
			MethodName: "DeleteServingConfig",
			Handler:    _ServingConfigService_DeleteServingConfig_Handler,
		},
		{
			MethodName: "UpdateServingConfig",
			Handler:    _ServingConfigService_UpdateServingConfig_Handler,
		},
		{
			MethodName: "GetServingConfig",
			Handler:    _ServingConfigService_GetServingConfig_Handler,
		},
		{
			MethodName: "ListServingConfigs",
			Handler:    _ServingConfigService_ListServingConfigs_Handler,
		},
		{
			MethodName: "AddControl",
			Handler:    _ServingConfigService_AddControl_Handler,
		},
		{
			MethodName: "RemoveControl",
			Handler:    _ServingConfigService_RemoveControl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2alpha/serving_config_service.proto",
}
