// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2/control_service.proto

package retailpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ControlService_CreateControl_FullMethodName = "/google.cloud.retail.v2.ControlService/CreateControl"
	ControlService_DeleteControl_FullMethodName = "/google.cloud.retail.v2.ControlService/DeleteControl"
	ControlService_UpdateControl_FullMethodName = "/google.cloud.retail.v2.ControlService/UpdateControl"
	ControlService_GetControl_FullMethodName    = "/google.cloud.retail.v2.ControlService/GetControl"
	ControlService_ListControls_FullMethodName  = "/google.cloud.retail.v2.ControlService/ListControls"
)

// ControlServiceClient is the client API for ControlService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ControlServiceClient interface {
	// Creates a Control.
	//
	// If the [Control][google.cloud.retail.v2.Control] to create already exists,
	// an ALREADY_EXISTS error is returned.
	CreateControl(ctx context.Context, in *CreateControlRequest, opts ...grpc.CallOption) (*Control, error)
	// Deletes a Control.
	//
	// If the [Control][google.cloud.retail.v2.Control] to delete does not exist,
	// a NOT_FOUND error is returned.
	DeleteControl(ctx context.Context, in *DeleteControlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a Control.
	//
	// [Control][google.cloud.retail.v2.Control] cannot be set to a different
	// oneof field, if so an INVALID_ARGUMENT is returned. If the
	// [Control][google.cloud.retail.v2.Control] to update does not exist, a
	// NOT_FOUND error is returned.
	UpdateControl(ctx context.Context, in *UpdateControlRequest, opts ...grpc.CallOption) (*Control, error)
	// Gets a Control.
	GetControl(ctx context.Context, in *GetControlRequest, opts ...grpc.CallOption) (*Control, error)
	// Lists all Controls by their parent
	// [Catalog][google.cloud.retail.v2.Catalog].
	ListControls(ctx context.Context, in *ListControlsRequest, opts ...grpc.CallOption) (*ListControlsResponse, error)
}

type controlServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewControlServiceClient(cc grpc.ClientConnInterface) ControlServiceClient {
	return &controlServiceClient{cc}
}

func (c *controlServiceClient) CreateControl(ctx context.Context, in *CreateControlRequest, opts ...grpc.CallOption) (*Control, error) {
	out := new(Control)
	err := c.cc.Invoke(ctx, ControlService_CreateControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlServiceClient) DeleteControl(ctx context.Context, in *DeleteControlRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ControlService_DeleteControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlServiceClient) UpdateControl(ctx context.Context, in *UpdateControlRequest, opts ...grpc.CallOption) (*Control, error) {
	out := new(Control)
	err := c.cc.Invoke(ctx, ControlService_UpdateControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlServiceClient) GetControl(ctx context.Context, in *GetControlRequest, opts ...grpc.CallOption) (*Control, error) {
	out := new(Control)
	err := c.cc.Invoke(ctx, ControlService_GetControl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controlServiceClient) ListControls(ctx context.Context, in *ListControlsRequest, opts ...grpc.CallOption) (*ListControlsResponse, error) {
	out := new(ListControlsResponse)
	err := c.cc.Invoke(ctx, ControlService_ListControls_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ControlServiceServer is the server API for ControlService service.
// All implementations should embed UnimplementedControlServiceServer
// for forward compatibility
type ControlServiceServer interface {
	// Creates a Control.
	//
	// If the [Control][google.cloud.retail.v2.Control] to create already exists,
	// an ALREADY_EXISTS error is returned.
	CreateControl(context.Context, *CreateControlRequest) (*Control, error)
	// Deletes a Control.
	//
	// If the [Control][google.cloud.retail.v2.Control] to delete does not exist,
	// a NOT_FOUND error is returned.
	DeleteControl(context.Context, *DeleteControlRequest) (*emptypb.Empty, error)
	// Updates a Control.
	//
	// [Control][google.cloud.retail.v2.Control] cannot be set to a different
	// oneof field, if so an INVALID_ARGUMENT is returned. If the
	// [Control][google.cloud.retail.v2.Control] to update does not exist, a
	// NOT_FOUND error is returned.
	UpdateControl(context.Context, *UpdateControlRequest) (*Control, error)
	// Gets a Control.
	GetControl(context.Context, *GetControlRequest) (*Control, error)
	// Lists all Controls by their parent
	// [Catalog][google.cloud.retail.v2.Catalog].
	ListControls(context.Context, *ListControlsRequest) (*ListControlsResponse, error)
}

// UnimplementedControlServiceServer should be embedded to have forward compatible implementations.
type UnimplementedControlServiceServer struct {
}

func (UnimplementedControlServiceServer) CreateControl(context.Context, *CreateControlRequest) (*Control, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateControl not implemented")
}
func (UnimplementedControlServiceServer) DeleteControl(context.Context, *DeleteControlRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteControl not implemented")
}
func (UnimplementedControlServiceServer) UpdateControl(context.Context, *UpdateControlRequest) (*Control, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateControl not implemented")
}
func (UnimplementedControlServiceServer) GetControl(context.Context, *GetControlRequest) (*Control, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetControl not implemented")
}
func (UnimplementedControlServiceServer) ListControls(context.Context, *ListControlsRequest) (*ListControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListControls not implemented")
}

// UnsafeControlServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ControlServiceServer will
// result in compilation errors.
type UnsafeControlServiceServer interface {
	mustEmbedUnimplementedControlServiceServer()
}

func RegisterControlServiceServer(s grpc.ServiceRegistrar, srv ControlServiceServer) {
	s.RegisterService(&ControlService_ServiceDesc, srv)
}

func _ControlService_CreateControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServiceServer).CreateControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ControlService_CreateControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServiceServer).CreateControl(ctx, req.(*CreateControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ControlService_DeleteControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServiceServer).DeleteControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ControlService_DeleteControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServiceServer).DeleteControl(ctx, req.(*DeleteControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ControlService_UpdateControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServiceServer).UpdateControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ControlService_UpdateControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServiceServer).UpdateControl(ctx, req.(*UpdateControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ControlService_GetControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServiceServer).GetControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ControlService_GetControl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServiceServer).GetControl(ctx, req.(*GetControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ControlService_ListControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControlServiceServer).ListControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ControlService_ListControls_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControlServiceServer).ListControls(ctx, req.(*ListControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ControlService_ServiceDesc is the grpc.ServiceDesc for ControlService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ControlService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2.ControlService",
	HandlerType: (*ControlServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateControl",
			Handler:    _ControlService_CreateControl_Handler,
		},
		{
			MethodName: "DeleteControl",
			Handler:    _ControlService_DeleteControl_Handler,
		},
		{
			MethodName: "UpdateControl",
			Handler:    _ControlService_UpdateControl_Handler,
		},
		{
			MethodName: "GetControl",
			Handler:    _ControlService_GetControl_Handler,
		},
		{
			MethodName: "ListControls",
			Handler:    _ControlService_ListControls_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2/control_service.proto",
}
