// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto

package appconnectionspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AppConnectionsService_ListAppConnections_FullMethodName    = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ListAppConnections"
	AppConnectionsService_GetAppConnection_FullMethodName      = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/GetAppConnection"
	AppConnectionsService_CreateAppConnection_FullMethodName   = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/CreateAppConnection"
	AppConnectionsService_UpdateAppConnection_FullMethodName   = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/UpdateAppConnection"
	AppConnectionsService_DeleteAppConnection_FullMethodName   = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/DeleteAppConnection"
	AppConnectionsService_ResolveAppConnections_FullMethodName = "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ResolveAppConnections"
)

// AppConnectionsServiceClient is the client API for AppConnectionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AppConnectionsServiceClient interface {
	// Lists AppConnections in a given project and location.
	ListAppConnections(ctx context.Context, in *ListAppConnectionsRequest, opts ...grpc.CallOption) (*ListAppConnectionsResponse, error)
	// Gets details of a single AppConnection.
	GetAppConnection(ctx context.Context, in *GetAppConnectionRequest, opts ...grpc.CallOption) (*AppConnection, error)
	// Creates a new AppConnection in a given project and location.
	CreateAppConnection(ctx context.Context, in *CreateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnection.
	UpdateAppConnection(ctx context.Context, in *UpdateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AppConnection.
	DeleteAppConnection(ctx context.Context, in *DeleteAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resolves AppConnections details for a given AppConnector.
	// An internal method called by a connector to find AppConnections to connect
	// to.
	ResolveAppConnections(ctx context.Context, in *ResolveAppConnectionsRequest, opts ...grpc.CallOption) (*ResolveAppConnectionsResponse, error)
}

type appConnectionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAppConnectionsServiceClient(cc grpc.ClientConnInterface) AppConnectionsServiceClient {
	return &appConnectionsServiceClient{cc}
}

func (c *appConnectionsServiceClient) ListAppConnections(ctx context.Context, in *ListAppConnectionsRequest, opts ...grpc.CallOption) (*ListAppConnectionsResponse, error) {
	out := new(ListAppConnectionsResponse)
	err := c.cc.Invoke(ctx, AppConnectionsService_ListAppConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) GetAppConnection(ctx context.Context, in *GetAppConnectionRequest, opts ...grpc.CallOption) (*AppConnection, error) {
	out := new(AppConnection)
	err := c.cc.Invoke(ctx, AppConnectionsService_GetAppConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) CreateAppConnection(ctx context.Context, in *CreateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectionsService_CreateAppConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) UpdateAppConnection(ctx context.Context, in *UpdateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectionsService_UpdateAppConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) DeleteAppConnection(ctx context.Context, in *DeleteAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectionsService_DeleteAppConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) ResolveAppConnections(ctx context.Context, in *ResolveAppConnectionsRequest, opts ...grpc.CallOption) (*ResolveAppConnectionsResponse, error) {
	out := new(ResolveAppConnectionsResponse)
	err := c.cc.Invoke(ctx, AppConnectionsService_ResolveAppConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppConnectionsServiceServer is the server API for AppConnectionsService service.
// All implementations should embed UnimplementedAppConnectionsServiceServer
// for forward compatibility
type AppConnectionsServiceServer interface {
	// Lists AppConnections in a given project and location.
	ListAppConnections(context.Context, *ListAppConnectionsRequest) (*ListAppConnectionsResponse, error)
	// Gets details of a single AppConnection.
	GetAppConnection(context.Context, *GetAppConnectionRequest) (*AppConnection, error)
	// Creates a new AppConnection in a given project and location.
	CreateAppConnection(context.Context, *CreateAppConnectionRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnection.
	UpdateAppConnection(context.Context, *UpdateAppConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single AppConnection.
	DeleteAppConnection(context.Context, *DeleteAppConnectionRequest) (*longrunningpb.Operation, error)
	// Resolves AppConnections details for a given AppConnector.
	// An internal method called by a connector to find AppConnections to connect
	// to.
	ResolveAppConnections(context.Context, *ResolveAppConnectionsRequest) (*ResolveAppConnectionsResponse, error)
}

// UnimplementedAppConnectionsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAppConnectionsServiceServer struct {
}

func (UnimplementedAppConnectionsServiceServer) ListAppConnections(context.Context, *ListAppConnectionsRequest) (*ListAppConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppConnections not implemented")
}
func (UnimplementedAppConnectionsServiceServer) GetAppConnection(context.Context, *GetAppConnectionRequest) (*AppConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppConnection not implemented")
}
func (UnimplementedAppConnectionsServiceServer) CreateAppConnection(context.Context, *CreateAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppConnection not implemented")
}
func (UnimplementedAppConnectionsServiceServer) UpdateAppConnection(context.Context, *UpdateAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAppConnection not implemented")
}
func (UnimplementedAppConnectionsServiceServer) DeleteAppConnection(context.Context, *DeleteAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppConnection not implemented")
}
func (UnimplementedAppConnectionsServiceServer) ResolveAppConnections(context.Context, *ResolveAppConnectionsRequest) (*ResolveAppConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveAppConnections not implemented")
}

// UnsafeAppConnectionsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AppConnectionsServiceServer will
// result in compilation errors.
type UnsafeAppConnectionsServiceServer interface {
	mustEmbedUnimplementedAppConnectionsServiceServer()
}

func RegisterAppConnectionsServiceServer(s grpc.ServiceRegistrar, srv AppConnectionsServiceServer) {
	s.RegisterService(&AppConnectionsService_ServiceDesc, srv)
}

func _AppConnectionsService_ListAppConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).ListAppConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_ListAppConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).ListAppConnections(ctx, req.(*ListAppConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_GetAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).GetAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_GetAppConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).GetAppConnection(ctx, req.(*GetAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_CreateAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).CreateAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_CreateAppConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).CreateAppConnection(ctx, req.(*CreateAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_UpdateAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).UpdateAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_UpdateAppConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).UpdateAppConnection(ctx, req.(*UpdateAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_DeleteAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).DeleteAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_DeleteAppConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).DeleteAppConnection(ctx, req.(*DeleteAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_ResolveAppConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveAppConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).ResolveAppConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectionsService_ResolveAppConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).ResolveAppConnections(ctx, req.(*ResolveAppConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AppConnectionsService_ServiceDesc is the grpc.ServiceDesc for AppConnectionsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AppConnectionsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.appconnections.v1.AppConnectionsService",
	HandlerType: (*AppConnectionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAppConnections",
			Handler:    _AppConnectionsService_ListAppConnections_Handler,
		},
		{
			MethodName: "GetAppConnection",
			Handler:    _AppConnectionsService_GetAppConnection_Handler,
		},
		{
			MethodName: "CreateAppConnection",
			Handler:    _AppConnectionsService_CreateAppConnection_Handler,
		},
		{
			MethodName: "UpdateAppConnection",
			Handler:    _AppConnectionsService_UpdateAppConnection_Handler,
		},
		{
			MethodName: "DeleteAppConnection",
			Handler:    _AppConnectionsService_DeleteAppConnection_Handler,
		},
		{
			MethodName: "ResolveAppConnections",
			Handler:    _AppConnectionsService_ResolveAppConnections_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto",
}
