//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// EligibleChildResourcesServer is a fake server for instances of the armauthorization.EligibleChildResourcesClient type.
type EligibleChildResourcesServer struct {
	// NewGetPager is the fake for method EligibleChildResourcesClient.NewGetPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetPager func(scope string, options *armauthorization.EligibleChildResourcesClientGetOptions) (resp azfake.PagerResponder[armauthorization.EligibleChildResourcesClientGetResponse])
}

// NewEligibleChildResourcesServerTransport creates a new instance of EligibleChildResourcesServerTransport with the provided implementation.
// The returned EligibleChildResourcesServerTransport instance is connected to an instance of armauthorization.EligibleChildResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEligibleChildResourcesServerTransport(srv *EligibleChildResourcesServer) *EligibleChildResourcesServerTransport {
	return &EligibleChildResourcesServerTransport{
		srv:         srv,
		newGetPager: newTracker[azfake.PagerResponder[armauthorization.EligibleChildResourcesClientGetResponse]](),
	}
}

// EligibleChildResourcesServerTransport connects instances of armauthorization.EligibleChildResourcesClient to instances of EligibleChildResourcesServer.
// Don't use this type directly, use NewEligibleChildResourcesServerTransport instead.
type EligibleChildResourcesServerTransport struct {
	srv         *EligibleChildResourcesServer
	newGetPager *tracker[azfake.PagerResponder[armauthorization.EligibleChildResourcesClientGetResponse]]
}

// Do implements the policy.Transporter interface for EligibleChildResourcesServerTransport.
func (e *EligibleChildResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EligibleChildResourcesClient.NewGetPager":
		resp, err = e.dispatchNewGetPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EligibleChildResourcesServerTransport) dispatchNewGetPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewGetPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetPager not implemented")}
	}
	newGetPager := e.newGetPager.get(req)
	if newGetPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/eligibleChildResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armauthorization.EligibleChildResourcesClientGetOptions
		if filterParam != nil {
			options = &armauthorization.EligibleChildResourcesClientGetOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewGetPager(scopeParam, options)
		newGetPager = &resp
		e.newGetPager.add(req, newGetPager)
		server.PagerResponderInjectNextLinks(newGetPager, req, func(page *armauthorization.EligibleChildResourcesClientGetResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newGetPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetPager) {
		e.newGetPager.remove(req)
	}
	return resp, nil
}
