//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AlertConfigurationsServer is a fake server for instances of the armauthorization.AlertConfigurationsClient type.
type AlertConfigurationsServer struct {
	// Get is the fake for method AlertConfigurationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, alertID string, options *armauthorization.AlertConfigurationsClientGetOptions) (resp azfake.Responder[armauthorization.AlertConfigurationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method AlertConfigurationsClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, options *armauthorization.AlertConfigurationsClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.AlertConfigurationsClientListForScopeResponse])

	// Update is the fake for method AlertConfigurationsClient.Update
	// HTTP status codes to indicate success: http.StatusNoContent
	Update func(ctx context.Context, scope string, alertID string, parameters armauthorization.AlertConfiguration, options *armauthorization.AlertConfigurationsClientUpdateOptions) (resp azfake.Responder[armauthorization.AlertConfigurationsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAlertConfigurationsServerTransport creates a new instance of AlertConfigurationsServerTransport with the provided implementation.
// The returned AlertConfigurationsServerTransport instance is connected to an instance of armauthorization.AlertConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertConfigurationsServerTransport(srv *AlertConfigurationsServer) *AlertConfigurationsServerTransport {
	return &AlertConfigurationsServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.AlertConfigurationsClientListForScopeResponse]](),
	}
}

// AlertConfigurationsServerTransport connects instances of armauthorization.AlertConfigurationsClient to instances of AlertConfigurationsServer.
// Don't use this type directly, use NewAlertConfigurationsServerTransport instead.
type AlertConfigurationsServerTransport struct {
	srv                  *AlertConfigurationsServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.AlertConfigurationsClientListForScopeResponse]]
}

// Do implements the policy.Transporter interface for AlertConfigurationsServerTransport.
func (a *AlertConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertConfigurationsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AlertConfigurationsClient.NewListForScopePager":
		resp, err = a.dispatchNewListForScopePager(req)
	case "AlertConfigurationsClient.Update":
		resp, err = a.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertConfigurationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlertConfigurations/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, alertIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertConfigurationsServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := a.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlertConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListForScopePager(scopeParam, nil)
		newListForScopePager = &resp
		a.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.AlertConfigurationsClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		a.newListForScopePager.remove(req)
	}
	return resp, nil
}

func (a *AlertConfigurationsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlertConfigurations/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.AlertConfiguration](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), scopeParam, alertIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
