// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package cloudbuild aliases all exported identifiers in package
// "cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb".
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package cloudbuild

import (
	src "cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
const (
	ApprovalResult_APPROVED                                           = src.ApprovalResult_APPROVED
	ApprovalResult_DECISION_UNSPECIFIED                               = src.ApprovalResult_DECISION_UNSPECIFIED
	ApprovalResult_REJECTED                                           = src.ApprovalResult_REJECTED
	BuildApproval_APPROVED                                            = src.BuildApproval_APPROVED
	BuildApproval_CANCELLED                                           = src.BuildApproval_CANCELLED
	BuildApproval_PENDING                                             = src.BuildApproval_PENDING
	BuildApproval_REJECTED                                            = src.BuildApproval_REJECTED
	BuildApproval_STATE_UNSPECIFIED                                   = src.BuildApproval_STATE_UNSPECIFIED
	BuildOptions_ALLOW_LOOSE                                          = src.BuildOptions_ALLOW_LOOSE
	BuildOptions_CLOUD_LOGGING_ONLY                                   = src.BuildOptions_CLOUD_LOGGING_ONLY
	BuildOptions_E2_HIGHCPU_32                                        = src.BuildOptions_E2_HIGHCPU_32
	BuildOptions_E2_HIGHCPU_8                                         = src.BuildOptions_E2_HIGHCPU_8
	BuildOptions_GCS_ONLY                                             = src.BuildOptions_GCS_ONLY
	BuildOptions_LEGACY                                               = src.BuildOptions_LEGACY
	BuildOptions_LOGGING_UNSPECIFIED                                  = src.BuildOptions_LOGGING_UNSPECIFIED
	BuildOptions_MUST_MATCH                                           = src.BuildOptions_MUST_MATCH
	BuildOptions_N1_HIGHCPU_32                                        = src.BuildOptions_N1_HIGHCPU_32
	BuildOptions_N1_HIGHCPU_8                                         = src.BuildOptions_N1_HIGHCPU_8
	BuildOptions_NONE                                                 = src.BuildOptions_NONE
	BuildOptions_NOT_VERIFIED                                         = src.BuildOptions_NOT_VERIFIED
	BuildOptions_STACKDRIVER_ONLY                                     = src.BuildOptions_STACKDRIVER_ONLY
	BuildOptions_STREAM_DEFAULT                                       = src.BuildOptions_STREAM_DEFAULT
	BuildOptions_STREAM_OFF                                           = src.BuildOptions_STREAM_OFF
	BuildOptions_STREAM_ON                                            = src.BuildOptions_STREAM_ON
	BuildOptions_UNSPECIFIED                                          = src.BuildOptions_UNSPECIFIED
	BuildOptions_VERIFIED                                             = src.BuildOptions_VERIFIED
	Build_CANCELLED                                                   = src.Build_CANCELLED
	Build_EXPIRED                                                     = src.Build_EXPIRED
	Build_FAILURE                                                     = src.Build_FAILURE
	Build_FailureInfo_FAILURE_TYPE_UNSPECIFIED                        = src.Build_FailureInfo_FAILURE_TYPE_UNSPECIFIED
	Build_FailureInfo_FETCH_SOURCE_FAILED                             = src.Build_FailureInfo_FETCH_SOURCE_FAILED
	Build_FailureInfo_LOGGING_FAILURE                                 = src.Build_FailureInfo_LOGGING_FAILURE
	Build_FailureInfo_PUSH_FAILED                                     = src.Build_FailureInfo_PUSH_FAILED
	Build_FailureInfo_PUSH_IMAGE_NOT_FOUND                            = src.Build_FailureInfo_PUSH_IMAGE_NOT_FOUND
	Build_FailureInfo_PUSH_NOT_AUTHORIZED                             = src.Build_FailureInfo_PUSH_NOT_AUTHORIZED
	Build_FailureInfo_USER_BUILD_STEP                                 = src.Build_FailureInfo_USER_BUILD_STEP
	Build_INTERNAL_ERROR                                              = src.Build_INTERNAL_ERROR
	Build_PENDING                                                     = src.Build_PENDING
	Build_QUEUED                                                      = src.Build_QUEUED
	Build_STATUS_UNKNOWN                                              = src.Build_STATUS_UNKNOWN
	Build_SUCCESS                                                     = src.Build_SUCCESS
	Build_TIMEOUT                                                     = src.Build_TIMEOUT
	Build_WORKING                                                     = src.Build_WORKING
	Build_Warning_ALERT                                               = src.Build_Warning_ALERT
	Build_Warning_INFO                                                = src.Build_Warning_INFO
	Build_Warning_PRIORITY_UNSPECIFIED                                = src.Build_Warning_PRIORITY_UNSPECIFIED
	Build_Warning_WARNING                                             = src.Build_Warning_WARNING
	Hash_MD5                                                          = src.Hash_MD5
	Hash_NONE                                                         = src.Hash_NONE
	Hash_SHA256                                                       = src.Hash_SHA256
	PrivatePoolV1Config_NetworkConfig_EGRESS_OPTION_UNSPECIFIED       = src.PrivatePoolV1Config_NetworkConfig_EGRESS_OPTION_UNSPECIFIED
	PrivatePoolV1Config_NetworkConfig_NO_PUBLIC_EGRESS                = src.PrivatePoolV1Config_NetworkConfig_NO_PUBLIC_EGRESS
	PrivatePoolV1Config_NetworkConfig_PUBLIC_EGRESS                   = src.PrivatePoolV1Config_NetworkConfig_PUBLIC_EGRESS
	PubsubConfig_OK                                                   = src.PubsubConfig_OK
	PubsubConfig_STATE_UNSPECIFIED                                    = src.PubsubConfig_STATE_UNSPECIFIED
	PubsubConfig_SUBSCRIPTION_DELETED                                 = src.PubsubConfig_SUBSCRIPTION_DELETED
	PubsubConfig_SUBSCRIPTION_MISCONFIGURED                           = src.PubsubConfig_SUBSCRIPTION_MISCONFIGURED
	PubsubConfig_TOPIC_DELETED                                        = src.PubsubConfig_TOPIC_DELETED
	PullRequestFilter_COMMENTS_DISABLED                               = src.PullRequestFilter_COMMENTS_DISABLED
	PullRequestFilter_COMMENTS_ENABLED                                = src.PullRequestFilter_COMMENTS_ENABLED
	PullRequestFilter_COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY = src.PullRequestFilter_COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY
	WebhookConfig_OK                                                  = src.WebhookConfig_OK
	WebhookConfig_SECRET_DELETED                                      = src.WebhookConfig_SECRET_DELETED
	WebhookConfig_STATE_UNSPECIFIED                                   = src.WebhookConfig_STATE_UNSPECIFIED
	WorkerPool_CREATING                                               = src.WorkerPool_CREATING
	WorkerPool_DELETED                                                = src.WorkerPool_DELETED
	WorkerPool_DELETING                                               = src.WorkerPool_DELETING
	WorkerPool_RUNNING                                                = src.WorkerPool_RUNNING
	WorkerPool_STATE_UNSPECIFIED                                      = src.WorkerPool_STATE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
var (
	ApprovalResult_Decision_name                         = src.ApprovalResult_Decision_name
	ApprovalResult_Decision_value                        = src.ApprovalResult_Decision_value
	BuildApproval_State_name                             = src.BuildApproval_State_name
	BuildApproval_State_value                            = src.BuildApproval_State_value
	BuildOptions_LogStreamingOption_name                 = src.BuildOptions_LogStreamingOption_name
	BuildOptions_LogStreamingOption_value                = src.BuildOptions_LogStreamingOption_value
	BuildOptions_LoggingMode_name                        = src.BuildOptions_LoggingMode_name
	BuildOptions_LoggingMode_value                       = src.BuildOptions_LoggingMode_value
	BuildOptions_MachineType_name                        = src.BuildOptions_MachineType_name
	BuildOptions_MachineType_value                       = src.BuildOptions_MachineType_value
	BuildOptions_SubstitutionOption_name                 = src.BuildOptions_SubstitutionOption_name
	BuildOptions_SubstitutionOption_value                = src.BuildOptions_SubstitutionOption_value
	BuildOptions_VerifyOption_name                       = src.BuildOptions_VerifyOption_name
	BuildOptions_VerifyOption_value                      = src.BuildOptions_VerifyOption_value
	Build_FailureInfo_FailureType_name                   = src.Build_FailureInfo_FailureType_name
	Build_FailureInfo_FailureType_value                  = src.Build_FailureInfo_FailureType_value
	Build_Status_name                                    = src.Build_Status_name
	Build_Status_value                                   = src.Build_Status_value
	Build_Warning_Priority_name                          = src.Build_Warning_Priority_name
	Build_Warning_Priority_value                         = src.Build_Warning_Priority_value
	File_google_devtools_cloudbuild_v1_cloudbuild_proto  = src.File_google_devtools_cloudbuild_v1_cloudbuild_proto
	Hash_HashType_name                                   = src.Hash_HashType_name
	Hash_HashType_value                                  = src.Hash_HashType_value
	PrivatePoolV1Config_NetworkConfig_EgressOption_name  = src.PrivatePoolV1Config_NetworkConfig_EgressOption_name
	PrivatePoolV1Config_NetworkConfig_EgressOption_value = src.PrivatePoolV1Config_NetworkConfig_EgressOption_value
	PubsubConfig_State_name                              = src.PubsubConfig_State_name
	PubsubConfig_State_value                             = src.PubsubConfig_State_value
	PullRequestFilter_CommentControl_name                = src.PullRequestFilter_CommentControl_name
	PullRequestFilter_CommentControl_value               = src.PullRequestFilter_CommentControl_value
	WebhookConfig_State_name                             = src.WebhookConfig_State_name
	WebhookConfig_State_value                            = src.WebhookConfig_State_value
	WorkerPool_State_name                                = src.WorkerPool_State_name
	WorkerPool_State_value                               = src.WorkerPool_State_value
)

// ApprovalConfig describes configuration for manual approval of a build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ApprovalConfig = src.ApprovalConfig

// ApprovalResult describes the decision and associated metadata of a manual
// approval of a build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ApprovalResult = src.ApprovalResult

// Specifies whether or not this manual approval result is to approve or
// reject a build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ApprovalResult_Decision = src.ApprovalResult_Decision

// Request to approve or reject a pending build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ApproveBuildRequest = src.ApproveBuildRequest

// An artifact that was uploaded during a build. This is a single record in
// the artifact manifest JSON file.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ArtifactResult = src.ArtifactResult

// Artifacts produced by a build that should be uploaded upon successful
// completion of all build steps.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Artifacts = src.Artifacts

// Files in the workspace to upload to Cloud Storage upon successful
// completion of all build steps.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Artifacts_ArtifactObjects = src.Artifacts_ArtifactObjects

// A build resource in the Cloud Build API. At a high level, a `Build`
// describes where to find source code, how to build it (for example, the
// builder image to run on the source), and where to store the built artifacts.
// Fields can include the following variables, which will be expanded when the
// build is created: - $PROJECT_ID: the project ID of the build. -
// $PROJECT_NUMBER: the project number of the build. - $BUILD_ID: the
// autogenerated ID of the build. - $REPO_NAME: the source repository name
// specified by RepoSource. - $BRANCH_NAME: the branch name specified by
// RepoSource. - $TAG_NAME: the tag name specified by RepoSource. -
// $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
// resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters
// of $REVISION_ID or $COMMIT_SHA.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build = src.Build

// BuildApproval describes a build's approval configuration, state, and
// result.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildApproval = src.BuildApproval

// Specifies the current state of a build's approval.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildApproval_State = src.BuildApproval_State

// Metadata for build operations.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOperationMetadata = src.BuildOperationMetadata

// Optional arguments to enable specific features of builds.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions = src.BuildOptions

// Specifies the behavior when writing build logs to Google Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_LogStreamingOption = src.BuildOptions_LogStreamingOption

// Specifies the logging mode.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_LoggingMode = src.BuildOptions_LoggingMode

// Supported Compute Engine machine types. For more information, see [Machine
// types](https://cloud.google.com/compute/docs/machine-types).
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_MachineType = src.BuildOptions_MachineType

// Details about how a build should be executed on a `WorkerPool`. See
// [running builds in a private
// pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
// for more information.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_PoolOption = src.BuildOptions_PoolOption

// Specifies the behavior when there is an error in the substitution checks.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_SubstitutionOption = src.BuildOptions_SubstitutionOption

// Specifies the manner in which the build should be verified, if at all.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildOptions_VerifyOption = src.BuildOptions_VerifyOption

// A step in the build pipeline.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildStep = src.BuildStep

// Configuration for an automated build in response to source repository
// changes.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuildTrigger = src.BuildTrigger
type BuildTrigger_Autodetect = src.BuildTrigger_Autodetect
type BuildTrigger_Build = src.BuildTrigger_Build
type BuildTrigger_Filename = src.BuildTrigger_Filename

// A fatal problem encountered during the execution of the build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build_FailureInfo = src.Build_FailureInfo

// The name of a fatal problem encountered during the execution of the build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build_FailureInfo_FailureType = src.Build_FailureInfo_FailureType

// Possible status of a build or build step.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build_Status = src.Build_Status

// A non-fatal problem encountered during the execution of the build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build_Warning = src.Build_Warning

// The relative importance of this warning.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Build_Warning_Priority = src.Build_Warning_Priority

// An image built by the pipeline.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type BuiltImage = src.BuiltImage

// Request to cancel an ongoing build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CancelBuildRequest = src.CancelBuildRequest

// CloudBuildClient is the client API for CloudBuild service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CloudBuildClient = src.CloudBuildClient

// CloudBuildServer is the server API for CloudBuild service.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CloudBuildServer = src.CloudBuildServer

// Request to create a new build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CreateBuildRequest = src.CreateBuildRequest

// Request to create a new `BuildTrigger`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CreateBuildTriggerRequest = src.CreateBuildTriggerRequest

// Metadata for the `CreateWorkerPool` operation.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CreateWorkerPoolOperationMetadata = src.CreateWorkerPoolOperationMetadata

// Request to create a new `WorkerPool`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type CreateWorkerPoolRequest = src.CreateWorkerPoolRequest

// Request to delete a `BuildTrigger`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type DeleteBuildTriggerRequest = src.DeleteBuildTriggerRequest

// Metadata for the `DeleteWorkerPool` operation.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type DeleteWorkerPoolOperationMetadata = src.DeleteWorkerPoolOperationMetadata

// Request to delete a `WorkerPool`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type DeleteWorkerPoolRequest = src.DeleteWorkerPoolRequest

// Container message for hashes of byte content of files, used in
// SourceProvenance messages to verify integrity of source input to the build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type FileHashes = src.FileHashes

// Request to get a build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type GetBuildRequest = src.GetBuildRequest

// Returns the `BuildTrigger` with the specified ID.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type GetBuildTriggerRequest = src.GetBuildTriggerRequest

// Request to get a `WorkerPool` with the specified name.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type GetWorkerPoolRequest = src.GetWorkerPoolRequest

// GitHubEventsConfig describes the configuration of a trigger that creates a
// build whenever a GitHub event is received. This message is experimental.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type GitHubEventsConfig = src.GitHubEventsConfig
type GitHubEventsConfig_PullRequest = src.GitHubEventsConfig_PullRequest
type GitHubEventsConfig_Push = src.GitHubEventsConfig_Push

// Container message for hash values.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Hash = src.Hash

// Specifies the hash algorithm, if any.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Hash_HashType = src.Hash_HashType

// Pairs a set of secret environment variables mapped to encrypted values with
// the Cloud KMS key to use to decrypt the value.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type InlineSecret = src.InlineSecret

// Request to list existing `BuildTriggers`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListBuildTriggersRequest = src.ListBuildTriggersRequest

// Response containing existing `BuildTriggers`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListBuildTriggersResponse = src.ListBuildTriggersResponse

// Request to list builds.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListBuildsRequest = src.ListBuildsRequest

// Response including listed builds.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListBuildsResponse = src.ListBuildsResponse

// Request to list `WorkerPool`s.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListWorkerPoolsRequest = src.ListWorkerPoolsRequest

// Response containing existing `WorkerPools`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ListWorkerPoolsResponse = src.ListWorkerPoolsResponse

// Configuration for a V1 `PrivatePool`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PrivatePoolV1Config = src.PrivatePoolV1Config

// Defines the network configuration for the pool.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PrivatePoolV1Config_NetworkConfig = src.PrivatePoolV1Config_NetworkConfig

// Defines the egress option for the pool.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PrivatePoolV1Config_NetworkConfig_EgressOption = src.PrivatePoolV1Config_NetworkConfig_EgressOption

// Defines the configuration to be used for creating workers in the pool.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PrivatePoolV1Config_WorkerConfig = src.PrivatePoolV1Config_WorkerConfig

// PubsubConfig describes the configuration of a trigger that creates a build
// whenever a Pub/Sub message is published.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PubsubConfig = src.PubsubConfig

// Enumerates potential issues with the underlying Pub/Sub subscription
// configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PubsubConfig_State = src.PubsubConfig_State

// PullRequestFilter contains filter properties for matching GitHub Pull
// Requests.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PullRequestFilter = src.PullRequestFilter
type PullRequestFilter_Branch = src.PullRequestFilter_Branch

// Controls behavior of Pull Request comments.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PullRequestFilter_CommentControl = src.PullRequestFilter_CommentControl

// Push contains filter properties for matching GitHub git pushes.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type PushFilter = src.PushFilter
type PushFilter_Branch = src.PushFilter_Branch
type PushFilter_Tag = src.PushFilter_Tag

// ReceiveTriggerWebhookRequest [Experimental] is the request object accepted
// by the ReceiveTriggerWebhook method.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ReceiveTriggerWebhookRequest = src.ReceiveTriggerWebhookRequest

// ReceiveTriggerWebhookResponse [Experimental] is the response object for the
// ReceiveTriggerWebhook method.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type ReceiveTriggerWebhookResponse = src.ReceiveTriggerWebhookResponse

// Location of the source in a Google Cloud Source Repository.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type RepoSource = src.RepoSource
type RepoSource_BranchName = src.RepoSource_BranchName
type RepoSource_CommitSha = src.RepoSource_CommitSha
type RepoSource_TagName = src.RepoSource_TagName

// Artifacts created by the build pipeline.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Results = src.Results

// Specifies a build to retry.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type RetryBuildRequest = src.RetryBuildRequest

// Specifies a build trigger to run and the source to use.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type RunBuildTriggerRequest = src.RunBuildTriggerRequest

// Pairs a set of secret environment variables containing encrypted values
// with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName`
// with `available_secrets` instead of using `kmsKeyName` with `secret`. For
// instructions see:
// https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Secret = src.Secret

// Pairs a secret environment variable with a SecretVersion in Secret Manager.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type SecretManagerSecret = src.SecretManagerSecret

// Secrets and secret environment variables.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Secrets = src.Secrets

// Location of the source in a supported storage service.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Source = src.Source

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type SourceProvenance = src.SourceProvenance
type Source_RepoSource = src.Source_RepoSource
type Source_StorageSource = src.Source_StorageSource
type Source_StorageSourceManifest = src.Source_StorageSourceManifest

// Location of the source in an archive file in Google Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type StorageSource = src.StorageSource

// Location of the source manifest in Google Cloud Storage. This feature is in
// Preview; see description
// [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type StorageSourceManifest = src.StorageSourceManifest

// Start and end times for a build execution phase.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type TimeSpan = src.TimeSpan

// UnimplementedCloudBuildServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type UnimplementedCloudBuildServer = src.UnimplementedCloudBuildServer

// Request to update an existing `BuildTrigger`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type UpdateBuildTriggerRequest = src.UpdateBuildTriggerRequest

// Metadata for the `UpdateWorkerPool` operation.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type UpdateWorkerPoolOperationMetadata = src.UpdateWorkerPoolOperationMetadata

// Request to update a `WorkerPool`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type UpdateWorkerPoolRequest = src.UpdateWorkerPoolRequest

// Volume describes a Docker container volume which is mounted into build
// steps in order to persist files across build step execution.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type Volume = src.Volume

// WebhookConfig describes the configuration of a trigger that creates a build
// whenever a webhook is sent to a trigger's webhook URL.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type WebhookConfig = src.WebhookConfig
type WebhookConfig_Secret = src.WebhookConfig_Secret

// Enumerates potential issues with the Secret Manager secret provided by the
// user.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type WebhookConfig_State = src.WebhookConfig_State

// Configuration for a `WorkerPool`. Cloud Build owns and maintains a pool of
// workers for general use and have no access to a project's private network.
// By default, builds submitted to Cloud Build will use a worker from this
// pool. If your build needs access to resources on a private network, create
// and use a `WorkerPool` to run your builds. Private `WorkerPool`s give your
// builds access to any single VPC network that you administer, including any
// on-prem resources connected to that VPC network. For an overview of private
// pools, see [Private pools
// overview](https://cloud.google.com/build/docs/private-pools/private-pools-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type WorkerPool = src.WorkerPool
type WorkerPool_PrivatePoolV1Config = src.WorkerPool_PrivatePoolV1Config

// State of the `WorkerPool`.
//
// Deprecated: Please use types in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
type WorkerPool_State = src.WorkerPool_State

// Deprecated: Please use funcs in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
func NewCloudBuildClient(cc grpc.ClientConnInterface) CloudBuildClient {
	return src.NewCloudBuildClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/cloudbuild/apiv1/v2/cloudbuildpb
func RegisterCloudBuildServer(s *grpc.Server, srv CloudBuildServer) {
	src.RegisterCloudBuildServer(s, srv)
}
