// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/containeranalysis/v1beta1/containeranalysis.proto

package containeranalysispb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ContainerAnalysisV1Beta1_SetIamPolicy_FullMethodName            = "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/SetIamPolicy"
	ContainerAnalysisV1Beta1_GetIamPolicy_FullMethodName            = "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GetIamPolicy"
	ContainerAnalysisV1Beta1_TestIamPermissions_FullMethodName      = "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/TestIamPermissions"
	ContainerAnalysisV1Beta1_GeneratePackagesSummary_FullMethodName = "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/GeneratePackagesSummary"
	ContainerAnalysisV1Beta1_ExportSBOM_FullMethodName              = "/google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1/ExportSBOM"
)

// ContainerAnalysisV1Beta1Client is the client API for ContainerAnalysisV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ContainerAnalysisV1Beta1Client interface {
	// Sets the access control policy on the specified note or occurrence.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or an occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for a note or an occurrence resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence. Requires list permission on the project (for example,
	// `containeranalysis.notes.list`).
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Gets a summary of the packages within a given resource.
	GeneratePackagesSummary(ctx context.Context, in *GeneratePackagesSummaryRequest, opts ...grpc.CallOption) (*PackagesSummaryResponse, error)
	// Generates an SBOM and other dependency information for the given resource.
	ExportSBOM(ctx context.Context, in *ExportSBOMRequest, opts ...grpc.CallOption) (*ExportSBOMResponse, error)
}

type containerAnalysisV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewContainerAnalysisV1Beta1Client(cc grpc.ClientConnInterface) ContainerAnalysisV1Beta1Client {
	return &containerAnalysisV1Beta1Client{cc}
}

func (c *containerAnalysisV1Beta1Client) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ContainerAnalysisV1Beta1_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ContainerAnalysisV1Beta1_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, ContainerAnalysisV1Beta1_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) GeneratePackagesSummary(ctx context.Context, in *GeneratePackagesSummaryRequest, opts ...grpc.CallOption) (*PackagesSummaryResponse, error) {
	out := new(PackagesSummaryResponse)
	err := c.cc.Invoke(ctx, ContainerAnalysisV1Beta1_GeneratePackagesSummary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisV1Beta1Client) ExportSBOM(ctx context.Context, in *ExportSBOMRequest, opts ...grpc.CallOption) (*ExportSBOMResponse, error) {
	out := new(ExportSBOMResponse)
	err := c.cc.Invoke(ctx, ContainerAnalysisV1Beta1_ExportSBOM_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContainerAnalysisV1Beta1Server is the server API for ContainerAnalysisV1Beta1 service.
// All implementations should embed UnimplementedContainerAnalysisV1Beta1Server
// for forward compatibility
type ContainerAnalysisV1Beta1Server interface {
	// Sets the access control policy on the specified note or occurrence.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or an occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for a note or an occurrence resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence. Requires list permission on the project (for example,
	// `containeranalysis.notes.list`).
	//
	// The resource takes the format `projects/[PROJECT_ID]/notes/[NOTE_ID]` for
	// notes and `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]` for
	// occurrences.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Gets a summary of the packages within a given resource.
	GeneratePackagesSummary(context.Context, *GeneratePackagesSummaryRequest) (*PackagesSummaryResponse, error)
	// Generates an SBOM and other dependency information for the given resource.
	ExportSBOM(context.Context, *ExportSBOMRequest) (*ExportSBOMResponse, error)
}

// UnimplementedContainerAnalysisV1Beta1Server should be embedded to have forward compatible implementations.
type UnimplementedContainerAnalysisV1Beta1Server struct {
}

func (UnimplementedContainerAnalysisV1Beta1Server) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedContainerAnalysisV1Beta1Server) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedContainerAnalysisV1Beta1Server) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedContainerAnalysisV1Beta1Server) GeneratePackagesSummary(context.Context, *GeneratePackagesSummaryRequest) (*PackagesSummaryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GeneratePackagesSummary not implemented")
}
func (UnimplementedContainerAnalysisV1Beta1Server) ExportSBOM(context.Context, *ExportSBOMRequest) (*ExportSBOMResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportSBOM not implemented")
}

// UnsafeContainerAnalysisV1Beta1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ContainerAnalysisV1Beta1Server will
// result in compilation errors.
type UnsafeContainerAnalysisV1Beta1Server interface {
	mustEmbedUnimplementedContainerAnalysisV1Beta1Server()
}

func RegisterContainerAnalysisV1Beta1Server(s grpc.ServiceRegistrar, srv ContainerAnalysisV1Beta1Server) {
	s.RegisterService(&ContainerAnalysisV1Beta1_ServiceDesc, srv)
}

func _ContainerAnalysisV1Beta1_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContainerAnalysisV1Beta1_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContainerAnalysisV1Beta1_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContainerAnalysisV1Beta1_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_GeneratePackagesSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GeneratePackagesSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).GeneratePackagesSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContainerAnalysisV1Beta1_GeneratePackagesSummary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).GeneratePackagesSummary(ctx, req.(*GeneratePackagesSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysisV1Beta1_ExportSBOM_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportSBOMRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisV1Beta1Server).ExportSBOM(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContainerAnalysisV1Beta1_ExportSBOM_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisV1Beta1Server).ExportSBOM(ctx, req.(*ExportSBOMRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ContainerAnalysisV1Beta1_ServiceDesc is the grpc.ServiceDesc for ContainerAnalysisV1Beta1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ContainerAnalysisV1Beta1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1",
	HandlerType: (*ContainerAnalysisV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetIamPolicy",
			Handler:    _ContainerAnalysisV1Beta1_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ContainerAnalysisV1Beta1_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ContainerAnalysisV1Beta1_TestIamPermissions_Handler,
		},
		{
			MethodName: "GeneratePackagesSummary",
			Handler:    _ContainerAnalysisV1Beta1_GeneratePackagesSummary_Handler,
		},
		{
			MethodName: "ExportSBOM",
			Handler:    _ContainerAnalysisV1Beta1_ExportSBOM_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/containeranalysis/v1beta1/containeranalysis.proto",
}
