/*
Slurm Rest API RO

API to access Slurm. Only GET requests are implemented.

API version: 0.0.38
Contact: sales@schedmd.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package v0038

import (
	"encoding/json"
)

// checks if the V0038Node type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &V0038Node{}

// V0038Node struct for V0038Node
type V0038Node struct {
	// computer architecture
	Architecture *string `json:"architecture,omitempty"`
	// BcastAddr
	BurstbufferNetworkAddress *string `json:"burstbuffer_network_address,omitempty"`
	// total number of boards per node
	Boards *int32 `json:"boards,omitempty"`
	// timestamp of node boot
	BootTime *int64 `json:"boot_time,omitempty"`
	// number of cores per socket
	Cores *int32 `json:"cores,omitempty"`
	// Default task binding
	CpuBinding *int32 `json:"cpu_binding,omitempty"`
	// CPU load * 100
	CpuLoad *int64 `json:"cpu_load,omitempty"`
	// free memory in MiB
	FreeMemory *int32 `json:"free_memory,omitempty"`
	// configured count of cpus running on the node
	Cpus *int32 `json:"cpus,omitempty"`
	// 
	Features *string `json:"features,omitempty"`
	// list of a node's available features
	ActiveFeatures *string `json:"active_features,omitempty"`
	// list of a node's generic resources
	Gres *string `json:"gres,omitempty"`
	// list of drained GRES
	GresDrained *string `json:"gres_drained,omitempty"`
	// list of GRES in current use
	GresUsed *string `json:"gres_used,omitempty"`
	// mcs label if mcs plugin in use
	McsLabel *string `json:"mcs_label,omitempty"`
	// node name to slurm
	Name *string `json:"name,omitempty"`
	// state after reboot
	NextStateAfterReboot *string `json:"next_state_after_reboot,omitempty"`
	// node state flags
	NextStateAfterRebootFlags []string `json:"next_state_after_reboot_flags,omitempty"`
	// state after reboot
	Address *string `json:"address,omitempty"`
	// node's hostname
	Hostname *string `json:"hostname,omitempty"`
	// current node state
	State *string `json:"state,omitempty"`
	// node state flags
	StateFlags []string `json:"state_flags,omitempty"`
	// operating system
	OperatingSystem *string `json:"operating_system,omitempty"`
	// User allowed to use this node
	Owner *string `json:"owner,omitempty"`
	// assigned partitions
	Partitions []string `json:"partitions,omitempty"`
	// TCP port number of the slurmd
	Port *int32 `json:"port,omitempty"`
	// configured MB of real memory on the node
	RealMemory *int32 `json:"real_memory,omitempty"`
	// reason for node being DOWN or DRAINING
	Reason *string `json:"reason,omitempty"`
	// Time stamp when reason was set
	ReasonChangedAt *int32 `json:"reason_changed_at,omitempty"`
	// User that set the reason
	ReasonSetByUser *string `json:"reason_set_by_user,omitempty"`
	// timestamp of slurmd startup
	SlurmdStartTime *int64 `json:"slurmd_start_time,omitempty"`
	// total number of sockets per node
	Sockets *int32 `json:"sockets,omitempty"`
	// number of threads per core
	Threads *int32 `json:"threads,omitempty"`
	// configured MB of total disk in TMP_FS
	TemporaryDisk *int32 `json:"temporary_disk,omitempty"`
	// arbitrary priority of node for scheduling
	Weight *int32 `json:"weight,omitempty"`
	// TRES on node
	Tres *string `json:"tres,omitempty"`
	// TRES used on node
	TresUsed *string `json:"tres_used,omitempty"`
	// TRES weight used on node
	TresWeighted *float64 `json:"tres_weighted,omitempty"`
	// Slurmd version
	SlurmdVersion *string `json:"slurmd_version,omitempty"`
	// Allocated CPUs
	AllocCpus *int64 `json:"alloc_cpus,omitempty"`
	// Idle CPUs
	IdleCpus *int64 `json:"idle_cpus,omitempty"`
	// Allocated memory (MB)
	AllocMemory *int64 `json:"alloc_memory,omitempty"`
}

// NewV0038Node instantiates a new V0038Node object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewV0038Node() *V0038Node {
	this := V0038Node{}
	return &this
}

// NewV0038NodeWithDefaults instantiates a new V0038Node object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewV0038NodeWithDefaults() *V0038Node {
	this := V0038Node{}
	return &this
}

// GetArchitecture returns the Architecture field value if set, zero value otherwise.
func (o *V0038Node) GetArchitecture() string {
	if o == nil || IsNil(o.Architecture) {
		var ret string
		return ret
	}
	return *o.Architecture
}

// GetArchitectureOk returns a tuple with the Architecture field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetArchitectureOk() (*string, bool) {
	if o == nil || IsNil(o.Architecture) {
		return nil, false
	}
	return o.Architecture, true
}

// HasArchitecture returns a boolean if a field has been set.
func (o *V0038Node) HasArchitecture() bool {
	if o != nil && !IsNil(o.Architecture) {
		return true
	}

	return false
}

// SetArchitecture gets a reference to the given string and assigns it to the Architecture field.
func (o *V0038Node) SetArchitecture(v string) {
	o.Architecture = &v
}

// GetBurstbufferNetworkAddress returns the BurstbufferNetworkAddress field value if set, zero value otherwise.
func (o *V0038Node) GetBurstbufferNetworkAddress() string {
	if o == nil || IsNil(o.BurstbufferNetworkAddress) {
		var ret string
		return ret
	}
	return *o.BurstbufferNetworkAddress
}

// GetBurstbufferNetworkAddressOk returns a tuple with the BurstbufferNetworkAddress field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetBurstbufferNetworkAddressOk() (*string, bool) {
	if o == nil || IsNil(o.BurstbufferNetworkAddress) {
		return nil, false
	}
	return o.BurstbufferNetworkAddress, true
}

// HasBurstbufferNetworkAddress returns a boolean if a field has been set.
func (o *V0038Node) HasBurstbufferNetworkAddress() bool {
	if o != nil && !IsNil(o.BurstbufferNetworkAddress) {
		return true
	}

	return false
}

// SetBurstbufferNetworkAddress gets a reference to the given string and assigns it to the BurstbufferNetworkAddress field.
func (o *V0038Node) SetBurstbufferNetworkAddress(v string) {
	o.BurstbufferNetworkAddress = &v
}

// GetBoards returns the Boards field value if set, zero value otherwise.
func (o *V0038Node) GetBoards() int32 {
	if o == nil || IsNil(o.Boards) {
		var ret int32
		return ret
	}
	return *o.Boards
}

// GetBoardsOk returns a tuple with the Boards field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetBoardsOk() (*int32, bool) {
	if o == nil || IsNil(o.Boards) {
		return nil, false
	}
	return o.Boards, true
}

// HasBoards returns a boolean if a field has been set.
func (o *V0038Node) HasBoards() bool {
	if o != nil && !IsNil(o.Boards) {
		return true
	}

	return false
}

// SetBoards gets a reference to the given int32 and assigns it to the Boards field.
func (o *V0038Node) SetBoards(v int32) {
	o.Boards = &v
}

// GetBootTime returns the BootTime field value if set, zero value otherwise.
func (o *V0038Node) GetBootTime() int64 {
	if o == nil || IsNil(o.BootTime) {
		var ret int64
		return ret
	}
	return *o.BootTime
}

// GetBootTimeOk returns a tuple with the BootTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetBootTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.BootTime) {
		return nil, false
	}
	return o.BootTime, true
}

// HasBootTime returns a boolean if a field has been set.
func (o *V0038Node) HasBootTime() bool {
	if o != nil && !IsNil(o.BootTime) {
		return true
	}

	return false
}

// SetBootTime gets a reference to the given int64 and assigns it to the BootTime field.
func (o *V0038Node) SetBootTime(v int64) {
	o.BootTime = &v
}

// GetCores returns the Cores field value if set, zero value otherwise.
func (o *V0038Node) GetCores() int32 {
	if o == nil || IsNil(o.Cores) {
		var ret int32
		return ret
	}
	return *o.Cores
}

// GetCoresOk returns a tuple with the Cores field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetCoresOk() (*int32, bool) {
	if o == nil || IsNil(o.Cores) {
		return nil, false
	}
	return o.Cores, true
}

// HasCores returns a boolean if a field has been set.
func (o *V0038Node) HasCores() bool {
	if o != nil && !IsNil(o.Cores) {
		return true
	}

	return false
}

// SetCores gets a reference to the given int32 and assigns it to the Cores field.
func (o *V0038Node) SetCores(v int32) {
	o.Cores = &v
}

// GetCpuBinding returns the CpuBinding field value if set, zero value otherwise.
func (o *V0038Node) GetCpuBinding() int32 {
	if o == nil || IsNil(o.CpuBinding) {
		var ret int32
		return ret
	}
	return *o.CpuBinding
}

// GetCpuBindingOk returns a tuple with the CpuBinding field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetCpuBindingOk() (*int32, bool) {
	if o == nil || IsNil(o.CpuBinding) {
		return nil, false
	}
	return o.CpuBinding, true
}

// HasCpuBinding returns a boolean if a field has been set.
func (o *V0038Node) HasCpuBinding() bool {
	if o != nil && !IsNil(o.CpuBinding) {
		return true
	}

	return false
}

// SetCpuBinding gets a reference to the given int32 and assigns it to the CpuBinding field.
func (o *V0038Node) SetCpuBinding(v int32) {
	o.CpuBinding = &v
}

// GetCpuLoad returns the CpuLoad field value if set, zero value otherwise.
func (o *V0038Node) GetCpuLoad() int64 {
	if o == nil || IsNil(o.CpuLoad) {
		var ret int64
		return ret
	}
	return *o.CpuLoad
}

// GetCpuLoadOk returns a tuple with the CpuLoad field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetCpuLoadOk() (*int64, bool) {
	if o == nil || IsNil(o.CpuLoad) {
		return nil, false
	}
	return o.CpuLoad, true
}

// HasCpuLoad returns a boolean if a field has been set.
func (o *V0038Node) HasCpuLoad() bool {
	if o != nil && !IsNil(o.CpuLoad) {
		return true
	}

	return false
}

// SetCpuLoad gets a reference to the given int64 and assigns it to the CpuLoad field.
func (o *V0038Node) SetCpuLoad(v int64) {
	o.CpuLoad = &v
}

// GetFreeMemory returns the FreeMemory field value if set, zero value otherwise.
func (o *V0038Node) GetFreeMemory() int32 {
	if o == nil || IsNil(o.FreeMemory) {
		var ret int32
		return ret
	}
	return *o.FreeMemory
}

// GetFreeMemoryOk returns a tuple with the FreeMemory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetFreeMemoryOk() (*int32, bool) {
	if o == nil || IsNil(o.FreeMemory) {
		return nil, false
	}
	return o.FreeMemory, true
}

// HasFreeMemory returns a boolean if a field has been set.
func (o *V0038Node) HasFreeMemory() bool {
	if o != nil && !IsNil(o.FreeMemory) {
		return true
	}

	return false
}

// SetFreeMemory gets a reference to the given int32 and assigns it to the FreeMemory field.
func (o *V0038Node) SetFreeMemory(v int32) {
	o.FreeMemory = &v
}

// GetCpus returns the Cpus field value if set, zero value otherwise.
func (o *V0038Node) GetCpus() int32 {
	if o == nil || IsNil(o.Cpus) {
		var ret int32
		return ret
	}
	return *o.Cpus
}

// GetCpusOk returns a tuple with the Cpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetCpusOk() (*int32, bool) {
	if o == nil || IsNil(o.Cpus) {
		return nil, false
	}
	return o.Cpus, true
}

// HasCpus returns a boolean if a field has been set.
func (o *V0038Node) HasCpus() bool {
	if o != nil && !IsNil(o.Cpus) {
		return true
	}

	return false
}

// SetCpus gets a reference to the given int32 and assigns it to the Cpus field.
func (o *V0038Node) SetCpus(v int32) {
	o.Cpus = &v
}

// GetFeatures returns the Features field value if set, zero value otherwise.
func (o *V0038Node) GetFeatures() string {
	if o == nil || IsNil(o.Features) {
		var ret string
		return ret
	}
	return *o.Features
}

// GetFeaturesOk returns a tuple with the Features field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.Features) {
		return nil, false
	}
	return o.Features, true
}

// HasFeatures returns a boolean if a field has been set.
func (o *V0038Node) HasFeatures() bool {
	if o != nil && !IsNil(o.Features) {
		return true
	}

	return false
}

// SetFeatures gets a reference to the given string and assigns it to the Features field.
func (o *V0038Node) SetFeatures(v string) {
	o.Features = &v
}

// GetActiveFeatures returns the ActiveFeatures field value if set, zero value otherwise.
func (o *V0038Node) GetActiveFeatures() string {
	if o == nil || IsNil(o.ActiveFeatures) {
		var ret string
		return ret
	}
	return *o.ActiveFeatures
}

// GetActiveFeaturesOk returns a tuple with the ActiveFeatures field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetActiveFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.ActiveFeatures) {
		return nil, false
	}
	return o.ActiveFeatures, true
}

// HasActiveFeatures returns a boolean if a field has been set.
func (o *V0038Node) HasActiveFeatures() bool {
	if o != nil && !IsNil(o.ActiveFeatures) {
		return true
	}

	return false
}

// SetActiveFeatures gets a reference to the given string and assigns it to the ActiveFeatures field.
func (o *V0038Node) SetActiveFeatures(v string) {
	o.ActiveFeatures = &v
}

// GetGres returns the Gres field value if set, zero value otherwise.
func (o *V0038Node) GetGres() string {
	if o == nil || IsNil(o.Gres) {
		var ret string
		return ret
	}
	return *o.Gres
}

// GetGresOk returns a tuple with the Gres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetGresOk() (*string, bool) {
	if o == nil || IsNil(o.Gres) {
		return nil, false
	}
	return o.Gres, true
}

// HasGres returns a boolean if a field has been set.
func (o *V0038Node) HasGres() bool {
	if o != nil && !IsNil(o.Gres) {
		return true
	}

	return false
}

// SetGres gets a reference to the given string and assigns it to the Gres field.
func (o *V0038Node) SetGres(v string) {
	o.Gres = &v
}

// GetGresDrained returns the GresDrained field value if set, zero value otherwise.
func (o *V0038Node) GetGresDrained() string {
	if o == nil || IsNil(o.GresDrained) {
		var ret string
		return ret
	}
	return *o.GresDrained
}

// GetGresDrainedOk returns a tuple with the GresDrained field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetGresDrainedOk() (*string, bool) {
	if o == nil || IsNil(o.GresDrained) {
		return nil, false
	}
	return o.GresDrained, true
}

// HasGresDrained returns a boolean if a field has been set.
func (o *V0038Node) HasGresDrained() bool {
	if o != nil && !IsNil(o.GresDrained) {
		return true
	}

	return false
}

// SetGresDrained gets a reference to the given string and assigns it to the GresDrained field.
func (o *V0038Node) SetGresDrained(v string) {
	o.GresDrained = &v
}

// GetGresUsed returns the GresUsed field value if set, zero value otherwise.
func (o *V0038Node) GetGresUsed() string {
	if o == nil || IsNil(o.GresUsed) {
		var ret string
		return ret
	}
	return *o.GresUsed
}

// GetGresUsedOk returns a tuple with the GresUsed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetGresUsedOk() (*string, bool) {
	if o == nil || IsNil(o.GresUsed) {
		return nil, false
	}
	return o.GresUsed, true
}

// HasGresUsed returns a boolean if a field has been set.
func (o *V0038Node) HasGresUsed() bool {
	if o != nil && !IsNil(o.GresUsed) {
		return true
	}

	return false
}

// SetGresUsed gets a reference to the given string and assigns it to the GresUsed field.
func (o *V0038Node) SetGresUsed(v string) {
	o.GresUsed = &v
}

// GetMcsLabel returns the McsLabel field value if set, zero value otherwise.
func (o *V0038Node) GetMcsLabel() string {
	if o == nil || IsNil(o.McsLabel) {
		var ret string
		return ret
	}
	return *o.McsLabel
}

// GetMcsLabelOk returns a tuple with the McsLabel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetMcsLabelOk() (*string, bool) {
	if o == nil || IsNil(o.McsLabel) {
		return nil, false
	}
	return o.McsLabel, true
}

// HasMcsLabel returns a boolean if a field has been set.
func (o *V0038Node) HasMcsLabel() bool {
	if o != nil && !IsNil(o.McsLabel) {
		return true
	}

	return false
}

// SetMcsLabel gets a reference to the given string and assigns it to the McsLabel field.
func (o *V0038Node) SetMcsLabel(v string) {
	o.McsLabel = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *V0038Node) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *V0038Node) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *V0038Node) SetName(v string) {
	o.Name = &v
}

// GetNextStateAfterReboot returns the NextStateAfterReboot field value if set, zero value otherwise.
func (o *V0038Node) GetNextStateAfterReboot() string {
	if o == nil || IsNil(o.NextStateAfterReboot) {
		var ret string
		return ret
	}
	return *o.NextStateAfterReboot
}

// GetNextStateAfterRebootOk returns a tuple with the NextStateAfterReboot field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetNextStateAfterRebootOk() (*string, bool) {
	if o == nil || IsNil(o.NextStateAfterReboot) {
		return nil, false
	}
	return o.NextStateAfterReboot, true
}

// HasNextStateAfterReboot returns a boolean if a field has been set.
func (o *V0038Node) HasNextStateAfterReboot() bool {
	if o != nil && !IsNil(o.NextStateAfterReboot) {
		return true
	}

	return false
}

// SetNextStateAfterReboot gets a reference to the given string and assigns it to the NextStateAfterReboot field.
func (o *V0038Node) SetNextStateAfterReboot(v string) {
	o.NextStateAfterReboot = &v
}

// GetNextStateAfterRebootFlags returns the NextStateAfterRebootFlags field value if set, zero value otherwise.
func (o *V0038Node) GetNextStateAfterRebootFlags() []string {
	if o == nil || IsNil(o.NextStateAfterRebootFlags) {
		var ret []string
		return ret
	}
	return o.NextStateAfterRebootFlags
}

// GetNextStateAfterRebootFlagsOk returns a tuple with the NextStateAfterRebootFlags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetNextStateAfterRebootFlagsOk() ([]string, bool) {
	if o == nil || IsNil(o.NextStateAfterRebootFlags) {
		return nil, false
	}
	return o.NextStateAfterRebootFlags, true
}

// HasNextStateAfterRebootFlags returns a boolean if a field has been set.
func (o *V0038Node) HasNextStateAfterRebootFlags() bool {
	if o != nil && !IsNil(o.NextStateAfterRebootFlags) {
		return true
	}

	return false
}

// SetNextStateAfterRebootFlags gets a reference to the given []string and assigns it to the NextStateAfterRebootFlags field.
func (o *V0038Node) SetNextStateAfterRebootFlags(v []string) {
	o.NextStateAfterRebootFlags = v
}

// GetAddress returns the Address field value if set, zero value otherwise.
func (o *V0038Node) GetAddress() string {
	if o == nil || IsNil(o.Address) {
		var ret string
		return ret
	}
	return *o.Address
}

// GetAddressOk returns a tuple with the Address field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetAddressOk() (*string, bool) {
	if o == nil || IsNil(o.Address) {
		return nil, false
	}
	return o.Address, true
}

// HasAddress returns a boolean if a field has been set.
func (o *V0038Node) HasAddress() bool {
	if o != nil && !IsNil(o.Address) {
		return true
	}

	return false
}

// SetAddress gets a reference to the given string and assigns it to the Address field.
func (o *V0038Node) SetAddress(v string) {
	o.Address = &v
}

// GetHostname returns the Hostname field value if set, zero value otherwise.
func (o *V0038Node) GetHostname() string {
	if o == nil || IsNil(o.Hostname) {
		var ret string
		return ret
	}
	return *o.Hostname
}

// GetHostnameOk returns a tuple with the Hostname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetHostnameOk() (*string, bool) {
	if o == nil || IsNil(o.Hostname) {
		return nil, false
	}
	return o.Hostname, true
}

// HasHostname returns a boolean if a field has been set.
func (o *V0038Node) HasHostname() bool {
	if o != nil && !IsNil(o.Hostname) {
		return true
	}

	return false
}

// SetHostname gets a reference to the given string and assigns it to the Hostname field.
func (o *V0038Node) SetHostname(v string) {
	o.Hostname = &v
}

// GetState returns the State field value if set, zero value otherwise.
func (o *V0038Node) GetState() string {
	if o == nil || IsNil(o.State) {
		var ret string
		return ret
	}
	return *o.State
}

// GetStateOk returns a tuple with the State field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetStateOk() (*string, bool) {
	if o == nil || IsNil(o.State) {
		return nil, false
	}
	return o.State, true
}

// HasState returns a boolean if a field has been set.
func (o *V0038Node) HasState() bool {
	if o != nil && !IsNil(o.State) {
		return true
	}

	return false
}

// SetState gets a reference to the given string and assigns it to the State field.
func (o *V0038Node) SetState(v string) {
	o.State = &v
}

// GetStateFlags returns the StateFlags field value if set, zero value otherwise.
func (o *V0038Node) GetStateFlags() []string {
	if o == nil || IsNil(o.StateFlags) {
		var ret []string
		return ret
	}
	return o.StateFlags
}

// GetStateFlagsOk returns a tuple with the StateFlags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetStateFlagsOk() ([]string, bool) {
	if o == nil || IsNil(o.StateFlags) {
		return nil, false
	}
	return o.StateFlags, true
}

// HasStateFlags returns a boolean if a field has been set.
func (o *V0038Node) HasStateFlags() bool {
	if o != nil && !IsNil(o.StateFlags) {
		return true
	}

	return false
}

// SetStateFlags gets a reference to the given []string and assigns it to the StateFlags field.
func (o *V0038Node) SetStateFlags(v []string) {
	o.StateFlags = v
}

// GetOperatingSystem returns the OperatingSystem field value if set, zero value otherwise.
func (o *V0038Node) GetOperatingSystem() string {
	if o == nil || IsNil(o.OperatingSystem) {
		var ret string
		return ret
	}
	return *o.OperatingSystem
}

// GetOperatingSystemOk returns a tuple with the OperatingSystem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetOperatingSystemOk() (*string, bool) {
	if o == nil || IsNil(o.OperatingSystem) {
		return nil, false
	}
	return o.OperatingSystem, true
}

// HasOperatingSystem returns a boolean if a field has been set.
func (o *V0038Node) HasOperatingSystem() bool {
	if o != nil && !IsNil(o.OperatingSystem) {
		return true
	}

	return false
}

// SetOperatingSystem gets a reference to the given string and assigns it to the OperatingSystem field.
func (o *V0038Node) SetOperatingSystem(v string) {
	o.OperatingSystem = &v
}

// GetOwner returns the Owner field value if set, zero value otherwise.
func (o *V0038Node) GetOwner() string {
	if o == nil || IsNil(o.Owner) {
		var ret string
		return ret
	}
	return *o.Owner
}

// GetOwnerOk returns a tuple with the Owner field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetOwnerOk() (*string, bool) {
	if o == nil || IsNil(o.Owner) {
		return nil, false
	}
	return o.Owner, true
}

// HasOwner returns a boolean if a field has been set.
func (o *V0038Node) HasOwner() bool {
	if o != nil && !IsNil(o.Owner) {
		return true
	}

	return false
}

// SetOwner gets a reference to the given string and assigns it to the Owner field.
func (o *V0038Node) SetOwner(v string) {
	o.Owner = &v
}

// GetPartitions returns the Partitions field value if set, zero value otherwise.
func (o *V0038Node) GetPartitions() []string {
	if o == nil || IsNil(o.Partitions) {
		var ret []string
		return ret
	}
	return o.Partitions
}

// GetPartitionsOk returns a tuple with the Partitions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetPartitionsOk() ([]string, bool) {
	if o == nil || IsNil(o.Partitions) {
		return nil, false
	}
	return o.Partitions, true
}

// HasPartitions returns a boolean if a field has been set.
func (o *V0038Node) HasPartitions() bool {
	if o != nil && !IsNil(o.Partitions) {
		return true
	}

	return false
}

// SetPartitions gets a reference to the given []string and assigns it to the Partitions field.
func (o *V0038Node) SetPartitions(v []string) {
	o.Partitions = v
}

// GetPort returns the Port field value if set, zero value otherwise.
func (o *V0038Node) GetPort() int32 {
	if o == nil || IsNil(o.Port) {
		var ret int32
		return ret
	}
	return *o.Port
}

// GetPortOk returns a tuple with the Port field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetPortOk() (*int32, bool) {
	if o == nil || IsNil(o.Port) {
		return nil, false
	}
	return o.Port, true
}

// HasPort returns a boolean if a field has been set.
func (o *V0038Node) HasPort() bool {
	if o != nil && !IsNil(o.Port) {
		return true
	}

	return false
}

// SetPort gets a reference to the given int32 and assigns it to the Port field.
func (o *V0038Node) SetPort(v int32) {
	o.Port = &v
}

// GetRealMemory returns the RealMemory field value if set, zero value otherwise.
func (o *V0038Node) GetRealMemory() int32 {
	if o == nil || IsNil(o.RealMemory) {
		var ret int32
		return ret
	}
	return *o.RealMemory
}

// GetRealMemoryOk returns a tuple with the RealMemory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetRealMemoryOk() (*int32, bool) {
	if o == nil || IsNil(o.RealMemory) {
		return nil, false
	}
	return o.RealMemory, true
}

// HasRealMemory returns a boolean if a field has been set.
func (o *V0038Node) HasRealMemory() bool {
	if o != nil && !IsNil(o.RealMemory) {
		return true
	}

	return false
}

// SetRealMemory gets a reference to the given int32 and assigns it to the RealMemory field.
func (o *V0038Node) SetRealMemory(v int32) {
	o.RealMemory = &v
}

// GetReason returns the Reason field value if set, zero value otherwise.
func (o *V0038Node) GetReason() string {
	if o == nil || IsNil(o.Reason) {
		var ret string
		return ret
	}
	return *o.Reason
}

// GetReasonOk returns a tuple with the Reason field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetReasonOk() (*string, bool) {
	if o == nil || IsNil(o.Reason) {
		return nil, false
	}
	return o.Reason, true
}

// HasReason returns a boolean if a field has been set.
func (o *V0038Node) HasReason() bool {
	if o != nil && !IsNil(o.Reason) {
		return true
	}

	return false
}

// SetReason gets a reference to the given string and assigns it to the Reason field.
func (o *V0038Node) SetReason(v string) {
	o.Reason = &v
}

// GetReasonChangedAt returns the ReasonChangedAt field value if set, zero value otherwise.
func (o *V0038Node) GetReasonChangedAt() int32 {
	if o == nil || IsNil(o.ReasonChangedAt) {
		var ret int32
		return ret
	}
	return *o.ReasonChangedAt
}

// GetReasonChangedAtOk returns a tuple with the ReasonChangedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetReasonChangedAtOk() (*int32, bool) {
	if o == nil || IsNil(o.ReasonChangedAt) {
		return nil, false
	}
	return o.ReasonChangedAt, true
}

// HasReasonChangedAt returns a boolean if a field has been set.
func (o *V0038Node) HasReasonChangedAt() bool {
	if o != nil && !IsNil(o.ReasonChangedAt) {
		return true
	}

	return false
}

// SetReasonChangedAt gets a reference to the given int32 and assigns it to the ReasonChangedAt field.
func (o *V0038Node) SetReasonChangedAt(v int32) {
	o.ReasonChangedAt = &v
}

// GetReasonSetByUser returns the ReasonSetByUser field value if set, zero value otherwise.
func (o *V0038Node) GetReasonSetByUser() string {
	if o == nil || IsNil(o.ReasonSetByUser) {
		var ret string
		return ret
	}
	return *o.ReasonSetByUser
}

// GetReasonSetByUserOk returns a tuple with the ReasonSetByUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetReasonSetByUserOk() (*string, bool) {
	if o == nil || IsNil(o.ReasonSetByUser) {
		return nil, false
	}
	return o.ReasonSetByUser, true
}

// HasReasonSetByUser returns a boolean if a field has been set.
func (o *V0038Node) HasReasonSetByUser() bool {
	if o != nil && !IsNil(o.ReasonSetByUser) {
		return true
	}

	return false
}

// SetReasonSetByUser gets a reference to the given string and assigns it to the ReasonSetByUser field.
func (o *V0038Node) SetReasonSetByUser(v string) {
	o.ReasonSetByUser = &v
}

// GetSlurmdStartTime returns the SlurmdStartTime field value if set, zero value otherwise.
func (o *V0038Node) GetSlurmdStartTime() int64 {
	if o == nil || IsNil(o.SlurmdStartTime) {
		var ret int64
		return ret
	}
	return *o.SlurmdStartTime
}

// GetSlurmdStartTimeOk returns a tuple with the SlurmdStartTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetSlurmdStartTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.SlurmdStartTime) {
		return nil, false
	}
	return o.SlurmdStartTime, true
}

// HasSlurmdStartTime returns a boolean if a field has been set.
func (o *V0038Node) HasSlurmdStartTime() bool {
	if o != nil && !IsNil(o.SlurmdStartTime) {
		return true
	}

	return false
}

// SetSlurmdStartTime gets a reference to the given int64 and assigns it to the SlurmdStartTime field.
func (o *V0038Node) SetSlurmdStartTime(v int64) {
	o.SlurmdStartTime = &v
}

// GetSockets returns the Sockets field value if set, zero value otherwise.
func (o *V0038Node) GetSockets() int32 {
	if o == nil || IsNil(o.Sockets) {
		var ret int32
		return ret
	}
	return *o.Sockets
}

// GetSocketsOk returns a tuple with the Sockets field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetSocketsOk() (*int32, bool) {
	if o == nil || IsNil(o.Sockets) {
		return nil, false
	}
	return o.Sockets, true
}

// HasSockets returns a boolean if a field has been set.
func (o *V0038Node) HasSockets() bool {
	if o != nil && !IsNil(o.Sockets) {
		return true
	}

	return false
}

// SetSockets gets a reference to the given int32 and assigns it to the Sockets field.
func (o *V0038Node) SetSockets(v int32) {
	o.Sockets = &v
}

// GetThreads returns the Threads field value if set, zero value otherwise.
func (o *V0038Node) GetThreads() int32 {
	if o == nil || IsNil(o.Threads) {
		var ret int32
		return ret
	}
	return *o.Threads
}

// GetThreadsOk returns a tuple with the Threads field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetThreadsOk() (*int32, bool) {
	if o == nil || IsNil(o.Threads) {
		return nil, false
	}
	return o.Threads, true
}

// HasThreads returns a boolean if a field has been set.
func (o *V0038Node) HasThreads() bool {
	if o != nil && !IsNil(o.Threads) {
		return true
	}

	return false
}

// SetThreads gets a reference to the given int32 and assigns it to the Threads field.
func (o *V0038Node) SetThreads(v int32) {
	o.Threads = &v
}

// GetTemporaryDisk returns the TemporaryDisk field value if set, zero value otherwise.
func (o *V0038Node) GetTemporaryDisk() int32 {
	if o == nil || IsNil(o.TemporaryDisk) {
		var ret int32
		return ret
	}
	return *o.TemporaryDisk
}

// GetTemporaryDiskOk returns a tuple with the TemporaryDisk field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetTemporaryDiskOk() (*int32, bool) {
	if o == nil || IsNil(o.TemporaryDisk) {
		return nil, false
	}
	return o.TemporaryDisk, true
}

// HasTemporaryDisk returns a boolean if a field has been set.
func (o *V0038Node) HasTemporaryDisk() bool {
	if o != nil && !IsNil(o.TemporaryDisk) {
		return true
	}

	return false
}

// SetTemporaryDisk gets a reference to the given int32 and assigns it to the TemporaryDisk field.
func (o *V0038Node) SetTemporaryDisk(v int32) {
	o.TemporaryDisk = &v
}

// GetWeight returns the Weight field value if set, zero value otherwise.
func (o *V0038Node) GetWeight() int32 {
	if o == nil || IsNil(o.Weight) {
		var ret int32
		return ret
	}
	return *o.Weight
}

// GetWeightOk returns a tuple with the Weight field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetWeightOk() (*int32, bool) {
	if o == nil || IsNil(o.Weight) {
		return nil, false
	}
	return o.Weight, true
}

// HasWeight returns a boolean if a field has been set.
func (o *V0038Node) HasWeight() bool {
	if o != nil && !IsNil(o.Weight) {
		return true
	}

	return false
}

// SetWeight gets a reference to the given int32 and assigns it to the Weight field.
func (o *V0038Node) SetWeight(v int32) {
	o.Weight = &v
}

// GetTres returns the Tres field value if set, zero value otherwise.
func (o *V0038Node) GetTres() string {
	if o == nil || IsNil(o.Tres) {
		var ret string
		return ret
	}
	return *o.Tres
}

// GetTresOk returns a tuple with the Tres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetTresOk() (*string, bool) {
	if o == nil || IsNil(o.Tres) {
		return nil, false
	}
	return o.Tres, true
}

// HasTres returns a boolean if a field has been set.
func (o *V0038Node) HasTres() bool {
	if o != nil && !IsNil(o.Tres) {
		return true
	}

	return false
}

// SetTres gets a reference to the given string and assigns it to the Tres field.
func (o *V0038Node) SetTres(v string) {
	o.Tres = &v
}

// GetTresUsed returns the TresUsed field value if set, zero value otherwise.
func (o *V0038Node) GetTresUsed() string {
	if o == nil || IsNil(o.TresUsed) {
		var ret string
		return ret
	}
	return *o.TresUsed
}

// GetTresUsedOk returns a tuple with the TresUsed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetTresUsedOk() (*string, bool) {
	if o == nil || IsNil(o.TresUsed) {
		return nil, false
	}
	return o.TresUsed, true
}

// HasTresUsed returns a boolean if a field has been set.
func (o *V0038Node) HasTresUsed() bool {
	if o != nil && !IsNil(o.TresUsed) {
		return true
	}

	return false
}

// SetTresUsed gets a reference to the given string and assigns it to the TresUsed field.
func (o *V0038Node) SetTresUsed(v string) {
	o.TresUsed = &v
}

// GetTresWeighted returns the TresWeighted field value if set, zero value otherwise.
func (o *V0038Node) GetTresWeighted() float64 {
	if o == nil || IsNil(o.TresWeighted) {
		var ret float64
		return ret
	}
	return *o.TresWeighted
}

// GetTresWeightedOk returns a tuple with the TresWeighted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetTresWeightedOk() (*float64, bool) {
	if o == nil || IsNil(o.TresWeighted) {
		return nil, false
	}
	return o.TresWeighted, true
}

// HasTresWeighted returns a boolean if a field has been set.
func (o *V0038Node) HasTresWeighted() bool {
	if o != nil && !IsNil(o.TresWeighted) {
		return true
	}

	return false
}

// SetTresWeighted gets a reference to the given float64 and assigns it to the TresWeighted field.
func (o *V0038Node) SetTresWeighted(v float64) {
	o.TresWeighted = &v
}

// GetSlurmdVersion returns the SlurmdVersion field value if set, zero value otherwise.
func (o *V0038Node) GetSlurmdVersion() string {
	if o == nil || IsNil(o.SlurmdVersion) {
		var ret string
		return ret
	}
	return *o.SlurmdVersion
}

// GetSlurmdVersionOk returns a tuple with the SlurmdVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetSlurmdVersionOk() (*string, bool) {
	if o == nil || IsNil(o.SlurmdVersion) {
		return nil, false
	}
	return o.SlurmdVersion, true
}

// HasSlurmdVersion returns a boolean if a field has been set.
func (o *V0038Node) HasSlurmdVersion() bool {
	if o != nil && !IsNil(o.SlurmdVersion) {
		return true
	}

	return false
}

// SetSlurmdVersion gets a reference to the given string and assigns it to the SlurmdVersion field.
func (o *V0038Node) SetSlurmdVersion(v string) {
	o.SlurmdVersion = &v
}

// GetAllocCpus returns the AllocCpus field value if set, zero value otherwise.
func (o *V0038Node) GetAllocCpus() int64 {
	if o == nil || IsNil(o.AllocCpus) {
		var ret int64
		return ret
	}
	return *o.AllocCpus
}

// GetAllocCpusOk returns a tuple with the AllocCpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetAllocCpusOk() (*int64, bool) {
	if o == nil || IsNil(o.AllocCpus) {
		return nil, false
	}
	return o.AllocCpus, true
}

// HasAllocCpus returns a boolean if a field has been set.
func (o *V0038Node) HasAllocCpus() bool {
	if o != nil && !IsNil(o.AllocCpus) {
		return true
	}

	return false
}

// SetAllocCpus gets a reference to the given int64 and assigns it to the AllocCpus field.
func (o *V0038Node) SetAllocCpus(v int64) {
	o.AllocCpus = &v
}

// GetIdleCpus returns the IdleCpus field value if set, zero value otherwise.
func (o *V0038Node) GetIdleCpus() int64 {
	if o == nil || IsNil(o.IdleCpus) {
		var ret int64
		return ret
	}
	return *o.IdleCpus
}

// GetIdleCpusOk returns a tuple with the IdleCpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetIdleCpusOk() (*int64, bool) {
	if o == nil || IsNil(o.IdleCpus) {
		return nil, false
	}
	return o.IdleCpus, true
}

// HasIdleCpus returns a boolean if a field has been set.
func (o *V0038Node) HasIdleCpus() bool {
	if o != nil && !IsNil(o.IdleCpus) {
		return true
	}

	return false
}

// SetIdleCpus gets a reference to the given int64 and assigns it to the IdleCpus field.
func (o *V0038Node) SetIdleCpus(v int64) {
	o.IdleCpus = &v
}

// GetAllocMemory returns the AllocMemory field value if set, zero value otherwise.
func (o *V0038Node) GetAllocMemory() int64 {
	if o == nil || IsNil(o.AllocMemory) {
		var ret int64
		return ret
	}
	return *o.AllocMemory
}

// GetAllocMemoryOk returns a tuple with the AllocMemory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038Node) GetAllocMemoryOk() (*int64, bool) {
	if o == nil || IsNil(o.AllocMemory) {
		return nil, false
	}
	return o.AllocMemory, true
}

// HasAllocMemory returns a boolean if a field has been set.
func (o *V0038Node) HasAllocMemory() bool {
	if o != nil && !IsNil(o.AllocMemory) {
		return true
	}

	return false
}

// SetAllocMemory gets a reference to the given int64 and assigns it to the AllocMemory field.
func (o *V0038Node) SetAllocMemory(v int64) {
	o.AllocMemory = &v
}

func (o V0038Node) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o V0038Node) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Architecture) {
		toSerialize["architecture"] = o.Architecture
	}
	if !IsNil(o.BurstbufferNetworkAddress) {
		toSerialize["burstbuffer_network_address"] = o.BurstbufferNetworkAddress
	}
	if !IsNil(o.Boards) {
		toSerialize["boards"] = o.Boards
	}
	if !IsNil(o.BootTime) {
		toSerialize["boot_time"] = o.BootTime
	}
	if !IsNil(o.Cores) {
		toSerialize["cores"] = o.Cores
	}
	if !IsNil(o.CpuBinding) {
		toSerialize["cpu_binding"] = o.CpuBinding
	}
	if !IsNil(o.CpuLoad) {
		toSerialize["cpu_load"] = o.CpuLoad
	}
	if !IsNil(o.FreeMemory) {
		toSerialize["free_memory"] = o.FreeMemory
	}
	if !IsNil(o.Cpus) {
		toSerialize["cpus"] = o.Cpus
	}
	if !IsNil(o.Features) {
		toSerialize["features"] = o.Features
	}
	if !IsNil(o.ActiveFeatures) {
		toSerialize["active_features"] = o.ActiveFeatures
	}
	if !IsNil(o.Gres) {
		toSerialize["gres"] = o.Gres
	}
	if !IsNil(o.GresDrained) {
		toSerialize["gres_drained"] = o.GresDrained
	}
	if !IsNil(o.GresUsed) {
		toSerialize["gres_used"] = o.GresUsed
	}
	if !IsNil(o.McsLabel) {
		toSerialize["mcs_label"] = o.McsLabel
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.NextStateAfterReboot) {
		toSerialize["next_state_after_reboot"] = o.NextStateAfterReboot
	}
	if !IsNil(o.NextStateAfterRebootFlags) {
		toSerialize["next_state_after_reboot_flags"] = o.NextStateAfterRebootFlags
	}
	if !IsNil(o.Address) {
		toSerialize["address"] = o.Address
	}
	if !IsNil(o.Hostname) {
		toSerialize["hostname"] = o.Hostname
	}
	if !IsNil(o.State) {
		toSerialize["state"] = o.State
	}
	if !IsNil(o.StateFlags) {
		toSerialize["state_flags"] = o.StateFlags
	}
	if !IsNil(o.OperatingSystem) {
		toSerialize["operating_system"] = o.OperatingSystem
	}
	if !IsNil(o.Owner) {
		toSerialize["owner"] = o.Owner
	}
	if !IsNil(o.Partitions) {
		toSerialize["partitions"] = o.Partitions
	}
	if !IsNil(o.Port) {
		toSerialize["port"] = o.Port
	}
	if !IsNil(o.RealMemory) {
		toSerialize["real_memory"] = o.RealMemory
	}
	if !IsNil(o.Reason) {
		toSerialize["reason"] = o.Reason
	}
	if !IsNil(o.ReasonChangedAt) {
		toSerialize["reason_changed_at"] = o.ReasonChangedAt
	}
	if !IsNil(o.ReasonSetByUser) {
		toSerialize["reason_set_by_user"] = o.ReasonSetByUser
	}
	if !IsNil(o.SlurmdStartTime) {
		toSerialize["slurmd_start_time"] = o.SlurmdStartTime
	}
	if !IsNil(o.Sockets) {
		toSerialize["sockets"] = o.Sockets
	}
	if !IsNil(o.Threads) {
		toSerialize["threads"] = o.Threads
	}
	if !IsNil(o.TemporaryDisk) {
		toSerialize["temporary_disk"] = o.TemporaryDisk
	}
	if !IsNil(o.Weight) {
		toSerialize["weight"] = o.Weight
	}
	if !IsNil(o.Tres) {
		toSerialize["tres"] = o.Tres
	}
	if !IsNil(o.TresUsed) {
		toSerialize["tres_used"] = o.TresUsed
	}
	if !IsNil(o.TresWeighted) {
		toSerialize["tres_weighted"] = o.TresWeighted
	}
	if !IsNil(o.SlurmdVersion) {
		toSerialize["slurmd_version"] = o.SlurmdVersion
	}
	if !IsNil(o.AllocCpus) {
		toSerialize["alloc_cpus"] = o.AllocCpus
	}
	if !IsNil(o.IdleCpus) {
		toSerialize["idle_cpus"] = o.IdleCpus
	}
	if !IsNil(o.AllocMemory) {
		toSerialize["alloc_memory"] = o.AllocMemory
	}
	return toSerialize, nil
}

type NullableV0038Node struct {
	value *V0038Node
	isSet bool
}

func (v NullableV0038Node) Get() *V0038Node {
	return v.value
}

func (v *NullableV0038Node) Set(val *V0038Node) {
	v.value = val
	v.isSet = true
}

func (v NullableV0038Node) IsSet() bool {
	return v.isSet
}

func (v *NullableV0038Node) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableV0038Node(val *V0038Node) *NullableV0038Node {
	return &NullableV0038Node{value: val, isSet: true}
}

func (v NullableV0038Node) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableV0038Node) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


