// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

package websecurityscannerpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WebSecurityScanner_CreateScanConfig_FullMethodName     = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/CreateScanConfig"
	WebSecurityScanner_DeleteScanConfig_FullMethodName     = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/DeleteScanConfig"
	WebSecurityScanner_GetScanConfig_FullMethodName        = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/GetScanConfig"
	WebSecurityScanner_ListScanConfigs_FullMethodName      = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/ListScanConfigs"
	WebSecurityScanner_UpdateScanConfig_FullMethodName     = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/UpdateScanConfig"
	WebSecurityScanner_StartScanRun_FullMethodName         = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/StartScanRun"
	WebSecurityScanner_GetScanRun_FullMethodName           = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/GetScanRun"
	WebSecurityScanner_ListScanRuns_FullMethodName         = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/ListScanRuns"
	WebSecurityScanner_StopScanRun_FullMethodName          = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/StopScanRun"
	WebSecurityScanner_ListCrawledUrls_FullMethodName      = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/ListCrawledUrls"
	WebSecurityScanner_GetFinding_FullMethodName           = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/GetFinding"
	WebSecurityScanner_ListFindings_FullMethodName         = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/ListFindings"
	WebSecurityScanner_ListFindingTypeStats_FullMethodName = "/google.cloud.websecurityscanner.v1.WebSecurityScanner/ListFindingTypeStats"
)

// WebSecurityScannerClient is the client API for WebSecurityScanner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebSecurityScannerClient interface {
	// Creates a new ScanConfig.
	CreateScanConfig(ctx context.Context, in *CreateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
	// Deletes an existing ScanConfig and its child resources.
	DeleteScanConfig(ctx context.Context, in *DeleteScanConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a ScanConfig.
	GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
	// Lists ScanConfigs under a given project.
	ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error)
	// Updates a ScanConfig. This method support partial update of a ScanConfig.
	UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error)
	// Start a ScanRun according to the given ScanConfig.
	StartScanRun(ctx context.Context, in *StartScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error)
	// Gets a ScanRun.
	GetScanRun(ctx context.Context, in *GetScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error)
	// Lists ScanRuns under a given ScanConfig, in descending order of ScanRun
	// stop time.
	ListScanRuns(ctx context.Context, in *ListScanRunsRequest, opts ...grpc.CallOption) (*ListScanRunsResponse, error)
	// Stops a ScanRun. The stopped ScanRun is returned.
	StopScanRun(ctx context.Context, in *StopScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error)
	// List CrawledUrls under a given ScanRun.
	ListCrawledUrls(ctx context.Context, in *ListCrawledUrlsRequest, opts ...grpc.CallOption) (*ListCrawledUrlsResponse, error)
	// Gets a Finding.
	GetFinding(ctx context.Context, in *GetFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// List Findings under a given ScanRun.
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// List all FindingTypeStats under a given ScanRun.
	ListFindingTypeStats(ctx context.Context, in *ListFindingTypeStatsRequest, opts ...grpc.CallOption) (*ListFindingTypeStatsResponse, error)
}

type webSecurityScannerClient struct {
	cc grpc.ClientConnInterface
}

func NewWebSecurityScannerClient(cc grpc.ClientConnInterface) WebSecurityScannerClient {
	return &webSecurityScannerClient{cc}
}

func (c *webSecurityScannerClient) CreateScanConfig(ctx context.Context, in *CreateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := c.cc.Invoke(ctx, WebSecurityScanner_CreateScanConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) DeleteScanConfig(ctx context.Context, in *DeleteScanConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, WebSecurityScanner_DeleteScanConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) GetScanConfig(ctx context.Context, in *GetScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := c.cc.Invoke(ctx, WebSecurityScanner_GetScanConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) ListScanConfigs(ctx context.Context, in *ListScanConfigsRequest, opts ...grpc.CallOption) (*ListScanConfigsResponse, error) {
	out := new(ListScanConfigsResponse)
	err := c.cc.Invoke(ctx, WebSecurityScanner_ListScanConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) UpdateScanConfig(ctx context.Context, in *UpdateScanConfigRequest, opts ...grpc.CallOption) (*ScanConfig, error) {
	out := new(ScanConfig)
	err := c.cc.Invoke(ctx, WebSecurityScanner_UpdateScanConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) StartScanRun(ctx context.Context, in *StartScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error) {
	out := new(ScanRun)
	err := c.cc.Invoke(ctx, WebSecurityScanner_StartScanRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) GetScanRun(ctx context.Context, in *GetScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error) {
	out := new(ScanRun)
	err := c.cc.Invoke(ctx, WebSecurityScanner_GetScanRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) ListScanRuns(ctx context.Context, in *ListScanRunsRequest, opts ...grpc.CallOption) (*ListScanRunsResponse, error) {
	out := new(ListScanRunsResponse)
	err := c.cc.Invoke(ctx, WebSecurityScanner_ListScanRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) StopScanRun(ctx context.Context, in *StopScanRunRequest, opts ...grpc.CallOption) (*ScanRun, error) {
	out := new(ScanRun)
	err := c.cc.Invoke(ctx, WebSecurityScanner_StopScanRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) ListCrawledUrls(ctx context.Context, in *ListCrawledUrlsRequest, opts ...grpc.CallOption) (*ListCrawledUrlsResponse, error) {
	out := new(ListCrawledUrlsResponse)
	err := c.cc.Invoke(ctx, WebSecurityScanner_ListCrawledUrls_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) GetFinding(ctx context.Context, in *GetFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, WebSecurityScanner_GetFinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, WebSecurityScanner_ListFindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webSecurityScannerClient) ListFindingTypeStats(ctx context.Context, in *ListFindingTypeStatsRequest, opts ...grpc.CallOption) (*ListFindingTypeStatsResponse, error) {
	out := new(ListFindingTypeStatsResponse)
	err := c.cc.Invoke(ctx, WebSecurityScanner_ListFindingTypeStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebSecurityScannerServer is the server API for WebSecurityScanner service.
// All implementations should embed UnimplementedWebSecurityScannerServer
// for forward compatibility
type WebSecurityScannerServer interface {
	// Creates a new ScanConfig.
	CreateScanConfig(context.Context, *CreateScanConfigRequest) (*ScanConfig, error)
	// Deletes an existing ScanConfig and its child resources.
	DeleteScanConfig(context.Context, *DeleteScanConfigRequest) (*emptypb.Empty, error)
	// Gets a ScanConfig.
	GetScanConfig(context.Context, *GetScanConfigRequest) (*ScanConfig, error)
	// Lists ScanConfigs under a given project.
	ListScanConfigs(context.Context, *ListScanConfigsRequest) (*ListScanConfigsResponse, error)
	// Updates a ScanConfig. This method support partial update of a ScanConfig.
	UpdateScanConfig(context.Context, *UpdateScanConfigRequest) (*ScanConfig, error)
	// Start a ScanRun according to the given ScanConfig.
	StartScanRun(context.Context, *StartScanRunRequest) (*ScanRun, error)
	// Gets a ScanRun.
	GetScanRun(context.Context, *GetScanRunRequest) (*ScanRun, error)
	// Lists ScanRuns under a given ScanConfig, in descending order of ScanRun
	// stop time.
	ListScanRuns(context.Context, *ListScanRunsRequest) (*ListScanRunsResponse, error)
	// Stops a ScanRun. The stopped ScanRun is returned.
	StopScanRun(context.Context, *StopScanRunRequest) (*ScanRun, error)
	// List CrawledUrls under a given ScanRun.
	ListCrawledUrls(context.Context, *ListCrawledUrlsRequest) (*ListCrawledUrlsResponse, error)
	// Gets a Finding.
	GetFinding(context.Context, *GetFindingRequest) (*Finding, error)
	// List Findings under a given ScanRun.
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// List all FindingTypeStats under a given ScanRun.
	ListFindingTypeStats(context.Context, *ListFindingTypeStatsRequest) (*ListFindingTypeStatsResponse, error)
}

// UnimplementedWebSecurityScannerServer should be embedded to have forward compatible implementations.
type UnimplementedWebSecurityScannerServer struct {
}

func (UnimplementedWebSecurityScannerServer) CreateScanConfig(context.Context, *CreateScanConfigRequest) (*ScanConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateScanConfig not implemented")
}
func (UnimplementedWebSecurityScannerServer) DeleteScanConfig(context.Context, *DeleteScanConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteScanConfig not implemented")
}
func (UnimplementedWebSecurityScannerServer) GetScanConfig(context.Context, *GetScanConfigRequest) (*ScanConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetScanConfig not implemented")
}
func (UnimplementedWebSecurityScannerServer) ListScanConfigs(context.Context, *ListScanConfigsRequest) (*ListScanConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListScanConfigs not implemented")
}
func (UnimplementedWebSecurityScannerServer) UpdateScanConfig(context.Context, *UpdateScanConfigRequest) (*ScanConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateScanConfig not implemented")
}
func (UnimplementedWebSecurityScannerServer) StartScanRun(context.Context, *StartScanRunRequest) (*ScanRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartScanRun not implemented")
}
func (UnimplementedWebSecurityScannerServer) GetScanRun(context.Context, *GetScanRunRequest) (*ScanRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetScanRun not implemented")
}
func (UnimplementedWebSecurityScannerServer) ListScanRuns(context.Context, *ListScanRunsRequest) (*ListScanRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListScanRuns not implemented")
}
func (UnimplementedWebSecurityScannerServer) StopScanRun(context.Context, *StopScanRunRequest) (*ScanRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopScanRun not implemented")
}
func (UnimplementedWebSecurityScannerServer) ListCrawledUrls(context.Context, *ListCrawledUrlsRequest) (*ListCrawledUrlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCrawledUrls not implemented")
}
func (UnimplementedWebSecurityScannerServer) GetFinding(context.Context, *GetFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFinding not implemented")
}
func (UnimplementedWebSecurityScannerServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (UnimplementedWebSecurityScannerServer) ListFindingTypeStats(context.Context, *ListFindingTypeStatsRequest) (*ListFindingTypeStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindingTypeStats not implemented")
}

// UnsafeWebSecurityScannerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebSecurityScannerServer will
// result in compilation errors.
type UnsafeWebSecurityScannerServer interface {
	mustEmbedUnimplementedWebSecurityScannerServer()
}

func RegisterWebSecurityScannerServer(s grpc.ServiceRegistrar, srv WebSecurityScannerServer) {
	s.RegisterService(&WebSecurityScanner_ServiceDesc, srv)
}

func _WebSecurityScanner_CreateScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).CreateScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_CreateScanConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).CreateScanConfig(ctx, req.(*CreateScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_DeleteScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).DeleteScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_DeleteScanConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).DeleteScanConfig(ctx, req.(*DeleteScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_GetScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).GetScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_GetScanConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).GetScanConfig(ctx, req.(*GetScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_ListScanConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScanConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).ListScanConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_ListScanConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).ListScanConfigs(ctx, req.(*ListScanConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_UpdateScanConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateScanConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).UpdateScanConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_UpdateScanConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).UpdateScanConfig(ctx, req.(*UpdateScanConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_StartScanRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartScanRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).StartScanRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_StartScanRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).StartScanRun(ctx, req.(*StartScanRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_GetScanRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScanRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).GetScanRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_GetScanRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).GetScanRun(ctx, req.(*GetScanRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_ListScanRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScanRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).ListScanRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_ListScanRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).ListScanRuns(ctx, req.(*ListScanRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_StopScanRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopScanRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).StopScanRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_StopScanRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).StopScanRun(ctx, req.(*StopScanRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_ListCrawledUrls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCrawledUrlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).ListCrawledUrls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_ListCrawledUrls_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).ListCrawledUrls(ctx, req.(*ListCrawledUrlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_GetFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).GetFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_GetFinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).GetFinding(ctx, req.(*GetFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_ListFindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebSecurityScanner_ListFindingTypeStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingTypeStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebSecurityScannerServer).ListFindingTypeStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebSecurityScanner_ListFindingTypeStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebSecurityScannerServer).ListFindingTypeStats(ctx, req.(*ListFindingTypeStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WebSecurityScanner_ServiceDesc is the grpc.ServiceDesc for WebSecurityScanner service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WebSecurityScanner_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.websecurityscanner.v1.WebSecurityScanner",
	HandlerType: (*WebSecurityScannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateScanConfig",
			Handler:    _WebSecurityScanner_CreateScanConfig_Handler,
		},
		{
			MethodName: "DeleteScanConfig",
			Handler:    _WebSecurityScanner_DeleteScanConfig_Handler,
		},
		{
			MethodName: "GetScanConfig",
			Handler:    _WebSecurityScanner_GetScanConfig_Handler,
		},
		{
			MethodName: "ListScanConfigs",
			Handler:    _WebSecurityScanner_ListScanConfigs_Handler,
		},
		{
			MethodName: "UpdateScanConfig",
			Handler:    _WebSecurityScanner_UpdateScanConfig_Handler,
		},
		{
			MethodName: "StartScanRun",
			Handler:    _WebSecurityScanner_StartScanRun_Handler,
		},
		{
			MethodName: "GetScanRun",
			Handler:    _WebSecurityScanner_GetScanRun_Handler,
		},
		{
			MethodName: "ListScanRuns",
			Handler:    _WebSecurityScanner_ListScanRuns_Handler,
		},
		{
			MethodName: "StopScanRun",
			Handler:    _WebSecurityScanner_StopScanRun_Handler,
		},
		{
			MethodName: "ListCrawledUrls",
			Handler:    _WebSecurityScanner_ListCrawledUrls_Handler,
		},
		{
			MethodName: "GetFinding",
			Handler:    _WebSecurityScanner_GetFinding_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _WebSecurityScanner_ListFindings_Handler,
		},
		{
			MethodName: "ListFindingTypeStats",
			Handler:    _WebSecurityScanner_ListFindingTypeStats_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/websecurityscanner/v1/web_security_scanner.proto",
}
