// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: jwt_rsa_ssa_pss.proto

package jwt_rsa_ssa_pss_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// See https://datatracker.ietf.org/doc/html/rfc7518#section-3.5
type JwtRsaSsaPssAlgorithm int32

const (
	JwtRsaSsaPssAlgorithm_PS_UNKNOWN JwtRsaSsaPssAlgorithm = 0
	JwtRsaSsaPssAlgorithm_PS256      JwtRsaSsaPssAlgorithm = 1 // RSASSA-PSS using SHA-256 and MGF1 with SHA-256
	JwtRsaSsaPssAlgorithm_PS384      JwtRsaSsaPssAlgorithm = 2 // RSASSA-PSS using SHA-384 and MGF1 with SHA-384
	JwtRsaSsaPssAlgorithm_PS512      JwtRsaSsaPssAlgorithm = 3 // RSASSA-PSS using SHA-512 and MGF1 with SHA-512
)

// Enum value maps for JwtRsaSsaPssAlgorithm.
var (
	JwtRsaSsaPssAlgorithm_name = map[int32]string{
		0: "PS_UNKNOWN",
		1: "PS256",
		2: "PS384",
		3: "PS512",
	}
	JwtRsaSsaPssAlgorithm_value = map[string]int32{
		"PS_UNKNOWN": 0,
		"PS256":      1,
		"PS384":      2,
		"PS512":      3,
	}
)

func (x JwtRsaSsaPssAlgorithm) Enum() *JwtRsaSsaPssAlgorithm {
	p := new(JwtRsaSsaPssAlgorithm)
	*p = x
	return p
}

func (x JwtRsaSsaPssAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JwtRsaSsaPssAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_jwt_rsa_ssa_pss_proto_enumTypes[0].Descriptor()
}

func (JwtRsaSsaPssAlgorithm) Type() protoreflect.EnumType {
	return &file_jwt_rsa_ssa_pss_proto_enumTypes[0]
}

func (x JwtRsaSsaPssAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JwtRsaSsaPssAlgorithm.Descriptor instead.
func (JwtRsaSsaPssAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_jwt_rsa_ssa_pss_proto_rawDescGZIP(), []int{0}
}

// key_type: type.googleapis.com/google.crypto.tink.JwtRsaSsaPssPublicKey
type JwtRsaSsaPssPublicKey struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Version   uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm JwtRsaSsaPssAlgorithm  `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtRsaSsaPssAlgorithm" json:"algorithm,omitempty"`
	// Modulus.
	// Unsigned big integer in big-endian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in big-endian representation.
	E             []byte                           `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
	CustomKid     *JwtRsaSsaPssPublicKey_CustomKid `protobuf:"bytes,5,opt,name=custom_kid,json=customKid,proto3" json:"custom_kid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtRsaSsaPssPublicKey) Reset() {
	*x = JwtRsaSsaPssPublicKey{}
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtRsaSsaPssPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPssPublicKey) ProtoMessage() {}

func (x *JwtRsaSsaPssPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPssPublicKey.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPssPublicKey) Descriptor() ([]byte, []int) {
	return file_jwt_rsa_ssa_pss_proto_rawDescGZIP(), []int{0}
}

func (x *JwtRsaSsaPssPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPssPublicKey) GetAlgorithm() JwtRsaSsaPssAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtRsaSsaPssAlgorithm_PS_UNKNOWN
}

func (x *JwtRsaSsaPssPublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *JwtRsaSsaPssPublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

func (x *JwtRsaSsaPssPublicKey) GetCustomKid() *JwtRsaSsaPssPublicKey_CustomKid {
	if x != nil {
		return x.CustomKid
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.JwtRsaSsaPssPrivateKey
type JwtRsaSsaPssPrivateKey struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Version   uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	PublicKey *JwtRsaSsaPssPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in big-endian representation.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in big-endian representation.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in big-endian representation.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in big-endian representation.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in big-endian representation.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in big-endian representation.
	Crt           []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtRsaSsaPssPrivateKey) Reset() {
	*x = JwtRsaSsaPssPrivateKey{}
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtRsaSsaPssPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPssPrivateKey) ProtoMessage() {}

func (x *JwtRsaSsaPssPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPssPrivateKey.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPssPrivateKey) Descriptor() ([]byte, []int) {
	return file_jwt_rsa_ssa_pss_proto_rawDescGZIP(), []int{1}
}

func (x *JwtRsaSsaPssPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPssPrivateKey) GetPublicKey() *JwtRsaSsaPssPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *JwtRsaSsaPssPrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type JwtRsaSsaPssKeyFormat struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Version           uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm         JwtRsaSsaPssAlgorithm  `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtRsaSsaPssAlgorithm" json:"algorithm,omitempty"`
	ModulusSizeInBits uint32                 `protobuf:"varint,3,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	PublicExponent    []byte                 `protobuf:"bytes,4,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *JwtRsaSsaPssKeyFormat) Reset() {
	*x = JwtRsaSsaPssKeyFormat{}
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtRsaSsaPssKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPssKeyFormat) ProtoMessage() {}

func (x *JwtRsaSsaPssKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPssKeyFormat.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPssKeyFormat) Descriptor() ([]byte, []int) {
	return file_jwt_rsa_ssa_pss_proto_rawDescGZIP(), []int{2}
}

func (x *JwtRsaSsaPssKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPssKeyFormat) GetAlgorithm() JwtRsaSsaPssAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtRsaSsaPssAlgorithm_PS_UNKNOWN
}

func (x *JwtRsaSsaPssKeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *JwtRsaSsaPssKeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

// Optional, custom kid header value to be used with "RAW" keys.
// "TINK" keys with this value set will be rejected.
type JwtRsaSsaPssPublicKey_CustomKid struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         string                 `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtRsaSsaPssPublicKey_CustomKid) Reset() {
	*x = JwtRsaSsaPssPublicKey_CustomKid{}
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtRsaSsaPssPublicKey_CustomKid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPssPublicKey_CustomKid) ProtoMessage() {}

func (x *JwtRsaSsaPssPublicKey_CustomKid) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_rsa_ssa_pss_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPssPublicKey_CustomKid.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPssPublicKey_CustomKid) Descriptor() ([]byte, []int) {
	return file_jwt_rsa_ssa_pss_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtRsaSsaPssPublicKey_CustomKid) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_jwt_rsa_ssa_pss_proto protoreflect.FileDescriptor

const file_jwt_rsa_ssa_pss_proto_rawDesc = "" +
	"\n" +
	"\x15jwt_rsa_ssa_pss.proto\x12\x12google.crypto.tink\"\x8d\x02\n" +
	"\x15JwtRsaSsaPssPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12G\n" +
	"\talgorithm\x18\x02 \x01(\x0e2).google.crypto.tink.JwtRsaSsaPssAlgorithmR\talgorithm\x12\f\n" +
	"\x01n\x18\x03 \x01(\fR\x01n\x12\f\n" +
	"\x01e\x18\x04 \x01(\fR\x01e\x12R\n" +
	"\n" +
	"custom_kid\x18\x05 \x01(\v23.google.crypto.tink.JwtRsaSsaPssPublicKey.CustomKidR\tcustomKid\x1a!\n" +
	"\tCustomKid\x12\x14\n" +
	"\x05value\x18\x01 \x01(\tR\x05value\"\xd8\x01\n" +
	"\x16JwtRsaSsaPssPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12H\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2).google.crypto.tink.JwtRsaSsaPssPublicKeyR\tpublicKey\x12\f\n" +
	"\x01d\x18\x03 \x01(\fR\x01d\x12\f\n" +
	"\x01p\x18\x04 \x01(\fR\x01p\x12\f\n" +
	"\x01q\x18\x05 \x01(\fR\x01q\x12\x0e\n" +
	"\x02dp\x18\x06 \x01(\fR\x02dp\x12\x0e\n" +
	"\x02dq\x18\a \x01(\fR\x02dq\x12\x10\n" +
	"\x03crt\x18\b \x01(\fR\x03crt\"\xd4\x01\n" +
	"\x15JwtRsaSsaPssKeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12G\n" +
	"\talgorithm\x18\x02 \x01(\x0e2).google.crypto.tink.JwtRsaSsaPssAlgorithmR\talgorithm\x12/\n" +
	"\x14modulus_size_in_bits\x18\x03 \x01(\rR\x11modulusSizeInBits\x12'\n" +
	"\x0fpublic_exponent\x18\x04 \x01(\fR\x0epublicExponent*H\n" +
	"\x15JwtRsaSsaPssAlgorithm\x12\x0e\n" +
	"\n" +
	"PS_UNKNOWN\x10\x00\x12\t\n" +
	"\x05PS256\x10\x01\x12\t\n" +
	"\x05PS384\x10\x02\x12\t\n" +
	"\x05PS512\x10\x03Bb\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z@github.com/tink-crypto/tink-go/v2/proto/jwt_rsa_ssa_pss_go_protob\x06proto3"

var (
	file_jwt_rsa_ssa_pss_proto_rawDescOnce sync.Once
	file_jwt_rsa_ssa_pss_proto_rawDescData []byte
)

func file_jwt_rsa_ssa_pss_proto_rawDescGZIP() []byte {
	file_jwt_rsa_ssa_pss_proto_rawDescOnce.Do(func() {
		file_jwt_rsa_ssa_pss_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_jwt_rsa_ssa_pss_proto_rawDesc), len(file_jwt_rsa_ssa_pss_proto_rawDesc)))
	})
	return file_jwt_rsa_ssa_pss_proto_rawDescData
}

var file_jwt_rsa_ssa_pss_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_jwt_rsa_ssa_pss_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_jwt_rsa_ssa_pss_proto_goTypes = []any{
	(JwtRsaSsaPssAlgorithm)(0),              // 0: google.crypto.tink.JwtRsaSsaPssAlgorithm
	(*JwtRsaSsaPssPublicKey)(nil),           // 1: google.crypto.tink.JwtRsaSsaPssPublicKey
	(*JwtRsaSsaPssPrivateKey)(nil),          // 2: google.crypto.tink.JwtRsaSsaPssPrivateKey
	(*JwtRsaSsaPssKeyFormat)(nil),           // 3: google.crypto.tink.JwtRsaSsaPssKeyFormat
	(*JwtRsaSsaPssPublicKey_CustomKid)(nil), // 4: google.crypto.tink.JwtRsaSsaPssPublicKey.CustomKid
}
var file_jwt_rsa_ssa_pss_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.JwtRsaSsaPssPublicKey.algorithm:type_name -> google.crypto.tink.JwtRsaSsaPssAlgorithm
	4, // 1: google.crypto.tink.JwtRsaSsaPssPublicKey.custom_kid:type_name -> google.crypto.tink.JwtRsaSsaPssPublicKey.CustomKid
	1, // 2: google.crypto.tink.JwtRsaSsaPssPrivateKey.public_key:type_name -> google.crypto.tink.JwtRsaSsaPssPublicKey
	0, // 3: google.crypto.tink.JwtRsaSsaPssKeyFormat.algorithm:type_name -> google.crypto.tink.JwtRsaSsaPssAlgorithm
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_jwt_rsa_ssa_pss_proto_init() }
func file_jwt_rsa_ssa_pss_proto_init() {
	if File_jwt_rsa_ssa_pss_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_jwt_rsa_ssa_pss_proto_rawDesc), len(file_jwt_rsa_ssa_pss_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_jwt_rsa_ssa_pss_proto_goTypes,
		DependencyIndexes: file_jwt_rsa_ssa_pss_proto_depIdxs,
		EnumInfos:         file_jwt_rsa_ssa_pss_proto_enumTypes,
		MessageInfos:      file_jwt_rsa_ssa_pss_proto_msgTypes,
	}.Build()
	File_jwt_rsa_ssa_pss_proto = out.File
	file_jwt_rsa_ssa_pss_proto_goTypes = nil
	file_jwt_rsa_ssa_pss_proto_depIdxs = nil
}
