// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/vision/v1/product_search_service.proto

package visionpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ProductSearch_CreateProductSet_FullMethodName            = "/google.cloud.vision.v1.ProductSearch/CreateProductSet"
	ProductSearch_ListProductSets_FullMethodName             = "/google.cloud.vision.v1.ProductSearch/ListProductSets"
	ProductSearch_GetProductSet_FullMethodName               = "/google.cloud.vision.v1.ProductSearch/GetProductSet"
	ProductSearch_UpdateProductSet_FullMethodName            = "/google.cloud.vision.v1.ProductSearch/UpdateProductSet"
	ProductSearch_DeleteProductSet_FullMethodName            = "/google.cloud.vision.v1.ProductSearch/DeleteProductSet"
	ProductSearch_CreateProduct_FullMethodName               = "/google.cloud.vision.v1.ProductSearch/CreateProduct"
	ProductSearch_ListProducts_FullMethodName                = "/google.cloud.vision.v1.ProductSearch/ListProducts"
	ProductSearch_GetProduct_FullMethodName                  = "/google.cloud.vision.v1.ProductSearch/GetProduct"
	ProductSearch_UpdateProduct_FullMethodName               = "/google.cloud.vision.v1.ProductSearch/UpdateProduct"
	ProductSearch_DeleteProduct_FullMethodName               = "/google.cloud.vision.v1.ProductSearch/DeleteProduct"
	ProductSearch_CreateReferenceImage_FullMethodName        = "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage"
	ProductSearch_DeleteReferenceImage_FullMethodName        = "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage"
	ProductSearch_ListReferenceImages_FullMethodName         = "/google.cloud.vision.v1.ProductSearch/ListReferenceImages"
	ProductSearch_GetReferenceImage_FullMethodName           = "/google.cloud.vision.v1.ProductSearch/GetReferenceImage"
	ProductSearch_AddProductToProductSet_FullMethodName      = "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet"
	ProductSearch_RemoveProductFromProductSet_FullMethodName = "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet"
	ProductSearch_ListProductsInProductSet_FullMethodName    = "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet"
	ProductSearch_ImportProductSets_FullMethodName           = "/google.cloud.vision.v1.ProductSearch/ImportProductSets"
	ProductSearch_PurgeProducts_FullMethodName               = "/google.cloud.vision.v1.ProductSearch/PurgeProducts"
)

// ProductSearchClient is the client API for ProductSearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ProductSearchClient interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//     4096 characters.
	CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//     than 1.
	ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the ProductSet does not exist.
	//   - Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//     missing from the request or longer than 4096 characters.
	UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//     characters.
	//   - Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the Product does not exist.
	//   - Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//     missing from the request or longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if description is present in update_mask but is
	//     longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//     characters.
	//   - Returns INVALID_ARGUMENT if the product does not exist.
	//   - Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//     compatible with the parent product's product_category is detected.
	//   - Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the parent product does not exist.
	//   - Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//     than 1.
	ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type productSearchClient struct {
	cc grpc.ClientConnInterface
}

func NewProductSearchClient(cc grpc.ClientConnInterface) ProductSearchClient {
	return &productSearchClient{cc}
}

func (c *productSearchClient) CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, ProductSearch_CreateProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error) {
	out := new(ListProductSetsResponse)
	err := c.cc.Invoke(ctx, ProductSearch_ListProductSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, ProductSearch_GetProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, ProductSearch_UpdateProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductSearch_DeleteProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductSearch_CreateProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, ProductSearch_ListProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductSearch_GetProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductSearch_UpdateProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductSearch_DeleteProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, ProductSearch_CreateReferenceImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductSearch_DeleteReferenceImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error) {
	out := new(ListReferenceImagesResponse)
	err := c.cc.Invoke(ctx, ProductSearch_ListReferenceImages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, ProductSearch_GetReferenceImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductSearch_AddProductToProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductSearch_RemoveProductFromProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error) {
	out := new(ListProductsInProductSetResponse)
	err := c.cc.Invoke(ctx, ProductSearch_ListProductsInProductSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductSearch_ImportProductSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductSearch_PurgeProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductSearchServer is the server API for ProductSearch service.
// All implementations should embed UnimplementedProductSearchServer
// for forward compatibility
type ProductSearchServer interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//     4096 characters.
	CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//     than 1.
	ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the ProductSet does not exist.
	//   - Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//     missing from the request or longer than 4096 characters.
	UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(context.Context, *DeleteProductSetRequest) (*emptypb.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//     characters.
	//   - Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the Product does not exist.
	//   - Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//     missing from the request or longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if description is present in update_mask but is
	//     longer than 4096 characters.
	//   - Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	//   - Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//     characters.
	//   - Returns INVALID_ARGUMENT if the product does not exist.
	//   - Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//     compatible with the parent product's product_category is detected.
	//   - Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*emptypb.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	//   - Returns NOT_FOUND if the parent product does not exist.
	//   - Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//     than 1.
	ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*emptypb.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*emptypb.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunningpb.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be
	// used to keep track of the progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedProductSearchServer should be embedded to have forward compatible implementations.
type UnimplementedProductSearchServer struct {
}

func (UnimplementedProductSearchServer) CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProductSet not implemented")
}
func (UnimplementedProductSearchServer) ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProductSets not implemented")
}
func (UnimplementedProductSearchServer) GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProductSet not implemented")
}
func (UnimplementedProductSearchServer) UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProductSet not implemented")
}
func (UnimplementedProductSearchServer) DeleteProductSet(context.Context, *DeleteProductSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProductSet not implemented")
}
func (UnimplementedProductSearchServer) CreateProduct(context.Context, *CreateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProduct not implemented")
}
func (UnimplementedProductSearchServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (UnimplementedProductSearchServer) GetProduct(context.Context, *GetProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProduct not implemented")
}
func (UnimplementedProductSearchServer) UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProduct not implemented")
}
func (UnimplementedProductSearchServer) DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProduct not implemented")
}
func (UnimplementedProductSearchServer) CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReferenceImage not implemented")
}
func (UnimplementedProductSearchServer) DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReferenceImage not implemented")
}
func (UnimplementedProductSearchServer) ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReferenceImages not implemented")
}
func (UnimplementedProductSearchServer) GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReferenceImage not implemented")
}
func (UnimplementedProductSearchServer) AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddProductToProductSet not implemented")
}
func (UnimplementedProductSearchServer) RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveProductFromProductSet not implemented")
}
func (UnimplementedProductSearchServer) ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProductsInProductSet not implemented")
}
func (UnimplementedProductSearchServer) ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportProductSets not implemented")
}
func (UnimplementedProductSearchServer) PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeProducts not implemented")
}

// UnsafeProductSearchServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ProductSearchServer will
// result in compilation errors.
type UnsafeProductSearchServer interface {
	mustEmbedUnimplementedProductSearchServer()
}

func RegisterProductSearchServer(s grpc.ServiceRegistrar, srv ProductSearchServer) {
	s.RegisterService(&ProductSearch_ServiceDesc, srv)
}

func _ProductSearch_CreateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_CreateProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProductSet(ctx, req.(*CreateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_ListProductSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductSets(ctx, req.(*ListProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_GetProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProductSet(ctx, req.(*GetProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_UpdateProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, req.(*UpdateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_DeleteProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, req.(*DeleteProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_CreateProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_ListProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_GetProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_UpdateProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_DeleteProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_CreateReferenceImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, req.(*CreateReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_DeleteReferenceImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, req.(*DeleteReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListReferenceImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReferenceImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_ListReferenceImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, req.(*ListReferenceImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_GetReferenceImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, req.(*GetReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_AddProductToProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProductToProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_AddProductToProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, req.(*AddProductToProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_RemoveProductFromProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveProductFromProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_RemoveProductFromProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, req.(*RemoveProductFromProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductsInProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsInProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_ListProductsInProductSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, req.(*ListProductsInProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ImportProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ImportProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_ImportProductSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ImportProductSets(ctx, req.(*ImportProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_PurgeProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).PurgeProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductSearch_PurgeProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).PurgeProducts(ctx, req.(*PurgeProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ProductSearch_ServiceDesc is the grpc.ServiceDesc for ProductSearch service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ProductSearch_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ProductSearch",
	HandlerType: (*ProductSearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProductSet",
			Handler:    _ProductSearch_CreateProductSet_Handler,
		},
		{
			MethodName: "ListProductSets",
			Handler:    _ProductSearch_ListProductSets_Handler,
		},
		{
			MethodName: "GetProductSet",
			Handler:    _ProductSearch_GetProductSet_Handler,
		},
		{
			MethodName: "UpdateProductSet",
			Handler:    _ProductSearch_UpdateProductSet_Handler,
		},
		{
			MethodName: "DeleteProductSet",
			Handler:    _ProductSearch_DeleteProductSet_Handler,
		},
		{
			MethodName: "CreateProduct",
			Handler:    _ProductSearch_CreateProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductSearch_ListProducts_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductSearch_GetProduct_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductSearch_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductSearch_DeleteProduct_Handler,
		},
		{
			MethodName: "CreateReferenceImage",
			Handler:    _ProductSearch_CreateReferenceImage_Handler,
		},
		{
			MethodName: "DeleteReferenceImage",
			Handler:    _ProductSearch_DeleteReferenceImage_Handler,
		},
		{
			MethodName: "ListReferenceImages",
			Handler:    _ProductSearch_ListReferenceImages_Handler,
		},
		{
			MethodName: "GetReferenceImage",
			Handler:    _ProductSearch_GetReferenceImage_Handler,
		},
		{
			MethodName: "AddProductToProductSet",
			Handler:    _ProductSearch_AddProductToProductSet_Handler,
		},
		{
			MethodName: "RemoveProductFromProductSet",
			Handler:    _ProductSearch_RemoveProductFromProductSet_Handler,
		},
		{
			MethodName: "ListProductsInProductSet",
			Handler:    _ProductSearch_ListProductsInProductSet_Handler,
		},
		{
			MethodName: "ImportProductSets",
			Handler:    _ProductSearch_ImportProductSets_Handler,
		},
		{
			MethodName: "PurgeProducts",
			Handler:    _ProductSearch_PurgeProducts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/product_search_service.proto",
}
