/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpointAzureBlobStorage type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpointAzureBlobStorage{}

// EndpointAzureBlobStorage struct for EndpointAzureBlobStorage
type EndpointAzureBlobStorage struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	StorageAccount *string `json:"storage_account,omitempty"`
	ContainerName *string `json:"container_name,omitempty"`
	BlobSasToken *string `json:"blob_sas_token,omitempty"`
}

// NewEndpointAzureBlobStorage instantiates a new EndpointAzureBlobStorage object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpointAzureBlobStorage() *EndpointAzureBlobStorage {
	this := EndpointAzureBlobStorage{}
	return &this
}

// NewEndpointAzureBlobStorageWithDefaults instantiates a new EndpointAzureBlobStorage object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpointAzureBlobStorageWithDefaults() *EndpointAzureBlobStorage {
	this := EndpointAzureBlobStorage{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpointAzureBlobStorage) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureBlobStorage) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpointAzureBlobStorage) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpointAzureBlobStorage) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetStorageAccount returns the StorageAccount field value if set, zero value otherwise.
func (o *EndpointAzureBlobStorage) GetStorageAccount() string {
	if o == nil || IsNil(o.StorageAccount) {
		var ret string
		return ret
	}
	return *o.StorageAccount
}

// GetStorageAccountOk returns a tuple with the StorageAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureBlobStorage) GetStorageAccountOk() (*string, bool) {
	if o == nil || IsNil(o.StorageAccount) {
		return nil, false
	}
	return o.StorageAccount, true
}

// HasStorageAccount returns a boolean if a field has been set.
func (o *EndpointAzureBlobStorage) HasStorageAccount() bool {
	if o != nil && !IsNil(o.StorageAccount) {
		return true
	}

	return false
}

// SetStorageAccount gets a reference to the given string and assigns it to the StorageAccount field.
func (o *EndpointAzureBlobStorage) SetStorageAccount(v string) {
	o.StorageAccount = &v
}

// GetContainerName returns the ContainerName field value if set, zero value otherwise.
func (o *EndpointAzureBlobStorage) GetContainerName() string {
	if o == nil || IsNil(o.ContainerName) {
		var ret string
		return ret
	}
	return *o.ContainerName
}

// GetContainerNameOk returns a tuple with the ContainerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureBlobStorage) GetContainerNameOk() (*string, bool) {
	if o == nil || IsNil(o.ContainerName) {
		return nil, false
	}
	return o.ContainerName, true
}

// HasContainerName returns a boolean if a field has been set.
func (o *EndpointAzureBlobStorage) HasContainerName() bool {
	if o != nil && !IsNil(o.ContainerName) {
		return true
	}

	return false
}

// SetContainerName gets a reference to the given string and assigns it to the ContainerName field.
func (o *EndpointAzureBlobStorage) SetContainerName(v string) {
	o.ContainerName = &v
}

// GetBlobSasToken returns the BlobSasToken field value if set, zero value otherwise.
func (o *EndpointAzureBlobStorage) GetBlobSasToken() string {
	if o == nil || IsNil(o.BlobSasToken) {
		var ret string
		return ret
	}
	return *o.BlobSasToken
}

// GetBlobSasTokenOk returns a tuple with the BlobSasToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointAzureBlobStorage) GetBlobSasTokenOk() (*string, bool) {
	if o == nil || IsNil(o.BlobSasToken) {
		return nil, false
	}
	return o.BlobSasToken, true
}

// HasBlobSasToken returns a boolean if a field has been set.
func (o *EndpointAzureBlobStorage) HasBlobSasToken() bool {
	if o != nil && !IsNil(o.BlobSasToken) {
		return true
	}

	return false
}

// SetBlobSasToken gets a reference to the given string and assigns it to the BlobSasToken field.
func (o *EndpointAzureBlobStorage) SetBlobSasToken(v string) {
	o.BlobSasToken = &v
}

func (o EndpointAzureBlobStorage) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpointAzureBlobStorage) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.StorageAccount) {
		toSerialize["storage_account"] = o.StorageAccount
	}
	if !IsNil(o.ContainerName) {
		toSerialize["container_name"] = o.ContainerName
	}
	if !IsNil(o.BlobSasToken) {
		toSerialize["blob_sas_token"] = o.BlobSasToken
	}
	return toSerialize, nil
}

type NullableEndpointAzureBlobStorage struct {
	value *EndpointAzureBlobStorage
	isSet bool
}

func (v NullableEndpointAzureBlobStorage) Get() *EndpointAzureBlobStorage {
	return v.value
}

func (v *NullableEndpointAzureBlobStorage) Set(val *EndpointAzureBlobStorage) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpointAzureBlobStorage) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpointAzureBlobStorage) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpointAzureBlobStorage(val *EndpointAzureBlobStorage) *NullableEndpointAzureBlobStorage {
	return &NullableEndpointAzureBlobStorage{value: val, isSet: true}
}

func (v NullableEndpointAzureBlobStorage) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpointAzureBlobStorage) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


