/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.fields;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotatedReader;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.fields.FieldVisitor;

public final class FieldReader
extends AnnotatedReader {
    @Nonnull
    private final ClassVisitor cv;
    @Nullable
    private Object constantValue;

    public FieldReader(@Nonnull ClassReader cr, @Nonnull ClassVisitor cv) {
        super(cr);
        this.cv = cv;
    }

    @Nonnegative
    public int readFields() {
        for (int fieldCount = this.readUnsignedShort(); fieldCount > 0; --fieldCount) {
            this.readField();
        }
        return this.codeIndex;
    }

    private void readField() {
        this.access = this.readUnsignedShort();
        String name = this.readNonnullUTF8();
        String desc = this.readNonnullUTF8();
        this.constantValue = null;
        this.readAttributes();
        FieldVisitor fv = this.cv.visitField(this.access, name, desc, this.signature, this.constantValue);
        if (fv != null) {
            this.readAnnotations(fv);
            fv.visitEnd();
        }
    }

    @Override
    @Nullable
    protected Boolean readAttribute(@Nonnull String attributeName) {
        if ("ConstantValue".equals(attributeName)) {
            int constItemIndex = this.readUnsignedShort();
            if (constItemIndex > 0) {
                this.constantValue = this.readConst(constItemIndex);
            }
            return true;
        }
        return null;
    }
}

