// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/video/v1/video.proto

package video

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum controlling whether videos are automatically transcoded after upload.
type AutoTranscode int32

const (
	// The auto-transcoding setting is not specified.
	AutoTranscode_AUTO_TRANSCODE_UNSPECIFIED AutoTranscode = 0
	// Automatically start transcoding after the video upload is complete.
	AutoTranscode_ENABLE AutoTranscode = 1
	// Do not automatically transcode; requires manual initiation via the Transcode() method.
	AutoTranscode_DISABLE AutoTranscode = 2
)

// Enum value maps for AutoTranscode.
var (
	AutoTranscode_name = map[int32]string{
		0: "AUTO_TRANSCODE_UNSPECIFIED",
		1: "ENABLE",
		2: "DISABLE",
	}
	AutoTranscode_value = map[string]int32{
		"AUTO_TRANSCODE_UNSPECIFIED": 0,
		"ENABLE":                     1,
		"DISABLE":                    2,
	}
)

func (x AutoTranscode) Enum() *AutoTranscode {
	p := new(AutoTranscode)
	*p = x
	return p
}

func (x AutoTranscode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoTranscode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_video_proto_enumTypes[0].Descriptor()
}

func (AutoTranscode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_video_proto_enumTypes[0]
}

func (x AutoTranscode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoTranscode.Descriptor instead.
func (AutoTranscode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{0}
}

// Current processing status of the video.
type Video_VideoStatus int32

const (
	// The video status is not specified.
	Video_VIDEO_STATUS_UNSPECIFIED Video_VideoStatus = 0
	// The video upload is in progress, waiting for all bytes to be received.
	Video_WAIT_UPLOADING Video_VideoStatus = 1
	// The video has been fully uploaded and is ready for transcoding.
	Video_UPLOADED Video_VideoStatus = 2
	// The video is currently being processed.
	Video_PROCESSING Video_VideoStatus = 4
	// The video has been successfully processed and is ready for watching.
	Video_READY Video_VideoStatus = 5
	// An error occurred during video processing.
	Video_ERROR Video_VideoStatus = 7
)

// Enum value maps for Video_VideoStatus.
var (
	Video_VideoStatus_name = map[int32]string{
		0: "VIDEO_STATUS_UNSPECIFIED",
		1: "WAIT_UPLOADING",
		2: "UPLOADED",
		4: "PROCESSING",
		5: "READY",
		7: "ERROR",
	}
	Video_VideoStatus_value = map[string]int32{
		"VIDEO_STATUS_UNSPECIFIED": 0,
		"WAIT_UPLOADING":           1,
		"UPLOADED":                 2,
		"PROCESSING":               4,
		"READY":                    5,
		"ERROR":                    7,
	}
)

func (x Video_VideoStatus) Enum() *Video_VideoStatus {
	p := new(Video_VideoStatus)
	*p = x
	return p
}

func (x Video_VideoStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Video_VideoStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_video_proto_enumTypes[1].Descriptor()
}

func (Video_VideoStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_video_proto_enumTypes[1]
}

func (x Video_VideoStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Video_VideoStatus.Descriptor instead.
func (Video_VideoStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{0, 0}
}

// Visibility status of the video.
type Video_VisibilityStatus int32

const (
	// The visibility status is not specified.
	Video_VISIBILITY_STATUS_UNSPECIFIED Video_VisibilityStatus = 0
	// The video is publicly available, subject to its access permission settings.
	Video_PUBLISHED Video_VisibilityStatus = 1
	// The video is available only to administrators.
	Video_UNPUBLISHED Video_VisibilityStatus = 2
)

// Enum value maps for Video_VisibilityStatus.
var (
	Video_VisibilityStatus_name = map[int32]string{
		0: "VISIBILITY_STATUS_UNSPECIFIED",
		1: "PUBLISHED",
		2: "UNPUBLISHED",
	}
	Video_VisibilityStatus_value = map[string]int32{
		"VISIBILITY_STATUS_UNSPECIFIED": 0,
		"PUBLISHED":                     1,
		"UNPUBLISHED":                   2,
	}
)

func (x Video_VisibilityStatus) Enum() *Video_VisibilityStatus {
	p := new(Video_VisibilityStatus)
	*p = x
	return p
}

func (x Video_VisibilityStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Video_VisibilityStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_video_proto_enumTypes[2].Descriptor()
}

func (Video_VisibilityStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_video_proto_enumTypes[2]
}

func (x Video_VisibilityStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Video_VisibilityStatus.Descriptor instead.
func (Video_VisibilityStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{0, 1}
}

// Status of a feature processing request.
type VideoFeatures_FeatureResult int32

const (
	// The feature result status is not specified.
	VideoFeatures_FEATURE_RESULT_UNSPECIFIED VideoFeatures_FeatureResult = 0
	// The feature processing has not been requested.
	VideoFeatures_NOT_REQUESTED VideoFeatures_FeatureResult = 1
	// The feature is currently being processed.
	VideoFeatures_PROCESSING VideoFeatures_FeatureResult = 2
	// The feature processing has completed successfully.
	VideoFeatures_SUCCESS VideoFeatures_FeatureResult = 3
	// The feature processing has failed.
	VideoFeatures_FAILED VideoFeatures_FeatureResult = 4
)

// Enum value maps for VideoFeatures_FeatureResult.
var (
	VideoFeatures_FeatureResult_name = map[int32]string{
		0: "FEATURE_RESULT_UNSPECIFIED",
		1: "NOT_REQUESTED",
		2: "PROCESSING",
		3: "SUCCESS",
		4: "FAILED",
	}
	VideoFeatures_FeatureResult_value = map[string]int32{
		"FEATURE_RESULT_UNSPECIFIED": 0,
		"NOT_REQUESTED":              1,
		"PROCESSING":                 2,
		"SUCCESS":                    3,
		"FAILED":                     4,
	}
)

func (x VideoFeatures_FeatureResult) Enum() *VideoFeatures_FeatureResult {
	p := new(VideoFeatures_FeatureResult)
	*p = x
	return p
}

func (x VideoFeatures_FeatureResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VideoFeatures_FeatureResult) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_video_proto_enumTypes[3].Descriptor()
}

func (VideoFeatures_FeatureResult) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_video_proto_enumTypes[3]
}

func (x VideoFeatures_FeatureResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VideoFeatures_FeatureResult.Descriptor instead.
func (VideoFeatures_FeatureResult) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{4, 0}
}

// Main entity representing a video in the platform.
type Video struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique identifier of the video.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the channel where the video is created and managed.
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Title of the video displayed to users in interfaces and players.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Detailed description of the video content and context.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the thumbnail image used to represent the video visually.
	ThumbnailId string `protobuf:"bytes,5,opt,name=thumbnail_id,json=thumbnailId,proto3" json:"thumbnail_id,omitempty"`
	// Current processing status of the video.
	Status Video_VideoStatus `protobuf:"varint,6,opt,name=status,proto3,enum=yandex.cloud.video.v1.Video_VideoStatus" json:"status,omitempty"`
	// Error message describing the reason for video processing failure, if any.
	ErrorMessage string `protobuf:"bytes,18,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Current visibility status controlling whether the video is publicly available.
	VisibilityStatus Video_VisibilityStatus `protobuf:"varint,9,opt,name=visibility_status,json=visibilityStatus,proto3,enum=yandex.cloud.video.v1.Video_VisibilityStatus" json:"visibility_status,omitempty"`
	// Total duration of the video.
	// Optional, may be empty until the transcoding result is ready.
	Duration *durationpb.Duration `protobuf:"bytes,8,opt,name=duration,proto3" json:"duration,omitempty"`
	// Auto-transcoding setting that controls the video processing workflow.
	// Set ENABLE to automatically initiate transcoding after upload,
	// or DISABLE for manual initiation via the Transcode() method.
	AutoTranscode AutoTranscode `protobuf:"varint,11,opt,name=auto_transcode,json=autoTranscode,proto3,enum=yandex.cloud.video.v1.AutoTranscode" json:"auto_transcode,omitempty"`
	// Identifier of the style preset applied to the video during processing.
	StylePresetId string `protobuf:"bytes,16,opt,name=style_preset_id,json=stylePresetId,proto3" json:"style_preset_id,omitempty"`
	// Controls the ability to display advertisements for this video.
	// Default: true.
	// Set explicitly to false to disable advertisements for a specific video.
	EnableAd *wrapperspb.BoolValue `protobuf:"bytes,17,opt,name=enable_ad,json=enableAd,proto3" json:"enable_ad,omitempty"`
	// List of identifiers defining the active subtitles available for the video.
	SubtitleIds []string `protobuf:"bytes,12,rep,name=subtitle_ids,json=subtitleIds,proto3" json:"subtitle_ids,omitempty"`
	// Additional video processing features and their results, such as summarization.
	Features *VideoFeatures `protobuf:"bytes,13,opt,name=features,proto3" json:"features,omitempty"`
	// Specifies the video upload source method (one source variant must be chosen).
	//
	// Types that are valid to be assigned to Source:
	//
	//	*Video_Tusd
	Source isVideo_Source `protobuf_oneof:"source"`
	// Specifies the video access permission settings.
	//
	// Types that are valid to be assigned to AccessRights:
	//
	//	*Video_PublicAccess
	//	*Video_SignUrlAccess
	AccessRights isVideo_AccessRights `protobuf_oneof:"access_rights"`
	// Timestamp when the video was initially created in the system.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Timestamp of the last modification to the video or its metadata.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,101,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Custom user-defined labels as `key:value` pairs.
	// Maximum 64 labels per video.
	// Labels can be used for organization, filtering, and metadata purposes.
	Labels        map[string]string `protobuf:"bytes,200,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Video) Reset() {
	*x = Video{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Video) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Video) ProtoMessage() {}

func (x *Video) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Video.ProtoReflect.Descriptor instead.
func (*Video) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{0}
}

func (x *Video) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Video) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *Video) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Video) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Video) GetThumbnailId() string {
	if x != nil {
		return x.ThumbnailId
	}
	return ""
}

func (x *Video) GetStatus() Video_VideoStatus {
	if x != nil {
		return x.Status
	}
	return Video_VIDEO_STATUS_UNSPECIFIED
}

func (x *Video) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *Video) GetVisibilityStatus() Video_VisibilityStatus {
	if x != nil {
		return x.VisibilityStatus
	}
	return Video_VISIBILITY_STATUS_UNSPECIFIED
}

func (x *Video) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Video) GetAutoTranscode() AutoTranscode {
	if x != nil {
		return x.AutoTranscode
	}
	return AutoTranscode_AUTO_TRANSCODE_UNSPECIFIED
}

func (x *Video) GetStylePresetId() string {
	if x != nil {
		return x.StylePresetId
	}
	return ""
}

func (x *Video) GetEnableAd() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableAd
	}
	return nil
}

func (x *Video) GetSubtitleIds() []string {
	if x != nil {
		return x.SubtitleIds
	}
	return nil
}

func (x *Video) GetFeatures() *VideoFeatures {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *Video) GetSource() isVideo_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Video) GetTusd() *VideoTUSDSource {
	if x != nil {
		if x, ok := x.Source.(*Video_Tusd); ok {
			return x.Tusd
		}
	}
	return nil
}

func (x *Video) GetAccessRights() isVideo_AccessRights {
	if x != nil {
		return x.AccessRights
	}
	return nil
}

func (x *Video) GetPublicAccess() *VideoPublicAccessRights {
	if x != nil {
		if x, ok := x.AccessRights.(*Video_PublicAccess); ok {
			return x.PublicAccess
		}
	}
	return nil
}

func (x *Video) GetSignUrlAccess() *VideoSignURLAccessRights {
	if x != nil {
		if x, ok := x.AccessRights.(*Video_SignUrlAccess); ok {
			return x.SignUrlAccess
		}
	}
	return nil
}

func (x *Video) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Video) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Video) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isVideo_Source interface {
	isVideo_Source()
}

type Video_Tusd struct {
	// Upload video using the TUS (Tus Resumable Upload Protocol) protocol.
	// @see https://tus.io/
	Tusd *VideoTUSDSource `protobuf:"bytes,1000,opt,name=tusd,proto3,oneof"`
}

func (*Video_Tusd) isVideo_Source() {}

type isVideo_AccessRights interface {
	isVideo_AccessRights()
}

type Video_PublicAccess struct {
	// Allows unrestricted public access to the video via direct link.
	// No additional authorization or access control is applied.
	PublicAccess *VideoPublicAccessRights `protobuf:"bytes,2000,opt,name=public_access,json=publicAccess,proto3,oneof"`
}

type Video_SignUrlAccess struct {
	// Restricts video access using URL signatures for secure time-limited access.
	SignUrlAccess *VideoSignURLAccessRights `protobuf:"bytes,2003,opt,name=sign_url_access,json=signUrlAccess,proto3,oneof"`
}

func (*Video_PublicAccess) isVideo_AccessRights() {}

func (*Video_SignUrlAccess) isVideo_AccessRights() {}

// Represents a video upload source using the TUS (Tus Resumable Upload Protocol) protocol.
// This is a push-based upload method where the client pushes data to the server.
// @see https://tus.io/
type VideoTUSDSource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL endpoint for uploading the video via the TUS protocol.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Total size of the uploaded file, in bytes.
	FileSize      int64 `protobuf:"varint,2,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoTUSDSource) Reset() {
	*x = VideoTUSDSource{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoTUSDSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoTUSDSource) ProtoMessage() {}

func (x *VideoTUSDSource) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoTUSDSource.ProtoReflect.Descriptor instead.
func (*VideoTUSDSource) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{1}
}

func (x *VideoTUSDSource) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *VideoTUSDSource) GetFileSize() int64 {
	if x != nil {
		return x.FileSize
	}
	return 0
}

// Represents public access rights for a video.
// When this access type is set, the video is publicly accessible via direct link.
type VideoPublicAccessRights struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoPublicAccessRights) Reset() {
	*x = VideoPublicAccessRights{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoPublicAccessRights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoPublicAccessRights) ProtoMessage() {}

func (x *VideoPublicAccessRights) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoPublicAccessRights.ProtoReflect.Descriptor instead.
func (*VideoPublicAccessRights) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{2}
}

// Represents access rights controlled by URL signatures.
// When this access type is set, the video is accessible only via properly signed temporary link.
type VideoSignURLAccessRights struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoSignURLAccessRights) Reset() {
	*x = VideoSignURLAccessRights{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoSignURLAccessRights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoSignURLAccessRights) ProtoMessage() {}

func (x *VideoSignURLAccessRights) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoSignURLAccessRights.ProtoReflect.Descriptor instead.
func (*VideoSignURLAccessRights) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{3}
}

// Contains additional processing features and their results for the video.
type VideoFeatures struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Results of the video content summarization process.
	Summary       *VideoFeatures_Summary `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoFeatures) Reset() {
	*x = VideoFeatures{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFeatures) ProtoMessage() {}

func (x *VideoFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFeatures.ProtoReflect.Descriptor instead.
func (*VideoFeatures) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{4}
}

func (x *VideoFeatures) GetSummary() *VideoFeatures_Summary {
	if x != nil {
		return x.Summary
	}
	return nil
}

// Contains the results of video summarization.
type VideoFeatures_Summary struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Current status of the summarization process.
	Result VideoFeatures_FeatureResult `protobuf:"varint,1,opt,name=result,proto3,enum=yandex.cloud.video.v1.VideoFeatures_FeatureResult" json:"result,omitempty"`
	// List of URLs to summarization results for different audio tracks.
	Urls          []*VideoFeatures_Summary_SummaryURL `protobuf:"bytes,3,rep,name=urls,proto3" json:"urls,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoFeatures_Summary) Reset() {
	*x = VideoFeatures_Summary{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoFeatures_Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFeatures_Summary) ProtoMessage() {}

func (x *VideoFeatures_Summary) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFeatures_Summary.ProtoReflect.Descriptor instead.
func (*VideoFeatures_Summary) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{4, 0}
}

func (x *VideoFeatures_Summary) GetResult() VideoFeatures_FeatureResult {
	if x != nil {
		return x.Result
	}
	return VideoFeatures_FEATURE_RESULT_UNSPECIFIED
}

func (x *VideoFeatures_Summary) GetUrls() []*VideoFeatures_Summary_SummaryURL {
	if x != nil {
		return x.Urls
	}
	return nil
}

// Contains a URL to a summarization result for a specific audio track.
type VideoFeatures_Summary_SummaryURL struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL to the summarization result file.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Input audio track index (one-based) that was summarized.
	TrackIndex int64 `protobuf:"varint,2,opt,name=track_index,json=trackIndex,proto3" json:"track_index,omitempty"`
	// Source track language represented as a three-letter code according to ISO 639-2/T.
	SrcLang       string `protobuf:"bytes,3,opt,name=src_lang,json=srcLang,proto3" json:"src_lang,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VideoFeatures_Summary_SummaryURL) Reset() {
	*x = VideoFeatures_Summary_SummaryURL{}
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoFeatures_Summary_SummaryURL) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFeatures_Summary_SummaryURL) ProtoMessage() {}

func (x *VideoFeatures_Summary_SummaryURL) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_video_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFeatures_Summary_SummaryURL.ProtoReflect.Descriptor instead.
func (*VideoFeatures_Summary_SummaryURL) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_video_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *VideoFeatures_Summary_SummaryURL) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *VideoFeatures_Summary_SummaryURL) GetTrackIndex() int64 {
	if x != nil {
		return x.TrackIndex
	}
	return 0
}

func (x *VideoFeatures_Summary_SummaryURL) GetSrcLang() string {
	if x != nil {
		return x.SrcLang
	}
	return ""
}

var File_yandex_cloud_video_v1_video_proto protoreflect.FileDescriptor

const file_yandex_cloud_video_v1_video_proto_rawDesc = "" +
	"\n" +
	"!yandex/cloud/video/v1/video.proto\x12\x15yandex.cloud.video.v1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\"\xb7\v\n" +
	"\x05Video\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1d\n" +
	"\n" +
	"channel_id\x18\x02 \x01(\tR\tchannelId\x12\x14\n" +
	"\x05title\x18\x03 \x01(\tR\x05title\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12!\n" +
	"\fthumbnail_id\x18\x05 \x01(\tR\vthumbnailId\x12@\n" +
	"\x06status\x18\x06 \x01(\x0e2(.yandex.cloud.video.v1.Video.VideoStatusR\x06status\x12#\n" +
	"\rerror_message\x18\x12 \x01(\tR\ferrorMessage\x12Z\n" +
	"\x11visibility_status\x18\t \x01(\x0e2-.yandex.cloud.video.v1.Video.VisibilityStatusR\x10visibilityStatus\x125\n" +
	"\bduration\x18\b \x01(\v2\x19.google.protobuf.DurationR\bduration\x12K\n" +
	"\x0eauto_transcode\x18\v \x01(\x0e2$.yandex.cloud.video.v1.AutoTranscodeR\rautoTranscode\x12&\n" +
	"\x0fstyle_preset_id\x18\x10 \x01(\tR\rstylePresetId\x127\n" +
	"\tenable_ad\x18\x11 \x01(\v2\x1a.google.protobuf.BoolValueR\benableAd\x12!\n" +
	"\fsubtitle_ids\x18\f \x03(\tR\vsubtitleIds\x12@\n" +
	"\bfeatures\x18\r \x01(\v2$.yandex.cloud.video.v1.VideoFeaturesR\bfeatures\x12=\n" +
	"\x04tusd\x18\xe8\a \x01(\v2&.yandex.cloud.video.v1.VideoTUSDSourceH\x00R\x04tusd\x12V\n" +
	"\rpublic_access\x18\xd0\x0f \x01(\v2..yandex.cloud.video.v1.VideoPublicAccessRightsH\x01R\fpublicAccess\x12Z\n" +
	"\x0fsign_url_access\x18\xd3\x0f \x01(\v2/.yandex.cloud.video.v1.VideoSignURLAccessRightsH\x01R\rsignUrlAccess\x129\n" +
	"\n" +
	"created_at\x18d \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18e \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12A\n" +
	"\x06labels\x18\xc8\x01 \x03(\v2(.yandex.cloud.video.v1.Video.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x7f\n" +
	"\vVideoStatus\x12\x1c\n" +
	"\x18VIDEO_STATUS_UNSPECIFIED\x10\x00\x12\x12\n" +
	"\x0eWAIT_UPLOADING\x10\x01\x12\f\n" +
	"\bUPLOADED\x10\x02\x12\x0e\n" +
	"\n" +
	"PROCESSING\x10\x04\x12\t\n" +
	"\x05READY\x10\x05\x12\t\n" +
	"\x05ERROR\x10\a\"\x04\b\x03\x10\x03\"\x04\b\x06\x10\x06\"U\n" +
	"\x10VisibilityStatus\x12!\n" +
	"\x1dVISIBILITY_STATUS_UNSPECIFIED\x10\x00\x12\r\n" +
	"\tPUBLISHED\x10\x01\x12\x0f\n" +
	"\vUNPUBLISHED\x10\x02B\b\n" +
	"\x06sourceB\x0f\n" +
	"\raccess_rightsJ\x04\b\n" +
	"\x10\vJ\x06\b\xd1\x0f\x10\xd2\x0fJ\x06\b\xd2\x0f\x10\xd3\x0fJ\x04\b\a\x10\bJ\x04\b\x0e\x10\x10J\x04\b\x13\x10dJ\x05\bf\x10\xc8\x01J\x06\b\xc9\x01\x10\xe8\aJ\x06\b\xe9\a\x10\xd0\x0f\"@\n" +
	"\x0fVideoTUSDSource\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12\x1b\n" +
	"\tfile_size\x18\x02 \x01(\x03R\bfileSize\"\x19\n" +
	"\x17VideoPublicAccessRights\"\x1a\n" +
	"\x18VideoSignURLAccessRights\"\xcb\x03\n" +
	"\rVideoFeatures\x12F\n" +
	"\asummary\x18\x01 \x01(\v2,.yandex.cloud.video.v1.VideoFeatures.SummaryR\asummary\x1a\x84\x02\n" +
	"\aSummary\x12J\n" +
	"\x06result\x18\x01 \x01(\x0e22.yandex.cloud.video.v1.VideoFeatures.FeatureResultR\x06result\x12K\n" +
	"\x04urls\x18\x03 \x03(\v27.yandex.cloud.video.v1.VideoFeatures.Summary.SummaryURLR\x04urls\x1aZ\n" +
	"\n" +
	"SummaryURL\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12\x1f\n" +
	"\vtrack_index\x18\x02 \x01(\x03R\n" +
	"trackIndex\x12\x19\n" +
	"\bsrc_lang\x18\x03 \x01(\tR\asrcLangJ\x04\b\x02\x10\x03\"k\n" +
	"\rFeatureResult\x12\x1e\n" +
	"\x1aFEATURE_RESULT_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rNOT_REQUESTED\x10\x01\x12\x0e\n" +
	"\n" +
	"PROCESSING\x10\x02\x12\v\n" +
	"\aSUCCESS\x10\x03\x12\n" +
	"\n" +
	"\x06FAILED\x10\x04*H\n" +
	"\rAutoTranscode\x12\x1e\n" +
	"\x1aAUTO_TRANSCODE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06ENABLE\x10\x01\x12\v\n" +
	"\aDISABLE\x10\x02B\\\n" +
	"\x19yandex.cloud.api.video.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/video/v1;videob\x06proto3"

var (
	file_yandex_cloud_video_v1_video_proto_rawDescOnce sync.Once
	file_yandex_cloud_video_v1_video_proto_rawDescData []byte
)

func file_yandex_cloud_video_v1_video_proto_rawDescGZIP() []byte {
	file_yandex_cloud_video_v1_video_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_video_v1_video_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_video_proto_rawDesc), len(file_yandex_cloud_video_v1_video_proto_rawDesc)))
	})
	return file_yandex_cloud_video_v1_video_proto_rawDescData
}

var file_yandex_cloud_video_v1_video_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_yandex_cloud_video_v1_video_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_yandex_cloud_video_v1_video_proto_goTypes = []any{
	(AutoTranscode)(0),                       // 0: yandex.cloud.video.v1.AutoTranscode
	(Video_VideoStatus)(0),                   // 1: yandex.cloud.video.v1.Video.VideoStatus
	(Video_VisibilityStatus)(0),              // 2: yandex.cloud.video.v1.Video.VisibilityStatus
	(VideoFeatures_FeatureResult)(0),         // 3: yandex.cloud.video.v1.VideoFeatures.FeatureResult
	(*Video)(nil),                            // 4: yandex.cloud.video.v1.Video
	(*VideoTUSDSource)(nil),                  // 5: yandex.cloud.video.v1.VideoTUSDSource
	(*VideoPublicAccessRights)(nil),          // 6: yandex.cloud.video.v1.VideoPublicAccessRights
	(*VideoSignURLAccessRights)(nil),         // 7: yandex.cloud.video.v1.VideoSignURLAccessRights
	(*VideoFeatures)(nil),                    // 8: yandex.cloud.video.v1.VideoFeatures
	nil,                                      // 9: yandex.cloud.video.v1.Video.LabelsEntry
	(*VideoFeatures_Summary)(nil),            // 10: yandex.cloud.video.v1.VideoFeatures.Summary
	(*VideoFeatures_Summary_SummaryURL)(nil), // 11: yandex.cloud.video.v1.VideoFeatures.Summary.SummaryURL
	(*durationpb.Duration)(nil),              // 12: google.protobuf.Duration
	(*wrapperspb.BoolValue)(nil),             // 13: google.protobuf.BoolValue
	(*timestamppb.Timestamp)(nil),            // 14: google.protobuf.Timestamp
}
var file_yandex_cloud_video_v1_video_proto_depIdxs = []int32{
	1,  // 0: yandex.cloud.video.v1.Video.status:type_name -> yandex.cloud.video.v1.Video.VideoStatus
	2,  // 1: yandex.cloud.video.v1.Video.visibility_status:type_name -> yandex.cloud.video.v1.Video.VisibilityStatus
	12, // 2: yandex.cloud.video.v1.Video.duration:type_name -> google.protobuf.Duration
	0,  // 3: yandex.cloud.video.v1.Video.auto_transcode:type_name -> yandex.cloud.video.v1.AutoTranscode
	13, // 4: yandex.cloud.video.v1.Video.enable_ad:type_name -> google.protobuf.BoolValue
	8,  // 5: yandex.cloud.video.v1.Video.features:type_name -> yandex.cloud.video.v1.VideoFeatures
	5,  // 6: yandex.cloud.video.v1.Video.tusd:type_name -> yandex.cloud.video.v1.VideoTUSDSource
	6,  // 7: yandex.cloud.video.v1.Video.public_access:type_name -> yandex.cloud.video.v1.VideoPublicAccessRights
	7,  // 8: yandex.cloud.video.v1.Video.sign_url_access:type_name -> yandex.cloud.video.v1.VideoSignURLAccessRights
	14, // 9: yandex.cloud.video.v1.Video.created_at:type_name -> google.protobuf.Timestamp
	14, // 10: yandex.cloud.video.v1.Video.updated_at:type_name -> google.protobuf.Timestamp
	9,  // 11: yandex.cloud.video.v1.Video.labels:type_name -> yandex.cloud.video.v1.Video.LabelsEntry
	10, // 12: yandex.cloud.video.v1.VideoFeatures.summary:type_name -> yandex.cloud.video.v1.VideoFeatures.Summary
	3,  // 13: yandex.cloud.video.v1.VideoFeatures.Summary.result:type_name -> yandex.cloud.video.v1.VideoFeatures.FeatureResult
	11, // 14: yandex.cloud.video.v1.VideoFeatures.Summary.urls:type_name -> yandex.cloud.video.v1.VideoFeatures.Summary.SummaryURL
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_yandex_cloud_video_v1_video_proto_init() }
func file_yandex_cloud_video_v1_video_proto_init() {
	if File_yandex_cloud_video_v1_video_proto != nil {
		return
	}
	file_yandex_cloud_video_v1_video_proto_msgTypes[0].OneofWrappers = []any{
		(*Video_Tusd)(nil),
		(*Video_PublicAccess)(nil),
		(*Video_SignUrlAccess)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_video_proto_rawDesc), len(file_yandex_cloud_video_v1_video_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_video_v1_video_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_video_v1_video_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_video_v1_video_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_video_v1_video_proto_msgTypes,
	}.Build()
	File_yandex_cloud_video_v1_video_proto = out.File
	file_yandex_cloud_video_v1_video_proto_goTypes = nil
	file_yandex_cloud_video_v1_video_proto_depIdxs = nil
}
