package storage

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storage/mgmt/2019-06-01/storage"

// Account the storage account.
type Account struct {
	autorest.Response `json:"-"`
	// Sku - READ-ONLY; Gets the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Gets the Kind. Possible values include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountProperties - Properties of the storage account.
	*AccountProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = kind
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountCheckNameAvailabilityParameters the parameters used to check the availability of the storage
// account name.
type AccountCheckNameAvailabilityParameters struct {
	// Name - The storage account name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Storage/storageAccounts
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters the parameters used when creating a storage account.
type AccountCreateParameters struct {
	// Sku - Required. Gets or sets the SKU name.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Indicates the type of storage account. Possible values include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Location - Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesCreateParameters - The parameters used to create the storage account.
	*AccountPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCreateParameters.
func (acp AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.Sku != nil {
		objectMap["sku"] = acp.Sku
	}
	if acp.Kind != "" {
		objectMap["kind"] = acp.Kind
	}
	if acp.Location != nil {
		objectMap["location"] = acp.Location
	}
	if acp.Tags != nil {
		objectMap["tags"] = acp.Tags
	}
	if acp.Identity != nil {
		objectMap["identity"] = acp.Identity
	}
	if acp.AccountPropertiesCreateParameters != nil {
		objectMap["properties"] = acp.AccountPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateParameters struct.
func (acp *AccountCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				acp.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acp.Kind = kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				acp.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesCreateParameters AccountPropertiesCreateParameters
				err = json.Unmarshal(*v, &accountPropertiesCreateParameters)
				if err != nil {
					return err
				}
				acp.AccountPropertiesCreateParameters = &accountPropertiesCreateParameters
			}
		}
	}

	return nil
}

// AccountInternetEndpoints the URIs that are used to perform a retrieval of a public blob, file, web or
// dfs object via a internet routing endpoint.
type AccountInternetEndpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
}

// AccountKey an access key for the storage account.
type AccountKey struct {
	// KeyName - READ-ONLY; Name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// Value - READ-ONLY; Base 64-encoded value of the key.
	Value *string `json:"value,omitempty"`
	// Permissions - READ-ONLY; Permissions for the key -- read-only or full permissions. Possible values include: 'Read', 'Full'
	Permissions KeyPermission `json:"permissions,omitempty"`
}

// AccountListKeysResult the response from the ListKeys operation.
type AccountListKeysResult struct {
	autorest.Response `json:"-"`
	// Keys - READ-ONLY; Gets the list of storage account keys and their properties for the specified storage account.
	Keys *[]AccountKey `json:"keys,omitempty"`
}

// AccountListResult the response from the List Storage Accounts operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Gets the list of storage accounts and their properties.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of storage accounts. Returned when total number of requested storage accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountMicrosoftEndpoints the URIs that are used to perform a retrieval of a public blob, queue, table,
// web or dfs object via a microsoft routing endpoint.
type AccountMicrosoftEndpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// Queue - READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty"`
	// Table - READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
}

// AccountProperties properties of the storage account.
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Gets the status of the storage account at the time the operation was called. Possible values include: 'Creating', 'ResolvingDNS', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrimaryEndpoints - READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints `json:"primaryEndpoints,omitempty"`
	// PrimaryLocation - READ-ONLY; Gets the location of the primary data center for the storage account.
	PrimaryLocation *string `json:"primaryLocation,omitempty"`
	// StatusOfPrimary - READ-ONLY; Gets the status indicating whether the primary location of the storage account is available or unavailable. Possible values include: 'Available', 'Unavailable'
	StatusOfPrimary AccountStatus `json:"statusOfPrimary,omitempty"`
	// LastGeoFailoverTime - READ-ONLY; Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent timestamp is retained. This element is not returned if there has never been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	LastGeoFailoverTime *date.Time `json:"lastGeoFailoverTime,omitempty"`
	// SecondaryLocation - READ-ONLY; Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
	SecondaryLocation *string `json:"secondaryLocation,omitempty"`
	// StatusOfSecondary - READ-ONLY; Gets the status indicating whether the secondary location of the storage account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS. Possible values include: 'Available', 'Unavailable'
	StatusOfSecondary AccountStatus `json:"statusOfSecondary,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation date and time of the storage account in UTC.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// CustomDomain - READ-ONLY; Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// SecondaryEndpoints - READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints `json:"secondaryEndpoints,omitempty"`
	// Encryption - READ-ONLY; Gets the encryption settings on the account. If unspecified, the account is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`
	// AccessTier - READ-ONLY; Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// NetworkRuleSet - READ-ONLY; Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// IsHnsEnabled - Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`
	// GeoReplicationStats - READ-ONLY; Geo Replication Stats
	GeoReplicationStats *GeoReplicationStats `json:"geoReplicationStats,omitempty"`
	// FailoverInProgress - READ-ONLY; If the failover is in progress, the value will be true, otherwise, it will be null.
	FailoverInProgress *bool `json:"failoverInProgress,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// BlobRestoreStatus - READ-ONLY; Blob restore status
	BlobRestoreStatus *BlobRestoreStatus `json:"blobRestoreStatus,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'TLS10', 'TLS11', 'TLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AzureFilesIdentityBasedAuthentication != nil {
		objectMap["azureFilesIdentityBasedAuthentication"] = ap.AzureFilesIdentityBasedAuthentication
	}
	if ap.EnableHTTPSTrafficOnly != nil {
		objectMap["supportsHttpsTrafficOnly"] = ap.EnableHTTPSTrafficOnly
	}
	if ap.IsHnsEnabled != nil {
		objectMap["isHnsEnabled"] = ap.IsHnsEnabled
	}
	if ap.LargeFileSharesState != "" {
		objectMap["largeFileSharesState"] = ap.LargeFileSharesState
	}
	if ap.RoutingPreference != nil {
		objectMap["routingPreference"] = ap.RoutingPreference
	}
	if ap.AllowBlobPublicAccess != nil {
		objectMap["allowBlobPublicAccess"] = ap.AllowBlobPublicAccess
	}
	if ap.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = ap.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// AccountPropertiesCreateParameters the parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// CustomDomain - User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Not applicable. Azure Storage encryption is enabled for all storage accounts and cannot be disabled.
	Encryption *Encryption `json:"encryption,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// IsHnsEnabled - Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'TLS10', 'TLS11', 'TLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// AccountPropertiesUpdateParameters the parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// CustomDomain - Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`
	// Encryption - Provides the encryption settings on the account. The default setting is unencrypted.
	Encryption *Encryption `json:"encryption,omitempty"`
	// AccessTier - Required for storage accounts where kind = BlobStorage. The access tier used for billing. Possible values include: 'Hot', 'Cool'
	AccessTier AccessTier `json:"accessTier,omitempty"`
	// AzureFilesIdentityBasedAuthentication - Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`
	// EnableHTTPSTrafficOnly - Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`
	// NetworkRuleSet - Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`
	// LargeFileSharesState - Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled. Possible values include: 'LargeFileSharesStateDisabled', 'LargeFileSharesStateEnabled'
	LargeFileSharesState LargeFileSharesState `json:"largeFileSharesState,omitempty"`
	// RoutingPreference - Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`
	// AllowBlobPublicAccess - Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`
	// MinimumTLSVersion - Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property. Possible values include: 'TLS10', 'TLS11', 'TLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// AccountRegenerateKeyParameters the parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// KeyName - The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1, kerb2.
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSasParameters the parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// Services - The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). Possible values include: 'B', 'Q', 'T', 'F'
	Services Services `json:"signedServices,omitempty"`
	// ResourceTypes - The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. Possible values include: 'SignedResourceTypesS', 'SignedResourceTypesC', 'SignedResourceTypesO'
	ResourceTypes SignedResourceTypes `json:"signedResourceTypes,omitempty"`
	// Permissions - The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'R', 'D', 'W', 'L', 'A', 'C', 'U', 'P'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'Httpshttp', 'HTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
}

// AccountsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// AccountsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// AccountsRestoreBlobRangesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AccountsRestoreBlobRangesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (BlobRestoreStatus, error)
}

// AccountUpdateParameters the parameters that can be provided when updating the storage account
// properties.
type AccountUpdateParameters struct {
	// Sku - Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any other value.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
	*AccountPropertiesUpdateParameters `json:"properties,omitempty"`
	// Kind - Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server. Possible values include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Sku != nil {
		objectMap["sku"] = aup.Sku
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	if aup.Identity != nil {
		objectMap["identity"] = aup.Identity
	}
	if aup.AccountPropertiesUpdateParameters != nil {
		objectMap["properties"] = aup.AccountPropertiesUpdateParameters
	}
	if aup.Kind != "" {
		objectMap["kind"] = aup.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				aup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				aup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var accountPropertiesUpdateParameters AccountPropertiesUpdateParameters
				err = json.Unmarshal(*v, &accountPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				aup.AccountPropertiesUpdateParameters = &accountPropertiesUpdateParameters
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aup.Kind = kind
			}
		}
	}

	return nil
}

// ActiveDirectoryProperties settings properties for Active Directory (AD).
type ActiveDirectoryProperties struct {
	// DomainName - Specifies the primary domain that the AD DNS server is authoritative for.
	DomainName *string `json:"domainName,omitempty"`
	// NetBiosDomainName - Specifies the NetBIOS domain name.
	NetBiosDomainName *string `json:"netBiosDomainName,omitempty"`
	// ForestName - Specifies the Active Directory forest to get.
	ForestName *string `json:"forestName,omitempty"`
	// DomainGUID - Specifies the domain GUID.
	DomainGUID *string `json:"domainGuid,omitempty"`
	// DomainSid - Specifies the security identifier (SID).
	DomainSid *string `json:"domainSid,omitempty"`
	// AzureStorageSid - Specifies the security identifier (SID) for Azure Storage.
	AzureStorageSid *string `json:"azureStorageSid,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// AzureFilesIdentityBasedAuthentication settings for Azure Files identity based authentication.
type AzureFilesIdentityBasedAuthentication struct {
	// DirectoryServiceOptions - Indicates the directory service used. Possible values include: 'DirectoryServiceOptionsNone', 'DirectoryServiceOptionsAADDS', 'DirectoryServiceOptionsAD'
	DirectoryServiceOptions DirectoryServiceOptions `json:"directoryServiceOptions,omitempty"`
	// ActiveDirectoryProperties - Required if choose AD.
	ActiveDirectoryProperties *ActiveDirectoryProperties `json:"activeDirectoryProperties,omitempty"`
}

// BlobContainer properties of the blob container, including Id, resource name, resource type, Etag.
type BlobContainer struct {
	autorest.Response `json:"-"`
	// ContainerProperties - Properties of the blob container.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobContainer.
func (bc BlobContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.ContainerProperties != nil {
		objectMap["properties"] = bc.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobContainer struct.
func (bc *BlobContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				bc.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		}
	}

	return nil
}

// BlobRestoreParameters blob restore parameters
type BlobRestoreParameters struct {
	// TimeToRestore - Restore blob to the specified time.
	TimeToRestore *date.Time `json:"timeToRestore,omitempty"`
	// BlobRanges - Blob ranges to restore.
	BlobRanges *[]BlobRestoreRange `json:"blobRanges,omitempty"`
}

// BlobRestoreRange blob range
type BlobRestoreRange struct {
	// StartRange - Blob start range. This is inclusive. Empty means account start.
	StartRange *string `json:"startRange,omitempty"`
	// EndRange - Blob end range. This is exclusive. Empty means account end.
	EndRange *string `json:"endRange,omitempty"`
}

// BlobRestoreStatus blob restore status.
type BlobRestoreStatus struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing. - Complete: Indicates that blob restore has been completed successfully. - Failed: Indicates that blob restore is failed. Possible values include: 'InProgress', 'Complete', 'Failed'
	Status BlobRestoreProgressStatus `json:"status,omitempty"`
	// FailureReason - READ-ONLY; Failure reason when blob restore is failed.
	FailureReason *string `json:"failureReason,omitempty"`
	// RestoreID - READ-ONLY; Id for tracking blob restore request.
	RestoreID *string `json:"restoreId,omitempty"`
	// Parameters - READ-ONLY; Blob restore request parameters.
	Parameters *BlobRestoreParameters `json:"parameters,omitempty"`
}

// BlobServiceItems ...
type BlobServiceItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of blob services returned.
	Value *[]BlobServiceProperties `json:"value,omitempty"`
}

// BlobServiceProperties the properties of a storage account’s Blob service.
type BlobServiceProperties struct {
	autorest.Response `json:"-"`
	// BlobServicePropertiesProperties - The properties of a storage account’s Blob service.
	*BlobServicePropertiesProperties `json:"properties,omitempty"`
	// Sku - READ-ONLY; Sku name and tier.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobServiceProperties.
func (bsp BlobServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsp.BlobServicePropertiesProperties != nil {
		objectMap["properties"] = bsp.BlobServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobServiceProperties struct.
func (bsp *BlobServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobServiceProperties BlobServicePropertiesProperties
				err = json.Unmarshal(*v, &blobServiceProperties)
				if err != nil {
					return err
				}
				bsp.BlobServicePropertiesProperties = &blobServiceProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				bsp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsp.Type = &typeVar
			}
		}
	}

	return nil
}

// BlobServicePropertiesProperties the properties of a storage account’s Blob service.
type BlobServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
	Cors *CorsRules `json:"cors,omitempty"`
	// DefaultServiceVersion - DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
	DefaultServiceVersion *string `json:"defaultServiceVersion,omitempty"`
	// DeleteRetentionPolicy - The blob service properties for blob soft delete.
	DeleteRetentionPolicy *DeleteRetentionPolicy `json:"deleteRetentionPolicy,omitempty"`
	// IsVersioningEnabled - Versioning is enabled if set to true.
	IsVersioningEnabled *bool `json:"isVersioningEnabled,omitempty"`
	// AutomaticSnapshotPolicyEnabled - Deprecated in favor of isVersioningEnabled property.
	AutomaticSnapshotPolicyEnabled *bool `json:"automaticSnapshotPolicyEnabled,omitempty"`
	// ChangeFeed - The blob service properties for change feed events.
	ChangeFeed *ChangeFeed `json:"changeFeed,omitempty"`
	// RestorePolicy - The blob service properties for blob restore policy.
	RestorePolicy *RestorePolicyProperties `json:"restorePolicy,omitempty"`
	// ContainerDeleteRetentionPolicy - The blob service properties for container soft delete.
	ContainerDeleteRetentionPolicy *DeleteRetentionPolicy `json:"containerDeleteRetentionPolicy,omitempty"`
}

// ChangeFeed the blob service properties for change feed events.
type ChangeFeed struct {
	// Enabled - Indicates whether change feed event logging is enabled for the Blob service.
	Enabled *bool `json:"enabled,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'AccountNameInvalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// CloudError an error response from the Storage service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Storage service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ContainerProperties the properties of a container.
type ContainerProperties struct {
	// Version - READ-ONLY; The version of the deleted blob container.
	Version *string `json:"version,omitempty"`
	// Deleted - READ-ONLY; Indicates whether the blob container was deleted.
	Deleted *bool `json:"deleted,omitempty"`
	// DeletedTime - READ-ONLY; Blob container deletion time.
	DeletedTime *date.Time `json:"deletedTime,omitempty"`
	// RemainingRetentionDays - READ-ONLY; Remaining retention days for soft deleted blob container.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty"`
	// DefaultEncryptionScope - Default the container to use specified encryption scope for all writes.
	DefaultEncryptionScope *string `json:"defaultEncryptionScope,omitempty"`
	// DenyEncryptionScopeOverride - Block override of encryption scope from the container default.
	DenyEncryptionScopeOverride *bool `json:"denyEncryptionScopeOverride,omitempty"`
	// PublicAccess - Specifies whether data in the container may be accessed publicly and the level of access. Possible values include: 'PublicAccessContainer', 'PublicAccessBlob', 'PublicAccessNone'
	PublicAccess PublicAccess `json:"publicAccess,omitempty"`
	// LastModifiedTime - READ-ONLY; Returns the date and time the container was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// LeaseStatus - READ-ONLY; The lease status of the container. Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked'
	LeaseStatus LeaseStatus `json:"leaseStatus,omitempty"`
	// LeaseState - READ-ONLY; Lease state of the container. Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken'
	LeaseState LeaseState `json:"leaseState,omitempty"`
	// LeaseDuration - READ-ONLY; Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased. Possible values include: 'Infinite', 'Fixed'
	LeaseDuration LeaseDuration `json:"leaseDuration,omitempty"`
	// Metadata - A name-value pair to associate with the container as metadata.
	Metadata map[string]*string `json:"metadata"`
	// ImmutabilityPolicy - READ-ONLY; The ImmutabilityPolicy property of the container.
	ImmutabilityPolicy *ImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty"`
	// LegalHold - READ-ONLY; The LegalHold property of the container.
	LegalHold *LegalHoldProperties `json:"legalHold,omitempty"`
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// HasImmutabilityPolicy - READ-ONLY; The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
	HasImmutabilityPolicy *bool `json:"hasImmutabilityPolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerProperties.
func (cp ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.DefaultEncryptionScope != nil {
		objectMap["defaultEncryptionScope"] = cp.DefaultEncryptionScope
	}
	if cp.DenyEncryptionScopeOverride != nil {
		objectMap["denyEncryptionScopeOverride"] = cp.DenyEncryptionScopeOverride
	}
	if cp.PublicAccess != "" {
		objectMap["publicAccess"] = cp.PublicAccess
	}
	if cp.Metadata != nil {
		objectMap["metadata"] = cp.Metadata
	}
	return json.Marshal(objectMap)
}

// CorsRule specifies a CORS rule for the Blob service.
type CorsRule struct {
	// AllowedOrigins - Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// AllowedMethods - Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
	AllowedMethods *[]string `json:"allowedMethods,omitempty"`
	// MaxAgeInSeconds - Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
	MaxAgeInSeconds *int32 `json:"maxAgeInSeconds,omitempty"`
	// ExposedHeaders - Required if CorsRule element is present. A list of response headers to expose to CORS clients.
	ExposedHeaders *[]string `json:"exposedHeaders,omitempty"`
	// AllowedHeaders - Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
	AllowedHeaders *[]string `json:"allowedHeaders,omitempty"`
}

// CorsRules sets the CORS rules. You can include up to five CorsRule elements in the request.
type CorsRules struct {
	// CorsRules - The List of CORS rules. You can include up to five CorsRule elements in the request.
	CorsRules *[]CorsRule `json:"corsRules,omitempty"`
}

// CustomDomain the custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// Name - Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string `json:"name,omitempty"`
	// UseSubDomainName - Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomainName *bool `json:"useSubDomainName,omitempty"`
}

// DateAfterCreation object to define the number of days after creation.
type DateAfterCreation struct {
	// DaysAfterCreationGreaterThan - Value indicating the age in days after creation
	DaysAfterCreationGreaterThan *float64 `json:"daysAfterCreationGreaterThan,omitempty"`
}

// DateAfterModification object to define the number of days after last modification.
type DateAfterModification struct {
	// DaysAfterModificationGreaterThan - Value indicating the age in days after last modification
	DaysAfterModificationGreaterThan *float64 `json:"daysAfterModificationGreaterThan,omitempty"`
}

// DeletedShare the deleted share to be restored.
type DeletedShare struct {
	// DeletedShareName - Required. Identify the name of the deleted share that will be restored.
	DeletedShareName *string `json:"deletedShareName,omitempty"`
	// DeletedShareVersion - Required. Identify the version of the deleted share that will be restored.
	DeletedShareVersion *string `json:"deletedShareVersion,omitempty"`
}

// DeleteRetentionPolicy the service properties for soft delete.
type DeleteRetentionPolicy struct {
	// Enabled - Indicates whether DeleteRetentionPolicy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum value can be 365.
	Days *int32 `json:"days,omitempty"`
}

// Dimension dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// Encryption the encryption settings on the storage account.
type Encryption struct {
	// Services - List of services which support encryption.
	Services *EncryptionServices `json:"services,omitempty"`
	// KeySource - The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include: 'KeySourceMicrosoftStorage', 'KeySourceMicrosoftKeyvault'
	KeySource KeySource `json:"keySource,omitempty"`
	// RequireInfrastructureEncryption - A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`
	// KeyVaultProperties - Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`
}

// EncryptionScope the Encryption Scope resource.
type EncryptionScope struct {
	autorest.Response `json:"-"`
	// EncryptionScopeProperties - Properties of the encryption scope.
	*EncryptionScopeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScope.
func (es EncryptionScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EncryptionScopeProperties != nil {
		objectMap["properties"] = es.EncryptionScopeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionScope struct.
func (es *EncryptionScope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var encryptionScopeProperties EncryptionScopeProperties
				err = json.Unmarshal(*v, &encryptionScopeProperties)
				if err != nil {
					return err
				}
				es.EncryptionScopeProperties = &encryptionScopeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionScopeKeyVaultProperties the key vault properties for the encryption scope. This is a required
// field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
type EncryptionScopeKeyVaultProperties struct {
	// KeyURI - The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
	KeyURI *string `json:"keyUri,omitempty"`
}

// EncryptionScopeListResult list of encryption scopes requested, and if paging is required, a URL to the
// next page of encryption scopes.
type EncryptionScopeListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of encryption scopes requested.
	Value *[]EncryptionScope `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of encryption scopes. Returned when total number of requested encryption scopes exceeds the maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// EncryptionScopeListResultIterator provides access to a complete listing of EncryptionScope values.
type EncryptionScopeListResultIterator struct {
	i    int
	page EncryptionScopeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionScopeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionScopeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionScopeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionScopeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionScopeListResultIterator) Response() EncryptionScopeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionScopeListResultIterator) Value() EncryptionScope {
	if !iter.page.NotDone() {
		return EncryptionScope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionScopeListResultIterator type.
func NewEncryptionScopeListResultIterator(page EncryptionScopeListResultPage) EncryptionScopeListResultIterator {
	return EncryptionScopeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eslr EncryptionScopeListResult) IsEmpty() bool {
	return eslr.Value == nil || len(*eslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eslr EncryptionScopeListResult) hasNextLink() bool {
	return eslr.NextLink != nil && len(*eslr.NextLink) != 0
}

// encryptionScopeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eslr EncryptionScopeListResult) encryptionScopeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eslr.NextLink)))
}

// EncryptionScopeListResultPage contains a page of EncryptionScope values.
type EncryptionScopeListResultPage struct {
	fn   func(context.Context, EncryptionScopeListResult) (EncryptionScopeListResult, error)
	eslr EncryptionScopeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionScopeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionScopeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eslr)
		if err != nil {
			return err
		}
		page.eslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionScopeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionScopeListResultPage) NotDone() bool {
	return !page.eslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionScopeListResultPage) Response() EncryptionScopeListResult {
	return page.eslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionScopeListResultPage) Values() []EncryptionScope {
	if page.eslr.IsEmpty() {
		return nil
	}
	return *page.eslr.Value
}

// Creates a new instance of the EncryptionScopeListResultPage type.
func NewEncryptionScopeListResultPage(cur EncryptionScopeListResult, getNextPage func(context.Context, EncryptionScopeListResult) (EncryptionScopeListResult, error)) EncryptionScopeListResultPage {
	return EncryptionScopeListResultPage{
		fn:   getNextPage,
		eslr: cur,
	}
}

// EncryptionScopeProperties properties of the encryption scope.
type EncryptionScopeProperties struct {
	// Source - The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible values include: 'MicrosoftStorage', 'MicrosoftKeyVault'
	Source EncryptionScopeSource `json:"source,omitempty"`
	// State - The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. Possible values include: 'Enabled', 'Disabled'
	State EncryptionScopeState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; Gets the creation date and time of the encryption scope in UTC.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Gets the last modification date and time of the encryption scope in UTC.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// KeyVaultProperties - The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
	KeyVaultProperties *EncryptionScopeKeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionScopeProperties.
func (esp EncryptionScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esp.Source != "" {
		objectMap["source"] = esp.Source
	}
	if esp.State != "" {
		objectMap["state"] = esp.State
	}
	if esp.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = esp.KeyVaultProperties
	}
	return json.Marshal(objectMap)
}

// EncryptionService a service that allows server-side encryption to be used.
type EncryptionService struct {
	// Enabled - A boolean indicating whether or not the service encrypts the data as it is stored.
	Enabled *bool `json:"enabled,omitempty"`
	// LastEnabledTime - READ-ONLY; Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
	// KeyType - Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used. Possible values include: 'KeyTypeService', 'KeyTypeAccount'
	KeyType KeyType `json:"keyType,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionService.
func (es EncryptionService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.Enabled != nil {
		objectMap["enabled"] = es.Enabled
	}
	if es.KeyType != "" {
		objectMap["keyType"] = es.KeyType
	}
	return json.Marshal(objectMap)
}

// EncryptionServices a list of services that support encryption.
type EncryptionServices struct {
	// Blob - The encryption function of the blob storage service.
	Blob *EncryptionService `json:"blob,omitempty"`
	// File - The encryption function of the file storage service.
	File *EncryptionService `json:"file,omitempty"`
	// Table - The encryption function of the table storage service.
	Table *EncryptionService `json:"table,omitempty"`
	// Queue - The encryption function of the queue storage service.
	Queue *EncryptionService `json:"queue,omitempty"`
}

// Endpoints the URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs
// object.
type Endpoints struct {
	// Blob - READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty"`
	// Queue - READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty"`
	// Table - READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty"`
	// File - READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty"`
	// Web - READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty"`
	// Dfs - READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty"`
	// MicrosoftEndpoints - Gets the microsoft routing storage endpoints.
	MicrosoftEndpoints *AccountMicrosoftEndpoints `json:"microsoftEndpoints,omitempty"`
	// InternetEndpoints - Gets the internet routing storage endpoints
	InternetEndpoints *AccountInternetEndpoints `json:"internetEndpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoints.
func (e Endpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.MicrosoftEndpoints != nil {
		objectMap["microsoftEndpoints"] = e.MicrosoftEndpoints
	}
	if e.InternetEndpoints != nil {
		objectMap["internetEndpoints"] = e.InternetEndpoints
	}
	return json.Marshal(objectMap)
}

// ErrorResponse an error response from the storage resource provider.
type ErrorResponse struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// FileServiceItems ...
type FileServiceItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of file services returned.
	Value *[]FileServiceProperties `json:"value,omitempty"`
}

// FileServiceProperties the properties of File services in storage account.
type FileServiceProperties struct {
	autorest.Response `json:"-"`
	// FileServicePropertiesProperties - The properties of File services in storage account.
	*FileServicePropertiesProperties `json:"properties,omitempty"`
	// Sku - READ-ONLY; Sku name and tier.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServiceProperties.
func (fsp FileServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.FileServicePropertiesProperties != nil {
		objectMap["properties"] = fsp.FileServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServiceProperties struct.
func (fsp *FileServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServiceProperties FileServicePropertiesProperties
				err = json.Unmarshal(*v, &fileServiceProperties)
				if err != nil {
					return err
				}
				fsp.FileServicePropertiesProperties = &fileServiceProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				fsp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fsp.Type = &typeVar
			}
		}
	}

	return nil
}

// FileServicePropertiesProperties the properties of File services in storage account.
type FileServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
	Cors *CorsRules `json:"cors,omitempty"`
	// ShareDeleteRetentionPolicy - The file service properties for share soft delete.
	ShareDeleteRetentionPolicy *DeleteRetentionPolicy `json:"shareDeleteRetentionPolicy,omitempty"`
}

// FileShare properties of the file share, including Id, resource name, resource type, Etag.
type FileShare struct {
	autorest.Response `json:"-"`
	// FileShareProperties - Properties of the file share.
	*FileShareProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShare.
func (fs FileShare) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileShareProperties != nil {
		objectMap["properties"] = fs.FileShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShare struct.
func (fs *FileShare) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareProperties FileShareProperties
				err = json.Unmarshal(*v, &fileShareProperties)
				if err != nil {
					return err
				}
				fs.FileShareProperties = &fileShareProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FileShareItem the file share properties be listed out.
type FileShareItem struct {
	// FileShareProperties - The file share properties be listed out.
	*FileShareProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShareItem.
func (fsi FileShareItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsi.FileShareProperties != nil {
		objectMap["properties"] = fsi.FileShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileShareItem struct.
func (fsi *FileShareItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileShareProperties FileShareProperties
				err = json.Unmarshal(*v, &fileShareProperties)
				if err != nil {
					return err
				}
				fsi.FileShareProperties = &fileShareProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fsi.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fsi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fsi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fsi.Type = &typeVar
			}
		}
	}

	return nil
}

// FileShareItems response schema. Contains list of shares returned, and if paging is requested or
// required, a URL to next page of shares.
type FileShareItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of file shares returned.
	Value *[]FileShareItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of shares. Returned when total number of requested shares exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// FileShareItemsIterator provides access to a complete listing of FileShareItem values.
type FileShareItemsIterator struct {
	i    int
	page FileShareItemsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileShareItemsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileShareItemsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FileShareItemsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileShareItemsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileShareItemsIterator) Response() FileShareItems {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileShareItemsIterator) Value() FileShareItem {
	if !iter.page.NotDone() {
		return FileShareItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FileShareItemsIterator type.
func NewFileShareItemsIterator(page FileShareItemsPage) FileShareItemsIterator {
	return FileShareItemsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fsi FileShareItems) IsEmpty() bool {
	return fsi.Value == nil || len(*fsi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fsi FileShareItems) hasNextLink() bool {
	return fsi.NextLink != nil && len(*fsi.NextLink) != 0
}

// fileShareItemsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fsi FileShareItems) fileShareItemsPreparer(ctx context.Context) (*http.Request, error) {
	if !fsi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fsi.NextLink)))
}

// FileShareItemsPage contains a page of FileShareItem values.
type FileShareItemsPage struct {
	fn  func(context.Context, FileShareItems) (FileShareItems, error)
	fsi FileShareItems
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileShareItemsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileShareItemsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fsi)
		if err != nil {
			return err
		}
		page.fsi = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FileShareItemsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileShareItemsPage) NotDone() bool {
	return !page.fsi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileShareItemsPage) Response() FileShareItems {
	return page.fsi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileShareItemsPage) Values() []FileShareItem {
	if page.fsi.IsEmpty() {
		return nil
	}
	return *page.fsi.Value
}

// Creates a new instance of the FileShareItemsPage type.
func NewFileShareItemsPage(cur FileShareItems, getNextPage func(context.Context, FileShareItems) (FileShareItems, error)) FileShareItemsPage {
	return FileShareItemsPage{
		fn:  getNextPage,
		fsi: cur,
	}
}

// FileShareProperties the properties of the file share.
type FileShareProperties struct {
	// LastModifiedTime - READ-ONLY; Returns the date and time the share was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Metadata - A name-value pair to associate with the share as metadata.
	Metadata map[string]*string `json:"metadata"`
	// ShareQuota - The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
	ShareQuota *int32 `json:"shareQuota,omitempty"`
	// EnabledProtocols - The authentication protocol that is used for the file share. Can only be specified when creating a share. Possible values include: 'SMB', 'NFS'
	EnabledProtocols EnabledProtocols `json:"enabledProtocols,omitempty"`
	// RootSquash - The property is for NFS share only. The default is NoRootSquash. Possible values include: 'NoRootSquash', 'RootSquash', 'AllSquash'
	RootSquash RootSquashType `json:"rootSquash,omitempty"`
	// Version - READ-ONLY; The version of the share.
	Version *string `json:"version,omitempty"`
	// Deleted - READ-ONLY; Indicates whether the share was deleted.
	Deleted *bool `json:"deleted,omitempty"`
	// DeletedTime - READ-ONLY; The deleted time if the share was deleted.
	DeletedTime *date.Time `json:"deletedTime,omitempty"`
	// RemainingRetentionDays - READ-ONLY; Remaining retention days for share that was soft deleted.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty"`
	// AccessTier - Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Possible values include: 'ShareAccessTierTransactionOptimized', 'ShareAccessTierHot', 'ShareAccessTierCool', 'ShareAccessTierPremium'
	AccessTier ShareAccessTier `json:"accessTier,omitempty"`
	// AccessTierChangeTime - READ-ONLY; Indicates the last modification time for share access tier.
	AccessTierChangeTime *date.Time `json:"accessTierChangeTime,omitempty"`
	// AccessTierStatus - READ-ONLY; Indicates if there is a pending transition for access tier.
	AccessTierStatus *string `json:"accessTierStatus,omitempty"`
	// ShareUsageBytes - READ-ONLY; The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files.
	ShareUsageBytes *int64 `json:"shareUsageBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for FileShareProperties.
func (fsp FileShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.Metadata != nil {
		objectMap["metadata"] = fsp.Metadata
	}
	if fsp.ShareQuota != nil {
		objectMap["shareQuota"] = fsp.ShareQuota
	}
	if fsp.EnabledProtocols != "" {
		objectMap["enabledProtocols"] = fsp.EnabledProtocols
	}
	if fsp.RootSquash != "" {
		objectMap["rootSquash"] = fsp.RootSquash
	}
	if fsp.AccessTier != "" {
		objectMap["accessTier"] = fsp.AccessTier
	}
	return json.Marshal(objectMap)
}

// GeoReplicationStats statistics related to replication for storage account's Blob, Table, Queue and File
// services. It is only available when geo-redundant replication is enabled for the storage account.
type GeoReplicationStats struct {
	// Status - READ-ONLY; The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable. Possible values include: 'GeoReplicationStatusLive', 'GeoReplicationStatusBootstrap', 'GeoReplicationStatusUnavailable'
	Status GeoReplicationStatus `json:"status,omitempty"`
	// LastSyncTime - READ-ONLY; All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// CanFailover - READ-ONLY; A boolean flag which indicates whether or not account failover is supported for the account.
	CanFailover *bool `json:"canFailover,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// ImmutabilityPolicy the ImmutabilityPolicy property of a blob container, including Id, resource name,
// resource type, Etag.
type ImmutabilityPolicy struct {
	autorest.Response `json:"-"`
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicy.
func (IP ImmutabilityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = IP.ImmutabilityPolicyProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicy struct.
func (IP *ImmutabilityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				IP.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				IP.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperties the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperties struct {
	// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
	*ImmutabilityPolicyProperty `json:"properties,omitempty"`
	// Etag - READ-ONLY; ImmutabilityPolicy Etag.
	Etag *string `json:"etag,omitempty"`
	// UpdateHistory - READ-ONLY; The ImmutabilityPolicy update history of the blob container.
	UpdateHistory *[]UpdateHistoryProperty `json:"updateHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicyProperties.
func (ipp ImmutabilityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.ImmutabilityPolicyProperty != nil {
		objectMap["properties"] = ipp.ImmutabilityPolicyProperty
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImmutabilityPolicyProperties struct.
func (ipp *ImmutabilityPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var immutabilityPolicyProperty ImmutabilityPolicyProperty
				err = json.Unmarshal(*v, &immutabilityPolicyProperty)
				if err != nil {
					return err
				}
				ipp.ImmutabilityPolicyProperty = &immutabilityPolicyProperty
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ipp.Etag = &etag
			}
		case "updateHistory":
			if v != nil {
				var updateHistory []UpdateHistoryProperty
				err = json.Unmarshal(*v, &updateHistory)
				if err != nil {
					return err
				}
				ipp.UpdateHistory = &updateHistory
			}
		}
	}

	return nil
}

// ImmutabilityPolicyProperty the properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperty struct {
	// ImmutabilityPeriodSinceCreationInDays - The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// State - READ-ONLY; The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked. Possible values include: 'Locked', 'Unlocked'
	State ImmutabilityPolicyState `json:"state,omitempty"`
	// AllowProtectedAppendWrites - This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmutabilityPolicyProperty.
func (ipp ImmutabilityPolicyProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.ImmutabilityPeriodSinceCreationInDays != nil {
		objectMap["immutabilityPeriodSinceCreationInDays"] = ipp.ImmutabilityPeriodSinceCreationInDays
	}
	if ipp.AllowProtectedAppendWrites != nil {
		objectMap["allowProtectedAppendWrites"] = ipp.AllowProtectedAppendWrites
	}
	return json.Marshal(objectMap)
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
	// Action - The action of IP ACL rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
}

// KeyVaultProperties properties of key vault.
type KeyVaultProperties struct {
	// KeyName - The name of KeyVault key.
	KeyName *string `json:"keyname,omitempty"`
	// KeyVersion - The version of KeyVault key.
	KeyVersion *string `json:"keyversion,omitempty"`
	// KeyVaultURI - The Uri of KeyVault.
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`
	// CurrentVersionedKeyIdentifier - READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty"`
	// LastKeyRotationTimestamp - READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *date.Time `json:"lastKeyRotationTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyName != nil {
		objectMap["keyname"] = kvp.KeyName
	}
	if kvp.KeyVersion != nil {
		objectMap["keyversion"] = kvp.KeyVersion
	}
	if kvp.KeyVaultURI != nil {
		objectMap["keyvaulturi"] = kvp.KeyVaultURI
	}
	return json.Marshal(objectMap)
}

// LeaseContainerRequest lease Container request schema.
type LeaseContainerRequest struct {
	// Action - Specifies the lease action. Can be one of the available actions. Possible values include: 'Acquire', 'Renew', 'Change', 'Release', 'Break'
	Action Action1 `json:"action,omitempty"`
	// LeaseID - Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string `json:"leaseId,omitempty"`
	// BreakPeriod - Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60.
	BreakPeriod *int32 `json:"breakPeriod,omitempty"`
	// LeaseDuration - Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32 `json:"leaseDuration,omitempty"`
	// ProposedLeaseID - Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string `json:"proposedLeaseId,omitempty"`
}

// LeaseContainerResponse lease Container response schema.
type LeaseContainerResponse struct {
	autorest.Response `json:"-"`
	// LeaseID - Returned unique lease ID that must be included with any request to delete the container, or to renew, change, or release the lease.
	LeaseID *string `json:"leaseId,omitempty"`
	// LeaseTimeSeconds - Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string `json:"leaseTimeSeconds,omitempty"`
}

// LegalHold the LegalHold property of a blob container.
type LegalHold struct {
	autorest.Response `json:"-"`
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for LegalHold.
func (lh LegalHold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lh.Tags != nil {
		objectMap["tags"] = lh.Tags
	}
	return json.Marshal(objectMap)
}

// LegalHoldProperties the LegalHold property of a blob container.
type LegalHoldProperties struct {
	// HasLegalHold - READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty"`
	// Tags - The list of LegalHold tags of a blob container.
	Tags *[]TagProperty `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for LegalHoldProperties.
func (lhp LegalHoldProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lhp.Tags != nil {
		objectMap["tags"] = lhp.Tags
	}
	return json.Marshal(objectMap)
}

// ListAccountSasResponse the List SAS credentials operation response.
type ListAccountSasResponse struct {
	autorest.Response `json:"-"`
	// AccountSasToken - READ-ONLY; List SAS credentials of storage account.
	AccountSasToken *string `json:"accountSasToken,omitempty"`
}

// ListContainerItem the blob container properties be listed out.
type ListContainerItem struct {
	// ContainerProperties - The blob container properties be listed out.
	*ContainerProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ListContainerItem.
func (lci ListContainerItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lci.ContainerProperties != nil {
		objectMap["properties"] = lci.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListContainerItem struct.
func (lci *ListContainerItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				lci.ContainerProperties = &containerProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lci.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lci.Type = &typeVar
			}
		}
	}

	return nil
}

// ListContainerItems response schema. Contains list of blobs returned, and if paging is requested or
// required, a URL to next page of containers.
type ListContainerItems struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of blobs containers returned.
	Value *[]ListContainerItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListContainerItemsIterator provides access to a complete listing of ListContainerItem values.
type ListContainerItemsIterator struct {
	i    int
	page ListContainerItemsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListContainerItemsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListContainerItemsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListContainerItemsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListContainerItemsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListContainerItemsIterator) Response() ListContainerItems {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListContainerItemsIterator) Value() ListContainerItem {
	if !iter.page.NotDone() {
		return ListContainerItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListContainerItemsIterator type.
func NewListContainerItemsIterator(page ListContainerItemsPage) ListContainerItemsIterator {
	return ListContainerItemsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lci ListContainerItems) IsEmpty() bool {
	return lci.Value == nil || len(*lci.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lci ListContainerItems) hasNextLink() bool {
	return lci.NextLink != nil && len(*lci.NextLink) != 0
}

// listContainerItemsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lci ListContainerItems) listContainerItemsPreparer(ctx context.Context) (*http.Request, error) {
	if !lci.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lci.NextLink)))
}

// ListContainerItemsPage contains a page of ListContainerItem values.
type ListContainerItemsPage struct {
	fn  func(context.Context, ListContainerItems) (ListContainerItems, error)
	lci ListContainerItems
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListContainerItemsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListContainerItemsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lci)
		if err != nil {
			return err
		}
		page.lci = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListContainerItemsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListContainerItemsPage) NotDone() bool {
	return !page.lci.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListContainerItemsPage) Response() ListContainerItems {
	return page.lci
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListContainerItemsPage) Values() []ListContainerItem {
	if page.lci.IsEmpty() {
		return nil
	}
	return *page.lci.Value
}

// Creates a new instance of the ListContainerItemsPage type.
func NewListContainerItemsPage(cur ListContainerItems, getNextPage func(context.Context, ListContainerItems) (ListContainerItems, error)) ListContainerItemsPage {
	return ListContainerItemsPage{
		fn:  getNextPage,
		lci: cur,
	}
}

// ListQueue ...
type ListQueue struct {
	// ListQueueProperties - List Queue resource properties.
	*ListQueueProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ListQueue.
func (lq ListQueue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lq.ListQueueProperties != nil {
		objectMap["properties"] = lq.ListQueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ListQueue struct.
func (lq *ListQueue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueProperties ListQueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				lq.ListQueueProperties = &queueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lq.Type = &typeVar
			}
		}
	}

	return nil
}

// ListQueueProperties ...
type ListQueueProperties struct {
	// Metadata - A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata"`
}

// MarshalJSON is the custom marshaler for ListQueueProperties.
func (lqp ListQueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lqp.Metadata != nil {
		objectMap["metadata"] = lqp.Metadata
	}
	return json.Marshal(objectMap)
}

// ListQueueResource response schema. Contains list of queues returned
type ListQueueResource struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of queues returned.
	Value *[]ListQueue `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to list next page of queues
	NextLink *string `json:"nextLink,omitempty"`
}

// ListQueueResourceIterator provides access to a complete listing of ListQueue values.
type ListQueueResourceIterator struct {
	i    int
	page ListQueueResourcePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListQueueResourceIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListQueueResourceIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListQueueResourceIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListQueueResourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListQueueResourceIterator) Response() ListQueueResource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListQueueResourceIterator) Value() ListQueue {
	if !iter.page.NotDone() {
		return ListQueue{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListQueueResourceIterator type.
func NewListQueueResourceIterator(page ListQueueResourcePage) ListQueueResourceIterator {
	return ListQueueResourceIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lqr ListQueueResource) IsEmpty() bool {
	return lqr.Value == nil || len(*lqr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lqr ListQueueResource) hasNextLink() bool {
	return lqr.NextLink != nil && len(*lqr.NextLink) != 0
}

// listQueueResourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lqr ListQueueResource) listQueueResourcePreparer(ctx context.Context) (*http.Request, error) {
	if !lqr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lqr.NextLink)))
}

// ListQueueResourcePage contains a page of ListQueue values.
type ListQueueResourcePage struct {
	fn  func(context.Context, ListQueueResource) (ListQueueResource, error)
	lqr ListQueueResource
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListQueueResourcePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListQueueResourcePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lqr)
		if err != nil {
			return err
		}
		page.lqr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListQueueResourcePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListQueueResourcePage) NotDone() bool {
	return !page.lqr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListQueueResourcePage) Response() ListQueueResource {
	return page.lqr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListQueueResourcePage) Values() []ListQueue {
	if page.lqr.IsEmpty() {
		return nil
	}
	return *page.lqr.Value
}

// Creates a new instance of the ListQueueResourcePage type.
func NewListQueueResourcePage(cur ListQueueResource, getNextPage func(context.Context, ListQueueResource) (ListQueueResource, error)) ListQueueResourcePage {
	return ListQueueResourcePage{
		fn:  getNextPage,
		lqr: cur,
	}
}

// ListQueueServices ...
type ListQueueServices struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of queue services returned.
	Value *[]QueueServiceProperties `json:"value,omitempty"`
}

// ListServiceSasResponse the List service SAS credentials operation response.
type ListServiceSasResponse struct {
	autorest.Response `json:"-"`
	// ServiceSasToken - READ-ONLY; List service SAS credentials of specific resource.
	ServiceSasToken *string `json:"serviceSasToken,omitempty"`
}

// ListTableResource response schema. Contains list of tables returned
type ListTableResource struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of tables returned.
	Value *[]Table `json:"value,omitempty"`
	// NextLink - READ-ONLY; Request URL that can be used to query next page of tables
	NextLink *string `json:"nextLink,omitempty"`
}

// ListTableResourceIterator provides access to a complete listing of Table values.
type ListTableResourceIterator struct {
	i    int
	page ListTableResourcePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListTableResourceIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListTableResourceIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListTableResourceIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListTableResourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListTableResourceIterator) Response() ListTableResource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListTableResourceIterator) Value() Table {
	if !iter.page.NotDone() {
		return Table{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListTableResourceIterator type.
func NewListTableResourceIterator(page ListTableResourcePage) ListTableResourceIterator {
	return ListTableResourceIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ltr ListTableResource) IsEmpty() bool {
	return ltr.Value == nil || len(*ltr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ltr ListTableResource) hasNextLink() bool {
	return ltr.NextLink != nil && len(*ltr.NextLink) != 0
}

// listTableResourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ltr ListTableResource) listTableResourcePreparer(ctx context.Context) (*http.Request, error) {
	if !ltr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ltr.NextLink)))
}

// ListTableResourcePage contains a page of Table values.
type ListTableResourcePage struct {
	fn  func(context.Context, ListTableResource) (ListTableResource, error)
	ltr ListTableResource
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListTableResourcePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListTableResourcePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ltr)
		if err != nil {
			return err
		}
		page.ltr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListTableResourcePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListTableResourcePage) NotDone() bool {
	return !page.ltr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListTableResourcePage) Response() ListTableResource {
	return page.ltr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListTableResourcePage) Values() []Table {
	if page.ltr.IsEmpty() {
		return nil
	}
	return *page.ltr.Value
}

// Creates a new instance of the ListTableResourcePage type.
func NewListTableResourcePage(cur ListTableResource, getNextPage func(context.Context, ListTableResource) (ListTableResource, error)) ListTableResourcePage {
	return ListTableResourcePage{
		fn:  getNextPage,
		ltr: cur,
	}
}

// ListTableServices ...
type ListTableServices struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of table services returned.
	Value *[]TableServiceProperties `json:"value,omitempty"`
}

// ManagementPolicy the Get Storage Account ManagementPolicies operation response.
type ManagementPolicy struct {
	autorest.Response `json:"-"`
	// ManagementPolicyProperties - Returns the Storage Account Data Policies Rules.
	*ManagementPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementPolicy.
func (mp ManagementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.ManagementPolicyProperties != nil {
		objectMap["properties"] = mp.ManagementPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementPolicy struct.
func (mp *ManagementPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementPolicyProperties ManagementPolicyProperties
				err = json.Unmarshal(*v, &managementPolicyProperties)
				if err != nil {
					return err
				}
				mp.ManagementPolicyProperties = &managementPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagementPolicyAction actions are applied to the filtered blobs when the execution condition is met.
type ManagementPolicyAction struct {
	// BaseBlob - The management policy action for base blob
	BaseBlob *ManagementPolicyBaseBlob `json:"baseBlob,omitempty"`
	// Snapshot - The management policy action for snapshot
	Snapshot *ManagementPolicySnapShot `json:"snapshot,omitempty"`
}

// ManagementPolicyBaseBlob management policy action for base blob.
type ManagementPolicyBaseBlob struct {
	// TierToCool - The function to tier blobs to cool storage. Support blobs currently at Hot tier
	TierToCool *DateAfterModification `json:"tierToCool,omitempty"`
	// TierToArchive - The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
	TierToArchive *DateAfterModification `json:"tierToArchive,omitempty"`
	// Delete - The function to delete the blob
	Delete *DateAfterModification `json:"delete,omitempty"`
}

// ManagementPolicyDefinition an object that defines the Lifecycle rule. Each definition is made up with a
// filters set and an actions set.
type ManagementPolicyDefinition struct {
	// Actions - An object that defines the action set.
	Actions *ManagementPolicyAction `json:"actions,omitempty"`
	// Filters - An object that defines the filter set.
	Filters *ManagementPolicyFilter `json:"filters,omitempty"`
}

// ManagementPolicyFilter filters limit rule actions to a subset of blobs within the storage account. If
// multiple filters are defined, a logical AND is performed on all filters.
type ManagementPolicyFilter struct {
	// PrefixMatch - An array of strings for prefixes to be match.
	PrefixMatch *[]string `json:"prefixMatch,omitempty"`
	// BlobTypes - An array of predefined enum values. Only blockBlob is supported.
	BlobTypes *[]string `json:"blobTypes,omitempty"`
	// BlobIndexMatch - An array of blob index tag based filters, there can be at most 10 tag filters
	BlobIndexMatch *[]TagFilter `json:"blobIndexMatch,omitempty"`
}

// ManagementPolicyProperties the Storage Account ManagementPolicy properties.
type ManagementPolicyProperties struct {
	// LastModifiedTime - READ-ONLY; Returns the date and time the ManagementPolicies was last modified.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Policy - The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Policy *ManagementPolicySchema `json:"policy,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementPolicyProperties.
func (mpp ManagementPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpp.Policy != nil {
		objectMap["policy"] = mpp.Policy
	}
	return json.Marshal(objectMap)
}

// ManagementPolicyRule an object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
type ManagementPolicyRule struct {
	// Enabled - Rule is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Name - A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
	Name *string `json:"name,omitempty"`
	// Type - The valid value is Lifecycle
	Type *string `json:"type,omitempty"`
	// Definition - An object that defines the Lifecycle rule.
	Definition *ManagementPolicyDefinition `json:"definition,omitempty"`
}

// ManagementPolicySchema the Storage Account ManagementPolicies Rules. See more details in:
// https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
type ManagementPolicySchema struct {
	// Rules - The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Rules *[]ManagementPolicyRule `json:"rules,omitempty"`
}

// ManagementPolicySnapShot management policy action for snapshot.
type ManagementPolicySnapShot struct {
	// Delete - The function to delete the blob snapshot
	Delete *DateAfterCreation `json:"delete,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// NetworkRuleSet network rule set
type NetworkRuleSet struct {
	// Bypass - Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics. Possible values include: 'None', 'Logging', 'Metrics', 'AzureServices'
	Bypass Bypass `json:"bypass,omitempty"`
	// VirtualNetworkRules - Sets the virtual network rules
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - Sets the IP ACL rules
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// DefaultAction - Specifies the default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
}

// ObjectReplicationPolicies list storage account object replication policies.
type ObjectReplicationPolicies struct {
	autorest.Response `json:"-"`
	// Value - The replication policy between two storage accounts.
	Value *[]ObjectReplicationPolicy `json:"value,omitempty"`
}

// ObjectReplicationPolicy the replication policy between two storage accounts. Multiple rules can be
// defined in one policy.
type ObjectReplicationPolicy struct {
	autorest.Response `json:"-"`
	// ObjectReplicationPolicyProperties - Returns the Storage Account Object Replication Policy.
	*ObjectReplicationPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ObjectReplicationPolicy.
func (orp ObjectReplicationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orp.ObjectReplicationPolicyProperties != nil {
		objectMap["properties"] = orp.ObjectReplicationPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ObjectReplicationPolicy struct.
func (orp *ObjectReplicationPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var objectReplicationPolicyProperties ObjectReplicationPolicyProperties
				err = json.Unmarshal(*v, &objectReplicationPolicyProperties)
				if err != nil {
					return err
				}
				orp.ObjectReplicationPolicyProperties = &objectReplicationPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				orp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				orp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				orp.Type = &typeVar
			}
		}
	}

	return nil
}

// ObjectReplicationPolicyFilter filters limit replication to a subset of blobs within the storage account.
// A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is
// performed on all filters.
type ObjectReplicationPolicyFilter struct {
	// PrefixMatch - Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
	PrefixMatch *[]string `json:"prefixMatch,omitempty"`
	// MinCreationTime - Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
	MinCreationTime *string `json:"minCreationTime,omitempty"`
}

// ObjectReplicationPolicyProperties the Storage Account ObjectReplicationPolicy properties.
type ObjectReplicationPolicyProperties struct {
	// PolicyID - READ-ONLY; A unique id for object replication policy.
	PolicyID *string `json:"policyId,omitempty"`
	// EnabledTime - READ-ONLY; Indicates when the policy is enabled on the source account.
	EnabledTime *date.Time `json:"enabledTime,omitempty"`
	// SourceAccount - Required. Source account name.
	SourceAccount *string `json:"sourceAccount,omitempty"`
	// DestinationAccount - Required. Destination account name.
	DestinationAccount *string `json:"destinationAccount,omitempty"`
	// Rules - The storage account object replication rules.
	Rules *[]ObjectReplicationPolicyRule `json:"rules,omitempty"`
}

// MarshalJSON is the custom marshaler for ObjectReplicationPolicyProperties.
func (orpp ObjectReplicationPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orpp.SourceAccount != nil {
		objectMap["sourceAccount"] = orpp.SourceAccount
	}
	if orpp.DestinationAccount != nil {
		objectMap["destinationAccount"] = orpp.DestinationAccount
	}
	if orpp.Rules != nil {
		objectMap["rules"] = orpp.Rules
	}
	return json.Marshal(objectMap)
}

// ObjectReplicationPolicyRule the replication policy rule between two containers.
type ObjectReplicationPolicyRule struct {
	// RuleID - Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
	RuleID *string `json:"ruleId,omitempty"`
	// SourceContainer - Required. Source container name.
	SourceContainer *string `json:"sourceContainer,omitempty"`
	// DestinationContainer - Required. Destination container name.
	DestinationContainer *string `json:"destinationContainer,omitempty"`
	// Filters - Optional. An object that defines the filter set.
	Filters *ObjectReplicationPolicyFilter `json:"filters,omitempty"`
}

// Operation storage REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Storage.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Storage operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'Pending', 'Approved', 'Rejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string `json:"actionRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Queue ...
type Queue struct {
	autorest.Response `json:"-"`
	// QueueProperties - Queue resource properties.
	*QueueProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Queue.
func (q Queue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.QueueProperties != nil {
		objectMap["properties"] = q.QueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Queue struct.
func (q *Queue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueProperties QueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				q.QueueProperties = &queueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				q.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				q.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				q.Type = &typeVar
			}
		}
	}

	return nil
}

// QueueProperties ...
type QueueProperties struct {
	// Metadata - A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata"`
	// ApproximateMessageCount - READ-ONLY; Integer indicating an approximate number of messages in the queue. This number is not lower than the actual number of messages in the queue, but could be higher.
	ApproximateMessageCount *int32 `json:"approximateMessageCount,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueProperties.
func (qp QueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qp.Metadata != nil {
		objectMap["metadata"] = qp.Metadata
	}
	return json.Marshal(objectMap)
}

// QueueServiceProperties the properties of a storage account’s Queue service.
type QueueServiceProperties struct {
	autorest.Response `json:"-"`
	// QueueServicePropertiesProperties - The properties of a storage account’s Queue service.
	*QueueServicePropertiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueServiceProperties.
func (qsp QueueServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qsp.QueueServicePropertiesProperties != nil {
		objectMap["properties"] = qsp.QueueServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueueServiceProperties struct.
func (qsp *QueueServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueServiceProperties QueueServicePropertiesProperties
				err = json.Unmarshal(*v, &queueServiceProperties)
				if err != nil {
					return err
				}
				qsp.QueueServicePropertiesProperties = &queueServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qsp.Type = &typeVar
			}
		}
	}

	return nil
}

// QueueServicePropertiesProperties the properties of a storage account’s Queue service.
type QueueServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Queue service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// RestorePolicyProperties the blob service properties for blob restore policy
type RestorePolicyProperties struct {
	// Enabled - Blob restore is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
	Days *int32 `json:"days,omitempty"`
	// LastEnabledTime - READ-ONLY; Deprecated in favor of minRestoreTime property.
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
	// MinRestoreTime - READ-ONLY; Returns the minimum date and time that the restore can be started.
	MinRestoreTime *date.Time `json:"minRestoreTime,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePolicyProperties.
func (rpp RestorePolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpp.Enabled != nil {
		objectMap["enabled"] = rpp.Enabled
	}
	if rpp.Days != nil {
		objectMap["days"] = rpp.Days
	}
	return json.Marshal(objectMap)
}

// Restriction the restriction because of which SKU cannot be used.
type Restriction struct {
	// Type - READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReasonCode != "" {
		objectMap["reasonCode"] = r.ReasonCode
	}
	return json.Marshal(objectMap)
}

// RoutingPreference routing preference defines the type of network, either microsoft or internet routing
// to be used to deliver the user data, the default option is microsoft routing
type RoutingPreference struct {
	// RoutingChoice - Routing Choice defines the kind of network routing opted by the user. Possible values include: 'MicrosoftRouting', 'InternetRouting'
	RoutingChoice RoutingChoice `json:"routingChoice,omitempty"`
	// PublishMicrosoftEndpoints - A boolean flag which indicates whether microsoft routing storage endpoints are to be published
	PublishMicrosoftEndpoints *bool `json:"publishMicrosoftEndpoints,omitempty"`
	// PublishInternetEndpoints - A boolean flag which indicates whether internet routing storage endpoints are to be published
	PublishInternetEndpoints *bool `json:"publishInternetEndpoints,omitempty"`
}

// ServiceSasParameters the parameters to list service SAS credentials of a specific resource.
type ServiceSasParameters struct {
	// CanonicalizedResource - The canonical path to the signed resource.
	CanonicalizedResource *string `json:"canonicalizedResource,omitempty"`
	// Resource - The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s). Possible values include: 'SignedResourceB', 'SignedResourceC', 'SignedResourceF', 'SignedResourceS'
	Resource SignedResource `json:"signedResource,omitempty"`
	// Permissions - The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible values include: 'R', 'D', 'W', 'L', 'A', 'C', 'U', 'P'
	Permissions Permissions `json:"signedPermission,omitempty"`
	// IPAddressOrRange - An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`
	// Protocols - The protocol permitted for a request made with the account SAS. Possible values include: 'Httpshttp', 'HTTPS'
	Protocols HTTPProtocol `json:"signedProtocol,omitempty"`
	// SharedAccessStartTime - The time at which the SAS becomes valid.
	SharedAccessStartTime *date.Time `json:"signedStart,omitempty"`
	// SharedAccessExpiryTime - The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *date.Time `json:"signedExpiry,omitempty"`
	// Identifier - A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
	Identifier *string `json:"signedIdentifier,omitempty"`
	// PartitionKeyStart - The start of partition key.
	PartitionKeyStart *string `json:"startPk,omitempty"`
	// PartitionKeyEnd - The end of partition key.
	PartitionKeyEnd *string `json:"endPk,omitempty"`
	// RowKeyStart - The start of row key.
	RowKeyStart *string `json:"startRk,omitempty"`
	// RowKeyEnd - The end of row key.
	RowKeyEnd *string `json:"endRk,omitempty"`
	// KeyToSign - The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`
	// CacheControl - The response header override for cache control.
	CacheControl *string `json:"rscc,omitempty"`
	// ContentDisposition - The response header override for content disposition.
	ContentDisposition *string `json:"rscd,omitempty"`
	// ContentEncoding - The response header override for content encoding.
	ContentEncoding *string `json:"rsce,omitempty"`
	// ContentLanguage - The response header override for content language.
	ContentLanguage *string `json:"rscl,omitempty"`
	// ContentType - The response header override for content type.
	ContentType *string `json:"rsct,omitempty"`
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku the SKU of the storage account.
type Sku struct {
	// Name - Possible values include: 'StandardLRS', 'StandardGRS', 'StandardRAGRS', 'StandardZRS', 'PremiumLRS', 'PremiumZRS', 'StandardGZRS', 'StandardRAGZRS'
	Name SkuName `json:"name,omitempty"`
	// Tier - Possible values include: 'Standard', 'Premium'
	Tier SkuTier `json:"tier,omitempty"`
}

// SKUCapability the capability information in the specified SKU, including file encryption, network ACLs,
// change notification, etc.
type SKUCapability struct {
	// Name - READ-ONLY; The name of capability, The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string `json:"value,omitempty"`
}

// SkuInformation storage SKU and its properties
type SkuInformation struct {
	// Name - Possible values include: 'StandardLRS', 'StandardGRS', 'StandardRAGRS', 'StandardZRS', 'PremiumLRS', 'PremiumZRS', 'StandardGZRS', 'StandardRAGZRS'
	Name SkuName `json:"name,omitempty"`
	// Tier - Possible values include: 'Standard', 'Premium'
	Tier SkuTier `json:"tier,omitempty"`
	// ResourceType - READ-ONLY; The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string `json:"resourceType,omitempty"`
	// Kind - READ-ONLY; Indicates the type of storage account. Possible values include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'
	Kind Kind `json:"kind,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - READ-ONLY; The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]Restriction `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.Name != "" {
		objectMap["name"] = si.Name
	}
	if si.Tier != "" {
		objectMap["tier"] = si.Tier
	}
	if si.Restrictions != nil {
		objectMap["restrictions"] = si.Restrictions
	}
	return json.Marshal(objectMap)
}

// SkuListResult the response from the List Storage SKUs operation.
type SkuListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Get the list result of storage SKUs and their properties.
	Value *[]SkuInformation `json:"value,omitempty"`
}

// Table properties of the table, including Id, resource name, resource type.
type Table struct {
	autorest.Response `json:"-"`
	// TableProperties - Table resource properties.
	*TableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Table.
func (t Table) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TableProperties != nil {
		objectMap["properties"] = t.TableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Table struct.
func (t *Table) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableProperties TableProperties
				err = json.Unmarshal(*v, &tableProperties)
				if err != nil {
					return err
				}
				t.TableProperties = &tableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TableProperties ...
type TableProperties struct {
	// TableName - READ-ONLY; Table name under the specified account
	TableName *string `json:"tableName,omitempty"`
}

// TableServiceProperties the properties of a storage account’s Table service.
type TableServiceProperties struct {
	autorest.Response `json:"-"`
	// TableServicePropertiesProperties - The properties of a storage account’s Table service.
	*TableServicePropertiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TableServiceProperties.
func (tsp TableServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsp.TableServicePropertiesProperties != nil {
		objectMap["properties"] = tsp.TableServicePropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableServiceProperties struct.
func (tsp *TableServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableServiceProperties TableServicePropertiesProperties
				err = json.Unmarshal(*v, &tableServiceProperties)
				if err != nil {
					return err
				}
				tsp.TableServicePropertiesProperties = &tableServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsp.Type = &typeVar
			}
		}
	}

	return nil
}

// TableServicePropertiesProperties the properties of a storage account’s Table service.
type TableServicePropertiesProperties struct {
	// Cors - Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Table service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// TagFilter blob index tag based filtering for blob objects
type TagFilter struct {
	// Name - This is the filter tag name, it can have 1 - 128 characters
	Name *string `json:"name,omitempty"`
	// Op - This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
	Op *string `json:"op,omitempty"`
	// Value - This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
	Value *string `json:"value,omitempty"`
}

// TagProperty a tag of the LegalHold of a blob container.
type TagProperty struct {
	// Tag - READ-ONLY; The tag value.
	Tag *string `json:"tag,omitempty"`
	// Timestamp - READ-ONLY; Returns the date and time the tag was added.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - READ-ONLY; Returns the Object ID of the user who added the tag.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - READ-ONLY; Returns the Tenant ID that issued the token for the user who added the tag.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - READ-ONLY; Returns the User Principal Name of the user who added the tag.
	Upn *string `json:"upn,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateHistoryProperty an update history of the ImmutabilityPolicy of a blob container.
type UpdateHistoryProperty struct {
	// Update - READ-ONLY; The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend. Possible values include: 'Put', 'Lock', 'Extend'
	Update ImmutabilityPolicyUpdateType `json:"update,omitempty"`
	// ImmutabilityPeriodSinceCreationInDays - READ-ONLY; The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`
	// Timestamp - READ-ONLY; Returns the date and time the ImmutabilityPolicy was updated.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ObjectIdentifier - READ-ONLY; Returns the Object ID of the user who updated the ImmutabilityPolicy.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty"`
	// TenantID - READ-ONLY; Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
	TenantID *string `json:"tenantId,omitempty"`
	// Upn - READ-ONLY; Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
	Upn *string `json:"upn,omitempty"`
}

// Usage describes Storage Resource Usage.
type Usage struct {
	// Unit - READ-ONLY; Gets the unit of measurement. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountsPerSecond', 'BytesPerSecond'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty"`
	// Name - READ-ONLY; Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageListResult the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of Storage Resource Usages.
	Value *[]Usage `json:"value,omitempty"`
}

// UsageName the usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// Value - READ-ONLY; Gets a string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VirtualNetworkRule virtual Network rule.
type VirtualNetworkRule struct {
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
	// Action - The action of virtual network rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// State - Gets the state of virtual network rule. Possible values include: 'StateProvisioning', 'StateDeprovisioning', 'StateSucceeded', 'StateFailed', 'StateNetworkSourceDeleted'
	State State `json:"state,omitempty"`
}
