package managedapplications

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplianceArtifactType enumerates the values for appliance artifact type.
type ApplianceArtifactType string

const (
	// Custom ...
	Custom ApplianceArtifactType = "Custom"
	// Template ...
	Template ApplianceArtifactType = "Template"
)

// PossibleApplianceArtifactTypeValues returns an array of possible values for the ApplianceArtifactType const type.
func PossibleApplianceArtifactTypeValues() []ApplianceArtifactType {
	return []ApplianceArtifactType{Custom, Template}
}

// ApplianceLockLevel enumerates the values for appliance lock level.
type ApplianceLockLevel string

const (
	// CanNotDelete ...
	CanNotDelete ApplianceLockLevel = "CanNotDelete"
	// None ...
	None ApplianceLockLevel = "None"
	// ReadOnly ...
	ReadOnly ApplianceLockLevel = "ReadOnly"
)

// PossibleApplianceLockLevelValues returns an array of possible values for the ApplianceLockLevel const type.
func PossibleApplianceLockLevelValues() []ApplianceLockLevel {
	return []ApplianceLockLevel{CanNotDelete, None, ReadOnly}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Created ...
	Created ProvisioningState = "Created"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleted ...
	Deleted ProvisioningState = "Deleted"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Ready ...
	Ready ProvisioningState = "Ready"
	// Running ...
	Running ProvisioningState = "Running"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Canceled, Created, Creating, Deleted, Deleting, Failed, Ready, Running, Succeeded, Updating}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}
