package kubernetesconfiguration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ComplianceStateType enumerates the values for compliance state type.
type ComplianceStateType string

const (
	// Compliant ...
	Compliant ComplianceStateType = "Compliant"
	// Failed ...
	Failed ComplianceStateType = "Failed"
	// Installed ...
	Installed ComplianceStateType = "Installed"
	// Noncompliant ...
	Noncompliant ComplianceStateType = "Noncompliant"
	// Pending ...
	Pending ComplianceStateType = "Pending"
)

// PossibleComplianceStateTypeValues returns an array of possible values for the ComplianceStateType const type.
func PossibleComplianceStateTypeValues() []ComplianceStateType {
	return []ComplianceStateType{Compliant, Failed, Installed, Noncompliant, Pending}
}

// InstallStateType enumerates the values for install state type.
type InstallStateType string

const (
	// InstallStateTypeFailed ...
	InstallStateTypeFailed InstallStateType = "Failed"
	// InstallStateTypeInstalled ...
	InstallStateTypeInstalled InstallStateType = "Installed"
	// InstallStateTypePending ...
	InstallStateTypePending InstallStateType = "Pending"
)

// PossibleInstallStateTypeValues returns an array of possible values for the InstallStateType const type.
func PossibleInstallStateTypeValues() []InstallStateType {
	return []InstallStateType{InstallStateTypeFailed, InstallStateTypeInstalled, InstallStateTypePending}
}

// LevelType enumerates the values for level type.
type LevelType string

const (
	// Error ...
	Error LevelType = "Error"
	// Information ...
	Information LevelType = "Information"
	// Warning ...
	Warning LevelType = "Warning"
)

// PossibleLevelTypeValues returns an array of possible values for the LevelType const type.
func PossibleLevelTypeValues() []LevelType {
	return []LevelType{Error, Information, Warning}
}

// MessageLevelType enumerates the values for message level type.
type MessageLevelType string

const (
	// MessageLevelTypeError ...
	MessageLevelTypeError MessageLevelType = "Error"
	// MessageLevelTypeInformation ...
	MessageLevelTypeInformation MessageLevelType = "Information"
	// MessageLevelTypeWarning ...
	MessageLevelTypeWarning MessageLevelType = "Warning"
)

// PossibleMessageLevelTypeValues returns an array of possible values for the MessageLevelType const type.
func PossibleMessageLevelTypeValues() []MessageLevelType {
	return []MessageLevelType{MessageLevelTypeError, MessageLevelTypeInformation, MessageLevelTypeWarning}
}

// OperatorScopeType enumerates the values for operator scope type.
type OperatorScopeType string

const (
	// Cluster ...
	Cluster OperatorScopeType = "cluster"
	// Namespace ...
	Namespace OperatorScopeType = "namespace"
)

// PossibleOperatorScopeTypeValues returns an array of possible values for the OperatorScopeType const type.
func PossibleOperatorScopeTypeValues() []OperatorScopeType {
	return []OperatorScopeType{Cluster, Namespace}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// Flux ...
	Flux OperatorType = "Flux"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{Flux}
}

// ProvisioningStateType enumerates the values for provisioning state type.
type ProvisioningStateType string

const (
	// ProvisioningStateTypeAccepted ...
	ProvisioningStateTypeAccepted ProvisioningStateType = "Accepted"
	// ProvisioningStateTypeDeleting ...
	ProvisioningStateTypeDeleting ProvisioningStateType = "Deleting"
	// ProvisioningStateTypeFailed ...
	ProvisioningStateTypeFailed ProvisioningStateType = "Failed"
	// ProvisioningStateTypeRunning ...
	ProvisioningStateTypeRunning ProvisioningStateType = "Running"
	// ProvisioningStateTypeSucceeded ...
	ProvisioningStateTypeSucceeded ProvisioningStateType = "Succeeded"
)

// PossibleProvisioningStateTypeValues returns an array of possible values for the ProvisioningStateType const type.
func PossibleProvisioningStateTypeValues() []ProvisioningStateType {
	return []ProvisioningStateType{ProvisioningStateTypeAccepted, ProvisioningStateTypeDeleting, ProvisioningStateTypeFailed, ProvisioningStateTypeRunning, ProvisioningStateTypeSucceeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned}
}
