package frontdoor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/frontdoor/mgmt/2018-08-01-preview/frontdoor"

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'. Possible values include: 'NetworkOperationStatusInProgress', 'NetworkOperationStatusSucceeded', 'NetworkOperationStatusFailed'
	Status NetworkOperationStatus `json:"status,omitempty"`
	Error  *Error                 `json:"error,omitempty"`
}

// AzureManagedOverrideRuleGroup defines contents of a web application rule
type AzureManagedOverrideRuleGroup struct {
	// RuleGroupOverride - Describes override rule group. Possible values include: 'SQLInjection', 'XSS'
	RuleGroupOverride RuleGroupOverride `json:"ruleGroupOverride,omitempty"`
	// Action - Type of Actions. Possible values include: 'Allow', 'Block', 'Log'
	Action Action `json:"action,omitempty"`
}

// AzureManagedRuleSet describes azure managed provider.
type AzureManagedRuleSet struct {
	// RuleGroupOverrides - List of azure managed provider override configuration (optional)
	RuleGroupOverrides *[]AzureManagedOverrideRuleGroup `json:"ruleGroupOverrides,omitempty"`
	// Priority - Describes priority of the rule
	Priority *int32 `json:"priority,omitempty"`
	// Version - defines version of the rule set
	Version *int32 `json:"version,omitempty"`
	// RuleSetType - Possible values include: 'RuleSetTypeUnknown', 'RuleSetTypeAzureManagedRuleSet'
	RuleSetType RuleSetType `json:"ruleSetType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) MarshalJSON() ([]byte, error) {
	amrs.RuleSetType = RuleSetTypeAzureManagedRuleSet
	objectMap := make(map[string]interface{})
	if amrs.RuleGroupOverrides != nil {
		objectMap["ruleGroupOverrides"] = amrs.RuleGroupOverrides
	}
	if amrs.Priority != nil {
		objectMap["priority"] = amrs.Priority
	}
	if amrs.Version != nil {
		objectMap["version"] = amrs.Version
	}
	if amrs.RuleSetType != "" {
		objectMap["ruleSetType"] = amrs.RuleSetType
	}
	return json.Marshal(objectMap)
}

// AsAzureManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool) {
	return &amrs, true
}

// AsManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsManagedRuleSet() (*ManagedRuleSet, bool) {
	return nil, false
}

// AsBasicManagedRuleSet is the BasicManagedRuleSet implementation for AzureManagedRuleSet.
func (amrs AzureManagedRuleSet) AsBasicManagedRuleSet() (BasicManagedRuleSet, bool) {
	return &amrs, true
}

// Backend backend address of a frontDoor load balancer.
type Backend struct {
	// Address - Location of the backend (IP address or FQDN)
	Address *string `json:"address,omitempty"`
	// HTTPPort - The HTTP TCP port number. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The HTTPS TCP port number. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// EnabledState - Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
	// Priority - Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of this endpoint for load balancing purposes.
	Weight *int32 `json:"weight,omitempty"`
	// BackendHostHeader - The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
	BackendHostHeader *string `json:"backendHostHeader,omitempty"`
}

// BackendPool a backend pool is a collection of backends that can be routed to.
type BackendPool struct {
	// BackendPoolProperties - Properties of the Front Door Backend Pool
	*BackendPoolProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendPool.
func (bp BackendPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.BackendPoolProperties != nil {
		objectMap["properties"] = bp.BackendPoolProperties
	}
	if bp.Name != nil {
		objectMap["name"] = bp.Name
	}
	if bp.ID != nil {
		objectMap["id"] = bp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendPool struct.
func (bp *BackendPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendPoolProperties BackendPoolProperties
				err = json.Unmarshal(*v, &backendPoolProperties)
				if err != nil {
					return err
				}
				bp.BackendPoolProperties = &backendPoolProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bp.ID = &ID
			}
		}
	}

	return nil
}

// BackendPoolListResult result of the request to list Backend Pools. It contains a list of Backend Pools
// objects and a URL link to get the next set of results.
type BackendPoolListResult struct {
	// Value - READ-ONLY; List of Backend Pools within a Front Door.
	Value *[]BackendPool `json:"value,omitempty"`
	// NextLink - URL to get the next set of BackendPool objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendPoolListResult.
func (bplr BackendPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bplr.NextLink != nil {
		objectMap["nextLink"] = bplr.NextLink
	}
	return json.Marshal(objectMap)
}

// BackendPoolProperties the JSON object that contains the properties required to create a routing rule.
type BackendPoolProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// Backends - The set of backends for this pool
	Backends *[]Backend `json:"backends,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`
}

// BackendPoolUpdateParameters a collection of backends that can be routed to.
type BackendPoolUpdateParameters struct {
	// Backends - The set of backends for this pool
	Backends *[]Backend `json:"backends,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *SubResource `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - L7 health probe settings for a backend pool
	HealthProbeSettings *SubResource `json:"healthProbeSettings,omitempty"`
}

// CacheConfiguration caching settings for a caching-type route. To disable caching, do not provide a
// cacheConfiguration object.
type CacheConfiguration struct {
	// QueryParameterStripDirective - Treatment of URL query terms when forming the cache key. Possible values include: 'StripNone', 'StripAll'
	QueryParameterStripDirective Query `json:"queryParameterStripDirective,omitempty"`
	// DynamicCompression - Whether to use dynamic compression for cached content. Possible values include: 'DynamicCompressionEnabledEnabled', 'DynamicCompressionEnabledDisabled'
	DynamicCompression DynamicCompressionEnabled `json:"dynamicCompression,omitempty"`
}

// CertificateSourceParameters parameters required for enabling SSL with Front Door-managed certificates
type CertificateSourceParameters struct {
	// CertificateType - Defines the type of the certificate used for secure connections to a frontendEndpoint. Possible values include: 'Dedicated'
	CertificateType CertificateType `json:"certificateType,omitempty"`
}

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated. Possible values include: 'MicrosoftNetworkfrontDoors', 'MicrosoftNetworkfrontDoorsfrontendEndpoints'
	Type ResourceType `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailability - READ-ONLY; Indicates whether the name is available. Possible values include: 'Available', 'Unavailable'
	NameAvailability Availability `json:"nameAvailability,omitempty"`
	// Reason - READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CustomHTTPSConfiguration https settings for a domain
type CustomHTTPSConfiguration struct {
	// CertificateSource - Defines the source of the SSL certificate. Possible values include: 'CertificateSourceAzureKeyVault', 'CertificateSourceFrontDoor'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication'
	ProtocolType TLSProtocolType `json:"protocolType,omitempty"`
	// KeyVaultCertificateSourceParameters - KeyVault certificate source parameters (if certificateSource=AzureKeyVault)
	*KeyVaultCertificateSourceParameters `json:"keyVaultCertificateSourceParameters,omitempty"`
	// CertificateSourceParameters - Parameters required for enabling SSL with Front Door-managed certificates (if certificateSource=FrontDoor)
	*CertificateSourceParameters `json:"frontDoorCertificateSourceParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomHTTPSConfiguration.
func (chc CustomHTTPSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if chc.CertificateSource != "" {
		objectMap["certificateSource"] = chc.CertificateSource
	}
	if chc.ProtocolType != "" {
		objectMap["protocolType"] = chc.ProtocolType
	}
	if chc.KeyVaultCertificateSourceParameters != nil {
		objectMap["keyVaultCertificateSourceParameters"] = chc.KeyVaultCertificateSourceParameters
	}
	if chc.CertificateSourceParameters != nil {
		objectMap["frontDoorCertificateSourceParameters"] = chc.CertificateSourceParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomHTTPSConfiguration struct.
func (chc *CustomHTTPSConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "certificateSource":
			if v != nil {
				var certificateSource CertificateSource
				err = json.Unmarshal(*v, &certificateSource)
				if err != nil {
					return err
				}
				chc.CertificateSource = certificateSource
			}
		case "protocolType":
			if v != nil {
				var protocolType TLSProtocolType
				err = json.Unmarshal(*v, &protocolType)
				if err != nil {
					return err
				}
				chc.ProtocolType = protocolType
			}
		case "keyVaultCertificateSourceParameters":
			if v != nil {
				var keyVaultCertificateSourceParameters KeyVaultCertificateSourceParameters
				err = json.Unmarshal(*v, &keyVaultCertificateSourceParameters)
				if err != nil {
					return err
				}
				chc.KeyVaultCertificateSourceParameters = &keyVaultCertificateSourceParameters
			}
		case "frontDoorCertificateSourceParameters":
			if v != nil {
				var certificateSourceParameters CertificateSourceParameters
				err = json.Unmarshal(*v, &certificateSourceParameters)
				if err != nil {
					return err
				}
				chc.CertificateSourceParameters = &certificateSourceParameters
			}
		}
	}

	return nil
}

// CustomRule defines contents of a web application rule
type CustomRule struct {
	// Name - Gets name of the resource that is unique within a policy. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Priority - Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value
	Priority *int32 `json:"priority,omitempty"`
	// RuleType - Describes type of rule. Possible values include: 'MatchRule', 'RateLimitRule'
	RuleType RuleType `json:"ruleType,omitempty"`
	// RateLimitDurationInMinutes - Defines rate limit duration. Default - 1 minute
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`
	// RateLimitThreshold - Defines rate limit threshold
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`
	// MatchConditions - List of match conditions
	MatchConditions *[]MatchCondition1 `json:"matchConditions,omitempty"`
	// Action - Type of Actions. Possible values include: 'Allow', 'Block', 'Log'
	Action Action `json:"action,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomRule.
func (cr CustomRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Name != nil {
		objectMap["name"] = cr.Name
	}
	if cr.Priority != nil {
		objectMap["priority"] = cr.Priority
	}
	if cr.RuleType != "" {
		objectMap["ruleType"] = cr.RuleType
	}
	if cr.RateLimitDurationInMinutes != nil {
		objectMap["rateLimitDurationInMinutes"] = cr.RateLimitDurationInMinutes
	}
	if cr.RateLimitThreshold != nil {
		objectMap["rateLimitThreshold"] = cr.RateLimitThreshold
	}
	if cr.MatchConditions != nil {
		objectMap["matchConditions"] = cr.MatchConditions
	}
	if cr.Action != "" {
		objectMap["action"] = cr.Action
	}
	if cr.Transforms != nil {
		objectMap["transforms"] = cr.Transforms
	}
	return json.Marshal(objectMap)
}

// CustomRules defines contents of custom rules
type CustomRules struct {
	// Rules - List of rules
	Rules *[]CustomRule `json:"rules,omitempty"`
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (autorest.Response, error)
}

// Error ...
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails ...
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response indicates Front Door service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponse struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FrontDoor front Door represents a collection of backend endpoints to route traffic to along with rules
// that specify how traffic is sent there.
type FrontDoor struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Front Door Load Balancer
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FrontDoor.
func (fd FrontDoor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fd.Properties != nil {
		objectMap["properties"] = fd.Properties
	}
	if fd.Location != nil {
		objectMap["location"] = fd.Location
	}
	if fd.Tags != nil {
		objectMap["tags"] = fd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontDoor struct.
func (fd *FrontDoor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				fd.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fd.Tags = tags
			}
		}
	}

	return nil
}

// FrontDoorsCreateOrUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontDoorsCreateOrUpdateFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FrontDoorsClient) (FrontDoor, error)
}

// FrontDoorsDeleteFutureType an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FrontDoorsDeleteFutureType struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FrontDoorsClient) (autorest.Response, error)
}

// FrontendEndpoint a frontend endpoint used for routing.
type FrontendEndpoint struct {
	autorest.Response `json:"-"`
	// FrontendEndpointProperties - Properties of the Frontend endpoint
	*FrontendEndpointProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendEndpoint.
func (fe FrontendEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.FrontendEndpointProperties != nil {
		objectMap["properties"] = fe.FrontendEndpointProperties
	}
	if fe.Name != nil {
		objectMap["name"] = fe.Name
	}
	if fe.ID != nil {
		objectMap["id"] = fe.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendEndpoint struct.
func (fe *FrontendEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendEndpointProperties FrontendEndpointProperties
				err = json.Unmarshal(*v, &frontendEndpointProperties)
				if err != nil {
					return err
				}
				fe.FrontendEndpointProperties = &frontendEndpointProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		}
	}

	return nil
}

// FrontendEndpointProperties the JSON object that contains the properties required to create a frontend
// endpoint.
type FrontendEndpointProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - READ-ONLY; Provisioning status of Custom Https of the frontendEndpoint. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// CustomHTTPSProvisioningSubstate - READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. Possible values include: 'SubmittingDomainControlValidationRequest', 'PendingDomainControlValidationREquestApproval', 'DomainControlValidationRequestApproved', 'DomainControlValidationRequestRejected', 'DomainControlValidationRequestTimedOut', 'IssuingCertificate', 'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate', 'CertificateDeleted'
	CustomHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty"`
	// CustomHTTPSConfiguration - READ-ONLY; The configuration specifying how to enable HTTPS
	CustomHTTPSConfiguration *CustomHTTPSConfiguration `json:"customHttpsConfiguration,omitempty"`
	// HostName - The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// SessionAffinityEnabledState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'SessionAffinityEnabledStateEnabled', 'SessionAffinityEnabledStateDisabled'
	SessionAffinityEnabledState SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`
	// SessionAffinityTTLSeconds - UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendEndpointProperties.
func (fep FrontendEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fep.ResourceState != "" {
		objectMap["resourceState"] = fep.ResourceState
	}
	if fep.HostName != nil {
		objectMap["hostName"] = fep.HostName
	}
	if fep.SessionAffinityEnabledState != "" {
		objectMap["sessionAffinityEnabledState"] = fep.SessionAffinityEnabledState
	}
	if fep.SessionAffinityTTLSeconds != nil {
		objectMap["sessionAffinityTtlSeconds"] = fep.SessionAffinityTTLSeconds
	}
	if fep.WebApplicationFirewallPolicyLink != nil {
		objectMap["webApplicationFirewallPolicyLink"] = fep.WebApplicationFirewallPolicyLink
	}
	return json.Marshal(objectMap)
}

// FrontendEndpointsDisableHTTPSFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontendEndpointsDisableHTTPSFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FrontendEndpointsClient) (autorest.Response, error)
}

// FrontendEndpointsEnableHTTPSFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FrontendEndpointsEnableHTTPSFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FrontendEndpointsClient) (autorest.Response, error)
}

// FrontendEndpointsListResult result of the request to list frontend endpoints. It contains a list of
// Frontend endpoint objects and a URL link to get the next set of results.
type FrontendEndpointsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Frontend endpoints within a Front Door.
	Value *[]FrontendEndpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of frontend endpoints if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendEndpointsListResult.
func (felr FrontendEndpointsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if felr.NextLink != nil {
		objectMap["nextLink"] = felr.NextLink
	}
	return json.Marshal(objectMap)
}

// FrontendEndpointsListResultIterator provides access to a complete listing of FrontendEndpoint values.
type FrontendEndpointsListResultIterator struct {
	i    int
	page FrontendEndpointsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FrontendEndpointsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FrontendEndpointsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FrontendEndpointsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FrontendEndpointsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FrontendEndpointsListResultIterator) Response() FrontendEndpointsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FrontendEndpointsListResultIterator) Value() FrontendEndpoint {
	if !iter.page.NotDone() {
		return FrontendEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FrontendEndpointsListResultIterator type.
func NewFrontendEndpointsListResultIterator(page FrontendEndpointsListResultPage) FrontendEndpointsListResultIterator {
	return FrontendEndpointsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (felr FrontendEndpointsListResult) IsEmpty() bool {
	return felr.Value == nil || len(*felr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (felr FrontendEndpointsListResult) hasNextLink() bool {
	return felr.NextLink != nil && len(*felr.NextLink) != 0
}

// frontendEndpointsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (felr FrontendEndpointsListResult) frontendEndpointsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !felr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(felr.NextLink)))
}

// FrontendEndpointsListResultPage contains a page of FrontendEndpoint values.
type FrontendEndpointsListResultPage struct {
	fn   func(context.Context, FrontendEndpointsListResult) (FrontendEndpointsListResult, error)
	felr FrontendEndpointsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FrontendEndpointsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FrontendEndpointsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.felr)
		if err != nil {
			return err
		}
		page.felr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FrontendEndpointsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FrontendEndpointsListResultPage) NotDone() bool {
	return !page.felr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FrontendEndpointsListResultPage) Response() FrontendEndpointsListResult {
	return page.felr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FrontendEndpointsListResultPage) Values() []FrontendEndpoint {
	if page.felr.IsEmpty() {
		return nil
	}
	return *page.felr.Value
}

// Creates a new instance of the FrontendEndpointsListResultPage type.
func NewFrontendEndpointsListResultPage(cur FrontendEndpointsListResult, getNextPage func(context.Context, FrontendEndpointsListResult) (FrontendEndpointsListResult, error)) FrontendEndpointsListResultPage {
	return FrontendEndpointsListResultPage{
		fn:   getNextPage,
		felr: cur,
	}
}

// FrontendEndpointUpdateParameters frontend endpoint used in routing rule
type FrontendEndpointUpdateParameters struct {
	// HostName - The host name of the frontendEndpoint. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// SessionAffinityEnabledState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'SessionAffinityEnabledStateEnabled', 'SessionAffinityEnabledStateDisabled'
	SessionAffinityEnabledState SessionAffinityEnabledState `json:"sessionAffinityEnabledState,omitempty"`
	// SessionAffinityTTLSeconds - UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
	SessionAffinityTTLSeconds *int32 `json:"sessionAffinityTtlSeconds,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for each host (if applicable)
	WebApplicationFirewallPolicyLink *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink defines the Web Application Firewall
// policy for each host (if applicable)
type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// HealthProbeSettingsListResult result of the request to list HealthProbeSettings. It contains a list of
// HealthProbeSettings objects and a URL link to get the next set of results.
type HealthProbeSettingsListResult struct {
	// Value - READ-ONLY; List of HealthProbeSettings within a Front Door.
	Value *[]HealthProbeSettingsModel `json:"value,omitempty"`
	// NextLink - URL to get the next set of HealthProbeSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthProbeSettingsListResult.
func (hpslr HealthProbeSettingsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpslr.NextLink != nil {
		objectMap["nextLink"] = hpslr.NextLink
	}
	return json.Marshal(objectMap)
}

// HealthProbeSettingsModel load balancing settings for a backend pool
type HealthProbeSettingsModel struct {
	// HealthProbeSettingsProperties - Properties of the health probe settings
	*HealthProbeSettingsProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthProbeSettingsModel.
func (hpsm HealthProbeSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpsm.HealthProbeSettingsProperties != nil {
		objectMap["properties"] = hpsm.HealthProbeSettingsProperties
	}
	if hpsm.Name != nil {
		objectMap["name"] = hpsm.Name
	}
	if hpsm.ID != nil {
		objectMap["id"] = hpsm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HealthProbeSettingsModel struct.
func (hpsm *HealthProbeSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var healthProbeSettingsProperties HealthProbeSettingsProperties
				err = json.Unmarshal(*v, &healthProbeSettingsProperties)
				if err != nil {
					return err
				}
				hpsm.HealthProbeSettingsProperties = &healthProbeSettingsProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hpsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hpsm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hpsm.ID = &ID
			}
		}
	}

	return nil
}

// HealthProbeSettingsProperties the JSON object that contains the properties required to create a health
// probe settings.
type HealthProbeSettingsProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// Path - The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`
	// Protocol - Protocol scheme to use for this probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol Protocol `json:"protocol,omitempty"`
	// IntervalInSeconds - The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// HealthProbeSettingsUpdateParameters l7 health probe settings for a backend pool
type HealthProbeSettingsUpdateParameters struct {
	// Path - The path to use for the health probe. Default is /
	Path *string `json:"path,omitempty"`
	// Protocol - Protocol scheme to use for this probe. Possible values include: 'HTTP', 'HTTPS'
	Protocol Protocol `json:"protocol,omitempty"`
	// IntervalInSeconds - The number of seconds between health probes.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// KeyVaultCertificateSourceParameters parameters required for bring-your-own-certification via Key Vault
type KeyVaultCertificateSourceParameters struct {
	// Vault - The Key Vault containing the SSL certificate
	Vault *KeyVaultCertificateSourceParametersVault `json:"vault,omitempty"`
	// SecretName - The name of the Key Vault secret representing the full certificate PFX
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version of the Key Vault secret representing the full certificate PFX
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// KeyVaultCertificateSourceParametersVault the Key Vault containing the SSL certificate
type KeyVaultCertificateSourceParametersVault struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ListResult result of the request to list Front Doors. It contains a list of Front Door objects and a URL
// link to get the next set of results.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Front Doors within a resource group.
	Value *[]FrontDoor `json:"value,omitempty"`
	// NextLink - URL to get the next set of Front Door objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListResult.
func (lr ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.NextLink != nil {
		objectMap["nextLink"] = lr.NextLink
	}
	return json.Marshal(objectMap)
}

// ListResultIterator provides access to a complete listing of FrontDoor values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() FrontDoor {
	if !iter.page.NotDone() {
		return FrontDoor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of FrontDoor values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []FrontDoor {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// LoadBalancingSettingsListResult result of the request to list load balancing settings. It contains a
// list of load balancing settings objects and a URL link to get the next set of results.
type LoadBalancingSettingsListResult struct {
	// Value - READ-ONLY; List of Backend Pools within a Front Door.
	Value *[]LoadBalancingSettingsModel `json:"value,omitempty"`
	// NextLink - URL to get the next set of LoadBalancingSettings objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingSettingsListResult.
func (lbslr LoadBalancingSettingsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbslr.NextLink != nil {
		objectMap["nextLink"] = lbslr.NextLink
	}
	return json.Marshal(objectMap)
}

// LoadBalancingSettingsModel load balancing settings for a backend pool
type LoadBalancingSettingsModel struct {
	// LoadBalancingSettingsProperties - Properties of the load balancing settings
	*LoadBalancingSettingsProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingSettingsModel.
func (lbsm LoadBalancingSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbsm.LoadBalancingSettingsProperties != nil {
		objectMap["properties"] = lbsm.LoadBalancingSettingsProperties
	}
	if lbsm.Name != nil {
		objectMap["name"] = lbsm.Name
	}
	if lbsm.ID != nil {
		objectMap["id"] = lbsm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingSettingsModel struct.
func (lbsm *LoadBalancingSettingsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingSettingsProperties LoadBalancingSettingsProperties
				err = json.Unmarshal(*v, &loadBalancingSettingsProperties)
				if err != nil {
					return err
				}
				lbsm.LoadBalancingSettingsProperties = &loadBalancingSettingsProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbsm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lbsm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbsm.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingSettingsProperties the JSON object that contains the properties required to create load
// balancing settings
type LoadBalancingSettingsProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// SampleSize - The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`
	// SuccessfulSamplesRequired - The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
	// AdditionalLatencyMilliseconds - The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`
}

// LoadBalancingSettingsUpdateParameters round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsUpdateParameters struct {
	// SampleSize - The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`
	// SuccessfulSamplesRequired - The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
	// AdditionalLatencyMilliseconds - The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyMilliseconds *int32 `json:"additionalLatencyMilliseconds,omitempty"`
}

// BasicManagedRuleSet base class for all types of ManagedRuleSet.
type BasicManagedRuleSet interface {
	AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool)
	AsManagedRuleSet() (*ManagedRuleSet, bool)
}

// ManagedRuleSet base class for all types of ManagedRuleSet.
type ManagedRuleSet struct {
	// Priority - Describes priority of the rule
	Priority *int32 `json:"priority,omitempty"`
	// Version - defines version of the rule set
	Version *int32 `json:"version,omitempty"`
	// RuleSetType - Possible values include: 'RuleSetTypeUnknown', 'RuleSetTypeAzureManagedRuleSet'
	RuleSetType RuleSetType `json:"ruleSetType,omitempty"`
}

func unmarshalBasicManagedRuleSet(body []byte) (BasicManagedRuleSet, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleSetType"] {
	case string(RuleSetTypeAzureManagedRuleSet):
		var amrs AzureManagedRuleSet
		err := json.Unmarshal(body, &amrs)
		return amrs, err
	default:
		var mrs ManagedRuleSet
		err := json.Unmarshal(body, &mrs)
		return mrs, err
	}
}
func unmarshalBasicManagedRuleSetArray(body []byte) ([]BasicManagedRuleSet, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mrsArray := make([]BasicManagedRuleSet, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mrs, err := unmarshalBasicManagedRuleSet(*rawMessage)
		if err != nil {
			return nil, err
		}
		mrsArray[index] = mrs
	}
	return mrsArray, nil
}

// MarshalJSON is the custom marshaler for ManagedRuleSet.
func (mrs ManagedRuleSet) MarshalJSON() ([]byte, error) {
	mrs.RuleSetType = RuleSetTypeUnknown
	objectMap := make(map[string]interface{})
	if mrs.Priority != nil {
		objectMap["priority"] = mrs.Priority
	}
	if mrs.Version != nil {
		objectMap["version"] = mrs.Version
	}
	if mrs.RuleSetType != "" {
		objectMap["ruleSetType"] = mrs.RuleSetType
	}
	return json.Marshal(objectMap)
}

// AsAzureManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsAzureManagedRuleSet() (*AzureManagedRuleSet, bool) {
	return nil, false
}

// AsManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsManagedRuleSet() (*ManagedRuleSet, bool) {
	return &mrs, true
}

// AsBasicManagedRuleSet is the BasicManagedRuleSet implementation for ManagedRuleSet.
func (mrs ManagedRuleSet) AsBasicManagedRuleSet() (BasicManagedRuleSet, bool) {
	return &mrs, true
}

// ManagedRuleSets defines ManagedRuleSets - array of managedRuleSet
type ManagedRuleSets struct {
	// RuleSets - List of rules
	RuleSets *[]BasicManagedRuleSet `json:"ruleSets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagedRuleSets struct.
func (mrs *ManagedRuleSets) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ruleSets":
			if v != nil {
				ruleSets, err := unmarshalBasicManagedRuleSetArray(*v)
				if err != nil {
					return err
				}
				mrs.RuleSets = &ruleSets
			}
		}
	}

	return nil
}

// MatchCondition1 define match conditions
type MatchCondition1 struct {
	// MatchVariable - Match Variable. Possible values include: 'RemoteAddr', 'RequestMethod', 'QueryString', 'PostArgs', 'RequestURI', 'RequestHeader', 'RequestBody'
	MatchVariable MatchCondition `json:"matchVariable,omitempty"`
	// Selector - Name of selector in RequestHeader or RequestBody to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'Any', 'IPMatch', 'GeoMatch', 'Equal', 'Contains', 'LessThan', 'GreaterThan', 'LessThanOrEqual', 'GreaterThanOrEqual', 'BeginsWith', 'EndsWith'
	Operator Operator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValue - Match value
	MatchValue *[]string `json:"matchValue,omitempty"`
}

// PoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoliciesClient) (autorest.Response, error)
}

// PolicySettings defines contents of a web application firewall global configuration
type PolicySettings struct {
	// EnabledState - describes if the policy is in enabled state or disabled state. Possible values include: 'EnabledStateDisabled', 'EnabledStateEnabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// Mode - Describes if it is in detection mode  or prevention mode at policy level. Possible values include: 'Prevention', 'Detection'
	Mode Mode `json:"mode,omitempty"`
}

// Properties the JSON object that contains the properties required to create an endpoint.
type Properties struct {
	// ResourceState - Resource status of the Front Door. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the Front Door.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Cname - READ-ONLY; The host that each frontendEndpoint must CNAME to.
	Cname *string `json:"cname,omitempty"`
	// FriendlyName - A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RoutingRules - Routing rules associated with this Front Door.
	RoutingRules *[]RoutingRule `json:"routingRules,omitempty"`
	// LoadBalancingSettings - Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings *[]LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings associated with this Front Door instance.
	HealthProbeSettings *[]HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`
	// BackendPools - Backend pools available to routing rules.
	BackendPools *[]BackendPool `json:"backendPools,omitempty"`
	// FrontendEndpoints - Frontend endpoints available to routing rules.
	FrontendEndpoints *[]FrontendEndpoint `json:"frontendEndpoints,omitempty"`
	// EnabledState - Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ResourceState != "" {
		objectMap["resourceState"] = p.ResourceState
	}
	if p.FriendlyName != nil {
		objectMap["friendlyName"] = p.FriendlyName
	}
	if p.RoutingRules != nil {
		objectMap["routingRules"] = p.RoutingRules
	}
	if p.LoadBalancingSettings != nil {
		objectMap["loadBalancingSettings"] = p.LoadBalancingSettings
	}
	if p.HealthProbeSettings != nil {
		objectMap["healthProbeSettings"] = p.HealthProbeSettings
	}
	if p.BackendPools != nil {
		objectMap["backendPools"] = p.BackendPools
	}
	if p.FrontendEndpoints != nil {
		objectMap["frontendEndpoints"] = p.FrontendEndpoints
	}
	if p.EnabledState != "" {
		objectMap["enabledState"] = p.EnabledState
	}
	return json.Marshal(objectMap)
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Resource common resource representation.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RoutingRule a routing rule represents a specification for traffic to treat and where to send it, along
// with health probe information.
type RoutingRule struct {
	// RoutingRuleProperties - Properties of the Front Door Routing Rule
	*RoutingRuleProperties `json:"properties,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for RoutingRule.
func (rr RoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RoutingRuleProperties != nil {
		objectMap["properties"] = rr.RoutingRuleProperties
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoutingRule struct.
func (rr *RoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routingRuleProperties RoutingRuleProperties
				err = json.Unmarshal(*v, &routingRuleProperties)
				if err != nil {
					return err
				}
				rr.RoutingRuleProperties = &routingRuleProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		}
	}

	return nil
}

// RoutingRuleListResult result of the request to list Routing Rules. It contains a list of Routing Rule
// objects and a URL link to get the next set of results.
type RoutingRuleListResult struct {
	// Value - READ-ONLY; List of Routing Rules within a Front Door.
	Value *[]RoutingRule `json:"value,omitempty"`
	// NextLink - URL to get the next set of RoutingRule objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RoutingRuleListResult.
func (rrlr RoutingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrlr.NextLink != nil {
		objectMap["nextLink"] = rrlr.NextLink
	}
	return json.Marshal(objectMap)
}

// RoutingRuleProperties the JSON object that contains the properties required to create a routing rule.
type RoutingRuleProperties struct {
	// ResourceState - Resource status. Possible values include: 'ResourceStateCreating', 'ResourceStateEnabling', 'ResourceStateEnabled', 'ResourceStateDisabling', 'ResourceStateDisabled', 'ResourceStateDeleting'
	ResourceState ResourceState `json:"resourceState,omitempty"`
	// FrontendEndpoints - Frontend endpoints associated with this rule
	FrontendEndpoints *[]SubResource `json:"frontendEndpoints,omitempty"`
	// AcceptedProtocols - Protocol schemes to match for this rule
	AcceptedProtocols *[]Protocol `json:"acceptedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CustomForwardingPath - A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string `json:"customForwardingPath,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'HTTPOnly', 'HTTPSOnly', 'MatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// CacheConfiguration - The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`
	// BackendPool - A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource `json:"backendPool,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// RoutingRuleUpdateParameters routing rules to apply to an endpoint
type RoutingRuleUpdateParameters struct {
	// FrontendEndpoints - Frontend endpoints associated with this rule
	FrontendEndpoints *[]SubResource `json:"frontendEndpoints,omitempty"`
	// AcceptedProtocols - Protocol schemes to match for this rule
	AcceptedProtocols *[]Protocol `json:"acceptedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CustomForwardingPath - A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
	CustomForwardingPath *string `json:"customForwardingPath,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'HTTPOnly', 'HTTPSOnly', 'MatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// CacheConfiguration - The caching configuration associated with this rule.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`
	// BackendPool - A reference to the BackendPool which this rule routes to.
	BackendPool *SubResource `json:"backendPool,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// SubResource reference to another subresource.
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateParameters the properties needed to update a Front Door
type UpdateParameters struct {
	// FriendlyName - A friendly name for the frontDoor
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RoutingRules - Routing rules associated with this Front Door.
	RoutingRules *[]RoutingRule `json:"routingRules,omitempty"`
	// LoadBalancingSettings - Load balancing settings associated with this Front Door instance.
	LoadBalancingSettings *[]LoadBalancingSettingsModel `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings associated with this Front Door instance.
	HealthProbeSettings *[]HealthProbeSettingsModel `json:"healthProbeSettings,omitempty"`
	// BackendPools - Backend pools available to routing rules.
	BackendPools *[]BackendPool `json:"backendPools,omitempty"`
	// FrontendEndpoints - Frontend endpoints available to routing rules.
	FrontendEndpoints *[]FrontendEndpoint `json:"frontendEndpoints,omitempty"`
	// EnabledState - Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnumEnabled', 'EnabledStateEnumDisabled'
	EnabledState EnabledStateEnum `json:"enabledState,omitempty"`
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - READ-ONLY; The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}

// WebApplicationFirewallPolicy1 defines web application firewall policy.
type WebApplicationFirewallPolicy1 struct {
	autorest.Response `json:"-"`
	// WebApplicationFirewallPolicyPropertiesFormat - Properties of the web application firewall policy.
	*WebApplicationFirewallPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicy1.
func (wafp1 WebApplicationFirewallPolicy1) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafp1.WebApplicationFirewallPolicyPropertiesFormat != nil {
		objectMap["properties"] = wafp1.WebApplicationFirewallPolicyPropertiesFormat
	}
	if wafp1.Etag != nil {
		objectMap["etag"] = wafp1.Etag
	}
	if wafp1.Location != nil {
		objectMap["location"] = wafp1.Location
	}
	if wafp1.Tags != nil {
		objectMap["tags"] = wafp1.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebApplicationFirewallPolicy1 struct.
func (wafp1 *WebApplicationFirewallPolicy1) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webApplicationFirewallPolicyPropertiesFormat WebApplicationFirewallPolicyPropertiesFormat
				err = json.Unmarshal(*v, &webApplicationFirewallPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				wafp1.WebApplicationFirewallPolicyPropertiesFormat = &webApplicationFirewallPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wafp1.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wafp1.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wafp1.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wafp1.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wafp1.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wafp1.Tags = tags
			}
		}
	}

	return nil
}

// WebApplicationFirewallPolicyListResult result of the request to list WebApplicationFirewallPolicies. It
// contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of WebApplicationFirewallPolicies within a resource group.
	Value *[]WebApplicationFirewallPolicy1 `json:"value,omitempty"`
	// NextLink - URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyListResult.
func (wafplr WebApplicationFirewallPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafplr.NextLink != nil {
		objectMap["nextLink"] = wafplr.NextLink
	}
	return json.Marshal(objectMap)
}

// WebApplicationFirewallPolicyListResultIterator provides access to a complete listing of
// WebApplicationFirewallPolicy1 values.
type WebApplicationFirewallPolicyListResultIterator struct {
	i    int
	page WebApplicationFirewallPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebApplicationFirewallPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebApplicationFirewallPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebApplicationFirewallPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebApplicationFirewallPolicyListResultIterator) Response() WebApplicationFirewallPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebApplicationFirewallPolicyListResultIterator) Value() WebApplicationFirewallPolicy1 {
	if !iter.page.NotDone() {
		return WebApplicationFirewallPolicy1{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebApplicationFirewallPolicyListResultIterator type.
func NewWebApplicationFirewallPolicyListResultIterator(page WebApplicationFirewallPolicyListResultPage) WebApplicationFirewallPolicyListResultIterator {
	return WebApplicationFirewallPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wafplr WebApplicationFirewallPolicyListResult) IsEmpty() bool {
	return wafplr.Value == nil || len(*wafplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wafplr WebApplicationFirewallPolicyListResult) hasNextLink() bool {
	return wafplr.NextLink != nil && len(*wafplr.NextLink) != 0
}

// webApplicationFirewallPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wafplr WebApplicationFirewallPolicyListResult) webApplicationFirewallPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wafplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wafplr.NextLink)))
}

// WebApplicationFirewallPolicyListResultPage contains a page of WebApplicationFirewallPolicy1 values.
type WebApplicationFirewallPolicyListResultPage struct {
	fn     func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)
	wafplr WebApplicationFirewallPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebApplicationFirewallPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wafplr)
		if err != nil {
			return err
		}
		page.wafplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebApplicationFirewallPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebApplicationFirewallPolicyListResultPage) NotDone() bool {
	return !page.wafplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebApplicationFirewallPolicyListResultPage) Response() WebApplicationFirewallPolicyListResult {
	return page.wafplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebApplicationFirewallPolicyListResultPage) Values() []WebApplicationFirewallPolicy1 {
	if page.wafplr.IsEmpty() {
		return nil
	}
	return *page.wafplr.Value
}

// Creates a new instance of the WebApplicationFirewallPolicyListResultPage type.
func NewWebApplicationFirewallPolicyListResultPage(cur WebApplicationFirewallPolicyListResult, getNextPage func(context.Context, WebApplicationFirewallPolicyListResult) (WebApplicationFirewallPolicyListResult, error)) WebApplicationFirewallPolicyListResultPage {
	return WebApplicationFirewallPolicyListResultPage{
		fn:     getNextPage,
		wafplr: cur,
	}
}

// WebApplicationFirewallPolicyPropertiesFormat defines web application firewall policy properties
type WebApplicationFirewallPolicyPropertiesFormat struct {
	// PolicySettings - Describes  policySettings for policy
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`
	// CustomRules - Describes custom rules inside the policy
	CustomRules *CustomRules `json:"customRules,omitempty"`
	// ManagedRules - Describes managed rules inside the policy
	ManagedRules *ManagedRuleSets `json:"managedRules,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the WebApplicationFirewallPolicy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; Possible values include: 'WebApplicationFirewallPolicyCreating', 'WebApplicationFirewallPolicyEnabling', 'WebApplicationFirewallPolicyEnabled', 'WebApplicationFirewallPolicyDisabling', 'WebApplicationFirewallPolicyDisabled', 'WebApplicationFirewallPolicyDeleting'
	ResourceState WebApplicationFirewallPolicy `json:"resourceState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyPropertiesFormat.
func (wafppf WebApplicationFirewallPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafppf.PolicySettings != nil {
		objectMap["policySettings"] = wafppf.PolicySettings
	}
	if wafppf.CustomRules != nil {
		objectMap["customRules"] = wafppf.CustomRules
	}
	if wafppf.ManagedRules != nil {
		objectMap["managedRules"] = wafppf.ManagedRules
	}
	return json.Marshal(objectMap)
}
