package baremetalinfrastructure

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/baremetalinfrastructure/mgmt/2020-08-06-preview/baremetalinfrastructure"

// AzureBareMetalInstance azureBareMetal instance info on Azure (ARM properties and AzureBareMetal
// properties)
type AzureBareMetalInstance struct {
	autorest.Response `json:"-"`
	// AzureBareMetalInstanceProperties - AzureBareMetal instance properties
	*AzureBareMetalInstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBareMetalInstance.
func (abmi AzureBareMetalInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abmi.AzureBareMetalInstanceProperties != nil {
		objectMap["properties"] = abmi.AzureBareMetalInstanceProperties
	}
	if abmi.Tags != nil {
		objectMap["tags"] = abmi.Tags
	}
	if abmi.Location != nil {
		objectMap["location"] = abmi.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureBareMetalInstance struct.
func (abmi *AzureBareMetalInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureBareMetalInstanceProperties AzureBareMetalInstanceProperties
				err = json.Unmarshal(*v, &azureBareMetalInstanceProperties)
				if err != nil {
					return err
				}
				abmi.AzureBareMetalInstanceProperties = &azureBareMetalInstanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				abmi.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				abmi.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				abmi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				abmi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abmi.Type = &typeVar
			}
		}
	}

	return nil
}

// AzureBareMetalInstanceProperties describes the properties of an AzureBareMetal instance.
type AzureBareMetalInstanceProperties struct {
	// HardwareProfile - Specifies the hardware settings for the AzureBareMetal instance.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// StorageProfile - Specifies the storage settings for the AzureBareMetal instance disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// OsProfile - Specifies the operating system settings for the AzureBareMetal instance.
	OsProfile *OSProfile `json:"osProfile,omitempty"`
	// NetworkProfile - Specifies the network settings for the AzureBareMetal instance.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// AzureBareMetalInstanceID - READ-ONLY; Specifies the AzureBareMetal instance unique ID.
	AzureBareMetalInstanceID *string `json:"azureBareMetalInstanceId,omitempty"`
	// PowerState - READ-ONLY; Resource power state. Possible values include: 'Starting', 'Started', 'Stopping', 'Stopped', 'Restarting', 'Unknown'
	PowerState AzureBareMetalInstancePowerStateEnum `json:"powerState,omitempty"`
	// ProximityPlacementGroup - READ-ONLY; Resource proximity placement group
	ProximityPlacementGroup *string `json:"proximityPlacementGroup,omitempty"`
	// HwRevision - READ-ONLY; Hardware revision of an AzureBareMetal instance
	HwRevision *string `json:"hwRevision,omitempty"`
	// PartnerNodeID - ARM ID of another AzureBareMetalInstance that will share a network with this AzureBareMetalInstance
	PartnerNodeID *string `json:"partnerNodeId,omitempty"`
	// ProvisioningState - READ-ONLY; State of provisioning of the AzureBareMetalInstance. Possible values include: 'Accepted', 'Creating', 'Updating', 'Failed', 'Succeeded', 'Deleting', 'Migrating'
	ProvisioningState AzureBareMetalProvisioningStatesEnum `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBareMetalInstanceProperties.
func (abmip AzureBareMetalInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abmip.HardwareProfile != nil {
		objectMap["hardwareProfile"] = abmip.HardwareProfile
	}
	if abmip.StorageProfile != nil {
		objectMap["storageProfile"] = abmip.StorageProfile
	}
	if abmip.OsProfile != nil {
		objectMap["osProfile"] = abmip.OsProfile
	}
	if abmip.NetworkProfile != nil {
		objectMap["networkProfile"] = abmip.NetworkProfile
	}
	if abmip.PartnerNodeID != nil {
		objectMap["partnerNodeId"] = abmip.PartnerNodeID
	}
	return json.Marshal(objectMap)
}

// AzureBareMetalInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureBareMetalInstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureBareMetalInstancesClient) (autorest.Response, error)
}

// AzureBareMetalInstancesListResult the response from the List AzureBareMetal Instances operation.
type AzureBareMetalInstancesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Azure BareMetal instances.
	Value *[]AzureBareMetalInstance `json:"value,omitempty"`
	// NextLink - The URL to get the next set of AzureBareMetal instances.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureBareMetalInstancesListResultIterator provides access to a complete listing of
// AzureBareMetalInstance values.
type AzureBareMetalInstancesListResultIterator struct {
	i    int
	page AzureBareMetalInstancesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureBareMetalInstancesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBareMetalInstancesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureBareMetalInstancesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureBareMetalInstancesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureBareMetalInstancesListResultIterator) Response() AzureBareMetalInstancesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureBareMetalInstancesListResultIterator) Value() AzureBareMetalInstance {
	if !iter.page.NotDone() {
		return AzureBareMetalInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureBareMetalInstancesListResultIterator type.
func NewAzureBareMetalInstancesListResultIterator(page AzureBareMetalInstancesListResultPage) AzureBareMetalInstancesListResultIterator {
	return AzureBareMetalInstancesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (abmilr AzureBareMetalInstancesListResult) IsEmpty() bool {
	return abmilr.Value == nil || len(*abmilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (abmilr AzureBareMetalInstancesListResult) hasNextLink() bool {
	return abmilr.NextLink != nil && len(*abmilr.NextLink) != 0
}

// azureBareMetalInstancesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (abmilr AzureBareMetalInstancesListResult) azureBareMetalInstancesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !abmilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(abmilr.NextLink)))
}

// AzureBareMetalInstancesListResultPage contains a page of AzureBareMetalInstance values.
type AzureBareMetalInstancesListResultPage struct {
	fn     func(context.Context, AzureBareMetalInstancesListResult) (AzureBareMetalInstancesListResult, error)
	abmilr AzureBareMetalInstancesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureBareMetalInstancesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBareMetalInstancesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.abmilr)
		if err != nil {
			return err
		}
		page.abmilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureBareMetalInstancesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureBareMetalInstancesListResultPage) NotDone() bool {
	return !page.abmilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureBareMetalInstancesListResultPage) Response() AzureBareMetalInstancesListResult {
	return page.abmilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureBareMetalInstancesListResultPage) Values() []AzureBareMetalInstance {
	if page.abmilr.IsEmpty() {
		return nil
	}
	return *page.abmilr.Value
}

// Creates a new instance of the AzureBareMetalInstancesListResultPage type.
func NewAzureBareMetalInstancesListResultPage(cur AzureBareMetalInstancesListResult, getNextPage func(context.Context, AzureBareMetalInstancesListResult) (AzureBareMetalInstancesListResult, error)) AzureBareMetalInstancesListResultPage {
	return AzureBareMetalInstancesListResultPage{
		fn:     getNextPage,
		abmilr: cur,
	}
}

// AzureBareMetalInstancesRestartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureBareMetalInstancesRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureBareMetalInstancesClient) (autorest.Response, error)
}

// AzureBareMetalInstancesShutdownFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureBareMetalInstancesShutdownFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureBareMetalInstancesClient) (autorest.Response, error)
}

// AzureBareMetalInstancesStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureBareMetalInstancesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureBareMetalInstancesClient) (autorest.Response, error)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Disk specifies the disk information fo the AzureBareMetal instance
type Disk struct {
	// Name - The disk name.
	Name *string `json:"name,omitempty"`
	// DiskSizeGB - Specifies the size of an empty data disk in gigabytes.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
	// Lun - READ-ONLY; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`
}

// MarshalJSON is the custom marshaler for Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.DiskSizeGB != nil {
		objectMap["diskSizeGB"] = d.DiskSizeGB
	}
	return json.Marshal(objectMap)
}

// Display detailed BareMetal operation information
type Display struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name. This form is also expected to include the publisher/company responsible. Use Title Casing. Begin with "Microsoft" for 1st party services.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation. This form should match the public documentation for the resource provider. Use Title Casing. For examples, refer to the “name” section.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation as shown to the user. This name should be concise (to fit in drop downs), but clear (self-documenting). Use Title Casing and include the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation as shown to the user. This description should be thorough, yet concise. It will be used in tool-tips and detailed views.
	Description *string `json:"description,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default value is 'user,system'
	Origin *string `json:"origin,omitempty"`
}

// ErrorDefinition error definition.
type ErrorDefinition struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; Internal error details.
	Details *[]ErrorDefinition `json:"details,omitempty"`
}

// ErrorResponse error response.
type ErrorResponse struct {
	// Error - The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// HardwareProfile specifies the hardware settings for the AzureBareMetal instance.
type HardwareProfile struct {
	// HardwareType - READ-ONLY; Name of the hardware type (vendor and/or their product name). Possible values include: 'CiscoUCS', 'HPE'
	HardwareType AzureBareMetalHardwareTypeNamesEnum `json:"hardwareType,omitempty"`
	// AzureBareMetalInstanceSize - READ-ONLY; Specifies the AzureBareMetal instance SKU. Possible values include: 'S72m', 'S144m', 'S72', 'S144', 'S192', 'S192m', 'S192xm', 'S96', 'S112', 'S224', 'S224m', 'S224om', 'S224oo', 'S224oom', 'S224ooo', 'S384', 'S384m', 'S384xm', 'S384xxm', 'S448', 'S448m', 'S448om', 'S448oo', 'S448oom', 'S448ooo', 'S576m', 'S576xm', 'S672', 'S672m', 'S672om', 'S672oo', 'S672oom', 'S672ooo', 'S768', 'S768m', 'S768xm', 'S896', 'S896m', 'S896om', 'S896oo', 'S896oom', 'S896ooo', 'S960m'
	AzureBareMetalInstanceSize AzureBareMetalInstanceSizeNamesEnum `json:"azureBareMetalInstanceSize,omitempty"`
}

// IPAddress specifies the IP address of the network interface.
type IPAddress struct {
	// IPAddress - Specifies the IP address of the network interface.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// NetworkProfile specifies the network settings for the AzureBareMetal instance disks.
type NetworkProfile struct {
	// NetworkInterfaces - Specifies the network interfaces for the AzureBareMetal instance.
	NetworkInterfaces *[]IPAddress `json:"networkInterfaces,omitempty"`
	// CircuitID - READ-ONLY; Specifies the circuit id for connecting to express route.
	CircuitID *string `json:"circuitId,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkProfile.
func (np NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if np.NetworkInterfaces != nil {
		objectMap["networkInterfaces"] = np.NetworkInterfaces
	}
	return json.Marshal(objectMap)
}

// Operation azureBareMetal operation information
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object. This name should match the action name that appears in RBAC / the event service.
	Name *string `json:"name,omitempty"`
	// Display - Displayed AzureBareMetal operation information
	Display *Display `json:"display,omitempty"`
	// IsDataAction - indicates whether an operation is a data action or not.
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// OperationList list of AzureBareMetal operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of AzureBareMetal operations
	Value *[]Operation `json:"value,omitempty"`
}

// OSProfile specifies the operating system settings for the AzureBareMetal instance.
type OSProfile struct {
	// ComputerName - Specifies the host OS name of the AzureBareMetal instance.
	ComputerName *string `json:"computerName,omitempty"`
	// OsType - READ-ONLY; This property allows you to specify the type of the OS.
	OsType *string `json:"osType,omitempty"`
	// Version - READ-ONLY; Specifies version of operating system.
	Version *string `json:"version,omitempty"`
	// SSHPublicKey - Specifies the SSH public key used to access the operating system.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// MarshalJSON is the custom marshaler for OSProfile.
func (op OSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.ComputerName != nil {
		objectMap["computerName"] = op.ComputerName
	}
	if op.SSHPublicKey != nil {
		objectMap["sshPublicKey"] = op.SSHPublicKey
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Result sample result definition
type Result struct {
	// SampleProperty - Sample property of type string
	SampleProperty *string `json:"sampleProperty,omitempty"`
}

// StorageProfile specifies the storage settings for the AzureBareMetal instance disks.
type StorageProfile struct {
	// NfsIPAddress - READ-ONLY; IP Address to connect to storage.
	NfsIPAddress *string `json:"nfsIpAddress,omitempty"`
	// OsDisks - Specifies information about the operating system disk used by baremetal instance.
	OsDisks *[]Disk `json:"osDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageProfile.
func (sp StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.OsDisks != nil {
		objectMap["osDisks"] = sp.OsDisks
	}
	return json.Marshal(objectMap)
}

// Tags tags field of the AzureBareMetal instance.
type Tags struct {
	// Tags - Tags field of the AzureBareMetal instance.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
