package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/appinsights/v1/insights"

// Column a column in a table.
type Column struct {
	// Name - The name of this column.
	Name *string `json:"name,omitempty"`
	// Type - The data type of this column.
	Type *string `json:"type,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	// Code - The error's code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Value - Indicates which value in 'target' is responsible for the error.
	Value *string `json:"value,omitempty"`
	// Resources - Indicates resources which were responsible for the error.
	Resources            *[]string   `json:"resources,omitempty"`
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// ErrorInfo ...
type ErrorInfo struct {
	// Code - A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Details - error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// Innererror - Inner error details if they exist.
	Innererror           *ErrorInfo  `json:"innererror,omitempty"`
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// ErrorResponse contains details when the response code indicates an error.
type ErrorResponse struct {
	// Error - The error details.
	Error *ErrorInfo `json:"error,omitempty"`
}

// EventsAiInfo AI related application info for an event result
type EventsAiInfo struct {
	// IKey - iKey of the app
	IKey *string `json:"iKey,omitempty"`
	// AppName - Name of the application
	AppName *string `json:"appName,omitempty"`
	// AppID - ID of the application
	AppID *string `json:"appId,omitempty"`
	// SdkVersion - SDK version of the application
	SdkVersion *string `json:"sdkVersion,omitempty"`
}

// EventsApplicationInfo application info for an event result
type EventsApplicationInfo struct {
	// Version - Version of the application
	Version *string `json:"version,omitempty"`
}

// EventsAvailabilityResultInfo the availability result info
type EventsAvailabilityResultInfo struct {
	// Name - The name of the availability result
	Name *string `json:"name,omitempty"`
	// Success - Indicates if the availability result was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the availability result
	Duration *int64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the availability result
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// Message - The message of the availability result
	Message *string `json:"message,omitempty"`
	// Location - The location of the availability result
	Location *string `json:"location,omitempty"`
	// ID - The ID of the availability result
	ID *string `json:"id,omitempty"`
	// Size - The size of the availability result
	Size *string `json:"size,omitempty"`
}

// EventsAvailabilityResultResult an availability result result
type EventsAvailabilityResultResult struct {
	AvailabilityResult *EventsAvailabilityResultInfo `json:"availabilityResult,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) MarshalJSON() ([]byte, error) {
	earr.Type = TypeAvailabilityResult
	objectMap := make(map[string]interface{})
	if earr.AvailabilityResult != nil {
		objectMap["availabilityResult"] = earr.AvailabilityResult
	}
	if earr.ID != nil {
		objectMap["id"] = earr.ID
	}
	if earr.Count != nil {
		objectMap["count"] = earr.Count
	}
	if earr.Timestamp != nil {
		objectMap["timestamp"] = earr.Timestamp
	}
	if earr.CustomDimensions != nil {
		objectMap["customDimensions"] = earr.CustomDimensions
	}
	if earr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = earr.CustomMeasurements
	}
	if earr.Operation != nil {
		objectMap["operation"] = earr.Operation
	}
	if earr.Session != nil {
		objectMap["session"] = earr.Session
	}
	if earr.User != nil {
		objectMap["user"] = earr.User
	}
	if earr.Cloud != nil {
		objectMap["cloud"] = earr.Cloud
	}
	if earr.Ai != nil {
		objectMap["ai"] = earr.Ai
	}
	if earr.Application != nil {
		objectMap["application"] = earr.Application
	}
	if earr.Client != nil {
		objectMap["client"] = earr.Client
	}
	if earr.Type != "" {
		objectMap["type"] = earr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return &earr, true
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsAvailabilityResultResult.
func (earr EventsAvailabilityResultResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &earr, true
}

// EventsBrowserTimingInfo the browser timing information
type EventsBrowserTimingInfo struct {
	// URLPath - The path of the URL
	URLPath *string `json:"urlPath,omitempty"`
	// URLHost - The host of the URL
	URLHost *string `json:"urlHost,omitempty"`
	// Name - The name of the page
	Name *string `json:"name,omitempty"`
	// URL - The url of the page
	URL *string `json:"url,omitempty"`
	// TotalDuration - The total duration of the load
	TotalDuration *int64 `json:"totalDuration,omitempty"`
	// PerformanceBucket - The performance bucket of the load
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// NetworkDuration - The network duration of the load
	NetworkDuration *int64 `json:"networkDuration,omitempty"`
	// SendDuration - The send duration of the load
	SendDuration *int64 `json:"sendDuration,omitempty"`
	// ReceiveDuration - The receive duration of the load
	ReceiveDuration *int64 `json:"receiveDuration,omitempty"`
	// ProcessingDuration - The processing duration of the load
	ProcessingDuration *int64 `json:"processingDuration,omitempty"`
}

// EventsBrowserTimingResult a browser timing result
type EventsBrowserTimingResult struct {
	BrowserTiming     *EventsBrowserTimingInfo     `json:"browserTiming,omitempty"`
	ClientPerformance *EventsClientPerformanceInfo `json:"clientPerformance,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) MarshalJSON() ([]byte, error) {
	ebtr.Type = TypeBrowserTiming
	objectMap := make(map[string]interface{})
	if ebtr.BrowserTiming != nil {
		objectMap["browserTiming"] = ebtr.BrowserTiming
	}
	if ebtr.ClientPerformance != nil {
		objectMap["clientPerformance"] = ebtr.ClientPerformance
	}
	if ebtr.ID != nil {
		objectMap["id"] = ebtr.ID
	}
	if ebtr.Count != nil {
		objectMap["count"] = ebtr.Count
	}
	if ebtr.Timestamp != nil {
		objectMap["timestamp"] = ebtr.Timestamp
	}
	if ebtr.CustomDimensions != nil {
		objectMap["customDimensions"] = ebtr.CustomDimensions
	}
	if ebtr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ebtr.CustomMeasurements
	}
	if ebtr.Operation != nil {
		objectMap["operation"] = ebtr.Operation
	}
	if ebtr.Session != nil {
		objectMap["session"] = ebtr.Session
	}
	if ebtr.User != nil {
		objectMap["user"] = ebtr.User
	}
	if ebtr.Cloud != nil {
		objectMap["cloud"] = ebtr.Cloud
	}
	if ebtr.Ai != nil {
		objectMap["ai"] = ebtr.Ai
	}
	if ebtr.Application != nil {
		objectMap["application"] = ebtr.Application
	}
	if ebtr.Client != nil {
		objectMap["client"] = ebtr.Client
	}
	if ebtr.Type != "" {
		objectMap["type"] = ebtr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return &ebtr, true
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsBrowserTimingResult.
func (ebtr EventsBrowserTimingResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &ebtr, true
}

// EventsClientInfo client info for an event result
type EventsClientInfo struct {
	// Model - Model of the client
	Model *string `json:"model,omitempty"`
	// Os - Operating system of the client
	Os *string `json:"os,omitempty"`
	// Type - Type of the client
	Type *string `json:"type,omitempty"`
	// Browser - Browser of the client
	Browser *string `json:"browser,omitempty"`
	// IP - IP address of the client
	IP *string `json:"ip,omitempty"`
	// City - City of the client
	City *string `json:"city,omitempty"`
	// StateOrProvince - State or province of the client
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// CountryOrRegion - Country or region of the client
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`
}

// EventsClientPerformanceInfo client performance information
type EventsClientPerformanceInfo struct {
	// Name - The name of the client performance
	Name *string `json:"name,omitempty"`
}

// EventsCloudInfo cloud info for an event result
type EventsCloudInfo struct {
	// RoleName - Role name of the cloud
	RoleName *string `json:"roleName,omitempty"`
	// RoleInstance - Role instance of the cloud
	RoleInstance *string `json:"roleInstance,omitempty"`
}

// EventsCustomEventInfo the custom event information
type EventsCustomEventInfo struct {
	// Name - The name of the custom event
	Name *string `json:"name,omitempty"`
}

// EventsCustomEventResult a custom event result
type EventsCustomEventResult struct {
	CustomEvent *EventsCustomEventInfo `json:"customEvent,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsCustomEventResult.
func (ecer EventsCustomEventResult) MarshalJSON() ([]byte, error) {
	ecer.Type = TypeCustomEvent
	objectMap := make(map[string]interface{})
	if ecer.CustomEvent != nil {
		objectMap["customEvent"] = ecer.CustomEvent
	}
	if ecer.ID != nil {
		objectMap["id"] = ecer.ID
	}
	if ecer.Count != nil {
		objectMap["count"] = ecer.Count
	}
	if ecer.Timestamp != nil {
		objectMap["timestamp"] = ecer.Timestamp
	}
	if ecer.CustomDimensions != nil {
		objectMap["customDimensions"] = ecer.CustomDimensions
	}
	if ecer.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ecer.CustomMeasurements
	}
	if ecer.Operation != nil {
		objectMap["operation"] = ecer.Operation
	}
	if ecer.Session != nil {
		objectMap["session"] = ecer.Session
	}
	if ecer.User != nil {
		objectMap["user"] = ecer.User
	}
	if ecer.Cloud != nil {
		objectMap["cloud"] = ecer.Cloud
	}
	if ecer.Ai != nil {
		objectMap["ai"] = ecer.Ai
	}
	if ecer.Application != nil {
		objectMap["application"] = ecer.Application
	}
	if ecer.Client != nil {
		objectMap["client"] = ecer.Client
	}
	if ecer.Type != "" {
		objectMap["type"] = ecer.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return &ecer, true
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsCustomEventResult.
func (ecer EventsCustomEventResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &ecer, true
}

// EventsCustomMetricInfo the custom metric info
type EventsCustomMetricInfo struct {
	// Name - The name of the custom metric
	Name *string `json:"name,omitempty"`
	// Value - The value of the custom metric
	Value *float64 `json:"value,omitempty"`
	// ValueSum - The sum of the custom metric
	ValueSum *float64 `json:"valueSum,omitempty"`
	// ValueCount - The count of the custom metric
	ValueCount *int32 `json:"valueCount,omitempty"`
	// ValueMin - The minimum value of the custom metric
	ValueMin *float64 `json:"valueMin,omitempty"`
	// ValueMax - The maximum value of the custom metric
	ValueMax *float64 `json:"valueMax,omitempty"`
	// ValueStdDev - The standard deviation of the custom metric
	ValueStdDev *float64 `json:"valueStdDev,omitempty"`
}

// EventsCustomMetricResult a custom metric result
type EventsCustomMetricResult struct {
	CustomMetric *EventsCustomMetricInfo `json:"customMetric,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) MarshalJSON() ([]byte, error) {
	ecmr.Type = TypeCustomMetric
	objectMap := make(map[string]interface{})
	if ecmr.CustomMetric != nil {
		objectMap["customMetric"] = ecmr.CustomMetric
	}
	if ecmr.ID != nil {
		objectMap["id"] = ecmr.ID
	}
	if ecmr.Count != nil {
		objectMap["count"] = ecmr.Count
	}
	if ecmr.Timestamp != nil {
		objectMap["timestamp"] = ecmr.Timestamp
	}
	if ecmr.CustomDimensions != nil {
		objectMap["customDimensions"] = ecmr.CustomDimensions
	}
	if ecmr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ecmr.CustomMeasurements
	}
	if ecmr.Operation != nil {
		objectMap["operation"] = ecmr.Operation
	}
	if ecmr.Session != nil {
		objectMap["session"] = ecmr.Session
	}
	if ecmr.User != nil {
		objectMap["user"] = ecmr.User
	}
	if ecmr.Cloud != nil {
		objectMap["cloud"] = ecmr.Cloud
	}
	if ecmr.Ai != nil {
		objectMap["ai"] = ecmr.Ai
	}
	if ecmr.Application != nil {
		objectMap["application"] = ecmr.Application
	}
	if ecmr.Client != nil {
		objectMap["client"] = ecmr.Client
	}
	if ecmr.Type != "" {
		objectMap["type"] = ecmr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return &ecmr, true
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsCustomMetricResult.
func (ecmr EventsCustomMetricResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &ecmr, true
}

// EventsDependencyInfo the dependency info
type EventsDependencyInfo struct {
	// Target - The target of the dependency
	Target *string `json:"target,omitempty"`
	// Data - The data of the dependency
	Data *string `json:"data,omitempty"`
	// Success - Indicates if the dependency was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the dependency
	Duration *int64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the dependency
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// ResultCode - The result code of the dependency
	ResultCode *string `json:"resultCode,omitempty"`
	// Type - The type of the dependency
	Type *string `json:"type,omitempty"`
	// Name - The name of the dependency
	Name *string `json:"name,omitempty"`
	// ID - The ID of the dependency
	ID *string `json:"id,omitempty"`
}

// EventsDependencyResult a dependency result
type EventsDependencyResult struct {
	Dependency *EventsDependencyInfo `json:"dependency,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsDependencyResult.
func (edr EventsDependencyResult) MarshalJSON() ([]byte, error) {
	edr.Type = TypeDependency
	objectMap := make(map[string]interface{})
	if edr.Dependency != nil {
		objectMap["dependency"] = edr.Dependency
	}
	if edr.ID != nil {
		objectMap["id"] = edr.ID
	}
	if edr.Count != nil {
		objectMap["count"] = edr.Count
	}
	if edr.Timestamp != nil {
		objectMap["timestamp"] = edr.Timestamp
	}
	if edr.CustomDimensions != nil {
		objectMap["customDimensions"] = edr.CustomDimensions
	}
	if edr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = edr.CustomMeasurements
	}
	if edr.Operation != nil {
		objectMap["operation"] = edr.Operation
	}
	if edr.Session != nil {
		objectMap["session"] = edr.Session
	}
	if edr.User != nil {
		objectMap["user"] = edr.User
	}
	if edr.Cloud != nil {
		objectMap["cloud"] = edr.Cloud
	}
	if edr.Ai != nil {
		objectMap["ai"] = edr.Ai
	}
	if edr.Application != nil {
		objectMap["application"] = edr.Application
	}
	if edr.Client != nil {
		objectMap["client"] = edr.Client
	}
	if edr.Type != "" {
		objectMap["type"] = edr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return &edr, true
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsDependencyResult.
func (edr EventsDependencyResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &edr, true
}

// EventsExceptionDetail exception details
type EventsExceptionDetail struct {
	// SeverityLevel - The severity level of the exception detail
	SeverityLevel *string `json:"severityLevel,omitempty"`
	// OuterID - The outer ID of the exception detail
	OuterID *string `json:"outerId,omitempty"`
	// Message - The message of the exception detail
	Message *string `json:"message,omitempty"`
	// Type - The type of the exception detail
	Type *string `json:"type,omitempty"`
	// ID - The ID of the exception detail
	ID *string `json:"id,omitempty"`
	// ParsedStack - The parsed stack
	ParsedStack *[]EventsExceptionDetailsParsedStack `json:"parsedStack,omitempty"`
}

// EventsExceptionDetailsParsedStack a parsed stack entry
type EventsExceptionDetailsParsedStack struct {
	// Assembly - The assembly of the stack entry
	Assembly *string `json:"assembly,omitempty"`
	// Method - The method of the stack entry
	Method *string `json:"method,omitempty"`
	// Level - The level of the stack entry
	Level *int64 `json:"level,omitempty"`
	// Line - The line of the stack entry
	Line *int64 `json:"line,omitempty"`
}

// EventsExceptionInfo the exception info
type EventsExceptionInfo struct {
	// SeverityLevel - The severity level of the exception
	SeverityLevel *int32 `json:"severityLevel,omitempty"`
	// ProblemID - The problem ID of the exception
	ProblemID *string `json:"problemId,omitempty"`
	// HandledAt - Indicates where the exception was handled at
	HandledAt *string `json:"handledAt,omitempty"`
	// Assembly - The assembly which threw the exception
	Assembly *string `json:"assembly,omitempty"`
	// Method - The method that threw the exception
	Method *string `json:"method,omitempty"`
	// Message - The message of the exception
	Message *string `json:"message,omitempty"`
	// Type - The type of the exception
	Type *string `json:"type,omitempty"`
	// OuterType - The outer type of the exception
	OuterType *string `json:"outerType,omitempty"`
	// OuterMethod - The outer method of the exception
	OuterMethod *string `json:"outerMethod,omitempty"`
	// OuterAssembly - The outer assembly of the exception
	OuterAssembly *string `json:"outerAssembly,omitempty"`
	// OuterMessage - The outer message of the exception
	OuterMessage *string `json:"outerMessage,omitempty"`
	// InnermostType - The inner most type of the exception
	InnermostType *string `json:"innermostType,omitempty"`
	// InnermostMessage - The inner most message of the exception
	InnermostMessage *string `json:"innermostMessage,omitempty"`
	// InnermostMethod - The inner most method of the exception
	InnermostMethod *string `json:"innermostMethod,omitempty"`
	// InnermostAssembly - The inner most assembly of the exception
	InnermostAssembly *string `json:"innermostAssembly,omitempty"`
	// Details - The details of the exception
	Details *[]EventsExceptionDetail `json:"details,omitempty"`
}

// EventsExceptionResult an exception result
type EventsExceptionResult struct {
	Exception *EventsExceptionInfo `json:"exception,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsExceptionResult.
func (eer EventsExceptionResult) MarshalJSON() ([]byte, error) {
	eer.Type = TypeException
	objectMap := make(map[string]interface{})
	if eer.Exception != nil {
		objectMap["exception"] = eer.Exception
	}
	if eer.ID != nil {
		objectMap["id"] = eer.ID
	}
	if eer.Count != nil {
		objectMap["count"] = eer.Count
	}
	if eer.Timestamp != nil {
		objectMap["timestamp"] = eer.Timestamp
	}
	if eer.CustomDimensions != nil {
		objectMap["customDimensions"] = eer.CustomDimensions
	}
	if eer.CustomMeasurements != nil {
		objectMap["customMeasurements"] = eer.CustomMeasurements
	}
	if eer.Operation != nil {
		objectMap["operation"] = eer.Operation
	}
	if eer.Session != nil {
		objectMap["session"] = eer.Session
	}
	if eer.User != nil {
		objectMap["user"] = eer.User
	}
	if eer.Cloud != nil {
		objectMap["cloud"] = eer.Cloud
	}
	if eer.Ai != nil {
		objectMap["ai"] = eer.Ai
	}
	if eer.Application != nil {
		objectMap["application"] = eer.Application
	}
	if eer.Client != nil {
		objectMap["client"] = eer.Client
	}
	if eer.Type != "" {
		objectMap["type"] = eer.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return &eer, true
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsExceptionResult.
func (eer EventsExceptionResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &eer, true
}

// EventsOperationInfo operation info for an event result
type EventsOperationInfo struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// ID - ID of the operation
	ID *string `json:"id,omitempty"`
	// ParentID - Parent ID of the operation
	ParentID *string `json:"parentId,omitempty"`
	// SyntheticSource - Synthetic source of the operation
	SyntheticSource *string `json:"syntheticSource,omitempty"`
}

// EventsPageViewInfo the page view information
type EventsPageViewInfo struct {
	// Name - The name of the page
	Name *string `json:"name,omitempty"`
	// URL - The URL of the page
	URL *string `json:"url,omitempty"`
	// Duration - The duration of the page view
	Duration *string `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the page view
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
}

// EventsPageViewResult a page view result
type EventsPageViewResult struct {
	PageView *EventsPageViewInfo `json:"pageView,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsPageViewResult.
func (epvr EventsPageViewResult) MarshalJSON() ([]byte, error) {
	epvr.Type = TypePageView
	objectMap := make(map[string]interface{})
	if epvr.PageView != nil {
		objectMap["pageView"] = epvr.PageView
	}
	if epvr.ID != nil {
		objectMap["id"] = epvr.ID
	}
	if epvr.Count != nil {
		objectMap["count"] = epvr.Count
	}
	if epvr.Timestamp != nil {
		objectMap["timestamp"] = epvr.Timestamp
	}
	if epvr.CustomDimensions != nil {
		objectMap["customDimensions"] = epvr.CustomDimensions
	}
	if epvr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = epvr.CustomMeasurements
	}
	if epvr.Operation != nil {
		objectMap["operation"] = epvr.Operation
	}
	if epvr.Session != nil {
		objectMap["session"] = epvr.Session
	}
	if epvr.User != nil {
		objectMap["user"] = epvr.User
	}
	if epvr.Cloud != nil {
		objectMap["cloud"] = epvr.Cloud
	}
	if epvr.Ai != nil {
		objectMap["ai"] = epvr.Ai
	}
	if epvr.Application != nil {
		objectMap["application"] = epvr.Application
	}
	if epvr.Client != nil {
		objectMap["client"] = epvr.Client
	}
	if epvr.Type != "" {
		objectMap["type"] = epvr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return &epvr, true
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsPageViewResult.
func (epvr EventsPageViewResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &epvr, true
}

// EventsPerformanceCounterInfo the performance counter info
type EventsPerformanceCounterInfo struct {
	// Value - The value of the performance counter
	Value *float64 `json:"value,omitempty"`
	// Name - The name of the performance counter
	Name *string `json:"name,omitempty"`
	// Category - The category of the performance counter
	Category *string `json:"category,omitempty"`
	// Counter - The counter of the performance counter
	Counter *string `json:"counter,omitempty"`
	// InstanceName - The instance name of the performance counter
	InstanceName *string `json:"instanceName,omitempty"`
	// Instance - The instance of the performance counter
	Instance *string `json:"instance,omitempty"`
}

// EventsPerformanceCounterResult a performance counter result
type EventsPerformanceCounterResult struct {
	PerformanceCounter *EventsPerformanceCounterInfo `json:"performanceCounter,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) MarshalJSON() ([]byte, error) {
	epcr.Type = TypePerformanceCounter
	objectMap := make(map[string]interface{})
	if epcr.PerformanceCounter != nil {
		objectMap["performanceCounter"] = epcr.PerformanceCounter
	}
	if epcr.ID != nil {
		objectMap["id"] = epcr.ID
	}
	if epcr.Count != nil {
		objectMap["count"] = epcr.Count
	}
	if epcr.Timestamp != nil {
		objectMap["timestamp"] = epcr.Timestamp
	}
	if epcr.CustomDimensions != nil {
		objectMap["customDimensions"] = epcr.CustomDimensions
	}
	if epcr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = epcr.CustomMeasurements
	}
	if epcr.Operation != nil {
		objectMap["operation"] = epcr.Operation
	}
	if epcr.Session != nil {
		objectMap["session"] = epcr.Session
	}
	if epcr.User != nil {
		objectMap["user"] = epcr.User
	}
	if epcr.Cloud != nil {
		objectMap["cloud"] = epcr.Cloud
	}
	if epcr.Ai != nil {
		objectMap["ai"] = epcr.Ai
	}
	if epcr.Application != nil {
		objectMap["application"] = epcr.Application
	}
	if epcr.Client != nil {
		objectMap["client"] = epcr.Client
	}
	if epcr.Type != "" {
		objectMap["type"] = epcr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return &epcr, true
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsPerformanceCounterResult.
func (epcr EventsPerformanceCounterResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &epcr, true
}

// EventsRequestInfo the request info
type EventsRequestInfo struct {
	// Name - The name of the request
	Name *string `json:"name,omitempty"`
	// URL - The URL of the request
	URL *string `json:"url,omitempty"`
	// Success - Indicates if the request was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the request
	Duration *float64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the request
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// ResultCode - The result code of the request
	ResultCode *string `json:"resultCode,omitempty"`
	// Source - The source of the request
	Source *string `json:"source,omitempty"`
	// ID - The ID of the request
	ID *string `json:"id,omitempty"`
}

// EventsRequestResult a request result
type EventsRequestResult struct {
	Request *EventsRequestInfo `json:"request,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsRequestResult.
func (errVar EventsRequestResult) MarshalJSON() ([]byte, error) {
	errVar.Type = TypeRequest
	objectMap := make(map[string]interface{})
	if errVar.Request != nil {
		objectMap["request"] = errVar.Request
	}
	if errVar.ID != nil {
		objectMap["id"] = errVar.ID
	}
	if errVar.Count != nil {
		objectMap["count"] = errVar.Count
	}
	if errVar.Timestamp != nil {
		objectMap["timestamp"] = errVar.Timestamp
	}
	if errVar.CustomDimensions != nil {
		objectMap["customDimensions"] = errVar.CustomDimensions
	}
	if errVar.CustomMeasurements != nil {
		objectMap["customMeasurements"] = errVar.CustomMeasurements
	}
	if errVar.Operation != nil {
		objectMap["operation"] = errVar.Operation
	}
	if errVar.Session != nil {
		objectMap["session"] = errVar.Session
	}
	if errVar.User != nil {
		objectMap["user"] = errVar.User
	}
	if errVar.Cloud != nil {
		objectMap["cloud"] = errVar.Cloud
	}
	if errVar.Ai != nil {
		objectMap["ai"] = errVar.Ai
	}
	if errVar.Application != nil {
		objectMap["application"] = errVar.Application
	}
	if errVar.Client != nil {
		objectMap["client"] = errVar.Client
	}
	if errVar.Type != "" {
		objectMap["type"] = errVar.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return &errVar, true
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsRequestResult.
func (errVar EventsRequestResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &errVar, true
}

// EventsResult an event query result.
type EventsResult struct {
	// AiMessages - OData messages for this response.
	AiMessages *[]ErrorInfo          `json:"@ai.messages,omitempty"`
	Value      BasicEventsResultData `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventsResult struct.
func (er *EventsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "@ai.messages":
			if v != nil {
				var aiMessages []ErrorInfo
				err = json.Unmarshal(*v, &aiMessages)
				if err != nil {
					return err
				}
				er.AiMessages = &aiMessages
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEventsResultData(*v)
				if err != nil {
					return err
				}
				er.Value = value
			}
		}
	}

	return nil
}

// BasicEventsResultData events query result data.
type BasicEventsResultData interface {
	AsEventsTraceResult() (*EventsTraceResult, bool)
	AsEventsCustomEventResult() (*EventsCustomEventResult, bool)
	AsEventsPageViewResult() (*EventsPageViewResult, bool)
	AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool)
	AsEventsRequestResult() (*EventsRequestResult, bool)
	AsEventsDependencyResult() (*EventsDependencyResult, bool)
	AsEventsExceptionResult() (*EventsExceptionResult, bool)
	AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool)
	AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool)
	AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool)
	AsEventsResultData() (*EventsResultData, bool)
}

// EventsResultData events query result data.
type EventsResultData struct {
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicEventsResultData(body []byte) (BasicEventsResultData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeTrace):
		var etr EventsTraceResult
		err := json.Unmarshal(body, &etr)
		return etr, err
	case string(TypeCustomEvent):
		var ecer EventsCustomEventResult
		err := json.Unmarshal(body, &ecer)
		return ecer, err
	case string(TypePageView):
		var epvr EventsPageViewResult
		err := json.Unmarshal(body, &epvr)
		return epvr, err
	case string(TypeBrowserTiming):
		var ebtr EventsBrowserTimingResult
		err := json.Unmarshal(body, &ebtr)
		return ebtr, err
	case string(TypeRequest):
		var errVar EventsRequestResult
		err := json.Unmarshal(body, &errVar)
		return errVar, err
	case string(TypeDependency):
		var edr EventsDependencyResult
		err := json.Unmarshal(body, &edr)
		return edr, err
	case string(TypeException):
		var eer EventsExceptionResult
		err := json.Unmarshal(body, &eer)
		return eer, err
	case string(TypeAvailabilityResult):
		var earr EventsAvailabilityResultResult
		err := json.Unmarshal(body, &earr)
		return earr, err
	case string(TypePerformanceCounter):
		var epcr EventsPerformanceCounterResult
		err := json.Unmarshal(body, &epcr)
		return epcr, err
	case string(TypeCustomMetric):
		var ecmr EventsCustomMetricResult
		err := json.Unmarshal(body, &ecmr)
		return ecmr, err
	default:
		var erd EventsResultData
		err := json.Unmarshal(body, &erd)
		return erd, err
	}
}
func unmarshalBasicEventsResultDataArray(body []byte) ([]BasicEventsResultData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	erdArray := make([]BasicEventsResultData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		erd, err := unmarshalBasicEventsResultData(*rawMessage)
		if err != nil {
			return nil, err
		}
		erdArray[index] = erd
	}
	return erdArray, nil
}

// MarshalJSON is the custom marshaler for EventsResultData.
func (erd EventsResultData) MarshalJSON() ([]byte, error) {
	erd.Type = TypeEventsResultData
	objectMap := make(map[string]interface{})
	if erd.ID != nil {
		objectMap["id"] = erd.ID
	}
	if erd.Count != nil {
		objectMap["count"] = erd.Count
	}
	if erd.Timestamp != nil {
		objectMap["timestamp"] = erd.Timestamp
	}
	if erd.CustomDimensions != nil {
		objectMap["customDimensions"] = erd.CustomDimensions
	}
	if erd.CustomMeasurements != nil {
		objectMap["customMeasurements"] = erd.CustomMeasurements
	}
	if erd.Operation != nil {
		objectMap["operation"] = erd.Operation
	}
	if erd.Session != nil {
		objectMap["session"] = erd.Session
	}
	if erd.User != nil {
		objectMap["user"] = erd.User
	}
	if erd.Cloud != nil {
		objectMap["cloud"] = erd.Cloud
	}
	if erd.Ai != nil {
		objectMap["ai"] = erd.Ai
	}
	if erd.Application != nil {
		objectMap["application"] = erd.Application
	}
	if erd.Client != nil {
		objectMap["client"] = erd.Client
	}
	if erd.Type != "" {
		objectMap["type"] = erd.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return nil, false
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsEventsResultData() (*EventsResultData, bool) {
	return &erd, true
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsResultData.
func (erd EventsResultData) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &erd, true
}

// EventsResultDataCustomDimensions custom dimensions of the event
type EventsResultDataCustomDimensions struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties  map[string]interface{} `json:""`
	AdditionalProperties1 interface{}            `json:"additionalProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsResultDataCustomDimensions.
func (erdD EventsResultDataCustomDimensions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erdD.AdditionalProperties1 != nil {
		objectMap["additionalProperties"] = erdD.AdditionalProperties1
	}
	for k, v := range erdD.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventsResultDataCustomDimensions struct.
func (erdD *EventsResultDataCustomDimensions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if erdD.AdditionalProperties == nil {
					erdD.AdditionalProperties = make(map[string]interface{})
				}
				erdD.AdditionalProperties[k] = additionalProperties
			}
		case "additionalProperties":
			if v != nil {
				var additionalProperties1 interface{}
				err = json.Unmarshal(*v, &additionalProperties1)
				if err != nil {
					return err
				}
				erdD.AdditionalProperties1 = additionalProperties1
			}
		}
	}

	return nil
}

// EventsResultDataCustomMeasurements custom measurements of the event
type EventsResultDataCustomMeasurements struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties  map[string]interface{} `json:""`
	AdditionalProperties1 interface{}            `json:"additionalProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsResultDataCustomMeasurements.
func (erdM EventsResultDataCustomMeasurements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erdM.AdditionalProperties1 != nil {
		objectMap["additionalProperties"] = erdM.AdditionalProperties1
	}
	for k, v := range erdM.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventsResultDataCustomMeasurements struct.
func (erdM *EventsResultDataCustomMeasurements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if erdM.AdditionalProperties == nil {
					erdM.AdditionalProperties = make(map[string]interface{})
				}
				erdM.AdditionalProperties[k] = additionalProperties
			}
		case "additionalProperties":
			if v != nil {
				var additionalProperties1 interface{}
				err = json.Unmarshal(*v, &additionalProperties1)
				if err != nil {
					return err
				}
				erdM.AdditionalProperties1 = additionalProperties1
			}
		}
	}

	return nil
}

// EventsResults an events query result.
type EventsResults struct {
	autorest.Response `json:"-"`
	// OdataContext - OData context metadata endpoint for this response
	OdataContext *string `json:"@odata.context,omitempty"`
	// AiMessages - OData messages for this response.
	AiMessages *[]ErrorInfo `json:"@ai.messages,omitempty"`
	// Value - Contents of the events query result.
	Value *[]BasicEventsResultData `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventsResults struct.
func (er *EventsResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "@odata.context":
			if v != nil {
				var odataContext string
				err = json.Unmarshal(*v, &odataContext)
				if err != nil {
					return err
				}
				er.OdataContext = &odataContext
			}
		case "@ai.messages":
			if v != nil {
				var aiMessages []ErrorInfo
				err = json.Unmarshal(*v, &aiMessages)
				if err != nil {
					return err
				}
				er.AiMessages = &aiMessages
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEventsResultDataArray(*v)
				if err != nil {
					return err
				}
				er.Value = &value
			}
		}
	}

	return nil
}

// EventsSessionInfo session info for an event result
type EventsSessionInfo struct {
	// ID - ID of the session
	ID *string `json:"id,omitempty"`
}

// EventsTraceInfo the trace information
type EventsTraceInfo struct {
	// Message - The trace message
	Message *string `json:"message,omitempty"`
	// SeverityLevel - The trace severity level
	SeverityLevel *int32 `json:"severityLevel,omitempty"`
}

// EventsTraceResult a trace result
type EventsTraceResult struct {
	Trace *EventsTraceInfo `json:"trace,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensions `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurements `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfo `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfo `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfo `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfo `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfo `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfo `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfo `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventsTraceResult.
func (etr EventsTraceResult) MarshalJSON() ([]byte, error) {
	etr.Type = TypeTrace
	objectMap := make(map[string]interface{})
	if etr.Trace != nil {
		objectMap["trace"] = etr.Trace
	}
	if etr.ID != nil {
		objectMap["id"] = etr.ID
	}
	if etr.Count != nil {
		objectMap["count"] = etr.Count
	}
	if etr.Timestamp != nil {
		objectMap["timestamp"] = etr.Timestamp
	}
	if etr.CustomDimensions != nil {
		objectMap["customDimensions"] = etr.CustomDimensions
	}
	if etr.CustomMeasurements != nil {
		objectMap["customMeasurements"] = etr.CustomMeasurements
	}
	if etr.Operation != nil {
		objectMap["operation"] = etr.Operation
	}
	if etr.Session != nil {
		objectMap["session"] = etr.Session
	}
	if etr.User != nil {
		objectMap["user"] = etr.User
	}
	if etr.Cloud != nil {
		objectMap["cloud"] = etr.Cloud
	}
	if etr.Ai != nil {
		objectMap["ai"] = etr.Ai
	}
	if etr.Application != nil {
		objectMap["application"] = etr.Application
	}
	if etr.Client != nil {
		objectMap["client"] = etr.Client
	}
	if etr.Type != "" {
		objectMap["type"] = etr.Type
	}
	return json.Marshal(objectMap)
}

// AsEventsTraceResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsTraceResult() (*EventsTraceResult, bool) {
	return &etr, true
}

// AsEventsCustomEventResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsCustomEventResult() (*EventsCustomEventResult, bool) {
	return nil, false
}

// AsEventsPageViewResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsPageViewResult() (*EventsPageViewResult, bool) {
	return nil, false
}

// AsEventsBrowserTimingResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsBrowserTimingResult() (*EventsBrowserTimingResult, bool) {
	return nil, false
}

// AsEventsRequestResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsRequestResult() (*EventsRequestResult, bool) {
	return nil, false
}

// AsEventsDependencyResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsDependencyResult() (*EventsDependencyResult, bool) {
	return nil, false
}

// AsEventsExceptionResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsExceptionResult() (*EventsExceptionResult, bool) {
	return nil, false
}

// AsEventsAvailabilityResultResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsAvailabilityResultResult() (*EventsAvailabilityResultResult, bool) {
	return nil, false
}

// AsEventsPerformanceCounterResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsPerformanceCounterResult() (*EventsPerformanceCounterResult, bool) {
	return nil, false
}

// AsEventsCustomMetricResult is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsCustomMetricResult() (*EventsCustomMetricResult, bool) {
	return nil, false
}

// AsEventsResultData is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsEventsResultData() (*EventsResultData, bool) {
	return nil, false
}

// AsBasicEventsResultData is the BasicEventsResultData implementation for EventsTraceResult.
func (etr EventsTraceResult) AsBasicEventsResultData() (BasicEventsResultData, bool) {
	return &etr, true
}

// EventsUserInfo user info for an event result
type EventsUserInfo struct {
	// ID - ID of the user
	ID *string `json:"id,omitempty"`
	// AccountID - Account ID of the user
	AccountID *string `json:"accountId,omitempty"`
	// AuthenticatedID - Authenticated ID of the user
	AuthenticatedID *string `json:"authenticatedId,omitempty"`
}

// ListMetricsResultsItem ...
type ListMetricsResultsItem struct {
	autorest.Response `json:"-"`
	Value             *[]MetricsResultsItem `json:"value,omitempty"`
}

// MetadataApplication application Insights apps that were part of the metadata request and that the user
// has access to.
type MetadataApplication struct {
	// ID - The ID of the Application Insights app.
	ID *string `json:"id,omitempty"`
	// ResourceID - The ARM resource ID of the Application Insights app.
	ResourceID *string `json:"resourceId,omitempty"`
	// Name - The name of the Application Insights app.
	Name *string `json:"name,omitempty"`
	// Region - The Azure region of the Application Insights app.
	Region *string `json:"region,omitempty"`
	// Tables - The list of custom tables for the Application Insights app.
	Tables *[]string `json:"tables,omitempty"`
	// Functions - The list of stored functions on the Application Insights app
	Functions *[]string `json:"functions,omitempty"`
	// TableGroups - The list of table groups on the Application Insights app
	TableGroups *[]string `json:"tableGroups,omitempty"`
}

// MetadataFunction functions are stored Kusto queries that can be specified as part of queries by using
// their name.
type MetadataFunction struct {
	// ID - The ID of the function.
	ID *string `json:"id,omitempty"`
	// Name - The name of the function, to be used in queries.
	Name *string `json:"name,omitempty"`
	// Parameters - The parameters/arguments of the function, if any.
	Parameters *string `json:"parameters,omitempty"`
	// DisplayName - The display name of the function.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the function.
	Description *string `json:"description,omitempty"`
	// Body - The KQL body of the function.
	Body *string `json:"body,omitempty"`
}

// MetadataResults the metadata result for the app, including available tables, etc.
type MetadataResults struct {
	autorest.Response `json:"-"`
	// TableGroups - The list of groups of tables on the app.
	TableGroups *[]MetadataTableGroup `json:"tableGroups,omitempty"`
	// Tables - The list of tables and columns that comprise the schema of the app.
	Tables *[]MetadataTable `json:"tables,omitempty"`
	// Functions - The list of functions stored on the app.
	Functions *[]MetadataFunction `json:"functions,omitempty"`
	// Applications - The list of Application Insights apps that were referenced in the metadata request.
	Applications *[]MetadataApplication `json:"applications,omitempty"`
}

// MetadataTable tables are part of the app schema, and contain a list of columns and a reference to other
// relevant metadata items.
type MetadataTable struct {
	// ID - The ID of the table
	ID *string `json:"id,omitempty"`
	// Name - The name of the table
	Name *string `json:"name,omitempty"`
	// Description - The description of the table
	Description *string `json:"description,omitempty"`
	// TimespanColumn - The column associated with the timespan query parameter for the table
	TimespanColumn *string `json:"timespanColumn,omitempty"`
	// Columns - The list of columns defined on the table
	Columns *[]MetadataTableColumnsItem `json:"columns,omitempty"`
}

// MetadataTableColumnsItem ...
type MetadataTableColumnsItem struct {
	// Name - The name of the column
	Name *string `json:"name,omitempty"`
	// Description - The description of the column
	Description *string `json:"description,omitempty"`
	// Type - The data type of the column. Possible values include: 'Bool', 'Datetime', 'Dynamic', 'Int', 'Long', 'Real', 'String'
	Type MetadataColumnDataType `json:"type,omitempty"`
	// IsPreferredFacet - A flag indicating this column is a preferred facet
	IsPreferredFacet *bool `json:"isPreferredFacet,omitempty"`
	// Source - an indication of the source of the column, used only when multiple apps have conflicting definition for the column
	Source interface{} `json:"source,omitempty"`
}

// MetadataTableGroup the table grouping can be either an Application Insights schema or a Log Analytics
// solution.
type MetadataTableGroup struct {
	// ID - The ID of the table group
	ID *string `json:"id,omitempty"`
	// Name - The name of the table group
	Name *string `json:"name,omitempty"`
	// Source - The source of the table group, can be either AI or OMS for Log Analytics workspaces
	Source *string `json:"source,omitempty"`
	// DisplayName - The display name of the table group
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the table group
	Description *string `json:"description,omitempty"`
	// Tables - The list of tables contained in the table group
	Tables *[]string `json:"tables,omitempty"`
}

// MetricsPostBodySchema a metric request
type MetricsPostBodySchema struct {
	// ID - An identifier for this query.  Must be unique within the post body of the request.  This identifier will be the 'id' property of the response object representing this query.
	ID *string `json:"id,omitempty"`
	// Parameters - The parameters for a single metrics query
	Parameters *MetricsPostBodySchemaParameters `json:"parameters,omitempty"`
}

// MetricsPostBodySchemaParameters the parameters for a single metrics query
type MetricsPostBodySchemaParameters struct {
	// MetricID - Possible values include: 'Requestscount', 'Requestsduration', 'Requestsfailed', 'Userscount', 'Usersauthenticated', 'PageViewscount', 'PageViewsduration', 'ClientprocessingDuration', 'ClientreceiveDuration', 'ClientnetworkDuration', 'ClientsendDuration', 'ClienttotalDuration', 'Dependenciescount', 'Dependenciesfailed', 'Dependenciesduration', 'Exceptionscount', 'Exceptionsbrowser', 'Exceptionsserver', 'Sessionscount', 'PerformanceCountersrequestExecutionTime', 'PerformanceCountersrequestsPerSecond', 'PerformanceCountersrequestsInQueue', 'PerformanceCountersmemoryAvailableBytes', 'PerformanceCountersexceptionsPerSecond', 'PerformanceCountersprocessCPUPercentage', 'PerformanceCountersprocessIOBytesPerSecond', 'PerformanceCountersprocessPrivateBytes', 'PerformanceCountersprocessorCPUPercentage', 'AvailabilityResultsavailabilityPercentage', 'AvailabilityResultsduration', 'BillingtelemetryCount', 'CustomEventscount'
	MetricID    MetricID              `json:"metricId,omitempty"`
	Timespan    *string               `json:"timespan,omitempty"`
	Aggregation *[]MetricsAggregation `json:"aggregation,omitempty"`
	Interval    *string               `json:"interval,omitempty"`
	Segment     *[]MetricsSegment     `json:"segment,omitempty"`
	Top         *int32                `json:"top,omitempty"`
	Orderby     *string               `json:"orderby,omitempty"`
	Filter      *string               `json:"filter,omitempty"`
}

// MetricsResult a metric result.
type MetricsResult struct {
	autorest.Response `json:"-"`
	Value             *MetricsResultInfo `json:"value,omitempty"`
}

// MetricsResultInfo a metric result data.
type MetricsResultInfo struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Start - Start time of the metric.
	Start *date.Time `json:"start,omitempty"`
	// End - Start time of the metric.
	End *date.Time `json:"end,omitempty"`
	// Interval - The interval used to segment the metric data.
	Interval *string `json:"interval,omitempty"`
	// Segments - Segmented metric data (if segmented).
	Segments *[]MetricsSegmentInfo `json:"segments,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricsResultInfo.
func (mri MetricsResultInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mri.Start != nil {
		objectMap["start"] = mri.Start
	}
	if mri.End != nil {
		objectMap["end"] = mri.End
	}
	if mri.Interval != nil {
		objectMap["interval"] = mri.Interval
	}
	if mri.Segments != nil {
		objectMap["segments"] = mri.Segments
	}
	for k, v := range mri.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricsResultInfo struct.
func (mri *MetricsResultInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if mri.AdditionalProperties == nil {
					mri.AdditionalProperties = make(map[string]interface{})
				}
				mri.AdditionalProperties[k] = additionalProperties
			}
		case "start":
			if v != nil {
				var start date.Time
				err = json.Unmarshal(*v, &start)
				if err != nil {
					return err
				}
				mri.Start = &start
			}
		case "end":
			if v != nil {
				var end date.Time
				err = json.Unmarshal(*v, &end)
				if err != nil {
					return err
				}
				mri.End = &end
			}
		case "interval":
			if v != nil {
				var interval string
				err = json.Unmarshal(*v, &interval)
				if err != nil {
					return err
				}
				mri.Interval = &interval
			}
		case "segments":
			if v != nil {
				var segments []MetricsSegmentInfo
				err = json.Unmarshal(*v, &segments)
				if err != nil {
					return err
				}
				mri.Segments = &segments
			}
		}
	}

	return nil
}

// MetricsResultsItem ...
type MetricsResultsItem struct {
	// ID - The specified ID for this metric.
	ID *string `json:"id,omitempty"`
	// Status - The HTTP status code of this metric query.
	Status *int32 `json:"status,omitempty"`
	// Body - The results of this metric query.
	Body *MetricsResult `json:"body,omitempty"`
}

// MetricsSegmentInfo a metric segment
type MetricsSegmentInfo struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Start - Start time of the metric segment (only when an interval was specified).
	Start *date.Time `json:"start,omitempty"`
	// End - Start time of the metric segment (only when an interval was specified).
	End *date.Time `json:"end,omitempty"`
	// Segments - Segmented metric data (if further segmented).
	Segments *[]MetricsSegmentInfo `json:"segments,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricsSegmentInfo.
func (msi MetricsSegmentInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Start != nil {
		objectMap["start"] = msi.Start
	}
	if msi.End != nil {
		objectMap["end"] = msi.End
	}
	if msi.Segments != nil {
		objectMap["segments"] = msi.Segments
	}
	for k, v := range msi.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricsSegmentInfo struct.
func (msi *MetricsSegmentInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if msi.AdditionalProperties == nil {
					msi.AdditionalProperties = make(map[string]interface{})
				}
				msi.AdditionalProperties[k] = additionalProperties
			}
		case "start":
			if v != nil {
				var start date.Time
				err = json.Unmarshal(*v, &start)
				if err != nil {
					return err
				}
				msi.Start = &start
			}
		case "end":
			if v != nil {
				var end date.Time
				err = json.Unmarshal(*v, &end)
				if err != nil {
					return err
				}
				msi.End = &end
			}
		case "segments":
			if v != nil {
				var segments []MetricsSegmentInfo
				err = json.Unmarshal(*v, &segments)
				if err != nil {
					return err
				}
				msi.Segments = &segments
			}
		}
	}

	return nil
}

// QueryBody the Analytics query. Learn more about the [Analytics query
// syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/)
type QueryBody struct {
	// Query - The query to execute.
	Query *string `json:"query,omitempty"`
	// Timespan - Optional. The timespan over which to query data. This is an ISO8601 time period value.  This timespan is applied in addition to any that are specified in the query expression.
	Timespan *string `json:"timespan,omitempty"`
	// Applications - A list of Application IDs for cross-application queries.
	Applications *[]string `json:"applications,omitempty"`
}

// QueryResults contains the tables, columns & rows resulting from a query.
type QueryResults struct {
	autorest.Response `json:"-"`
	// Tables - The list of tables, columns and rows.
	Tables *[]Table `json:"tables,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Table contains the columns and rows for one table in a query response.
type Table struct {
	// Name - The name of the table.
	Name *string `json:"name,omitempty"`
	// Columns - The list of columns in this table.
	Columns *[]Column `json:"columns,omitempty"`
	// Rows - The resulting rows from this query.
	Rows *[][]interface{} `json:"rows,omitempty"`
}
