// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package automation

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/automation/mgmt/2015-10-31/automation"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccountState = original.AccountState

const (
	Ok          AccountState = original.Ok
	Suspended   AccountState = original.Suspended
	Unavailable AccountState = original.Unavailable
)

type AgentRegistrationKeyName = original.AgentRegistrationKeyName

const (
	Primary   AgentRegistrationKeyName = original.Primary
	Secondary AgentRegistrationKeyName = original.Secondary
)

type ContentSourceType = original.ContentSourceType

const (
	EmbeddedContent ContentSourceType = original.EmbeddedContent
	URI             ContentSourceType = original.URI
)

type DscConfigurationProvisioningState = original.DscConfigurationProvisioningState

const (
	Succeeded DscConfigurationProvisioningState = original.Succeeded
)

type DscConfigurationState = original.DscConfigurationState

const (
	DscConfigurationStateEdit      DscConfigurationState = original.DscConfigurationStateEdit
	DscConfigurationStateNew       DscConfigurationState = original.DscConfigurationStateNew
	DscConfigurationStatePublished DscConfigurationState = original.DscConfigurationStatePublished
)

type GroupTypeEnum = original.GroupTypeEnum

const (
	System GroupTypeEnum = original.System
	User   GroupTypeEnum = original.User
)

type HTTPStatusCode = original.HTTPStatusCode

const (
	Accepted                     HTTPStatusCode = original.Accepted
	Ambiguous                    HTTPStatusCode = original.Ambiguous
	BadGateway                   HTTPStatusCode = original.BadGateway
	BadRequest                   HTTPStatusCode = original.BadRequest
	Conflict                     HTTPStatusCode = original.Conflict
	Continue                     HTTPStatusCode = original.Continue
	Created                      HTTPStatusCode = original.Created
	ExpectationFailed            HTTPStatusCode = original.ExpectationFailed
	Forbidden                    HTTPStatusCode = original.Forbidden
	Found                        HTTPStatusCode = original.Found
	GatewayTimeout               HTTPStatusCode = original.GatewayTimeout
	Gone                         HTTPStatusCode = original.Gone
	HTTPVersionNotSupported      HTTPStatusCode = original.HTTPVersionNotSupported
	InternalServerError          HTTPStatusCode = original.InternalServerError
	LengthRequired               HTTPStatusCode = original.LengthRequired
	MethodNotAllowed             HTTPStatusCode = original.MethodNotAllowed
	Moved                        HTTPStatusCode = original.Moved
	MovedPermanently             HTTPStatusCode = original.MovedPermanently
	MultipleChoices              HTTPStatusCode = original.MultipleChoices
	NoContent                    HTTPStatusCode = original.NoContent
	NonAuthoritativeInformation  HTTPStatusCode = original.NonAuthoritativeInformation
	NotAcceptable                HTTPStatusCode = original.NotAcceptable
	NotFound                     HTTPStatusCode = original.NotFound
	NotImplemented               HTTPStatusCode = original.NotImplemented
	NotModified                  HTTPStatusCode = original.NotModified
	OK                           HTTPStatusCode = original.OK
	PartialContent               HTTPStatusCode = original.PartialContent
	PaymentRequired              HTTPStatusCode = original.PaymentRequired
	PreconditionFailed           HTTPStatusCode = original.PreconditionFailed
	ProxyAuthenticationRequired  HTTPStatusCode = original.ProxyAuthenticationRequired
	Redirect                     HTTPStatusCode = original.Redirect
	RedirectKeepVerb             HTTPStatusCode = original.RedirectKeepVerb
	RedirectMethod               HTTPStatusCode = original.RedirectMethod
	RequestedRangeNotSatisfiable HTTPStatusCode = original.RequestedRangeNotSatisfiable
	RequestEntityTooLarge        HTTPStatusCode = original.RequestEntityTooLarge
	RequestTimeout               HTTPStatusCode = original.RequestTimeout
	RequestURITooLong            HTTPStatusCode = original.RequestURITooLong
	ResetContent                 HTTPStatusCode = original.ResetContent
	SeeOther                     HTTPStatusCode = original.SeeOther
	ServiceUnavailable           HTTPStatusCode = original.ServiceUnavailable
	SwitchingProtocols           HTTPStatusCode = original.SwitchingProtocols
	TemporaryRedirect            HTTPStatusCode = original.TemporaryRedirect
	Unauthorized                 HTTPStatusCode = original.Unauthorized
	UnsupportedMediaType         HTTPStatusCode = original.UnsupportedMediaType
	Unused                       HTTPStatusCode = original.Unused
	UpgradeRequired              HTTPStatusCode = original.UpgradeRequired
	UseProxy                     HTTPStatusCode = original.UseProxy
)

type JobProvisioningState = original.JobProvisioningState

const (
	JobProvisioningStateFailed     JobProvisioningState = original.JobProvisioningStateFailed
	JobProvisioningStateProcessing JobProvisioningState = original.JobProvisioningStateProcessing
	JobProvisioningStateSucceeded  JobProvisioningState = original.JobProvisioningStateSucceeded
	JobProvisioningStateSuspended  JobProvisioningState = original.JobProvisioningStateSuspended
)

type JobStatus = original.JobStatus

const (
	JobStatusActivating   JobStatus = original.JobStatusActivating
	JobStatusBlocked      JobStatus = original.JobStatusBlocked
	JobStatusCompleted    JobStatus = original.JobStatusCompleted
	JobStatusDisconnected JobStatus = original.JobStatusDisconnected
	JobStatusFailed       JobStatus = original.JobStatusFailed
	JobStatusNew          JobStatus = original.JobStatusNew
	JobStatusRemoving     JobStatus = original.JobStatusRemoving
	JobStatusResuming     JobStatus = original.JobStatusResuming
	JobStatusRunning      JobStatus = original.JobStatusRunning
	JobStatusStopped      JobStatus = original.JobStatusStopped
	JobStatusStopping     JobStatus = original.JobStatusStopping
	JobStatusSuspended    JobStatus = original.JobStatusSuspended
	JobStatusSuspending   JobStatus = original.JobStatusSuspending
)

type JobStreamType = original.JobStreamType

const (
	Any      JobStreamType = original.Any
	Debug    JobStreamType = original.Debug
	Error    JobStreamType = original.Error
	Output   JobStreamType = original.Output
	Progress JobStreamType = original.Progress
	Verbose  JobStreamType = original.Verbose
	Warning  JobStreamType = original.Warning
)

type KeyName = original.KeyName

const (
	KeyNamePrimary   KeyName = original.KeyNamePrimary
	KeyNameSecondary KeyName = original.KeyNameSecondary
)

type KeyPermissions = original.KeyPermissions

const (
	Full KeyPermissions = original.Full
	Read KeyPermissions = original.Read
)

type ModuleProvisioningState = original.ModuleProvisioningState

const (
	ModuleProvisioningStateActivitiesStored            ModuleProvisioningState = original.ModuleProvisioningStateActivitiesStored
	ModuleProvisioningStateCancelled                   ModuleProvisioningState = original.ModuleProvisioningStateCancelled
	ModuleProvisioningStateConnectionTypeImported      ModuleProvisioningState = original.ModuleProvisioningStateConnectionTypeImported
	ModuleProvisioningStateContentDownloaded           ModuleProvisioningState = original.ModuleProvisioningStateContentDownloaded
	ModuleProvisioningStateContentRetrieved            ModuleProvisioningState = original.ModuleProvisioningStateContentRetrieved
	ModuleProvisioningStateContentStored               ModuleProvisioningState = original.ModuleProvisioningStateContentStored
	ModuleProvisioningStateContentValidated            ModuleProvisioningState = original.ModuleProvisioningStateContentValidated
	ModuleProvisioningStateCreated                     ModuleProvisioningState = original.ModuleProvisioningStateCreated
	ModuleProvisioningStateCreating                    ModuleProvisioningState = original.ModuleProvisioningStateCreating
	ModuleProvisioningStateFailed                      ModuleProvisioningState = original.ModuleProvisioningStateFailed
	ModuleProvisioningStateModuleDataStored            ModuleProvisioningState = original.ModuleProvisioningStateModuleDataStored
	ModuleProvisioningStateModuleImportRunbookComplete ModuleProvisioningState = original.ModuleProvisioningStateModuleImportRunbookComplete
	ModuleProvisioningStateRunningImportModuleRunbook  ModuleProvisioningState = original.ModuleProvisioningStateRunningImportModuleRunbook
	ModuleProvisioningStateStartingImportModuleRunbook ModuleProvisioningState = original.ModuleProvisioningStateStartingImportModuleRunbook
	ModuleProvisioningStateSucceeded                   ModuleProvisioningState = original.ModuleProvisioningStateSucceeded
	ModuleProvisioningStateUpdating                    ModuleProvisioningState = original.ModuleProvisioningStateUpdating
)

type RunbookProvisioningState = original.RunbookProvisioningState

const (
	RunbookProvisioningStateSucceeded RunbookProvisioningState = original.RunbookProvisioningStateSucceeded
)

type RunbookState = original.RunbookState

const (
	RunbookStateEdit      RunbookState = original.RunbookStateEdit
	RunbookStateNew       RunbookState = original.RunbookStateNew
	RunbookStatePublished RunbookState = original.RunbookStatePublished
)

type RunbookTypeEnum = original.RunbookTypeEnum

const (
	Graph                   RunbookTypeEnum = original.Graph
	GraphPowerShell         RunbookTypeEnum = original.GraphPowerShell
	GraphPowerShellWorkflow RunbookTypeEnum = original.GraphPowerShellWorkflow
	PowerShell              RunbookTypeEnum = original.PowerShell
	PowerShellWorkflow      RunbookTypeEnum = original.PowerShellWorkflow
	Script                  RunbookTypeEnum = original.Script
)

type ScheduleDay = original.ScheduleDay

const (
	Friday    ScheduleDay = original.Friday
	Monday    ScheduleDay = original.Monday
	Saturday  ScheduleDay = original.Saturday
	Sunday    ScheduleDay = original.Sunday
	Thursday  ScheduleDay = original.Thursday
	Tuesday   ScheduleDay = original.Tuesday
	Wednesday ScheduleDay = original.Wednesday
)

type ScheduleFrequency = original.ScheduleFrequency

const (
	Day     ScheduleFrequency = original.Day
	Hour    ScheduleFrequency = original.Hour
	Minute  ScheduleFrequency = original.Minute
	Month   ScheduleFrequency = original.Month
	OneTime ScheduleFrequency = original.OneTime
	Week    ScheduleFrequency = original.Week
)

type SkuNameEnum = original.SkuNameEnum

const (
	Basic SkuNameEnum = original.Basic
	Free  SkuNameEnum = original.Free
)

type Account = original.Account
type AccountClient = original.AccountClient
type AccountCreateOrUpdateParameters = original.AccountCreateOrUpdateParameters
type AccountCreateOrUpdateProperties = original.AccountCreateOrUpdateProperties
type AccountListResult = original.AccountListResult
type AccountListResultIterator = original.AccountListResultIterator
type AccountListResultPage = original.AccountListResultPage
type AccountProperties = original.AccountProperties
type AccountUpdateParameters = original.AccountUpdateParameters
type AccountUpdateProperties = original.AccountUpdateProperties
type Activity = original.Activity
type ActivityClient = original.ActivityClient
type ActivityListResult = original.ActivityListResult
type ActivityListResultIterator = original.ActivityListResultIterator
type ActivityListResultPage = original.ActivityListResultPage
type ActivityOutputType = original.ActivityOutputType
type ActivityParameter = original.ActivityParameter
type ActivityParameterSet = original.ActivityParameterSet
type ActivityParameterValidationSet = original.ActivityParameterValidationSet
type ActivityProperties = original.ActivityProperties
type AdvancedSchedule = original.AdvancedSchedule
type AdvancedScheduleMonthlyOccurrence = original.AdvancedScheduleMonthlyOccurrence
type AgentRegistration = original.AgentRegistration
type AgentRegistrationInformationClient = original.AgentRegistrationInformationClient
type AgentRegistrationKeys = original.AgentRegistrationKeys
type AgentRegistrationRegenerateKeyParameter = original.AgentRegistrationRegenerateKeyParameter
type BaseClient = original.BaseClient
type Certificate = original.Certificate
type CertificateClient = original.CertificateClient
type CertificateCreateOrUpdateParameters = original.CertificateCreateOrUpdateParameters
type CertificateCreateOrUpdateProperties = original.CertificateCreateOrUpdateProperties
type CertificateListResult = original.CertificateListResult
type CertificateListResultIterator = original.CertificateListResultIterator
type CertificateListResultPage = original.CertificateListResultPage
type CertificateProperties = original.CertificateProperties
type CertificateUpdateParameters = original.CertificateUpdateParameters
type CertificateUpdateProperties = original.CertificateUpdateProperties
type Connection = original.Connection
type ConnectionClient = original.ConnectionClient
type ConnectionCreateOrUpdateParameters = original.ConnectionCreateOrUpdateParameters
type ConnectionCreateOrUpdateProperties = original.ConnectionCreateOrUpdateProperties
type ConnectionListResult = original.ConnectionListResult
type ConnectionListResultIterator = original.ConnectionListResultIterator
type ConnectionListResultPage = original.ConnectionListResultPage
type ConnectionProperties = original.ConnectionProperties
type ConnectionType = original.ConnectionType
type ConnectionTypeAssociationProperty = original.ConnectionTypeAssociationProperty
type ConnectionTypeClient = original.ConnectionTypeClient
type ConnectionTypeCreateOrUpdateParameters = original.ConnectionTypeCreateOrUpdateParameters
type ConnectionTypeCreateOrUpdateProperties = original.ConnectionTypeCreateOrUpdateProperties
type ConnectionTypeListResult = original.ConnectionTypeListResult
type ConnectionTypeListResultIterator = original.ConnectionTypeListResultIterator
type ConnectionTypeListResultPage = original.ConnectionTypeListResultPage
type ConnectionTypeProperties = original.ConnectionTypeProperties
type ConnectionUpdateParameters = original.ConnectionUpdateParameters
type ConnectionUpdateProperties = original.ConnectionUpdateProperties
type ContentHash = original.ContentHash
type ContentLink = original.ContentLink
type ContentSource = original.ContentSource
type Credential = original.Credential
type CredentialClient = original.CredentialClient
type CredentialCreateOrUpdateParameters = original.CredentialCreateOrUpdateParameters
type CredentialCreateOrUpdateProperties = original.CredentialCreateOrUpdateProperties
type CredentialListResult = original.CredentialListResult
type CredentialListResultIterator = original.CredentialListResultIterator
type CredentialListResultPage = original.CredentialListResultPage
type CredentialProperties = original.CredentialProperties
type CredentialUpdateParameters = original.CredentialUpdateParameters
type CredentialUpdateProperties = original.CredentialUpdateProperties
type DscCompilationJob = original.DscCompilationJob
type DscCompilationJobClient = original.DscCompilationJobClient
type DscCompilationJobCreateParameters = original.DscCompilationJobCreateParameters
type DscCompilationJobCreateProperties = original.DscCompilationJobCreateProperties
type DscCompilationJobListResult = original.DscCompilationJobListResult
type DscCompilationJobListResultIterator = original.DscCompilationJobListResultIterator
type DscCompilationJobListResultPage = original.DscCompilationJobListResultPage
type DscCompilationJobProperties = original.DscCompilationJobProperties
type DscCompilationJobStreamClient = original.DscCompilationJobStreamClient
type DscConfiguration = original.DscConfiguration
type DscConfigurationAssociationProperty = original.DscConfigurationAssociationProperty
type DscConfigurationClient = original.DscConfigurationClient
type DscConfigurationCreateOrUpdateParameters = original.DscConfigurationCreateOrUpdateParameters
type DscConfigurationCreateOrUpdateProperties = original.DscConfigurationCreateOrUpdateProperties
type DscConfigurationListResult = original.DscConfigurationListResult
type DscConfigurationListResultIterator = original.DscConfigurationListResultIterator
type DscConfigurationListResultPage = original.DscConfigurationListResultPage
type DscConfigurationParameter = original.DscConfigurationParameter
type DscConfigurationProperties = original.DscConfigurationProperties
type DscConfigurationUpdateParameters = original.DscConfigurationUpdateParameters
type DscMetaConfiguration = original.DscMetaConfiguration
type DscNode = original.DscNode
type DscNodeClient = original.DscNodeClient
type DscNodeConfiguration = original.DscNodeConfiguration
type DscNodeConfigurationAssociationProperty = original.DscNodeConfigurationAssociationProperty
type DscNodeConfigurationClient = original.DscNodeConfigurationClient
type DscNodeConfigurationCreateOrUpdateParameters = original.DscNodeConfigurationCreateOrUpdateParameters
type DscNodeConfigurationListResult = original.DscNodeConfigurationListResult
type DscNodeConfigurationListResultIterator = original.DscNodeConfigurationListResultIterator
type DscNodeConfigurationListResultPage = original.DscNodeConfigurationListResultPage
type DscNodeExtensionHandlerAssociationProperty = original.DscNodeExtensionHandlerAssociationProperty
type DscNodeListResult = original.DscNodeListResult
type DscNodeListResultIterator = original.DscNodeListResultIterator
type DscNodeListResultPage = original.DscNodeListResultPage
type DscNodeReport = original.DscNodeReport
type DscNodeReportListResult = original.DscNodeReportListResult
type DscNodeReportListResultIterator = original.DscNodeReportListResultIterator
type DscNodeReportListResultPage = original.DscNodeReportListResultPage
type DscNodeUpdateParameters = original.DscNodeUpdateParameters
type DscReportError = original.DscReportError
type DscReportResource = original.DscReportResource
type DscReportResourceNavigation = original.DscReportResourceNavigation
type ErrorResponse = original.ErrorResponse
type FieldDefinition = original.FieldDefinition
type FieldsClient = original.FieldsClient
type HybridRunbookWorker = original.HybridRunbookWorker
type HybridRunbookWorkerGroup = original.HybridRunbookWorkerGroup
type HybridRunbookWorkerGroupClient = original.HybridRunbookWorkerGroupClient
type HybridRunbookWorkerGroupUpdateParameters = original.HybridRunbookWorkerGroupUpdateParameters
type HybridRunbookWorkerGroupsListResult = original.HybridRunbookWorkerGroupsListResult
type HybridRunbookWorkerGroupsListResultIterator = original.HybridRunbookWorkerGroupsListResultIterator
type HybridRunbookWorkerGroupsListResultPage = original.HybridRunbookWorkerGroupsListResultPage
type Job = original.Job
type JobClient = original.JobClient
type JobCreateParameters = original.JobCreateParameters
type JobCreateProperties = original.JobCreateProperties
type JobListResult = original.JobListResult
type JobListResultIterator = original.JobListResultIterator
type JobListResultPage = original.JobListResultPage
type JobProperties = original.JobProperties
type JobSchedule = original.JobSchedule
type JobScheduleClient = original.JobScheduleClient
type JobScheduleCreateParameters = original.JobScheduleCreateParameters
type JobScheduleCreateProperties = original.JobScheduleCreateProperties
type JobScheduleListResult = original.JobScheduleListResult
type JobScheduleListResultIterator = original.JobScheduleListResultIterator
type JobScheduleListResultPage = original.JobScheduleListResultPage
type JobScheduleProperties = original.JobScheduleProperties
type JobStream = original.JobStream
type JobStreamClient = original.JobStreamClient
type JobStreamListResult = original.JobStreamListResult
type JobStreamListResultIterator = original.JobStreamListResultIterator
type JobStreamListResultPage = original.JobStreamListResultPage
type JobStreamProperties = original.JobStreamProperties
type Key = original.Key
type KeyListResult = original.KeyListResult
type KeysClient = original.KeysClient
type LinkedWorkspace = original.LinkedWorkspace
type LinkedWorkspaceClient = original.LinkedWorkspaceClient
type Module = original.Module
type ModuleClient = original.ModuleClient
type ModuleCreateOrUpdateParameters = original.ModuleCreateOrUpdateParameters
type ModuleCreateOrUpdateProperties = original.ModuleCreateOrUpdateProperties
type ModuleErrorInfo = original.ModuleErrorInfo
type ModuleListResult = original.ModuleListResult
type ModuleListResultIterator = original.ModuleListResultIterator
type ModuleListResultPage = original.ModuleListResultPage
type ModuleProperties = original.ModuleProperties
type ModuleUpdateParameters = original.ModuleUpdateParameters
type ModuleUpdateProperties = original.ModuleUpdateProperties
type NodeReportsClient = original.NodeReportsClient
type ObjectDataTypesClient = original.ObjectDataTypesClient
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type ReadCloser = original.ReadCloser
type Resource = original.Resource
type RunAsCredentialAssociationProperty = original.RunAsCredentialAssociationProperty
type Runbook = original.Runbook
type RunbookAssociationProperty = original.RunbookAssociationProperty
type RunbookClient = original.RunbookClient
type RunbookCreateOrUpdateDraftParameters = original.RunbookCreateOrUpdateDraftParameters
type RunbookCreateOrUpdateDraftProperties = original.RunbookCreateOrUpdateDraftProperties
type RunbookCreateOrUpdateParameters = original.RunbookCreateOrUpdateParameters
type RunbookCreateOrUpdateProperties = original.RunbookCreateOrUpdateProperties
type RunbookDraft = original.RunbookDraft
type RunbookDraftClient = original.RunbookDraftClient
type RunbookDraftPublishFuture = original.RunbookDraftPublishFuture
type RunbookDraftReplaceContentFuture = original.RunbookDraftReplaceContentFuture
type RunbookDraftUndoEditResult = original.RunbookDraftUndoEditResult
type RunbookListResult = original.RunbookListResult
type RunbookListResultIterator = original.RunbookListResultIterator
type RunbookListResultPage = original.RunbookListResultPage
type RunbookParameter = original.RunbookParameter
type RunbookProperties = original.RunbookProperties
type RunbookUpdateParameters = original.RunbookUpdateParameters
type RunbookUpdateProperties = original.RunbookUpdateProperties
type Schedule = original.Schedule
type ScheduleAssociationProperty = original.ScheduleAssociationProperty
type ScheduleClient = original.ScheduleClient
type ScheduleCreateOrUpdateParameters = original.ScheduleCreateOrUpdateParameters
type ScheduleCreateOrUpdateProperties = original.ScheduleCreateOrUpdateProperties
type ScheduleListResult = original.ScheduleListResult
type ScheduleListResultIterator = original.ScheduleListResultIterator
type ScheduleListResultPage = original.ScheduleListResultPage
type ScheduleProperties = original.ScheduleProperties
type ScheduleUpdateParameters = original.ScheduleUpdateParameters
type ScheduleUpdateProperties = original.ScheduleUpdateProperties
type SetObject = original.SetObject
type Sku = original.Sku
type Statistics = original.Statistics
type StatisticsClient = original.StatisticsClient
type StatisticsListResult = original.StatisticsListResult
type String = original.String
type TestJob = original.TestJob
type TestJobClient = original.TestJobClient
type TestJobCreateParameters = original.TestJobCreateParameters
type TestJobStreamsClient = original.TestJobStreamsClient
type TrackedResource = original.TrackedResource
type TypeField = original.TypeField
type TypeFieldListResult = original.TypeFieldListResult
type Usage = original.Usage
type UsageCounterName = original.UsageCounterName
type UsageListResult = original.UsageListResult
type UsagesClient = original.UsagesClient
type Variable = original.Variable
type VariableClient = original.VariableClient
type VariableCreateOrUpdateParameters = original.VariableCreateOrUpdateParameters
type VariableCreateOrUpdateProperties = original.VariableCreateOrUpdateProperties
type VariableListResult = original.VariableListResult
type VariableListResultIterator = original.VariableListResultIterator
type VariableListResultPage = original.VariableListResultPage
type VariableProperties = original.VariableProperties
type VariableUpdateParameters = original.VariableUpdateParameters
type VariableUpdateProperties = original.VariableUpdateProperties
type Webhook = original.Webhook
type WebhookClient = original.WebhookClient
type WebhookCreateOrUpdateParameters = original.WebhookCreateOrUpdateParameters
type WebhookCreateOrUpdateProperties = original.WebhookCreateOrUpdateProperties
type WebhookListResult = original.WebhookListResult
type WebhookListResultIterator = original.WebhookListResultIterator
type WebhookListResultPage = original.WebhookListResultPage
type WebhookProperties = original.WebhookProperties
type WebhookUpdateParameters = original.WebhookUpdateParameters
type WebhookUpdateProperties = original.WebhookUpdateProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountClient(subscriptionID string) AccountClient {
	return original.NewAccountClient(subscriptionID)
}
func NewAccountClientWithBaseURI(baseURI string, subscriptionID string) AccountClient {
	return original.NewAccountClientWithBaseURI(baseURI, subscriptionID)
}
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return original.NewAccountListResultIterator(page)
}
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return original.NewAccountListResultPage(cur, getNextPage)
}
func NewActivityClient(subscriptionID string) ActivityClient {
	return original.NewActivityClient(subscriptionID)
}
func NewActivityClientWithBaseURI(baseURI string, subscriptionID string) ActivityClient {
	return original.NewActivityClientWithBaseURI(baseURI, subscriptionID)
}
func NewActivityListResultIterator(page ActivityListResultPage) ActivityListResultIterator {
	return original.NewActivityListResultIterator(page)
}
func NewActivityListResultPage(cur ActivityListResult, getNextPage func(context.Context, ActivityListResult) (ActivityListResult, error)) ActivityListResultPage {
	return original.NewActivityListResultPage(cur, getNextPage)
}
func NewAgentRegistrationInformationClient(subscriptionID string) AgentRegistrationInformationClient {
	return original.NewAgentRegistrationInformationClient(subscriptionID)
}
func NewAgentRegistrationInformationClientWithBaseURI(baseURI string, subscriptionID string) AgentRegistrationInformationClient {
	return original.NewAgentRegistrationInformationClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificateClient(subscriptionID string) CertificateClient {
	return original.NewCertificateClient(subscriptionID)
}
func NewCertificateClientWithBaseURI(baseURI string, subscriptionID string) CertificateClient {
	return original.NewCertificateClientWithBaseURI(baseURI, subscriptionID)
}
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return original.NewCertificateListResultIterator(page)
}
func NewCertificateListResultPage(cur CertificateListResult, getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return original.NewCertificateListResultPage(cur, getNextPage)
}
func NewConnectionClient(subscriptionID string) ConnectionClient {
	return original.NewConnectionClient(subscriptionID)
}
func NewConnectionClientWithBaseURI(baseURI string, subscriptionID string) ConnectionClient {
	return original.NewConnectionClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionListResultIterator(page ConnectionListResultPage) ConnectionListResultIterator {
	return original.NewConnectionListResultIterator(page)
}
func NewConnectionListResultPage(cur ConnectionListResult, getNextPage func(context.Context, ConnectionListResult) (ConnectionListResult, error)) ConnectionListResultPage {
	return original.NewConnectionListResultPage(cur, getNextPage)
}
func NewConnectionTypeClient(subscriptionID string) ConnectionTypeClient {
	return original.NewConnectionTypeClient(subscriptionID)
}
func NewConnectionTypeClientWithBaseURI(baseURI string, subscriptionID string) ConnectionTypeClient {
	return original.NewConnectionTypeClientWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionTypeListResultIterator(page ConnectionTypeListResultPage) ConnectionTypeListResultIterator {
	return original.NewConnectionTypeListResultIterator(page)
}
func NewConnectionTypeListResultPage(cur ConnectionTypeListResult, getNextPage func(context.Context, ConnectionTypeListResult) (ConnectionTypeListResult, error)) ConnectionTypeListResultPage {
	return original.NewConnectionTypeListResultPage(cur, getNextPage)
}
func NewCredentialClient(subscriptionID string) CredentialClient {
	return original.NewCredentialClient(subscriptionID)
}
func NewCredentialClientWithBaseURI(baseURI string, subscriptionID string) CredentialClient {
	return original.NewCredentialClientWithBaseURI(baseURI, subscriptionID)
}
func NewCredentialListResultIterator(page CredentialListResultPage) CredentialListResultIterator {
	return original.NewCredentialListResultIterator(page)
}
func NewCredentialListResultPage(cur CredentialListResult, getNextPage func(context.Context, CredentialListResult) (CredentialListResult, error)) CredentialListResultPage {
	return original.NewCredentialListResultPage(cur, getNextPage)
}
func NewDscCompilationJobClient(subscriptionID string) DscCompilationJobClient {
	return original.NewDscCompilationJobClient(subscriptionID)
}
func NewDscCompilationJobClientWithBaseURI(baseURI string, subscriptionID string) DscCompilationJobClient {
	return original.NewDscCompilationJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscCompilationJobListResultIterator(page DscCompilationJobListResultPage) DscCompilationJobListResultIterator {
	return original.NewDscCompilationJobListResultIterator(page)
}
func NewDscCompilationJobListResultPage(cur DscCompilationJobListResult, getNextPage func(context.Context, DscCompilationJobListResult) (DscCompilationJobListResult, error)) DscCompilationJobListResultPage {
	return original.NewDscCompilationJobListResultPage(cur, getNextPage)
}
func NewDscCompilationJobStreamClient(subscriptionID string) DscCompilationJobStreamClient {
	return original.NewDscCompilationJobStreamClient(subscriptionID)
}
func NewDscCompilationJobStreamClientWithBaseURI(baseURI string, subscriptionID string) DscCompilationJobStreamClient {
	return original.NewDscCompilationJobStreamClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscConfigurationClient(subscriptionID string) DscConfigurationClient {
	return original.NewDscConfigurationClient(subscriptionID)
}
func NewDscConfigurationClientWithBaseURI(baseURI string, subscriptionID string) DscConfigurationClient {
	return original.NewDscConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscConfigurationListResultIterator(page DscConfigurationListResultPage) DscConfigurationListResultIterator {
	return original.NewDscConfigurationListResultIterator(page)
}
func NewDscConfigurationListResultPage(cur DscConfigurationListResult, getNextPage func(context.Context, DscConfigurationListResult) (DscConfigurationListResult, error)) DscConfigurationListResultPage {
	return original.NewDscConfigurationListResultPage(cur, getNextPage)
}
func NewDscNodeClient(subscriptionID string) DscNodeClient {
	return original.NewDscNodeClient(subscriptionID)
}
func NewDscNodeClientWithBaseURI(baseURI string, subscriptionID string) DscNodeClient {
	return original.NewDscNodeClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscNodeConfigurationClient(subscriptionID string) DscNodeConfigurationClient {
	return original.NewDscNodeConfigurationClient(subscriptionID)
}
func NewDscNodeConfigurationClientWithBaseURI(baseURI string, subscriptionID string) DscNodeConfigurationClient {
	return original.NewDscNodeConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewDscNodeConfigurationListResultIterator(page DscNodeConfigurationListResultPage) DscNodeConfigurationListResultIterator {
	return original.NewDscNodeConfigurationListResultIterator(page)
}
func NewDscNodeConfigurationListResultPage(cur DscNodeConfigurationListResult, getNextPage func(context.Context, DscNodeConfigurationListResult) (DscNodeConfigurationListResult, error)) DscNodeConfigurationListResultPage {
	return original.NewDscNodeConfigurationListResultPage(cur, getNextPage)
}
func NewDscNodeListResultIterator(page DscNodeListResultPage) DscNodeListResultIterator {
	return original.NewDscNodeListResultIterator(page)
}
func NewDscNodeListResultPage(cur DscNodeListResult, getNextPage func(context.Context, DscNodeListResult) (DscNodeListResult, error)) DscNodeListResultPage {
	return original.NewDscNodeListResultPage(cur, getNextPage)
}
func NewDscNodeReportListResultIterator(page DscNodeReportListResultPage) DscNodeReportListResultIterator {
	return original.NewDscNodeReportListResultIterator(page)
}
func NewDscNodeReportListResultPage(cur DscNodeReportListResult, getNextPage func(context.Context, DscNodeReportListResult) (DscNodeReportListResult, error)) DscNodeReportListResultPage {
	return original.NewDscNodeReportListResultPage(cur, getNextPage)
}
func NewFieldsClient(subscriptionID string) FieldsClient {
	return original.NewFieldsClient(subscriptionID)
}
func NewFieldsClientWithBaseURI(baseURI string, subscriptionID string) FieldsClient {
	return original.NewFieldsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHybridRunbookWorkerGroupClient(subscriptionID string) HybridRunbookWorkerGroupClient {
	return original.NewHybridRunbookWorkerGroupClient(subscriptionID)
}
func NewHybridRunbookWorkerGroupClientWithBaseURI(baseURI string, subscriptionID string) HybridRunbookWorkerGroupClient {
	return original.NewHybridRunbookWorkerGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewHybridRunbookWorkerGroupsListResultIterator(page HybridRunbookWorkerGroupsListResultPage) HybridRunbookWorkerGroupsListResultIterator {
	return original.NewHybridRunbookWorkerGroupsListResultIterator(page)
}
func NewHybridRunbookWorkerGroupsListResultPage(cur HybridRunbookWorkerGroupsListResult, getNextPage func(context.Context, HybridRunbookWorkerGroupsListResult) (HybridRunbookWorkerGroupsListResult, error)) HybridRunbookWorkerGroupsListResultPage {
	return original.NewHybridRunbookWorkerGroupsListResultPage(cur, getNextPage)
}
func NewJobClient(subscriptionID string) JobClient {
	return original.NewJobClient(subscriptionID)
}
func NewJobClientWithBaseURI(baseURI string, subscriptionID string) JobClient {
	return original.NewJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return original.NewJobListResultIterator(page)
}
func NewJobListResultPage(cur JobListResult, getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return original.NewJobListResultPage(cur, getNextPage)
}
func NewJobScheduleClient(subscriptionID string) JobScheduleClient {
	return original.NewJobScheduleClient(subscriptionID)
}
func NewJobScheduleClientWithBaseURI(baseURI string, subscriptionID string) JobScheduleClient {
	return original.NewJobScheduleClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobScheduleListResultIterator(page JobScheduleListResultPage) JobScheduleListResultIterator {
	return original.NewJobScheduleListResultIterator(page)
}
func NewJobScheduleListResultPage(cur JobScheduleListResult, getNextPage func(context.Context, JobScheduleListResult) (JobScheduleListResult, error)) JobScheduleListResultPage {
	return original.NewJobScheduleListResultPage(cur, getNextPage)
}
func NewJobStreamClient(subscriptionID string) JobStreamClient {
	return original.NewJobStreamClient(subscriptionID)
}
func NewJobStreamClientWithBaseURI(baseURI string, subscriptionID string) JobStreamClient {
	return original.NewJobStreamClientWithBaseURI(baseURI, subscriptionID)
}
func NewJobStreamListResultIterator(page JobStreamListResultPage) JobStreamListResultIterator {
	return original.NewJobStreamListResultIterator(page)
}
func NewJobStreamListResultPage(cur JobStreamListResult, getNextPage func(context.Context, JobStreamListResult) (JobStreamListResult, error)) JobStreamListResultPage {
	return original.NewJobStreamListResultPage(cur, getNextPage)
}
func NewKeysClient(subscriptionID string) KeysClient {
	return original.NewKeysClient(subscriptionID)
}
func NewKeysClientWithBaseURI(baseURI string, subscriptionID string) KeysClient {
	return original.NewKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewLinkedWorkspaceClient(subscriptionID string) LinkedWorkspaceClient {
	return original.NewLinkedWorkspaceClient(subscriptionID)
}
func NewLinkedWorkspaceClientWithBaseURI(baseURI string, subscriptionID string) LinkedWorkspaceClient {
	return original.NewLinkedWorkspaceClientWithBaseURI(baseURI, subscriptionID)
}
func NewModuleClient(subscriptionID string) ModuleClient {
	return original.NewModuleClient(subscriptionID)
}
func NewModuleClientWithBaseURI(baseURI string, subscriptionID string) ModuleClient {
	return original.NewModuleClientWithBaseURI(baseURI, subscriptionID)
}
func NewModuleListResultIterator(page ModuleListResultPage) ModuleListResultIterator {
	return original.NewModuleListResultIterator(page)
}
func NewModuleListResultPage(cur ModuleListResult, getNextPage func(context.Context, ModuleListResult) (ModuleListResult, error)) ModuleListResultPage {
	return original.NewModuleListResultPage(cur, getNextPage)
}
func NewNodeReportsClient(subscriptionID string) NodeReportsClient {
	return original.NewNodeReportsClient(subscriptionID)
}
func NewNodeReportsClientWithBaseURI(baseURI string, subscriptionID string) NodeReportsClient {
	return original.NewNodeReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewObjectDataTypesClient(subscriptionID string) ObjectDataTypesClient {
	return original.NewObjectDataTypesClient(subscriptionID)
}
func NewObjectDataTypesClientWithBaseURI(baseURI string, subscriptionID string) ObjectDataTypesClient {
	return original.NewObjectDataTypesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunbookClient(subscriptionID string) RunbookClient {
	return original.NewRunbookClient(subscriptionID)
}
func NewRunbookClientWithBaseURI(baseURI string, subscriptionID string) RunbookClient {
	return original.NewRunbookClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunbookDraftClient(subscriptionID string) RunbookDraftClient {
	return original.NewRunbookDraftClient(subscriptionID)
}
func NewRunbookDraftClientWithBaseURI(baseURI string, subscriptionID string) RunbookDraftClient {
	return original.NewRunbookDraftClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunbookListResultIterator(page RunbookListResultPage) RunbookListResultIterator {
	return original.NewRunbookListResultIterator(page)
}
func NewRunbookListResultPage(cur RunbookListResult, getNextPage func(context.Context, RunbookListResult) (RunbookListResult, error)) RunbookListResultPage {
	return original.NewRunbookListResultPage(cur, getNextPage)
}
func NewScheduleClient(subscriptionID string) ScheduleClient {
	return original.NewScheduleClient(subscriptionID)
}
func NewScheduleClientWithBaseURI(baseURI string, subscriptionID string) ScheduleClient {
	return original.NewScheduleClientWithBaseURI(baseURI, subscriptionID)
}
func NewScheduleListResultIterator(page ScheduleListResultPage) ScheduleListResultIterator {
	return original.NewScheduleListResultIterator(page)
}
func NewScheduleListResultPage(cur ScheduleListResult, getNextPage func(context.Context, ScheduleListResult) (ScheduleListResult, error)) ScheduleListResultPage {
	return original.NewScheduleListResultPage(cur, getNextPage)
}
func NewStatisticsClient(subscriptionID string) StatisticsClient {
	return original.NewStatisticsClient(subscriptionID)
}
func NewStatisticsClientWithBaseURI(baseURI string, subscriptionID string) StatisticsClient {
	return original.NewStatisticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTestJobClient(subscriptionID string) TestJobClient {
	return original.NewTestJobClient(subscriptionID)
}
func NewTestJobClientWithBaseURI(baseURI string, subscriptionID string) TestJobClient {
	return original.NewTestJobClientWithBaseURI(baseURI, subscriptionID)
}
func NewTestJobStreamsClient(subscriptionID string) TestJobStreamsClient {
	return original.NewTestJobStreamsClient(subscriptionID)
}
func NewTestJobStreamsClientWithBaseURI(baseURI string, subscriptionID string) TestJobStreamsClient {
	return original.NewTestJobStreamsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVariableClient(subscriptionID string) VariableClient {
	return original.NewVariableClient(subscriptionID)
}
func NewVariableClientWithBaseURI(baseURI string, subscriptionID string) VariableClient {
	return original.NewVariableClientWithBaseURI(baseURI, subscriptionID)
}
func NewVariableListResultIterator(page VariableListResultPage) VariableListResultIterator {
	return original.NewVariableListResultIterator(page)
}
func NewVariableListResultPage(cur VariableListResult, getNextPage func(context.Context, VariableListResult) (VariableListResult, error)) VariableListResultPage {
	return original.NewVariableListResultPage(cur, getNextPage)
}
func NewWebhookClient(subscriptionID string) WebhookClient {
	return original.NewWebhookClient(subscriptionID)
}
func NewWebhookClientWithBaseURI(baseURI string, subscriptionID string) WebhookClient {
	return original.NewWebhookClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return original.NewWebhookListResultIterator(page)
}
func NewWebhookListResultPage(cur WebhookListResult, getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return original.NewWebhookListResultPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccountStateValues() []AccountState {
	return original.PossibleAccountStateValues()
}
func PossibleAgentRegistrationKeyNameValues() []AgentRegistrationKeyName {
	return original.PossibleAgentRegistrationKeyNameValues()
}
func PossibleContentSourceTypeValues() []ContentSourceType {
	return original.PossibleContentSourceTypeValues()
}
func PossibleDscConfigurationProvisioningStateValues() []DscConfigurationProvisioningState {
	return original.PossibleDscConfigurationProvisioningStateValues()
}
func PossibleDscConfigurationStateValues() []DscConfigurationState {
	return original.PossibleDscConfigurationStateValues()
}
func PossibleGroupTypeEnumValues() []GroupTypeEnum {
	return original.PossibleGroupTypeEnumValues()
}
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return original.PossibleHTTPStatusCodeValues()
}
func PossibleJobProvisioningStateValues() []JobProvisioningState {
	return original.PossibleJobProvisioningStateValues()
}
func PossibleJobStatusValues() []JobStatus {
	return original.PossibleJobStatusValues()
}
func PossibleJobStreamTypeValues() []JobStreamType {
	return original.PossibleJobStreamTypeValues()
}
func PossibleKeyNameValues() []KeyName {
	return original.PossibleKeyNameValues()
}
func PossibleKeyPermissionsValues() []KeyPermissions {
	return original.PossibleKeyPermissionsValues()
}
func PossibleModuleProvisioningStateValues() []ModuleProvisioningState {
	return original.PossibleModuleProvisioningStateValues()
}
func PossibleRunbookProvisioningStateValues() []RunbookProvisioningState {
	return original.PossibleRunbookProvisioningStateValues()
}
func PossibleRunbookStateValues() []RunbookState {
	return original.PossibleRunbookStateValues()
}
func PossibleRunbookTypeEnumValues() []RunbookTypeEnum {
	return original.PossibleRunbookTypeEnumValues()
}
func PossibleScheduleDayValues() []ScheduleDay {
	return original.PossibleScheduleDayValues()
}
func PossibleScheduleFrequencyValues() []ScheduleFrequency {
	return original.PossibleScheduleFrequencyValues()
}
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return original.PossibleSkuNameEnumValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
