/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha3

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
	v1alpha2 "sigs.k8s.io/gateway-api/apis/applyconfiguration/apis/v1alpha2"

	internal "sigs.k8s.io/gateway-api/apis/applyconfiguration/internal"
	apisv1alpha3 "sigs.k8s.io/gateway-api/apis/v1alpha3"
)

// BackendTLSPolicyApplyConfiguration represents an declarative configuration of the BackendTLSPolicy type for use
// with apply.
type BackendTLSPolicyApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Spec                             *BackendTLSPolicySpecApplyConfiguration  `json:"spec,omitempty"`
	Status                           *v1alpha2.PolicyStatusApplyConfiguration `json:"status,omitempty"`
}

// BackendTLSPolicy constructs an declarative configuration of the BackendTLSPolicy type for use with
// apply.
func BackendTLSPolicy(name, namespace string) *BackendTLSPolicyApplyConfiguration {
	b := &BackendTLSPolicyApplyConfiguration{}
	b.WithName(name)
	b.WithNamespace(namespace)
	b.WithKind("BackendTLSPolicy")
	b.WithAPIVersion("gateway.networking.k8s.io/v1alpha3")
	return b
}

// ExtractBackendTLSPolicy extracts the applied configuration owned by fieldManager from
// backendTLSPolicy. If no managedFields are found in backendTLSPolicy for fieldManager, a
// BackendTLSPolicyApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// backendTLSPolicy must be a unmodified BackendTLSPolicy API object that was retrieved from the Kubernetes API.
// ExtractBackendTLSPolicy provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractBackendTLSPolicy(backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, fieldManager string) (*BackendTLSPolicyApplyConfiguration, error) {
	return extractBackendTLSPolicy(backendTLSPolicy, fieldManager, "")
}

// ExtractBackendTLSPolicyStatus is the same as ExtractBackendTLSPolicy except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractBackendTLSPolicyStatus(backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, fieldManager string) (*BackendTLSPolicyApplyConfiguration, error) {
	return extractBackendTLSPolicy(backendTLSPolicy, fieldManager, "status")
}

func extractBackendTLSPolicy(backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, fieldManager string, subresource string) (*BackendTLSPolicyApplyConfiguration, error) {
	b := &BackendTLSPolicyApplyConfiguration{}
	err := managedfields.ExtractInto(backendTLSPolicy, internal.Parser().Type("io.k8s.sigs.gateway-api.apis.v1alpha3.BackendTLSPolicy"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(backendTLSPolicy.Name)
	b.WithNamespace(backendTLSPolicy.Namespace)

	b.WithKind("BackendTLSPolicy")
	b.WithAPIVersion("gateway.networking.k8s.io/v1alpha3")
	return b, nil
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithKind(value string) *BackendTLSPolicyApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithAPIVersion(value string) *BackendTLSPolicyApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithName(value string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithGenerateName(value string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithNamespace(value string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithUID(value types.UID) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithResourceVersion(value string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithGeneration(value int64) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithCreationTimestamp(value metav1.Time) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *BackendTLSPolicyApplyConfiguration) WithLabels(entries map[string]string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *BackendTLSPolicyApplyConfiguration) WithAnnotations(entries map[string]string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *BackendTLSPolicyApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.OwnerReferences = append(b.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *BackendTLSPolicyApplyConfiguration) WithFinalizers(values ...string) *BackendTLSPolicyApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.Finalizers = append(b.Finalizers, values[i])
	}
	return b
}

func (b *BackendTLSPolicyApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithSpec sets the Spec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spec field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithSpec(value *BackendTLSPolicySpecApplyConfiguration) *BackendTLSPolicyApplyConfiguration {
	b.Spec = value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *BackendTLSPolicyApplyConfiguration) WithStatus(value *v1alpha2.PolicyStatusApplyConfiguration) *BackendTLSPolicyApplyConfiguration {
	b.Status = value
	return b
}
