// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/conversation_dataset.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConversationDatasets_CreateConversationDataset_FullMethodName = "/google.cloud.dialogflow.v2.ConversationDatasets/CreateConversationDataset"
	ConversationDatasets_GetConversationDataset_FullMethodName    = "/google.cloud.dialogflow.v2.ConversationDatasets/GetConversationDataset"
	ConversationDatasets_ListConversationDatasets_FullMethodName  = "/google.cloud.dialogflow.v2.ConversationDatasets/ListConversationDatasets"
	ConversationDatasets_DeleteConversationDataset_FullMethodName = "/google.cloud.dialogflow.v2.ConversationDatasets/DeleteConversationDataset"
	ConversationDatasets_ImportConversationData_FullMethodName    = "/google.cloud.dialogflow.v2.ConversationDatasets/ImportConversationData"
)

// ConversationDatasetsClient is the client API for ConversationDatasets service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationDatasetsClient interface {
	// Creates a new conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
	// - `response`:
	// [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
	CreateConversationDataset(ctx context.Context, in *CreateConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves the specified conversation dataset.
	GetConversationDataset(ctx context.Context, in *GetConversationDatasetRequest, opts ...grpc.CallOption) (*ConversationDataset, error)
	// Returns the list of all conversation datasets in the specified
	// project and location.
	ListConversationDatasets(ctx context.Context, in *ListConversationDatasetsRequest, opts ...grpc.CallOption) (*ListConversationDatasetsResponse, error)
	// Deletes the specified conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationDataset(ctx context.Context, in *DeleteConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Import data into the specified conversation dataset. Note that it
	// is not allowed to import data to a conversation dataset that
	// already has data in it.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
	// - `response`:
	// [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
	ImportConversationData(ctx context.Context, in *ImportConversationDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationDatasetsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationDatasetsClient(cc grpc.ClientConnInterface) ConversationDatasetsClient {
	return &conversationDatasetsClient{cc}
}

func (c *conversationDatasetsClient) CreateConversationDataset(ctx context.Context, in *CreateConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationDatasets_CreateConversationDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) GetConversationDataset(ctx context.Context, in *GetConversationDatasetRequest, opts ...grpc.CallOption) (*ConversationDataset, error) {
	out := new(ConversationDataset)
	err := c.cc.Invoke(ctx, ConversationDatasets_GetConversationDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) ListConversationDatasets(ctx context.Context, in *ListConversationDatasetsRequest, opts ...grpc.CallOption) (*ListConversationDatasetsResponse, error) {
	out := new(ListConversationDatasetsResponse)
	err := c.cc.Invoke(ctx, ConversationDatasets_ListConversationDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) DeleteConversationDataset(ctx context.Context, in *DeleteConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationDatasets_DeleteConversationDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) ImportConversationData(ctx context.Context, in *ImportConversationDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationDatasets_ImportConversationData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationDatasetsServer is the server API for ConversationDatasets service.
// All implementations should embed UnimplementedConversationDatasetsServer
// for forward compatibility
type ConversationDatasetsServer interface {
	// Creates a new conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
	// - `response`:
	// [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
	CreateConversationDataset(context.Context, *CreateConversationDatasetRequest) (*longrunningpb.Operation, error)
	// Retrieves the specified conversation dataset.
	GetConversationDataset(context.Context, *GetConversationDatasetRequest) (*ConversationDataset, error)
	// Returns the list of all conversation datasets in the specified
	// project and location.
	ListConversationDatasets(context.Context, *ListConversationDatasetsRequest) (*ListConversationDatasetsResponse, error)
	// Deletes the specified conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationDataset(context.Context, *DeleteConversationDatasetRequest) (*longrunningpb.Operation, error)
	// Import data into the specified conversation dataset. Note that it
	// is not allowed to import data to a conversation dataset that
	// already has data in it.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
	// - `response`:
	// [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
	ImportConversationData(context.Context, *ImportConversationDataRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationDatasetsServer should be embedded to have forward compatible implementations.
type UnimplementedConversationDatasetsServer struct {
}

func (UnimplementedConversationDatasetsServer) CreateConversationDataset(context.Context, *CreateConversationDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationDataset not implemented")
}
func (UnimplementedConversationDatasetsServer) GetConversationDataset(context.Context, *GetConversationDatasetRequest) (*ConversationDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationDataset not implemented")
}
func (UnimplementedConversationDatasetsServer) ListConversationDatasets(context.Context, *ListConversationDatasetsRequest) (*ListConversationDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationDatasets not implemented")
}
func (UnimplementedConversationDatasetsServer) DeleteConversationDataset(context.Context, *DeleteConversationDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversationDataset not implemented")
}
func (UnimplementedConversationDatasetsServer) ImportConversationData(context.Context, *ImportConversationDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportConversationData not implemented")
}

// UnsafeConversationDatasetsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationDatasetsServer will
// result in compilation errors.
type UnsafeConversationDatasetsServer interface {
	mustEmbedUnimplementedConversationDatasetsServer()
}

func RegisterConversationDatasetsServer(s grpc.ServiceRegistrar, srv ConversationDatasetsServer) {
	s.RegisterService(&ConversationDatasets_ServiceDesc, srv)
}

func _ConversationDatasets_CreateConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).CreateConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationDatasets_CreateConversationDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).CreateConversationDataset(ctx, req.(*CreateConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_GetConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).GetConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationDatasets_GetConversationDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).GetConversationDataset(ctx, req.(*GetConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_ListConversationDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).ListConversationDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationDatasets_ListConversationDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).ListConversationDatasets(ctx, req.(*ListConversationDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_DeleteConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).DeleteConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationDatasets_DeleteConversationDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).DeleteConversationDataset(ctx, req.(*DeleteConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_ImportConversationData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportConversationDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).ImportConversationData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationDatasets_ImportConversationData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).ImportConversationData(ctx, req.(*ImportConversationDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConversationDatasets_ServiceDesc is the grpc.ServiceDesc for ConversationDatasets service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConversationDatasets_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.ConversationDatasets",
	HandlerType: (*ConversationDatasetsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversationDataset",
			Handler:    _ConversationDatasets_CreateConversationDataset_Handler,
		},
		{
			MethodName: "GetConversationDataset",
			Handler:    _ConversationDatasets_GetConversationDataset_Handler,
		},
		{
			MethodName: "ListConversationDatasets",
			Handler:    _ConversationDatasets_ListConversationDatasets_Handler,
		},
		{
			MethodName: "DeleteConversationDataset",
			Handler:    _ConversationDatasets_DeleteConversationDataset_Handler,
		},
		{
			MethodName: "ImportConversationData",
			Handler:    _ConversationDatasets_ImportConversationData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation_dataset.proto",
}
