// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestMetric_MoveTo(t *testing.T) {
	ms := generateTestMetric()
	dest := NewMetric()
	ms.MoveTo(dest)
	assert.Equal(t, NewMetric(), ms)
	assert.Equal(t, generateTestMetric(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestMetric(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newMetric(internal.NewMetric(), sharedState)) })
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).MoveTo(dest) })
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	orig := NewMetric()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestMetric()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newMetric(internal.NewMetric(), sharedState)) })
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.Empty(t, ms.Name())
	ms.SetName("test_name")
	assert.Equal(t, "test_name", ms.Name())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetName("test_name") })
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.Empty(t, ms.Description())
	ms.SetDescription("test_description")
	assert.Equal(t, "test_description", ms.Description())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetDescription("test_description") })
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.Empty(t, ms.Unit())
	ms.SetUnit("test_unit")
	assert.Equal(t, "test_unit", ms.Unit())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetUnit("test_unit") })
}

func TestMetric_Type(t *testing.T) {
	tv := NewMetric()
	assert.Equal(t, MetricTypeEmpty, tv.Type())
}

func TestMetric_Gauge(t *testing.T) {
	ms := NewMetric()
	ms.SetEmptyGauge()
	assert.Equal(t, NewGauge(), ms.Gauge())
	ms.orig.GetData().(*internal.Metric_Gauge).Gauge = internal.GenTestGauge()
	assert.Equal(t, MetricTypeGauge, ms.Type())
	assert.Equal(t, generateTestGauge(), ms.Gauge())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetEmptyGauge() })
}

func TestMetric_Sum(t *testing.T) {
	ms := NewMetric()
	ms.SetEmptySum()
	assert.Equal(t, NewSum(), ms.Sum())
	ms.orig.GetData().(*internal.Metric_Sum).Sum = internal.GenTestSum()
	assert.Equal(t, MetricTypeSum, ms.Type())
	assert.Equal(t, generateTestSum(), ms.Sum())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetEmptySum() })
}

func TestMetric_Histogram(t *testing.T) {
	ms := NewMetric()
	ms.SetEmptyHistogram()
	assert.Equal(t, NewHistogram(), ms.Histogram())
	ms.orig.GetData().(*internal.Metric_Histogram).Histogram = internal.GenTestHistogram()
	assert.Equal(t, MetricTypeHistogram, ms.Type())
	assert.Equal(t, generateTestHistogram(), ms.Histogram())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetEmptyHistogram() })
}

func TestMetric_ExponentialHistogram(t *testing.T) {
	ms := NewMetric()
	ms.SetEmptyExponentialHistogram()
	assert.Equal(t, NewExponentialHistogram(), ms.ExponentialHistogram())
	ms.orig.GetData().(*internal.Metric_ExponentialHistogram).ExponentialHistogram = internal.GenTestExponentialHistogram()
	assert.Equal(t, MetricTypeExponentialHistogram, ms.Type())
	assert.Equal(t, generateTestExponentialHistogram(), ms.ExponentialHistogram())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetEmptyExponentialHistogram() })
}

func TestMetric_Summary(t *testing.T) {
	ms := NewMetric()
	ms.SetEmptySummary()
	assert.Equal(t, NewSummary(), ms.Summary())
	ms.orig.GetData().(*internal.Metric_Summary).Summary = internal.GenTestSummary()
	assert.Equal(t, MetricTypeSummary, ms.Type())
	assert.Equal(t, generateTestSummary(), ms.Summary())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newMetric(internal.NewMetric(), sharedState).SetEmptySummary() })
}

func TestMetric_Metadata(t *testing.T) {
	ms := NewMetric()
	assert.Equal(t, pcommon.NewMap(), ms.Metadata())
	ms.orig.Metadata = internal.GenTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenTestMapWrapper()), ms.Metadata())
}

func generateTestMetric() Metric {
	return newMetric(internal.GenTestMetric(), internal.NewState())
}
